-------------------------------------------------------------------------------
-- Copyright (c) 1995/2004 Xilinx, Inc.
-- All Right Reserved.
-------------------------------------------------------------------------------
--   ____  ____
--  /   /\/   /
-- /___/  \  /    Vendor : Xilinx
-- \   \   \/     Version : 11.1
--  \   \         Description : Xilinx Timing Simulation Library Component
--  /   /                  18X18 Signed Multiplier Followed by Three-Input Adder plus ALU with Pipeline Registers
-- /___/   /\     Filename : X_DSP48E.vhd
-- \   \  /  \    Timestamp : Mon Mar 28 22:50:04 PST 2005
--  \___\/\___\
--
-- Revision:
--    03/28/05 - Initial version.
--    05/26/05 - BTrack 191 mult not valid in TWO24/FOUR12/USE_MULT=NONE.
--    06/16/05 - Added MULTSIGNIN/OUT pins and functionality
--    09/29/05 - Made xyz muxes to be sensitive to carryinsel when recovering from invalid opmode/carryinsel
--    10/05/05 - Added more valid DRC check entries.
--    10/25/05 - CR 219047
--    11/03/05 - Added two DRC checks -- ARITHMETIC and LOGIC
--    11/07/05 - 'X'ed out carrycascout in LOGIC modes (like the carryout)
--    11/21/05 - 'X'ed out pattern detect signals when in illegal opmodes.
--    02/28/06 - CR 225886 -- USE_MULT check updates. 
--    02/28/06 - CR 226267 -- Changed USE_MULT default to MULT_S.
--    05/20/06 - CR 230656 -- Disabled RSTP timing check during GSR.
--    05/29/06 - CR 232187 -- Corrected multcarryinreg CASE statement 
--    05/29/06 - CR 232275 -- Corrected PREG/multsignout_o_mux
--    10/29/06 - CR 424959 -- Corrected simprim false violation warnings
--    12/10/06 - CR 429825 -- Added Timing Checks for CARRYCASCIN.
--    02/20/07 - CR 434192 -- Fixed RSTALUMODE issue
--    06/11/07 - Added SIM_MODE -- FAST/SAFE feature
--    06/29/07 - CR 438456 -- Added DRC to output X when USE_MULT=MULT_S is set and not using the multiplier opmode through muxX 
--    08/06/07 - CR 445673 -- Fixed CARRYCASCOUT registered mode issue
--    10/01/07 - CR 448147 -- Fixed error introduced by 438456
--    10/10/07 - CR 451453 -- DRC warning
--    10/15/07 - CR 444150 -- DRC check enhancements for OPMODEREG/CARRYINSELREG 
--    11/06/07 - CR 451178 -- DRC warning enhancement
--    02/06/08 - CR 455601 -- DRC relax for OPMODEREG/CARRYINSELREG
--    04/07/08 - CR 469973 -- Header Description fix
--    05/27/08 - CR 472154 -- Removed Vital GSR constructs
--    10/23/08 - CR 491227 -- Fixed multsignout_o_reg
--    12/03/08 - CR 497513 -- Fixed macc ext mode
--    01/08/09 - CR 501854 -- Fixed invalid pdet comparison when there is a X in pattern.
-- End Revision
----- CELL X_DSP48E -----

library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.STD_LOGIC_SIGNED.all;
use IEEE.STD_LOGIC_ARITH.all;

library STD;
use STD.TEXTIO.all;


library IEEE;
use IEEE.VITAL_Timing.all;

library simprim;
use simprim.Vcomponents.all;
use simprim.VPACKAGE.all;

entity X_DSP48E is

  generic(

        TimingChecksOn  : boolean       := true;
        InstancePath    : string        := "*";
        Xon             : boolean       := true;
        MsgOn           : boolean       := true;
    	LOC		: string	:= "UNPLACED";

----- VITAL input wire delays
        tipd_A          : VitalDelayArrayType01 (29 downto 0) := (others => (0 ps, 0 ps));
        tipd_ACIN       : VitalDelayArrayType01 (29 downto 0) := (others => (0 ps, 0 ps));
        tipd_ALUMODE    : VitalDelayArrayType01 (3 downto 0)  := (others => (0 ps, 0 ps));
        tipd_B          : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
        tipd_BCIN       : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
        tipd_C          : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
        tipd_CARRYCASCIN : VitalDelayType01 := ( 0 ps,  0 ps);
        tipd_CARRYIN    : VitalDelayType01 := ( 0 ps,  0 ps);
        tipd_CARRYINSEL : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
        tipd_CEA1       : VitalDelayType01 := ( 0 ps,  0 ps);
        tipd_CEA2       : VitalDelayType01 := ( 0 ps,  0 ps);
        tipd_CEALUMODE  : VitalDelayType01 := ( 0 ps,  0 ps);
        tipd_CEB1       : VitalDelayType01 := ( 0 ps,  0 ps);
        tipd_CEB2       : VitalDelayType01 := ( 0 ps,  0 ps);
        tipd_CEC        : VitalDelayType01 := ( 0 ps,  0 ps);
        tipd_CECARRYIN  : VitalDelayType01 := ( 0 ps,  0 ps);
        tipd_CECTRL     : VitalDelayType01 := ( 0 ps,  0 ps);
        tipd_CEMULTCARRYIN   : VitalDelayType01 := ( 0 ps,  0 ps);
        tipd_CEM        : VitalDelayType01 := ( 0 ps,  0 ps);
        tipd_CEP        : VitalDelayType01 := ( 0 ps,  0 ps);
        tipd_CLK        : VitalDelayType01 := ( 0 ps,  0 ps);
        tipd_MULTSIGNIN : VitalDelayType01 := ( 0 ps,  0 ps);
        tipd_OPMODE     : VitalDelayArrayType01 (6 downto 0) := (others => (0 ps, 0 ps));
        tipd_PCIN       : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
        tipd_RSTA       : VitalDelayType01 := ( 0 ps,  0 ps);
        tipd_RSTALUMODE : VitalDelayType01 := ( 0 ps,  0 ps);
        tipd_RSTB       : VitalDelayType01 := ( 0 ps,  0 ps);
        tipd_RSTC       : VitalDelayType01 := ( 0 ps,  0 ps);
        tipd_RSTALLCARRYIN : VitalDelayType01 := ( 0 ps,  0 ps);
        tipd_RSTCTRL    : VitalDelayType01 := ( 0 ps,  0 ps);
        tipd_RSTM       : VitalDelayType01 := ( 0 ps,  0 ps);
        tipd_RSTP       : VitalDelayType01 := ( 0 ps,  0 ps);

----- VITAL pin-to-pin propagation delays

        tpd_A_ACOUT     : VitalDelayArrayType01 (899 downto 0)  := (others => (0 ps, 0 ps));
        tpd_A_CARRYOUT  : VitalDelayArrayType01 (119 downto 0)   := (others => (0 ps, 0 ps));
        tpd_A_CARRYCASCOUT  : VitalDelayArrayType01 (29 downto 0)   := (others => (0 ps, 0 ps));
        tpd_A_MULTSIGNOUT  : VitalDelayArrayType01 (29 downto 0)   := (others => (0 ps, 0 ps));
        tpd_A_OVERFLOW  : VitalDelayArrayType01 (29 downto 0)   := (others => (0 ps, 0 ps));
        tpd_A_P         : VitalDelayArrayType01 (1439 downto 0) := (others => (0 ps, 0 ps));
        tpd_A_PATTERNBDETECT : VitalDelayArrayType01 (29 downto 0)   := (others => (0 ps, 0 ps));
        tpd_A_PATTERNDETECT  : VitalDelayArrayType01 (29 downto 0)   := (others => (0 ps, 0 ps));
        tpd_A_PCOUT     : VitalDelayArrayType01 (1439 downto 0) := (others => (0 ps, 0 ps));
        tpd_A_UNDERFLOW : VitalDelayArrayType01 (29 downto 0)   := (others => (0 ps, 0 ps));

        tpd_ACIN_ACOUT  : VitalDelayArrayType01 (899 downto 0)  := (others => (0 ps, 0 ps));
        tpd_ACIN_CARRYOUT  : VitalDelayArrayType01 (119 downto 0)   := (others => (0 ps, 0 ps));
        tpd_ACIN_CARRYCASCOUT  : VitalDelayArrayType01 (29 downto 0)   := (others => (0 ps, 0 ps));
        tpd_ACIN_MULTSIGNOUT  : VitalDelayArrayType01 (29 downto 0)   := (others => (0 ps, 0 ps));
        tpd_ACIN_OVERFLOW  : VitalDelayArrayType01 (29 downto 0)   := (others => (0 ps, 0 ps));
        tpd_ACIN_P      : VitalDelayArrayType01 (1439 downto 0)  := (others => (0 ps, 0 ps));
        tpd_ACIN_PATTERNBDETECT : VitalDelayArrayType01 (29 downto 0)   := (others => (0 ps, 0 ps));
        tpd_ACIN_PATTERNDETECT  : VitalDelayArrayType01 (29 downto 0)   := (others => (0 ps, 0 ps));
        tpd_ACIN_PCOUT  : VitalDelayArrayType01 (1439 downto 0)  := (others => (0 ps, 0 ps));
        tpd_ACIN_UNDERFLOW : VitalDelayArrayType01 (29 downto 0)   := (others => (0 ps, 0 ps));

        tpd_ALUMODE_ACOUT  : VitalDelayArrayType01 (119 downto 0)  := (others => (0 ps, 0 ps));
        tpd_ALUMODE_CARRYOUT  : VitalDelayArrayType01 (15 downto 0)   := (others => (0 ps, 0 ps));
        tpd_ALUMODE_CARRYCASCOUT  : VitalDelayArrayType01 (3 downto 0)   := (others => (0 ps, 0 ps));
        tpd_ALUMODE_MULTSIGNOUT  : VitalDelayArrayType01 (3 downto 0)   := (others => (0 ps, 0 ps));
        tpd_ALUMODE_OVERFLOW  : VitalDelayArrayType01 (3 downto 0)   := (others => (0 ps, 0 ps));
        tpd_ALUMODE_P      : VitalDelayArrayType01 (191 downto 0)  := (others => (0 ps, 0 ps));
        tpd_ALUMODE_PATTERNBDETECT : VitalDelayArrayType01 (3 downto 0)   := (others => (0 ps, 0 ps));
        tpd_ALUMODE_PATTERNDETECT  : VitalDelayArrayType01 (3 downto 0)   := (others => (0 ps, 0 ps));
        tpd_ALUMODE_PCOUT  : VitalDelayArrayType01 (191 downto 0)  := (others => (0 ps, 0 ps));
        tpd_ALUMODE_UNDERFLOW : VitalDelayArrayType01 (3 downto 0)   := (others => (0 ps, 0 ps));

        tpd_B_BCOUT     : VitalDelayArrayType01 (323 downto 0)  := (others => (0 ps, 0 ps));
        tpd_B_CARRYOUT  : VitalDelayArrayType01 (71 downto 0)   := (others => (0 ps, 0 ps));
        tpd_B_CARRYCASCOUT  : VitalDelayArrayType01 (17 downto 0)   := (others => (0 ps, 0 ps));
        tpd_B_MULTSIGNOUT  : VitalDelayArrayType01 (17 downto 0)   := (others => (0 ps, 0 ps));
        tpd_B_OVERFLOW  : VitalDelayArrayType01 (17 downto 0)   := (others => (0 ps, 0 ps));
        tpd_B_P         : VitalDelayArrayType01 (863 downto 0)  := (others => (0 ps, 0 ps));
        tpd_B_PATTERNBDETECT : VitalDelayArrayType01 (17 downto 0)   := (others => (0 ps, 0 ps));
        tpd_B_PATTERNDETECT  : VitalDelayArrayType01 (17 downto 0)   := (others => (0 ps, 0 ps));
        tpd_B_PCOUT     : VitalDelayArrayType01 (863 downto 0)  := (others => (0 ps, 0 ps));
        tpd_B_UNDERFLOW  : VitalDelayArrayType01 (17 downto 0)   := (others => (0 ps, 0 ps));

        tpd_BCIN_BCOUT  : VitalDelayArrayType01 (323 downto 0)  := (others => (0 ps, 0 ps));
        tpd_BCIN_CARRYOUT  : VitalDelayArrayType01 (71 downto 0)   := (others => (0 ps, 0 ps));
        tpd_BCIN_CARRYCASCOUT  : VitalDelayArrayType01 (17 downto 0)   := (others => (0 ps, 0 ps));
        tpd_BCIN_MULTSIGNOUT  : VitalDelayArrayType01 (17 downto 0)   := (others => (0 ps, 0 ps));
        tpd_BCIN_OVERFLOW  : VitalDelayArrayType01 (17 downto 0)   := (others => (0 ps, 0 ps));
        tpd_BCIN_P      : VitalDelayArrayType01 (863 downto 0)  := (others => (0 ps, 0 ps));
        tpd_BCIN_PATTERNBDETECT : VitalDelayArrayType01 (17 downto 0)   := (others => (0 ps, 0 ps));
        tpd_BCIN_PATTERNDETECT  : VitalDelayArrayType01 (17 downto 0)   := (others => (0 ps, 0 ps));
        tpd_BCIN_PCOUT  : VitalDelayArrayType01 (863 downto 0)  := (others => (0 ps, 0 ps));
        tpd_BCIN_UNDERFLOW  : VitalDelayArrayType01 (17 downto 0)   := (others => (0 ps, 0 ps));

        tpd_C_CARRYOUT      : VitalDelayArrayType01 (191 downto 0) := (others => (0 ps, 0 ps));
        tpd_C_CARRYCASCOUT  : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
        tpd_C_MULTSIGNOUT  : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
        tpd_C_OVERFLOW  : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
        tpd_C_P         : VitalDelayArrayType01 (2303 downto 0) := (others => (0 ps, 0 ps));
        tpd_C_PATTERNBDETECT  : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
        tpd_C_PATTERNDETECT  : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
        tpd_C_PCOUT     : VitalDelayArrayType01 (2303 downto 0) := (others => (0 ps, 0 ps));
        tpd_C_UNDERFLOW  : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));

        tpd_CARRYIN_CARRYOUT  : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
        tpd_CARRYIN_CARRYCASCOUT  : VitalDelayType01 := (0 ps, 0 ps);
        tpd_CARRYIN_MULTSIGNOUT  : VitalDelayType01 := (0 ps, 0 ps);
        tpd_CARRYIN_OVERFLOW  : VitalDelayType01 := (0 ps, 0 ps);
        tpd_CARRYIN_P     : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
        tpd_CARRYIN_PATTERNBDETECT  : VitalDelayType01 := (0 ps, 0 ps);
        tpd_CARRYIN_PATTERNDETECT  : VitalDelayType01 := (0 ps, 0 ps);
        tpd_CARRYIN_PCOUT : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
        tpd_CARRYIN_UNDERFLOW  : VitalDelayType01 := (0 ps, 0 ps);

        tpd_CARRYINSEL_CARRYOUT  : VitalDelayArrayType01 (11 downto 0) := (others => (0 ps, 0 ps));
        tpd_CARRYINSEL_CARRYCASCOUT  : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
        tpd_CARRYINSEL_MULTSIGNOUT  : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
        tpd_CARRYINSEL_OVERFLOW  : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
        tpd_CARRYINSEL_P     : VitalDelayArrayType01 (143 downto 0)  := (others => (0 ps, 0 ps));
        tpd_CARRYINSEL_PATTERNBDETECT  : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
        tpd_CARRYINSEL_PATTERNDETECT  : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
        tpd_CARRYINSEL_PCOUT : VitalDelayArrayType01 (143 downto 0)  := (others => (0 ps, 0 ps));
        tpd_CARRYINSEL_UNDERFLOW  : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));

        tpd_CARRYCASCIN_CARRYOUT  : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
        tpd_CARRYCASCIN_CARRYCASCOUT  : VitalDelayType01 := (0 ps, 0 ps);
        tpd_CARRYCASCIN_MULTSIGNOUT  : VitalDelayType01 := (0 ps, 0 ps);
        tpd_CARRYCASCIN_OVERFLOW  : VitalDelayType01 := (0 ps, 0 ps);
        tpd_CARRYCASCIN_P     : VitalDelayArrayType01 (47 downto 0)  := (others => (0 ps, 0 ps));
        tpd_CARRYCASCIN_PATTERNBDETECT  : VitalDelayType01 := (0 ps, 0 ps);
        tpd_CARRYCASCIN_PATTERNDETECT  : VitalDelayType01 := (0 ps, 0 ps);
        tpd_CARRYCASCIN_PCOUT : VitalDelayArrayType01 (47 downto 0)  := (others => (0 ps, 0 ps));
        tpd_CARRYCASCIN_UNDERFLOW  : VitalDelayType01 := (0 ps, 0 ps);

        tpd_CLK_ACOUT   : VitalDelayArrayType01 (29 downto 0)  := (others => (100 ps, 100 ps));
        tpd_CLK_BCOUT   : VitalDelayArrayType01 (17 downto 0)  := (others => (100 ps, 100 ps));
        tpd_CLK_CARRYOUT   : VitalDelayArrayType01 (3 downto 0)  := (others => (100 ps, 100 ps));
        tpd_CLK_CARRYCASCOUT : VitalDelayType01 	       := (100 ps, 100 ps);
        tpd_CLK_MULTSIGNOUT : VitalDelayType01 	       := (100 ps, 100 ps);
        tpd_CLK_OVERFLOW : VitalDelayType01 	       := (100 ps, 100 ps);
        tpd_CLK_P       : VitalDelayArrayType01 (47 downto 0)  := (others => (100 ps, 100 ps));
        tpd_CLK_PATTERNBDETECT : VitalDelayType01 	       := (100 ps, 100 ps);
        tpd_CLK_PATTERNDETECT : VitalDelayType01 	       := (100 ps, 100 ps);
        tpd_CLK_PCOUT   : VitalDelayArrayType01 (47 downto 0)  := (others => (100 ps, 100 ps));
        tpd_CLK_UNDERFLOW : VitalDelayType01 	       := (100 ps, 100 ps);

        tpd_MULTSIGNIN_CARRYOUT  : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
        tpd_MULTSIGNIN_CARRYCASCOUT  : VitalDelayType01 := (0 ps, 0 ps);
        tpd_MULTSIGNIN_MULTSIGNOUT  : VitalDelayType01 := (0 ps, 0 ps);
        tpd_MULTSIGNIN_OVERFLOW  : VitalDelayType01 := (0 ps, 0 ps);
        tpd_MULTSIGNIN_P     : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
        tpd_MULTSIGNIN_PATTERNBDETECT  : VitalDelayType01 := (0 ps, 0 ps);
        tpd_MULTSIGNIN_PATTERNDETECT  : VitalDelayType01 := (0 ps, 0 ps);
        tpd_MULTSIGNIN_PCOUT : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
        tpd_MULTSIGNIN_UNDERFLOW  : VitalDelayType01 := (0 ps, 0 ps);

        tpd_OPMODE_CARRYOUT  : VitalDelayArrayType01 (27 downto 0)   := (others => (0 ps, 0 ps));
        tpd_OPMODE_CARRYCASCOUT  : VitalDelayArrayType01 (6 downto 0)   := (others => (0 ps, 0 ps));
        tpd_OPMODE_MULTSIGNOUT  : VitalDelayArrayType01 (6 downto 0)   := (others => (0 ps, 0 ps));
        tpd_OPMODE_OVERFLOW  : VitalDelayArrayType01 (6 downto 0)   := (others => (0 ps, 0 ps));
        tpd_OPMODE_P     : VitalDelayArrayType01 (335 downto 0)  := (others => (0 ps, 0 ps));
        tpd_OPMODE_PATTERNBDETECT  : VitalDelayArrayType01 (6 downto 0)   := (others => (0 ps, 0 ps));
        tpd_OPMODE_PATTERNDETECT  : VitalDelayArrayType01 (6 downto 0)   := (others => (0 ps, 0 ps));
        tpd_OPMODE_PCOUT : VitalDelayArrayType01 (335 downto 0)  := (others => (0 ps, 0 ps));
        tpd_OPMODE_UNDERFLOW  : VitalDelayArrayType01 (6 downto 0)   := (others => (0 ps, 0 ps));

        tpd_PCIN_CARRYOUT  : VitalDelayArrayType01 (191 downto 0)   := (others => (0 ps, 0 ps));
        tpd_PCIN_CARRYCASCOUT  : VitalDelayArrayType01 (47 downto 0)   := (others => (0 ps, 0 ps));
        tpd_PCIN_MULTSIGNOUT  : VitalDelayArrayType01 (47 downto 0)   := (others => (0 ps, 0 ps));
        tpd_PCIN_OVERFLOW  : VitalDelayArrayType01 (47 downto 0)   := (others => (0 ps, 0 ps));
        tpd_PCIN_P      : VitalDelayArrayType01 (2303 downto 0)  := (others => (0 ps, 0 ps));
        tpd_PCIN_PATTERNBDETECT  : VitalDelayArrayType01 (47 downto 0)   := (others => (0 ps, 0 ps));
        tpd_PCIN_PATTERNDETECT  : VitalDelayArrayType01 (47 downto 0)   := (others => (0 ps, 0 ps));
        tpd_PCIN_PCOUT  : VitalDelayArrayType01 (2303 downto 0)  := (others => (0 ps, 0 ps));
        tpd_PCIN_UNDERFLOW  : VitalDelayArrayType01 (47 downto 0)   := (others => (0 ps, 0 ps));

----- VITAL setup and hold times
       
        tsetup_A_CLK_posedge_posedge : VitalDelayArrayType(29 downto 0) := (others => 0 ps);
        tsetup_A_CLK_negedge_posedge : VitalDelayArrayType(29 downto 0) := (others => 0 ps);
        tsetup_ACIN_CLK_posedge_posedge : VitalDelayArrayType(29 downto 0) := (others => 0 ps);
        tsetup_ACIN_CLK_negedge_posedge : VitalDelayArrayType(29 downto 0) := (others => 0 ps);
        tsetup_ALUMODE_CLK_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
        tsetup_ALUMODE_CLK_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
        tsetup_B_CLK_posedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
        tsetup_B_CLK_negedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
        tsetup_BCIN_CLK_posedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
        tsetup_BCIN_CLK_negedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
        tsetup_C_CLK_posedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
        tsetup_C_CLK_negedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
        tsetup_CARRYCASCIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
        tsetup_CARRYCASCIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
        tsetup_CARRYIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
        tsetup_CARRYIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
        tsetup_CARRYINSEL_CLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
        tsetup_CARRYINSEL_CLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
        tsetup_CEA1_CLK_posedge_posedge : VitalDelayType := 0 ps;
        tsetup_CEA1_CLK_negedge_posedge : VitalDelayType := 0 ps;
        tsetup_CEA2_CLK_posedge_posedge : VitalDelayType := 0 ps;
        tsetup_CEA2_CLK_negedge_posedge : VitalDelayType := 0 ps;
        tsetup_CEALUMODE_CLK_posedge_posedge : VitalDelayType := 0 ps;
        tsetup_CEALUMODE_CLK_negedge_posedge : VitalDelayType := 0 ps;
        tsetup_CEB1_CLK_posedge_posedge : VitalDelayType := 0 ps;
        tsetup_CEB1_CLK_negedge_posedge : VitalDelayType := 0 ps;
        tsetup_CEB2_CLK_posedge_posedge : VitalDelayType := 0 ps;
        tsetup_CEB2_CLK_negedge_posedge : VitalDelayType := 0 ps;
        tsetup_CEC_CLK_posedge_posedge : VitalDelayType := 0 ps;
        tsetup_CEC_CLK_negedge_posedge : VitalDelayType := 0 ps;
        tsetup_CECARRYIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
        tsetup_CECARRYIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
        tsetup_CECTRL_CLK_posedge_posedge : VitalDelayType := 0 ps;
        tsetup_CECTRL_CLK_negedge_posedge : VitalDelayType := 0 ps;
        tsetup_CEM_CLK_posedge_posedge : VitalDelayType := 0 ps;
        tsetup_CEM_CLK_negedge_posedge : VitalDelayType := 0 ps;
        tsetup_CEMULTCARRYIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
        tsetup_CEMULTCARRYIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
        tsetup_CEP_CLK_posedge_posedge : VitalDelayType := 0 ps;
        tsetup_CEP_CLK_negedge_posedge : VitalDelayType := 0 ps;
        tsetup_MULTSIGNIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
        tsetup_MULTSIGNIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
        tsetup_OPMODE_CLK_posedge_posedge : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
        tsetup_OPMODE_CLK_negedge_posedge : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
        tsetup_PCIN_CLK_posedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
        tsetup_PCIN_CLK_negedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
        tsetup_RSTA_CLK_posedge_posedge : VitalDelayType := 0 ps;
        tsetup_RSTA_CLK_negedge_posedge : VitalDelayType := 0 ps;
        tsetup_RSTALLCARRYIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
        tsetup_RSTALLCARRYIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
        tsetup_RSTALUMODE_CLK_posedge_posedge : VitalDelayType := 0 ps;
        tsetup_RSTALUMODE_CLK_negedge_posedge : VitalDelayType := 0 ps;
        tsetup_RSTB_CLK_posedge_posedge : VitalDelayType := 0 ps;
        tsetup_RSTB_CLK_negedge_posedge : VitalDelayType := 0 ps;
        tsetup_RSTC_CLK_posedge_posedge : VitalDelayType := 0 ps;
        tsetup_RSTC_CLK_negedge_posedge : VitalDelayType := 0 ps;
        tsetup_RSTCTRL_CLK_posedge_posedge : VitalDelayType := 0 ps;
        tsetup_RSTCTRL_CLK_negedge_posedge : VitalDelayType := 0 ps;
        tsetup_RSTP_CLK_posedge_posedge : VitalDelayType := 0 ps;
        tsetup_RSTP_CLK_negedge_posedge : VitalDelayType := 0 ps;
        tsetup_RSTM_CLK_posedge_posedge : VitalDelayType := 0 ps;
        tsetup_RSTM_CLK_negedge_posedge : VitalDelayType := 0 ps;

        thold_A_CLK_posedge_posedge : VitalDelayArrayType(29 downto 0) := (others => 0 ps);
        thold_A_CLK_negedge_posedge : VitalDelayArrayType(29 downto 0) := (others => 0 ps);
        thold_ACIN_CLK_posedge_posedge : VitalDelayArrayType(29 downto 0) := (others => 0 ps);
        thold_ACIN_CLK_negedge_posedge : VitalDelayArrayType(29 downto 0) := (others => 0 ps);
        thold_ALUMODE_CLK_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
        thold_ALUMODE_CLK_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
        thold_B_CLK_posedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
        thold_B_CLK_negedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
        thold_BCIN_CLK_posedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
        thold_BCIN_CLK_negedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
        thold_C_CLK_posedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
        thold_C_CLK_negedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
        thold_CARRYCASCIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
        thold_CARRYCASCIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
        thold_CARRYIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
        thold_CARRYIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
        thold_CARRYINSEL_CLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
        thold_CARRYINSEL_CLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
        thold_CEA1_CLK_posedge_posedge : VitalDelayType := 0 ps;
        thold_CEA1_CLK_negedge_posedge : VitalDelayType := 0 ps;
        thold_CEA2_CLK_posedge_posedge : VitalDelayType := 0 ps;
        thold_CEA2_CLK_negedge_posedge : VitalDelayType := 0 ps;
        thold_CEALUMODE_CLK_posedge_posedge : VitalDelayType := 0 ps;
        thold_CEALUMODE_CLK_negedge_posedge : VitalDelayType := 0 ps;
        thold_CEB1_CLK_posedge_posedge : VitalDelayType := 0 ps;
        thold_CEB1_CLK_negedge_posedge : VitalDelayType := 0 ps;
        thold_CEB2_CLK_posedge_posedge : VitalDelayType := 0 ps;
        thold_CEB2_CLK_negedge_posedge : VitalDelayType := 0 ps;
        thold_CEC_CLK_posedge_posedge : VitalDelayType := 0 ps;
        thold_CEC_CLK_negedge_posedge : VitalDelayType := 0 ps;
        thold_CECARRYIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
        thold_CECARRYIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
        thold_CECTRL_CLK_posedge_posedge : VitalDelayType := 0 ps;
        thold_CECTRL_CLK_negedge_posedge : VitalDelayType := 0 ps;
        thold_CEM_CLK_posedge_posedge : VitalDelayType := 0 ps;
        thold_CEM_CLK_negedge_posedge : VitalDelayType := 0 ps;
        thold_CEMULTCARRYIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
        thold_CEMULTCARRYIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
        thold_CEP_CLK_posedge_posedge : VitalDelayType := 0 ps;
        thold_CEP_CLK_negedge_posedge : VitalDelayType := 0 ps;
        thold_MULTSIGNIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
        thold_MULTSIGNIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
        thold_OPMODE_CLK_posedge_posedge : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
        thold_OPMODE_CLK_negedge_posedge : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
        thold_PCIN_CLK_posedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
        thold_PCIN_CLK_negedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
        thold_RSTA_CLK_posedge_posedge : VitalDelayType := 0 ps;
        thold_RSTA_CLK_negedge_posedge : VitalDelayType := 0 ps;
        thold_RSTALLCARRYIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
        thold_RSTALLCARRYIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
        thold_RSTALUMODE_CLK_posedge_posedge : VitalDelayType := 0 ps;
        thold_RSTALUMODE_CLK_negedge_posedge : VitalDelayType := 0 ps;
        thold_RSTB_CLK_posedge_posedge : VitalDelayType := 0 ps;
        thold_RSTB_CLK_negedge_posedge : VitalDelayType := 0 ps;
        thold_RSTC_CLK_posedge_posedge : VitalDelayType := 0 ps;
        thold_RSTC_CLK_negedge_posedge : VitalDelayType := 0 ps;
        thold_RSTCTRL_CLK_posedge_posedge : VitalDelayType := 0 ps;
        thold_RSTCTRL_CLK_negedge_posedge : VitalDelayType := 0 ps;
        thold_RSTP_CLK_posedge_posedge : VitalDelayType := 0 ps;
        thold_RSTP_CLK_negedge_posedge : VitalDelayType := 0 ps;
        thold_RSTM_CLK_posedge_posedge : VitalDelayType := 0 ps;
        thold_RSTM_CLK_negedge_posedge : VitalDelayType := 0 ps;

----- VITAL clock ticd delays
        ticd_CLK        : VitalDelayType  := 0 ps;
     
----- VITAL clock-to-pin tisd delays
        tisd_A_CLK              : VitalDelayArrayType(29 downto 0) := (others => 0 ps);
        tisd_ACIN_CLK           : VitalDelayArrayType(29 downto 0) := (others => 0 ps);
        tisd_ALUMODE_CLK        : VitalDelayArrayType(3 downto 0)  := (others => 0 ps);
        tisd_B_CLK              : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
        tisd_BCIN_CLK           : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
        tisd_C_CLK              : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
        tisd_CARRYCASCIN_CLK    : VitalDelayType  := 0 ps;
        tisd_CARRYIN_CLK        : VitalDelayType  := 0 ps;
        tisd_CARRYINSEL_CLK     : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
        tisd_CEA1_CLK           : VitalDelayType  := 0 ps;
        tisd_CEA2_CLK           : VitalDelayType  := 0 ps;
        tisd_CEALUMODE_CLK      : VitalDelayType  := 0 ps;
        tisd_CEB1_CLK           : VitalDelayType  := 0 ps;
        tisd_CEB2_CLK           : VitalDelayType  := 0 ps;
        tisd_CEC_CLK            : VitalDelayType  := 0 ps;
        tisd_CECARRYIN_CLK      : VitalDelayType  := 0 ps;
        tisd_CECTRL_CLK         : VitalDelayType  := 0 ps;
        tisd_CEM_CLK            : VitalDelayType  := 0 ps;
        tisd_CEMULTCARRYIN_CLK  : VitalDelayType  := 0 ps;
        tisd_CEP_CLK            : VitalDelayType  := 0 ps;
        tisd_MULTSIGNIN_CLK     : VitalDelayType  := 0 ps;
        tisd_OPMODE_CLK         : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
        tisd_PCIN_CLK           : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
        tisd_RSTA_CLK           : VitalDelayType := 0 ps;
        tisd_RSTALLCARRYIN_CLK  : VitalDelayType := 0 ps;
        tisd_RSTALUMODE_CLK     : VitalDelayType := 0 ps;
        tisd_RSTB_CLK           : VitalDelayType := 0 ps;
        tisd_RSTC_CLK           : VitalDelayType := 0 ps;
        tisd_RSTCTRL_CLK        : VitalDelayType := 0 ps;
        tisd_RSTM_CLK           : VitalDelayType := 0 ps;
        tisd_RSTP_CLK           : VitalDelayType := 0 ps;

----- VITAL period check 
        tperiod_CLK_posedge     : VitalDelayType := 0 ps;

----- VITAL pulse width
        tpw_CLK_negedge         : VitalDelayType := 0 ps;
        tpw_CLK_posedge         : VitalDelayType := 0 ps;

----- VITAL Recovery

        ACASCREG	: integer		:= 1;
        ALUMODEREG	: integer		:= 1;
        AREG		: integer		:= 1;
        AUTORESET_PATTERN_DETECT		: boolean		:= FALSE;
        AUTORESET_PATTERN_DETECT_OPTINV		: string		:= "MATCH";
        A_INPUT		: string		:= "DIRECT";
        BCASCREG	: integer		:= 1;
        BREG		: integer		:= 1;
        B_INPUT		: string		:= "DIRECT";
        CARRYINREG	: integer		:= 1;
        CARRYINSELREG	: integer		:= 1;
        CREG		: integer		:= 1;
        MASK            : bit_vector            := X"3FFFFFFFFFFF";
        MREG		: integer		:= 1;
        MULTCARRYINREG	: integer		:= 1;
        OPMODEREG	: integer		:= 1;
        PATTERN         : bit_vector            := X"000000000000";
        PREG		: integer		:= 1;
        SEL_MASK	: string		:= "MASK";
        SEL_PATTERN	: string		:= "PATTERN";
        SEL_ROUNDING_MASK	: string	:= "SEL_MASK";
        USE_MULT	: string		:= "MULT_S";
        USE_PATTERN_DETECT	: string	:= "NO_PATDET";
        USE_SIMD	: string		:= "ONE48"
        );

  port(
        ACOUT                   : out std_logic_vector(29 downto 0);
        BCOUT                   : out std_logic_vector(17 downto 0);
        CARRYCASCOUT            : out std_ulogic;
        CARRYOUT                : out std_logic_vector(3 downto 0);
        MULTSIGNOUT             : out std_ulogic;
        OVERFLOW                : out std_ulogic;
        P                       : out std_logic_vector(47 downto 0);
        PATTERNBDETECT          : out std_ulogic;
        PATTERNDETECT           : out std_ulogic;
        PCOUT                   : out std_logic_vector(47 downto 0);
        UNDERFLOW               : out std_ulogic;

        A                       : in  std_logic_vector(29 downto 0);
        ACIN                    : in  std_logic_vector(29 downto 0);
        ALUMODE                 : in  std_logic_vector(3 downto 0);
        B                       : in  std_logic_vector(17 downto 0);
        BCIN                    : in  std_logic_vector(17 downto 0);
        C                       : in  std_logic_vector(47 downto 0);
        CARRYCASCIN             : in  std_ulogic;
        CARRYIN                 : in  std_ulogic;
        CARRYINSEL              : in  std_logic_vector(2 downto 0);
        CEA1                    : in  std_ulogic;
        CEA2                    : in  std_ulogic;
        CEALUMODE               : in  std_ulogic;
        CEB1                    : in  std_ulogic;
        CEB2                    : in  std_ulogic;
        CEC                     : in  std_ulogic;
        CECARRYIN               : in  std_ulogic;
        CECTRL                  : in  std_ulogic;
        CEM                     : in  std_ulogic;
        CEMULTCARRYIN           : in  std_ulogic;
        CEP                     : in  std_ulogic;
        CLK                     : in  std_ulogic;
        MULTSIGNIN              : in std_ulogic;
        OPMODE                  : in  std_logic_vector(6 downto 0);
        PCIN                    : in  std_logic_vector(47 downto 0);
        RSTA                    : in  std_ulogic;
        RSTALLCARRYIN           : in  std_ulogic;
        RSTALUMODE              : in  std_ulogic;
        RSTB                    : in  std_ulogic;
        RSTC                    : in  std_ulogic;
        RSTCTRL                 : in  std_ulogic;
        RSTM                    : in  std_ulogic;
        RSTP                    : in  std_ulogic
      );

  attribute VITAL_LEVEL0 of X_DSP48E :     entity is true;

end X_DSP48E;

-- architecture body                    --

architecture X_DSP48E_V of X_DSP48E is

    function find_x (
      lhs : in std_logic_vector (47 downto 0);
      rhs : in std_logic_vector (47 downto 0)
    ) return boolean is
    variable test_bit : std_ulogic := '0';
    variable found_x : boolean := false;
    variable i : integer := 0;
    begin

       found_x := false;

       for i in 0 to 47 loop
         test_bit := lhs(i);
         if (test_bit /= '0' and test_bit /= '1') then
              found_x := true;
         end if;
       end loop;
       for i in 0 to 47 loop
         test_bit := rhs(i);
         if (test_bit /= '0' and test_bit /= '1') then
              found_x := true;
         end if;
       end loop;
      return found_x;
    end;

    procedure invalid_opmode_preg_msg( OPMODE : IN string ; 
                                   CARRYINSEL : IN string ) is
    variable Message : line;
    begin
       Write ( Message, string'("OPMODE Input Warning : The OPMODE "));
       Write ( Message,  OPMODE);
       Write ( Message, string'(" with CARRYINSEL "));
       Write ( Message,  CARRYINSEL);
       Write ( Message, string'(" to X_DSP48E instance "));
       Write ( Message, string'("requires attribute PREG set to 1."));
       assert false report Message.all severity Warning;
       DEALLOCATE (Message);
    end invalid_opmode_preg_msg;

    procedure invalid_opmode_preg_msg_logic( OPMODE : IN string ) is
    variable Message : line;
    begin
       Write ( Message, string'("OPMODE Input Warning : The OPMODE "));
       Write ( Message,  OPMODE);
       Write ( Message, string'(" to X_DSP48E instance "));
       Write ( Message, string'("requires attribute PREG set to 1."));
       assert false report Message.all severity Warning;
       DEALLOCATE (Message);
    end invalid_opmode_preg_msg_logic;

    procedure invalid_opmode_mreg_msg( OPMODE : IN string ; 
                                   CARRYINSEL : IN string ) is
    variable Message : line;
    begin
       Write ( Message, string'("OPMODE Input Warning : The OPMODE "));
       Write ( Message,  OPMODE);
       Write ( Message, string'(" with CARRYINSEL "));
       Write ( Message,  CARRYINSEL);
       Write ( Message, string'(" to X_DSP48E instance "));
       Write ( Message, string'("requires attribute MREG set to 1."));
       assert false report Message.all severity Warning;
       DEALLOCATE (Message);
    end invalid_opmode_mreg_msg;

    procedure invalid_opmode_no_mreg_msg( OPMODE : IN string ; 
                                      CARRYINSEL : IN string ) is
    variable Message : line;
    begin
       Write ( Message, string'("OPMODE Input Warning : The OPMODE "));
       Write ( Message,  OPMODE);
       Write ( Message, string'(" with CARRYINSEL "));
       Write ( Message,  CARRYINSEL);
       Write ( Message, string'(" to X_DSP48E instance "));
       Write ( Message, string'("requires attribute MREG set to 0."));
       assert false report Message.all severity Warning;
       DEALLOCATE (Message);
    end invalid_opmode_no_mreg_msg;


  attribute VITAL_LEVEL0 of X_DSP48E_V : architecture is true;

  TYPE VitalTimingDataArrayType IS ARRAY (NATURAL RANGE <>)
         OF VitalTimingDataType;


  TYPE AluFuntionType is (INVALID_ALU, ADD_ALU, ADD_XY_NOTZ_ALU, NOT_XYZC_ALU, SUBTRACT_ALU, NOT_ALU, 
                          AND_ALU, OR_ALU, XOR_ALU, NAND_ALU, NOR_ALU, 
                          XNOR_ALU, X_AND_NOT_Z_ALU, NOT_X_OR_Z_ALU, X_OR_NOT_Z_ALU,
                          X_NOR_Z_ALU, NOT_X_AND_Z_ALU);

  constant SYNC_PATH_DELAY : time := 100 ps;

  constant MAX_ACOUT      : integer    := 30;
  constant MAX_BCOUT      : integer    := 18;
  constant MAX_CARRYOUT   : integer    := 4;
  constant MAX_P          : integer    := 48;
  constant MAX_PCOUT      : integer    := 48;

  constant MAX_A          : integer    := 30;
  constant MAX_ACIN       : integer    := 30;
  constant MAX_ALUMODE    : integer    := 4;
  constant MAX_A_MULT     : integer    := 25;
  constant MAX_B          : integer    := 18;
  constant MAX_B_MULT     : integer    := 18;
  constant MAX_BCIN       : integer    := 18;
  constant MAX_C          : integer    := 48;
  constant MAX_CARRYINSEL : integer    := 3;
  constant MAX_OPMODE     : integer    := 7;
  constant MAX_PCIN       : integer    := 48;

  constant MAX_ALU_FULL   : integer    := 48;
  constant MAX_ALU_HALF   : integer    := 24;
  constant MAX_ALU_QUART  : integer    := 12;

  constant MSB_ACOUT      : integer    := MAX_ACOUT - 1;
  constant MSB_BCOUT      : integer    := MAX_BCOUT - 1;
  constant MSB_CARRYOUT   : integer    := MAX_CARRYOUT - 1;
  constant MSB_P          : integer    := MAX_P - 1;
  constant MSB_PCOUT      : integer    := MAX_PCOUT - 1;


  constant MSB_A          : integer    := MAX_A - 1;
  constant MSB_ACIN       : integer    := MAX_ACIN - 1;
  constant MSB_ALUMODE    : integer    := MAX_ALUMODE - 1;
  constant MSB_A_MULT     : integer    := MAX_A_MULT - 1;
  constant MSB_B          : integer    := MAX_B - 1;
  constant MSB_B_MULT     : integer    := MAX_B_MULT - 1;
  constant MSB_BCIN       : integer    := MAX_BCIN - 1;
  constant MSB_C          : integer    := MAX_C - 1;
  constant MSB_CARRYINSEL : integer    := MAX_CARRYINSEL - 1;
  constant MSB_OPMODE     : integer    := MAX_OPMODE - 1;
  constant MSB_PCIN       : integer    := MAX_PCIN - 1;

  constant MSB_ALU_FULL   : integer    := MAX_ALU_FULL - 1;
  constant MSB_ALU_HALF   : integer    := MAX_ALU_HALF - 1;
  constant MSB_ALU_QUART  : integer    := MAX_ALU_QUART - 1;

  constant SHIFT_MUXZ     : integer    := 17;

  signal 	A_ipd		: std_logic_vector(MSB_A downto 0) := (others => '0');
  signal 	ACIN_ipd	: std_logic_vector(MSB_ACIN downto 0) := (others => '0');
  signal 	ALUMODE_ipd	: std_logic_vector(MSB_ALUMODE downto 0) := (others => '0');
  signal 	B_ipd		: std_logic_vector(MSB_B downto 0) := (others => '0');
  signal 	BCIN_ipd	: std_logic_vector(MSB_BCIN downto 0) := (others => '0');
  signal 	C_ipd		: std_logic_vector(MSB_C downto 0)    := (others => '0');
  signal 	CARRYCASCIN_ipd	: std_ulogic := '0';
  signal 	CARRYIN_ipd	: std_ulogic := '0';
  signal 	CARRYINSEL_ipd	: std_logic_vector(MSB_CARRYINSEL downto 0)  := (others => '0');
  signal 	CEA1_ipd	: std_ulogic := '0';
  signal 	CEA2_ipd	: std_ulogic := '0';
  signal 	CEALUMODE_ipd	: std_ulogic := '0';
  signal 	CEB1_ipd	: std_ulogic := '0';
  signal 	CEB2_ipd	: std_ulogic := '0';
  signal 	CEC_ipd		: std_ulogic := '0';
  signal 	CECARRYIN_ipd	: std_ulogic := '0';
  signal 	CECTRL_ipd	: std_ulogic := '0';
  signal 	CEM_ipd		: std_ulogic := '0';
  signal 	CEMULTCARRYIN_ipd	: std_ulogic := '0';
  signal 	CEP_ipd		: std_ulogic := '0';
  signal 	CLK_ipd		: std_ulogic := '0';
  signal 	GSR_ipd		: std_ulogic := '0';
  signal 	MULTSIGNIN_ipd		: std_ulogic := '0';
  signal 	OPMODE_ipd	: std_logic_vector(MSB_OPMODE downto 0)  := (others => '0');
  signal 	PCIN_ipd	: std_logic_vector(MSB_PCIN downto 0) := (others => '0');
  signal 	RSTA_ipd	: std_ulogic := '0';
  signal 	RSTALLCARRYIN_ipd	: std_ulogic := '0';
  signal 	RSTALUMODE_ipd	: std_ulogic := '0';
  signal 	RSTB_ipd	: std_ulogic := '0';
  signal 	RSTC_ipd	: std_ulogic := '0';
  signal 	RSTCTRL_ipd	: std_ulogic := '0';
  signal 	RSTM_ipd	: std_ulogic := '0';
  signal 	RSTP_ipd	: std_ulogic := '0';

  signal 	A_dly		: std_logic_vector(MSB_A downto 0) := (others => '0');
  signal 	ACIN_dly	: std_logic_vector(MSB_ACIN downto 0) := (others => '0');
  signal 	ALUMODE_dly	: std_logic_vector(MSB_ALUMODE downto 0) := (others => '0');
  signal 	B_dly		: std_logic_vector(MSB_B downto 0) := (others => '0');
  signal 	BCIN_dly	: std_logic_vector(MSB_BCIN downto 0) := (others => '0');
  signal 	C_dly		: std_logic_vector(MSB_C downto 0)    := (others => '0');
  signal 	CARRYCASCIN_dly	: std_ulogic := '0';
  signal 	CARRYIN_dly	: std_ulogic := '0';
  signal 	CARRYINSEL_dly	: std_logic_vector(MSB_CARRYINSEL downto 0)  := (others => '0');
  signal 	CEA1_dly	: std_ulogic := '0';
  signal 	CEA2_dly	: std_ulogic := '0';
  signal 	CEALUMODE_dly	: std_ulogic := '0';
  signal 	CEB1_dly	: std_ulogic := '0';
  signal 	CEB2_dly	: std_ulogic := '0';
  signal 	CEC_dly		: std_ulogic := '0';
  signal 	CECARRYIN_dly	: std_ulogic := '0';
  signal 	CECTRL_dly	: std_ulogic := '0';
  signal 	CEM_dly		: std_ulogic := '0';
  signal 	CEMULTCARRYIN_dly	: std_ulogic := '0';
  signal 	CEP_dly		: std_ulogic := '0';
  signal 	CLK_dly		: std_ulogic := '0';
  signal 	GSR_dly		: std_ulogic := '0';
  signal 	MULTSIGNIN_dly	: std_ulogic := '0';
  signal 	OPMODE_dly	: std_logic_vector(MSB_OPMODE downto 0)  := (others => '0');
  signal 	PCIN_dly	: std_logic_vector(MSB_PCIN downto 0) := (others => '0');
  signal 	RSTA_dly	: std_ulogic := '0';
  signal 	RSTALLCARRYIN_dly	: std_ulogic := '0';
  signal 	RSTALUMODE_dly	: std_ulogic := '0';
  signal 	RSTB_dly	: std_ulogic := '0';
  signal 	RSTC_dly	: std_ulogic := '0';
  signal 	RSTCTRL_dly	: std_ulogic := '0';
  signal 	RSTM_dly	: std_ulogic := '0';
  signal 	RSTP_dly	: std_ulogic := '0';


  signal	ACOUT_zd	: std_logic_vector(MSB_ACOUT downto 0) := (others => '0');
  signal	BCOUT_zd	: std_logic_vector(MSB_BCOUT downto 0) := (others => '0');
  signal 	CARRYCASCOUT_zd	: std_ulogic := '0';
  signal	CARRYOUT_zd	: std_logic_vector(MSB_CARRYOUT downto 0) := (others => '0');
  signal 	OVERFLOW_zd	: std_ulogic := '0';
  signal	P_zd		: std_logic_vector(MSB_P downto 0) := (others => '0');
  signal 	PATTERNBDETECT_zd	: std_ulogic := '0';
  signal 	PATTERNDETECT_zd	: std_ulogic := '0';
  signal	PCOUT_zd	: std_logic_vector(MSB_PCOUT downto 0) := (others => '0');
  signal 	UNDERFLOW_zd	: std_ulogic := '0';
  signal 	MULTSIGNOUT_zd	: std_ulogic;
  
  --- Internal Signal Declarations
  signal	a_o_mux		: std_logic_vector(MSB_A downto 0) := (others => '0');
  signal	qa_o_reg1	: std_logic_vector(MSB_A downto 0) := (others => '0');
  signal	qa_o_reg2	: std_logic_vector(MSB_A downto 0) := (others => '0');
  signal	qa_o_mux	: std_logic_vector(MSB_A downto 0) := (others => '0');
  signal	qacout_o_mux	: std_logic_vector(MSB_ACOUT downto 0) := (others => '0');

  signal	b_o_mux		: std_logic_vector(MSB_B downto 0) := (others => '0');
  signal	qb_o_reg1	: std_logic_vector(MSB_B downto 0) := (others => '0');
  signal	qb_o_reg2	: std_logic_vector(MSB_B downto 0) := (others => '0');
  signal	qb_o_mux	: std_logic_vector(MSB_B downto 0) := (others => '0');
  signal	qbcout_o_mux	: std_logic_vector(MSB_BCOUT downto 0) := (others => '0');

  signal	qc_o_reg        : std_logic_vector(MSB_C downto 0) := (others => '0');
  signal	qc_o_mux	: std_logic_vector(MSB_C downto 0) := (others => '0');

  signal	mult_o_int	: std_logic_vector((MSB_A_MULT + MSB_B_MULT + 1) downto 0) := (others => '0');
  signal	mult_o_reg	: std_logic_vector((MSB_A_MULT + MSB_B_MULT + 1) downto 0) := (others => '0');
  signal	mult_o_mux	: std_logic_vector((MSB_A_MULT + MSB_B_MULT + 1) downto 0) := (others => '0');

  signal	opmode_o_reg	: std_logic_vector(MSB_OPMODE downto 0) := (others => '0');
  signal	opmode_o_mux	: std_logic_vector(MSB_OPMODE downto 0) := (others => '0');

  signal	muxx_o_mux	: std_logic_vector(MSB_P downto 0) := (others => '0');
  signal	muxy_o_mux	: std_logic_vector(MSB_P downto 0) := (others => '0');
  signal	muxz_o_mux	: std_logic_vector(MSB_P downto 0) := (others => '0');

  signal	carryinsel_o_reg	: std_logic_vector(MSB_CARRYINSEL downto 0) := (others => '0');
  signal	carryinsel_o_mux	: std_logic_vector(MSB_CARRYINSEL downto 0) := (others => '0');

  signal	qcarryin_o_reg0	: std_ulogic := '0';
  signal	carryin_o_mux0	: std_ulogic := '0';
  signal	qcarryin_o_reg7	: std_ulogic := '0';
  signal	carryin_o_mux7	: std_ulogic := '0';

  signal	carryin_o_mux	: std_ulogic := '0';

  signal	qp_o_reg	: std_logic_vector(MSB_P downto 0) := (others => '0');
  signal	qp_o_mux	: std_logic_vector(MSB_P downto 0) := (others => '0');

  signal	reg_p_int       : std_logic_vector(47 downto 0) := (others => '0');
  signal	p_o_int         : std_logic_vector(47 downto 0) := (others => '0');

  signal	output_x_sig	: std_ulogic := '0';

  signal	RST_META          : std_ulogic := '0';

  signal	DefDelay          : time := 10 ps;

  signal	opmode_valid_flg   : boolean := true;
  signal	alumode_valid_flg  : boolean := true;

  signal	AluFunction	: AluFuntionType := INVALID_ALU;

  signal	alumode_o_reg	: std_logic_vector(MSB_ALUMODE downto 0) := (others => '0');
  signal	alumode_o_mux	: std_logic_vector(MSB_ALUMODE downto 0) := (others => '0');

  signal	carrycascout_o  : std_ulogic := '0';
  signal	carrycascout_o_reg  : std_ulogic := '0';
  signal	carrycascout_o_mux  : std_ulogic := '0';
  signal	carryout_o	: std_logic_vector(MSB_CARRYOUT downto 0) := (others => '0');
  signal	carryout_o_reg	: std_logic_vector(MSB_CARRYOUT downto 0) := (others => '0');
  signal	carryout_o_mux	: std_logic_vector(MSB_CARRYOUT downto 0) := (others => '0');
  signal        carryout_x_o    : std_logic_vector(MSB_CARRYOUT downto 0) := (others => 'X');
  signal	overflow_o      : std_ulogic := '0';
  signal	pdetb_o         : std_ulogic := '0';
  signal	pdetb_o_reg1    : std_ulogic := '0';
  signal	pdetb_o_reg2    : std_ulogic := '0';
  signal	pdet_o          : std_ulogic := '0';
  signal	pdet_o_reg1     : std_ulogic := '0';
  signal	pdet_o_reg2     : std_ulogic := '0';
  signal	underflow_o     : std_ulogic := '0';

  signal	alu_o		: std_logic_vector(MSB_P downto 0) := (others => '0');
  signal	pattern_qp	: std_logic_vector(MSB_P downto 0) := (others => '0');
  signal	mask_qp		: std_logic_vector(MSB_P downto 0) := (others => '0');

  signal        multsignout_o_reg : std_ulogic    := '0';
  signal        multsignout_o_mux : std_ulogic    := '0';
  signal        multsignout_o_opmode : std_ulogic := '0';

  signal	OPMODE_NUMBER	: integer		:= -1;

  signal	ping_opmode_drc_check : std_ulogic := '0';

begin

  GSR_dly <= GSR;

  ---------------------
  --  INPUT PATH DELAYs
  ---------------------
  WireDelay     : block
  begin
    A_Delay : for i in MSB_A downto 0 generate
        VitalWireDelay (A_ipd(i),    A(i),        tipd_A(i));
    end generate A_Delay;    

    ACIN_Delay : for i in MSB_ACIN downto 0 generate
        VitalWireDelay (ACIN_ipd(i),  ACIN(i),      tipd_ACIN(i));
    end generate ACIN_Delay;    

    ALUMODE_Delay : for i in MSB_ALUMODE downto 0 generate
        VitalWireDelay (ALUMODE_ipd(i),  ALUMODE(i),      tipd_ALUMODE(i));
    end generate ALUMODE_Delay;    

    B_Delay : for i in MSB_B downto 0 generate
        VitalWireDelay (B_ipd(i),    B(i),        tipd_B(i));
    end generate B_Delay;    

    BCIN_Delay : for i in MSB_BCIN downto 0 generate
        VitalWireDelay (BCIN_ipd(i),  BCIN(i),      tipd_BCIN(i));
    end generate BCIN_Delay;    

    C_Delay : for i in MSB_C downto 0 generate
        VitalWireDelay (C_ipd(i),    C(i),        tipd_C(i));
    end generate C_Delay;    

    VitalWireDelay (CARRYCASCIN_ipd,    CARRYCASCIN,    tipd_CARRYCASCIN);

    VitalWireDelay (CARRYIN_ipd,    CARRYIN,    tipd_CARRYIN);

    CARRYINSEL_delay : for i in MSB_CARRYINSEL downto 0 generate
        VitalWireDelay (CARRYINSEL_ipd(i), CARRYINSEL(i),    tipd_CARRYINSEL(i));    
    end generate CARRYINSEL_delay;

    VitalWireDelay (CEA1_ipd,       CEA1,        tipd_CEA1);
    VitalWireDelay (CEA2_ipd,       CEA2,        tipd_CEA2);
    VitalWireDelay (CEALUMODE_ipd,  CEALUMODE,   tipd_CEALUMODE);
    VitalWireDelay (CEB1_ipd,       CEB1,        tipd_CEB1);
    VitalWireDelay (CEB2_ipd,       CEB2,        tipd_CEB2);
    VitalWireDelay (CEC_ipd,        CEC,        tipd_CEC);
    VitalWireDelay (CECARRYIN_ipd,  CECARRYIN,  tipd_CECARRYIN);
    VitalWireDelay (CECTRL_ipd,     CECTRL,     tipd_CECTRL);
    VitalWireDelay (CEM_ipd,        CEM,        tipd_CEM);
    VitalWireDelay (CEMULTCARRYIN_ipd,   CEMULTCARRYIN,   tipd_CEMULTCARRYIN);
    VitalWireDelay (CEP_ipd,        CEP,        tipd_CEP);

    VitalWireDelay (CLK_ipd,        CLK,        tipd_CLK);
    VitalWireDelay (MULTSIGNIN_ipd, MULTSIGNIN, tipd_MULTSIGNIN);

    OPMODE_delay : for i in MSB_OPMODE downto 0 generate
        VitalWireDelay (OPMODE_ipd(i),     OPMODE(i),    tipd_OPMODE(i));    
    end generate OPMODE_delay;

    Pin_Delay : for i in MSB_PCIN downto 0 generate
        VitalWireDelay (PCIN_ipd(i),     PCIN(i),    tipd_PCIN(i));
    end generate Pin_Delay;    

    VitalWireDelay (RSTA_ipd,        RSTA,        tipd_RSTA);
    VitalWireDelay (RSTALLCARRYIN_ipd,    RSTALLCARRYIN,    tipd_RSTALLCARRYIN);
    VitalWireDelay (RSTALUMODE_ipd,  RSTALUMODE,  tipd_RSTALUMODE);
    VitalWireDelay (RSTB_ipd,        RSTB,        tipd_RSTB);
    VitalWireDelay (RSTC_ipd,        RSTC,        tipd_RSTC);
    VitalWireDelay (RSTCTRL_ipd,     RSTCTRL,     tipd_RSTCTRL);
    VitalWireDelay (RSTM_ipd,        RSTM,        tipd_RSTM);
    VitalWireDelay (RSTP_ipd,        RSTP,        tipd_RSTP);

  end block;


  SignalDelay : block
  begin
    A_Delay : for i in MSB_A downto 0 generate
        VitalSignalDelay (A_dly(i),     A_ipd(i),    tisd_A_CLK(i));
    end generate A_Delay;

    ACIN_Delay : for i in MSB_ACIN downto 0 generate
        VitalSignalDelay (ACIN_dly(i),     ACIN_ipd(i),    tisd_ACIN_CLK(i));
    end generate ACIN_Delay;

    ALUMODE_Delay : for i in MSB_ALUMODE downto 0 generate
        VitalSignalDelay (ALUMODE_dly(i),     ALUMODE_ipd(i),    tisd_ALUMODE_CLK(i));
    end generate ALUMODE_Delay;

    B_Delay : for i in MSB_B downto 0 generate
        VitalSignalDelay (B_dly(i),     B_ipd(i),    tisd_B_CLK(i));
    end generate B_Delay;

    BCIN_Delay : for i in MSB_BCIN downto 0 generate
        VitalSignalDelay (BCIN_dly(i),     BCIN_ipd(i),    tisd_BCIN_CLK(i));
    end generate BCIN_Delay;

    C_Delay : for i in MSB_C downto 0 generate
        VitalSignalDelay (C_dly(i),     C_ipd(i),    tisd_C_CLK(i));
    end generate C_Delay;

    VitalSignalDelay (CARRYCASCIN_dly,    CARRYCASCIN_ipd,    tisd_CARRYCASCIN_CLK);

    VitalSignalDelay (CARRYIN_dly,    CARRYIN_ipd,    tisd_CARRYIN_CLK);

    CARRYINSEL_Delay : for i in MSB_CARRYINSEL downto 0 generate
        VitalSignalDelay (CARRYINSEL_dly(i),     CARRYINSEL_ipd(i),    tisd_CARRYINSEL_CLK(i));
    end generate CARRYINSEL_Delay;

    VitalSignalDelay (CEA1_dly,       CEA1_ipd,        tisd_CEA1_CLK);
    VitalSignalDelay (CEA2_dly,       CEA2_ipd,        tisd_CEA2_CLK);
    VitalSignalDelay (CEALUMODE_dly,  CEALUMODE_ipd,   tisd_CEALUMODE_CLK);
    VitalSignalDelay (CEB1_dly,       CEB1_ipd,        tisd_CEB1_CLK);
    VitalSignalDelay (CEB2_dly,       CEB2_ipd,        tisd_CEB2_CLK);
    VitalSignalDelay (CEC_dly,        CEC_ipd,        tisd_CEC_CLK);
    VitalSignalDelay (CECARRYIN_dly,  CECARRYIN_ipd,  tisd_CECARRYIN_CLK);
    VitalSignalDelay (CECTRL_dly,     CECTRL_ipd,     tisd_CECTRL_CLK);
    VitalSignalDelay (CEM_dly,        CEM_ipd,        tisd_CEM_CLK);
    VitalSignalDelay (CEMULTCARRYIN_dly,        CEMULTCARRYIN_ipd,        tisd_CEMULTCARRYIN_CLK);
    VitalSignalDelay (CEP_dly,        CEP_ipd,        tisd_CEP_CLK);

    VitalSignalDelay (CLK_dly,        CLK_ipd,        ticd_CLK);
    VitalSignalDelay (MULTSIGNIN_dly, MULTSIGNIN_ipd, tisd_MULTSIGNIN_CLK);

    OPMODE_Delay : for i in MSB_OPMODE downto 0 generate
        VitalSignalDelay (OPMODE_dly(i),     OPMODE_ipd(i),    tisd_OPMODE_CLK(i));
    end generate OPMODE_Delay;

    PCIN_Delay : for i in MSB_PCIN downto 0 generate
        VitalSignalDelay (PCIN_dly(i),     PCIN_ipd(i),    tisd_PCIN_CLK(i));
    end generate PCIN_Delay;

    VitalSignalDelay (RSTA_dly,       RSTA_ipd,       tisd_RSTA_CLK);
    VitalSignalDelay (RSTALLCARRYIN_dly,   RSTALLCARRYIN_ipd,   tisd_RSTALLCARRYIN_CLK);
    VitalSignalDelay (RSTALUMODE_dly,      RSTALUMODE_ipd,      tisd_RSTALUMODE_CLK);
    VitalSignalDelay (RSTB_dly,       RSTB_ipd,       tisd_RSTB_CLK);
    VitalSignalDelay (RSTC_dly,       RSTC_ipd,       tisd_RSTC_CLK);
    VitalSignalDelay (RSTCTRL_dly,    RSTCTRL_ipd,    tisd_RSTCTRL_CLK);
    VitalSignalDelay (RSTM_dly,       RSTM_ipd,       tisd_RSTM_CLK);
    VitalSignalDelay (RSTP_dly,       RSTP_ipd,       tisd_RSTP_CLK);


  end block;

  --------------------
  --  BEHAVIOR SECTION
  --------------------


--####################################################################
--#####                        Initialization                      ###
--####################################################################
 prcs_init:process
  begin

----------- Checks for AREG ----------------------
    case AREG is
      when 0|1|2 =>
      when others =>
         assert false
         report "Attribute Syntax Error: The allowed values for AREG are 0 or 1 or 2"
         severity Failure;
    end case;

----------- Checks for ACASCREG and (ACASCREG vs AREG) ----------------------
      
    case AREG is
      when 0 => if(AREG /= ACASCREG) then
              assert false
              report "Attribute Syntax Error : The attribute ACASCREG on X_DSP48E has to be set to 0 when attribute AREG = 0."
              severity Failure;
           end if;
      when 1 => if(AREG /= ACASCREG) then
              assert false
              report "Attribute Syntax Error : The attribute ACASCREG on X_DSP48E has to be set to 1 when attribute AREG = 1."
              severity Failure;
           end if;
      when 2 => if((AREG /= ACASCREG) and ((AREG-1) /= ACASCREG))then
              assert false
              report "Attribute Syntax Error : The attribute ACASCREG on X_DSP48E has to be set to either 2 or 1 when attribute AREG = 2."
              severity Failure;
           end if;
      when others => null;
    end case;

----------- Checks for BREG ----------------------
    case BREG is
      when 0|1|2 =>
      when others =>
         assert false
         report "Attribute Syntax Error: The allowed values for BREG are 0 or 1 or 2"
         severity Failure;
    end case;

----------- Checks for BCASCREG and (BCASCREG vs BREG) ----------------------

    case BREG is
      when 0 => if(BREG /= BCASCREG) then
              assert false
              report "Attribute Syntax Error : The attribute BCASCREG on X_DSP48E has to be set to 0 when attribute BREG = 0."
              severity Failure;
           end if;
      when 1 => if(BREG /= BCASCREG) then
              assert false
              report "Attribute Syntax Error : The attribute BCASCREG on X_DSP48E has to be set to 1 when attribute BREG = 1."
              severity Failure;
           end if;
      when 2 => if((BREG /= BCASCREG) and ((BREG-1) /= BCASCREG))then
              assert false
              report "Attribute Syntax Error : The attribute BCASCREG on X_DSP48E has to be set to either 2 or 1 when attribute BREG = 2."
              severity Failure;
           end if;
      when others => null;
    end case;

----------- Check for AUTORESET_OVER_UNDER_FLOW ----------------------

--   case AUTORESET_OVER_UNDER_FLOW is
--      when true | false => null;
--      when others =>
--         assert false
--         report "Attribute Syntax Error: The allowed values for AUTORESET_OVER_UNDER_FLOW are true or fasle"
--         severity Failure;
--    end case;
         
----------- Check for AUTORESET_PATTERN_DETECT ----------------------

    case AUTORESET_PATTERN_DETECT is
      when true | false => null;
      when others =>
         assert false
         report "Attribute Syntax Error: The allowed values for AUTORESET_PATTERN_DETECT are true or fasle"
         severity Failure;
    end case;
         
----------- Check for AUTORESET_PATTERN_DETECT_OPTINV ----------------------

    if((AUTORESET_PATTERN_DETECT_OPTINV /="MATCH") and (AUTORESET_PATTERN_DETECT_OPTINV /="NOT_MATCH")) then
        assert false
        report "Attribute Syntax Error: The allowed values for AUTORESET_PATTERN_DETECT_OPTINV are MATCH or NOT_MATCH."
        severity Failure;
    end if;

----------- Check for USE_MULT ----------------------

     if((USE_MULT /="NONE") and (USE_MULT /="MULT") and
        (USE_MULT /="MULT_S")) then
        assert false
        report "Attribute Syntax Error: The allowed values for USE_MULT are NONE, MULT or MULT_S."
        severity Failure;
     elsif((USE_MULT ="MULT") and (MREG /= 0)) then
        assert false
        report "Attribute Syntax Error: The attribute USE_MULT on DSP48 is set to MULT. This requires attribute MREG to be set to 0."
        severity Failure;
     elsif((USE_MULT ="MULT_S") and (MREG /= 1)) then
        assert false
        report "Attribute Syntax Error: The attribute USE_MULT on DSP48 is set to MULT_S. This requires attribute MREG to be set to 1."
        severity Failure;
     end if;

----------- Check for USE_PATTERN_DETECT ----------------------

    if((USE_PATTERN_DETECT /="PATDET") and (USE_PATTERN_DETECT /="NO_PATDET")) then
        assert false
        report "Attribute Syntax Error: The allowed values for USE_PATTERN_DETECT are PATDET or NO_PATDET."
        severity Failure;
    end if;

--*********************************************************
--*** ADDITIONAL DRC
--*********************************************************
-- CR 219407  --  (1)
    if((AUTORESET_PATTERN_DETECT = TRUE) and (USE_PATTERN_DETECT = "NO_PATDET")) then
        assert false
        report "Attribute Syntax Error : The attribute USE_PATTERN_DETECT on X_DSP48E instance must be set to PATDET in order to use AUTORESET_PATTERN_DETECT equals TRUE. Failure to do so could make timing reports inaccurate. "
        severity Warning;
    end if;
------------------------------------------------------------
    ping_opmode_drc_check   <= '1' after 100010 ps;
------------------------------------------------------------

    wait;
  end process prcs_init;
--####################################################################
--#####    Input Register A with two levels of registers and a mux ###
--####################################################################
  prcs_a_in:process(A_dly, ACIN_dly)
  begin
     if(A_INPUT ="DIRECT") then
        a_o_mux <= A_dly;
     elsif(A_INPUT ="CASCADE") then
        a_o_mux <= ACIN_dly;
     else
        assert false
        report "Attribute Syntax Error: The allowed values for A_INPUT are DIRECT or CASCADE."
        severity Failure;
     end if;
  end process prcs_a_in;
------------------------------------------------------------------
  prcs_qa_2lvl:process(CLK_dly, GSR_dly)
  begin
      if(GSR_dly = '1') then
          qa_o_reg1 <= ( others => '0');
          qa_o_reg2 <= ( others => '0');
      elsif (GSR_dly = '0') then
         if(rising_edge(CLK_dly)) then
            if(RSTA_dly = '1') then
               qa_o_reg1 <= ( others => '0');
               qa_o_reg2 <= ( others => '0');
            elsif (RSTA_dly = '0') then
               case AREG is
                    when 1 =>
                       if(CEA2_dly = '1') then
                          qa_o_reg2 <= a_o_mux;
                       end if;
                    when 2 =>
                       if(CEA1_dly = '1') then
                          qa_o_reg1 <= a_o_mux;
                       end if;
                       if(CEA2_dly = '1') then
                          qa_o_reg2 <= qa_o_reg1;
                       end if;
                    when others => null;
               end case;
            end if;
         end if;
      end if;
  end process prcs_qa_2lvl;
------------------------------------------------------------------
  prcs_qa_o_mux:process(a_o_mux, qa_o_reg2)
  begin
     case AREG is
       when 0   => qa_o_mux <= a_o_mux;
       when 1|2 => qa_o_mux <= qa_o_reg2;
       when others =>
            assert false
            report "Attribute Syntax Error: The allowed values for AREG are 0 or 1 or 2"
            severity Failure;
     end case;
  end process prcs_qa_o_mux;
------------------------------------------------------------------
  prcs_qacout_o_mux:process(qa_o_mux, qa_o_reg1)
  begin
     case ACASCREG is
       when 1 => case AREG is
                   when 2 => qacout_o_mux <= qa_o_reg1;
                   when others =>  qacout_o_mux <= qa_o_mux;
                 end case;
       when others =>  qacout_o_mux <= qa_o_mux;
     end case;

  end process prcs_qacout_o_mux;
--####################################################################
--#####    Input Register B with two levels of registers and a mux ###
--####################################################################
 prcs_b_in:process(B_dly, BCIN_dly)
  begin
     if(B_INPUT ="DIRECT") then
        b_o_mux <= B_dly;
     elsif(B_INPUT ="CASCADE") then
        b_o_mux <= BCIN_dly;
     else
        assert false
        report "Attribute Syntax Error: The allowed values for B_INPUT are DIRECT or CASCADE."
        severity Failure;
     end if;
     
  end process prcs_b_in;
------------------------------------------------------------------
 prcs_qb_2lvl:process(CLK_dly, GSR_dly)
  begin
      if(GSR_dly = '1') then
          qb_o_reg1 <= ( others => '0');
          qb_o_reg2 <= ( others => '0');
      elsif (GSR_dly = '0') then
         if(rising_edge(CLK_dly)) then
            if(RSTB_dly = '1') then
               qb_o_reg1 <= ( others => '0');
               qb_o_reg2 <= ( others => '0');
            elsif (RSTB_dly = '0') then
               case BREG is
                    when 1 =>
                       if(CEB2_dly = '1') then
                          qb_o_reg2 <= b_o_mux;
                       end if;
                    when 2 =>
                       if(CEB1_dly = '1') then
                          qb_o_reg1 <= b_o_mux;
                       end if;
                       if(CEB2_dly = '1') then
                          qb_o_reg2 <= qb_o_reg1;
                       end if;
                    when others => null;
               end case;
            end if;
         end if;
      end if;
  end process prcs_qb_2lvl;
------------------------------------------------------------------
  prcs_qb_o_mux:process(b_o_mux, qb_o_reg2)
  begin
     case BREG is
       when 0   => qb_o_mux <= b_o_mux;
       when 1|2 => qb_o_mux <= qb_o_reg2;
       when others =>
            assert false
            report "Attribute Syntax Error: The allowed values for BREG are 0 or 1 or 2 "
            severity Failure;
     end case;

  end process prcs_qb_o_mux;
------------------------------------------------------------------
  prcs_qbcout_o_mux:process(qb_o_mux, qb_o_reg1)
  begin
     case BCASCREG is
       when 1 => case BREG is
                   when 2 => qbcout_o_mux <= qb_o_reg1;
                   when others =>  qbcout_o_mux <= qb_o_mux;
                 end case;
       when others =>  qbcout_o_mux <= qb_o_mux;
     end case;
  end process prcs_qbcout_o_mux;

--####################################################################
--#####    Input Register C with 0, 1, level of registers        #####
--####################################################################
  prcs_qc_1lvl:process(CLK_dly, GSR_dly)
  begin
      if(GSR_dly = '1') then
         qc_o_reg <= ( others => '0');
      elsif (GSR_dly = '0') then
         if(rising_edge(CLK_dly)) then
            if(RSTC_dly = '1') then
               qc_o_reg <= ( others => '0');
            elsif ((RSTC_dly = '0') and (CEC_dly = '1')) then
               qc_o_reg <= C_dly;
            end if;
         end if;
      end if;
  end process prcs_qc_1lvl;
------------------------------------------------------------------
  prcs_qc_o_mux:process(C_dly, qc_o_reg)
  begin
     case CREG is
      when 0 => qc_o_mux <= C_dly;
      when 1 => qc_o_mux <= qc_o_reg;
      when others =>
           assert false
           report "Attribute Syntax Error: The allowed values for CREG are 0 or 1"
           severity Failure;
      end case;
  end process prcs_qc_o_mux;

--####################################################################
--###################      25x18 Multiplier     ######################
--####################################################################
--
-- 05/26/05 -- FP -- Added warning for invalid mult when USE_MULT=NONE
-- SIMD=FOUR12 and SIMD=TWO24
-- Made mult_o to be "X"
--
  prcs_mult:process(qa_o_mux, qb_o_mux)
  begin
     if(USE_MULT /= "NONE") then
        mult_o_int <=  qa_o_mux(MSB_A_MULT downto 0) * qb_o_mux (MSB_B_MULT downto 0);
     end if;
  end process prcs_mult;
------------------------------------------------------------------
  prcs_mult_reg:process(CLK_dly, GSR_dly)
  begin
      if(GSR_dly = '1') then
         mult_o_reg <= ( others => '0');
      elsif (GSR_dly = '0') then
         if(rising_edge(CLK_dly)) then
            if(RSTM_dly = '1') then
               mult_o_reg <= ( others => '0');
            elsif ((RSTM_dly = '0') and (CEM_dly = '1')) then
               mult_o_reg <= mult_o_int;
            end if;
         end if;
      end if;
  end process prcs_mult_reg;
------------------------------------------------------------------
  prcs_mult_mux:process(mult_o_reg, mult_o_int)
  begin
     case MREG is
      when 0 => mult_o_mux <= mult_o_int;
      when 1 => mult_o_mux <= mult_o_reg;
      when others =>
           assert false
           report "Attribute Syntax Error: The allowed values for MREG are 0 or 1"
           severity Failure;
      end case;
  end process prcs_mult_mux;

--####################################################################
--#####                        OpMode                            #####
--####################################################################
  prcs_opmode_reg:process(CLK_dly, GSR_dly)
  begin
      if(GSR_dly = '1') then
         opmode_o_reg <= ( others => '0');
      elsif (GSR_dly = '0') then
         if(rising_edge(CLK_dly)) then
            if(RSTCTRL_dly = '1') then
               opmode_o_reg <= ( others => '0');
            elsif ((RSTCTRL_dly = '0') and (CECTRL_dly = '1')) then
               opmode_o_reg <= OPMODE_dly;
            end if;
         end if;
      end if;
  end process prcs_opmode_reg;
------------------------------------------------------------------
  prcs_opmode_mux:process(opmode_o_reg, OPMODE_dly)
  begin
     case OPMODEREG is
      when 0 => opmode_o_mux <= OPMODE_dly;
      when 1 => opmode_o_mux <= opmode_o_reg;
      when others =>
           assert false
           report "Attribute Syntax Error: The allowed values for OPMODEREG are 0 or 1"
           severity Failure;
      end case;
  end process prcs_opmode_mux;
--####################################################################
--#####                        MUX_XYZ                           #####
--####################################################################
  prcs_mux_xyz:process(opmode_o_mux, qp_o_mux, qa_o_mux, qb_o_mux, mult_o_mux, 
                       qc_o_mux, PCIN_dly, output_x_sig, MULTSIGNIN_dly)
  begin
    if(output_x_sig = '1') then
      muxx_o_mux(MSB_P downto 0) <= ( others => 'X');
      muxy_o_mux(MSB_P downto 0) <= ( others => 'X');
      muxz_o_mux(MSB_P downto 0) <= ( others => 'X');
    elsif(output_x_sig = '0') then
    --MUX_X -----
       case opmode_o_mux(1 downto 0) is
         when "00" => muxx_o_mux <= ( others => '0');
         -- FP ?? sign extend needed from 43rd bit to 48th bit 
         when "01" => muxx_o_mux((MSB_A_MULT + MSB_B_MULT +1) downto 0) <= mult_o_mux;
                   if(mult_o_mux(MSB_A_MULT + MSB_B_MULT + 1) = '1') then
                     muxx_o_mux(MSB_PCIN downto (MAX_A_MULT + MAX_B_MULT)) <=  ( others => '1');
                   elsif (mult_o_mux(MSB_A_MULT + MSB_B_MULT + 1) = '0') then
                     muxx_o_mux(MSB_PCIN downto (MAX_A_MULT + MAX_B_MULT)) <=  ( others => '0');
                   end if;
         when "10" => muxx_o_mux <= qp_o_mux;

-- CR 438456  & CR 448147 & CR 451453
         when "11" => if((USE_MULT = "MULT_S") and (AREG=0 or BREG=0)) then 
                          muxx_o_mux(MSB_P downto 0) <=  ( others => 'X');  
                          assert false
                          report "DRC warning: When attribute USE_MULT on DSP48E instance %m is set to MULT_S, the A:B opmode selection is not permitted when AREG or BREG=0. If the multiplier is not used, set USE_MULT = NONE. For dynamic switching between multiply and add operation, set AREG and BREG=1 or MREG=0 and USE_MULT=MULT."
                          severity Warning;
                      else
                          muxx_o_mux(MSB_P downto 0)  <= (qa_o_mux & qb_o_mux);
                      end if;

         when others => null;
       end case;

    --MUX_Y -----
       case opmode_o_mux(3 downto 2) is
         when "00" => muxy_o_mux <= ( others => '0');
         when "01" => muxy_o_mux <= ( others => '0');
         when "10" => 
                     if(opmode_o_mux(6 downto 4) = "100") then
                        muxy_o_mux <= ( others => MULTSIGNIN_dly);
                     else
                        muxy_o_mux <= ( others => '1');
                     end if;
         when "11" => muxy_o_mux <= qc_o_mux;
         when others => null;
       end case;
    --MUX_Z -----
       case opmode_o_mux(6 downto 4) is
         when "000" => muxz_o_mux <= ( others => '0');
         when "001" => muxz_o_mux <= PCIN_dly;
         when "010" => muxz_o_mux <= qp_o_mux;
         when "011" => muxz_o_mux <= qc_o_mux;
         when "100" => muxz_o_mux <= qp_o_mux; -- Used for MACC extend -- multsignin
      -- FP ?? better shift possible ?
         when "101" => if(PCIN_dly(MSB_PCIN) = '0') then
                         muxz_o_mux  <= ( others => '0');
                       elsif(PCIN_dly(MSB_PCIN) = '1') then
                         muxz_o_mux  <= ( others => '1');
                       end if;
                       muxz_o_mux ((MSB_PCIN - SHIFT_MUXZ) downto 0) <= PCIN_dly(MSB_PCIN downto SHIFT_MUXZ ); 
         when "110" => if(qp_o_mux(MSB_P) = '0') then
                         muxz_o_mux  <= ( others => '0');
                       elsif(qp_o_mux(MSB_P) = '1') then
                         muxz_o_mux  <= ( others => '1');
                       end if;
                       muxz_o_mux ((MSB_P - SHIFT_MUXZ) downto 0) <= qp_o_mux(MSB_P downto SHIFT_MUXZ ); 
                      
         when "111" => null;
         when others => null;
       end case;
    end if;
  end process prcs_mux_xyz;
--####################################################################
--#####                        Alumode                          #####
--####################################################################
  prcs_alumode_reg:process(CLK_dly, GSR_dly)
  begin
      if(GSR_dly = '1') then
         alumode_o_reg <= ( others => '0');
      elsif (GSR_dly = '0') then
         if(rising_edge(CLK_dly)) then
            if(RSTALUMODE_dly = '1') then
               alumode_o_reg <= ( others => '0');
            elsif ((RSTALUMODE_dly = '0') and (CEALUMODE_dly = '1'))then
               alumode_o_reg <= ALUMODE_dly;
            end if;
         end if;
      end if;
  end process prcs_alumode_reg;
------------------------------------------------------------------
  prcs_alumode_mux:process(alumode_o_reg, ALUMODE_dly)
  begin
     case ALUMODEREG is
      when 0 => alumode_o_mux <= ALUMODE_dly;
      when 1 => alumode_o_mux <= alumode_o_reg;
      when others =>
           assert false
           report "Attribute Syntax Error: The allowed values for ALUMODEREG are 0 or 1"
           severity Failure;
      end case;
  end process prcs_alumode_mux;

--####################################################################
--#####                     CarryInSel                           #####
--####################################################################
  prcs_carryinsel_reg:process(CLK_dly, GSR_dly)
  begin
      if(GSR_dly = '1') then
         carryinsel_o_reg <= ( others => '0');
      elsif (GSR_dly = '0') then
         if(rising_edge(CLK_dly)) then
            if(RSTCTRL_dly = '1') then
               carryinsel_o_reg <= ( others => '0');
            elsif ((RSTCTRL_dly = '0') and (CECTRL_dly = '1')) then
               carryinsel_o_reg <= CARRYINSEL_dly;
            end if;
         end if;
      end if;
  end process prcs_carryinsel_reg;
------------------------------------------------------------------
  prcs_carryinsel_mux:process(carryinsel_o_reg, CARRYINSEL_dly)
  begin
     case CARRYINSELREG is
       when 0 => carryinsel_o_mux <= CARRYINSEL_dly;
       when 1 => carryinsel_o_mux <= carryinsel_o_reg;
       when others =>
           assert false
           report "Attribute Syntax Error: The allowed values for CARRYINSELREG are 0 or 1"
           severity Failure;
     end case;
  end process prcs_carryinsel_mux;

------------------------------------------------------------------
-- CR 219047 (3)

  prcs_carryinsel_drc:process(carryinsel_o_mux, MULTSIGNIN_dly, opmode_o_mux)
  begin
     if(carryinsel_o_mux = "010") then
        if(not((MULTSIGNIN_dly = 'X') or ((opmode_o_mux = "1001000") and (MULTSIGNIN_dly /= 'X')) 
                                 or ((MULTSIGNIN_dly = '0') and (CARRYCASCIN_dly = '0')))) then
           assert false
-- CR 451178 -- DRC warning Enhancement
           report "DRC warning : CARRYCASCIN can only be used in the current X_DSP48E instance if the previous X_DSP48E  is performing a two input ADD operation, or the current X_DSP48E is configured in the MAC extend opmode(6:0) equals 1001000. This warning can be also triggered if OPMODEREG is set to 1 and CARRYINSELREG is set to 0 - in which case please set CARRYINSELREG to 1."
           severity Warning;
        end if;
     end if;
  end process prcs_carryinsel_drc;

-- CR 219047 (4)
  prcs_carryinsel_mac_drc:process(carryinsel_o_mux)
  begin
     if((carryinsel_o_mux = "110")  and (MULTCARRYINREG /= MREG)) then
        assert false
        report "Attribute Syntax Warning : It is recommended that MREG and MULTCARRYINREG on X_DSP48E instance be set to the same value when using CARRYINSEL = 110 for multiply rounding. "
        severity Warning;
     end if;
  end process prcs_carryinsel_mac_drc;


--####################################################################
--#####                       CarryIn                            #####
--####################################################################

-------  input 0

  prcs_carryin_reg0:process(CLK_dly, GSR_dly)
  begin
      if(GSR_dly = '1') then
         qcarryin_o_reg0 <= '0';
      elsif (GSR_dly = '0') then
         if(rising_edge(CLK_dly)) then
            if(RSTALLCARRYIN_dly = '1') then
               qcarryin_o_reg0 <= '0';
            elsif((RSTALLCARRYIN_dly = '0') and (CECARRYIN_dly = '1')) then
               qcarryin_o_reg0 <= CARRYIN_dly;
            end if;
         end if;
      end if;
  end process prcs_carryin_reg0;

  prcs_carryin_mux0:process(qcarryin_o_reg0, CARRYIN_dly)
  begin
     case CARRYINREG is
       when 0 => carryin_o_mux0 <= CARRYIN_dly;
       when 1 => carryin_o_mux0 <= qcarryin_o_reg0;
       when others =>
            assert false
            report "Attribute Syntax Error: The allowed values for CARRYINREG are 0 or 1"
            severity Failure;
     end case;
  end process prcs_carryin_mux0;

------------------------------------------------------------------
-------  input 7

  prcs_carryin_reg7:process(CLK_dly, GSR_dly)
  begin
      if(GSR_dly = '1') then
         qcarryin_o_reg7 <= '0';
      elsif (GSR_dly = '0') then
         if(rising_edge(CLK_dly)) then
            if(RSTALLCARRYIN_dly = '1') then
               qcarryin_o_reg7 <= '0';
            elsif((RSTALLCARRYIN_dly = '0') and (CEMULTCARRYIN_dly = '1')) then
               qcarryin_o_reg7 <= qa_o_mux(24) XNOR qb_o_mux(17);
            end if;
         end if;
      end if;
  end process prcs_carryin_reg7;

  prcs_carryin_mux7:process(qa_o_mux(24), qb_o_mux(17), qcarryin_o_reg7)
  begin
     case MULTCARRYINREG is
       when 0 => carryin_o_mux7 <= qa_o_mux(24) XNOR qb_o_mux(17);
-- CR 232187
       when 1 => carryin_o_mux7 <= qcarryin_o_reg7;
       when others =>
            assert false
            report "Attribute Syntax Error: The allowed values for MULTCARRYINREG are 0 or 1"
            severity Failure;
     end case;
  end process prcs_carryin_mux7;

------------------------------------------------------------------
-- FP Check this with VV 
------------------------------------------------------------------
-- 
  prcs_carryin_mux:process(carryin_o_mux0, PCIN_dly(47), CARRYCASCIN_dly, carrycascout_o_mux, qp_o_mux(47), carryin_o_mux7, carryinsel_o_mux)
  begin
     case carryinsel_o_mux is
       when "000" => carryin_o_mux  <= carryin_o_mux0;
       when "001" => carryin_o_mux  <= NOT PCIN_dly(47);
       when "010" => carryin_o_mux  <= CARRYCASCIN_dly;
       when "011" => carryin_o_mux  <= PCIN_dly(47);
       when "100" => carryin_o_mux  <= carrycascout_o_mux;
       when "101" => carryin_o_mux  <= NOT qp_o_mux(47);
       when "110" => carryin_o_mux  <= carryin_o_mux7;
       when "111" => carryin_o_mux  <= qp_o_mux(47);
       when others => null;
     end case;
  end process prcs_carryin_mux;
--####################################################################
--#####                         ALU                              #####
--####################################################################
  prcs_alu:process(muxx_o_mux, muxy_o_mux, muxz_o_mux, alumode_o_mux, opmode_o_mux, carryin_o_mux, output_x_sig)

  variable opmode_alu_var : std_logic_vector(5 downto 0) := (others => '0');
  variable alu_full_tmp   : std_logic_vector(MAX_ALU_FULL downto 0) := (others => '0');
  variable alu_hlf1_tmp, alu_hlf2_tmp  : std_logic_vector(MAX_ALU_HALF downto 0) := (others => '0');
  variable alu_qrt1_tmp, alu_qrt2_tmp, alu_qrt3_tmp, alu_qrt4_tmp : std_logic_vector(MAX_ALU_QUART downto 0) := (others => '0');

  begin
     if(output_x_sig = '1') then
       alu_o <= (others => 'X');

     elsif(opmode_valid_flg) then
        opmode_alu_var := opmode_o_mux(3 downto 2) & alumode_o_mux;
        case opmode_alu_var is
           ---------------------------------
           ------------- ADD ---------------
           ---------------------------------
           when "000000" | "010000" | "100000" | "110000" => 

               AluFunction <= ADD_ALU;
               alumode_valid_flg <= true;

               if((USE_SIMD = "ONE48") or (USE_SIMD = "one48")) then
                  alu_full_tmp := (('0'&muxz_o_mux) + 
                                   ('0'&muxx_o_mux) + 
                                   ('0'&muxy_o_mux) + carryin_o_mux); 
                  alu_o <= alu_full_tmp(MSB_ALU_FULL downto 0);

                  carrycascout_o               <=  alu_full_tmp(MAX_ALU_FULL);
                  --  if multiply operation then "X"out the carryout
                  if((opmode_o_mux(1 downto 0) = "01") or (opmode_o_mux(3 downto 2) = "01")) then
                     carryout_o(MSB_CARRYOUT downto 0) <= (others => 'X');
                  else
                     carryout_o(MSB_CARRYOUT - 0) <=  alu_full_tmp(MAX_ALU_FULL);
                     carryout_o(MSB_CARRYOUT - 1) <=  'X';
                     carryout_o(MSB_CARRYOUT - 2) <=  'X';
                     carryout_o(MSB_CARRYOUT - 3) <=  'X';
                  end if;

               elsif((USE_SIMD = "TWO24") or (USE_SIMD = "two24")) then
                  alu_hlf1_tmp := (('0'&muxz_o_mux(((1*MAX_ALU_HALF)-1) downto 0)) +
                                  ('0'&muxx_o_mux(((1*MAX_ALU_HALF)-1) downto 0)) +
                                  ('0'&muxy_o_mux(((1*MAX_ALU_HALF)-1) downto 0)) +
                                  carryin_o_mux);
                  alu_hlf2_tmp := (('0'&muxz_o_mux(((2*MAX_ALU_HALF)-1) downto (1*MAX_ALU_HALF))) +
                                  ('0'&muxx_o_mux(((2*MAX_ALU_HALF)-1) downto (1*MAX_ALU_HALF))) +
                                  ('0'&muxy_o_mux(((2*MAX_ALU_HALF)-1) downto (1*MAX_ALU_HALF)))); 
                  alu_o <= (alu_hlf2_tmp(MSB_ALU_HALF downto 0) & alu_hlf1_tmp(MSB_ALU_HALF downto 0)) ;

                  carrycascout_o               <=  alu_hlf2_tmp(MAX_ALU_HALF);
                  --  if multiply operation then "X"out the carryout
                  if((opmode_o_mux(1 downto 0) = "01") or (opmode_o_mux(3 downto 2) = "01")) then
                     carryout_o(MSB_CARRYOUT downto 0) <= (others => 'X');
                  else
                     carryout_o(MSB_CARRYOUT - 0) <=  alu_hlf2_tmp(MAX_ALU_HALF);
                     carryout_o(MSB_CARRYOUT - 1) <=  'X';
                     carryout_o(MSB_CARRYOUT - 2) <=  alu_hlf1_tmp(MAX_ALU_HALF);
                     carryout_o(MSB_CARRYOUT - 3) <=  'X';
                  end if;

               elsif((USE_SIMD = "FOUR12") or (USE_SIMD = "four12")) then
                  alu_qrt1_tmp := (('0'&muxz_o_mux(((1*MAX_ALU_QUART)-1) downto 0)) +
                                  ('0'&muxx_o_mux(((1*MAX_ALU_QUART)-1) downto 0)) +
                                  ('0'&muxy_o_mux(((1*MAX_ALU_QUART)-1) downto 0)) +
                                  carryin_o_mux);
                  alu_qrt2_tmp := (('0'&muxz_o_mux(((2*MAX_ALU_QUART)-1) downto (1*MAX_ALU_QUART))) +
                                  ('0'&muxx_o_mux(((2*MAX_ALU_QUART)-1) downto (1*MAX_ALU_QUART))) +
                                  ('0'&muxy_o_mux(((2*MAX_ALU_QUART)-1) downto (1*MAX_ALU_QUART))));
                  alu_qrt3_tmp := (('0'&muxz_o_mux(((3*MAX_ALU_QUART)-1) downto (2*MAX_ALU_QUART))) +
                                  ('0'&muxx_o_mux(((3*MAX_ALU_QUART)-1) downto (2*MAX_ALU_QUART))) +
                                  ('0'&muxy_o_mux(((3*MAX_ALU_QUART)-1) downto (2*MAX_ALU_QUART))));
                  alu_qrt4_tmp := (('0'&muxz_o_mux(((4*MAX_ALU_QUART)-1) downto (3*MAX_ALU_QUART))) +
                                  ('0'&muxx_o_mux(((4*MAX_ALU_QUART)-1) downto (3*MAX_ALU_QUART))) +
                                  ('0'&muxy_o_mux(((4*MAX_ALU_QUART)-1) downto (3*MAX_ALU_QUART))));

                  alu_o <= (alu_qrt4_tmp(MSB_ALU_QUART downto 0) & alu_qrt3_tmp(MSB_ALU_QUART downto 0) &
                              alu_qrt2_tmp(MSB_ALU_QUART downto 0) & alu_qrt1_tmp(MSB_ALU_QUART downto 0));

                  carrycascout_o               <=  alu_qrt4_tmp(MAX_ALU_QUART);
                  --  if multiply operation then "X"out the carryout
                  if((opmode_o_mux(1 downto 0) = "01") or (opmode_o_mux(3 downto 2) = "01")) then
                     carryout_o(MSB_CARRYOUT downto 0) <= (others => 'X');
                  else
                     carryout_o(MSB_CARRYOUT - 0) <=  alu_qrt4_tmp(MAX_ALU_QUART);
                     carryout_o(MSB_CARRYOUT - 1) <=  alu_qrt3_tmp(MAX_ALU_QUART);
                     carryout_o(MSB_CARRYOUT - 2) <=  alu_qrt2_tmp(MAX_ALU_QUART);
                     carryout_o(MSB_CARRYOUT - 3) <=  alu_qrt1_tmp(MAX_ALU_QUART);
                  end if;

               else
                  assert false
                  report "Attribute Syntax Error: The legal values for USE_SIMD are ONE48 or TWO24 or FOUR12."
                  severity Failure;
               end if;

           ---------------------------------
           ------ SUBTRACT (X + ~Z ) ---- carryin must be 1 ---------------
           ---------------------------------
           when "000001" | "010001" | "100001" | "110001" => 

               AluFunction <= ADD_XY_NOTZ_ALU;
               alumode_valid_flg <= true;

               if((USE_SIMD = "ONE48") or (USE_SIMD = "one48")) then
                  alu_full_tmp := NOT('0'&muxz_o_mux) + 
                                   ('0'&muxx_o_mux) + 
                                   ('0'&muxy_o_mux) + carryin_o_mux; 
                  alu_o <= alu_full_tmp(MSB_ALU_FULL downto 0);

                  carrycascout_o               <=  NOT alu_full_tmp(MAX_ALU_FULL);
                  --  if multiply operation then "X"out the carryout
                  if((opmode_o_mux(1 downto 0) = "01") or (opmode_o_mux(3 downto 2) = "01")) then
                     carryout_o(MSB_CARRYOUT downto 0) <= (others => 'X');
                  else
                     carryout_o(MSB_CARRYOUT - 0) <=  NOT alu_full_tmp(MAX_ALU_FULL);
                     carryout_o(MSB_CARRYOUT - 1) <=  'X';
                     carryout_o(MSB_CARRYOUT - 2) <=  'X';
                     carryout_o(MSB_CARRYOUT - 3) <=  'X';
                  end if;

               elsif((USE_SIMD = "TWO24") or (USE_SIMD = "two24")) then
                  alu_hlf1_tmp := NOT('0'&muxz_o_mux(((1*MAX_ALU_HALF)-1) downto 0)) +
                                  ('0'&muxx_o_mux(((1*MAX_ALU_HALF)-1) downto 0)) +
                                  ('0'&muxy_o_mux(((1*MAX_ALU_HALF)-1) downto 0)) +
                                  carryin_o_mux;
                  alu_hlf2_tmp := NOT('0'&muxz_o_mux(((2*MAX_ALU_HALF)-1) downto (1*MAX_ALU_HALF))) +
                                  ('0'&muxx_o_mux(((2*MAX_ALU_HALF)-1) downto (1*MAX_ALU_HALF))) +
                                  ('0'&muxy_o_mux(((2*MAX_ALU_HALF)-1) downto (1*MAX_ALU_HALF)));

                  alu_o <= (alu_hlf2_tmp(MSB_ALU_HALF downto 0) & alu_hlf1_tmp(MSB_ALU_HALF downto 0)) ;

                  carrycascout_o               <=  NOT alu_hlf2_tmp(MAX_ALU_HALF);
                  --  if multiply operation then "X"out the carryout
                  if((opmode_o_mux(1 downto 0) = "01") or (opmode_o_mux(3 downto 2) = "01")) then
                     carryout_o(MSB_CARRYOUT downto 0) <= (others => 'X');
                  else
                     carryout_o(MSB_CARRYOUT - 0) <=  NOT alu_hlf2_tmp(MAX_ALU_HALF);
                     carryout_o(MSB_CARRYOUT - 1) <=  'X';
                     carryout_o(MSB_CARRYOUT - 2) <=  NOT alu_hlf1_tmp(MAX_ALU_HALF);
                     carryout_o(MSB_CARRYOUT - 3) <=  'X';
                  end if;

               elsif((USE_SIMD = "FOUR12") or (USE_SIMD = "four12")) then
                  alu_qrt1_tmp := NOT('0'&muxz_o_mux(((1*MAX_ALU_QUART)-1) downto 0)) +
                                  ('0'&muxx_o_mux(((1*MAX_ALU_QUART)-1) downto 0)) +
                                  ('0'&muxy_o_mux(((1*MAX_ALU_QUART)-1) downto 0)) +
                                  carryin_o_mux;
                  alu_qrt2_tmp := NOT('0'&muxz_o_mux(((2*MAX_ALU_QUART)-1) downto (1*MAX_ALU_QUART))) +
                                  ('0'&muxx_o_mux(((2*MAX_ALU_QUART)-1) downto (1*MAX_ALU_QUART))) +
                                  ('0'&muxy_o_mux(((2*MAX_ALU_QUART)-1) downto (1*MAX_ALU_QUART)));
                  alu_qrt3_tmp := NOT('0'&muxz_o_mux(((3*MAX_ALU_QUART)-1) downto (2*MAX_ALU_QUART))) +
                                  ('0'&muxx_o_mux(((3*MAX_ALU_QUART)-1) downto (2*MAX_ALU_QUART))) +
                                  ('0'&muxy_o_mux(((3*MAX_ALU_QUART)-1) downto (2*MAX_ALU_QUART)));
                  alu_qrt4_tmp := NOT('0'&muxz_o_mux(((4*MAX_ALU_QUART)-1) downto (3*MAX_ALU_QUART))) +
                                  ('0'&muxx_o_mux(((4*MAX_ALU_QUART)-1) downto (3*MAX_ALU_QUART))) +
                                  ('0'&muxy_o_mux(((4*MAX_ALU_QUART)-1) downto (3*MAX_ALU_QUART)));

                  alu_o <= (alu_qrt4_tmp(MSB_ALU_QUART downto 0) & alu_qrt3_tmp(MSB_ALU_QUART downto 0) &
                              alu_qrt2_tmp(MSB_ALU_QUART downto 0) & alu_qrt1_tmp(MSB_ALU_QUART downto 0));

                  carrycascout_o               <=  NOT alu_qrt4_tmp(MAX_ALU_QUART);
                  --  if multiply operation then "X"out the carryout
                  if((opmode_o_mux(1 downto 0) = "01") or (opmode_o_mux(3 downto 2) = "01")) then
                     carryout_o(MSB_CARRYOUT downto 0) <= (others => 'X');
                  else
                     carryout_o(MSB_CARRYOUT - 0) <=  NOT alu_qrt4_tmp(MAX_ALU_QUART);
                     carryout_o(MSB_CARRYOUT - 1) <=  NOT alu_qrt3_tmp(MAX_ALU_QUART);
                     carryout_o(MSB_CARRYOUT - 2) <=  NOT alu_qrt2_tmp(MAX_ALU_QUART);
                     carryout_o(MSB_CARRYOUT - 3) <=  NOT alu_qrt1_tmp(MAX_ALU_QUART);
                  end if;

               else
                  assert false
                  report "Attribute Syntax Error: The legal values for USE_SIMD are ONE48 or TWO24 or FOUR12."
                  severity Failure;
               end if;

           ---------------------------------
           ---------- NOT (X + Y + Z + C) ----------
           ---------------------------------
           when "000010" | "010010" | "100010" | "110010" => 

               AluFunction <= NOT_XYZC_ALU;
               alumode_valid_flg <= true;

               if((USE_SIMD = "ONE48") or (USE_SIMD = "one48")) then
                  alu_full_tmp := NOT((('0'&muxz_o_mux) + 
                                   ('0'&muxx_o_mux) + 
                                   ('0'&muxy_o_mux) + carryin_o_mux)); 

                  alu_o <= alu_full_tmp(MSB_ALU_FULL downto 0);

                  carrycascout_o               <=  NOT alu_full_tmp(MAX_ALU_FULL);
                  --  if multiply operation then "X"out the carryout
                  if((opmode_o_mux(1 downto 0) = "01") or (opmode_o_mux(3 downto 2) = "01")) then
                     carryout_o(MSB_CARRYOUT downto 0) <= (others => 'X');
                  else
                     carryout_o(MSB_CARRYOUT - 0) <=  NOT alu_full_tmp(MAX_ALU_FULL);
                     carryout_o(MSB_CARRYOUT - 1) <=  'X';
                     carryout_o(MSB_CARRYOUT - 2) <=  'X';
                     carryout_o(MSB_CARRYOUT - 3) <=  'X';
                  end if;

               elsif((USE_SIMD = "TWO24") or (USE_SIMD = "two24")) then
                  alu_hlf1_tmp := NOT((('0'&muxz_o_mux(((1*MAX_ALU_HALF)-1) downto 0)) +
                                  ('0'&muxx_o_mux(((1*MAX_ALU_HALF)-1) downto 0)) +
                                  ('0'&muxy_o_mux(((1*MAX_ALU_HALF)-1) downto 0)) +
                                  carryin_o_mux));
                  alu_hlf2_tmp := NOT((('0'&muxz_o_mux(((2*MAX_ALU_HALF)-1) downto (1*MAX_ALU_HALF))) +
                                  ('0'&muxx_o_mux(((2*MAX_ALU_HALF)-1) downto (1*MAX_ALU_HALF))) +
                                  ('0'&muxy_o_mux(((2*MAX_ALU_HALF)-1) downto (1*MAX_ALU_HALF)))));

                  alu_o <= (alu_hlf2_tmp(MSB_ALU_HALF downto 0) & alu_hlf1_tmp(MSB_ALU_HALF downto 0)) ;

                  carrycascout_o               <=  NOT alu_hlf2_tmp(MAX_ALU_HALF);
                  --  if multiply operation then "X"out the carryout
                  if((opmode_o_mux(1 downto 0) = "01") or (opmode_o_mux(3 downto 2) = "01")) then
                     carryout_o(MSB_CARRYOUT downto 0) <= (others => 'X');
                  else
                     carryout_o(MSB_CARRYOUT - 0) <=  NOT alu_hlf2_tmp(MAX_ALU_HALF);
                     carryout_o(MSB_CARRYOUT - 1) <=  'X';
                     carryout_o(MSB_CARRYOUT - 2) <=  NOT alu_hlf1_tmp(MAX_ALU_HALF);
                     carryout_o(MSB_CARRYOUT - 3) <=  'X';
                  end if;

               elsif((USE_SIMD = "FOUR12") or (USE_SIMD = "four12")) then
                  alu_qrt1_tmp := NOT((('0'&muxz_o_mux(((1*MAX_ALU_QUART)-1) downto 0)) +
                                  ('0'&muxx_o_mux(((1*MAX_ALU_QUART)-1) downto 0)) +
                                  ('0'&muxy_o_mux(((1*MAX_ALU_QUART)-1) downto 0)) +
                                  carryin_o_mux));
                  alu_qrt2_tmp := NOT((('0'&muxz_o_mux(((2*MAX_ALU_QUART)-1) downto (1*MAX_ALU_QUART))) +
                                  ('0'&muxx_o_mux(((2*MAX_ALU_QUART)-1) downto (1*MAX_ALU_QUART))) +
                                  ('0'&muxy_o_mux(((2*MAX_ALU_QUART)-1) downto (1*MAX_ALU_QUART)))));
                  alu_qrt3_tmp := NOT((('0'&muxz_o_mux(((3*MAX_ALU_QUART)-1) downto (2*MAX_ALU_QUART))) +
                                  ('0'&muxx_o_mux(((3*MAX_ALU_QUART)-1) downto (2*MAX_ALU_QUART))) +
                                  ('0'&muxy_o_mux(((3*MAX_ALU_QUART)-1) downto (2*MAX_ALU_QUART)))));
                  alu_qrt4_tmp := NOT((('0'&muxz_o_mux(((4*MAX_ALU_QUART)-1) downto (3*MAX_ALU_QUART))) +
                                  ('0'&muxx_o_mux(((4*MAX_ALU_QUART)-1) downto (3*MAX_ALU_QUART))) +
                                  ('0'&muxy_o_mux(((4*MAX_ALU_QUART)-1) downto (3*MAX_ALU_QUART)))));

                  alu_o <= (alu_qrt4_tmp(MSB_ALU_QUART downto 0) & alu_qrt3_tmp(MSB_ALU_QUART downto 0) &
                              alu_qrt2_tmp(MSB_ALU_QUART downto 0) & alu_qrt1_tmp(MSB_ALU_QUART downto 0));

                  carrycascout_o               <=  NOT alu_qrt4_tmp(MAX_ALU_QUART);
                  --  if multiply operation then "X"out the carryout
                  if((opmode_o_mux(1 downto 0) = "01") or (opmode_o_mux(3 downto 2) = "01")) then
                     carryout_o(MSB_CARRYOUT downto 0) <= (others => 'X');
                  else
                     carryout_o(MSB_CARRYOUT - 0) <=  NOT alu_qrt4_tmp(MAX_ALU_QUART);
                     carryout_o(MSB_CARRYOUT - 1) <=  NOT alu_qrt3_tmp(MAX_ALU_QUART);
                     carryout_o(MSB_CARRYOUT - 2) <=  NOT alu_qrt2_tmp(MAX_ALU_QUART);
                     carryout_o(MSB_CARRYOUT - 3) <=  NOT alu_qrt1_tmp(MAX_ALU_QUART);
                  end if;

               else
                  assert false
                  report "Attribute Syntax Error: The legal values for USE_SIMD are ONE48 or TWO24 or FOUR12."
                  severity Failure;
               end if;

           ---------------------------------
           ------- SUBTRACT (Z - X ) -------
           ---------------------------------
           when "000011" | "010011" | "100011" | "110011"=> 
               AluFunction <= SUBTRACT_ALU;
               alumode_valid_flg <= true;

               if((USE_SIMD = "ONE48") or (USE_SIMD = "one48")) then
                  alu_full_tmp := (('0'&muxz_o_mux) - 
                                   (('0'&muxx_o_mux) + 
                                   ('0'&muxy_o_mux) + carryin_o_mux)); 

                  alu_o <= alu_full_tmp(MSB_ALU_FULL downto 0);

                  carrycascout_o               <=  alu_full_tmp(MAX_ALU_FULL);
                  --  if multiply operation then "X"out the carryout
                  if((opmode_o_mux(1 downto 0) = "01") or (opmode_o_mux(3 downto 2) = "01")) then
                     carryout_o(MSB_CARRYOUT downto 0) <= (others => 'X');
                  else
                     carryout_o(MSB_CARRYOUT - 0) <=  NOT alu_full_tmp(MAX_ALU_FULL);
                     carryout_o(MSB_CARRYOUT - 1) <=  'X';
                     carryout_o(MSB_CARRYOUT - 2) <=  'X';
                     carryout_o(MSB_CARRYOUT - 3) <=  'X';
                  end if;

               elsif((USE_SIMD = "TWO24") or (USE_SIMD = "two24")) then
                  alu_hlf1_tmp := (('0'&muxz_o_mux(((1*MAX_ALU_HALF)-1) downto 0)) -
                                  (('0'&muxx_o_mux(((1*MAX_ALU_HALF)-1) downto 0)) +
                                  ('0'&muxy_o_mux(((1*MAX_ALU_HALF)-1) downto 0)) +
                                  carryin_o_mux));
                  alu_hlf2_tmp := (('0'&muxz_o_mux(((2*MAX_ALU_HALF)-1) downto (1*MAX_ALU_HALF))) -
                                  (('0'&muxx_o_mux(((2*MAX_ALU_HALF)-1) downto (1*MAX_ALU_HALF))) +
                                  ('0'&muxy_o_mux(((2*MAX_ALU_HALF)-1) downto (1*MAX_ALU_HALF)))));

                  alu_o <= (alu_hlf2_tmp(MSB_ALU_HALF downto 0) & alu_hlf1_tmp(MSB_ALU_HALF downto 0)) ;

                  carrycascout_o               <=  alu_hlf2_tmp(MAX_ALU_HALF);
                  --  if multiply operation then "X"out the carryout
                  if((opmode_o_mux(1 downto 0) = "01") or (opmode_o_mux(3 downto 2) = "01")) then
                     carryout_o(MSB_CARRYOUT downto 0) <= (others => 'X');
                  else
                     carryout_o(MSB_CARRYOUT - 0) <=  NOT alu_hlf2_tmp(MAX_ALU_HALF);
                     carryout_o(MSB_CARRYOUT - 1) <=  'X';
                     carryout_o(MSB_CARRYOUT - 2) <=  NOT alu_hlf1_tmp(MAX_ALU_HALF);
                     carryout_o(MSB_CARRYOUT - 3) <=  'X';
                  end if;

               elsif((USE_SIMD = "FOUR12") or (USE_SIMD = "four12")) then
                  alu_qrt1_tmp := (('0'&muxz_o_mux(((1*MAX_ALU_QUART)-1) downto 0)) -
                                  (('0'&muxx_o_mux(((1*MAX_ALU_QUART)-1) downto 0)) +
                                  ('0'&muxy_o_mux(((1*MAX_ALU_QUART)-1) downto 0)) +
                                  carryin_o_mux));
                  alu_qrt2_tmp := (('0'&muxz_o_mux(((2*MAX_ALU_QUART)-1) downto (1*MAX_ALU_QUART))) -
                                  (('0'&muxx_o_mux(((2*MAX_ALU_QUART)-1) downto (1*MAX_ALU_QUART))) +
                                  ('0'&muxy_o_mux(((2*MAX_ALU_QUART)-1) downto (1*MAX_ALU_QUART)))));
                  alu_qrt3_tmp := (('0'&muxz_o_mux(((3*MAX_ALU_QUART)-1) downto (2*MAX_ALU_QUART))) -
                                  (('0'&muxx_o_mux(((3*MAX_ALU_QUART)-1) downto (2*MAX_ALU_QUART))) +
                                  ('0'&muxy_o_mux(((3*MAX_ALU_QUART)-1) downto (2*MAX_ALU_QUART)))));
                  alu_qrt4_tmp := (('0'&muxz_o_mux(((4*MAX_ALU_QUART)-1) downto (3*MAX_ALU_QUART))) -
                                  (('0'&muxx_o_mux(((4*MAX_ALU_QUART)-1) downto (3*MAX_ALU_QUART))) +
                                  ('0'&muxy_o_mux(((4*MAX_ALU_QUART)-1) downto (3*MAX_ALU_QUART)))));

                  alu_o <= (alu_qrt4_tmp(MSB_ALU_QUART downto 0) & alu_qrt3_tmp(MSB_ALU_QUART downto 0) &
                              alu_qrt2_tmp(MSB_ALU_QUART downto 0) & alu_qrt1_tmp(MSB_ALU_QUART downto 0));

                  carrycascout_o               <=  alu_qrt4_tmp(MAX_ALU_QUART);
                  --  if multiply operation then "X"out the carryout
                  if((opmode_o_mux(1 downto 0) = "01") or (opmode_o_mux(3 downto 2) = "01")) then
                     carryout_o(MSB_CARRYOUT downto 0) <= (others => 'X');
                  else
                     carryout_o(MSB_CARRYOUT - 0) <=  NOT alu_qrt4_tmp(MAX_ALU_QUART);
                     carryout_o(MSB_CARRYOUT - 1) <=  NOT alu_qrt3_tmp(MAX_ALU_QUART);
                     carryout_o(MSB_CARRYOUT - 2) <=  NOT alu_qrt2_tmp(MAX_ALU_QUART);
                     carryout_o(MSB_CARRYOUT - 3) <=  NOT alu_qrt1_tmp(MAX_ALU_QUART);
                  end if;

               else
                  assert false
                  report "Attribute Syntax Error: The legal values for USE_SIMD are ONE48 or TWO24 or FOUR12."
                  severity Failure;
               end if;

           ---------------------------------
           ------------- XOR ---------------
           ---------------------------------
           when "000100" | "000111" | "100101" | "100110" =>
                AluFunction <= XOR_ALU;
                alumode_valid_flg <= true;
                alu_o <= muxx_o_mux xor muxz_o_mux; 
                carryout_o(MSB_CARRYOUT downto 0) <= (others => 'X');
                carrycascout_o <= 'X';

           ---------------------------------
           ------------- XNOR ---------------
           ---------------------------------
           when "000101" | "000110" | "100100" | "100111" =>
                AluFunction <= XNOR_ALU;
                alumode_valid_flg <= true;
                alu_o <= muxx_o_mux xnor muxz_o_mux; 
                carryout_o(MSB_CARRYOUT downto 0) <= (others => 'X');
                carrycascout_o <= 'X';

           ---------------------------------
           ------------- AND ---------------
           ---------------------------------
           when "001100" =>
                AluFunction <= AND_ALU;
                alumode_valid_flg <= true;
                alu_o <= muxx_o_mux and muxz_o_mux; 
                carryout_o(MSB_CARRYOUT downto 0) <= (others => 'X');
                carrycascout_o <= 'X';

           ---------------------------------
           --------- X AND (NOT Z) ---------
           ---------------------------------
           when "001101" =>
                AluFunction <= X_AND_NOT_Z_ALU;
                alumode_valid_flg <= true;
                alu_o <= muxx_o_mux and (not muxz_o_mux); 
                carryout_o(MSB_CARRYOUT downto 0) <= (others => 'X');
                carrycascout_o <= 'X';

           ---------------------------------
           ------------- NAND ---------------
           ---------------------------------
           when "001110" =>
                AluFunction <= NAND_ALU;
                alumode_valid_flg <= true;
                alu_o <= muxx_o_mux nand muxz_o_mux; 
                carryout_o(MSB_CARRYOUT downto 0) <= (others => 'X');
                carrycascout_o <= 'X';

           ---------------------------------
           -------- - (NOT X) OR Z ---------
           ---------------------------------
           when "001111" =>
                AluFunction <= NOT_X_OR_Z_ALU;
                alumode_valid_flg <= true;
                alu_o <= (not muxx_o_mux) or  muxz_o_mux; 
                carryout_o(MSB_CARRYOUT downto 0) <= (others => 'X');
                carrycascout_o <= 'X';

           ---------------------------------
           -------------- OR ---------------
           ---------------------------------
           when "101100" =>
                AluFunction <= OR_ALU;
                alumode_valid_flg <= true;
                alu_o <= muxx_o_mux or muxz_o_mux; 
                carryout_o(MSB_CARRYOUT downto 0) <= (others => 'X');
                carrycascout_o <= 'X';

           ---------------------------------
           --------- X OR (NOT Z) ---------
           ---------------------------------
           when "101101" =>
                AluFunction <= X_OR_NOT_Z_ALU;
                alumode_valid_flg <= true;
                alu_o <= muxx_o_mux or (not muxz_o_mux); 
                carryout_o(MSB_CARRYOUT downto 0) <= (others => 'X');
                carrycascout_o <= 'X';

           ---------------------------------
           ------------ X NOR Z ------------
           ---------------------------------
           when "101110" =>
                AluFunction <= X_NOR_Z_ALU;
                alumode_valid_flg <= true;
                alu_o <= muxx_o_mux nor  muxz_o_mux; 
                carryout_o(MSB_CARRYOUT downto 0) <= (others => 'X');
                carrycascout_o <= 'X';

           ---------------------------------
           --------- (NOT X) and Z ---------
           ---------------------------------
           when "101111" =>
                AluFunction <= NOT_X_AND_Z_ALU;
                alumode_valid_flg <= true;
                alu_o <= (not muxx_o_mux) and  muxz_o_mux; 
                carryout_o(MSB_CARRYOUT downto 0) <= (others => 'X');
                carrycascout_o <= 'X';


           when others => 
                AluFunction <= INVALID_ALU;
                alumode_valid_flg <= false;

                carryout_o(MSB_CARRYOUT downto 0) <= (others => 'X');
                carrycascout_o <= 'X';

        end case;
    end if;
  end process prcs_alu;
--####################################################################
--#####                CARRYOUT and CARRYCASCOUT                 #####
--####################################################################
  prcs_carry_reg:process(CLK_dly, GSR_dly)
  begin
      if(GSR_dly = '1') then
         carryout_o_reg     <=  ( others => '0');
         carrycascout_o_reg <=  '0';
      elsif (GSR_dly = '0') then
         if(rising_edge(CLK_dly)) then
            if((RSTP_dly = '1') or 
               ((AUTORESET_PATTERN_DETECT) and (
                ((AUTORESET_PATTERN_DETECT_OPTINV = "MATCH") and pdet_o_reg1 = '1') or 
                ((AUTORESET_PATTERN_DETECT_OPTINV = "NOT_MATCH") and (pdet_o_reg2 = '1' and pdet_o_reg1 = '0')))
               )
              ) then
               carryout_o_reg     <= ( others => '0');
               carrycascout_o_reg <=  '0';
            elsif ((RSTP_dly = '0') and (CEP_dly = '1')) then
               carryout_o_reg <= carryout_o;
               carrycascout_o_reg <= carrycascout_o;
            end if;
         end if;
      end if;
  end process prcs_carry_reg;
------------------------------------------------------------------
  prcs_carryout_mux:process(carryout_o, carryout_o_reg)
  begin
     case PREG is
       when 0 => carryout_o_mux <= carryout_o;
       when 1 => carryout_o_mux <= carryout_o_reg;
       when others =>
           assert false
           report "Attribute Syntax Error: The allowed values for PREG are 0 or 1"
           severity Failure;
     end case;
   
  end process prcs_carryout_mux;

------------------------------------------------------------------
  prcs_carryout_x_o:process(carryout_o_mux)
  begin
     if(USE_SIMD = "ONE48") then
        carryout_x_o(3) <= carryout_o_mux(3);
     elsif(USE_SIMD = "TWO24") then
        carryout_x_o(3) <= carryout_o_mux(3);
        carryout_x_o(1) <= carryout_o_mux(1);
     elsif(USE_SIMD = "FOUR12") then
        carryout_x_o(3) <= carryout_o_mux(3);
        carryout_x_o(2) <= carryout_o_mux(2);
        carryout_x_o(1) <= carryout_o_mux(1);
        carryout_x_o(0) <= carryout_o_mux(0);
     end if;
  end process prcs_carryout_x_o;

------------------------------------------------------------------
  prcs_carrycascout_mux:process(carrycascout_o, carrycascout_o_reg)
  begin
     case PREG is
       when 0 => carrycascout_o_mux <= carrycascout_o;
       when 1 => carrycascout_o_mux <= carrycascout_o_reg;
       when others =>
           assert false
           report "Attribute Syntax Error: The allowed values for PREG are 0 or 1"
           severity Failure;
     end case;
   
  end process prcs_carrycascout_mux;
------------------------------------------------------------------
-- CR 219047 (2)
  prcs_multsignout_o_opmode:process(mult_o_mux(MSB_A_MULT+MSB_B_MULT+1), opmode_o_mux(3 downto 0))
  begin
    if(opmode_o_mux(3 downto 0) = "0101") then
       multsignout_o_opmode <= mult_o_mux(MSB_A_MULT+MSB_B_MULT+1);
    else
       multsignout_o_opmode <= 'X';
    end if;
  end process prcs_multsignout_o_opmode;

  prcs_multsignout_o_mux:process(multsignout_o_opmode, multsignout_o_reg)
  begin
     case PREG is
       when 0 => multsignout_o_mux <= multsignout_o_opmode;
-- CR 232275
       when 1 => multsignout_o_mux <= multsignout_o_reg;
       when others => null;
--           assert false
--           report "Attribute Syntax Error: The allowed values for PREG are 0 or 1"
--           severity Failure;
     end case;
   
  end process prcs_multsignout_o_mux;
--####################################################################
--####################################################################
--####################################################################
--#####                 PCOUT and MULTSIGNOUT                    #####
--####################################################################
  prcs_qp_reg:process(CLK_dly, GSR_dly)
  begin
      if(GSR_dly = '1') then
         qp_o_reg <=  ( others => '0');
         multsignout_o_reg <= '0';
      elsif (GSR_dly = '0') then
         if(rising_edge(CLK_dly)) then
            if((RSTP_dly = '1') or 
               ((AUTORESET_PATTERN_DETECT) and (
                ((AUTORESET_PATTERN_DETECT_OPTINV = "MATCH") and pdet_o_reg1 = '1') or 
                ((AUTORESET_PATTERN_DETECT_OPTINV = "NOT_MATCH") and (pdet_o_reg2 = '1' and pdet_o_reg1 = '0')))
               )
              ) then
               qp_o_reg <= ( others => '0');
               multsignout_o_reg <= '0';
            elsif ((RSTP_dly = '0') and (CEP_dly = '1')) then
               qp_o_reg <= alu_o;
-- CR 491227               multsignout_o_reg <= mult_o_reg((MSB_A_MULT+MSB_B_MULT+1));
               multsignout_o_reg <= multsignout_o_opmode;
            end if;
         end if;
      end if;
  end process prcs_qp_reg;
------------------------------------------------------------------
  prcs_qp_mux:process(alu_o, qp_o_reg)
  begin
     case PREG is
       when 0 => qp_o_mux <= alu_o;
       when 1 => qp_o_mux <= qp_o_reg;
       when others =>
           assert false
           report "Attribute Syntax Error: The allowed values for PREG are 0 or 1"
           severity Failure;
     end case;
   
  end process prcs_qp_mux;
--####################################################################
--#####                    Pattern Detector                      #####
--####################################################################
  prcs_sel_pattern_detect:process(alu_o, qc_o_mux)
  begin

     -- Select the pattern
     if((SEL_PATTERN = "PATTERN") or (SEL_PATTERN = "pattern")) then
         pattern_qp <= To_StdLogicVector(PATTERN);
     elsif((SEL_PATTERN = "C") or (SEL_PATTERN = "c")) then
         pattern_qp <= qc_o_mux;
     else 
         assert false
         report "Attribute Syntax Error: The attribute SEL_PATTERN on DSP48_ALU is incorrect. Legal values for this attribute are PATTERN or C"
         severity Failure;
     end if;

     -- Select the mask  -- if ROUNDING MASK set, use rounding mode, else use SEL_MASK
     if((SEL_ROUNDING_MASK = "SEL_MASK") or (SEL_ROUNDING_MASK = "sel_mask")) then
         if((SEL_MASK = "MASK") or (SEL_MASK = "mask")) then
             mask_qp <= To_StdLogicVector(MASK);
         elsif((SEL_MASK = "C") or (SEL_MASK = "c")) then
             mask_qp <= qc_o_mux;
         else
           assert false
           report "Attribute Syntax Error: The attribute SEL_MASK on DSP48_ALU is incorrect. Legal values for this attribute are MASK or C"
           severity Failure;
         end if;
     elsif((SEL_ROUNDING_MASK = "MODE1") or (SEL_ROUNDING_MASK = "mode1")) then
         mask_qp <=   To_StdLogicVector((To_bitvector( not qc_o_mux)) sla 1) ;
         mask_qp (0) <= '0';
     elsif((SEL_ROUNDING_MASK = "MODE2") or (SEL_ROUNDING_MASK = "mode2")) then
         mask_qp <=   To_StdLogicVector((To_bitvector( not qc_o_mux)) sla 2) ;
         mask_qp (1 downto 0) <= (others => '0');
     else
         assert false
         report "Attribute Syntax Error: The attribute SEL_ROUNDING_MASK on DSP48_ALU is incorrect. Legal values for this attribute are SEL_MASK or MODE1 or MODE2."
         severity Failure;
     end if;
     
  end process prcs_sel_pattern_detect;


---------------------------------------------------------------

  prcs_pdet:process(alu_o, mask_qp, pattern_qp, GSR_dly )
  variable x_found : boolean := false;
  variable lhs     : std_logic_vector(MSB_P downto 0) := (others => '0');
  variable rhs     : std_logic_vector(MSB_P downto 0) := (others => '0');

  begin

  --   CR 501854

       lhs := (alu_o or mask_qp);
       rhs := (pattern_qp or mask_qp);

       x_found := find_x(lhs, rhs);
 
       if(((alu_o or mask_qp) = (pattern_qp or mask_qp)) and (GSR_dly = '0') and (not x_found))then 
          pdet_o <= '1';
       else
          pdet_o <= '0';
       end if;

       if(((alu_o or mask_qp) = ((NOT pattern_qp) or mask_qp)) and (GSR_dly = '0') and (not x_found)) then 
          pdetb_o <= '1';
       else
          pdetb_o <= '0';
       end if;

  end process prcs_pdet;

---------------------------------------------------------------

  prcs_pdet_reg:process(CLK_dly, GSR_dly)
  variable pdetb_reg1_var, pdetb_reg2_var, pdet_reg1_var, pdet_reg2_var : std_ulogic := '0';  
  begin
      if(GSR_dly = '1') then
         pdetb_o_reg1 <= '0';
         pdetb_o_reg2 <= '0';
         pdet_o_reg1  <= '0';
         pdet_o_reg2  <= '0';

         pdetb_reg1_var := '0';
         pdetb_reg2_var := '0';
         pdet_reg1_var  := '0';
         pdet_reg2_var  := '0';
      elsif (GSR_dly = '0') then
         if(rising_edge(CLK_dly)) then
            if((RSTP_dly = '1') or 
               ((AUTORESET_PATTERN_DETECT) and (
                ((AUTORESET_PATTERN_DETECT_OPTINV = "MATCH") and pdet_o_reg1 = '1') or 
                ((AUTORESET_PATTERN_DETECT_OPTINV = "NOT_MATCH") and (pdet_o_reg2 = '1' and pdet_o_reg1 = '0')))
               )
              ) then
               pdetb_o_reg1 <= '0';
               pdetb_o_reg2 <= '0';
               pdet_o_reg1  <= '0';
               pdet_o_reg2  <= '0';

               pdetb_reg1_var := '0';
               pdetb_reg2_var := '0';
               pdet_reg1_var  := '0';
               pdet_reg2_var  := '0';
            elsif ((RSTP_dly = '0') and (CEP_dly = '1')) then
               pdetb_reg2_var := pdetb_reg1_var;
               pdetb_reg1_var := pdetb_o;

               pdet_reg2_var := pdet_reg1_var;
               pdet_reg1_var := pdet_o;

               pdetb_o_reg1 <= pdetb_reg1_var;
               pdetb_o_reg2 <= pdetb_reg2_var;
               pdet_o_reg1  <= pdet_reg1_var;
               pdet_o_reg2  <= pdet_reg2_var;

            end if;
         end if;
      end if;
  end process prcs_pdet_reg;

--####################################################################
--#####                 Underflow / Overflow                     #####
--####################################################################
  prcs_uflow_oflow:process(pdet_o_reg1 , pdet_o_reg2 , pdetb_o_reg1 , pdetb_o_reg2)
  begin
--    if(((AUTORESET_PATTERN_DETECT) and (
--       ((AUTORESET_PATTERN_DETECT_OPTINV = "MATCH") and (pdet_o_reg1 = '1'))  or
--       ((AUTORESET_PATTERN_DETECT_OPTINV = "NOT_MATCH") and ((pdet_o_reg2 = '1') and (pdet_o_reg1 = '0'))))
--      )) then
--       underflow_o <= '0';
--       overflow_o  <= '0';
--    else
--       overflow_o  <= pdet_o_reg2   AND  (NOT pdet_o_reg1)  AND  (NOT pdetb_o_reg1);
--       underflow_o <= pdetb_o_reg2  AND  (NOT pdet_o_reg1)  AND (NOT pdetb_o_reg1);
--    end if;
    if(GSR_dly = '1') then
        overflow_o  <= '0';
        underflow_o <= '0';
    elsif(USE_PATTERN_DETECT = "NO_PATDET") then
        overflow_o  <= 'X';
        underflow_o <= 'X';
    elsif(PREG = 0) then
          overflow_o  <= 'X';
          underflow_o <= 'X';
    elsif(PREG = 1) then
          overflow_o  <= pdet_o_reg2   AND  (NOT pdet_o_reg1)  AND  (NOT pdetb_o_reg1);
          underflow_o <= pdetb_o_reg2  AND  (NOT pdet_o_reg1)  AND (NOT pdetb_o_reg1);
    end if;

  end process prcs_uflow_oflow;
--####################################################################
--#####                 OPMODE DRC                               #####
--####################################################################
  prcs_opmode_drc:process(ping_opmode_drc_check, alumode_o_mux, opmode_o_mux, carryinsel_o_mux)
  variable Message : line;
  variable invalid_opmode_flg : boolean := true;
  variable opmode_valid_var : boolean := true;
  variable opmode_carryinsel_var : std_logic_vector(9 downto 0) := (others => '0');
  begin
      opmode_carryinsel_var := opmode_o_mux & carryinsel_o_mux(MSB_CARRYINSEL downto 0);
      case alumode_o_mux(3 downto 2) is
-----------------------------------------
--        ARITHMETIC MODES DRC         --
-----------------------------------------
         when "00" => 
            case opmode_carryinsel_var is
               when "0000000000" => 
                          OPMODE_NUMBER <= 1;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "0000010000" => 
                          OPMODE_NUMBER <= 3;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0000010010" => 
                          OPMODE_NUMBER <= 4;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
-- CR 455601 eased the following two 
               when "0000010101" => 
                          OPMODE_NUMBER <= 50;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0000010111" => 
                          OPMODE_NUMBER <= 50;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
--
               when "0000011000" => 
                          OPMODE_NUMBER <= 7;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "0000011010" => 
                          OPMODE_NUMBER <= 8;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "0000011100" => 
                          OPMODE_NUMBER <= 9;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "0000101000" => 
                          OPMODE_NUMBER <= 13;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "0001000000" => 
                          OPMODE_NUMBER <= 15;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "0001010000" => 
                          OPMODE_NUMBER <= 17;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0001010010" => 
                          OPMODE_NUMBER <= 18;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0001011000" => 
                          OPMODE_NUMBER <= 21;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "0001011010" => 
                          OPMODE_NUMBER <= 22;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "0001011100" => 
                          OPMODE_NUMBER <= 23;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "0001100000" => 
                          OPMODE_NUMBER <= 27;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "0001100010" => 
                          OPMODE_NUMBER <= 28;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "0001100100" => 
                          OPMODE_NUMBER <= 29;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "0001110000" => 
                          OPMODE_NUMBER <= 33;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0001110010" => 
                          OPMODE_NUMBER <= 34;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0001110101" => 
                          OPMODE_NUMBER <= 37;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0001110111" => 
                          OPMODE_NUMBER <= 37;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0001111000" => 
                          OPMODE_NUMBER <= 38;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "0001111010" => 
                          OPMODE_NUMBER <= 39;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "0001111100" => 
                          OPMODE_NUMBER <= 40;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "0010000000" => 
                          OPMODE_NUMBER <= 46;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "0010010000" => 
                          OPMODE_NUMBER <= 48;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0010010101" => 
                          OPMODE_NUMBER <= 50;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0010010111" => 
                          OPMODE_NUMBER <= 50;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0010011000" => 
                          OPMODE_NUMBER <= 51;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "0010011001" => 
                          OPMODE_NUMBER <= 53;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "0010011011" => 
                          OPMODE_NUMBER <= 53;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "0010101000" => 
                          OPMODE_NUMBER <= 55;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "0010101001" => 
                          OPMODE_NUMBER <= 57;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "0010101011" => 
                          OPMODE_NUMBER <= 57;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "0010101110" => 
                          OPMODE_NUMBER <= 58;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "0011000000" => 
                          OPMODE_NUMBER <= 59;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "0011010000" => 
                          OPMODE_NUMBER <= 61;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0011010101" => 
                          OPMODE_NUMBER <= 63;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0011010111" => 
                          OPMODE_NUMBER <= 63;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0011011000" => 
                          OPMODE_NUMBER <= 64;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "0011011001" => 
                          OPMODE_NUMBER <= 66;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "0011011011" => 
                          OPMODE_NUMBER <= 66;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "0011100000" => 
                          OPMODE_NUMBER <= 68;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "0011100001" => 
                          OPMODE_NUMBER <= 70;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "0011100011" => 
                          OPMODE_NUMBER <= 70;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "0011110000" => 
                          OPMODE_NUMBER <= 72;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0011110101" => 
                          OPMODE_NUMBER <= 74;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0011110111" => 
                          OPMODE_NUMBER <= 74;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0011110001" => 
                          OPMODE_NUMBER <= 75;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0011110011" => 
                          OPMODE_NUMBER <= 75;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0011111000" => 
                          OPMODE_NUMBER <= 77;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "0011111001" => 
                          OPMODE_NUMBER <= 79;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "0011111011" => 
                          OPMODE_NUMBER <= 79;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "0100000000" => 
                          OPMODE_NUMBER <= 82;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0100000010" => 
                          OPMODE_NUMBER <= 83;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0100010000" => 
                          OPMODE_NUMBER <= 86;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0100010010" => 
                          OPMODE_NUMBER <= 87;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0100011000" => 
                          OPMODE_NUMBER <= 90;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0100011010" => 
                          OPMODE_NUMBER <= 91;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0100011101" => 
                          OPMODE_NUMBER <= 94;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0100011111" => 
                          OPMODE_NUMBER <= 94;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0100101000" => 
                          OPMODE_NUMBER <= 95;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0100101101" => 
                          OPMODE_NUMBER <= 97;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0100101111" => 
                          OPMODE_NUMBER <= 97;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0101000000" => 
                          OPMODE_NUMBER <= 98;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0101000010" => 
                          OPMODE_NUMBER <= 99;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0101010000" => 
                          OPMODE_NUMBER <= 102;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0101011000" => 
                          OPMODE_NUMBER <= 104;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0101011101" => 
                          OPMODE_NUMBER <= 106;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0101011111" => 
                          OPMODE_NUMBER <= 106;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0101100000" => 
                          OPMODE_NUMBER <= 107;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0101100010" => 
                          OPMODE_NUMBER <= 108;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0101100101" => 
                          OPMODE_NUMBER <= 111;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0101100111" => 
                          OPMODE_NUMBER <= 111;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0101110000" => 
                          OPMODE_NUMBER <= 112;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0101110101" => 
                          OPMODE_NUMBER <= 114;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0101110111" => 
                          OPMODE_NUMBER <= 114;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0101111000" => 
                          OPMODE_NUMBER <= 115;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0101111101" => 
                          OPMODE_NUMBER <= 117;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0101111111" => 
                          OPMODE_NUMBER <= 117;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0110000000" => 
                          OPMODE_NUMBER <= 120;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "0110000010" => 
                          OPMODE_NUMBER <= 121;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "0110000100" => 
                          OPMODE_NUMBER <= 122;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "0110010000" => 
                          OPMODE_NUMBER <= 126;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0110010010" => 
                          OPMODE_NUMBER <= 127;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0110010101" => 
                          OPMODE_NUMBER <= 130;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0110010111" => 
                          OPMODE_NUMBER <= 130;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0110011000" => 
                          OPMODE_NUMBER <= 131;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "0110011010" => 
                          OPMODE_NUMBER <= 132;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "0110011100" => 
                          OPMODE_NUMBER <= 133;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "0110101000" => 
                          OPMODE_NUMBER <= 139;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "0110101110" => 
                          OPMODE_NUMBER <= 141;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "0111000000" => 
                          OPMODE_NUMBER <= 143;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "0111000010" => 
                          OPMODE_NUMBER <= 144;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "0111000100" => 
                          OPMODE_NUMBER <= 145;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "0111010000" => 
                          OPMODE_NUMBER <= 149;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0111010101" => 
                          OPMODE_NUMBER <= 151;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0111010111" => 
                          OPMODE_NUMBER <= 151;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0111011000" => 
                          OPMODE_NUMBER <= 152;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "0111100000" => 
                          OPMODE_NUMBER <= 156;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "0111100010" => 
                          OPMODE_NUMBER <= 157;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "0111110000" => 
                          OPMODE_NUMBER <= 160;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0111111000" => 
                          OPMODE_NUMBER <= 162;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "1001000010" => 
                          OPMODE_NUMBER <= 165;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "1010000000" => 
                          OPMODE_NUMBER <= 167;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "1010010000" => 
                          OPMODE_NUMBER <= 169;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "1010010101" => 
                          OPMODE_NUMBER <= 171;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "1010010111" => 
                          OPMODE_NUMBER <= 171;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "1010011000" => 
                          OPMODE_NUMBER <= 172;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "1010011001" => 
                          OPMODE_NUMBER <= 174;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "1010011011" => 
                          OPMODE_NUMBER <= 174;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "1010101000" => 
                          OPMODE_NUMBER <= 176;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "1010101001" => 
                          OPMODE_NUMBER <= 178;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "1010101011" => 
                          OPMODE_NUMBER <= 178;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "1010101110" => 
                          OPMODE_NUMBER <= 179;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "1011000000" => 
                          OPMODE_NUMBER <= 180;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "1011010000" => 
                          OPMODE_NUMBER <= 182;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "1011010101" => 
                          OPMODE_NUMBER <= 184;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "1011010111" => 
                          OPMODE_NUMBER <= 184;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "1011011000" => 
                          OPMODE_NUMBER <= 185;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "1011011001" => 
                          OPMODE_NUMBER <= 187;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "1011011011" => 
                          OPMODE_NUMBER <= 187;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "1011100000" => 
                          OPMODE_NUMBER <= 189;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "1011100001" => 
                          OPMODE_NUMBER <= 191;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "1011100011" => 
                          OPMODE_NUMBER <= 191;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "1011110000" => 
                          OPMODE_NUMBER <= 193;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "1011110101" => 
                          OPMODE_NUMBER <= 195;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "1011110111" => 
                          OPMODE_NUMBER <= 195;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "1011110001" => 
                          OPMODE_NUMBER <= 197;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "1011110011" => 
                          OPMODE_NUMBER <= 197;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "1011111000" => 
                          OPMODE_NUMBER <= 198;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "1011111001" => 
                          OPMODE_NUMBER <= 200;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "1011111011" => 
                          OPMODE_NUMBER <= 200;
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "1100000000" => 
                          OPMODE_NUMBER <= 203;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "1100010000" => 
                          OPMODE_NUMBER <= 205;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "1100011000" => 
                          OPMODE_NUMBER <= 207;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "1100011101" => 
                          OPMODE_NUMBER <= 209;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "1100011111" => 
                          OPMODE_NUMBER <= 209;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "1100101000" => 
                          OPMODE_NUMBER <= 210;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "1100101101" => 
                          OPMODE_NUMBER <= 212;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "1100101111" => 
                          OPMODE_NUMBER <= 212;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "1101000000" => 
                          OPMODE_NUMBER <= 213;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "1101010000" => 
                          OPMODE_NUMBER <= 215;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "1101011000" => 
                          OPMODE_NUMBER <= 217;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "1101011101" => 
                          OPMODE_NUMBER <= 219;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "1101011111" => 
                          OPMODE_NUMBER <= 219;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "1101100000" => 
                          OPMODE_NUMBER <= 220;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "1101100101" => 
                          OPMODE_NUMBER <= 222;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "1101100111" => 
                          OPMODE_NUMBER <= 222;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "1101110000" => 
                          OPMODE_NUMBER <= 223;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "1101110101" => 
                          OPMODE_NUMBER <= 225;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "1101110111" => 
                          OPMODE_NUMBER <= 225;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "1101111000" => 
                          OPMODE_NUMBER <= 226;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "1101111101" => 
                          OPMODE_NUMBER <= 228;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "1101111111" => 
                          OPMODE_NUMBER <= 228;
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when others    =>
                          OPMODE_NUMBER <= -1;
                          if(invalid_opmode_flg = true) then
                             invalid_opmode_flg := false;
                             opmode_valid_var := false;
                             output_x_sig <= '1';
-- CR 444150
                             if((opmode_carryinsel_var = "0000000010") and ((OPMODEREG = 1) and (CARRYINSELREG = 0))) then
                                Write ( Message, string'("DRC Warning : The attribute CARRYINSELREG on DSP48E instance is set to 0. "));
                                Write ( Message, string'("It is required to have CARRYINSELREG be set to 1 to match OPMODEREG, "));
                                Write ( Message, string'("in order to ensure that the simulation model will match the hardware "));
                                Write ( Message, string'("behavior in all use cases."));
                                assert false report Message.all severity Warning;
                                DEALLOCATE (Message);
                             end if;

                             Write ( Message, string'("OPMODE Input Warning : The OPMODE "));
                             Write ( Message,  slv_to_str(opmode_o_mux));
                             Write ( Message, string'(" to DSP48E instance"));
                             Write ( Message, string'(" is either invalid or the CARRYINSEL "));
                             Write ( Message,  slv_to_str(carryinsel_o_mux));
                             Write ( Message, string'(" for that specific OPMODE is invalid. "));
                             Write ( Message, string'(" This error may be due to mismatch in the OPMODEREG "));
                             Write ( Message, string'(" and CARRYINSELREG attribute settings."));
                             Write ( Message, string'(" It is recommended that OPMODEREG and CARRYINSELREG always be set to the same value."));
                             assert false report Message.all severity Warning;
                             DEALLOCATE (Message);
                           end if;
            end case;
         when "01" | "11" => 
-----------------------------------------
--          LOGIC MODES DRC            --
-----------------------------------------
            case opmode_o_mux is
               when "0000000" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "0000010" => 
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg_logic(slv_to_str(opmode_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0000011" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "0010000" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "0010010" => 
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg_logic(slv_to_str(opmode_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0010011" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "0100000" => 
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg_logic(slv_to_str(opmode_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0100010" => 
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg_logic(slv_to_str(opmode_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0100011" => 
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg_logic(slv_to_str(opmode_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0110000" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "0110010" => 
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg_logic(slv_to_str(opmode_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0110011" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "1010000" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "1010010" => 
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg_logic(slv_to_str(opmode_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "1010011" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "1100000" => 
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg_logic(slv_to_str(opmode_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "1100010" => 
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg_logic(slv_to_str(opmode_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "1100011" => 
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg_logic(slv_to_str(opmode_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0001000" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "0001010" => 
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg_logic(slv_to_str(opmode_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0001011" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "0011000" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "0011010" => 
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg_logic(slv_to_str(opmode_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0011011" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "0101000" => 
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg_logic(slv_to_str(opmode_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0101010" => 
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg_logic(slv_to_str(opmode_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0101011" => 
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg_logic(slv_to_str(opmode_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0111000" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "0111010" => 
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg_logic(slv_to_str(opmode_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "0111011" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "1011000" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "1011010" => 
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg_logic(slv_to_str(opmode_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "1011011" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "1101000" => 
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg_logic(slv_to_str(opmode_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "1101010" => 
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg_logic(slv_to_str(opmode_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "1101011" => 
                          if (PREG /= 1) then
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg_logic(slv_to_str(opmode_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
                when others    =>
                          OPMODE_NUMBER <= -1;
                          if(invalid_opmode_flg = true) then
                             invalid_opmode_flg := false;
                             opmode_valid_var := false;
                             output_x_sig <= '1';
                             Write ( Message, string'("OPMODE Input Warning : The OPMODE "));
                             Write ( Message,  slv_to_str(opmode_o_mux));
                             Write ( Message, string'(" to DSP48E instance"));
                             Write ( Message, string'(" is invalid for ALU LOGIC modes."));
                             assert false report Message.all severity Warning;
                             DEALLOCATE (Message);
                           end if;
            end case;
         when others => null;
      end case;

      opmode_valid_flg <= opmode_valid_var;

  end process prcs_opmode_drc;
--####################################################################
--#####                   ZERO_DELAY_OUTPUTS                     #####
--####################################################################
  prcs_zero_delay_outputs:process(qacout_o_mux, qbcout_o_mux, carryout_x_o, carrycascout_o_mux,
                                  overflow_o, qp_o_mux, pdet_o, pdetb_o,
                                  pdet_o_reg1, pdetb_o_reg1,
                                  pdet_o_reg2, pdetb_o_reg2,
                                  underflow_o, multsignout_o_mux, opmode_valid_flg, alumode_valid_flg)
  begin
    ACOUT_zd          <= qacout_o_mux;
    BCOUT_zd          <= qbcout_o_mux;
    OVERFLOW_zd       <= overflow_o;
    UNDERFLOW_zd      <= underflow_o;
    P_zd              <= qp_o_mux;
    PCOUT_zd          <= qp_o_mux;
    MULTSIGNOUT_zd    <= multsignout_o_mux;

    if(((AUTORESET_PATTERN_DETECT) and (
       ((AUTORESET_PATTERN_DETECT_OPTINV = "MATCH") and (pdet_o_reg1 = '1'))  or
       ((AUTORESET_PATTERN_DETECT_OPTINV = "NOT_MATCH") and ((pdet_o_reg2 = '1') and (pdet_o_reg1 = '0'))))
      )) then
      CARRYCASCOUT_zd   <= '0';
      CARRYOUT_zd       <= (others => '0');
    else
      CARRYCASCOUT_zd   <= carrycascout_o_mux;   
      CARRYOUT_zd       <= carryout_x_o; 
    end if;

    if((USE_PATTERN_DETECT = "NO_PATDET") or (not opmode_valid_flg) or (not alumode_valid_flg)) then
       PATTERNBDETECT_zd <= 'X';
       PATTERNDETECT_zd  <= 'X';
    elsif (PREG = 0) then
          PATTERNBDETECT_zd <= pdetb_o;
          PATTERNDETECT_zd  <= pdet_o;
    elsif(PREG = 1) then
          PATTERNBDETECT_zd <= pdetb_o_reg1;
          PATTERNDETECT_zd  <= pdet_o_reg1;
    end if;

  end process prcs_zero_delay_outputs;

--####################################################################
--#####                   TIMING CHECKS                          #####
--####################################################################
  prcs_tmngchk:process
--    variable P_GlitchData :  VitalGlitchDataArrayType (47 downto 0 );
--    variable PCOUT_GlitchData :  VitalGlitchDataArrayType (47 downto 0 );
--    variable BCOUT_GlitchData :  VitalGlitchDataArrayType (17 downto 0 );
--
      variable ACOUT_GlitchData		:  VitalGlitchDataArrayType (29 downto 0 );
      variable BCOUT_GlitchData		:  VitalGlitchDataArrayType (17 downto 0 );
      variable CARRYCASCOUT_GlitchData	:  VitalGlitchDataType;
      variable CARRYOUT_GlitchData	:  VitalGlitchDataArrayType (3 downto 0 );
      variable OVERFLOW_GlitchData	:  VitalGlitchDataType;
      variable P_GlitchData		:  VitalGlitchDataArrayType (47 downto 0 );
      variable PATTERNBDETECT_GlitchData	:  VitalGlitchDataType;
      variable PATTERNDETECT_GlitchData	:  VitalGlitchDataType;
      variable PCOUT_GlitchData		:  VitalGlitchDataArrayType (47 downto 0 );
      variable UNDERFLOW_GlitchData	:  VitalGlitchDataType;

      variable MULTSIGNOUT_GlitchData	:  VitalGlitchDataType;
--  Pin timing violations (clock input pins)

--  Pin Timing Violations (all input pins)

    variable Tmkr_A_CLK_posedge  : VitalTimingDataArrayType(29 downto 0 );
    variable Tviol_A_CLK_posedge : std_logic_vector(29 downto 0 ) := (others => '0');

    variable Tmkr_ACIN_CLK_posedge  : VitalTimingDataArrayType(29 downto 0 );
    variable Tviol_ACIN_CLK_posedge : std_logic_vector(29 downto 0 ) := (others => '0');

    variable Tmkr_ALUMODE_CLK_posedge  : VitalTimingDataArrayType(29 downto 0 );
    variable Tviol_ALUMODE_CLK_posedge : std_logic_vector(29 downto 0 ) := (others => '0');

    variable Tmkr_B_CLK_posedge  : VitalTimingDataArrayType(17 downto 0 );
    variable Tviol_B_CLK_posedge : std_logic_vector(17 downto 0 ) := (others => '0');

    variable Tmkr_BCIN_CLK_posedge  : VitalTimingDataArrayType(17 downto 0 );
    variable Tviol_BCIN_CLK_posedge : std_logic_vector(17 downto 0 ) := (others => '0');

    variable Tmkr_C_CLK_posedge  : VitalTimingDataArrayType(47 downto 0 );
    variable Tviol_C_CLK_posedge : std_logic_vector(47 downto 0 ) := (others => '0');

    variable Tmkr_CARRYCASCIN_CLK_posedge  : VitalTimingDataType := VitalTimingDataInit;
    variable Tviol_CARRYCASCIN_CLK_posedge : std_ulogic := '0';

    variable Tmkr_CARRYIN_CLK_posedge  : VitalTimingDataType := VitalTimingDataInit;
    variable Tviol_CARRYIN_CLK_posedge : std_ulogic := '0';

    variable Tmkr_CARRYINSEL_CLK_posedge  : VitalTimingDataArrayType(2 downto 0 );
    variable Tviol_CARRYINSEL_CLK_posedge : std_logic_vector(2 downto 0 ) := (others => '0');

    variable Tmkr_CEA1_CLK_posedge  : VitalTimingDataType := VitalTimingDataInit;
    variable Tviol_CEA1_CLK_posedge : std_ulogic := '0';

    variable Tmkr_CEA2_CLK_posedge  : VitalTimingDataType := VitalTimingDataInit;
    variable Tviol_CEA2_CLK_posedge : std_ulogic := '0';

    variable Tmkr_CEALUMODE_CLK_posedge  : VitalTimingDataType := VitalTimingDataInit;
    variable Tviol_CEALUMODE_CLK_posedge : std_ulogic := '0';

    variable Tmkr_CEB1_CLK_posedge  : VitalTimingDataType := VitalTimingDataInit;
    variable Tviol_CEB1_CLK_posedge : std_ulogic := '0';

    variable Tmkr_CEB2_CLK_posedge  : VitalTimingDataType := VitalTimingDataInit;
    variable Tviol_CEB2_CLK_posedge : std_ulogic := '0';

    variable Tmkr_CEC_CLK_posedge  : VitalTimingDataType := VitalTimingDataInit;
    variable Tviol_CEC_CLK_posedge : std_ulogic := '0';

    variable Tmkr_CECARRYIN_CLK_posedge  : VitalTimingDataType := VitalTimingDataInit;
    variable Tviol_CECARRYIN_CLK_posedge : std_ulogic := '0';

    variable Tmkr_CECTRL_CLK_posedge  : VitalTimingDataType := VitalTimingDataInit;
    variable Tviol_CECTRL_CLK_posedge : std_ulogic := '0';

    variable Tmkr_CEM_CLK_posedge  : VitalTimingDataType := VitalTimingDataInit;
    variable Tviol_CEM_CLK_posedge : std_ulogic := '0';

    variable Tmkr_CEP_CLK_posedge  : VitalTimingDataType := VitalTimingDataInit;
    variable Tviol_CEP_CLK_posedge : std_ulogic := '0';

    variable Tmkr_OPMODE_CLK_posedge  : VitalTimingDataArrayType(6 downto 0 );
    variable Tviol_OPMODE_CLK_posedge : std_logic_vector(6 downto 0 ) := (others => '0');

    variable Tmkr_PCIN_CLK_posedge  : VitalTimingDataArrayType(47 downto 0 );
    variable Tviol_PCIN_CLK_posedge : std_logic_vector(47 downto 0 ) := (others => '0');

    variable Tmkr_RSTA_CLK_posedge  : VitalTimingDataType := VitalTimingDataInit;
    variable Tviol_RSTA_CLK_posedge : std_ulogic := '0';

    variable Tmkr_RSTALUMODE_CLK_posedge  : VitalTimingDataType := VitalTimingDataInit;
    variable Tviol_RSTALUMODE_CLK_posedge : std_ulogic := '0';

    variable Tmkr_RSTB_CLK_posedge  : VitalTimingDataType := VitalTimingDataInit;
    variable Tviol_RSTB_CLK_posedge : std_ulogic := '0';

    variable Tmkr_RSTC_CLK_posedge  : VitalTimingDataType := VitalTimingDataInit;
    variable Tviol_RSTC_CLK_posedge : std_ulogic := '0';

    variable Tmkr_RSTALLCARRYIN_CLK_posedge  : VitalTimingDataType := VitalTimingDataInit;
    variable Tviol_RSTALLCARRYIN_CLK_posedge : std_ulogic := '0';

    variable Tmkr_RSTCTRL_CLK_posedge  : VitalTimingDataType := VitalTimingDataInit;
    variable Tviol_RSTCTRL_CLK_posedge : std_ulogic := '0';

    variable Tmkr_RSTM_CLK_posedge  : VitalTimingDataType := VitalTimingDataInit;
    variable Tviol_RSTM_CLK_posedge : std_ulogic := '0';

    variable Tmkr_RSTP_CLK_posedge  : VitalTimingDataType := VitalTimingDataInit;
    variable Tviol_RSTP_CLK_posedge : std_ulogic := '0';

    variable PInfo_CLK : VitalPeriodDataType := VitalPeriodDataInit;
    variable Pviol_CLK : std_ulogic := '0';

begin

--  Setup/Hold Check Violations (all input pins)

     if (TimingChecksOn) then
--=====  Vital SetupHold Checks for Bus signal A =====
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(0),
         TimingData           => Tmkr_A_CLK_posedge(0),
         TestSignal           => A_dly(0),
         TestSignalName       => "A(0)",
         TestDelay            => tisd_A_CLK(0),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(0),
         SetupLow             => tsetup_A_CLK_negedge_posedge(0),
         HoldHigh             => thold_A_CLK_posedge_posedge(0),
         HoldLow              => thold_A_CLK_negedge_posedge(0),
         CheckEnabled         => (((TO_X01((not RSTA_dly) and (CEA1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((AREG = 1) and (TO_X01(CEA2) = '1')) or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(1),
         TimingData           => Tmkr_A_CLK_posedge(1),
         TestSignal           => A_dly(1),
         TestSignalName       => "A(1)",
         TestDelay            => tisd_A_CLK(1),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(1),
         SetupLow             => tsetup_A_CLK_negedge_posedge(1),
         HoldHigh             => thold_A_CLK_posedge_posedge(1),
         HoldLow              => thold_A_CLK_negedge_posedge(1),
         CheckEnabled         => (((TO_X01((not RSTA_dly) and (CEA1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((AREG = 1) and (TO_X01(CEA2) = '1')) or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(2),
         TimingData           => Tmkr_A_CLK_posedge(2),
         TestSignal           => A_dly(2),
         TestSignalName       => "A(2)",
         TestDelay            => tisd_A_CLK(2),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(2),
         SetupLow             => tsetup_A_CLK_negedge_posedge(2),
         HoldHigh             => thold_A_CLK_posedge_posedge(2),
         HoldLow              => thold_A_CLK_negedge_posedge(2),
         CheckEnabled         => (((TO_X01((not RSTA_dly) and (CEA1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((AREG = 1) and (TO_X01(CEA2) = '1')) or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(3),
         TimingData           => Tmkr_A_CLK_posedge(3),
         TestSignal           => A_dly(3),
         TestSignalName       => "A(3)",
         TestDelay            => tisd_A_CLK(3),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(3),
         SetupLow             => tsetup_A_CLK_negedge_posedge(3),
         HoldHigh             => thold_A_CLK_posedge_posedge(3),
         HoldLow              => thold_A_CLK_negedge_posedge(3),
         CheckEnabled         => (((TO_X01((not RSTA_dly) and (CEA1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((AREG = 1) and (TO_X01(CEA2) = '1')) or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(4),
         TimingData           => Tmkr_A_CLK_posedge(4),
         TestSignal           => A_dly(4),
         TestSignalName       => "A(4)",
         TestDelay            => tisd_A_CLK(4),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(4),
         SetupLow             => tsetup_A_CLK_negedge_posedge(4),
         HoldHigh             => thold_A_CLK_posedge_posedge(4),
         HoldLow              => thold_A_CLK_negedge_posedge(4),
         CheckEnabled         => (((TO_X01((not RSTA_dly) and (CEA1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((AREG = 1) and (TO_X01(CEA2) = '1')) or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(5),
         TimingData           => Tmkr_A_CLK_posedge(5),
         TestSignal           => A_dly(5),
         TestSignalName       => "A(5)",
         TestDelay            => tisd_A_CLK(5),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(5),
         SetupLow             => tsetup_A_CLK_negedge_posedge(5),
         HoldHigh             => thold_A_CLK_posedge_posedge(5),
         HoldLow              => thold_A_CLK_negedge_posedge(5),
         CheckEnabled         => (((TO_X01((not RSTA_dly) and (CEA1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((AREG = 1) and (TO_X01(CEA2) = '1')) or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(6),
         TimingData           => Tmkr_A_CLK_posedge(6),
         TestSignal           => A_dly(6),
         TestSignalName       => "A(6)",
         TestDelay            => tisd_A_CLK(6),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(6),
         SetupLow             => tsetup_A_CLK_negedge_posedge(6),
         HoldHigh             => thold_A_CLK_posedge_posedge(6),
         HoldLow              => thold_A_CLK_negedge_posedge(6),
         CheckEnabled         => (((TO_X01((not RSTA_dly) and (CEA1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((AREG = 1) and (TO_X01(CEA2) = '1')) or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(7),
         TimingData           => Tmkr_A_CLK_posedge(7),
         TestSignal           => A_dly(7),
         TestSignalName       => "A(7)",
         TestDelay            => tisd_A_CLK(7),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(7),
         SetupLow             => tsetup_A_CLK_negedge_posedge(7),
         HoldHigh             => thold_A_CLK_posedge_posedge(7),
         HoldLow              => thold_A_CLK_negedge_posedge(7),
         CheckEnabled         => (((TO_X01((not RSTA_dly) and (CEA1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((AREG = 1) and (TO_X01(CEA2) = '1')) or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(8),
         TimingData           => Tmkr_A_CLK_posedge(8),
         TestSignal           => A_dly(8),
         TestSignalName       => "A(8)",
         TestDelay            => tisd_A_CLK(8),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(8),
         SetupLow             => tsetup_A_CLK_negedge_posedge(8),
         HoldHigh             => thold_A_CLK_posedge_posedge(8),
         HoldLow              => thold_A_CLK_negedge_posedge(8),
         CheckEnabled         => (((TO_X01((not RSTA_dly) and (CEA1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((AREG = 1) and (TO_X01(CEA2) = '1')) or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(9),
         TimingData           => Tmkr_A_CLK_posedge(9),
         TestSignal           => A_dly(9),
         TestSignalName       => "A(9)",
         TestDelay            => tisd_A_CLK(9),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(9),
         SetupLow             => tsetup_A_CLK_negedge_posedge(9),
         HoldHigh             => thold_A_CLK_posedge_posedge(9),
         HoldLow              => thold_A_CLK_negedge_posedge(9),
         CheckEnabled         => (((TO_X01((not RSTA_dly) and (CEA1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((AREG = 1) and (TO_X01(CEA2) = '1')) or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(10),
         TimingData           => Tmkr_A_CLK_posedge(10),
         TestSignal           => A_dly(10),
         TestSignalName       => "A(10)",
         TestDelay            => tisd_A_CLK(10),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(10),
         SetupLow             => tsetup_A_CLK_negedge_posedge(10),
         HoldHigh             => thold_A_CLK_posedge_posedge(10),
         HoldLow              => thold_A_CLK_negedge_posedge(10),
         CheckEnabled         => (((TO_X01((not RSTA_dly) and (CEA1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((AREG = 1) and (TO_X01(CEA2) = '1')) or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(11),
         TimingData           => Tmkr_A_CLK_posedge(11),
         TestSignal           => A_dly(11),
         TestSignalName       => "A(11)",
         TestDelay            => tisd_A_CLK(11),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(11),
         SetupLow             => tsetup_A_CLK_negedge_posedge(11),
         HoldHigh             => thold_A_CLK_posedge_posedge(11),
         HoldLow              => thold_A_CLK_negedge_posedge(11),
         CheckEnabled         => (((TO_X01((not RSTA_dly) and (CEA1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((AREG = 1) and (TO_X01(CEA2) = '1')) or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(12),
         TimingData           => Tmkr_A_CLK_posedge(12),
         TestSignal           => A_dly(12),
         TestSignalName       => "A(12)",
         TestDelay            => tisd_A_CLK(12),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(12),
         SetupLow             => tsetup_A_CLK_negedge_posedge(12),
         HoldHigh             => thold_A_CLK_posedge_posedge(12),
         HoldLow              => thold_A_CLK_negedge_posedge(12),
         CheckEnabled         => (((TO_X01((not RSTA_dly) and (CEA1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((AREG = 1) and (TO_X01(CEA2) = '1')) or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(13),
         TimingData           => Tmkr_A_CLK_posedge(13),
         TestSignal           => A_dly(13),
         TestSignalName       => "A(13)",
         TestDelay            => tisd_A_CLK(13),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(13),
         SetupLow             => tsetup_A_CLK_negedge_posedge(13),
         HoldHigh             => thold_A_CLK_posedge_posedge(13),
         HoldLow              => thold_A_CLK_negedge_posedge(13),
         CheckEnabled         => (((TO_X01((not RSTA_dly) and (CEA1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((AREG = 1) and (TO_X01(CEA2) = '1')) or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(14),
         TimingData           => Tmkr_A_CLK_posedge(14),
         TestSignal           => A_dly(14),
         TestSignalName       => "A(14)",
         TestDelay            => tisd_A_CLK(14),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(14),
         SetupLow             => tsetup_A_CLK_negedge_posedge(14),
         HoldHigh             => thold_A_CLK_posedge_posedge(14),
         HoldLow              => thold_A_CLK_negedge_posedge(14),
         CheckEnabled         => (((TO_X01((not RSTA_dly) and (CEA1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((AREG = 1) and (TO_X01(CEA2) = '1')) or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(15),
         TimingData           => Tmkr_A_CLK_posedge(15),
         TestSignal           => A_dly(15),
         TestSignalName       => "A(15)",
         TestDelay            => tisd_A_CLK(15),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(15),
         SetupLow             => tsetup_A_CLK_negedge_posedge(15),
         HoldHigh             => thold_A_CLK_posedge_posedge(15),
         HoldLow              => thold_A_CLK_negedge_posedge(15),
         CheckEnabled         => (((TO_X01((not RSTA_dly) and (CEA1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((AREG = 1) and (TO_X01(CEA2) = '1')) or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(16),
         TimingData           => Tmkr_A_CLK_posedge(16),
         TestSignal           => A_dly(16),
         TestSignalName       => "A(16)",
         TestDelay            => tisd_A_CLK(16),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(16),
         SetupLow             => tsetup_A_CLK_negedge_posedge(16),
         HoldHigh             => thold_A_CLK_posedge_posedge(16),
         HoldLow              => thold_A_CLK_negedge_posedge(16),
         CheckEnabled         => (((TO_X01((not RSTA_dly) and (CEA1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((AREG = 1) and (TO_X01(CEA2) = '1')) or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(17),
         TimingData           => Tmkr_A_CLK_posedge(17),
         TestSignal           => A_dly(17),
         TestSignalName       => "A(17)",
         TestDelay            => tisd_A_CLK(17),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(17),
         SetupLow             => tsetup_A_CLK_negedge_posedge(17),
         HoldHigh             => thold_A_CLK_posedge_posedge(17),
         HoldLow              => thold_A_CLK_negedge_posedge(17),
         CheckEnabled         => (((TO_X01((not RSTA_dly) and (CEA1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((AREG = 1) and (TO_X01(CEA2) = '1')) or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(18),
         TimingData           => Tmkr_A_CLK_posedge(18),
         TestSignal           => A_dly(18),
         TestSignalName       => "A(18)",
         TestDelay            => tisd_A_CLK(18),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(18),
         SetupLow             => tsetup_A_CLK_negedge_posedge(18),
         HoldHigh             => thold_A_CLK_posedge_posedge(18),
         HoldLow              => thold_A_CLK_negedge_posedge(18),
         CheckEnabled         => (((TO_X01((not RSTA_dly) and (CEA1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((AREG = 1) and (TO_X01(CEA2) = '1')) or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(19),
         TimingData           => Tmkr_A_CLK_posedge(19),
         TestSignal           => A_dly(19),
         TestSignalName       => "A(19)",
         TestDelay            => tisd_A_CLK(19),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(19),
         SetupLow             => tsetup_A_CLK_negedge_posedge(19),
         HoldHigh             => thold_A_CLK_posedge_posedge(19),
         HoldLow              => thold_A_CLK_negedge_posedge(19),
         CheckEnabled         => (((TO_X01((not RSTA_dly) and (CEA1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((AREG = 1) and (TO_X01(CEA2) = '1')) or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(20),
         TimingData           => Tmkr_A_CLK_posedge(20),
         TestSignal           => A_dly(20),
         TestSignalName       => "A(20)",
         TestDelay            => tisd_A_CLK(20),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(20),
         SetupLow             => tsetup_A_CLK_negedge_posedge(20),
         HoldHigh             => thold_A_CLK_posedge_posedge(20),
         HoldLow              => thold_A_CLK_negedge_posedge(20),
         CheckEnabled         => (((TO_X01((not RSTA_dly) and (CEA1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((AREG = 1) and (TO_X01(CEA2) = '1')) or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(21),
         TimingData           => Tmkr_A_CLK_posedge(21),
         TestSignal           => A_dly(21),
         TestSignalName       => "A(21)",
         TestDelay            => tisd_A_CLK(21),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(21),
         SetupLow             => tsetup_A_CLK_negedge_posedge(21),
         HoldHigh             => thold_A_CLK_posedge_posedge(21),
         HoldLow              => thold_A_CLK_negedge_posedge(21),
         CheckEnabled         => (((TO_X01((not RSTA_dly) and (CEA1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((AREG = 1) and (TO_X01(CEA2) = '1')) or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(22),
         TimingData           => Tmkr_A_CLK_posedge(22),
         TestSignal           => A_dly(22),
         TestSignalName       => "A(22)",
         TestDelay            => tisd_A_CLK(22),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(22),
         SetupLow             => tsetup_A_CLK_negedge_posedge(22),
         HoldHigh             => thold_A_CLK_posedge_posedge(22),
         HoldLow              => thold_A_CLK_negedge_posedge(22),
         CheckEnabled         => (((TO_X01((not RSTA_dly) and (CEA1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((AREG = 1) and (TO_X01(CEA2) = '1')) or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(23),
         TimingData           => Tmkr_A_CLK_posedge(23),
         TestSignal           => A_dly(23),
         TestSignalName       => "A(23)",
         TestDelay            => tisd_A_CLK(23),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(23),
         SetupLow             => tsetup_A_CLK_negedge_posedge(23),
         HoldHigh             => thold_A_CLK_posedge_posedge(23),
         HoldLow              => thold_A_CLK_negedge_posedge(23),
         CheckEnabled         => (((TO_X01((not RSTA_dly) and (CEA1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((AREG = 1) and (TO_X01(CEA2) = '1')) or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(24),
         TimingData           => Tmkr_A_CLK_posedge(24),
         TestSignal           => A_dly(24),
         TestSignalName       => "A(24)",
         TestDelay            => tisd_A_CLK(24),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(24),
         SetupLow             => tsetup_A_CLK_negedge_posedge(24),
         HoldHigh             => thold_A_CLK_posedge_posedge(24),
         HoldLow              => thold_A_CLK_negedge_posedge(24),
         CheckEnabled         => (((TO_X01((not RSTA_dly) and (CEA1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((AREG = 1) and (TO_X01(CEA2) = '1')) or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(25),
         TimingData           => Tmkr_A_CLK_posedge(25),
         TestSignal           => A_dly(25),
         TestSignalName       => "A(25)",
         TestDelay            => tisd_A_CLK(25),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(25),
         SetupLow             => tsetup_A_CLK_negedge_posedge(25),
         HoldHigh             => thold_A_CLK_posedge_posedge(25),
         HoldLow              => thold_A_CLK_negedge_posedge(25),
         CheckEnabled         => (((TO_X01((not RSTA_dly) and (CEA1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((AREG = 1) and (TO_X01(CEA2) = '1')) or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(26),
         TimingData           => Tmkr_A_CLK_posedge(26),
         TestSignal           => A_dly(26),
         TestSignalName       => "A(26)",
         TestDelay            => tisd_A_CLK(26),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(26),
         SetupLow             => tsetup_A_CLK_negedge_posedge(26),
         HoldHigh             => thold_A_CLK_posedge_posedge(26),
         HoldLow              => thold_A_CLK_negedge_posedge(26),
         CheckEnabled         => (((TO_X01((not RSTA_dly) and (CEA1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((AREG = 1) and (TO_X01(CEA2) = '1')) or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(27),
         TimingData           => Tmkr_A_CLK_posedge(27),
         TestSignal           => A_dly(27),
         TestSignalName       => "A(27)",
         TestDelay            => tisd_A_CLK(27),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(27),
         SetupLow             => tsetup_A_CLK_negedge_posedge(27),
         HoldHigh             => thold_A_CLK_posedge_posedge(27),
         HoldLow              => thold_A_CLK_negedge_posedge(27),
         CheckEnabled         => (((TO_X01((not RSTA_dly) and (CEA1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((AREG = 1) and (TO_X01(CEA2) = '1')) or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(28),
         TimingData           => Tmkr_A_CLK_posedge(28),
         TestSignal           => A_dly(28),
         TestSignalName       => "A(28)",
         TestDelay            => tisd_A_CLK(28),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(28),
         SetupLow             => tsetup_A_CLK_negedge_posedge(28),
         HoldHigh             => thold_A_CLK_posedge_posedge(28),
         HoldLow              => thold_A_CLK_negedge_posedge(28),
         CheckEnabled         => (((TO_X01((not RSTA_dly) and (CEA1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((AREG = 1) and (TO_X01(CEA2) = '1')) or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(29),
         TimingData           => Tmkr_A_CLK_posedge(29),
         TestSignal           => A_dly(29),
         TestSignalName       => "A(29)",
         TestDelay            => tisd_A_CLK(29),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(29),
         SetupLow             => tsetup_A_CLK_negedge_posedge(29),
         HoldHigh             => thold_A_CLK_posedge_posedge(29),
         HoldLow              => thold_A_CLK_negedge_posedge(29),
         CheckEnabled         => (((TO_X01((not RSTA_dly) and (CEA1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((AREG = 1) and (TO_X01(CEA2) = '1')) or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
--=====  Vital SetupHold Checks for Bus signal ACIN =====
       VitalSetupHoldCheck (
         Violation            => Tviol_ACIN_CLK_posedge(0),
         TimingData           => Tmkr_ACIN_CLK_posedge(0),
         TestSignal           => ACIN_dly(0),
         TestSignalName       => "ACIN(0)",
         TestDelay            => tisd_ACIN_CLK(0),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_ACIN_CLK_posedge_posedge(0),
         SetupLow             => tsetup_ACIN_CLK_negedge_posedge(0),
         HoldHigh             => thold_ACIN_CLK_posedge_posedge(0),
         HoldLow              => thold_ACIN_CLK_negedge_posedge(0),
         CheckEnabled         => (((TO_X01((not RSTA_dly) and (CEA1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((AREG = 1) and (TO_X01(CEA2) = '1')) or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_ACIN_CLK_posedge(1),
         TimingData           => Tmkr_ACIN_CLK_posedge(1),
         TestSignal           => ACIN_dly(1),
         TestSignalName       => "ACIN(1)",
         TestDelay            => tisd_ACIN_CLK(1),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_ACIN_CLK_posedge_posedge(1),
         SetupLow             => tsetup_ACIN_CLK_negedge_posedge(1),
         HoldHigh             => thold_ACIN_CLK_posedge_posedge(1),
         HoldLow              => thold_ACIN_CLK_negedge_posedge(1),
         CheckEnabled         => (((TO_X01((not RSTA_dly) and (CEA1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((AREG = 1) and (TO_X01(CEA2) = '1')) or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_ACIN_CLK_posedge(2),
         TimingData           => Tmkr_ACIN_CLK_posedge(2),
         TestSignal           => ACIN_dly(2),
         TestSignalName       => "ACIN(2)",
         TestDelay            => tisd_ACIN_CLK(2),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_ACIN_CLK_posedge_posedge(2),
         SetupLow             => tsetup_ACIN_CLK_negedge_posedge(2),
         HoldHigh             => thold_ACIN_CLK_posedge_posedge(2),
         HoldLow              => thold_ACIN_CLK_negedge_posedge(2),
         CheckEnabled         => (((TO_X01((not RSTA_dly) and (CEA1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((AREG = 1) and (TO_X01(CEA2) = '1')) or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_ACIN_CLK_posedge(3),
         TimingData           => Tmkr_ACIN_CLK_posedge(3),
         TestSignal           => ACIN_dly(3),
         TestSignalName       => "ACIN(3)",
         TestDelay            => tisd_ACIN_CLK(3),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_ACIN_CLK_posedge_posedge(3),
         SetupLow             => tsetup_ACIN_CLK_negedge_posedge(3),
         HoldHigh             => thold_ACIN_CLK_posedge_posedge(3),
         HoldLow              => thold_ACIN_CLK_negedge_posedge(3),
         CheckEnabled         => (((TO_X01((not RSTA_dly) and (CEA1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((AREG = 1) and (TO_X01(CEA2) = '1')) or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_ACIN_CLK_posedge(4),
         TimingData           => Tmkr_ACIN_CLK_posedge(4),
         TestSignal           => ACIN_dly(4),
         TestSignalName       => "ACIN(4)",
         TestDelay            => tisd_ACIN_CLK(4),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_ACIN_CLK_posedge_posedge(4),
         SetupLow             => tsetup_ACIN_CLK_negedge_posedge(4),
         HoldHigh             => thold_ACIN_CLK_posedge_posedge(4),
         HoldLow              => thold_ACIN_CLK_negedge_posedge(4),
         CheckEnabled         => (((TO_X01((not RSTA_dly) and (CEA1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((AREG = 1) and (TO_X01(CEA2) = '1')) or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_ACIN_CLK_posedge(5),
         TimingData           => Tmkr_ACIN_CLK_posedge(5),
         TestSignal           => ACIN_dly(5),
         TestSignalName       => "ACIN(5)",
         TestDelay            => tisd_ACIN_CLK(5),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_ACIN_CLK_posedge_posedge(5),
         SetupLow             => tsetup_ACIN_CLK_negedge_posedge(5),
         HoldHigh             => thold_ACIN_CLK_posedge_posedge(5),
         HoldLow              => thold_ACIN_CLK_negedge_posedge(5),
         CheckEnabled         => (((TO_X01((not RSTA_dly) and (CEA1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((AREG = 1) and (TO_X01(CEA2) = '1')) or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_ACIN_CLK_posedge(6),
         TimingData           => Tmkr_ACIN_CLK_posedge(6),
         TestSignal           => ACIN_dly(6),
         TestSignalName       => "ACIN(6)",
         TestDelay            => tisd_ACIN_CLK(6),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_ACIN_CLK_posedge_posedge(6),
         SetupLow             => tsetup_ACIN_CLK_negedge_posedge(6),
         HoldHigh             => thold_ACIN_CLK_posedge_posedge(6),
         HoldLow              => thold_ACIN_CLK_negedge_posedge(6),
         CheckEnabled         => (((TO_X01((not RSTA_dly) and (CEA1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((AREG = 1) and (TO_X01(CEA2) = '1')) or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_ACIN_CLK_posedge(7),
         TimingData           => Tmkr_ACIN_CLK_posedge(7),
         TestSignal           => ACIN_dly(7),
         TestSignalName       => "ACIN(7)",
         TestDelay            => tisd_ACIN_CLK(7),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_ACIN_CLK_posedge_posedge(7),
         SetupLow             => tsetup_ACIN_CLK_negedge_posedge(7),
         HoldHigh             => thold_ACIN_CLK_posedge_posedge(7),
         HoldLow              => thold_ACIN_CLK_negedge_posedge(7),
         CheckEnabled         => (((TO_X01((not RSTA_dly) and (CEA1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((AREG = 1) and (TO_X01(CEA2) = '1')) or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_ACIN_CLK_posedge(8),
         TimingData           => Tmkr_ACIN_CLK_posedge(8),
         TestSignal           => ACIN_dly(8),
         TestSignalName       => "ACIN(8)",
         TestDelay            => tisd_ACIN_CLK(8),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_ACIN_CLK_posedge_posedge(8),
         SetupLow             => tsetup_ACIN_CLK_negedge_posedge(8),
         HoldHigh             => thold_ACIN_CLK_posedge_posedge(8),
         HoldLow              => thold_ACIN_CLK_negedge_posedge(8),
         CheckEnabled         => (((TO_X01((not RSTA_dly) and (CEA1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((AREG = 1) and (TO_X01(CEA2) = '1')) or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_ACIN_CLK_posedge(9),
         TimingData           => Tmkr_ACIN_CLK_posedge(9),
         TestSignal           => ACIN_dly(9),
         TestSignalName       => "ACIN(9)",
         TestDelay            => tisd_ACIN_CLK(9),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_ACIN_CLK_posedge_posedge(9),
         SetupLow             => tsetup_ACIN_CLK_negedge_posedge(9),
         HoldHigh             => thold_ACIN_CLK_posedge_posedge(9),
         HoldLow              => thold_ACIN_CLK_negedge_posedge(9),
         CheckEnabled         => (((TO_X01((not RSTA_dly) and (CEA1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((AREG = 1) and (TO_X01(CEA2) = '1')) or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_ACIN_CLK_posedge(10),
         TimingData           => Tmkr_ACIN_CLK_posedge(10),
         TestSignal           => ACIN_dly(10),
         TestSignalName       => "ACIN(10)",
         TestDelay            => tisd_ACIN_CLK(10),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_ACIN_CLK_posedge_posedge(10),
         SetupLow             => tsetup_ACIN_CLK_negedge_posedge(10),
         HoldHigh             => thold_ACIN_CLK_posedge_posedge(10),
         HoldLow              => thold_ACIN_CLK_negedge_posedge(10),
         CheckEnabled         => (((TO_X01((not RSTA_dly) and (CEA1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((AREG = 1) and (TO_X01(CEA2) = '1')) or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_ACIN_CLK_posedge(11),
         TimingData           => Tmkr_ACIN_CLK_posedge(11),
         TestSignal           => ACIN_dly(11),
         TestSignalName       => "ACIN(11)",
         TestDelay            => tisd_ACIN_CLK(11),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_ACIN_CLK_posedge_posedge(11),
         SetupLow             => tsetup_ACIN_CLK_negedge_posedge(11),
         HoldHigh             => thold_ACIN_CLK_posedge_posedge(11),
         HoldLow              => thold_ACIN_CLK_negedge_posedge(11),
         CheckEnabled         => (((TO_X01((not RSTA_dly) and (CEA1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((AREG = 1) and (TO_X01(CEA2) = '1')) or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_ACIN_CLK_posedge(12),
         TimingData           => Tmkr_ACIN_CLK_posedge(12),
         TestSignal           => ACIN_dly(12),
         TestSignalName       => "ACIN(12)",
         TestDelay            => tisd_ACIN_CLK(12),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_ACIN_CLK_posedge_posedge(12),
         SetupLow             => tsetup_ACIN_CLK_negedge_posedge(12),
         HoldHigh             => thold_ACIN_CLK_posedge_posedge(12),
         HoldLow              => thold_ACIN_CLK_negedge_posedge(12),
         CheckEnabled         => (((TO_X01((not RSTA_dly) and (CEA1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((AREG = 1) and (TO_X01(CEA2) = '1')) or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_ACIN_CLK_posedge(13),
         TimingData           => Tmkr_ACIN_CLK_posedge(13),
         TestSignal           => ACIN_dly(13),
         TestSignalName       => "ACIN(13)",
         TestDelay            => tisd_ACIN_CLK(13),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_ACIN_CLK_posedge_posedge(13),
         SetupLow             => tsetup_ACIN_CLK_negedge_posedge(13),
         HoldHigh             => thold_ACIN_CLK_posedge_posedge(13),
         HoldLow              => thold_ACIN_CLK_negedge_posedge(13),
         CheckEnabled         => (((TO_X01((not RSTA_dly) and (CEA1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((AREG = 1) and (TO_X01(CEA2) = '1')) or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_ACIN_CLK_posedge(14),
         TimingData           => Tmkr_ACIN_CLK_posedge(14),
         TestSignal           => ACIN_dly(14),
         TestSignalName       => "ACIN(14)",
         TestDelay            => tisd_ACIN_CLK(14),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_ACIN_CLK_posedge_posedge(14),
         SetupLow             => tsetup_ACIN_CLK_negedge_posedge(14),
         HoldHigh             => thold_ACIN_CLK_posedge_posedge(14),
         HoldLow              => thold_ACIN_CLK_negedge_posedge(14),
         CheckEnabled         => (((TO_X01((not RSTA_dly) and (CEA1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((AREG = 1) and (TO_X01(CEA2) = '1')) or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_ACIN_CLK_posedge(15),
         TimingData           => Tmkr_ACIN_CLK_posedge(15),
         TestSignal           => ACIN_dly(15),
         TestSignalName       => "ACIN(15)",
         TestDelay            => tisd_ACIN_CLK(15),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_ACIN_CLK_posedge_posedge(15),
         SetupLow             => tsetup_ACIN_CLK_negedge_posedge(15),
         HoldHigh             => thold_ACIN_CLK_posedge_posedge(15),
         HoldLow              => thold_ACIN_CLK_negedge_posedge(15),
         CheckEnabled         => (((TO_X01((not RSTA_dly) and (CEA1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((AREG = 1) and (TO_X01(CEA2) = '1')) or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_ACIN_CLK_posedge(16),
         TimingData           => Tmkr_ACIN_CLK_posedge(16),
         TestSignal           => ACIN_dly(16),
         TestSignalName       => "ACIN(16)",
         TestDelay            => tisd_ACIN_CLK(16),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_ACIN_CLK_posedge_posedge(16),
         SetupLow             => tsetup_ACIN_CLK_negedge_posedge(16),
         HoldHigh             => thold_ACIN_CLK_posedge_posedge(16),
         HoldLow              => thold_ACIN_CLK_negedge_posedge(16),
         CheckEnabled         => (((TO_X01((not RSTA_dly) and (CEA1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((AREG = 1) and (TO_X01(CEA2) = '1')) or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_ACIN_CLK_posedge(17),
         TimingData           => Tmkr_ACIN_CLK_posedge(17),
         TestSignal           => ACIN_dly(17),
         TestSignalName       => "ACIN(17)",
         TestDelay            => tisd_ACIN_CLK(17),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_ACIN_CLK_posedge_posedge(17),
         SetupLow             => tsetup_ACIN_CLK_negedge_posedge(17),
         HoldHigh             => thold_ACIN_CLK_posedge_posedge(17),
         HoldLow              => thold_ACIN_CLK_negedge_posedge(17),
         CheckEnabled         => (((TO_X01((not RSTA_dly) and (CEA1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((AREG = 1) and (TO_X01(CEA2) = '1')) or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_ACIN_CLK_posedge(18),
         TimingData           => Tmkr_ACIN_CLK_posedge(18),
         TestSignal           => ACIN_dly(18),
         TestSignalName       => "ACIN(18)",
         TestDelay            => tisd_ACIN_CLK(18),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_ACIN_CLK_posedge_posedge(18),
         SetupLow             => tsetup_ACIN_CLK_negedge_posedge(18),
         HoldHigh             => thold_ACIN_CLK_posedge_posedge(18),
         HoldLow              => thold_ACIN_CLK_negedge_posedge(18),
         CheckEnabled         => (((TO_X01((not RSTA_dly) and (CEA1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((AREG = 1) and (TO_X01(CEA2) = '1')) or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_ACIN_CLK_posedge(19),
         TimingData           => Tmkr_ACIN_CLK_posedge(19),
         TestSignal           => ACIN_dly(19),
         TestSignalName       => "ACIN(19)",
         TestDelay            => tisd_ACIN_CLK(19),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_ACIN_CLK_posedge_posedge(19),
         SetupLow             => tsetup_ACIN_CLK_negedge_posedge(19),
         HoldHigh             => thold_ACIN_CLK_posedge_posedge(19),
         HoldLow              => thold_ACIN_CLK_negedge_posedge(19),
         CheckEnabled         => (((TO_X01((not RSTA_dly) and (CEA1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((AREG = 1) and (TO_X01(CEA2) = '1')) or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_ACIN_CLK_posedge(20),
         TimingData           => Tmkr_ACIN_CLK_posedge(20),
         TestSignal           => ACIN_dly(20),
         TestSignalName       => "ACIN(20)",
         TestDelay            => tisd_ACIN_CLK(20),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_ACIN_CLK_posedge_posedge(20),
         SetupLow             => tsetup_ACIN_CLK_negedge_posedge(20),
         HoldHigh             => thold_ACIN_CLK_posedge_posedge(20),
         HoldLow              => thold_ACIN_CLK_negedge_posedge(20),
         CheckEnabled         => (((TO_X01((not RSTA_dly) and (CEA1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((AREG = 1) and (TO_X01(CEA2) = '1')) or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_ACIN_CLK_posedge(21),
         TimingData           => Tmkr_ACIN_CLK_posedge(21),
         TestSignal           => ACIN_dly(21),
         TestSignalName       => "ACIN(21)",
         TestDelay            => tisd_ACIN_CLK(21),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_ACIN_CLK_posedge_posedge(21),
         SetupLow             => tsetup_ACIN_CLK_negedge_posedge(21),
         HoldHigh             => thold_ACIN_CLK_posedge_posedge(21),
         HoldLow              => thold_ACIN_CLK_negedge_posedge(21),
         CheckEnabled         => (((TO_X01((not RSTA_dly) and (CEA1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((AREG = 1) and (TO_X01(CEA2) = '1')) or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_ACIN_CLK_posedge(22),
         TimingData           => Tmkr_ACIN_CLK_posedge(22),
         TestSignal           => ACIN_dly(22),
         TestSignalName       => "ACIN(22)",
         TestDelay            => tisd_ACIN_CLK(22),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_ACIN_CLK_posedge_posedge(22),
         SetupLow             => tsetup_ACIN_CLK_negedge_posedge(22),
         HoldHigh             => thold_ACIN_CLK_posedge_posedge(22),
         HoldLow              => thold_ACIN_CLK_negedge_posedge(22),
         CheckEnabled         => (((TO_X01((not RSTA_dly) and (CEA1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((AREG = 1) and (TO_X01(CEA2) = '1')) or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_ACIN_CLK_posedge(23),
         TimingData           => Tmkr_ACIN_CLK_posedge(23),
         TestSignal           => ACIN_dly(23),
         TestSignalName       => "ACIN(23)",
         TestDelay            => tisd_ACIN_CLK(23),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_ACIN_CLK_posedge_posedge(23),
         SetupLow             => tsetup_ACIN_CLK_negedge_posedge(23),
         HoldHigh             => thold_ACIN_CLK_posedge_posedge(23),
         HoldLow              => thold_ACIN_CLK_negedge_posedge(23),
         CheckEnabled         => (((TO_X01((not RSTA_dly) and (CEA1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((AREG = 1) and (TO_X01(CEA2) = '1')) or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_ACIN_CLK_posedge(24),
         TimingData           => Tmkr_ACIN_CLK_posedge(24),
         TestSignal           => ACIN_dly(24),
         TestSignalName       => "ACIN(24)",
         TestDelay            => tisd_ACIN_CLK(24),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_ACIN_CLK_posedge_posedge(24),
         SetupLow             => tsetup_ACIN_CLK_negedge_posedge(24),
         HoldHigh             => thold_ACIN_CLK_posedge_posedge(24),
         HoldLow              => thold_ACIN_CLK_negedge_posedge(24),
         CheckEnabled         => (((TO_X01((not RSTA_dly) and (CEA1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((AREG = 1) and (TO_X01(CEA2) = '1')) or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_ACIN_CLK_posedge(25),
         TimingData           => Tmkr_ACIN_CLK_posedge(25),
         TestSignal           => ACIN_dly(25),
         TestSignalName       => "ACIN(25)",
         TestDelay            => tisd_ACIN_CLK(25),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_ACIN_CLK_posedge_posedge(25),
         SetupLow             => tsetup_ACIN_CLK_negedge_posedge(25),
         HoldHigh             => thold_ACIN_CLK_posedge_posedge(25),
         HoldLow              => thold_ACIN_CLK_negedge_posedge(25),
         CheckEnabled         => (((TO_X01((not RSTA_dly) and (CEA1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((AREG = 1) and (TO_X01(CEA2) = '1')) or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_ACIN_CLK_posedge(26),
         TimingData           => Tmkr_ACIN_CLK_posedge(26),
         TestSignal           => ACIN_dly(26),
         TestSignalName       => "ACIN(26)",
         TestDelay            => tisd_ACIN_CLK(26),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_ACIN_CLK_posedge_posedge(26),
         SetupLow             => tsetup_ACIN_CLK_negedge_posedge(26),
         HoldHigh             => thold_ACIN_CLK_posedge_posedge(26),
         HoldLow              => thold_ACIN_CLK_negedge_posedge(26),
         CheckEnabled         => (((TO_X01((not RSTA_dly) and (CEA1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((AREG = 1) and (TO_X01(CEA2) = '1')) or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_ACIN_CLK_posedge(27),
         TimingData           => Tmkr_ACIN_CLK_posedge(27),
         TestSignal           => ACIN_dly(27),
         TestSignalName       => "ACIN(27)",
         TestDelay            => tisd_ACIN_CLK(27),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_ACIN_CLK_posedge_posedge(27),
         SetupLow             => tsetup_ACIN_CLK_negedge_posedge(27),
         HoldHigh             => thold_ACIN_CLK_posedge_posedge(27),
         HoldLow              => thold_ACIN_CLK_negedge_posedge(27),
         CheckEnabled         => (((TO_X01((not RSTA_dly) and (CEA1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((AREG = 1) and (TO_X01(CEA2) = '1')) or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_ACIN_CLK_posedge(28),
         TimingData           => Tmkr_ACIN_CLK_posedge(28),
         TestSignal           => ACIN_dly(28),
         TestSignalName       => "ACIN(28)",
         TestDelay            => tisd_ACIN_CLK(28),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_ACIN_CLK_posedge_posedge(28),
         SetupLow             => tsetup_ACIN_CLK_negedge_posedge(28),
         HoldHigh             => thold_ACIN_CLK_posedge_posedge(28),
         HoldLow              => thold_ACIN_CLK_negedge_posedge(28),
         CheckEnabled         => (((TO_X01((not RSTA_dly) and (CEA1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((AREG = 1) and (TO_X01(CEA2) = '1')) or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_ACIN_CLK_posedge(29),
         TimingData           => Tmkr_ACIN_CLK_posedge(29),
         TestSignal           => ACIN_dly(29),
         TestSignalName       => "ACIN(29)",
         TestDelay            => tisd_ACIN_CLK(29),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_ACIN_CLK_posedge_posedge(29),
         SetupLow             => tsetup_ACIN_CLK_negedge_posedge(29),
         HoldHigh             => thold_ACIN_CLK_posedge_posedge(29),
         HoldLow              => thold_ACIN_CLK_negedge_posedge(29),
         CheckEnabled         => (((TO_X01((not RSTA_dly) and (CEA1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((AREG = 1) and (TO_X01(CEA2) = '1')) or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
--=====  Vital SetupHold Checks for Bus signal ALUMODE =====
       VitalSetupHoldCheck (
         Violation            => Tviol_ALUMODE_CLK_posedge(0),
         TimingData           => Tmkr_ALUMODE_CLK_posedge(0),
         TestSignal           => ALUMODE_dly(0),
         TestSignalName       => "ALUMODE(0)",
         TestDelay            => tisd_ALUMODE_CLK(0),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_ALUMODE_CLK_posedge_posedge(0),
         SetupLow             => tsetup_ALUMODE_CLK_negedge_posedge(0),
         HoldHigh             => thold_ALUMODE_CLK_posedge_posedge(0),
         HoldLow              => thold_ALUMODE_CLK_negedge_posedge(0),
         CheckEnabled         => (TO_X01((not RSTALUMODE_dly) and (CEALUMODE_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_ALUMODE_CLK_posedge(1),
         TimingData           => Tmkr_ALUMODE_CLK_posedge(1),
         TestSignal           => ALUMODE_dly(1),
         TestSignalName       => "ALUMODE(1)",
         TestDelay            => tisd_ALUMODE_CLK(1),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_ALUMODE_CLK_posedge_posedge(1),
         SetupLow             => tsetup_ALUMODE_CLK_negedge_posedge(1),
         HoldHigh             => thold_ALUMODE_CLK_posedge_posedge(1),
         HoldLow              => thold_ALUMODE_CLK_negedge_posedge(1),
         CheckEnabled         => (TO_X01((not RSTALUMODE_dly) and (CEALUMODE_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_ALUMODE_CLK_posedge(2),
         TimingData           => Tmkr_ALUMODE_CLK_posedge(2),
         TestSignal           => ALUMODE_dly(2),
         TestSignalName       => "ALUMODE(2)",
         TestDelay            => tisd_ALUMODE_CLK(2),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_ALUMODE_CLK_posedge_posedge(2),
         SetupLow             => tsetup_ALUMODE_CLK_negedge_posedge(2),
         HoldHigh             => thold_ALUMODE_CLK_posedge_posedge(2),
         HoldLow              => thold_ALUMODE_CLK_negedge_posedge(2),
         CheckEnabled         => (TO_X01((not RSTALUMODE_dly) and (CEALUMODE_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_ALUMODE_CLK_posedge(3),
         TimingData           => Tmkr_ALUMODE_CLK_posedge(3),
         TestSignal           => ALUMODE_dly(3),
         TestSignalName       => "ALUMODE(3)",
         TestDelay            => tisd_ALUMODE_CLK(3),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_ALUMODE_CLK_posedge_posedge(3),
         SetupLow             => tsetup_ALUMODE_CLK_negedge_posedge(3),
         HoldHigh             => thold_ALUMODE_CLK_posedge_posedge(3),
         HoldLow              => thold_ALUMODE_CLK_negedge_posedge(3),
         CheckEnabled         => (TO_X01((not RSTALUMODE_dly) and (CEALUMODE_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
--=====  Vital SetupHold Checks for Bus signal B =====
       VitalSetupHoldCheck (
         Violation            => Tviol_B_CLK_posedge(0),
         TimingData           => Tmkr_B_CLK_posedge(0),
         TestSignal           => B_dly(0),
         TestSignalName       => "B(0)",
         TestDelay            => tisd_B_CLK(0),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_B_CLK_posedge_posedge(0),
         SetupLow             => tsetup_B_CLK_negedge_posedge(0),
         HoldHigh             => thold_B_CLK_posedge_posedge(0),
         HoldLow              => thold_B_CLK_negedge_posedge(0),
         CheckEnabled         => (((TO_X01((not RSTB_dly) and (CEB1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((BREG = 1) and (TO_X01(CEB2) = '1')) or ((BREG = 2) and (TO_X01(CEB1) = '1') and (TO_X01(CEB2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_B_CLK_posedge(1),
         TimingData           => Tmkr_B_CLK_posedge(1),
         TestSignal           => B_dly(1),
         TestSignalName       => "B(1)",
         TestDelay            => tisd_B_CLK(1),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_B_CLK_posedge_posedge(1),
         SetupLow             => tsetup_B_CLK_negedge_posedge(1),
         HoldHigh             => thold_B_CLK_posedge_posedge(1),
         HoldLow              => thold_B_CLK_negedge_posedge(1),
         CheckEnabled         => (((TO_X01((not RSTB_dly) and (CEB1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((BREG = 1) and (TO_X01(CEB2) = '1')) or ((BREG = 2) and (TO_X01(CEB1) = '1') and (TO_X01(CEB2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_B_CLK_posedge(2),
         TimingData           => Tmkr_B_CLK_posedge(2),
         TestSignal           => B_dly(2),
         TestSignalName       => "B(2)",
         TestDelay            => tisd_B_CLK(2),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_B_CLK_posedge_posedge(2),
         SetupLow             => tsetup_B_CLK_negedge_posedge(2),
         HoldHigh             => thold_B_CLK_posedge_posedge(2),
         HoldLow              => thold_B_CLK_negedge_posedge(2),
         CheckEnabled         => (((TO_X01((not RSTB_dly) and (CEB1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((BREG = 1) and (TO_X01(CEB2) = '1')) or ((BREG = 2) and (TO_X01(CEB1) = '1') and (TO_X01(CEB2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_B_CLK_posedge(3),
         TimingData           => Tmkr_B_CLK_posedge(3),
         TestSignal           => B_dly(3),
         TestSignalName       => "B(3)",
         TestDelay            => tisd_B_CLK(3),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_B_CLK_posedge_posedge(3),
         SetupLow             => tsetup_B_CLK_negedge_posedge(3),
         HoldHigh             => thold_B_CLK_posedge_posedge(3),
         HoldLow              => thold_B_CLK_negedge_posedge(3),
         CheckEnabled         => (((TO_X01((not RSTB_dly) and (CEB1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((BREG = 1) and (TO_X01(CEB2) = '1')) or ((BREG = 2) and (TO_X01(CEB1) = '1') and (TO_X01(CEB2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_B_CLK_posedge(4),
         TimingData           => Tmkr_B_CLK_posedge(4),
         TestSignal           => B_dly(4),
         TestSignalName       => "B(4)",
         TestDelay            => tisd_B_CLK(4),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_B_CLK_posedge_posedge(4),
         SetupLow             => tsetup_B_CLK_negedge_posedge(4),
         HoldHigh             => thold_B_CLK_posedge_posedge(4),
         HoldLow              => thold_B_CLK_negedge_posedge(4),
         CheckEnabled         => (((TO_X01((not RSTB_dly) and (CEB1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((BREG = 1) and (TO_X01(CEB2) = '1')) or ((BREG = 2) and (TO_X01(CEB1) = '1') and (TO_X01(CEB2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_B_CLK_posedge(5),
         TimingData           => Tmkr_B_CLK_posedge(5),
         TestSignal           => B_dly(5),
         TestSignalName       => "B(5)",
         TestDelay            => tisd_B_CLK(5),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_B_CLK_posedge_posedge(5),
         SetupLow             => tsetup_B_CLK_negedge_posedge(5),
         HoldHigh             => thold_B_CLK_posedge_posedge(5),
         HoldLow              => thold_B_CLK_negedge_posedge(5),
         CheckEnabled         => (((TO_X01((not RSTB_dly) and (CEB1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((BREG = 1) and (TO_X01(CEB2) = '1')) or ((BREG = 2) and (TO_X01(CEB1) = '1') and (TO_X01(CEB2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_B_CLK_posedge(6),
         TimingData           => Tmkr_B_CLK_posedge(6),
         TestSignal           => B_dly(6),
         TestSignalName       => "B(6)",
         TestDelay            => tisd_B_CLK(6),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_B_CLK_posedge_posedge(6),
         SetupLow             => tsetup_B_CLK_negedge_posedge(6),
         HoldHigh             => thold_B_CLK_posedge_posedge(6),
         HoldLow              => thold_B_CLK_negedge_posedge(6),
         CheckEnabled         => (((TO_X01((not RSTB_dly) and (CEB1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((BREG = 1) and (TO_X01(CEB2) = '1')) or ((BREG = 2) and (TO_X01(CEB1) = '1') and (TO_X01(CEB2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_B_CLK_posedge(7),
         TimingData           => Tmkr_B_CLK_posedge(7),
         TestSignal           => B_dly(7),
         TestSignalName       => "B(7)",
         TestDelay            => tisd_B_CLK(7),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_B_CLK_posedge_posedge(7),
         SetupLow             => tsetup_B_CLK_negedge_posedge(7),
         HoldHigh             => thold_B_CLK_posedge_posedge(7),
         HoldLow              => thold_B_CLK_negedge_posedge(7),
         CheckEnabled         => (((TO_X01((not RSTB_dly) and (CEB1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((BREG = 1) and (TO_X01(CEB2) = '1')) or ((BREG = 2) and (TO_X01(CEB1) = '1') and (TO_X01(CEB2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_B_CLK_posedge(8),
         TimingData           => Tmkr_B_CLK_posedge(8),
         TestSignal           => B_dly(8),
         TestSignalName       => "B(8)",
         TestDelay            => tisd_B_CLK(8),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_B_CLK_posedge_posedge(8),
         SetupLow             => tsetup_B_CLK_negedge_posedge(8),
         HoldHigh             => thold_B_CLK_posedge_posedge(8),
         HoldLow              => thold_B_CLK_negedge_posedge(8),
         CheckEnabled         => (((TO_X01((not RSTB_dly) and (CEB1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((BREG = 1) and (TO_X01(CEB2) = '1')) or ((BREG = 2) and (TO_X01(CEB1) = '1') and (TO_X01(CEB2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_B_CLK_posedge(9),
         TimingData           => Tmkr_B_CLK_posedge(9),
         TestSignal           => B_dly(9),
         TestSignalName       => "B(9)",
         TestDelay            => tisd_B_CLK(9),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_B_CLK_posedge_posedge(9),
         SetupLow             => tsetup_B_CLK_negedge_posedge(9),
         HoldHigh             => thold_B_CLK_posedge_posedge(9),
         HoldLow              => thold_B_CLK_negedge_posedge(9),
         CheckEnabled         => (((TO_X01((not RSTB_dly) and (CEB1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((BREG = 1) and (TO_X01(CEB2) = '1')) or ((BREG = 2) and (TO_X01(CEB1) = '1') and (TO_X01(CEB2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_B_CLK_posedge(10),
         TimingData           => Tmkr_B_CLK_posedge(10),
         TestSignal           => B_dly(10),
         TestSignalName       => "B(10)",
         TestDelay            => tisd_B_CLK(10),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_B_CLK_posedge_posedge(10),
         SetupLow             => tsetup_B_CLK_negedge_posedge(10),
         HoldHigh             => thold_B_CLK_posedge_posedge(10),
         HoldLow              => thold_B_CLK_negedge_posedge(10),
         CheckEnabled         => (((TO_X01((not RSTB_dly) and (CEB1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((BREG = 1) and (TO_X01(CEB2) = '1')) or ((BREG = 2) and (TO_X01(CEB1) = '1') and (TO_X01(CEB2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_B_CLK_posedge(11),
         TimingData           => Tmkr_B_CLK_posedge(11),
         TestSignal           => B_dly(11),
         TestSignalName       => "B(11)",
         TestDelay            => tisd_B_CLK(11),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_B_CLK_posedge_posedge(11),
         SetupLow             => tsetup_B_CLK_negedge_posedge(11),
         HoldHigh             => thold_B_CLK_posedge_posedge(11),
         HoldLow              => thold_B_CLK_negedge_posedge(11),
         CheckEnabled         => (((TO_X01((not RSTB_dly) and (CEB1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((BREG = 1) and (TO_X01(CEB2) = '1')) or ((BREG = 2) and (TO_X01(CEB1) = '1') and (TO_X01(CEB2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_B_CLK_posedge(12),
         TimingData           => Tmkr_B_CLK_posedge(12),
         TestSignal           => B_dly(12),
         TestSignalName       => "B(12)",
         TestDelay            => tisd_B_CLK(12),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_B_CLK_posedge_posedge(12),
         SetupLow             => tsetup_B_CLK_negedge_posedge(12),
         HoldHigh             => thold_B_CLK_posedge_posedge(12),
         HoldLow              => thold_B_CLK_negedge_posedge(12),
         CheckEnabled         => (((TO_X01((not RSTB_dly) and (CEB1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((BREG = 1) and (TO_X01(CEB2) = '1')) or ((BREG = 2) and (TO_X01(CEB1) = '1') and (TO_X01(CEB2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_B_CLK_posedge(13),
         TimingData           => Tmkr_B_CLK_posedge(13),
         TestSignal           => B_dly(13),
         TestSignalName       => "B(13)",
         TestDelay            => tisd_B_CLK(13),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_B_CLK_posedge_posedge(13),
         SetupLow             => tsetup_B_CLK_negedge_posedge(13),
         HoldHigh             => thold_B_CLK_posedge_posedge(13),
         HoldLow              => thold_B_CLK_negedge_posedge(13),
         CheckEnabled         => (((TO_X01((not RSTB_dly) and (CEB1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((BREG = 1) and (TO_X01(CEB2) = '1')) or ((BREG = 2) and (TO_X01(CEB1) = '1') and (TO_X01(CEB2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_B_CLK_posedge(14),
         TimingData           => Tmkr_B_CLK_posedge(14),
         TestSignal           => B_dly(14),
         TestSignalName       => "B(14)",
         TestDelay            => tisd_B_CLK(14),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_B_CLK_posedge_posedge(14),
         SetupLow             => tsetup_B_CLK_negedge_posedge(14),
         HoldHigh             => thold_B_CLK_posedge_posedge(14),
         HoldLow              => thold_B_CLK_negedge_posedge(14),
         CheckEnabled         => (((TO_X01((not RSTB_dly) and (CEB1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((BREG = 1) and (TO_X01(CEB2) = '1')) or ((BREG = 2) and (TO_X01(CEB1) = '1') and (TO_X01(CEB2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_B_CLK_posedge(15),
         TimingData           => Tmkr_B_CLK_posedge(15),
         TestSignal           => B_dly(15),
         TestSignalName       => "B(15)",
         TestDelay            => tisd_B_CLK(15),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_B_CLK_posedge_posedge(15),
         SetupLow             => tsetup_B_CLK_negedge_posedge(15),
         HoldHigh             => thold_B_CLK_posedge_posedge(15),
         HoldLow              => thold_B_CLK_negedge_posedge(15),
         CheckEnabled         => (((TO_X01((not RSTB_dly) and (CEB1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((BREG = 1) and (TO_X01(CEB2) = '1')) or ((BREG = 2) and (TO_X01(CEB1) = '1') and (TO_X01(CEB2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_B_CLK_posedge(16),
         TimingData           => Tmkr_B_CLK_posedge(16),
         TestSignal           => B_dly(16),
         TestSignalName       => "B(16)",
         TestDelay            => tisd_B_CLK(16),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_B_CLK_posedge_posedge(16),
         SetupLow             => tsetup_B_CLK_negedge_posedge(16),
         HoldHigh             => thold_B_CLK_posedge_posedge(16),
         HoldLow              => thold_B_CLK_negedge_posedge(16),
         CheckEnabled         => (((TO_X01((not RSTB_dly) and (CEB1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((BREG = 1) and (TO_X01(CEB2) = '1')) or ((BREG = 2) and (TO_X01(CEB1) = '1') and (TO_X01(CEB2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_B_CLK_posedge(17),
         TimingData           => Tmkr_B_CLK_posedge(17),
         TestSignal           => B_dly(17),
         TestSignalName       => "B(17)",
         TestDelay            => tisd_B_CLK(17),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_B_CLK_posedge_posedge(17),
         SetupLow             => tsetup_B_CLK_negedge_posedge(17),
         HoldHigh             => thold_B_CLK_posedge_posedge(17),
         HoldLow              => thold_B_CLK_negedge_posedge(17),
         CheckEnabled         => (((TO_X01((not RSTB_dly) and (CEB1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((BREG = 1) and (TO_X01(CEB2) = '1')) or ((BREG = 2) and (TO_X01(CEB1) = '1') and (TO_X01(CEB2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
--=====  Vital SetupHold Checks for Bus signal BCIN =====
       VitalSetupHoldCheck (
         Violation            => Tviol_BCIN_CLK_posedge(0),
         TimingData           => Tmkr_BCIN_CLK_posedge(0),
         TestSignal           => BCIN_dly(0),
         TestSignalName       => "BCIN(0)",
         TestDelay            => tisd_BCIN_CLK(0),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_BCIN_CLK_posedge_posedge(0),
         SetupLow             => tsetup_BCIN_CLK_negedge_posedge(0),
         HoldHigh             => thold_BCIN_CLK_posedge_posedge(0),
         HoldLow              => thold_BCIN_CLK_negedge_posedge(0),
         CheckEnabled         => (((TO_X01((not RSTB_dly) and (CEB1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((BREG = 1) and (TO_X01(CEB2) = '1')) or ((BREG = 2) and (TO_X01(CEB1) = '1') and (TO_X01(CEB2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_BCIN_CLK_posedge(1),
         TimingData           => Tmkr_BCIN_CLK_posedge(1),
         TestSignal           => BCIN_dly(1),
         TestSignalName       => "BCIN(1)",
         TestDelay            => tisd_BCIN_CLK(1),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_BCIN_CLK_posedge_posedge(1),
         SetupLow             => tsetup_BCIN_CLK_negedge_posedge(1),
         HoldHigh             => thold_BCIN_CLK_posedge_posedge(1),
         HoldLow              => thold_BCIN_CLK_negedge_posedge(1),
         CheckEnabled         => (((TO_X01((not RSTB_dly) and (CEB1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((BREG = 1) and (TO_X01(CEB2) = '1')) or ((BREG = 2) and (TO_X01(CEB1) = '1') and (TO_X01(CEB2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_BCIN_CLK_posedge(2),
         TimingData           => Tmkr_BCIN_CLK_posedge(2),
         TestSignal           => BCIN_dly(2),
         TestSignalName       => "BCIN(2)",
         TestDelay            => tisd_BCIN_CLK(2),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_BCIN_CLK_posedge_posedge(2),
         SetupLow             => tsetup_BCIN_CLK_negedge_posedge(2),
         HoldHigh             => thold_BCIN_CLK_posedge_posedge(2),
         HoldLow              => thold_BCIN_CLK_negedge_posedge(2),
         CheckEnabled         => (((TO_X01((not RSTB_dly) and (CEB1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((BREG = 1) and (TO_X01(CEB2) = '1')) or ((BREG = 2) and (TO_X01(CEB1) = '1') and (TO_X01(CEB2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_BCIN_CLK_posedge(3),
         TimingData           => Tmkr_BCIN_CLK_posedge(3),
         TestSignal           => BCIN_dly(3),
         TestSignalName       => "BCIN(3)",
         TestDelay            => tisd_BCIN_CLK(3),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_BCIN_CLK_posedge_posedge(3),
         SetupLow             => tsetup_BCIN_CLK_negedge_posedge(3),
         HoldHigh             => thold_BCIN_CLK_posedge_posedge(3),
         HoldLow              => thold_BCIN_CLK_negedge_posedge(3),
         CheckEnabled         => (((TO_X01((not RSTB_dly) and (CEB1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((BREG = 1) and (TO_X01(CEB2) = '1')) or ((BREG = 2) and (TO_X01(CEB1) = '1') and (TO_X01(CEB2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_BCIN_CLK_posedge(4),
         TimingData           => Tmkr_BCIN_CLK_posedge(4),
         TestSignal           => BCIN_dly(4),
         TestSignalName       => "BCIN(4)",
         TestDelay            => tisd_BCIN_CLK(4),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_BCIN_CLK_posedge_posedge(4),
         SetupLow             => tsetup_BCIN_CLK_negedge_posedge(4),
         HoldHigh             => thold_BCIN_CLK_posedge_posedge(4),
         HoldLow              => thold_BCIN_CLK_negedge_posedge(4),
         CheckEnabled         => (((TO_X01((not RSTB_dly) and (CEB1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((BREG = 1) and (TO_X01(CEB2) = '1')) or ((BREG = 2) and (TO_X01(CEB1) = '1') and (TO_X01(CEB2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_BCIN_CLK_posedge(5),
         TimingData           => Tmkr_BCIN_CLK_posedge(5),
         TestSignal           => BCIN_dly(5),
         TestSignalName       => "BCIN(5)",
         TestDelay            => tisd_BCIN_CLK(5),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_BCIN_CLK_posedge_posedge(5),
         SetupLow             => tsetup_BCIN_CLK_negedge_posedge(5),
         HoldHigh             => thold_BCIN_CLK_posedge_posedge(5),
         HoldLow              => thold_BCIN_CLK_negedge_posedge(5),
         CheckEnabled         => (((TO_X01((not RSTB_dly) and (CEB1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((BREG = 1) and (TO_X01(CEB2) = '1')) or ((BREG = 2) and (TO_X01(CEB1) = '1') and (TO_X01(CEB2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_BCIN_CLK_posedge(6),
         TimingData           => Tmkr_BCIN_CLK_posedge(6),
         TestSignal           => BCIN_dly(6),
         TestSignalName       => "BCIN(6)",
         TestDelay            => tisd_BCIN_CLK(6),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_BCIN_CLK_posedge_posedge(6),
         SetupLow             => tsetup_BCIN_CLK_negedge_posedge(6),
         HoldHigh             => thold_BCIN_CLK_posedge_posedge(6),
         HoldLow              => thold_BCIN_CLK_negedge_posedge(6),
         CheckEnabled         => (((TO_X01((not RSTB_dly) and (CEB1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((BREG = 1) and (TO_X01(CEB2) = '1')) or ((BREG = 2) and (TO_X01(CEB1) = '1') and (TO_X01(CEB2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_BCIN_CLK_posedge(7),
         TimingData           => Tmkr_BCIN_CLK_posedge(7),
         TestSignal           => BCIN_dly(7),
         TestSignalName       => "BCIN(7)",
         TestDelay            => tisd_BCIN_CLK(7),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_BCIN_CLK_posedge_posedge(7),
         SetupLow             => tsetup_BCIN_CLK_negedge_posedge(7),
         HoldHigh             => thold_BCIN_CLK_posedge_posedge(7),
         HoldLow              => thold_BCIN_CLK_negedge_posedge(7),
         CheckEnabled         => (((TO_X01((not RSTB_dly) and (CEB1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((BREG = 1) and (TO_X01(CEB2) = '1')) or ((BREG = 2) and (TO_X01(CEB1) = '1') and (TO_X01(CEB2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_BCIN_CLK_posedge(8),
         TimingData           => Tmkr_BCIN_CLK_posedge(8),
         TestSignal           => BCIN_dly(8),
         TestSignalName       => "BCIN(8)",
         TestDelay            => tisd_BCIN_CLK(8),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_BCIN_CLK_posedge_posedge(8),
         SetupLow             => tsetup_BCIN_CLK_negedge_posedge(8),
         HoldHigh             => thold_BCIN_CLK_posedge_posedge(8),
         HoldLow              => thold_BCIN_CLK_negedge_posedge(8),
         CheckEnabled         => (((TO_X01((not RSTB_dly) and (CEB1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((BREG = 1) and (TO_X01(CEB2) = '1')) or ((BREG = 2) and (TO_X01(CEB1) = '1') and (TO_X01(CEB2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_BCIN_CLK_posedge(9),
         TimingData           => Tmkr_BCIN_CLK_posedge(9),
         TestSignal           => BCIN_dly(9),
         TestSignalName       => "BCIN(9)",
         TestDelay            => tisd_BCIN_CLK(9),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_BCIN_CLK_posedge_posedge(9),
         SetupLow             => tsetup_BCIN_CLK_negedge_posedge(9),
         HoldHigh             => thold_BCIN_CLK_posedge_posedge(9),
         HoldLow              => thold_BCIN_CLK_negedge_posedge(9),
         CheckEnabled         => (((TO_X01((not RSTB_dly) and (CEB1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((BREG = 1) and (TO_X01(CEB2) = '1')) or ((BREG = 2) and (TO_X01(CEB1) = '1') and (TO_X01(CEB2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_BCIN_CLK_posedge(10),
         TimingData           => Tmkr_BCIN_CLK_posedge(10),
         TestSignal           => BCIN_dly(10),
         TestSignalName       => "BCIN(10)",
         TestDelay            => tisd_BCIN_CLK(10),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_BCIN_CLK_posedge_posedge(10),
         SetupLow             => tsetup_BCIN_CLK_negedge_posedge(10),
         HoldHigh             => thold_BCIN_CLK_posedge_posedge(10),
         HoldLow              => thold_BCIN_CLK_negedge_posedge(10),
         CheckEnabled         => (((TO_X01((not RSTB_dly) and (CEB1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((BREG = 1) and (TO_X01(CEB2) = '1')) or ((BREG = 2) and (TO_X01(CEB1) = '1') and (TO_X01(CEB2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_BCIN_CLK_posedge(11),
         TimingData           => Tmkr_BCIN_CLK_posedge(11),
         TestSignal           => BCIN_dly(11),
         TestSignalName       => "BCIN(11)",
         TestDelay            => tisd_BCIN_CLK(11),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_BCIN_CLK_posedge_posedge(11),
         SetupLow             => tsetup_BCIN_CLK_negedge_posedge(11),
         HoldHigh             => thold_BCIN_CLK_posedge_posedge(11),
         HoldLow              => thold_BCIN_CLK_negedge_posedge(11),
         CheckEnabled         => (((TO_X01((not RSTB_dly) and (CEB1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((BREG = 1) and (TO_X01(CEB2) = '1')) or ((BREG = 2) and (TO_X01(CEB1) = '1') and (TO_X01(CEB2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_BCIN_CLK_posedge(12),
         TimingData           => Tmkr_BCIN_CLK_posedge(12),
         TestSignal           => BCIN_dly(12),
         TestSignalName       => "BCIN(12)",
         TestDelay            => tisd_BCIN_CLK(12),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_BCIN_CLK_posedge_posedge(12),
         SetupLow             => tsetup_BCIN_CLK_negedge_posedge(12),
         HoldHigh             => thold_BCIN_CLK_posedge_posedge(12),
         HoldLow              => thold_BCIN_CLK_negedge_posedge(12),
         CheckEnabled         => (((TO_X01((not RSTB_dly) and (CEB1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((BREG = 1) and (TO_X01(CEB2) = '1')) or ((BREG = 2) and (TO_X01(CEB1) = '1') and (TO_X01(CEB2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_BCIN_CLK_posedge(13),
         TimingData           => Tmkr_BCIN_CLK_posedge(13),
         TestSignal           => BCIN_dly(13),
         TestSignalName       => "BCIN(13)",
         TestDelay            => tisd_BCIN_CLK(13),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_BCIN_CLK_posedge_posedge(13),
         SetupLow             => tsetup_BCIN_CLK_negedge_posedge(13),
         HoldHigh             => thold_BCIN_CLK_posedge_posedge(13),
         HoldLow              => thold_BCIN_CLK_negedge_posedge(13),
         CheckEnabled         => (((TO_X01((not RSTB_dly) and (CEB1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((BREG = 1) and (TO_X01(CEB2) = '1')) or ((BREG = 2) and (TO_X01(CEB1) = '1') and (TO_X01(CEB2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_BCIN_CLK_posedge(14),
         TimingData           => Tmkr_BCIN_CLK_posedge(14),
         TestSignal           => BCIN_dly(14),
         TestSignalName       => "BCIN(14)",
         TestDelay            => tisd_BCIN_CLK(14),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_BCIN_CLK_posedge_posedge(14),
         SetupLow             => tsetup_BCIN_CLK_negedge_posedge(14),
         HoldHigh             => thold_BCIN_CLK_posedge_posedge(14),
         HoldLow              => thold_BCIN_CLK_negedge_posedge(14),
         CheckEnabled         => (((TO_X01((not RSTB_dly) and (CEB1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((BREG = 1) and (TO_X01(CEB2) = '1')) or ((BREG = 2) and (TO_X01(CEB1) = '1') and (TO_X01(CEB2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_BCIN_CLK_posedge(15),
         TimingData           => Tmkr_BCIN_CLK_posedge(15),
         TestSignal           => BCIN_dly(15),
         TestSignalName       => "BCIN(15)",
         TestDelay            => tisd_BCIN_CLK(15),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_BCIN_CLK_posedge_posedge(15),
         SetupLow             => tsetup_BCIN_CLK_negedge_posedge(15),
         HoldHigh             => thold_BCIN_CLK_posedge_posedge(15),
         HoldLow              => thold_BCIN_CLK_negedge_posedge(15),
         CheckEnabled         => (((TO_X01((not RSTB_dly) and (CEB1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((BREG = 1) and (TO_X01(CEB2) = '1')) or ((BREG = 2) and (TO_X01(CEB1) = '1') and (TO_X01(CEB2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_BCIN_CLK_posedge(16),
         TimingData           => Tmkr_BCIN_CLK_posedge(16),
         TestSignal           => BCIN_dly(16),
         TestSignalName       => "BCIN(16)",
         TestDelay            => tisd_BCIN_CLK(16),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_BCIN_CLK_posedge_posedge(16),
         SetupLow             => tsetup_BCIN_CLK_negedge_posedge(16),
         HoldHigh             => thold_BCIN_CLK_posedge_posedge(16),
         HoldLow              => thold_BCIN_CLK_negedge_posedge(16),
         CheckEnabled         => (((TO_X01((not RSTB_dly) and (CEB1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((BREG = 1) and (TO_X01(CEB2) = '1')) or ((BREG = 2) and (TO_X01(CEB1) = '1') and (TO_X01(CEB2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_BCIN_CLK_posedge(17),
         TimingData           => Tmkr_BCIN_CLK_posedge(17),
         TestSignal           => BCIN_dly(17),
         TestSignalName       => "BCIN(17)",
         TestDelay            => tisd_BCIN_CLK(17),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_BCIN_CLK_posedge_posedge(17),
         SetupLow             => tsetup_BCIN_CLK_negedge_posedge(17),
         HoldHigh             => thold_BCIN_CLK_posedge_posedge(17),
         HoldLow              => thold_BCIN_CLK_negedge_posedge(17),
         CheckEnabled         => (((TO_X01((not RSTB_dly) and (CEB1_dly)) /= '0') and (TO_X01(GSR_dly) = '0') and (((BREG = 1) and (TO_X01(CEB2) = '1')) or ((BREG = 2) and (TO_X01(CEB1) = '1') and (TO_X01(CEB2) =  '1'))))),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
--=====  Vital SetupHold Checks for Bus signal C =====
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(0),
         TimingData           => Tmkr_C_CLK_posedge(0),
         TestSignal           => C_dly(0),
         TestSignalName       => "C(0)",
         TestDelay            => tisd_C_CLK(0),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(0),
         SetupLow             => tsetup_C_CLK_negedge_posedge(0),
         HoldHigh             => thold_C_CLK_posedge_posedge(0),
         HoldLow              => thold_C_CLK_negedge_posedge(0),
         CheckEnabled         => (TO_X01((not RSTC_dly) and (CEC_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(1),
         TimingData           => Tmkr_C_CLK_posedge(1),
         TestSignal           => C_dly(1),
         TestSignalName       => "C(1)",
         TestDelay            => tisd_C_CLK(1),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(1),
         SetupLow             => tsetup_C_CLK_negedge_posedge(1),
         HoldHigh             => thold_C_CLK_posedge_posedge(1),
         HoldLow              => thold_C_CLK_negedge_posedge(1),
         CheckEnabled         => (TO_X01((not RSTC_dly) and (CEC_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(2),
         TimingData           => Tmkr_C_CLK_posedge(2),
         TestSignal           => C_dly(2),
         TestSignalName       => "C(2)",
         TestDelay            => tisd_C_CLK(2),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(2),
         SetupLow             => tsetup_C_CLK_negedge_posedge(2),
         HoldHigh             => thold_C_CLK_posedge_posedge(2),
         HoldLow              => thold_C_CLK_negedge_posedge(2),
         CheckEnabled         => (TO_X01((not RSTC_dly) and (CEC_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(3),
         TimingData           => Tmkr_C_CLK_posedge(3),
         TestSignal           => C_dly(3),
         TestSignalName       => "C(3)",
         TestDelay            => tisd_C_CLK(3),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(3),
         SetupLow             => tsetup_C_CLK_negedge_posedge(3),
         HoldHigh             => thold_C_CLK_posedge_posedge(3),
         HoldLow              => thold_C_CLK_negedge_posedge(3),
         CheckEnabled         => (TO_X01((not RSTC_dly) and (CEC_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(4),
         TimingData           => Tmkr_C_CLK_posedge(4),
         TestSignal           => C_dly(4),
         TestSignalName       => "C(4)",
         TestDelay            => tisd_C_CLK(4),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(4),
         SetupLow             => tsetup_C_CLK_negedge_posedge(4),
         HoldHigh             => thold_C_CLK_posedge_posedge(4),
         HoldLow              => thold_C_CLK_negedge_posedge(4),
         CheckEnabled         => (TO_X01((not RSTC_dly) and (CEC_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(5),
         TimingData           => Tmkr_C_CLK_posedge(5),
         TestSignal           => C_dly(5),
         TestSignalName       => "C(5)",
         TestDelay            => tisd_C_CLK(5),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(5),
         SetupLow             => tsetup_C_CLK_negedge_posedge(5),
         HoldHigh             => thold_C_CLK_posedge_posedge(5),
         HoldLow              => thold_C_CLK_negedge_posedge(5),
         CheckEnabled         => (TO_X01((not RSTC_dly) and (CEC_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(6),
         TimingData           => Tmkr_C_CLK_posedge(6),
         TestSignal           => C_dly(6),
         TestSignalName       => "C(6)",
         TestDelay            => tisd_C_CLK(6),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(6),
         SetupLow             => tsetup_C_CLK_negedge_posedge(6),
         HoldHigh             => thold_C_CLK_posedge_posedge(6),
         HoldLow              => thold_C_CLK_negedge_posedge(6),
         CheckEnabled         => (TO_X01((not RSTC_dly) and (CEC_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(7),
         TimingData           => Tmkr_C_CLK_posedge(7),
         TestSignal           => C_dly(7),
         TestSignalName       => "C(7)",
         TestDelay            => tisd_C_CLK(7),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(7),
         SetupLow             => tsetup_C_CLK_negedge_posedge(7),
         HoldHigh             => thold_C_CLK_posedge_posedge(7),
         HoldLow              => thold_C_CLK_negedge_posedge(7),
         CheckEnabled         => (TO_X01((not RSTC_dly) and (CEC_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(8),
         TimingData           => Tmkr_C_CLK_posedge(8),
         TestSignal           => C_dly(8),
         TestSignalName       => "C(8)",
         TestDelay            => tisd_C_CLK(8),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(8),
         SetupLow             => tsetup_C_CLK_negedge_posedge(8),
         HoldHigh             => thold_C_CLK_posedge_posedge(8),
         HoldLow              => thold_C_CLK_negedge_posedge(8),
         CheckEnabled         => (TO_X01((not RSTC_dly) and (CEC_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(9),
         TimingData           => Tmkr_C_CLK_posedge(9),
         TestSignal           => C_dly(9),
         TestSignalName       => "C(9)",
         TestDelay            => tisd_C_CLK(9),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(9),
         SetupLow             => tsetup_C_CLK_negedge_posedge(9),
         HoldHigh             => thold_C_CLK_posedge_posedge(9),
         HoldLow              => thold_C_CLK_negedge_posedge(9),
         CheckEnabled         => (TO_X01((not RSTC_dly) and (CEC_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(10),
         TimingData           => Tmkr_C_CLK_posedge(10),
         TestSignal           => C_dly(10),
         TestSignalName       => "C(10)",
         TestDelay            => tisd_C_CLK(10),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(10),
         SetupLow             => tsetup_C_CLK_negedge_posedge(10),
         HoldHigh             => thold_C_CLK_posedge_posedge(10),
         HoldLow              => thold_C_CLK_negedge_posedge(10),
         CheckEnabled         => (TO_X01((not RSTC_dly) and (CEC_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(11),
         TimingData           => Tmkr_C_CLK_posedge(11),
         TestSignal           => C_dly(11),
         TestSignalName       => "C(11)",
         TestDelay            => tisd_C_CLK(11),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(11),
         SetupLow             => tsetup_C_CLK_negedge_posedge(11),
         HoldHigh             => thold_C_CLK_posedge_posedge(11),
         HoldLow              => thold_C_CLK_negedge_posedge(11),
         CheckEnabled         => (TO_X01((not RSTC_dly) and (CEC_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(12),
         TimingData           => Tmkr_C_CLK_posedge(12),
         TestSignal           => C_dly(12),
         TestSignalName       => "C(12)",
         TestDelay            => tisd_C_CLK(12),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(12),
         SetupLow             => tsetup_C_CLK_negedge_posedge(12),
         HoldHigh             => thold_C_CLK_posedge_posedge(12),
         HoldLow              => thold_C_CLK_negedge_posedge(12),
         CheckEnabled         => (TO_X01((not RSTC_dly) and (CEC_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(13),
         TimingData           => Tmkr_C_CLK_posedge(13),
         TestSignal           => C_dly(13),
         TestSignalName       => "C(13)",
         TestDelay            => tisd_C_CLK(13),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(13),
         SetupLow             => tsetup_C_CLK_negedge_posedge(13),
         HoldHigh             => thold_C_CLK_posedge_posedge(13),
         HoldLow              => thold_C_CLK_negedge_posedge(13),
         CheckEnabled         => (TO_X01((not RSTC_dly) and (CEC_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(14),
         TimingData           => Tmkr_C_CLK_posedge(14),
         TestSignal           => C_dly(14),
         TestSignalName       => "C(14)",
         TestDelay            => tisd_C_CLK(14),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(14),
         SetupLow             => tsetup_C_CLK_negedge_posedge(14),
         HoldHigh             => thold_C_CLK_posedge_posedge(14),
         HoldLow              => thold_C_CLK_negedge_posedge(14),
         CheckEnabled         => (TO_X01((not RSTC_dly) and (CEC_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(15),
         TimingData           => Tmkr_C_CLK_posedge(15),
         TestSignal           => C_dly(15),
         TestSignalName       => "C(15)",
         TestDelay            => tisd_C_CLK(15),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(15),
         SetupLow             => tsetup_C_CLK_negedge_posedge(15),
         HoldHigh             => thold_C_CLK_posedge_posedge(15),
         HoldLow              => thold_C_CLK_negedge_posedge(15),
         CheckEnabled         => (TO_X01((not RSTC_dly) and (CEC_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(16),
         TimingData           => Tmkr_C_CLK_posedge(16),
         TestSignal           => C_dly(16),
         TestSignalName       => "C(16)",
         TestDelay            => tisd_C_CLK(16),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(16),
         SetupLow             => tsetup_C_CLK_negedge_posedge(16),
         HoldHigh             => thold_C_CLK_posedge_posedge(16),
         HoldLow              => thold_C_CLK_negedge_posedge(16),
         CheckEnabled         => (TO_X01((not RSTC_dly) and (CEC_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(17),
         TimingData           => Tmkr_C_CLK_posedge(17),
         TestSignal           => C_dly(17),
         TestSignalName       => "C(17)",
         TestDelay            => tisd_C_CLK(17),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(17),
         SetupLow             => tsetup_C_CLK_negedge_posedge(17),
         HoldHigh             => thold_C_CLK_posedge_posedge(17),
         HoldLow              => thold_C_CLK_negedge_posedge(17),
         CheckEnabled         => (TO_X01((not RSTC_dly) and (CEC_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(18),
         TimingData           => Tmkr_C_CLK_posedge(18),
         TestSignal           => C_dly(18),
         TestSignalName       => "C(18)",
         TestDelay            => tisd_C_CLK(18),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(18),
         SetupLow             => tsetup_C_CLK_negedge_posedge(18),
         HoldHigh             => thold_C_CLK_posedge_posedge(18),
         HoldLow              => thold_C_CLK_negedge_posedge(18),
         CheckEnabled         => (TO_X01((not RSTC_dly) and (CEC_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(19),
         TimingData           => Tmkr_C_CLK_posedge(19),
         TestSignal           => C_dly(19),
         TestSignalName       => "C(19)",
         TestDelay            => tisd_C_CLK(19),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(19),
         SetupLow             => tsetup_C_CLK_negedge_posedge(19),
         HoldHigh             => thold_C_CLK_posedge_posedge(19),
         HoldLow              => thold_C_CLK_negedge_posedge(19),
         CheckEnabled         => (TO_X01((not RSTC_dly) and (CEC_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(20),
         TimingData           => Tmkr_C_CLK_posedge(20),
         TestSignal           => C_dly(20),
         TestSignalName       => "C(20)",
         TestDelay            => tisd_C_CLK(20),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(20),
         SetupLow             => tsetup_C_CLK_negedge_posedge(20),
         HoldHigh             => thold_C_CLK_posedge_posedge(20),
         HoldLow              => thold_C_CLK_negedge_posedge(20),
         CheckEnabled         => (TO_X01((not RSTC_dly) and (CEC_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(21),
         TimingData           => Tmkr_C_CLK_posedge(21),
         TestSignal           => C_dly(21),
         TestSignalName       => "C(21)",
         TestDelay            => tisd_C_CLK(21),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(21),
         SetupLow             => tsetup_C_CLK_negedge_posedge(21),
         HoldHigh             => thold_C_CLK_posedge_posedge(21),
         HoldLow              => thold_C_CLK_negedge_posedge(21),
         CheckEnabled         => (TO_X01((not RSTC_dly) and (CEC_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(22),
         TimingData           => Tmkr_C_CLK_posedge(22),
         TestSignal           => C_dly(22),
         TestSignalName       => "C(22)",
         TestDelay            => tisd_C_CLK(22),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(22),
         SetupLow             => tsetup_C_CLK_negedge_posedge(22),
         HoldHigh             => thold_C_CLK_posedge_posedge(22),
         HoldLow              => thold_C_CLK_negedge_posedge(22),
         CheckEnabled         => (TO_X01((not RSTC_dly) and (CEC_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(23),
         TimingData           => Tmkr_C_CLK_posedge(23),
         TestSignal           => C_dly(23),
         TestSignalName       => "C(23)",
         TestDelay            => tisd_C_CLK(23),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(23),
         SetupLow             => tsetup_C_CLK_negedge_posedge(23),
         HoldHigh             => thold_C_CLK_posedge_posedge(23),
         HoldLow              => thold_C_CLK_negedge_posedge(23),
         CheckEnabled         => (TO_X01((not RSTC_dly) and (CEC_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(24),
         TimingData           => Tmkr_C_CLK_posedge(24),
         TestSignal           => C_dly(24),
         TestSignalName       => "C(24)",
         TestDelay            => tisd_C_CLK(24),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(24),
         SetupLow             => tsetup_C_CLK_negedge_posedge(24),
         HoldHigh             => thold_C_CLK_posedge_posedge(24),
         HoldLow              => thold_C_CLK_negedge_posedge(24),
         CheckEnabled         => (TO_X01((not RSTC_dly) and (CEC_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(25),
         TimingData           => Tmkr_C_CLK_posedge(25),
         TestSignal           => C_dly(25),
         TestSignalName       => "C(25)",
         TestDelay            => tisd_C_CLK(25),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(25),
         SetupLow             => tsetup_C_CLK_negedge_posedge(25),
         HoldHigh             => thold_C_CLK_posedge_posedge(25),
         HoldLow              => thold_C_CLK_negedge_posedge(25),
         CheckEnabled         => (TO_X01((not RSTC_dly) and (CEC_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(26),
         TimingData           => Tmkr_C_CLK_posedge(26),
         TestSignal           => C_dly(26),
         TestSignalName       => "C(26)",
         TestDelay            => tisd_C_CLK(26),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(26),
         SetupLow             => tsetup_C_CLK_negedge_posedge(26),
         HoldHigh             => thold_C_CLK_posedge_posedge(26),
         HoldLow              => thold_C_CLK_negedge_posedge(26),
         CheckEnabled         => (TO_X01((not RSTC_dly) and (CEC_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(27),
         TimingData           => Tmkr_C_CLK_posedge(27),
         TestSignal           => C_dly(27),
         TestSignalName       => "C(27)",
         TestDelay            => tisd_C_CLK(27),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(27),
         SetupLow             => tsetup_C_CLK_negedge_posedge(27),
         HoldHigh             => thold_C_CLK_posedge_posedge(27),
         HoldLow              => thold_C_CLK_negedge_posedge(27),
         CheckEnabled         => (TO_X01((not RSTC_dly) and (CEC_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(28),
         TimingData           => Tmkr_C_CLK_posedge(28),
         TestSignal           => C_dly(28),
         TestSignalName       => "C(28)",
         TestDelay            => tisd_C_CLK(28),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(28),
         SetupLow             => tsetup_C_CLK_negedge_posedge(28),
         HoldHigh             => thold_C_CLK_posedge_posedge(28),
         HoldLow              => thold_C_CLK_negedge_posedge(28),
         CheckEnabled         => (TO_X01((not RSTC_dly) and (CEC_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(29),
         TimingData           => Tmkr_C_CLK_posedge(29),
         TestSignal           => C_dly(29),
         TestSignalName       => "C(29)",
         TestDelay            => tisd_C_CLK(29),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(29),
         SetupLow             => tsetup_C_CLK_negedge_posedge(29),
         HoldHigh             => thold_C_CLK_posedge_posedge(29),
         HoldLow              => thold_C_CLK_negedge_posedge(29),
         CheckEnabled         => (TO_X01((not RSTC_dly) and (CEC_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(30),
         TimingData           => Tmkr_C_CLK_posedge(30),
         TestSignal           => C_dly(30),
         TestSignalName       => "C(30)",
         TestDelay            => tisd_C_CLK(30),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(30),
         SetupLow             => tsetup_C_CLK_negedge_posedge(30),
         HoldHigh             => thold_C_CLK_posedge_posedge(30),
         HoldLow              => thold_C_CLK_negedge_posedge(30),
         CheckEnabled         => (TO_X01((not RSTC_dly) and (CEC_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(31),
         TimingData           => Tmkr_C_CLK_posedge(31),
         TestSignal           => C_dly(31),
         TestSignalName       => "C(31)",
         TestDelay            => tisd_C_CLK(31),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(31),
         SetupLow             => tsetup_C_CLK_negedge_posedge(31),
         HoldHigh             => thold_C_CLK_posedge_posedge(31),
         HoldLow              => thold_C_CLK_negedge_posedge(31),
         CheckEnabled         => (TO_X01((not RSTC_dly) and (CEC_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(32),
         TimingData           => Tmkr_C_CLK_posedge(32),
         TestSignal           => C_dly(32),
         TestSignalName       => "C(32)",
         TestDelay            => tisd_C_CLK(32),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(32),
         SetupLow             => tsetup_C_CLK_negedge_posedge(32),
         HoldHigh             => thold_C_CLK_posedge_posedge(32),
         HoldLow              => thold_C_CLK_negedge_posedge(32),
         CheckEnabled         => (TO_X01((not RSTC_dly) and (CEC_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(33),
         TimingData           => Tmkr_C_CLK_posedge(33),
         TestSignal           => C_dly(33),
         TestSignalName       => "C(33)",
         TestDelay            => tisd_C_CLK(33),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(33),
         SetupLow             => tsetup_C_CLK_negedge_posedge(33),
         HoldHigh             => thold_C_CLK_posedge_posedge(33),
         HoldLow              => thold_C_CLK_negedge_posedge(33),
         CheckEnabled         => (TO_X01((not RSTC_dly) and (CEC_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(34),
         TimingData           => Tmkr_C_CLK_posedge(34),
         TestSignal           => C_dly(34),
         TestSignalName       => "C(34)",
         TestDelay            => tisd_C_CLK(34),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(34),
         SetupLow             => tsetup_C_CLK_negedge_posedge(34),
         HoldHigh             => thold_C_CLK_posedge_posedge(34),
         HoldLow              => thold_C_CLK_negedge_posedge(34),
         CheckEnabled         => (TO_X01((not RSTC_dly) and (CEC_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(35),
         TimingData           => Tmkr_C_CLK_posedge(35),
         TestSignal           => C_dly(35),
         TestSignalName       => "C(35)",
         TestDelay            => tisd_C_CLK(35),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(35),
         SetupLow             => tsetup_C_CLK_negedge_posedge(35),
         HoldHigh             => thold_C_CLK_posedge_posedge(35),
         HoldLow              => thold_C_CLK_negedge_posedge(35),
         CheckEnabled         => (TO_X01((not RSTC_dly) and (CEC_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(36),
         TimingData           => Tmkr_C_CLK_posedge(36),
         TestSignal           => C_dly(36),
         TestSignalName       => "C(36)",
         TestDelay            => tisd_C_CLK(36),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(36),
         SetupLow             => tsetup_C_CLK_negedge_posedge(36),
         HoldHigh             => thold_C_CLK_posedge_posedge(36),
         HoldLow              => thold_C_CLK_negedge_posedge(36),
         CheckEnabled         => (TO_X01((not RSTC_dly) and (CEC_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(37),
         TimingData           => Tmkr_C_CLK_posedge(37),
         TestSignal           => C_dly(37),
         TestSignalName       => "C(37)",
         TestDelay            => tisd_C_CLK(37),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(37),
         SetupLow             => tsetup_C_CLK_negedge_posedge(37),
         HoldHigh             => thold_C_CLK_posedge_posedge(37),
         HoldLow              => thold_C_CLK_negedge_posedge(37),
         CheckEnabled         => (TO_X01((not RSTC_dly) and (CEC_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(38),
         TimingData           => Tmkr_C_CLK_posedge(38),
         TestSignal           => C_dly(38),
         TestSignalName       => "C(38)",
         TestDelay            => tisd_C_CLK(38),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(38),
         SetupLow             => tsetup_C_CLK_negedge_posedge(38),
         HoldHigh             => thold_C_CLK_posedge_posedge(38),
         HoldLow              => thold_C_CLK_negedge_posedge(38),
         CheckEnabled         => (TO_X01((not RSTC_dly) and (CEC_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(39),
         TimingData           => Tmkr_C_CLK_posedge(39),
         TestSignal           => C_dly(39),
         TestSignalName       => "C(39)",
         TestDelay            => tisd_C_CLK(39),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(39),
         SetupLow             => tsetup_C_CLK_negedge_posedge(39),
         HoldHigh             => thold_C_CLK_posedge_posedge(39),
         HoldLow              => thold_C_CLK_negedge_posedge(39),
         CheckEnabled         => (TO_X01((not RSTC_dly) and (CEC_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(40),
         TimingData           => Tmkr_C_CLK_posedge(40),
         TestSignal           => C_dly(40),
         TestSignalName       => "C(40)",
         TestDelay            => tisd_C_CLK(40),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(40),
         SetupLow             => tsetup_C_CLK_negedge_posedge(40),
         HoldHigh             => thold_C_CLK_posedge_posedge(40),
         HoldLow              => thold_C_CLK_negedge_posedge(40),
         CheckEnabled         => (TO_X01((not RSTC_dly) and (CEC_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(41),
         TimingData           => Tmkr_C_CLK_posedge(41),
         TestSignal           => C_dly(41),
         TestSignalName       => "C(41)",
         TestDelay            => tisd_C_CLK(41),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(41),
         SetupLow             => tsetup_C_CLK_negedge_posedge(41),
         HoldHigh             => thold_C_CLK_posedge_posedge(41),
         HoldLow              => thold_C_CLK_negedge_posedge(41),
         CheckEnabled         => (TO_X01((not RSTC_dly) and (CEC_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(42),
         TimingData           => Tmkr_C_CLK_posedge(42),
         TestSignal           => C_dly(42),
         TestSignalName       => "C(42)",
         TestDelay            => tisd_C_CLK(42),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(42),
         SetupLow             => tsetup_C_CLK_negedge_posedge(42),
         HoldHigh             => thold_C_CLK_posedge_posedge(42),
         HoldLow              => thold_C_CLK_negedge_posedge(42),
         CheckEnabled         => (TO_X01((not RSTC_dly) and (CEC_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(43),
         TimingData           => Tmkr_C_CLK_posedge(43),
         TestSignal           => C_dly(43),
         TestSignalName       => "C(43)",
         TestDelay            => tisd_C_CLK(43),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(43),
         SetupLow             => tsetup_C_CLK_negedge_posedge(43),
         HoldHigh             => thold_C_CLK_posedge_posedge(43),
         HoldLow              => thold_C_CLK_negedge_posedge(43),
         CheckEnabled         => (TO_X01((not RSTC_dly) and (CEC_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(44),
         TimingData           => Tmkr_C_CLK_posedge(44),
         TestSignal           => C_dly(44),
         TestSignalName       => "C(44)",
         TestDelay            => tisd_C_CLK(44),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(44),
         SetupLow             => tsetup_C_CLK_negedge_posedge(44),
         HoldHigh             => thold_C_CLK_posedge_posedge(44),
         HoldLow              => thold_C_CLK_negedge_posedge(44),
         CheckEnabled         => (TO_X01((not RSTC_dly) and (CEC_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(45),
         TimingData           => Tmkr_C_CLK_posedge(45),
         TestSignal           => C_dly(45),
         TestSignalName       => "C(45)",
         TestDelay            => tisd_C_CLK(45),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(45),
         SetupLow             => tsetup_C_CLK_negedge_posedge(45),
         HoldHigh             => thold_C_CLK_posedge_posedge(45),
         HoldLow              => thold_C_CLK_negedge_posedge(45),
         CheckEnabled         => (TO_X01((not RSTC_dly) and (CEC_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(46),
         TimingData           => Tmkr_C_CLK_posedge(46),
         TestSignal           => C_dly(46),
         TestSignalName       => "C(46)",
         TestDelay            => tisd_C_CLK(46),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(46),
         SetupLow             => tsetup_C_CLK_negedge_posedge(46),
         HoldHigh             => thold_C_CLK_posedge_posedge(46),
         HoldLow              => thold_C_CLK_negedge_posedge(46),
         CheckEnabled         => (TO_X01((not RSTC_dly) and (CEC_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(47),
         TimingData           => Tmkr_C_CLK_posedge(47),
         TestSignal           => C_dly(47),
         TestSignalName       => "C(47)",
         TestDelay            => tisd_C_CLK(47),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(47),
         SetupLow             => tsetup_C_CLK_negedge_posedge(47),
         HoldHigh             => thold_C_CLK_posedge_posedge(47),
         HoldLow              => thold_C_CLK_negedge_posedge(47),
         CheckEnabled         => (TO_X01((not RSTC_dly) and (CEC_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
--=====  Vital SetupHold Checks signal CARRYCASCIN =====
       VitalSetupHoldCheck (
         Violation            => Tviol_CARRYCASCIN_CLK_posedge,
         TimingData           => Tmkr_CARRYCASCIN_CLK_posedge,
         TestSignal           => CARRYCASCIN_dly,
         TestSignalName       => "CARRYCASCIN",
         TestDelay            => tisd_CARRYCASCIN_CLK,
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_CARRYCASCIN_CLK_posedge_posedge,
         SetupLow             => tsetup_CARRYCASCIN_CLK_negedge_posedge,
         HoldHigh             => thold_CARRYCASCIN_CLK_posedge_posedge,
         HoldLow              => thold_CARRYCASCIN_CLK_negedge_posedge,
         CheckEnabled         => (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => true,
         MsgSeverity          => Warning);
--=====  Vital SetupHold Checks signal CARRYIN =====
       VitalSetupHoldCheck (
         Violation            => Tviol_CARRYIN_CLK_posedge,
         TimingData           => Tmkr_CARRYIN_CLK_posedge,
         TestSignal           => CARRYIN_dly,
         TestSignalName       => "CARRYIN",
         TestDelay            => tisd_CARRYIN_CLK,
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_CARRYIN_CLK_posedge_posedge,
         SetupLow             => tsetup_CARRYIN_CLK_negedge_posedge,
         HoldHigh             => thold_CARRYIN_CLK_posedge_posedge,
         HoldLow              => thold_CARRYIN_CLK_negedge_posedge,
         CheckEnabled         => (TO_X01((not RSTALLCARRYIN_dly) and (CECARRYIN_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => true,
         MsgSeverity          => Warning);
--=====  Vital SetupHold Checks for Bus signal CARRYINSEL =====
       VitalSetupHoldCheck (
         Violation            => Tviol_CARRYINSEL_CLK_posedge(0),
         TimingData           => Tmkr_CARRYINSEL_CLK_posedge(0),
         TestSignal           => CARRYINSEL_dly(0),
         TestSignalName       => "CARRYINSEL(0)",
         TestDelay            => tisd_CARRYINSEL_CLK(0),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_CARRYINSEL_CLK_posedge_posedge(0),
         SetupLow             => tsetup_CARRYINSEL_CLK_negedge_posedge(0),
         HoldHigh             => thold_CARRYINSEL_CLK_posedge_posedge(0),
         HoldLow              => thold_CARRYINSEL_CLK_negedge_posedge(0),
         CheckEnabled         => (TO_X01((not RSTA_dly) and (not RSTB_dly) and (not RSTCTRL_dly) and (CECTRL_dly)) /= '0') and (((AREG = 1) and (TO_X01(CEA2) = '1'))  or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))) and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_CARRYINSEL_CLK_posedge(1),
         TimingData           => Tmkr_CARRYINSEL_CLK_posedge(1),
         TestSignal           => CARRYINSEL_dly(1),
         TestSignalName       => "CARRYINSEL(1)",
         TestDelay            => tisd_CARRYINSEL_CLK(1),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_CARRYINSEL_CLK_posedge_posedge(1),
         SetupLow             => tsetup_CARRYINSEL_CLK_negedge_posedge(1),
         HoldHigh             => thold_CARRYINSEL_CLK_posedge_posedge(1),
         HoldLow              => thold_CARRYINSEL_CLK_negedge_posedge(1),
         CheckEnabled         => (TO_X01((not RSTA_dly) and (not RSTB_dly) and (not RSTCTRL_dly) and (CECTRL_dly)) /= '0') and (((AREG = 1) and (TO_X01(CEA2) = '1'))  or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))) and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_CARRYINSEL_CLK_posedge(2),
         TimingData           => Tmkr_CARRYINSEL_CLK_posedge(2),
         TestSignal           => CARRYINSEL_dly(2),
         TestSignalName       => "CARRYINSEL(2)",
         TestDelay            => tisd_CARRYINSEL_CLK(2),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_CARRYINSEL_CLK_posedge_posedge(2),
         SetupLow             => tsetup_CARRYINSEL_CLK_negedge_posedge(2),
         HoldHigh             => thold_CARRYINSEL_CLK_posedge_posedge(2),
         HoldLow              => thold_CARRYINSEL_CLK_negedge_posedge(2),
         CheckEnabled         => (TO_X01((not RSTA_dly) and (not RSTB_dly) and (not RSTCTRL_dly) and (CECTRL_dly)) /= '0') and (((AREG = 1) and (TO_X01(CEA2) = '1'))  or ((AREG = 2) and (TO_X01(CEA1) = '1') and (TO_X01(CEA2) =  '1'))) and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
--=====  Vital SetupHold Checks signal CEA1 =====
       VitalSetupHoldCheck (
         Violation            => Tviol_CEA1_CLK_posedge,
         TimingData           => Tmkr_CEA1_CLK_posedge,
         TestSignal           => CEA1_dly,
         TestSignalName       => "CEA1",
         TestDelay            => tisd_CEA1_CLK,
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_CEA1_CLK_posedge_posedge,
         SetupLow             => tsetup_CEA1_CLK_negedge_posedge,
         HoldHigh             => thold_CEA1_CLK_posedge_posedge,
         HoldLow              => thold_CEA1_CLK_negedge_posedge,
         CheckEnabled         => (TO_X01(not RSTA_dly) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => true,
         MsgSeverity          => Warning);
--=====  Vital SetupHold Checks signal CEA2 =====
       VitalSetupHoldCheck (
         Violation            => Tviol_CEA2_CLK_posedge,
         TimingData           => Tmkr_CEA2_CLK_posedge,
         TestSignal           => CEA2_dly,
         TestSignalName       => "CEA2",
         TestDelay            => tisd_CEA2_CLK,
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_CEA2_CLK_posedge_posedge,
         SetupLow             => tsetup_CEA2_CLK_negedge_posedge,
         HoldHigh             => thold_CEA2_CLK_posedge_posedge,
         HoldLow              => thold_CEA2_CLK_negedge_posedge,
         CheckEnabled         => (TO_X01(not RSTA_dly) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => true,
         MsgSeverity          => Warning);
--=====  Vital SetupHold Checks signal CEALUMODE =====
       VitalSetupHoldCheck (
         Violation            => Tviol_CEALUMODE_CLK_posedge,
         TimingData           => Tmkr_CEALUMODE_CLK_posedge,
         TestSignal           => CEALUMODE_dly,
         TestSignalName       => "CEALUMODE",
         TestDelay            => tisd_CEALUMODE_CLK,
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_CEALUMODE_CLK_posedge_posedge,
         SetupLow             => tsetup_CEALUMODE_CLK_negedge_posedge,
         HoldHigh             => thold_CEALUMODE_CLK_posedge_posedge,
         HoldLow              => thold_CEALUMODE_CLK_negedge_posedge,
         CheckEnabled         => (TO_X01(not RSTALUMODE_dly) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => true,
         MsgSeverity          => Warning);
--=====  Vital SetupHold Checks signal CEB1 =====
       VitalSetupHoldCheck (
         Violation            => Tviol_CEB1_CLK_posedge,
         TimingData           => Tmkr_CEB1_CLK_posedge,
         TestSignal           => CEB1_dly,
         TestSignalName       => "CEB1",
         TestDelay            => tisd_CEB1_CLK,
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_CEB1_CLK_posedge_posedge,
         SetupLow             => tsetup_CEB1_CLK_negedge_posedge,
         HoldHigh             => thold_CEB1_CLK_posedge_posedge,
         HoldLow              => thold_CEB1_CLK_negedge_posedge,
         CheckEnabled         => (TO_X01(not RSTB_dly) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => true,
         MsgSeverity          => Warning);
--=====  Vital SetupHold Checks signal CEB2 =====
       VitalSetupHoldCheck (
         Violation            => Tviol_CEB2_CLK_posedge,
         TimingData           => Tmkr_CEB2_CLK_posedge,
         TestSignal           => CEB2_dly,
         TestSignalName       => "CEB2",
         TestDelay            => tisd_CEB2_CLK,
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_CEB2_CLK_posedge_posedge,
         SetupLow             => tsetup_CEB2_CLK_negedge_posedge,
         HoldHigh             => thold_CEB2_CLK_posedge_posedge,
         HoldLow              => thold_CEB2_CLK_negedge_posedge,
         CheckEnabled         => (TO_X01(not RSTB_dly) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => true,
         MsgSeverity          => Warning);
--=====  Vital SetupHold Checks signal CEC =====
       VitalSetupHoldCheck (
         Violation            => Tviol_CEC_CLK_posedge,
         TimingData           => Tmkr_CEC_CLK_posedge,
         TestSignal           => CEC_dly,
         TestSignalName       => "CEC",
         TestDelay            => tisd_CEC_CLK,
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_CEC_CLK_posedge_posedge,
         SetupLow             => tsetup_CEC_CLK_negedge_posedge,
         HoldHigh             => thold_CEC_CLK_posedge_posedge,
         HoldLow              => thold_CEC_CLK_negedge_posedge,
         CheckEnabled         => (TO_X01(not RSTC_dly) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => true,
         MsgSeverity          => Warning);
--=====  Vital SetupHold Checks signal CECARRYIN =====
       VitalSetupHoldCheck (
         Violation            => Tviol_CECARRYIN_CLK_posedge,
         TimingData           => Tmkr_CECARRYIN_CLK_posedge,
         TestSignal           => CECARRYIN_dly,
         TestSignalName       => "CECARRYIN",
         TestDelay            => tisd_CECARRYIN_CLK,
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_CECARRYIN_CLK_posedge_posedge,
         SetupLow             => tsetup_CECARRYIN_CLK_negedge_posedge,
         HoldHigh             => thold_CECARRYIN_CLK_posedge_posedge,
         HoldLow              => thold_CECARRYIN_CLK_negedge_posedge,
         CheckEnabled         => (TO_X01((not RSTALLCARRYIN_dly) and (CECARRYIN_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => true,
         MsgSeverity          => Warning);
--=====  Vital SetupHold Checks signal CECTRL =====
       VitalSetupHoldCheck (
         Violation            => Tviol_CECTRL_CLK_posedge,
         TimingData           => Tmkr_CECTRL_CLK_posedge,
         TestSignal           => CECTRL_dly,
         TestSignalName       => "CECTRL",
         TestDelay            => tisd_CECTRL_CLK,
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_CECTRL_CLK_posedge_posedge,
         SetupLow             => tsetup_CECTRL_CLK_negedge_posedge,
         HoldHigh             => thold_CECTRL_CLK_posedge_posedge,
         HoldLow              => thold_CECTRL_CLK_negedge_posedge,
         CheckEnabled         => (TO_X01(not RSTCTRL_dly) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => true,
         MsgSeverity          => Warning);
--=====  Vital SetupHold Checks signal CEM =====
       VitalSetupHoldCheck (
         Violation            => Tviol_CEM_CLK_posedge,
         TimingData           => Tmkr_CEM_CLK_posedge,
         TestSignal           => CEM_dly,
         TestSignalName       => "CEM",
         TestDelay            => tisd_CEM_CLK,
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_CEM_CLK_posedge_posedge,
         SetupLow             => tsetup_CEM_CLK_negedge_posedge,
         HoldHigh             => thold_CEM_CLK_posedge_posedge,
         HoldLow              => thold_CEM_CLK_negedge_posedge,
         CheckEnabled         => (TO_X01(not RSTM_dly) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => true,
         MsgSeverity          => Warning);
--=====  Vital SetupHold Checks signal CEP =====
       VitalSetupHoldCheck (
         Violation            => Tviol_CEP_CLK_posedge,
         TimingData           => Tmkr_CEP_CLK_posedge,
         TestSignal           => CEP_dly,
         TestSignalName       => "CEP",
         TestDelay            => tisd_CEP_CLK,
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_CEP_CLK_posedge_posedge,
         SetupLow             => tsetup_CEP_CLK_negedge_posedge,
         HoldHigh             => thold_CEP_CLK_posedge_posedge,
         HoldLow              => thold_CEP_CLK_negedge_posedge,
         CheckEnabled         => (TO_X01(not RSTP_dly) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => true,
         MsgSeverity          => Warning);
--=====  Vital SetupHold Checks for Bus signal OPMODE =====
       VitalSetupHoldCheck (
         Violation            => Tviol_OPMODE_CLK_posedge(0),
         TimingData           => Tmkr_OPMODE_CLK_posedge(0),
         TestSignal           => OPMODE_dly(0),
         TestSignalName       => "OPMODE(0)",
         TestDelay            => tisd_OPMODE_CLK(0),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_OPMODE_CLK_posedge_posedge(0),
         SetupLow             => tsetup_OPMODE_CLK_negedge_posedge(0),
         HoldHigh             => thold_OPMODE_CLK_posedge_posedge(0),
         HoldLow              => thold_OPMODE_CLK_negedge_posedge(0),
         CheckEnabled         => (TO_X01((not RSTCTRL_dly) and (CECTRL_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_OPMODE_CLK_posedge(1),
         TimingData           => Tmkr_OPMODE_CLK_posedge(1),
         TestSignal           => OPMODE_dly(1),
         TestSignalName       => "OPMODE(1)",
         TestDelay            => tisd_OPMODE_CLK(1),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_OPMODE_CLK_posedge_posedge(1),
         SetupLow             => tsetup_OPMODE_CLK_negedge_posedge(1),
         HoldHigh             => thold_OPMODE_CLK_posedge_posedge(1),
         HoldLow              => thold_OPMODE_CLK_negedge_posedge(1),
         CheckEnabled         => (TO_X01((not RSTCTRL_dly) and (CECTRL_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_OPMODE_CLK_posedge(2),
         TimingData           => Tmkr_OPMODE_CLK_posedge(2),
         TestSignal           => OPMODE_dly(2),
         TestSignalName       => "OPMODE(2)",
         TestDelay            => tisd_OPMODE_CLK(2),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_OPMODE_CLK_posedge_posedge(2),
         SetupLow             => tsetup_OPMODE_CLK_negedge_posedge(2),
         HoldHigh             => thold_OPMODE_CLK_posedge_posedge(2),
         HoldLow              => thold_OPMODE_CLK_negedge_posedge(2),
         CheckEnabled         => (TO_X01((not RSTCTRL_dly) and (CECTRL_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_OPMODE_CLK_posedge(3),
         TimingData           => Tmkr_OPMODE_CLK_posedge(3),
         TestSignal           => OPMODE_dly(3),
         TestSignalName       => "OPMODE(3)",
         TestDelay            => tisd_OPMODE_CLK(3),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_OPMODE_CLK_posedge_posedge(3),
         SetupLow             => tsetup_OPMODE_CLK_negedge_posedge(3),
         HoldHigh             => thold_OPMODE_CLK_posedge_posedge(3),
         HoldLow              => thold_OPMODE_CLK_negedge_posedge(3),
         CheckEnabled         => (TO_X01((not RSTCTRL_dly) and (CECTRL_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_OPMODE_CLK_posedge(4),
         TimingData           => Tmkr_OPMODE_CLK_posedge(4),
         TestSignal           => OPMODE_dly(4),
         TestSignalName       => "OPMODE(4)",
         TestDelay            => tisd_OPMODE_CLK(4),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_OPMODE_CLK_posedge_posedge(4),
         SetupLow             => tsetup_OPMODE_CLK_negedge_posedge(4),
         HoldHigh             => thold_OPMODE_CLK_posedge_posedge(4),
         HoldLow              => thold_OPMODE_CLK_negedge_posedge(4),
         CheckEnabled         => (TO_X01((not RSTCTRL_dly) and (CECTRL_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_OPMODE_CLK_posedge(5),
         TimingData           => Tmkr_OPMODE_CLK_posedge(5),
         TestSignal           => OPMODE_dly(5),
         TestSignalName       => "OPMODE(5)",
         TestDelay            => tisd_OPMODE_CLK(5),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_OPMODE_CLK_posedge_posedge(5),
         SetupLow             => tsetup_OPMODE_CLK_negedge_posedge(5),
         HoldHigh             => thold_OPMODE_CLK_posedge_posedge(5),
         HoldLow              => thold_OPMODE_CLK_negedge_posedge(5),
         CheckEnabled         => (TO_X01((not RSTCTRL_dly) and (CECTRL_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_OPMODE_CLK_posedge(6),
         TimingData           => Tmkr_OPMODE_CLK_posedge(6),
         TestSignal           => OPMODE_dly(6),
         TestSignalName       => "OPMODE(6)",
         TestDelay            => tisd_OPMODE_CLK(6),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_OPMODE_CLK_posedge_posedge(6),
         SetupLow             => tsetup_OPMODE_CLK_negedge_posedge(6),
         HoldHigh             => thold_OPMODE_CLK_posedge_posedge(6),
         HoldLow              => thold_OPMODE_CLK_negedge_posedge(6),
         CheckEnabled         => (TO_X01((not RSTCTRL_dly) and (CECTRL_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
--=====  Vital SetupHold Checks for Bus signal PCIN =====
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(0),
         TimingData           => Tmkr_PCIN_CLK_posedge(0),
         TestSignal           => PCIN_dly(0),
         TestSignalName       => "PCIN(0)",
         TestDelay            => tisd_PCIN_CLK(0),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(0),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(0),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(0),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(0),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(1),
         TimingData           => Tmkr_PCIN_CLK_posedge(1),
         TestSignal           => PCIN_dly(1),
         TestSignalName       => "PCIN(1)",
         TestDelay            => tisd_PCIN_CLK(1),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(1),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(1),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(1),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(1),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(2),
         TimingData           => Tmkr_PCIN_CLK_posedge(2),
         TestSignal           => PCIN_dly(2),
         TestSignalName       => "PCIN(2)",
         TestDelay            => tisd_PCIN_CLK(2),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(2),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(2),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(2),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(2),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(3),
         TimingData           => Tmkr_PCIN_CLK_posedge(3),
         TestSignal           => PCIN_dly(3),
         TestSignalName       => "PCIN(3)",
         TestDelay            => tisd_PCIN_CLK(3),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(3),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(3),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(3),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(3),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(4),
         TimingData           => Tmkr_PCIN_CLK_posedge(4),
         TestSignal           => PCIN_dly(4),
         TestSignalName       => "PCIN(4)",
         TestDelay            => tisd_PCIN_CLK(4),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(4),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(4),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(4),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(4),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(5),
         TimingData           => Tmkr_PCIN_CLK_posedge(5),
         TestSignal           => PCIN_dly(5),
         TestSignalName       => "PCIN(5)",
         TestDelay            => tisd_PCIN_CLK(5),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(5),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(5),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(5),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(5),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(6),
         TimingData           => Tmkr_PCIN_CLK_posedge(6),
         TestSignal           => PCIN_dly(6),
         TestSignalName       => "PCIN(6)",
         TestDelay            => tisd_PCIN_CLK(6),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(6),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(6),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(6),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(6),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(7),
         TimingData           => Tmkr_PCIN_CLK_posedge(7),
         TestSignal           => PCIN_dly(7),
         TestSignalName       => "PCIN(7)",
         TestDelay            => tisd_PCIN_CLK(7),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(7),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(7),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(7),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(7),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(8),
         TimingData           => Tmkr_PCIN_CLK_posedge(8),
         TestSignal           => PCIN_dly(8),
         TestSignalName       => "PCIN(8)",
         TestDelay            => tisd_PCIN_CLK(8),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(8),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(8),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(8),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(8),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(9),
         TimingData           => Tmkr_PCIN_CLK_posedge(9),
         TestSignal           => PCIN_dly(9),
         TestSignalName       => "PCIN(9)",
         TestDelay            => tisd_PCIN_CLK(9),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(9),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(9),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(9),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(9),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(10),
         TimingData           => Tmkr_PCIN_CLK_posedge(10),
         TestSignal           => PCIN_dly(10),
         TestSignalName       => "PCIN(10)",
         TestDelay            => tisd_PCIN_CLK(10),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(10),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(10),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(10),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(10),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(11),
         TimingData           => Tmkr_PCIN_CLK_posedge(11),
         TestSignal           => PCIN_dly(11),
         TestSignalName       => "PCIN(11)",
         TestDelay            => tisd_PCIN_CLK(11),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(11),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(11),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(11),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(11),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(12),
         TimingData           => Tmkr_PCIN_CLK_posedge(12),
         TestSignal           => PCIN_dly(12),
         TestSignalName       => "PCIN(12)",
         TestDelay            => tisd_PCIN_CLK(12),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(12),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(12),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(12),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(12),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(13),
         TimingData           => Tmkr_PCIN_CLK_posedge(13),
         TestSignal           => PCIN_dly(13),
         TestSignalName       => "PCIN(13)",
         TestDelay            => tisd_PCIN_CLK(13),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(13),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(13),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(13),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(13),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(14),
         TimingData           => Tmkr_PCIN_CLK_posedge(14),
         TestSignal           => PCIN_dly(14),
         TestSignalName       => "PCIN(14)",
         TestDelay            => tisd_PCIN_CLK(14),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(14),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(14),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(14),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(14),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(15),
         TimingData           => Tmkr_PCIN_CLK_posedge(15),
         TestSignal           => PCIN_dly(15),
         TestSignalName       => "PCIN(15)",
         TestDelay            => tisd_PCIN_CLK(15),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(15),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(15),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(15),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(15),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(16),
         TimingData           => Tmkr_PCIN_CLK_posedge(16),
         TestSignal           => PCIN_dly(16),
         TestSignalName       => "PCIN(16)",
         TestDelay            => tisd_PCIN_CLK(16),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(16),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(16),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(16),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(16),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(17),
         TimingData           => Tmkr_PCIN_CLK_posedge(17),
         TestSignal           => PCIN_dly(17),
         TestSignalName       => "PCIN(17)",
         TestDelay            => tisd_PCIN_CLK(17),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(17),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(17),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(17),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(17),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(18),
         TimingData           => Tmkr_PCIN_CLK_posedge(18),
         TestSignal           => PCIN_dly(18),
         TestSignalName       => "PCIN(18)",
         TestDelay            => tisd_PCIN_CLK(18),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(18),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(18),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(18),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(18),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(19),
         TimingData           => Tmkr_PCIN_CLK_posedge(19),
         TestSignal           => PCIN_dly(19),
         TestSignalName       => "PCIN(19)",
         TestDelay            => tisd_PCIN_CLK(19),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(19),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(19),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(19),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(19),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(20),
         TimingData           => Tmkr_PCIN_CLK_posedge(20),
         TestSignal           => PCIN_dly(20),
         TestSignalName       => "PCIN(20)",
         TestDelay            => tisd_PCIN_CLK(20),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(20),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(20),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(20),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(20),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(21),
         TimingData           => Tmkr_PCIN_CLK_posedge(21),
         TestSignal           => PCIN_dly(21),
         TestSignalName       => "PCIN(21)",
         TestDelay            => tisd_PCIN_CLK(21),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(21),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(21),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(21),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(21),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(22),
         TimingData           => Tmkr_PCIN_CLK_posedge(22),
         TestSignal           => PCIN_dly(22),
         TestSignalName       => "PCIN(22)",
         TestDelay            => tisd_PCIN_CLK(22),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(22),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(22),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(22),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(22),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(23),
         TimingData           => Tmkr_PCIN_CLK_posedge(23),
         TestSignal           => PCIN_dly(23),
         TestSignalName       => "PCIN(23)",
         TestDelay            => tisd_PCIN_CLK(23),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(23),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(23),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(23),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(23),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(24),
         TimingData           => Tmkr_PCIN_CLK_posedge(24),
         TestSignal           => PCIN_dly(24),
         TestSignalName       => "PCIN(24)",
         TestDelay            => tisd_PCIN_CLK(24),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(24),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(24),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(24),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(24),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(25),
         TimingData           => Tmkr_PCIN_CLK_posedge(25),
         TestSignal           => PCIN_dly(25),
         TestSignalName       => "PCIN(25)",
         TestDelay            => tisd_PCIN_CLK(25),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(25),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(25),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(25),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(25),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(26),
         TimingData           => Tmkr_PCIN_CLK_posedge(26),
         TestSignal           => PCIN_dly(26),
         TestSignalName       => "PCIN(26)",
         TestDelay            => tisd_PCIN_CLK(26),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(26),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(26),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(26),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(26),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(27),
         TimingData           => Tmkr_PCIN_CLK_posedge(27),
         TestSignal           => PCIN_dly(27),
         TestSignalName       => "PCIN(27)",
         TestDelay            => tisd_PCIN_CLK(27),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(27),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(27),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(27),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(27),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(28),
         TimingData           => Tmkr_PCIN_CLK_posedge(28),
         TestSignal           => PCIN_dly(28),
         TestSignalName       => "PCIN(28)",
         TestDelay            => tisd_PCIN_CLK(28),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(28),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(28),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(28),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(28),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(29),
         TimingData           => Tmkr_PCIN_CLK_posedge(29),
         TestSignal           => PCIN_dly(29),
         TestSignalName       => "PCIN(29)",
         TestDelay            => tisd_PCIN_CLK(29),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(29),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(29),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(29),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(29),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(30),
         TimingData           => Tmkr_PCIN_CLK_posedge(30),
         TestSignal           => PCIN_dly(30),
         TestSignalName       => "PCIN(30)",
         TestDelay            => tisd_PCIN_CLK(30),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(30),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(30),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(30),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(30),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(31),
         TimingData           => Tmkr_PCIN_CLK_posedge(31),
         TestSignal           => PCIN_dly(31),
         TestSignalName       => "PCIN(31)",
         TestDelay            => tisd_PCIN_CLK(31),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(31),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(31),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(31),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(31),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(32),
         TimingData           => Tmkr_PCIN_CLK_posedge(32),
         TestSignal           => PCIN_dly(32),
         TestSignalName       => "PCIN(32)",
         TestDelay            => tisd_PCIN_CLK(32),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(32),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(32),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(32),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(32),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(33),
         TimingData           => Tmkr_PCIN_CLK_posedge(33),
         TestSignal           => PCIN_dly(33),
         TestSignalName       => "PCIN(33)",
         TestDelay            => tisd_PCIN_CLK(33),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(33),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(33),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(33),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(33),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(34),
         TimingData           => Tmkr_PCIN_CLK_posedge(34),
         TestSignal           => PCIN_dly(34),
         TestSignalName       => "PCIN(34)",
         TestDelay            => tisd_PCIN_CLK(34),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(34),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(34),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(34),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(34),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(35),
         TimingData           => Tmkr_PCIN_CLK_posedge(35),
         TestSignal           => PCIN_dly(35),
         TestSignalName       => "PCIN(35)",
         TestDelay            => tisd_PCIN_CLK(35),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(35),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(35),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(35),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(35),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(36),
         TimingData           => Tmkr_PCIN_CLK_posedge(36),
         TestSignal           => PCIN_dly(36),
         TestSignalName       => "PCIN(36)",
         TestDelay            => tisd_PCIN_CLK(36),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(36),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(36),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(36),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(36),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(37),
         TimingData           => Tmkr_PCIN_CLK_posedge(37),
         TestSignal           => PCIN_dly(37),
         TestSignalName       => "PCIN(37)",
         TestDelay            => tisd_PCIN_CLK(37),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(37),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(37),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(37),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(37),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(38),
         TimingData           => Tmkr_PCIN_CLK_posedge(38),
         TestSignal           => PCIN_dly(38),
         TestSignalName       => "PCIN(38)",
         TestDelay            => tisd_PCIN_CLK(38),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(38),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(38),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(38),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(38),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(39),
         TimingData           => Tmkr_PCIN_CLK_posedge(39),
         TestSignal           => PCIN_dly(39),
         TestSignalName       => "PCIN(39)",
         TestDelay            => tisd_PCIN_CLK(39),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(39),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(39),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(39),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(39),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(40),
         TimingData           => Tmkr_PCIN_CLK_posedge(40),
         TestSignal           => PCIN_dly(40),
         TestSignalName       => "PCIN(40)",
         TestDelay            => tisd_PCIN_CLK(40),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(40),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(40),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(40),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(40),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(41),
         TimingData           => Tmkr_PCIN_CLK_posedge(41),
         TestSignal           => PCIN_dly(41),
         TestSignalName       => "PCIN(41)",
         TestDelay            => tisd_PCIN_CLK(41),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(41),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(41),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(41),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(41),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(42),
         TimingData           => Tmkr_PCIN_CLK_posedge(42),
         TestSignal           => PCIN_dly(42),
         TestSignalName       => "PCIN(42)",
         TestDelay            => tisd_PCIN_CLK(42),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(42),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(42),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(42),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(42),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(43),
         TimingData           => Tmkr_PCIN_CLK_posedge(43),
         TestSignal           => PCIN_dly(43),
         TestSignalName       => "PCIN(43)",
         TestDelay            => tisd_PCIN_CLK(43),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(43),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(43),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(43),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(43),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(44),
         TimingData           => Tmkr_PCIN_CLK_posedge(44),
         TestSignal           => PCIN_dly(44),
         TestSignalName       => "PCIN(44)",
         TestDelay            => tisd_PCIN_CLK(44),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(44),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(44),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(44),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(44),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(45),
         TimingData           => Tmkr_PCIN_CLK_posedge(45),
         TestSignal           => PCIN_dly(45),
         TestSignalName       => "PCIN(45)",
         TestDelay            => tisd_PCIN_CLK(45),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(45),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(45),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(45),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(45),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(46),
         TimingData           => Tmkr_PCIN_CLK_posedge(46),
         TestSignal           => PCIN_dly(46),
         TestSignalName       => "PCIN(46)",
         TestDelay            => tisd_PCIN_CLK(46),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(46),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(46),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(46),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(46),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(47),
         TimingData           => Tmkr_PCIN_CLK_posedge(47),
         TestSignal           => PCIN_dly(47),
         TestSignalName       => "PCIN(47)",
         TestDelay            => tisd_PCIN_CLK(47),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(47),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(47),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(47),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(47),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
--=====  Vital SetupHold Checks signal RSTA =====
       VitalSetupHoldCheck (
         Violation            => Tviol_RSTA_CLK_posedge,
         TimingData           => Tmkr_RSTA_CLK_posedge,
         TestSignal           => RSTA_dly,
         TestSignalName       => "RSTA",
         TestDelay            => tisd_RSTA_CLK,
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_RSTA_CLK_posedge_posedge,
         SetupLow             => tsetup_RSTA_CLK_negedge_posedge,
         HoldHigh             => thold_RSTA_CLK_posedge_posedge,
         HoldLow              => thold_RSTA_CLK_negedge_posedge,
         CheckEnabled         => (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => true,
         MsgSeverity          => Warning);
--=====  Vital SetupHold Checks signal RSTALUMODE =====
       VitalSetupHoldCheck (
         Violation            => Tviol_RSTALUMODE_CLK_posedge,
         TimingData           => Tmkr_RSTALUMODE_CLK_posedge,
         TestSignal           => RSTALUMODE_dly,
         TestSignalName       => "RSTALUMODE",
         TestDelay            => tisd_RSTALUMODE_CLK,
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_RSTALUMODE_CLK_posedge_posedge,
         SetupLow             => tsetup_RSTALUMODE_CLK_negedge_posedge,
         HoldHigh             => thold_RSTALUMODE_CLK_posedge_posedge,
         HoldLow              => thold_RSTALUMODE_CLK_negedge_posedge,
         CheckEnabled         => (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => true,
         MsgSeverity          => Warning);
--=====  Vital SetupHold Checks signal RSTB =====
       VitalSetupHoldCheck (
         Violation            => Tviol_RSTB_CLK_posedge,
         TimingData           => Tmkr_RSTB_CLK_posedge,
         TestSignal           => RSTB_dly,
         TestSignalName       => "RSTB",
         TestDelay            => tisd_RSTB_CLK,
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_RSTB_CLK_posedge_posedge,
         SetupLow             => tsetup_RSTB_CLK_negedge_posedge,
         HoldHigh             => thold_RSTB_CLK_posedge_posedge,
         HoldLow              => thold_RSTB_CLK_negedge_posedge,
         CheckEnabled         => (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => true,
         MsgSeverity          => Warning);
--=====  Vital SetupHold Checks signal RSTC =====
       VitalSetupHoldCheck (
         Violation            => Tviol_RSTC_CLK_posedge,
         TimingData           => Tmkr_RSTC_CLK_posedge,
         TestSignal           => RSTC_dly,
         TestSignalName       => "RSTC",
         TestDelay            => tisd_RSTC_CLK,
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_RSTC_CLK_posedge_posedge,
         SetupLow             => tsetup_RSTC_CLK_negedge_posedge,
         HoldHigh             => thold_RSTC_CLK_posedge_posedge,
         HoldLow              => thold_RSTC_CLK_negedge_posedge,
         CheckEnabled         => (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => true,
         MsgSeverity          => Warning);
--=====  Vital SetupHold Checks signal RSTALLCARRYIN =====
       VitalSetupHoldCheck (
         Violation            => Tviol_RSTALLCARRYIN_CLK_posedge,
         TimingData           => Tmkr_RSTALLCARRYIN_CLK_posedge,
         TestSignal           => RSTALLCARRYIN_dly,
         TestSignalName       => "RSTALLCARRYIN",
         TestDelay            => tisd_RSTALLCARRYIN_CLK,
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_RSTALLCARRYIN_CLK_posedge_posedge,
         SetupLow             => tsetup_RSTALLCARRYIN_CLK_negedge_posedge,
         HoldHigh             => thold_RSTALLCARRYIN_CLK_posedge_posedge,
         HoldLow              => thold_RSTALLCARRYIN_CLK_negedge_posedge,
         CheckEnabled         => (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => true,
         MsgSeverity          => Warning);
--=====  Vital SetupHold Checks signal RSTCTRL =====
       VitalSetupHoldCheck (
         Violation            => Tviol_RSTCTRL_CLK_posedge,
         TimingData           => Tmkr_RSTCTRL_CLK_posedge,
         TestSignal           => RSTCTRL_dly,
         TestSignalName       => "RSTCTRL",
         TestDelay            => tisd_RSTCTRL_CLK,
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_RSTCTRL_CLK_posedge_posedge,
         SetupLow             => tsetup_RSTCTRL_CLK_negedge_posedge,
         HoldHigh             => thold_RSTCTRL_CLK_posedge_posedge,
         HoldLow              => thold_RSTCTRL_CLK_negedge_posedge,
         CheckEnabled         => (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => true,
         MsgSeverity          => Warning);
--=====  Vital SetupHold Checks signal RSTM =====
       VitalSetupHoldCheck (
         Violation            => Tviol_RSTM_CLK_posedge,
         TimingData           => Tmkr_RSTM_CLK_posedge,
         TestSignal           => RSTM_dly,
         TestSignalName       => "RSTM",
         TestDelay            => tisd_RSTM_CLK,
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_RSTM_CLK_posedge_posedge,
         SetupLow             => tsetup_RSTM_CLK_negedge_posedge,
         HoldHigh             => thold_RSTM_CLK_posedge_posedge,
         HoldLow              => thold_RSTM_CLK_negedge_posedge,
         CheckEnabled         => (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => true,
         MsgSeverity          => Warning);
--=====  Vital SetupHold Checks signal RSTP =====
       VitalSetupHoldCheck (
         Violation            => Tviol_RSTP_CLK_posedge,
         TimingData           => Tmkr_RSTP_CLK_posedge,
         TestSignal           => RSTP_dly,
         TestSignalName       => "RSTP",
         TestDelay            => tisd_RSTP_CLK,
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_RSTP_CLK_posedge_posedge,
         SetupLow             => tsetup_RSTP_CLK_negedge_posedge,
         HoldHigh             => thold_RSTP_CLK_posedge_posedge,
         HoldLow              => thold_RSTP_CLK_negedge_posedge,
         CheckEnabled         => (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48E",
         Xon                  => Xon,
         MsgOn                => true,
         MsgSeverity          => Warning);
   end if;
-- End of (TimingChecksOn)

--  Output-to-Clock path delay
-- START
       VitalPathDelay01 (
         OutSignal	=> ACOUT(29),
         GlitchData	=> ACOUT_GlitchData(29),
         OutSignalName	=> "ACOUT(29)",
         OutTemp	=> ACOUT_zd(29),
         Paths		=> (
			0 => (A_ipd(29)'last_event, tpd_A_ACOUT((899 - 0)- 30*0), true),
			1 => (A_ipd(28)'last_event, tpd_A_ACOUT((899 - 0)- 30*1), true),
			2 => (A_ipd(27)'last_event, tpd_A_ACOUT((899 - 0)- 30*2), true),
			3 => (A_ipd(26)'last_event, tpd_A_ACOUT((899 - 0)- 30*3), true),
			4 => (A_ipd(25)'last_event, tpd_A_ACOUT((899 - 0)- 30*4), true),
			5 => (A_ipd(24)'last_event, tpd_A_ACOUT((899 - 0)- 30*5), true),
			6 => (A_ipd(23)'last_event, tpd_A_ACOUT((899 - 0)- 30*6), true),
			7 => (A_ipd(22)'last_event, tpd_A_ACOUT((899 - 0)- 30*7), true),
			8 => (A_ipd(21)'last_event, tpd_A_ACOUT((899 - 0)- 30*8), true),
			9 => (A_ipd(20)'last_event, tpd_A_ACOUT((899 - 0)- 30*9), true),
			10 => (A_ipd(19)'last_event, tpd_A_ACOUT((899 - 0)- 30*10), true),
			11 => (A_ipd(18)'last_event, tpd_A_ACOUT((899 - 0)- 30*11), true),
			12 => (A_ipd(17)'last_event, tpd_A_ACOUT((899 - 0)- 30*12), true),
			13 => (A_ipd(16)'last_event, tpd_A_ACOUT((899 - 0)- 30*13), true),
			14 => (A_ipd(15)'last_event, tpd_A_ACOUT((899 - 0)- 30*14), true),
			15 => (A_ipd(14)'last_event, tpd_A_ACOUT((899 - 0)- 30*15), true),
			16 => (A_ipd(13)'last_event, tpd_A_ACOUT((899 - 0)- 30*16), true),
			17 => (A_ipd(12)'last_event, tpd_A_ACOUT((899 - 0)- 30*17), true),
			18 => (A_ipd(11)'last_event, tpd_A_ACOUT((899 - 0)- 30*18), true),
			19 => (A_ipd(10)'last_event, tpd_A_ACOUT((899 - 0)- 30*19), true),
			20 => (A_ipd(9)'last_event, tpd_A_ACOUT((899 - 0)- 30*20), true),
			21 => (A_ipd(8)'last_event, tpd_A_ACOUT((899 - 0)- 30*21), true),
			22 => (A_ipd(7)'last_event, tpd_A_ACOUT((899 - 0)- 30*22), true),
			23 => (A_ipd(6)'last_event, tpd_A_ACOUT((899 - 0)- 30*23), true),
			24 => (A_ipd(5)'last_event, tpd_A_ACOUT((899 - 0)- 30*24), true),
			25 => (A_ipd(4)'last_event, tpd_A_ACOUT((899 - 0)- 30*25), true),
			26 => (A_ipd(3)'last_event, tpd_A_ACOUT((899 - 0)- 30*26), true),
			27 => (A_ipd(2)'last_event, tpd_A_ACOUT((899 - 0)- 30*27), true),
			28 => (A_ipd(1)'last_event, tpd_A_ACOUT((899 - 0)- 30*28), true),
			29 => (A_ipd(0)'last_event, tpd_A_ACOUT((899 - 0)- 30*29), true),
			30 => (ACIN_ipd(29)'last_event, tpd_ACIN_ACOUT((899 - 0)- 30*0), true),
			31 => (ACIN_ipd(28)'last_event, tpd_ACIN_ACOUT((899 - 0)- 30*1), true),
			32 => (ACIN_ipd(27)'last_event, tpd_ACIN_ACOUT((899 - 0)- 30*2), true),
			33 => (ACIN_ipd(26)'last_event, tpd_ACIN_ACOUT((899 - 0)- 30*3), true),
			34 => (ACIN_ipd(25)'last_event, tpd_ACIN_ACOUT((899 - 0)- 30*4), true),
			35 => (ACIN_ipd(24)'last_event, tpd_ACIN_ACOUT((899 - 0)- 30*5), true),
			36 => (ACIN_ipd(23)'last_event, tpd_ACIN_ACOUT((899 - 0)- 30*6), true),
			37 => (ACIN_ipd(22)'last_event, tpd_ACIN_ACOUT((899 - 0)- 30*7), true),
			38 => (ACIN_ipd(21)'last_event, tpd_ACIN_ACOUT((899 - 0)- 30*8), true),
			39 => (ACIN_ipd(20)'last_event, tpd_ACIN_ACOUT((899 - 0)- 30*9), true),
			40 => (ACIN_ipd(19)'last_event, tpd_ACIN_ACOUT((899 - 0)- 30*10), true),
			41 => (ACIN_ipd(18)'last_event, tpd_ACIN_ACOUT((899 - 0)- 30*11), true),
			42 => (ACIN_ipd(17)'last_event, tpd_ACIN_ACOUT((899 - 0)- 30*12), true),
			43 => (ACIN_ipd(16)'last_event, tpd_ACIN_ACOUT((899 - 0)- 30*13), true),
			44 => (ACIN_ipd(15)'last_event, tpd_ACIN_ACOUT((899 - 0)- 30*14), true),
			45 => (ACIN_ipd(14)'last_event, tpd_ACIN_ACOUT((899 - 0)- 30*15), true),
			46 => (ACIN_ipd(13)'last_event, tpd_ACIN_ACOUT((899 - 0)- 30*16), true),
			47 => (ACIN_ipd(12)'last_event, tpd_ACIN_ACOUT((899 - 0)- 30*17), true),
			48 => (ACIN_ipd(11)'last_event, tpd_ACIN_ACOUT((899 - 0)- 30*18), true),
			49 => (ACIN_ipd(10)'last_event, tpd_ACIN_ACOUT((899 - 0)- 30*19), true),
			50 => (ACIN_ipd(9)'last_event, tpd_ACIN_ACOUT((899 - 0)- 30*20), true),
			51 => (ACIN_ipd(8)'last_event, tpd_ACIN_ACOUT((899 - 0)- 30*21), true),
			52 => (ACIN_ipd(7)'last_event, tpd_ACIN_ACOUT((899 - 0)- 30*22), true),
			53 => (ACIN_ipd(6)'last_event, tpd_ACIN_ACOUT((899 - 0)- 30*23), true),
			54 => (ACIN_ipd(5)'last_event, tpd_ACIN_ACOUT((899 - 0)- 30*24), true),
			55 => (ACIN_ipd(4)'last_event, tpd_ACIN_ACOUT((899 - 0)- 30*25), true),
			56 => (ACIN_ipd(3)'last_event, tpd_ACIN_ACOUT((899 - 0)- 30*26), true),
			57 => (ACIN_ipd(2)'last_event, tpd_ACIN_ACOUT((899 - 0)- 30*27), true),
			58 => (ACIN_ipd(1)'last_event, tpd_ACIN_ACOUT((899 - 0)- 30*28), true),
			59 => (ACIN_ipd(0)'last_event, tpd_ACIN_ACOUT((899 - 0)- 30*29), true),
			60 => (CLK_dly'last_event, tpd_CLK_ACOUT(29), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> ACOUT(28),
         GlitchData	=> ACOUT_GlitchData(28),
         OutSignalName	=> "ACOUT(28)",
         OutTemp	=> ACOUT_zd(28),
         Paths		=> (
			0 => (A_ipd(28)'last_event, tpd_A_ACOUT((899 - 1)- 30*1), true),
			1 => (A_ipd(27)'last_event, tpd_A_ACOUT((899 - 1)- 30*2), true),
			2 => (A_ipd(26)'last_event, tpd_A_ACOUT((899 - 1)- 30*3), true),
			3 => (A_ipd(25)'last_event, tpd_A_ACOUT((899 - 1)- 30*4), true),
			4 => (A_ipd(24)'last_event, tpd_A_ACOUT((899 - 1)- 30*5), true),
			5 => (A_ipd(23)'last_event, tpd_A_ACOUT((899 - 1)- 30*6), true),
			6 => (A_ipd(22)'last_event, tpd_A_ACOUT((899 - 1)- 30*7), true),
			7 => (A_ipd(21)'last_event, tpd_A_ACOUT((899 - 1)- 30*8), true),
			8 => (A_ipd(20)'last_event, tpd_A_ACOUT((899 - 1)- 30*9), true),
			9 => (A_ipd(19)'last_event, tpd_A_ACOUT((899 - 1)- 30*10), true),
			10 => (A_ipd(18)'last_event, tpd_A_ACOUT((899 - 1)- 30*11), true),
			11 => (A_ipd(17)'last_event, tpd_A_ACOUT((899 - 1)- 30*12), true),
			12 => (A_ipd(16)'last_event, tpd_A_ACOUT((899 - 1)- 30*13), true),
			13 => (A_ipd(15)'last_event, tpd_A_ACOUT((899 - 1)- 30*14), true),
			14 => (A_ipd(14)'last_event, tpd_A_ACOUT((899 - 1)- 30*15), true),
			15 => (A_ipd(13)'last_event, tpd_A_ACOUT((899 - 1)- 30*16), true),
			16 => (A_ipd(12)'last_event, tpd_A_ACOUT((899 - 1)- 30*17), true),
			17 => (A_ipd(11)'last_event, tpd_A_ACOUT((899 - 1)- 30*18), true),
			18 => (A_ipd(10)'last_event, tpd_A_ACOUT((899 - 1)- 30*19), true),
			19 => (A_ipd(9)'last_event, tpd_A_ACOUT((899 - 1)- 30*20), true),
			20 => (A_ipd(8)'last_event, tpd_A_ACOUT((899 - 1)- 30*21), true),
			21 => (A_ipd(7)'last_event, tpd_A_ACOUT((899 - 1)- 30*22), true),
			22 => (A_ipd(6)'last_event, tpd_A_ACOUT((899 - 1)- 30*23), true),
			23 => (A_ipd(5)'last_event, tpd_A_ACOUT((899 - 1)- 30*24), true),
			24 => (A_ipd(4)'last_event, tpd_A_ACOUT((899 - 1)- 30*25), true),
			25 => (A_ipd(3)'last_event, tpd_A_ACOUT((899 - 1)- 30*26), true),
			26 => (A_ipd(2)'last_event, tpd_A_ACOUT((899 - 1)- 30*27), true),
			27 => (A_ipd(1)'last_event, tpd_A_ACOUT((899 - 1)- 30*28), true),
			28 => (A_ipd(0)'last_event, tpd_A_ACOUT((899 - 1)- 30*29), true),
			29 => (ACIN_ipd(28)'last_event, tpd_ACIN_ACOUT((899 - 1)- 30*1), true),
			30 => (ACIN_ipd(27)'last_event, tpd_ACIN_ACOUT((899 - 1)- 30*2), true),
			31 => (ACIN_ipd(26)'last_event, tpd_ACIN_ACOUT((899 - 1)- 30*3), true),
			32 => (ACIN_ipd(25)'last_event, tpd_ACIN_ACOUT((899 - 1)- 30*4), true),
			33 => (ACIN_ipd(24)'last_event, tpd_ACIN_ACOUT((899 - 1)- 30*5), true),
			34 => (ACIN_ipd(23)'last_event, tpd_ACIN_ACOUT((899 - 1)- 30*6), true),
			35 => (ACIN_ipd(22)'last_event, tpd_ACIN_ACOUT((899 - 1)- 30*7), true),
			36 => (ACIN_ipd(21)'last_event, tpd_ACIN_ACOUT((899 - 1)- 30*8), true),
			37 => (ACIN_ipd(20)'last_event, tpd_ACIN_ACOUT((899 - 1)- 30*9), true),
			38 => (ACIN_ipd(19)'last_event, tpd_ACIN_ACOUT((899 - 1)- 30*10), true),
			39 => (ACIN_ipd(18)'last_event, tpd_ACIN_ACOUT((899 - 1)- 30*11), true),
			40 => (ACIN_ipd(17)'last_event, tpd_ACIN_ACOUT((899 - 1)- 30*12), true),
			41 => (ACIN_ipd(16)'last_event, tpd_ACIN_ACOUT((899 - 1)- 30*13), true),
			42 => (ACIN_ipd(15)'last_event, tpd_ACIN_ACOUT((899 - 1)- 30*14), true),
			43 => (ACIN_ipd(14)'last_event, tpd_ACIN_ACOUT((899 - 1)- 30*15), true),
			44 => (ACIN_ipd(13)'last_event, tpd_ACIN_ACOUT((899 - 1)- 30*16), true),
			45 => (ACIN_ipd(12)'last_event, tpd_ACIN_ACOUT((899 - 1)- 30*17), true),
			46 => (ACIN_ipd(11)'last_event, tpd_ACIN_ACOUT((899 - 1)- 30*18), true),
			47 => (ACIN_ipd(10)'last_event, tpd_ACIN_ACOUT((899 - 1)- 30*19), true),
			48 => (ACIN_ipd(9)'last_event, tpd_ACIN_ACOUT((899 - 1)- 30*20), true),
			49 => (ACIN_ipd(8)'last_event, tpd_ACIN_ACOUT((899 - 1)- 30*21), true),
			50 => (ACIN_ipd(7)'last_event, tpd_ACIN_ACOUT((899 - 1)- 30*22), true),
			51 => (ACIN_ipd(6)'last_event, tpd_ACIN_ACOUT((899 - 1)- 30*23), true),
			52 => (ACIN_ipd(5)'last_event, tpd_ACIN_ACOUT((899 - 1)- 30*24), true),
			53 => (ACIN_ipd(4)'last_event, tpd_ACIN_ACOUT((899 - 1)- 30*25), true),
			54 => (ACIN_ipd(3)'last_event, tpd_ACIN_ACOUT((899 - 1)- 30*26), true),
			55 => (ACIN_ipd(2)'last_event, tpd_ACIN_ACOUT((899 - 1)- 30*27), true),
			56 => (ACIN_ipd(1)'last_event, tpd_ACIN_ACOUT((899 - 1)- 30*28), true),
			57 => (ACIN_ipd(0)'last_event, tpd_ACIN_ACOUT((899 - 1)- 30*29), true),
			58 => (CLK_dly'last_event, tpd_CLK_ACOUT(28), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> ACOUT(27),
         GlitchData	=> ACOUT_GlitchData(27),
         OutSignalName	=> "ACOUT(27)",
         OutTemp	=> ACOUT_zd(27),
         Paths		=> (
			0 => (A_ipd(27)'last_event, tpd_A_ACOUT((899 - 2)- 30*2), true),
			1 => (A_ipd(26)'last_event, tpd_A_ACOUT((899 - 2)- 30*3), true),
			2 => (A_ipd(25)'last_event, tpd_A_ACOUT((899 - 2)- 30*4), true),
			3 => (A_ipd(24)'last_event, tpd_A_ACOUT((899 - 2)- 30*5), true),
			4 => (A_ipd(23)'last_event, tpd_A_ACOUT((899 - 2)- 30*6), true),
			5 => (A_ipd(22)'last_event, tpd_A_ACOUT((899 - 2)- 30*7), true),
			6 => (A_ipd(21)'last_event, tpd_A_ACOUT((899 - 2)- 30*8), true),
			7 => (A_ipd(20)'last_event, tpd_A_ACOUT((899 - 2)- 30*9), true),
			8 => (A_ipd(19)'last_event, tpd_A_ACOUT((899 - 2)- 30*10), true),
			9 => (A_ipd(18)'last_event, tpd_A_ACOUT((899 - 2)- 30*11), true),
			10 => (A_ipd(17)'last_event, tpd_A_ACOUT((899 - 2)- 30*12), true),
			11 => (A_ipd(16)'last_event, tpd_A_ACOUT((899 - 2)- 30*13), true),
			12 => (A_ipd(15)'last_event, tpd_A_ACOUT((899 - 2)- 30*14), true),
			13 => (A_ipd(14)'last_event, tpd_A_ACOUT((899 - 2)- 30*15), true),
			14 => (A_ipd(13)'last_event, tpd_A_ACOUT((899 - 2)- 30*16), true),
			15 => (A_ipd(12)'last_event, tpd_A_ACOUT((899 - 2)- 30*17), true),
			16 => (A_ipd(11)'last_event, tpd_A_ACOUT((899 - 2)- 30*18), true),
			17 => (A_ipd(10)'last_event, tpd_A_ACOUT((899 - 2)- 30*19), true),
			18 => (A_ipd(9)'last_event, tpd_A_ACOUT((899 - 2)- 30*20), true),
			19 => (A_ipd(8)'last_event, tpd_A_ACOUT((899 - 2)- 30*21), true),
			20 => (A_ipd(7)'last_event, tpd_A_ACOUT((899 - 2)- 30*22), true),
			21 => (A_ipd(6)'last_event, tpd_A_ACOUT((899 - 2)- 30*23), true),
			22 => (A_ipd(5)'last_event, tpd_A_ACOUT((899 - 2)- 30*24), true),
			23 => (A_ipd(4)'last_event, tpd_A_ACOUT((899 - 2)- 30*25), true),
			24 => (A_ipd(3)'last_event, tpd_A_ACOUT((899 - 2)- 30*26), true),
			25 => (A_ipd(2)'last_event, tpd_A_ACOUT((899 - 2)- 30*27), true),
			26 => (A_ipd(1)'last_event, tpd_A_ACOUT((899 - 2)- 30*28), true),
			27 => (A_ipd(0)'last_event, tpd_A_ACOUT((899 - 2)- 30*29), true),
			28 => (ACIN_ipd(27)'last_event, tpd_ACIN_ACOUT((899 - 2)- 30*2), true),
			29 => (ACIN_ipd(26)'last_event, tpd_ACIN_ACOUT((899 - 2)- 30*3), true),
			30 => (ACIN_ipd(25)'last_event, tpd_ACIN_ACOUT((899 - 2)- 30*4), true),
			31 => (ACIN_ipd(24)'last_event, tpd_ACIN_ACOUT((899 - 2)- 30*5), true),
			32 => (ACIN_ipd(23)'last_event, tpd_ACIN_ACOUT((899 - 2)- 30*6), true),
			33 => (ACIN_ipd(22)'last_event, tpd_ACIN_ACOUT((899 - 2)- 30*7), true),
			34 => (ACIN_ipd(21)'last_event, tpd_ACIN_ACOUT((899 - 2)- 30*8), true),
			35 => (ACIN_ipd(20)'last_event, tpd_ACIN_ACOUT((899 - 2)- 30*9), true),
			36 => (ACIN_ipd(19)'last_event, tpd_ACIN_ACOUT((899 - 2)- 30*10), true),
			37 => (ACIN_ipd(18)'last_event, tpd_ACIN_ACOUT((899 - 2)- 30*11), true),
			38 => (ACIN_ipd(17)'last_event, tpd_ACIN_ACOUT((899 - 2)- 30*12), true),
			39 => (ACIN_ipd(16)'last_event, tpd_ACIN_ACOUT((899 - 2)- 30*13), true),
			40 => (ACIN_ipd(15)'last_event, tpd_ACIN_ACOUT((899 - 2)- 30*14), true),
			41 => (ACIN_ipd(14)'last_event, tpd_ACIN_ACOUT((899 - 2)- 30*15), true),
			42 => (ACIN_ipd(13)'last_event, tpd_ACIN_ACOUT((899 - 2)- 30*16), true),
			43 => (ACIN_ipd(12)'last_event, tpd_ACIN_ACOUT((899 - 2)- 30*17), true),
			44 => (ACIN_ipd(11)'last_event, tpd_ACIN_ACOUT((899 - 2)- 30*18), true),
			45 => (ACIN_ipd(10)'last_event, tpd_ACIN_ACOUT((899 - 2)- 30*19), true),
			46 => (ACIN_ipd(9)'last_event, tpd_ACIN_ACOUT((899 - 2)- 30*20), true),
			47 => (ACIN_ipd(8)'last_event, tpd_ACIN_ACOUT((899 - 2)- 30*21), true),
			48 => (ACIN_ipd(7)'last_event, tpd_ACIN_ACOUT((899 - 2)- 30*22), true),
			49 => (ACIN_ipd(6)'last_event, tpd_ACIN_ACOUT((899 - 2)- 30*23), true),
			50 => (ACIN_ipd(5)'last_event, tpd_ACIN_ACOUT((899 - 2)- 30*24), true),
			51 => (ACIN_ipd(4)'last_event, tpd_ACIN_ACOUT((899 - 2)- 30*25), true),
			52 => (ACIN_ipd(3)'last_event, tpd_ACIN_ACOUT((899 - 2)- 30*26), true),
			53 => (ACIN_ipd(2)'last_event, tpd_ACIN_ACOUT((899 - 2)- 30*27), true),
			54 => (ACIN_ipd(1)'last_event, tpd_ACIN_ACOUT((899 - 2)- 30*28), true),
			55 => (ACIN_ipd(0)'last_event, tpd_ACIN_ACOUT((899 - 2)- 30*29), true),
			56 => (CLK_dly'last_event, tpd_CLK_ACOUT(27), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> ACOUT(26),
         GlitchData	=> ACOUT_GlitchData(26),
         OutSignalName	=> "ACOUT(26)",
         OutTemp	=> ACOUT_zd(26),
         Paths		=> (
			0 => (A_ipd(26)'last_event, tpd_A_ACOUT((899 - 3)- 30*3), true),
			1 => (A_ipd(25)'last_event, tpd_A_ACOUT((899 - 3)- 30*4), true),
			2 => (A_ipd(24)'last_event, tpd_A_ACOUT((899 - 3)- 30*5), true),
			3 => (A_ipd(23)'last_event, tpd_A_ACOUT((899 - 3)- 30*6), true),
			4 => (A_ipd(22)'last_event, tpd_A_ACOUT((899 - 3)- 30*7), true),
			5 => (A_ipd(21)'last_event, tpd_A_ACOUT((899 - 3)- 30*8), true),
			6 => (A_ipd(20)'last_event, tpd_A_ACOUT((899 - 3)- 30*9), true),
			7 => (A_ipd(19)'last_event, tpd_A_ACOUT((899 - 3)- 30*10), true),
			8 => (A_ipd(18)'last_event, tpd_A_ACOUT((899 - 3)- 30*11), true),
			9 => (A_ipd(17)'last_event, tpd_A_ACOUT((899 - 3)- 30*12), true),
			10 => (A_ipd(16)'last_event, tpd_A_ACOUT((899 - 3)- 30*13), true),
			11 => (A_ipd(15)'last_event, tpd_A_ACOUT((899 - 3)- 30*14), true),
			12 => (A_ipd(14)'last_event, tpd_A_ACOUT((899 - 3)- 30*15), true),
			13 => (A_ipd(13)'last_event, tpd_A_ACOUT((899 - 3)- 30*16), true),
			14 => (A_ipd(12)'last_event, tpd_A_ACOUT((899 - 3)- 30*17), true),
			15 => (A_ipd(11)'last_event, tpd_A_ACOUT((899 - 3)- 30*18), true),
			16 => (A_ipd(10)'last_event, tpd_A_ACOUT((899 - 3)- 30*19), true),
			17 => (A_ipd(9)'last_event, tpd_A_ACOUT((899 - 3)- 30*20), true),
			18 => (A_ipd(8)'last_event, tpd_A_ACOUT((899 - 3)- 30*21), true),
			19 => (A_ipd(7)'last_event, tpd_A_ACOUT((899 - 3)- 30*22), true),
			20 => (A_ipd(6)'last_event, tpd_A_ACOUT((899 - 3)- 30*23), true),
			21 => (A_ipd(5)'last_event, tpd_A_ACOUT((899 - 3)- 30*24), true),
			22 => (A_ipd(4)'last_event, tpd_A_ACOUT((899 - 3)- 30*25), true),
			23 => (A_ipd(3)'last_event, tpd_A_ACOUT((899 - 3)- 30*26), true),
			24 => (A_ipd(2)'last_event, tpd_A_ACOUT((899 - 3)- 30*27), true),
			25 => (A_ipd(1)'last_event, tpd_A_ACOUT((899 - 3)- 30*28), true),
			26 => (A_ipd(0)'last_event, tpd_A_ACOUT((899 - 3)- 30*29), true),
			27 => (ACIN_ipd(26)'last_event, tpd_ACIN_ACOUT((899 - 3)- 30*3), true),
			28 => (ACIN_ipd(25)'last_event, tpd_ACIN_ACOUT((899 - 3)- 30*4), true),
			29 => (ACIN_ipd(24)'last_event, tpd_ACIN_ACOUT((899 - 3)- 30*5), true),
			30 => (ACIN_ipd(23)'last_event, tpd_ACIN_ACOUT((899 - 3)- 30*6), true),
			31 => (ACIN_ipd(22)'last_event, tpd_ACIN_ACOUT((899 - 3)- 30*7), true),
			32 => (ACIN_ipd(21)'last_event, tpd_ACIN_ACOUT((899 - 3)- 30*8), true),
			33 => (ACIN_ipd(20)'last_event, tpd_ACIN_ACOUT((899 - 3)- 30*9), true),
			34 => (ACIN_ipd(19)'last_event, tpd_ACIN_ACOUT((899 - 3)- 30*10), true),
			35 => (ACIN_ipd(18)'last_event, tpd_ACIN_ACOUT((899 - 3)- 30*11), true),
			36 => (ACIN_ipd(17)'last_event, tpd_ACIN_ACOUT((899 - 3)- 30*12), true),
			37 => (ACIN_ipd(16)'last_event, tpd_ACIN_ACOUT((899 - 3)- 30*13), true),
			38 => (ACIN_ipd(15)'last_event, tpd_ACIN_ACOUT((899 - 3)- 30*14), true),
			39 => (ACIN_ipd(14)'last_event, tpd_ACIN_ACOUT((899 - 3)- 30*15), true),
			40 => (ACIN_ipd(13)'last_event, tpd_ACIN_ACOUT((899 - 3)- 30*16), true),
			41 => (ACIN_ipd(12)'last_event, tpd_ACIN_ACOUT((899 - 3)- 30*17), true),
			42 => (ACIN_ipd(11)'last_event, tpd_ACIN_ACOUT((899 - 3)- 30*18), true),
			43 => (ACIN_ipd(10)'last_event, tpd_ACIN_ACOUT((899 - 3)- 30*19), true),
			44 => (ACIN_ipd(9)'last_event, tpd_ACIN_ACOUT((899 - 3)- 30*20), true),
			45 => (ACIN_ipd(8)'last_event, tpd_ACIN_ACOUT((899 - 3)- 30*21), true),
			46 => (ACIN_ipd(7)'last_event, tpd_ACIN_ACOUT((899 - 3)- 30*22), true),
			47 => (ACIN_ipd(6)'last_event, tpd_ACIN_ACOUT((899 - 3)- 30*23), true),
			48 => (ACIN_ipd(5)'last_event, tpd_ACIN_ACOUT((899 - 3)- 30*24), true),
			49 => (ACIN_ipd(4)'last_event, tpd_ACIN_ACOUT((899 - 3)- 30*25), true),
			50 => (ACIN_ipd(3)'last_event, tpd_ACIN_ACOUT((899 - 3)- 30*26), true),
			51 => (ACIN_ipd(2)'last_event, tpd_ACIN_ACOUT((899 - 3)- 30*27), true),
			52 => (ACIN_ipd(1)'last_event, tpd_ACIN_ACOUT((899 - 3)- 30*28), true),
			53 => (ACIN_ipd(0)'last_event, tpd_ACIN_ACOUT((899 - 3)- 30*29), true),
			54 => (CLK_dly'last_event, tpd_CLK_ACOUT(26), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> ACOUT(25),
         GlitchData	=> ACOUT_GlitchData(25),
         OutSignalName	=> "ACOUT(25)",
         OutTemp	=> ACOUT_zd(25),
         Paths		=> (
			0 => (A_ipd(25)'last_event, tpd_A_ACOUT((899 - 4)- 30*4), true),
			1 => (A_ipd(24)'last_event, tpd_A_ACOUT((899 - 4)- 30*5), true),
			2 => (A_ipd(23)'last_event, tpd_A_ACOUT((899 - 4)- 30*6), true),
			3 => (A_ipd(22)'last_event, tpd_A_ACOUT((899 - 4)- 30*7), true),
			4 => (A_ipd(21)'last_event, tpd_A_ACOUT((899 - 4)- 30*8), true),
			5 => (A_ipd(20)'last_event, tpd_A_ACOUT((899 - 4)- 30*9), true),
			6 => (A_ipd(19)'last_event, tpd_A_ACOUT((899 - 4)- 30*10), true),
			7 => (A_ipd(18)'last_event, tpd_A_ACOUT((899 - 4)- 30*11), true),
			8 => (A_ipd(17)'last_event, tpd_A_ACOUT((899 - 4)- 30*12), true),
			9 => (A_ipd(16)'last_event, tpd_A_ACOUT((899 - 4)- 30*13), true),
			10 => (A_ipd(15)'last_event, tpd_A_ACOUT((899 - 4)- 30*14), true),
			11 => (A_ipd(14)'last_event, tpd_A_ACOUT((899 - 4)- 30*15), true),
			12 => (A_ipd(13)'last_event, tpd_A_ACOUT((899 - 4)- 30*16), true),
			13 => (A_ipd(12)'last_event, tpd_A_ACOUT((899 - 4)- 30*17), true),
			14 => (A_ipd(11)'last_event, tpd_A_ACOUT((899 - 4)- 30*18), true),
			15 => (A_ipd(10)'last_event, tpd_A_ACOUT((899 - 4)- 30*19), true),
			16 => (A_ipd(9)'last_event, tpd_A_ACOUT((899 - 4)- 30*20), true),
			17 => (A_ipd(8)'last_event, tpd_A_ACOUT((899 - 4)- 30*21), true),
			18 => (A_ipd(7)'last_event, tpd_A_ACOUT((899 - 4)- 30*22), true),
			19 => (A_ipd(6)'last_event, tpd_A_ACOUT((899 - 4)- 30*23), true),
			20 => (A_ipd(5)'last_event, tpd_A_ACOUT((899 - 4)- 30*24), true),
			21 => (A_ipd(4)'last_event, tpd_A_ACOUT((899 - 4)- 30*25), true),
			22 => (A_ipd(3)'last_event, tpd_A_ACOUT((899 - 4)- 30*26), true),
			23 => (A_ipd(2)'last_event, tpd_A_ACOUT((899 - 4)- 30*27), true),
			24 => (A_ipd(1)'last_event, tpd_A_ACOUT((899 - 4)- 30*28), true),
			25 => (A_ipd(0)'last_event, tpd_A_ACOUT((899 - 4)- 30*29), true),
			26 => (ACIN_ipd(25)'last_event, tpd_ACIN_ACOUT((899 - 4)- 30*4), true),
			27 => (ACIN_ipd(24)'last_event, tpd_ACIN_ACOUT((899 - 4)- 30*5), true),
			28 => (ACIN_ipd(23)'last_event, tpd_ACIN_ACOUT((899 - 4)- 30*6), true),
			29 => (ACIN_ipd(22)'last_event, tpd_ACIN_ACOUT((899 - 4)- 30*7), true),
			30 => (ACIN_ipd(21)'last_event, tpd_ACIN_ACOUT((899 - 4)- 30*8), true),
			31 => (ACIN_ipd(20)'last_event, tpd_ACIN_ACOUT((899 - 4)- 30*9), true),
			32 => (ACIN_ipd(19)'last_event, tpd_ACIN_ACOUT((899 - 4)- 30*10), true),
			33 => (ACIN_ipd(18)'last_event, tpd_ACIN_ACOUT((899 - 4)- 30*11), true),
			34 => (ACIN_ipd(17)'last_event, tpd_ACIN_ACOUT((899 - 4)- 30*12), true),
			35 => (ACIN_ipd(16)'last_event, tpd_ACIN_ACOUT((899 - 4)- 30*13), true),
			36 => (ACIN_ipd(15)'last_event, tpd_ACIN_ACOUT((899 - 4)- 30*14), true),
			37 => (ACIN_ipd(14)'last_event, tpd_ACIN_ACOUT((899 - 4)- 30*15), true),
			38 => (ACIN_ipd(13)'last_event, tpd_ACIN_ACOUT((899 - 4)- 30*16), true),
			39 => (ACIN_ipd(12)'last_event, tpd_ACIN_ACOUT((899 - 4)- 30*17), true),
			40 => (ACIN_ipd(11)'last_event, tpd_ACIN_ACOUT((899 - 4)- 30*18), true),
			41 => (ACIN_ipd(10)'last_event, tpd_ACIN_ACOUT((899 - 4)- 30*19), true),
			42 => (ACIN_ipd(9)'last_event, tpd_ACIN_ACOUT((899 - 4)- 30*20), true),
			43 => (ACIN_ipd(8)'last_event, tpd_ACIN_ACOUT((899 - 4)- 30*21), true),
			44 => (ACIN_ipd(7)'last_event, tpd_ACIN_ACOUT((899 - 4)- 30*22), true),
			45 => (ACIN_ipd(6)'last_event, tpd_ACIN_ACOUT((899 - 4)- 30*23), true),
			46 => (ACIN_ipd(5)'last_event, tpd_ACIN_ACOUT((899 - 4)- 30*24), true),
			47 => (ACIN_ipd(4)'last_event, tpd_ACIN_ACOUT((899 - 4)- 30*25), true),
			48 => (ACIN_ipd(3)'last_event, tpd_ACIN_ACOUT((899 - 4)- 30*26), true),
			49 => (ACIN_ipd(2)'last_event, tpd_ACIN_ACOUT((899 - 4)- 30*27), true),
			50 => (ACIN_ipd(1)'last_event, tpd_ACIN_ACOUT((899 - 4)- 30*28), true),
			51 => (ACIN_ipd(0)'last_event, tpd_ACIN_ACOUT((899 - 4)- 30*29), true),
			52 => (CLK_dly'last_event, tpd_CLK_ACOUT(25), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> ACOUT(24),
         GlitchData	=> ACOUT_GlitchData(24),
         OutSignalName	=> "ACOUT(24)",
         OutTemp	=> ACOUT_zd(24),
         Paths		=> (
			0 => (A_ipd(24)'last_event, tpd_A_ACOUT((899 - 5)- 30*5), true),
			1 => (A_ipd(23)'last_event, tpd_A_ACOUT((899 - 5)- 30*6), true),
			2 => (A_ipd(22)'last_event, tpd_A_ACOUT((899 - 5)- 30*7), true),
			3 => (A_ipd(21)'last_event, tpd_A_ACOUT((899 - 5)- 30*8), true),
			4 => (A_ipd(20)'last_event, tpd_A_ACOUT((899 - 5)- 30*9), true),
			5 => (A_ipd(19)'last_event, tpd_A_ACOUT((899 - 5)- 30*10), true),
			6 => (A_ipd(18)'last_event, tpd_A_ACOUT((899 - 5)- 30*11), true),
			7 => (A_ipd(17)'last_event, tpd_A_ACOUT((899 - 5)- 30*12), true),
			8 => (A_ipd(16)'last_event, tpd_A_ACOUT((899 - 5)- 30*13), true),
			9 => (A_ipd(15)'last_event, tpd_A_ACOUT((899 - 5)- 30*14), true),
			10 => (A_ipd(14)'last_event, tpd_A_ACOUT((899 - 5)- 30*15), true),
			11 => (A_ipd(13)'last_event, tpd_A_ACOUT((899 - 5)- 30*16), true),
			12 => (A_ipd(12)'last_event, tpd_A_ACOUT((899 - 5)- 30*17), true),
			13 => (A_ipd(11)'last_event, tpd_A_ACOUT((899 - 5)- 30*18), true),
			14 => (A_ipd(10)'last_event, tpd_A_ACOUT((899 - 5)- 30*19), true),
			15 => (A_ipd(9)'last_event, tpd_A_ACOUT((899 - 5)- 30*20), true),
			16 => (A_ipd(8)'last_event, tpd_A_ACOUT((899 - 5)- 30*21), true),
			17 => (A_ipd(7)'last_event, tpd_A_ACOUT((899 - 5)- 30*22), true),
			18 => (A_ipd(6)'last_event, tpd_A_ACOUT((899 - 5)- 30*23), true),
			19 => (A_ipd(5)'last_event, tpd_A_ACOUT((899 - 5)- 30*24), true),
			20 => (A_ipd(4)'last_event, tpd_A_ACOUT((899 - 5)- 30*25), true),
			21 => (A_ipd(3)'last_event, tpd_A_ACOUT((899 - 5)- 30*26), true),
			22 => (A_ipd(2)'last_event, tpd_A_ACOUT((899 - 5)- 30*27), true),
			23 => (A_ipd(1)'last_event, tpd_A_ACOUT((899 - 5)- 30*28), true),
			24 => (A_ipd(0)'last_event, tpd_A_ACOUT((899 - 5)- 30*29), true),
			25 => (ACIN_ipd(24)'last_event, tpd_ACIN_ACOUT((899 - 5)- 30*5), true),
			26 => (ACIN_ipd(23)'last_event, tpd_ACIN_ACOUT((899 - 5)- 30*6), true),
			27 => (ACIN_ipd(22)'last_event, tpd_ACIN_ACOUT((899 - 5)- 30*7), true),
			28 => (ACIN_ipd(21)'last_event, tpd_ACIN_ACOUT((899 - 5)- 30*8), true),
			29 => (ACIN_ipd(20)'last_event, tpd_ACIN_ACOUT((899 - 5)- 30*9), true),
			30 => (ACIN_ipd(19)'last_event, tpd_ACIN_ACOUT((899 - 5)- 30*10), true),
			31 => (ACIN_ipd(18)'last_event, tpd_ACIN_ACOUT((899 - 5)- 30*11), true),
			32 => (ACIN_ipd(17)'last_event, tpd_ACIN_ACOUT((899 - 5)- 30*12), true),
			33 => (ACIN_ipd(16)'last_event, tpd_ACIN_ACOUT((899 - 5)- 30*13), true),
			34 => (ACIN_ipd(15)'last_event, tpd_ACIN_ACOUT((899 - 5)- 30*14), true),
			35 => (ACIN_ipd(14)'last_event, tpd_ACIN_ACOUT((899 - 5)- 30*15), true),
			36 => (ACIN_ipd(13)'last_event, tpd_ACIN_ACOUT((899 - 5)- 30*16), true),
			37 => (ACIN_ipd(12)'last_event, tpd_ACIN_ACOUT((899 - 5)- 30*17), true),
			38 => (ACIN_ipd(11)'last_event, tpd_ACIN_ACOUT((899 - 5)- 30*18), true),
			39 => (ACIN_ipd(10)'last_event, tpd_ACIN_ACOUT((899 - 5)- 30*19), true),
			40 => (ACIN_ipd(9)'last_event, tpd_ACIN_ACOUT((899 - 5)- 30*20), true),
			41 => (ACIN_ipd(8)'last_event, tpd_ACIN_ACOUT((899 - 5)- 30*21), true),
			42 => (ACIN_ipd(7)'last_event, tpd_ACIN_ACOUT((899 - 5)- 30*22), true),
			43 => (ACIN_ipd(6)'last_event, tpd_ACIN_ACOUT((899 - 5)- 30*23), true),
			44 => (ACIN_ipd(5)'last_event, tpd_ACIN_ACOUT((899 - 5)- 30*24), true),
			45 => (ACIN_ipd(4)'last_event, tpd_ACIN_ACOUT((899 - 5)- 30*25), true),
			46 => (ACIN_ipd(3)'last_event, tpd_ACIN_ACOUT((899 - 5)- 30*26), true),
			47 => (ACIN_ipd(2)'last_event, tpd_ACIN_ACOUT((899 - 5)- 30*27), true),
			48 => (ACIN_ipd(1)'last_event, tpd_ACIN_ACOUT((899 - 5)- 30*28), true),
			49 => (ACIN_ipd(0)'last_event, tpd_ACIN_ACOUT((899 - 5)- 30*29), true),
			50 => (CLK_dly'last_event, tpd_CLK_ACOUT(24), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> ACOUT(23),
         GlitchData	=> ACOUT_GlitchData(23),
         OutSignalName	=> "ACOUT(23)",
         OutTemp	=> ACOUT_zd(23),
         Paths		=> (
			0 => (A_ipd(23)'last_event, tpd_A_ACOUT((899 - 6)- 30*6), true),
			1 => (A_ipd(22)'last_event, tpd_A_ACOUT((899 - 6)- 30*7), true),
			2 => (A_ipd(21)'last_event, tpd_A_ACOUT((899 - 6)- 30*8), true),
			3 => (A_ipd(20)'last_event, tpd_A_ACOUT((899 - 6)- 30*9), true),
			4 => (A_ipd(19)'last_event, tpd_A_ACOUT((899 - 6)- 30*10), true),
			5 => (A_ipd(18)'last_event, tpd_A_ACOUT((899 - 6)- 30*11), true),
			6 => (A_ipd(17)'last_event, tpd_A_ACOUT((899 - 6)- 30*12), true),
			7 => (A_ipd(16)'last_event, tpd_A_ACOUT((899 - 6)- 30*13), true),
			8 => (A_ipd(15)'last_event, tpd_A_ACOUT((899 - 6)- 30*14), true),
			9 => (A_ipd(14)'last_event, tpd_A_ACOUT((899 - 6)- 30*15), true),
			10 => (A_ipd(13)'last_event, tpd_A_ACOUT((899 - 6)- 30*16), true),
			11 => (A_ipd(12)'last_event, tpd_A_ACOUT((899 - 6)- 30*17), true),
			12 => (A_ipd(11)'last_event, tpd_A_ACOUT((899 - 6)- 30*18), true),
			13 => (A_ipd(10)'last_event, tpd_A_ACOUT((899 - 6)- 30*19), true),
			14 => (A_ipd(9)'last_event, tpd_A_ACOUT((899 - 6)- 30*20), true),
			15 => (A_ipd(8)'last_event, tpd_A_ACOUT((899 - 6)- 30*21), true),
			16 => (A_ipd(7)'last_event, tpd_A_ACOUT((899 - 6)- 30*22), true),
			17 => (A_ipd(6)'last_event, tpd_A_ACOUT((899 - 6)- 30*23), true),
			18 => (A_ipd(5)'last_event, tpd_A_ACOUT((899 - 6)- 30*24), true),
			19 => (A_ipd(4)'last_event, tpd_A_ACOUT((899 - 6)- 30*25), true),
			20 => (A_ipd(3)'last_event, tpd_A_ACOUT((899 - 6)- 30*26), true),
			21 => (A_ipd(2)'last_event, tpd_A_ACOUT((899 - 6)- 30*27), true),
			22 => (A_ipd(1)'last_event, tpd_A_ACOUT((899 - 6)- 30*28), true),
			23 => (A_ipd(0)'last_event, tpd_A_ACOUT((899 - 6)- 30*29), true),
			24 => (ACIN_ipd(23)'last_event, tpd_ACIN_ACOUT((899 - 6)- 30*6), true),
			25 => (ACIN_ipd(22)'last_event, tpd_ACIN_ACOUT((899 - 6)- 30*7), true),
			26 => (ACIN_ipd(21)'last_event, tpd_ACIN_ACOUT((899 - 6)- 30*8), true),
			27 => (ACIN_ipd(20)'last_event, tpd_ACIN_ACOUT((899 - 6)- 30*9), true),
			28 => (ACIN_ipd(19)'last_event, tpd_ACIN_ACOUT((899 - 6)- 30*10), true),
			29 => (ACIN_ipd(18)'last_event, tpd_ACIN_ACOUT((899 - 6)- 30*11), true),
			30 => (ACIN_ipd(17)'last_event, tpd_ACIN_ACOUT((899 - 6)- 30*12), true),
			31 => (ACIN_ipd(16)'last_event, tpd_ACIN_ACOUT((899 - 6)- 30*13), true),
			32 => (ACIN_ipd(15)'last_event, tpd_ACIN_ACOUT((899 - 6)- 30*14), true),
			33 => (ACIN_ipd(14)'last_event, tpd_ACIN_ACOUT((899 - 6)- 30*15), true),
			34 => (ACIN_ipd(13)'last_event, tpd_ACIN_ACOUT((899 - 6)- 30*16), true),
			35 => (ACIN_ipd(12)'last_event, tpd_ACIN_ACOUT((899 - 6)- 30*17), true),
			36 => (ACIN_ipd(11)'last_event, tpd_ACIN_ACOUT((899 - 6)- 30*18), true),
			37 => (ACIN_ipd(10)'last_event, tpd_ACIN_ACOUT((899 - 6)- 30*19), true),
			38 => (ACIN_ipd(9)'last_event, tpd_ACIN_ACOUT((899 - 6)- 30*20), true),
			39 => (ACIN_ipd(8)'last_event, tpd_ACIN_ACOUT((899 - 6)- 30*21), true),
			40 => (ACIN_ipd(7)'last_event, tpd_ACIN_ACOUT((899 - 6)- 30*22), true),
			41 => (ACIN_ipd(6)'last_event, tpd_ACIN_ACOUT((899 - 6)- 30*23), true),
			42 => (ACIN_ipd(5)'last_event, tpd_ACIN_ACOUT((899 - 6)- 30*24), true),
			43 => (ACIN_ipd(4)'last_event, tpd_ACIN_ACOUT((899 - 6)- 30*25), true),
			44 => (ACIN_ipd(3)'last_event, tpd_ACIN_ACOUT((899 - 6)- 30*26), true),
			45 => (ACIN_ipd(2)'last_event, tpd_ACIN_ACOUT((899 - 6)- 30*27), true),
			46 => (ACIN_ipd(1)'last_event, tpd_ACIN_ACOUT((899 - 6)- 30*28), true),
			47 => (ACIN_ipd(0)'last_event, tpd_ACIN_ACOUT((899 - 6)- 30*29), true),
			48 => (CLK_dly'last_event, tpd_CLK_ACOUT(23), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> ACOUT(22),
         GlitchData	=> ACOUT_GlitchData(22),
         OutSignalName	=> "ACOUT(22)",
         OutTemp	=> ACOUT_zd(22),
         Paths		=> (
			0 => (A_ipd(22)'last_event, tpd_A_ACOUT((899 - 7)- 30*7), true),
			1 => (A_ipd(21)'last_event, tpd_A_ACOUT((899 - 7)- 30*8), true),
			2 => (A_ipd(20)'last_event, tpd_A_ACOUT((899 - 7)- 30*9), true),
			3 => (A_ipd(19)'last_event, tpd_A_ACOUT((899 - 7)- 30*10), true),
			4 => (A_ipd(18)'last_event, tpd_A_ACOUT((899 - 7)- 30*11), true),
			5 => (A_ipd(17)'last_event, tpd_A_ACOUT((899 - 7)- 30*12), true),
			6 => (A_ipd(16)'last_event, tpd_A_ACOUT((899 - 7)- 30*13), true),
			7 => (A_ipd(15)'last_event, tpd_A_ACOUT((899 - 7)- 30*14), true),
			8 => (A_ipd(14)'last_event, tpd_A_ACOUT((899 - 7)- 30*15), true),
			9 => (A_ipd(13)'last_event, tpd_A_ACOUT((899 - 7)- 30*16), true),
			10 => (A_ipd(12)'last_event, tpd_A_ACOUT((899 - 7)- 30*17), true),
			11 => (A_ipd(11)'last_event, tpd_A_ACOUT((899 - 7)- 30*18), true),
			12 => (A_ipd(10)'last_event, tpd_A_ACOUT((899 - 7)- 30*19), true),
			13 => (A_ipd(9)'last_event, tpd_A_ACOUT((899 - 7)- 30*20), true),
			14 => (A_ipd(8)'last_event, tpd_A_ACOUT((899 - 7)- 30*21), true),
			15 => (A_ipd(7)'last_event, tpd_A_ACOUT((899 - 7)- 30*22), true),
			16 => (A_ipd(6)'last_event, tpd_A_ACOUT((899 - 7)- 30*23), true),
			17 => (A_ipd(5)'last_event, tpd_A_ACOUT((899 - 7)- 30*24), true),
			18 => (A_ipd(4)'last_event, tpd_A_ACOUT((899 - 7)- 30*25), true),
			19 => (A_ipd(3)'last_event, tpd_A_ACOUT((899 - 7)- 30*26), true),
			20 => (A_ipd(2)'last_event, tpd_A_ACOUT((899 - 7)- 30*27), true),
			21 => (A_ipd(1)'last_event, tpd_A_ACOUT((899 - 7)- 30*28), true),
			22 => (A_ipd(0)'last_event, tpd_A_ACOUT((899 - 7)- 30*29), true),
			23 => (ACIN_ipd(22)'last_event, tpd_ACIN_ACOUT((899 - 7)- 30*7), true),
			24 => (ACIN_ipd(21)'last_event, tpd_ACIN_ACOUT((899 - 7)- 30*8), true),
			25 => (ACIN_ipd(20)'last_event, tpd_ACIN_ACOUT((899 - 7)- 30*9), true),
			26 => (ACIN_ipd(19)'last_event, tpd_ACIN_ACOUT((899 - 7)- 30*10), true),
			27 => (ACIN_ipd(18)'last_event, tpd_ACIN_ACOUT((899 - 7)- 30*11), true),
			28 => (ACIN_ipd(17)'last_event, tpd_ACIN_ACOUT((899 - 7)- 30*12), true),
			29 => (ACIN_ipd(16)'last_event, tpd_ACIN_ACOUT((899 - 7)- 30*13), true),
			30 => (ACIN_ipd(15)'last_event, tpd_ACIN_ACOUT((899 - 7)- 30*14), true),
			31 => (ACIN_ipd(14)'last_event, tpd_ACIN_ACOUT((899 - 7)- 30*15), true),
			32 => (ACIN_ipd(13)'last_event, tpd_ACIN_ACOUT((899 - 7)- 30*16), true),
			33 => (ACIN_ipd(12)'last_event, tpd_ACIN_ACOUT((899 - 7)- 30*17), true),
			34 => (ACIN_ipd(11)'last_event, tpd_ACIN_ACOUT((899 - 7)- 30*18), true),
			35 => (ACIN_ipd(10)'last_event, tpd_ACIN_ACOUT((899 - 7)- 30*19), true),
			36 => (ACIN_ipd(9)'last_event, tpd_ACIN_ACOUT((899 - 7)- 30*20), true),
			37 => (ACIN_ipd(8)'last_event, tpd_ACIN_ACOUT((899 - 7)- 30*21), true),
			38 => (ACIN_ipd(7)'last_event, tpd_ACIN_ACOUT((899 - 7)- 30*22), true),
			39 => (ACIN_ipd(6)'last_event, tpd_ACIN_ACOUT((899 - 7)- 30*23), true),
			40 => (ACIN_ipd(5)'last_event, tpd_ACIN_ACOUT((899 - 7)- 30*24), true),
			41 => (ACIN_ipd(4)'last_event, tpd_ACIN_ACOUT((899 - 7)- 30*25), true),
			42 => (ACIN_ipd(3)'last_event, tpd_ACIN_ACOUT((899 - 7)- 30*26), true),
			43 => (ACIN_ipd(2)'last_event, tpd_ACIN_ACOUT((899 - 7)- 30*27), true),
			44 => (ACIN_ipd(1)'last_event, tpd_ACIN_ACOUT((899 - 7)- 30*28), true),
			45 => (ACIN_ipd(0)'last_event, tpd_ACIN_ACOUT((899 - 7)- 30*29), true),
			46 => (CLK_dly'last_event, tpd_CLK_ACOUT(22), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> ACOUT(21),
         GlitchData	=> ACOUT_GlitchData(21),
         OutSignalName	=> "ACOUT(21)",
         OutTemp	=> ACOUT_zd(21),
         Paths		=> (
			0 => (A_ipd(21)'last_event, tpd_A_ACOUT((899 - 8)- 30*8), true),
			1 => (A_ipd(20)'last_event, tpd_A_ACOUT((899 - 8)- 30*9), true),
			2 => (A_ipd(19)'last_event, tpd_A_ACOUT((899 - 8)- 30*10), true),
			3 => (A_ipd(18)'last_event, tpd_A_ACOUT((899 - 8)- 30*11), true),
			4 => (A_ipd(17)'last_event, tpd_A_ACOUT((899 - 8)- 30*12), true),
			5 => (A_ipd(16)'last_event, tpd_A_ACOUT((899 - 8)- 30*13), true),
			6 => (A_ipd(15)'last_event, tpd_A_ACOUT((899 - 8)- 30*14), true),
			7 => (A_ipd(14)'last_event, tpd_A_ACOUT((899 - 8)- 30*15), true),
			8 => (A_ipd(13)'last_event, tpd_A_ACOUT((899 - 8)- 30*16), true),
			9 => (A_ipd(12)'last_event, tpd_A_ACOUT((899 - 8)- 30*17), true),
			10 => (A_ipd(11)'last_event, tpd_A_ACOUT((899 - 8)- 30*18), true),
			11 => (A_ipd(10)'last_event, tpd_A_ACOUT((899 - 8)- 30*19), true),
			12 => (A_ipd(9)'last_event, tpd_A_ACOUT((899 - 8)- 30*20), true),
			13 => (A_ipd(8)'last_event, tpd_A_ACOUT((899 - 8)- 30*21), true),
			14 => (A_ipd(7)'last_event, tpd_A_ACOUT((899 - 8)- 30*22), true),
			15 => (A_ipd(6)'last_event, tpd_A_ACOUT((899 - 8)- 30*23), true),
			16 => (A_ipd(5)'last_event, tpd_A_ACOUT((899 - 8)- 30*24), true),
			17 => (A_ipd(4)'last_event, tpd_A_ACOUT((899 - 8)- 30*25), true),
			18 => (A_ipd(3)'last_event, tpd_A_ACOUT((899 - 8)- 30*26), true),
			19 => (A_ipd(2)'last_event, tpd_A_ACOUT((899 - 8)- 30*27), true),
			20 => (A_ipd(1)'last_event, tpd_A_ACOUT((899 - 8)- 30*28), true),
			21 => (A_ipd(0)'last_event, tpd_A_ACOUT((899 - 8)- 30*29), true),
			22 => (ACIN_ipd(21)'last_event, tpd_ACIN_ACOUT((899 - 8)- 30*8), true),
			23 => (ACIN_ipd(20)'last_event, tpd_ACIN_ACOUT((899 - 8)- 30*9), true),
			24 => (ACIN_ipd(19)'last_event, tpd_ACIN_ACOUT((899 - 8)- 30*10), true),
			25 => (ACIN_ipd(18)'last_event, tpd_ACIN_ACOUT((899 - 8)- 30*11), true),
			26 => (ACIN_ipd(17)'last_event, tpd_ACIN_ACOUT((899 - 8)- 30*12), true),
			27 => (ACIN_ipd(16)'last_event, tpd_ACIN_ACOUT((899 - 8)- 30*13), true),
			28 => (ACIN_ipd(15)'last_event, tpd_ACIN_ACOUT((899 - 8)- 30*14), true),
			29 => (ACIN_ipd(14)'last_event, tpd_ACIN_ACOUT((899 - 8)- 30*15), true),
			30 => (ACIN_ipd(13)'last_event, tpd_ACIN_ACOUT((899 - 8)- 30*16), true),
			31 => (ACIN_ipd(12)'last_event, tpd_ACIN_ACOUT((899 - 8)- 30*17), true),
			32 => (ACIN_ipd(11)'last_event, tpd_ACIN_ACOUT((899 - 8)- 30*18), true),
			33 => (ACIN_ipd(10)'last_event, tpd_ACIN_ACOUT((899 - 8)- 30*19), true),
			34 => (ACIN_ipd(9)'last_event, tpd_ACIN_ACOUT((899 - 8)- 30*20), true),
			35 => (ACIN_ipd(8)'last_event, tpd_ACIN_ACOUT((899 - 8)- 30*21), true),
			36 => (ACIN_ipd(7)'last_event, tpd_ACIN_ACOUT((899 - 8)- 30*22), true),
			37 => (ACIN_ipd(6)'last_event, tpd_ACIN_ACOUT((899 - 8)- 30*23), true),
			38 => (ACIN_ipd(5)'last_event, tpd_ACIN_ACOUT((899 - 8)- 30*24), true),
			39 => (ACIN_ipd(4)'last_event, tpd_ACIN_ACOUT((899 - 8)- 30*25), true),
			40 => (ACIN_ipd(3)'last_event, tpd_ACIN_ACOUT((899 - 8)- 30*26), true),
			41 => (ACIN_ipd(2)'last_event, tpd_ACIN_ACOUT((899 - 8)- 30*27), true),
			42 => (ACIN_ipd(1)'last_event, tpd_ACIN_ACOUT((899 - 8)- 30*28), true),
			43 => (ACIN_ipd(0)'last_event, tpd_ACIN_ACOUT((899 - 8)- 30*29), true),
			44 => (CLK_dly'last_event, tpd_CLK_ACOUT(21), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> ACOUT(20),
         GlitchData	=> ACOUT_GlitchData(20),
         OutSignalName	=> "ACOUT(20)",
         OutTemp	=> ACOUT_zd(20),
         Paths		=> (
			0 => (A_ipd(20)'last_event, tpd_A_ACOUT((899 - 9)- 30*9), true),
			1 => (A_ipd(19)'last_event, tpd_A_ACOUT((899 - 9)- 30*10), true),
			2 => (A_ipd(18)'last_event, tpd_A_ACOUT((899 - 9)- 30*11), true),
			3 => (A_ipd(17)'last_event, tpd_A_ACOUT((899 - 9)- 30*12), true),
			4 => (A_ipd(16)'last_event, tpd_A_ACOUT((899 - 9)- 30*13), true),
			5 => (A_ipd(15)'last_event, tpd_A_ACOUT((899 - 9)- 30*14), true),
			6 => (A_ipd(14)'last_event, tpd_A_ACOUT((899 - 9)- 30*15), true),
			7 => (A_ipd(13)'last_event, tpd_A_ACOUT((899 - 9)- 30*16), true),
			8 => (A_ipd(12)'last_event, tpd_A_ACOUT((899 - 9)- 30*17), true),
			9 => (A_ipd(11)'last_event, tpd_A_ACOUT((899 - 9)- 30*18), true),
			10 => (A_ipd(10)'last_event, tpd_A_ACOUT((899 - 9)- 30*19), true),
			11 => (A_ipd(9)'last_event, tpd_A_ACOUT((899 - 9)- 30*20), true),
			12 => (A_ipd(8)'last_event, tpd_A_ACOUT((899 - 9)- 30*21), true),
			13 => (A_ipd(7)'last_event, tpd_A_ACOUT((899 - 9)- 30*22), true),
			14 => (A_ipd(6)'last_event, tpd_A_ACOUT((899 - 9)- 30*23), true),
			15 => (A_ipd(5)'last_event, tpd_A_ACOUT((899 - 9)- 30*24), true),
			16 => (A_ipd(4)'last_event, tpd_A_ACOUT((899 - 9)- 30*25), true),
			17 => (A_ipd(3)'last_event, tpd_A_ACOUT((899 - 9)- 30*26), true),
			18 => (A_ipd(2)'last_event, tpd_A_ACOUT((899 - 9)- 30*27), true),
			19 => (A_ipd(1)'last_event, tpd_A_ACOUT((899 - 9)- 30*28), true),
			20 => (A_ipd(0)'last_event, tpd_A_ACOUT((899 - 9)- 30*29), true),
			21 => (ACIN_ipd(20)'last_event, tpd_ACIN_ACOUT((899 - 9)- 30*9), true),
			22 => (ACIN_ipd(19)'last_event, tpd_ACIN_ACOUT((899 - 9)- 30*10), true),
			23 => (ACIN_ipd(18)'last_event, tpd_ACIN_ACOUT((899 - 9)- 30*11), true),
			24 => (ACIN_ipd(17)'last_event, tpd_ACIN_ACOUT((899 - 9)- 30*12), true),
			25 => (ACIN_ipd(16)'last_event, tpd_ACIN_ACOUT((899 - 9)- 30*13), true),
			26 => (ACIN_ipd(15)'last_event, tpd_ACIN_ACOUT((899 - 9)- 30*14), true),
			27 => (ACIN_ipd(14)'last_event, tpd_ACIN_ACOUT((899 - 9)- 30*15), true),
			28 => (ACIN_ipd(13)'last_event, tpd_ACIN_ACOUT((899 - 9)- 30*16), true),
			29 => (ACIN_ipd(12)'last_event, tpd_ACIN_ACOUT((899 - 9)- 30*17), true),
			30 => (ACIN_ipd(11)'last_event, tpd_ACIN_ACOUT((899 - 9)- 30*18), true),
			31 => (ACIN_ipd(10)'last_event, tpd_ACIN_ACOUT((899 - 9)- 30*19), true),
			32 => (ACIN_ipd(9)'last_event, tpd_ACIN_ACOUT((899 - 9)- 30*20), true),
			33 => (ACIN_ipd(8)'last_event, tpd_ACIN_ACOUT((899 - 9)- 30*21), true),
			34 => (ACIN_ipd(7)'last_event, tpd_ACIN_ACOUT((899 - 9)- 30*22), true),
			35 => (ACIN_ipd(6)'last_event, tpd_ACIN_ACOUT((899 - 9)- 30*23), true),
			36 => (ACIN_ipd(5)'last_event, tpd_ACIN_ACOUT((899 - 9)- 30*24), true),
			37 => (ACIN_ipd(4)'last_event, tpd_ACIN_ACOUT((899 - 9)- 30*25), true),
			38 => (ACIN_ipd(3)'last_event, tpd_ACIN_ACOUT((899 - 9)- 30*26), true),
			39 => (ACIN_ipd(2)'last_event, tpd_ACIN_ACOUT((899 - 9)- 30*27), true),
			40 => (ACIN_ipd(1)'last_event, tpd_ACIN_ACOUT((899 - 9)- 30*28), true),
			41 => (ACIN_ipd(0)'last_event, tpd_ACIN_ACOUT((899 - 9)- 30*29), true),
			42 => (CLK_dly'last_event, tpd_CLK_ACOUT(20), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> ACOUT(19),
         GlitchData	=> ACOUT_GlitchData(19),
         OutSignalName	=> "ACOUT(19)",
         OutTemp	=> ACOUT_zd(19),
         Paths		=> (
			0 => (A_ipd(19)'last_event, tpd_A_ACOUT((899 - 10)- 30*10), true),
			1 => (A_ipd(18)'last_event, tpd_A_ACOUT((899 - 10)- 30*11), true),
			2 => (A_ipd(17)'last_event, tpd_A_ACOUT((899 - 10)- 30*12), true),
			3 => (A_ipd(16)'last_event, tpd_A_ACOUT((899 - 10)- 30*13), true),
			4 => (A_ipd(15)'last_event, tpd_A_ACOUT((899 - 10)- 30*14), true),
			5 => (A_ipd(14)'last_event, tpd_A_ACOUT((899 - 10)- 30*15), true),
			6 => (A_ipd(13)'last_event, tpd_A_ACOUT((899 - 10)- 30*16), true),
			7 => (A_ipd(12)'last_event, tpd_A_ACOUT((899 - 10)- 30*17), true),
			8 => (A_ipd(11)'last_event, tpd_A_ACOUT((899 - 10)- 30*18), true),
			9 => (A_ipd(10)'last_event, tpd_A_ACOUT((899 - 10)- 30*19), true),
			10 => (A_ipd(9)'last_event, tpd_A_ACOUT((899 - 10)- 30*20), true),
			11 => (A_ipd(8)'last_event, tpd_A_ACOUT((899 - 10)- 30*21), true),
			12 => (A_ipd(7)'last_event, tpd_A_ACOUT((899 - 10)- 30*22), true),
			13 => (A_ipd(6)'last_event, tpd_A_ACOUT((899 - 10)- 30*23), true),
			14 => (A_ipd(5)'last_event, tpd_A_ACOUT((899 - 10)- 30*24), true),
			15 => (A_ipd(4)'last_event, tpd_A_ACOUT((899 - 10)- 30*25), true),
			16 => (A_ipd(3)'last_event, tpd_A_ACOUT((899 - 10)- 30*26), true),
			17 => (A_ipd(2)'last_event, tpd_A_ACOUT((899 - 10)- 30*27), true),
			18 => (A_ipd(1)'last_event, tpd_A_ACOUT((899 - 10)- 30*28), true),
			19 => (A_ipd(0)'last_event, tpd_A_ACOUT((899 - 10)- 30*29), true),
			20 => (ACIN_ipd(19)'last_event, tpd_ACIN_ACOUT((899 - 10)- 30*10), true),
			21 => (ACIN_ipd(18)'last_event, tpd_ACIN_ACOUT((899 - 10)- 30*11), true),
			22 => (ACIN_ipd(17)'last_event, tpd_ACIN_ACOUT((899 - 10)- 30*12), true),
			23 => (ACIN_ipd(16)'last_event, tpd_ACIN_ACOUT((899 - 10)- 30*13), true),
			24 => (ACIN_ipd(15)'last_event, tpd_ACIN_ACOUT((899 - 10)- 30*14), true),
			25 => (ACIN_ipd(14)'last_event, tpd_ACIN_ACOUT((899 - 10)- 30*15), true),
			26 => (ACIN_ipd(13)'last_event, tpd_ACIN_ACOUT((899 - 10)- 30*16), true),
			27 => (ACIN_ipd(12)'last_event, tpd_ACIN_ACOUT((899 - 10)- 30*17), true),
			28 => (ACIN_ipd(11)'last_event, tpd_ACIN_ACOUT((899 - 10)- 30*18), true),
			29 => (ACIN_ipd(10)'last_event, tpd_ACIN_ACOUT((899 - 10)- 30*19), true),
			30 => (ACIN_ipd(9)'last_event, tpd_ACIN_ACOUT((899 - 10)- 30*20), true),
			31 => (ACIN_ipd(8)'last_event, tpd_ACIN_ACOUT((899 - 10)- 30*21), true),
			32 => (ACIN_ipd(7)'last_event, tpd_ACIN_ACOUT((899 - 10)- 30*22), true),
			33 => (ACIN_ipd(6)'last_event, tpd_ACIN_ACOUT((899 - 10)- 30*23), true),
			34 => (ACIN_ipd(5)'last_event, tpd_ACIN_ACOUT((899 - 10)- 30*24), true),
			35 => (ACIN_ipd(4)'last_event, tpd_ACIN_ACOUT((899 - 10)- 30*25), true),
			36 => (ACIN_ipd(3)'last_event, tpd_ACIN_ACOUT((899 - 10)- 30*26), true),
			37 => (ACIN_ipd(2)'last_event, tpd_ACIN_ACOUT((899 - 10)- 30*27), true),
			38 => (ACIN_ipd(1)'last_event, tpd_ACIN_ACOUT((899 - 10)- 30*28), true),
			39 => (ACIN_ipd(0)'last_event, tpd_ACIN_ACOUT((899 - 10)- 30*29), true),
			40 => (CLK_dly'last_event, tpd_CLK_ACOUT(19), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> ACOUT(18),
         GlitchData	=> ACOUT_GlitchData(18),
         OutSignalName	=> "ACOUT(18)",
         OutTemp	=> ACOUT_zd(18),
         Paths		=> (
			0 => (A_ipd(18)'last_event, tpd_A_ACOUT((899 - 11)- 30*11), true),
			1 => (A_ipd(17)'last_event, tpd_A_ACOUT((899 - 11)- 30*12), true),
			2 => (A_ipd(16)'last_event, tpd_A_ACOUT((899 - 11)- 30*13), true),
			3 => (A_ipd(15)'last_event, tpd_A_ACOUT((899 - 11)- 30*14), true),
			4 => (A_ipd(14)'last_event, tpd_A_ACOUT((899 - 11)- 30*15), true),
			5 => (A_ipd(13)'last_event, tpd_A_ACOUT((899 - 11)- 30*16), true),
			6 => (A_ipd(12)'last_event, tpd_A_ACOUT((899 - 11)- 30*17), true),
			7 => (A_ipd(11)'last_event, tpd_A_ACOUT((899 - 11)- 30*18), true),
			8 => (A_ipd(10)'last_event, tpd_A_ACOUT((899 - 11)- 30*19), true),
			9 => (A_ipd(9)'last_event, tpd_A_ACOUT((899 - 11)- 30*20), true),
			10 => (A_ipd(8)'last_event, tpd_A_ACOUT((899 - 11)- 30*21), true),
			11 => (A_ipd(7)'last_event, tpd_A_ACOUT((899 - 11)- 30*22), true),
			12 => (A_ipd(6)'last_event, tpd_A_ACOUT((899 - 11)- 30*23), true),
			13 => (A_ipd(5)'last_event, tpd_A_ACOUT((899 - 11)- 30*24), true),
			14 => (A_ipd(4)'last_event, tpd_A_ACOUT((899 - 11)- 30*25), true),
			15 => (A_ipd(3)'last_event, tpd_A_ACOUT((899 - 11)- 30*26), true),
			16 => (A_ipd(2)'last_event, tpd_A_ACOUT((899 - 11)- 30*27), true),
			17 => (A_ipd(1)'last_event, tpd_A_ACOUT((899 - 11)- 30*28), true),
			18 => (A_ipd(0)'last_event, tpd_A_ACOUT((899 - 11)- 30*29), true),
			19 => (ACIN_ipd(18)'last_event, tpd_ACIN_ACOUT((899 - 11)- 30*11), true),
			20 => (ACIN_ipd(17)'last_event, tpd_ACIN_ACOUT((899 - 11)- 30*12), true),
			21 => (ACIN_ipd(16)'last_event, tpd_ACIN_ACOUT((899 - 11)- 30*13), true),
			22 => (ACIN_ipd(15)'last_event, tpd_ACIN_ACOUT((899 - 11)- 30*14), true),
			23 => (ACIN_ipd(14)'last_event, tpd_ACIN_ACOUT((899 - 11)- 30*15), true),
			24 => (ACIN_ipd(13)'last_event, tpd_ACIN_ACOUT((899 - 11)- 30*16), true),
			25 => (ACIN_ipd(12)'last_event, tpd_ACIN_ACOUT((899 - 11)- 30*17), true),
			26 => (ACIN_ipd(11)'last_event, tpd_ACIN_ACOUT((899 - 11)- 30*18), true),
			27 => (ACIN_ipd(10)'last_event, tpd_ACIN_ACOUT((899 - 11)- 30*19), true),
			28 => (ACIN_ipd(9)'last_event, tpd_ACIN_ACOUT((899 - 11)- 30*20), true),
			29 => (ACIN_ipd(8)'last_event, tpd_ACIN_ACOUT((899 - 11)- 30*21), true),
			30 => (ACIN_ipd(7)'last_event, tpd_ACIN_ACOUT((899 - 11)- 30*22), true),
			31 => (ACIN_ipd(6)'last_event, tpd_ACIN_ACOUT((899 - 11)- 30*23), true),
			32 => (ACIN_ipd(5)'last_event, tpd_ACIN_ACOUT((899 - 11)- 30*24), true),
			33 => (ACIN_ipd(4)'last_event, tpd_ACIN_ACOUT((899 - 11)- 30*25), true),
			34 => (ACIN_ipd(3)'last_event, tpd_ACIN_ACOUT((899 - 11)- 30*26), true),
			35 => (ACIN_ipd(2)'last_event, tpd_ACIN_ACOUT((899 - 11)- 30*27), true),
			36 => (ACIN_ipd(1)'last_event, tpd_ACIN_ACOUT((899 - 11)- 30*28), true),
			37 => (ACIN_ipd(0)'last_event, tpd_ACIN_ACOUT((899 - 11)- 30*29), true),
			38 => (CLK_dly'last_event, tpd_CLK_ACOUT(18), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> ACOUT(17),
         GlitchData	=> ACOUT_GlitchData(17),
         OutSignalName	=> "ACOUT(17)",
         OutTemp	=> ACOUT_zd(17),
         Paths		=> (
			0 => (A_ipd(17)'last_event, tpd_A_ACOUT((899 - 12)- 30*12), true),
			1 => (A_ipd(16)'last_event, tpd_A_ACOUT((899 - 12)- 30*13), true),
			2 => (A_ipd(15)'last_event, tpd_A_ACOUT((899 - 12)- 30*14), true),
			3 => (A_ipd(14)'last_event, tpd_A_ACOUT((899 - 12)- 30*15), true),
			4 => (A_ipd(13)'last_event, tpd_A_ACOUT((899 - 12)- 30*16), true),
			5 => (A_ipd(12)'last_event, tpd_A_ACOUT((899 - 12)- 30*17), true),
			6 => (A_ipd(11)'last_event, tpd_A_ACOUT((899 - 12)- 30*18), true),
			7 => (A_ipd(10)'last_event, tpd_A_ACOUT((899 - 12)- 30*19), true),
			8 => (A_ipd(9)'last_event, tpd_A_ACOUT((899 - 12)- 30*20), true),
			9 => (A_ipd(8)'last_event, tpd_A_ACOUT((899 - 12)- 30*21), true),
			10 => (A_ipd(7)'last_event, tpd_A_ACOUT((899 - 12)- 30*22), true),
			11 => (A_ipd(6)'last_event, tpd_A_ACOUT((899 - 12)- 30*23), true),
			12 => (A_ipd(5)'last_event, tpd_A_ACOUT((899 - 12)- 30*24), true),
			13 => (A_ipd(4)'last_event, tpd_A_ACOUT((899 - 12)- 30*25), true),
			14 => (A_ipd(3)'last_event, tpd_A_ACOUT((899 - 12)- 30*26), true),
			15 => (A_ipd(2)'last_event, tpd_A_ACOUT((899 - 12)- 30*27), true),
			16 => (A_ipd(1)'last_event, tpd_A_ACOUT((899 - 12)- 30*28), true),
			17 => (A_ipd(0)'last_event, tpd_A_ACOUT((899 - 12)- 30*29), true),
			18 => (ACIN_ipd(17)'last_event, tpd_ACIN_ACOUT((899 - 12)- 30*12), true),
			19 => (ACIN_ipd(16)'last_event, tpd_ACIN_ACOUT((899 - 12)- 30*13), true),
			20 => (ACIN_ipd(15)'last_event, tpd_ACIN_ACOUT((899 - 12)- 30*14), true),
			21 => (ACIN_ipd(14)'last_event, tpd_ACIN_ACOUT((899 - 12)- 30*15), true),
			22 => (ACIN_ipd(13)'last_event, tpd_ACIN_ACOUT((899 - 12)- 30*16), true),
			23 => (ACIN_ipd(12)'last_event, tpd_ACIN_ACOUT((899 - 12)- 30*17), true),
			24 => (ACIN_ipd(11)'last_event, tpd_ACIN_ACOUT((899 - 12)- 30*18), true),
			25 => (ACIN_ipd(10)'last_event, tpd_ACIN_ACOUT((899 - 12)- 30*19), true),
			26 => (ACIN_ipd(9)'last_event, tpd_ACIN_ACOUT((899 - 12)- 30*20), true),
			27 => (ACIN_ipd(8)'last_event, tpd_ACIN_ACOUT((899 - 12)- 30*21), true),
			28 => (ACIN_ipd(7)'last_event, tpd_ACIN_ACOUT((899 - 12)- 30*22), true),
			29 => (ACIN_ipd(6)'last_event, tpd_ACIN_ACOUT((899 - 12)- 30*23), true),
			30 => (ACIN_ipd(5)'last_event, tpd_ACIN_ACOUT((899 - 12)- 30*24), true),
			31 => (ACIN_ipd(4)'last_event, tpd_ACIN_ACOUT((899 - 12)- 30*25), true),
			32 => (ACIN_ipd(3)'last_event, tpd_ACIN_ACOUT((899 - 12)- 30*26), true),
			33 => (ACIN_ipd(2)'last_event, tpd_ACIN_ACOUT((899 - 12)- 30*27), true),
			34 => (ACIN_ipd(1)'last_event, tpd_ACIN_ACOUT((899 - 12)- 30*28), true),
			35 => (ACIN_ipd(0)'last_event, tpd_ACIN_ACOUT((899 - 12)- 30*29), true),
			36 => (CLK_dly'last_event, tpd_CLK_ACOUT(17), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> ACOUT(16),
         GlitchData	=> ACOUT_GlitchData(16),
         OutSignalName	=> "ACOUT(16)",
         OutTemp	=> ACOUT_zd(16),
         Paths		=> (
			0 => (A_ipd(16)'last_event, tpd_A_ACOUT((899 - 13)- 30*13), true),
			1 => (A_ipd(15)'last_event, tpd_A_ACOUT((899 - 13)- 30*14), true),
			2 => (A_ipd(14)'last_event, tpd_A_ACOUT((899 - 13)- 30*15), true),
			3 => (A_ipd(13)'last_event, tpd_A_ACOUT((899 - 13)- 30*16), true),
			4 => (A_ipd(12)'last_event, tpd_A_ACOUT((899 - 13)- 30*17), true),
			5 => (A_ipd(11)'last_event, tpd_A_ACOUT((899 - 13)- 30*18), true),
			6 => (A_ipd(10)'last_event, tpd_A_ACOUT((899 - 13)- 30*19), true),
			7 => (A_ipd(9)'last_event, tpd_A_ACOUT((899 - 13)- 30*20), true),
			8 => (A_ipd(8)'last_event, tpd_A_ACOUT((899 - 13)- 30*21), true),
			9 => (A_ipd(7)'last_event, tpd_A_ACOUT((899 - 13)- 30*22), true),
			10 => (A_ipd(6)'last_event, tpd_A_ACOUT((899 - 13)- 30*23), true),
			11 => (A_ipd(5)'last_event, tpd_A_ACOUT((899 - 13)- 30*24), true),
			12 => (A_ipd(4)'last_event, tpd_A_ACOUT((899 - 13)- 30*25), true),
			13 => (A_ipd(3)'last_event, tpd_A_ACOUT((899 - 13)- 30*26), true),
			14 => (A_ipd(2)'last_event, tpd_A_ACOUT((899 - 13)- 30*27), true),
			15 => (A_ipd(1)'last_event, tpd_A_ACOUT((899 - 13)- 30*28), true),
			16 => (A_ipd(0)'last_event, tpd_A_ACOUT((899 - 13)- 30*29), true),
			17 => (ACIN_ipd(16)'last_event, tpd_ACIN_ACOUT((899 - 13)- 30*13), true),
			18 => (ACIN_ipd(15)'last_event, tpd_ACIN_ACOUT((899 - 13)- 30*14), true),
			19 => (ACIN_ipd(14)'last_event, tpd_ACIN_ACOUT((899 - 13)- 30*15), true),
			20 => (ACIN_ipd(13)'last_event, tpd_ACIN_ACOUT((899 - 13)- 30*16), true),
			21 => (ACIN_ipd(12)'last_event, tpd_ACIN_ACOUT((899 - 13)- 30*17), true),
			22 => (ACIN_ipd(11)'last_event, tpd_ACIN_ACOUT((899 - 13)- 30*18), true),
			23 => (ACIN_ipd(10)'last_event, tpd_ACIN_ACOUT((899 - 13)- 30*19), true),
			24 => (ACIN_ipd(9)'last_event, tpd_ACIN_ACOUT((899 - 13)- 30*20), true),
			25 => (ACIN_ipd(8)'last_event, tpd_ACIN_ACOUT((899 - 13)- 30*21), true),
			26 => (ACIN_ipd(7)'last_event, tpd_ACIN_ACOUT((899 - 13)- 30*22), true),
			27 => (ACIN_ipd(6)'last_event, tpd_ACIN_ACOUT((899 - 13)- 30*23), true),
			28 => (ACIN_ipd(5)'last_event, tpd_ACIN_ACOUT((899 - 13)- 30*24), true),
			29 => (ACIN_ipd(4)'last_event, tpd_ACIN_ACOUT((899 - 13)- 30*25), true),
			30 => (ACIN_ipd(3)'last_event, tpd_ACIN_ACOUT((899 - 13)- 30*26), true),
			31 => (ACIN_ipd(2)'last_event, tpd_ACIN_ACOUT((899 - 13)- 30*27), true),
			32 => (ACIN_ipd(1)'last_event, tpd_ACIN_ACOUT((899 - 13)- 30*28), true),
			33 => (ACIN_ipd(0)'last_event, tpd_ACIN_ACOUT((899 - 13)- 30*29), true),
			34 => (CLK_dly'last_event, tpd_CLK_ACOUT(16), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> ACOUT(15),
         GlitchData	=> ACOUT_GlitchData(15),
         OutSignalName	=> "ACOUT(15)",
         OutTemp	=> ACOUT_zd(15),
         Paths		=> (
			0 => (A_ipd(15)'last_event, tpd_A_ACOUT((899 - 14)- 30*14), true),
			1 => (A_ipd(14)'last_event, tpd_A_ACOUT((899 - 14)- 30*15), true),
			2 => (A_ipd(13)'last_event, tpd_A_ACOUT((899 - 14)- 30*16), true),
			3 => (A_ipd(12)'last_event, tpd_A_ACOUT((899 - 14)- 30*17), true),
			4 => (A_ipd(11)'last_event, tpd_A_ACOUT((899 - 14)- 30*18), true),
			5 => (A_ipd(10)'last_event, tpd_A_ACOUT((899 - 14)- 30*19), true),
			6 => (A_ipd(9)'last_event, tpd_A_ACOUT((899 - 14)- 30*20), true),
			7 => (A_ipd(8)'last_event, tpd_A_ACOUT((899 - 14)- 30*21), true),
			8 => (A_ipd(7)'last_event, tpd_A_ACOUT((899 - 14)- 30*22), true),
			9 => (A_ipd(6)'last_event, tpd_A_ACOUT((899 - 14)- 30*23), true),
			10 => (A_ipd(5)'last_event, tpd_A_ACOUT((899 - 14)- 30*24), true),
			11 => (A_ipd(4)'last_event, tpd_A_ACOUT((899 - 14)- 30*25), true),
			12 => (A_ipd(3)'last_event, tpd_A_ACOUT((899 - 14)- 30*26), true),
			13 => (A_ipd(2)'last_event, tpd_A_ACOUT((899 - 14)- 30*27), true),
			14 => (A_ipd(1)'last_event, tpd_A_ACOUT((899 - 14)- 30*28), true),
			15 => (A_ipd(0)'last_event, tpd_A_ACOUT((899 - 14)- 30*29), true),
			16 => (ACIN_ipd(15)'last_event, tpd_ACIN_ACOUT((899 - 14)- 30*14), true),
			17 => (ACIN_ipd(14)'last_event, tpd_ACIN_ACOUT((899 - 14)- 30*15), true),
			18 => (ACIN_ipd(13)'last_event, tpd_ACIN_ACOUT((899 - 14)- 30*16), true),
			19 => (ACIN_ipd(12)'last_event, tpd_ACIN_ACOUT((899 - 14)- 30*17), true),
			20 => (ACIN_ipd(11)'last_event, tpd_ACIN_ACOUT((899 - 14)- 30*18), true),
			21 => (ACIN_ipd(10)'last_event, tpd_ACIN_ACOUT((899 - 14)- 30*19), true),
			22 => (ACIN_ipd(9)'last_event, tpd_ACIN_ACOUT((899 - 14)- 30*20), true),
			23 => (ACIN_ipd(8)'last_event, tpd_ACIN_ACOUT((899 - 14)- 30*21), true),
			24 => (ACIN_ipd(7)'last_event, tpd_ACIN_ACOUT((899 - 14)- 30*22), true),
			25 => (ACIN_ipd(6)'last_event, tpd_ACIN_ACOUT((899 - 14)- 30*23), true),
			26 => (ACIN_ipd(5)'last_event, tpd_ACIN_ACOUT((899 - 14)- 30*24), true),
			27 => (ACIN_ipd(4)'last_event, tpd_ACIN_ACOUT((899 - 14)- 30*25), true),
			28 => (ACIN_ipd(3)'last_event, tpd_ACIN_ACOUT((899 - 14)- 30*26), true),
			29 => (ACIN_ipd(2)'last_event, tpd_ACIN_ACOUT((899 - 14)- 30*27), true),
			30 => (ACIN_ipd(1)'last_event, tpd_ACIN_ACOUT((899 - 14)- 30*28), true),
			31 => (ACIN_ipd(0)'last_event, tpd_ACIN_ACOUT((899 - 14)- 30*29), true),
			32 => (CLK_dly'last_event, tpd_CLK_ACOUT(15), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> ACOUT(14),
         GlitchData	=> ACOUT_GlitchData(14),
         OutSignalName	=> "ACOUT(14)",
         OutTemp	=> ACOUT_zd(14),
         Paths		=> (
			0 => (A_ipd(14)'last_event, tpd_A_ACOUT((899 - 15)- 30*15), true),
			1 => (A_ipd(13)'last_event, tpd_A_ACOUT((899 - 15)- 30*16), true),
			2 => (A_ipd(12)'last_event, tpd_A_ACOUT((899 - 15)- 30*17), true),
			3 => (A_ipd(11)'last_event, tpd_A_ACOUT((899 - 15)- 30*18), true),
			4 => (A_ipd(10)'last_event, tpd_A_ACOUT((899 - 15)- 30*19), true),
			5 => (A_ipd(9)'last_event, tpd_A_ACOUT((899 - 15)- 30*20), true),
			6 => (A_ipd(8)'last_event, tpd_A_ACOUT((899 - 15)- 30*21), true),
			7 => (A_ipd(7)'last_event, tpd_A_ACOUT((899 - 15)- 30*22), true),
			8 => (A_ipd(6)'last_event, tpd_A_ACOUT((899 - 15)- 30*23), true),
			9 => (A_ipd(5)'last_event, tpd_A_ACOUT((899 - 15)- 30*24), true),
			10 => (A_ipd(4)'last_event, tpd_A_ACOUT((899 - 15)- 30*25), true),
			11 => (A_ipd(3)'last_event, tpd_A_ACOUT((899 - 15)- 30*26), true),
			12 => (A_ipd(2)'last_event, tpd_A_ACOUT((899 - 15)- 30*27), true),
			13 => (A_ipd(1)'last_event, tpd_A_ACOUT((899 - 15)- 30*28), true),
			14 => (A_ipd(0)'last_event, tpd_A_ACOUT((899 - 15)- 30*29), true),
			15 => (ACIN_ipd(14)'last_event, tpd_ACIN_ACOUT((899 - 15)- 30*15), true),
			16 => (ACIN_ipd(13)'last_event, tpd_ACIN_ACOUT((899 - 15)- 30*16), true),
			17 => (ACIN_ipd(12)'last_event, tpd_ACIN_ACOUT((899 - 15)- 30*17), true),
			18 => (ACIN_ipd(11)'last_event, tpd_ACIN_ACOUT((899 - 15)- 30*18), true),
			19 => (ACIN_ipd(10)'last_event, tpd_ACIN_ACOUT((899 - 15)- 30*19), true),
			20 => (ACIN_ipd(9)'last_event, tpd_ACIN_ACOUT((899 - 15)- 30*20), true),
			21 => (ACIN_ipd(8)'last_event, tpd_ACIN_ACOUT((899 - 15)- 30*21), true),
			22 => (ACIN_ipd(7)'last_event, tpd_ACIN_ACOUT((899 - 15)- 30*22), true),
			23 => (ACIN_ipd(6)'last_event, tpd_ACIN_ACOUT((899 - 15)- 30*23), true),
			24 => (ACIN_ipd(5)'last_event, tpd_ACIN_ACOUT((899 - 15)- 30*24), true),
			25 => (ACIN_ipd(4)'last_event, tpd_ACIN_ACOUT((899 - 15)- 30*25), true),
			26 => (ACIN_ipd(3)'last_event, tpd_ACIN_ACOUT((899 - 15)- 30*26), true),
			27 => (ACIN_ipd(2)'last_event, tpd_ACIN_ACOUT((899 - 15)- 30*27), true),
			28 => (ACIN_ipd(1)'last_event, tpd_ACIN_ACOUT((899 - 15)- 30*28), true),
			29 => (ACIN_ipd(0)'last_event, tpd_ACIN_ACOUT((899 - 15)- 30*29), true),
			30 => (CLK_dly'last_event, tpd_CLK_ACOUT(14), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> ACOUT(13),
         GlitchData	=> ACOUT_GlitchData(13),
         OutSignalName	=> "ACOUT(13)",
         OutTemp	=> ACOUT_zd(13),
         Paths		=> (
			0 => (A_ipd(13)'last_event, tpd_A_ACOUT((899 - 16)- 30*16), true),
			1 => (A_ipd(12)'last_event, tpd_A_ACOUT((899 - 16)- 30*17), true),
			2 => (A_ipd(11)'last_event, tpd_A_ACOUT((899 - 16)- 30*18), true),
			3 => (A_ipd(10)'last_event, tpd_A_ACOUT((899 - 16)- 30*19), true),
			4 => (A_ipd(9)'last_event, tpd_A_ACOUT((899 - 16)- 30*20), true),
			5 => (A_ipd(8)'last_event, tpd_A_ACOUT((899 - 16)- 30*21), true),
			6 => (A_ipd(7)'last_event, tpd_A_ACOUT((899 - 16)- 30*22), true),
			7 => (A_ipd(6)'last_event, tpd_A_ACOUT((899 - 16)- 30*23), true),
			8 => (A_ipd(5)'last_event, tpd_A_ACOUT((899 - 16)- 30*24), true),
			9 => (A_ipd(4)'last_event, tpd_A_ACOUT((899 - 16)- 30*25), true),
			10 => (A_ipd(3)'last_event, tpd_A_ACOUT((899 - 16)- 30*26), true),
			11 => (A_ipd(2)'last_event, tpd_A_ACOUT((899 - 16)- 30*27), true),
			12 => (A_ipd(1)'last_event, tpd_A_ACOUT((899 - 16)- 30*28), true),
			13 => (A_ipd(0)'last_event, tpd_A_ACOUT((899 - 16)- 30*29), true),
			14 => (ACIN_ipd(13)'last_event, tpd_ACIN_ACOUT((899 - 16)- 30*16), true),
			15 => (ACIN_ipd(12)'last_event, tpd_ACIN_ACOUT((899 - 16)- 30*17), true),
			16 => (ACIN_ipd(11)'last_event, tpd_ACIN_ACOUT((899 - 16)- 30*18), true),
			17 => (ACIN_ipd(10)'last_event, tpd_ACIN_ACOUT((899 - 16)- 30*19), true),
			18 => (ACIN_ipd(9)'last_event, tpd_ACIN_ACOUT((899 - 16)- 30*20), true),
			19 => (ACIN_ipd(8)'last_event, tpd_ACIN_ACOUT((899 - 16)- 30*21), true),
			20 => (ACIN_ipd(7)'last_event, tpd_ACIN_ACOUT((899 - 16)- 30*22), true),
			21 => (ACIN_ipd(6)'last_event, tpd_ACIN_ACOUT((899 - 16)- 30*23), true),
			22 => (ACIN_ipd(5)'last_event, tpd_ACIN_ACOUT((899 - 16)- 30*24), true),
			23 => (ACIN_ipd(4)'last_event, tpd_ACIN_ACOUT((899 - 16)- 30*25), true),
			24 => (ACIN_ipd(3)'last_event, tpd_ACIN_ACOUT((899 - 16)- 30*26), true),
			25 => (ACIN_ipd(2)'last_event, tpd_ACIN_ACOUT((899 - 16)- 30*27), true),
			26 => (ACIN_ipd(1)'last_event, tpd_ACIN_ACOUT((899 - 16)- 30*28), true),
			27 => (ACIN_ipd(0)'last_event, tpd_ACIN_ACOUT((899 - 16)- 30*29), true),
			28 => (CLK_dly'last_event, tpd_CLK_ACOUT(13), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> ACOUT(12),
         GlitchData	=> ACOUT_GlitchData(12),
         OutSignalName	=> "ACOUT(12)",
         OutTemp	=> ACOUT_zd(12),
         Paths		=> (
			0 => (A_ipd(12)'last_event, tpd_A_ACOUT((899 - 17)- 30*17), true),
			1 => (A_ipd(11)'last_event, tpd_A_ACOUT((899 - 17)- 30*18), true),
			2 => (A_ipd(10)'last_event, tpd_A_ACOUT((899 - 17)- 30*19), true),
			3 => (A_ipd(9)'last_event, tpd_A_ACOUT((899 - 17)- 30*20), true),
			4 => (A_ipd(8)'last_event, tpd_A_ACOUT((899 - 17)- 30*21), true),
			5 => (A_ipd(7)'last_event, tpd_A_ACOUT((899 - 17)- 30*22), true),
			6 => (A_ipd(6)'last_event, tpd_A_ACOUT((899 - 17)- 30*23), true),
			7 => (A_ipd(5)'last_event, tpd_A_ACOUT((899 - 17)- 30*24), true),
			8 => (A_ipd(4)'last_event, tpd_A_ACOUT((899 - 17)- 30*25), true),
			9 => (A_ipd(3)'last_event, tpd_A_ACOUT((899 - 17)- 30*26), true),
			10 => (A_ipd(2)'last_event, tpd_A_ACOUT((899 - 17)- 30*27), true),
			11 => (A_ipd(1)'last_event, tpd_A_ACOUT((899 - 17)- 30*28), true),
			12 => (A_ipd(0)'last_event, tpd_A_ACOUT((899 - 17)- 30*29), true),
			13 => (ACIN_ipd(12)'last_event, tpd_ACIN_ACOUT((899 - 17)- 30*17), true),
			14 => (ACIN_ipd(11)'last_event, tpd_ACIN_ACOUT((899 - 17)- 30*18), true),
			15 => (ACIN_ipd(10)'last_event, tpd_ACIN_ACOUT((899 - 17)- 30*19), true),
			16 => (ACIN_ipd(9)'last_event, tpd_ACIN_ACOUT((899 - 17)- 30*20), true),
			17 => (ACIN_ipd(8)'last_event, tpd_ACIN_ACOUT((899 - 17)- 30*21), true),
			18 => (ACIN_ipd(7)'last_event, tpd_ACIN_ACOUT((899 - 17)- 30*22), true),
			19 => (ACIN_ipd(6)'last_event, tpd_ACIN_ACOUT((899 - 17)- 30*23), true),
			20 => (ACIN_ipd(5)'last_event, tpd_ACIN_ACOUT((899 - 17)- 30*24), true),
			21 => (ACIN_ipd(4)'last_event, tpd_ACIN_ACOUT((899 - 17)- 30*25), true),
			22 => (ACIN_ipd(3)'last_event, tpd_ACIN_ACOUT((899 - 17)- 30*26), true),
			23 => (ACIN_ipd(2)'last_event, tpd_ACIN_ACOUT((899 - 17)- 30*27), true),
			24 => (ACIN_ipd(1)'last_event, tpd_ACIN_ACOUT((899 - 17)- 30*28), true),
			25 => (ACIN_ipd(0)'last_event, tpd_ACIN_ACOUT((899 - 17)- 30*29), true),
			26 => (CLK_dly'last_event, tpd_CLK_ACOUT(12), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> ACOUT(11),
         GlitchData	=> ACOUT_GlitchData(11),
         OutSignalName	=> "ACOUT(11)",
         OutTemp	=> ACOUT_zd(11),
         Paths		=> (
			0 => (A_ipd(11)'last_event, tpd_A_ACOUT((899 - 18)- 30*18), true),
			1 => (A_ipd(10)'last_event, tpd_A_ACOUT((899 - 18)- 30*19), true),
			2 => (A_ipd(9)'last_event, tpd_A_ACOUT((899 - 18)- 30*20), true),
			3 => (A_ipd(8)'last_event, tpd_A_ACOUT((899 - 18)- 30*21), true),
			4 => (A_ipd(7)'last_event, tpd_A_ACOUT((899 - 18)- 30*22), true),
			5 => (A_ipd(6)'last_event, tpd_A_ACOUT((899 - 18)- 30*23), true),
			6 => (A_ipd(5)'last_event, tpd_A_ACOUT((899 - 18)- 30*24), true),
			7 => (A_ipd(4)'last_event, tpd_A_ACOUT((899 - 18)- 30*25), true),
			8 => (A_ipd(3)'last_event, tpd_A_ACOUT((899 - 18)- 30*26), true),
			9 => (A_ipd(2)'last_event, tpd_A_ACOUT((899 - 18)- 30*27), true),
			10 => (A_ipd(1)'last_event, tpd_A_ACOUT((899 - 18)- 30*28), true),
			11 => (A_ipd(0)'last_event, tpd_A_ACOUT((899 - 18)- 30*29), true),
			12 => (ACIN_ipd(11)'last_event, tpd_ACIN_ACOUT((899 - 18)- 30*18), true),
			13 => (ACIN_ipd(10)'last_event, tpd_ACIN_ACOUT((899 - 18)- 30*19), true),
			14 => (ACIN_ipd(9)'last_event, tpd_ACIN_ACOUT((899 - 18)- 30*20), true),
			15 => (ACIN_ipd(8)'last_event, tpd_ACIN_ACOUT((899 - 18)- 30*21), true),
			16 => (ACIN_ipd(7)'last_event, tpd_ACIN_ACOUT((899 - 18)- 30*22), true),
			17 => (ACIN_ipd(6)'last_event, tpd_ACIN_ACOUT((899 - 18)- 30*23), true),
			18 => (ACIN_ipd(5)'last_event, tpd_ACIN_ACOUT((899 - 18)- 30*24), true),
			19 => (ACIN_ipd(4)'last_event, tpd_ACIN_ACOUT((899 - 18)- 30*25), true),
			20 => (ACIN_ipd(3)'last_event, tpd_ACIN_ACOUT((899 - 18)- 30*26), true),
			21 => (ACIN_ipd(2)'last_event, tpd_ACIN_ACOUT((899 - 18)- 30*27), true),
			22 => (ACIN_ipd(1)'last_event, tpd_ACIN_ACOUT((899 - 18)- 30*28), true),
			23 => (ACIN_ipd(0)'last_event, tpd_ACIN_ACOUT((899 - 18)- 30*29), true),
			24 => (CLK_dly'last_event, tpd_CLK_ACOUT(11), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> ACOUT(10),
         GlitchData	=> ACOUT_GlitchData(10),
         OutSignalName	=> "ACOUT(10)",
         OutTemp	=> ACOUT_zd(10),
         Paths		=> (
			0 => (A_ipd(10)'last_event, tpd_A_ACOUT((899 - 19)- 30*19), true),
			1 => (A_ipd(9)'last_event, tpd_A_ACOUT((899 - 19)- 30*20), true),
			2 => (A_ipd(8)'last_event, tpd_A_ACOUT((899 - 19)- 30*21), true),
			3 => (A_ipd(7)'last_event, tpd_A_ACOUT((899 - 19)- 30*22), true),
			4 => (A_ipd(6)'last_event, tpd_A_ACOUT((899 - 19)- 30*23), true),
			5 => (A_ipd(5)'last_event, tpd_A_ACOUT((899 - 19)- 30*24), true),
			6 => (A_ipd(4)'last_event, tpd_A_ACOUT((899 - 19)- 30*25), true),
			7 => (A_ipd(3)'last_event, tpd_A_ACOUT((899 - 19)- 30*26), true),
			8 => (A_ipd(2)'last_event, tpd_A_ACOUT((899 - 19)- 30*27), true),
			9 => (A_ipd(1)'last_event, tpd_A_ACOUT((899 - 19)- 30*28), true),
			10 => (A_ipd(0)'last_event, tpd_A_ACOUT((899 - 19)- 30*29), true),
			11 => (ACIN_ipd(10)'last_event, tpd_ACIN_ACOUT((899 - 19)- 30*19), true),
			12 => (ACIN_ipd(9)'last_event, tpd_ACIN_ACOUT((899 - 19)- 30*20), true),
			13 => (ACIN_ipd(8)'last_event, tpd_ACIN_ACOUT((899 - 19)- 30*21), true),
			14 => (ACIN_ipd(7)'last_event, tpd_ACIN_ACOUT((899 - 19)- 30*22), true),
			15 => (ACIN_ipd(6)'last_event, tpd_ACIN_ACOUT((899 - 19)- 30*23), true),
			16 => (ACIN_ipd(5)'last_event, tpd_ACIN_ACOUT((899 - 19)- 30*24), true),
			17 => (ACIN_ipd(4)'last_event, tpd_ACIN_ACOUT((899 - 19)- 30*25), true),
			18 => (ACIN_ipd(3)'last_event, tpd_ACIN_ACOUT((899 - 19)- 30*26), true),
			19 => (ACIN_ipd(2)'last_event, tpd_ACIN_ACOUT((899 - 19)- 30*27), true),
			20 => (ACIN_ipd(1)'last_event, tpd_ACIN_ACOUT((899 - 19)- 30*28), true),
			21 => (ACIN_ipd(0)'last_event, tpd_ACIN_ACOUT((899 - 19)- 30*29), true),
			22 => (CLK_dly'last_event, tpd_CLK_ACOUT(10), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> ACOUT(9),
         GlitchData	=> ACOUT_GlitchData(9),
         OutSignalName	=> "ACOUT(9)",
         OutTemp	=> ACOUT_zd(9),
         Paths		=> (
			0 => (A_ipd(9)'last_event, tpd_A_ACOUT((899 - 20)- 30*20), true),
			1 => (A_ipd(8)'last_event, tpd_A_ACOUT((899 - 20)- 30*21), true),
			2 => (A_ipd(7)'last_event, tpd_A_ACOUT((899 - 20)- 30*22), true),
			3 => (A_ipd(6)'last_event, tpd_A_ACOUT((899 - 20)- 30*23), true),
			4 => (A_ipd(5)'last_event, tpd_A_ACOUT((899 - 20)- 30*24), true),
			5 => (A_ipd(4)'last_event, tpd_A_ACOUT((899 - 20)- 30*25), true),
			6 => (A_ipd(3)'last_event, tpd_A_ACOUT((899 - 20)- 30*26), true),
			7 => (A_ipd(2)'last_event, tpd_A_ACOUT((899 - 20)- 30*27), true),
			8 => (A_ipd(1)'last_event, tpd_A_ACOUT((899 - 20)- 30*28), true),
			9 => (A_ipd(0)'last_event, tpd_A_ACOUT((899 - 20)- 30*29), true),
			10 => (ACIN_ipd(9)'last_event, tpd_ACIN_ACOUT((899 - 20)- 30*20), true),
			11 => (ACIN_ipd(8)'last_event, tpd_ACIN_ACOUT((899 - 20)- 30*21), true),
			12 => (ACIN_ipd(7)'last_event, tpd_ACIN_ACOUT((899 - 20)- 30*22), true),
			13 => (ACIN_ipd(6)'last_event, tpd_ACIN_ACOUT((899 - 20)- 30*23), true),
			14 => (ACIN_ipd(5)'last_event, tpd_ACIN_ACOUT((899 - 20)- 30*24), true),
			15 => (ACIN_ipd(4)'last_event, tpd_ACIN_ACOUT((899 - 20)- 30*25), true),
			16 => (ACIN_ipd(3)'last_event, tpd_ACIN_ACOUT((899 - 20)- 30*26), true),
			17 => (ACIN_ipd(2)'last_event, tpd_ACIN_ACOUT((899 - 20)- 30*27), true),
			18 => (ACIN_ipd(1)'last_event, tpd_ACIN_ACOUT((899 - 20)- 30*28), true),
			19 => (ACIN_ipd(0)'last_event, tpd_ACIN_ACOUT((899 - 20)- 30*29), true),
			20 => (CLK_dly'last_event, tpd_CLK_ACOUT(9), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> ACOUT(8),
         GlitchData	=> ACOUT_GlitchData(8),
         OutSignalName	=> "ACOUT(8)",
         OutTemp	=> ACOUT_zd(8),
         Paths		=> (
			0 => (A_ipd(8)'last_event, tpd_A_ACOUT((899 - 21)- 30*21), true),
			1 => (A_ipd(7)'last_event, tpd_A_ACOUT((899 - 21)- 30*22), true),
			2 => (A_ipd(6)'last_event, tpd_A_ACOUT((899 - 21)- 30*23), true),
			3 => (A_ipd(5)'last_event, tpd_A_ACOUT((899 - 21)- 30*24), true),
			4 => (A_ipd(4)'last_event, tpd_A_ACOUT((899 - 21)- 30*25), true),
			5 => (A_ipd(3)'last_event, tpd_A_ACOUT((899 - 21)- 30*26), true),
			6 => (A_ipd(2)'last_event, tpd_A_ACOUT((899 - 21)- 30*27), true),
			7 => (A_ipd(1)'last_event, tpd_A_ACOUT((899 - 21)- 30*28), true),
			8 => (A_ipd(0)'last_event, tpd_A_ACOUT((899 - 21)- 30*29), true),
			9 => (ACIN_ipd(8)'last_event, tpd_ACIN_ACOUT((899 - 21)- 30*21), true),
			10 => (ACIN_ipd(7)'last_event, tpd_ACIN_ACOUT((899 - 21)- 30*22), true),
			11 => (ACIN_ipd(6)'last_event, tpd_ACIN_ACOUT((899 - 21)- 30*23), true),
			12 => (ACIN_ipd(5)'last_event, tpd_ACIN_ACOUT((899 - 21)- 30*24), true),
			13 => (ACIN_ipd(4)'last_event, tpd_ACIN_ACOUT((899 - 21)- 30*25), true),
			14 => (ACIN_ipd(3)'last_event, tpd_ACIN_ACOUT((899 - 21)- 30*26), true),
			15 => (ACIN_ipd(2)'last_event, tpd_ACIN_ACOUT((899 - 21)- 30*27), true),
			16 => (ACIN_ipd(1)'last_event, tpd_ACIN_ACOUT((899 - 21)- 30*28), true),
			17 => (ACIN_ipd(0)'last_event, tpd_ACIN_ACOUT((899 - 21)- 30*29), true),
			18 => (CLK_dly'last_event, tpd_CLK_ACOUT(8), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> ACOUT(7),
         GlitchData	=> ACOUT_GlitchData(7),
         OutSignalName	=> "ACOUT(7)",
         OutTemp	=> ACOUT_zd(7),
         Paths		=> (
			0 => (A_ipd(7)'last_event, tpd_A_ACOUT((899 - 22)- 30*22), true),
			1 => (A_ipd(6)'last_event, tpd_A_ACOUT((899 - 22)- 30*23), true),
			2 => (A_ipd(5)'last_event, tpd_A_ACOUT((899 - 22)- 30*24), true),
			3 => (A_ipd(4)'last_event, tpd_A_ACOUT((899 - 22)- 30*25), true),
			4 => (A_ipd(3)'last_event, tpd_A_ACOUT((899 - 22)- 30*26), true),
			5 => (A_ipd(2)'last_event, tpd_A_ACOUT((899 - 22)- 30*27), true),
			6 => (A_ipd(1)'last_event, tpd_A_ACOUT((899 - 22)- 30*28), true),
			7 => (A_ipd(0)'last_event, tpd_A_ACOUT((899 - 22)- 30*29), true),
			8 => (ACIN_ipd(7)'last_event, tpd_ACIN_ACOUT((899 - 22)- 30*22), true),
			9 => (ACIN_ipd(6)'last_event, tpd_ACIN_ACOUT((899 - 22)- 30*23), true),
			10 => (ACIN_ipd(5)'last_event, tpd_ACIN_ACOUT((899 - 22)- 30*24), true),
			11 => (ACIN_ipd(4)'last_event, tpd_ACIN_ACOUT((899 - 22)- 30*25), true),
			12 => (ACIN_ipd(3)'last_event, tpd_ACIN_ACOUT((899 - 22)- 30*26), true),
			13 => (ACIN_ipd(2)'last_event, tpd_ACIN_ACOUT((899 - 22)- 30*27), true),
			14 => (ACIN_ipd(1)'last_event, tpd_ACIN_ACOUT((899 - 22)- 30*28), true),
			15 => (ACIN_ipd(0)'last_event, tpd_ACIN_ACOUT((899 - 22)- 30*29), true),
			16 => (CLK_dly'last_event, tpd_CLK_ACOUT(7), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> ACOUT(6),
         GlitchData	=> ACOUT_GlitchData(6),
         OutSignalName	=> "ACOUT(6)",
         OutTemp	=> ACOUT_zd(6),
         Paths		=> (
			0 => (A_ipd(6)'last_event, tpd_A_ACOUT((899 - 23)- 30*23), true),
			1 => (A_ipd(5)'last_event, tpd_A_ACOUT((899 - 23)- 30*24), true),
			2 => (A_ipd(4)'last_event, tpd_A_ACOUT((899 - 23)- 30*25), true),
			3 => (A_ipd(3)'last_event, tpd_A_ACOUT((899 - 23)- 30*26), true),
			4 => (A_ipd(2)'last_event, tpd_A_ACOUT((899 - 23)- 30*27), true),
			5 => (A_ipd(1)'last_event, tpd_A_ACOUT((899 - 23)- 30*28), true),
			6 => (A_ipd(0)'last_event, tpd_A_ACOUT((899 - 23)- 30*29), true),
			7 => (ACIN_ipd(6)'last_event, tpd_ACIN_ACOUT((899 - 23)- 30*23), true),
			8 => (ACIN_ipd(5)'last_event, tpd_ACIN_ACOUT((899 - 23)- 30*24), true),
			9 => (ACIN_ipd(4)'last_event, tpd_ACIN_ACOUT((899 - 23)- 30*25), true),
			10 => (ACIN_ipd(3)'last_event, tpd_ACIN_ACOUT((899 - 23)- 30*26), true),
			11 => (ACIN_ipd(2)'last_event, tpd_ACIN_ACOUT((899 - 23)- 30*27), true),
			12 => (ACIN_ipd(1)'last_event, tpd_ACIN_ACOUT((899 - 23)- 30*28), true),
			13 => (ACIN_ipd(0)'last_event, tpd_ACIN_ACOUT((899 - 23)- 30*29), true),
			14 => (CLK_dly'last_event, tpd_CLK_ACOUT(6), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> ACOUT(5),
         GlitchData	=> ACOUT_GlitchData(5),
         OutSignalName	=> "ACOUT(5)",
         OutTemp	=> ACOUT_zd(5),
         Paths		=> (
			0 => (A_ipd(5)'last_event, tpd_A_ACOUT((899 - 24)- 30*24), true),
			1 => (A_ipd(4)'last_event, tpd_A_ACOUT((899 - 24)- 30*25), true),
			2 => (A_ipd(3)'last_event, tpd_A_ACOUT((899 - 24)- 30*26), true),
			3 => (A_ipd(2)'last_event, tpd_A_ACOUT((899 - 24)- 30*27), true),
			4 => (A_ipd(1)'last_event, tpd_A_ACOUT((899 - 24)- 30*28), true),
			5 => (A_ipd(0)'last_event, tpd_A_ACOUT((899 - 24)- 30*29), true),
			6 => (ACIN_ipd(5)'last_event, tpd_ACIN_ACOUT((899 - 24)- 30*24), true),
			7 => (ACIN_ipd(4)'last_event, tpd_ACIN_ACOUT((899 - 24)- 30*25), true),
			8 => (ACIN_ipd(3)'last_event, tpd_ACIN_ACOUT((899 - 24)- 30*26), true),
			9 => (ACIN_ipd(2)'last_event, tpd_ACIN_ACOUT((899 - 24)- 30*27), true),
			10 => (ACIN_ipd(1)'last_event, tpd_ACIN_ACOUT((899 - 24)- 30*28), true),
			11 => (ACIN_ipd(0)'last_event, tpd_ACIN_ACOUT((899 - 24)- 30*29), true),
			12 => (CLK_dly'last_event, tpd_CLK_ACOUT(5), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> ACOUT(4),
         GlitchData	=> ACOUT_GlitchData(4),
         OutSignalName	=> "ACOUT(4)",
         OutTemp	=> ACOUT_zd(4),
         Paths		=> (
			0 => (A_ipd(4)'last_event, tpd_A_ACOUT((899 - 25)- 30*25), true),
			1 => (A_ipd(3)'last_event, tpd_A_ACOUT((899 - 25)- 30*26), true),
			2 => (A_ipd(2)'last_event, tpd_A_ACOUT((899 - 25)- 30*27), true),
			3 => (A_ipd(1)'last_event, tpd_A_ACOUT((899 - 25)- 30*28), true),
			4 => (A_ipd(0)'last_event, tpd_A_ACOUT((899 - 25)- 30*29), true),
			5 => (ACIN_ipd(4)'last_event, tpd_ACIN_ACOUT((899 - 25)- 30*25), true),
			6 => (ACIN_ipd(3)'last_event, tpd_ACIN_ACOUT((899 - 25)- 30*26), true),
			7 => (ACIN_ipd(2)'last_event, tpd_ACIN_ACOUT((899 - 25)- 30*27), true),
			8 => (ACIN_ipd(1)'last_event, tpd_ACIN_ACOUT((899 - 25)- 30*28), true),
			9 => (ACIN_ipd(0)'last_event, tpd_ACIN_ACOUT((899 - 25)- 30*29), true),
			10 => (CLK_dly'last_event, tpd_CLK_ACOUT(4), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> ACOUT(3),
         GlitchData	=> ACOUT_GlitchData(3),
         OutSignalName	=> "ACOUT(3)",
         OutTemp	=> ACOUT_zd(3),
         Paths		=> (
			0 => (A_ipd(3)'last_event, tpd_A_ACOUT((899 - 26)- 30*26), true),
			1 => (A_ipd(2)'last_event, tpd_A_ACOUT((899 - 26)- 30*27), true),
			2 => (A_ipd(1)'last_event, tpd_A_ACOUT((899 - 26)- 30*28), true),
			3 => (A_ipd(0)'last_event, tpd_A_ACOUT((899 - 26)- 30*29), true),
			4 => (ACIN_ipd(3)'last_event, tpd_ACIN_ACOUT((899 - 26)- 30*26), true),
			5 => (ACIN_ipd(2)'last_event, tpd_ACIN_ACOUT((899 - 26)- 30*27), true),
			6 => (ACIN_ipd(1)'last_event, tpd_ACIN_ACOUT((899 - 26)- 30*28), true),
			7 => (ACIN_ipd(0)'last_event, tpd_ACIN_ACOUT((899 - 26)- 30*29), true),
			8 => (CLK_dly'last_event, tpd_CLK_ACOUT(3), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> ACOUT(2),
         GlitchData	=> ACOUT_GlitchData(2),
         OutSignalName	=> "ACOUT(2)",
         OutTemp	=> ACOUT_zd(2),
         Paths		=> (
			0 => (A_ipd(2)'last_event, tpd_A_ACOUT((899 - 27)- 30*27), true),
			1 => (A_ipd(1)'last_event, tpd_A_ACOUT((899 - 27)- 30*28), true),
			2 => (A_ipd(0)'last_event, tpd_A_ACOUT((899 - 27)- 30*29), true),
			3 => (ACIN_ipd(2)'last_event, tpd_ACIN_ACOUT((899 - 27)- 30*27), true),
			4 => (ACIN_ipd(1)'last_event, tpd_ACIN_ACOUT((899 - 27)- 30*28), true),
			5 => (ACIN_ipd(0)'last_event, tpd_ACIN_ACOUT((899 - 27)- 30*29), true),
			6 => (CLK_dly'last_event, tpd_CLK_ACOUT(2), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> ACOUT(1),
         GlitchData	=> ACOUT_GlitchData(1),
         OutSignalName	=> "ACOUT(1)",
         OutTemp	=> ACOUT_zd(1),
         Paths		=> (
			0 => (A_ipd(1)'last_event, tpd_A_ACOUT((899 - 28)- 30*28), true),
			1 => (A_ipd(0)'last_event, tpd_A_ACOUT((899 - 28)- 30*29), true),
			2 => (ACIN_ipd(1)'last_event, tpd_ACIN_ACOUT((899 - 28)- 30*28), true),
			3 => (ACIN_ipd(0)'last_event, tpd_ACIN_ACOUT((899 - 28)- 30*29), true),
			4 => (CLK_dly'last_event, tpd_CLK_ACOUT(1), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> ACOUT(0),
         GlitchData	=> ACOUT_GlitchData(0),
         OutSignalName	=> "ACOUT(0)",
         OutTemp	=> ACOUT_zd(0),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_ACOUT((899 - 29)- 30*29), true),
			1 => (ACIN_ipd(0)'last_event, tpd_ACIN_ACOUT((899 - 29)- 30*29), true),
			2 => (CLK_dly'last_event, tpd_CLK_ACOUT(0), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> BCOUT(17),
         GlitchData	=> BCOUT_GlitchData(17),
         OutSignalName	=> "BCOUT(17)",
         OutTemp	=> BCOUT_zd(17),
         Paths		=> (
			0 => (B_ipd(17)'last_event, tpd_B_BCOUT((323 - 0)- 18*0), true),
			1 => (B_ipd(16)'last_event, tpd_B_BCOUT((323 - 0)- 18*1), true),
			2 => (B_ipd(15)'last_event, tpd_B_BCOUT((323 - 0)- 18*2), true),
			3 => (B_ipd(14)'last_event, tpd_B_BCOUT((323 - 0)- 18*3), true),
			4 => (B_ipd(13)'last_event, tpd_B_BCOUT((323 - 0)- 18*4), true),
			5 => (B_ipd(12)'last_event, tpd_B_BCOUT((323 - 0)- 18*5), true),
			6 => (B_ipd(11)'last_event, tpd_B_BCOUT((323 - 0)- 18*6), true),
			7 => (B_ipd(10)'last_event, tpd_B_BCOUT((323 - 0)- 18*7), true),
			8 => (B_ipd(9)'last_event, tpd_B_BCOUT((323 - 0)- 18*8), true),
			9 => (B_ipd(8)'last_event, tpd_B_BCOUT((323 - 0)- 18*9), true),
			10 => (B_ipd(7)'last_event, tpd_B_BCOUT((323 - 0)- 18*10), true),
			11 => (B_ipd(6)'last_event, tpd_B_BCOUT((323 - 0)- 18*11), true),
			12 => (B_ipd(5)'last_event, tpd_B_BCOUT((323 - 0)- 18*12), true),
			13 => (B_ipd(4)'last_event, tpd_B_BCOUT((323 - 0)- 18*13), true),
			14 => (B_ipd(3)'last_event, tpd_B_BCOUT((323 - 0)- 18*14), true),
			15 => (B_ipd(2)'last_event, tpd_B_BCOUT((323 - 0)- 18*15), true),
			16 => (B_ipd(1)'last_event, tpd_B_BCOUT((323 - 0)- 18*16), true),
			17 => (B_ipd(0)'last_event, tpd_B_BCOUT((323 - 0)- 18*17), true),
			18 => (BCIN_ipd(17)'last_event, tpd_BCIN_BCOUT((323 - 0)- 18*0), true),
			19 => (BCIN_ipd(16)'last_event, tpd_BCIN_BCOUT((323 - 0)- 18*1), true),
			20 => (BCIN_ipd(15)'last_event, tpd_BCIN_BCOUT((323 - 0)- 18*2), true),
			21 => (BCIN_ipd(14)'last_event, tpd_BCIN_BCOUT((323 - 0)- 18*3), true),
			22 => (BCIN_ipd(13)'last_event, tpd_BCIN_BCOUT((323 - 0)- 18*4), true),
			23 => (BCIN_ipd(12)'last_event, tpd_BCIN_BCOUT((323 - 0)- 18*5), true),
			24 => (BCIN_ipd(11)'last_event, tpd_BCIN_BCOUT((323 - 0)- 18*6), true),
			25 => (BCIN_ipd(10)'last_event, tpd_BCIN_BCOUT((323 - 0)- 18*7), true),
			26 => (BCIN_ipd(9)'last_event, tpd_BCIN_BCOUT((323 - 0)- 18*8), true),
			27 => (BCIN_ipd(8)'last_event, tpd_BCIN_BCOUT((323 - 0)- 18*9), true),
			28 => (BCIN_ipd(7)'last_event, tpd_BCIN_BCOUT((323 - 0)- 18*10), true),
			29 => (BCIN_ipd(6)'last_event, tpd_BCIN_BCOUT((323 - 0)- 18*11), true),
			30 => (BCIN_ipd(5)'last_event, tpd_BCIN_BCOUT((323 - 0)- 18*12), true),
			31 => (BCIN_ipd(4)'last_event, tpd_BCIN_BCOUT((323 - 0)- 18*13), true),
			32 => (BCIN_ipd(3)'last_event, tpd_BCIN_BCOUT((323 - 0)- 18*14), true),
			33 => (BCIN_ipd(2)'last_event, tpd_BCIN_BCOUT((323 - 0)- 18*15), true),
			34 => (BCIN_ipd(1)'last_event, tpd_BCIN_BCOUT((323 - 0)- 18*16), true),
			35 => (BCIN_ipd(0)'last_event, tpd_BCIN_BCOUT((323 - 0)- 18*17), true),
			36 => (CLK_dly'last_event, tpd_CLK_BCOUT(17), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> BCOUT(16),
         GlitchData	=> BCOUT_GlitchData(16),
         OutSignalName	=> "BCOUT(16)",
         OutTemp	=> BCOUT_zd(16),
         Paths		=> (
			0 => (B_ipd(16)'last_event, tpd_B_BCOUT((323 - 1)- 18*1), true),
			1 => (B_ipd(15)'last_event, tpd_B_BCOUT((323 - 1)- 18*2), true),
			2 => (B_ipd(14)'last_event, tpd_B_BCOUT((323 - 1)- 18*3), true),
			3 => (B_ipd(13)'last_event, tpd_B_BCOUT((323 - 1)- 18*4), true),
			4 => (B_ipd(12)'last_event, tpd_B_BCOUT((323 - 1)- 18*5), true),
			5 => (B_ipd(11)'last_event, tpd_B_BCOUT((323 - 1)- 18*6), true),
			6 => (B_ipd(10)'last_event, tpd_B_BCOUT((323 - 1)- 18*7), true),
			7 => (B_ipd(9)'last_event, tpd_B_BCOUT((323 - 1)- 18*8), true),
			8 => (B_ipd(8)'last_event, tpd_B_BCOUT((323 - 1)- 18*9), true),
			9 => (B_ipd(7)'last_event, tpd_B_BCOUT((323 - 1)- 18*10), true),
			10 => (B_ipd(6)'last_event, tpd_B_BCOUT((323 - 1)- 18*11), true),
			11 => (B_ipd(5)'last_event, tpd_B_BCOUT((323 - 1)- 18*12), true),
			12 => (B_ipd(4)'last_event, tpd_B_BCOUT((323 - 1)- 18*13), true),
			13 => (B_ipd(3)'last_event, tpd_B_BCOUT((323 - 1)- 18*14), true),
			14 => (B_ipd(2)'last_event, tpd_B_BCOUT((323 - 1)- 18*15), true),
			15 => (B_ipd(1)'last_event, tpd_B_BCOUT((323 - 1)- 18*16), true),
			16 => (B_ipd(0)'last_event, tpd_B_BCOUT((323 - 1)- 18*17), true),
			17 => (BCIN_ipd(16)'last_event, tpd_BCIN_BCOUT((323 - 1)- 18*1), true),
			18 => (BCIN_ipd(15)'last_event, tpd_BCIN_BCOUT((323 - 1)- 18*2), true),
			19 => (BCIN_ipd(14)'last_event, tpd_BCIN_BCOUT((323 - 1)- 18*3), true),
			20 => (BCIN_ipd(13)'last_event, tpd_BCIN_BCOUT((323 - 1)- 18*4), true),
			21 => (BCIN_ipd(12)'last_event, tpd_BCIN_BCOUT((323 - 1)- 18*5), true),
			22 => (BCIN_ipd(11)'last_event, tpd_BCIN_BCOUT((323 - 1)- 18*6), true),
			23 => (BCIN_ipd(10)'last_event, tpd_BCIN_BCOUT((323 - 1)- 18*7), true),
			24 => (BCIN_ipd(9)'last_event, tpd_BCIN_BCOUT((323 - 1)- 18*8), true),
			25 => (BCIN_ipd(8)'last_event, tpd_BCIN_BCOUT((323 - 1)- 18*9), true),
			26 => (BCIN_ipd(7)'last_event, tpd_BCIN_BCOUT((323 - 1)- 18*10), true),
			27 => (BCIN_ipd(6)'last_event, tpd_BCIN_BCOUT((323 - 1)- 18*11), true),
			28 => (BCIN_ipd(5)'last_event, tpd_BCIN_BCOUT((323 - 1)- 18*12), true),
			29 => (BCIN_ipd(4)'last_event, tpd_BCIN_BCOUT((323 - 1)- 18*13), true),
			30 => (BCIN_ipd(3)'last_event, tpd_BCIN_BCOUT((323 - 1)- 18*14), true),
			31 => (BCIN_ipd(2)'last_event, tpd_BCIN_BCOUT((323 - 1)- 18*15), true),
			32 => (BCIN_ipd(1)'last_event, tpd_BCIN_BCOUT((323 - 1)- 18*16), true),
			33 => (BCIN_ipd(0)'last_event, tpd_BCIN_BCOUT((323 - 1)- 18*17), true),
			34 => (CLK_dly'last_event, tpd_CLK_BCOUT(16), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> BCOUT(15),
         GlitchData	=> BCOUT_GlitchData(15),
         OutSignalName	=> "BCOUT(15)",
         OutTemp	=> BCOUT_zd(15),
         Paths		=> (
			0 => (B_ipd(15)'last_event, tpd_B_BCOUT((323 - 2)- 18*2), true),
			1 => (B_ipd(14)'last_event, tpd_B_BCOUT((323 - 2)- 18*3), true),
			2 => (B_ipd(13)'last_event, tpd_B_BCOUT((323 - 2)- 18*4), true),
			3 => (B_ipd(12)'last_event, tpd_B_BCOUT((323 - 2)- 18*5), true),
			4 => (B_ipd(11)'last_event, tpd_B_BCOUT((323 - 2)- 18*6), true),
			5 => (B_ipd(10)'last_event, tpd_B_BCOUT((323 - 2)- 18*7), true),
			6 => (B_ipd(9)'last_event, tpd_B_BCOUT((323 - 2)- 18*8), true),
			7 => (B_ipd(8)'last_event, tpd_B_BCOUT((323 - 2)- 18*9), true),
			8 => (B_ipd(7)'last_event, tpd_B_BCOUT((323 - 2)- 18*10), true),
			9 => (B_ipd(6)'last_event, tpd_B_BCOUT((323 - 2)- 18*11), true),
			10 => (B_ipd(5)'last_event, tpd_B_BCOUT((323 - 2)- 18*12), true),
			11 => (B_ipd(4)'last_event, tpd_B_BCOUT((323 - 2)- 18*13), true),
			12 => (B_ipd(3)'last_event, tpd_B_BCOUT((323 - 2)- 18*14), true),
			13 => (B_ipd(2)'last_event, tpd_B_BCOUT((323 - 2)- 18*15), true),
			14 => (B_ipd(1)'last_event, tpd_B_BCOUT((323 - 2)- 18*16), true),
			15 => (B_ipd(0)'last_event, tpd_B_BCOUT((323 - 2)- 18*17), true),
			16 => (BCIN_ipd(15)'last_event, tpd_BCIN_BCOUT((323 - 2)- 18*2), true),
			17 => (BCIN_ipd(14)'last_event, tpd_BCIN_BCOUT((323 - 2)- 18*3), true),
			18 => (BCIN_ipd(13)'last_event, tpd_BCIN_BCOUT((323 - 2)- 18*4), true),
			19 => (BCIN_ipd(12)'last_event, tpd_BCIN_BCOUT((323 - 2)- 18*5), true),
			20 => (BCIN_ipd(11)'last_event, tpd_BCIN_BCOUT((323 - 2)- 18*6), true),
			21 => (BCIN_ipd(10)'last_event, tpd_BCIN_BCOUT((323 - 2)- 18*7), true),
			22 => (BCIN_ipd(9)'last_event, tpd_BCIN_BCOUT((323 - 2)- 18*8), true),
			23 => (BCIN_ipd(8)'last_event, tpd_BCIN_BCOUT((323 - 2)- 18*9), true),
			24 => (BCIN_ipd(7)'last_event, tpd_BCIN_BCOUT((323 - 2)- 18*10), true),
			25 => (BCIN_ipd(6)'last_event, tpd_BCIN_BCOUT((323 - 2)- 18*11), true),
			26 => (BCIN_ipd(5)'last_event, tpd_BCIN_BCOUT((323 - 2)- 18*12), true),
			27 => (BCIN_ipd(4)'last_event, tpd_BCIN_BCOUT((323 - 2)- 18*13), true),
			28 => (BCIN_ipd(3)'last_event, tpd_BCIN_BCOUT((323 - 2)- 18*14), true),
			29 => (BCIN_ipd(2)'last_event, tpd_BCIN_BCOUT((323 - 2)- 18*15), true),
			30 => (BCIN_ipd(1)'last_event, tpd_BCIN_BCOUT((323 - 2)- 18*16), true),
			31 => (BCIN_ipd(0)'last_event, tpd_BCIN_BCOUT((323 - 2)- 18*17), true),
			32 => (CLK_dly'last_event, tpd_CLK_BCOUT(15), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> BCOUT(14),
         GlitchData	=> BCOUT_GlitchData(14),
         OutSignalName	=> "BCOUT(14)",
         OutTemp	=> BCOUT_zd(14),
         Paths		=> (
			0 => (B_ipd(14)'last_event, tpd_B_BCOUT((323 - 3)- 18*3), true),
			1 => (B_ipd(13)'last_event, tpd_B_BCOUT((323 - 3)- 18*4), true),
			2 => (B_ipd(12)'last_event, tpd_B_BCOUT((323 - 3)- 18*5), true),
			3 => (B_ipd(11)'last_event, tpd_B_BCOUT((323 - 3)- 18*6), true),
			4 => (B_ipd(10)'last_event, tpd_B_BCOUT((323 - 3)- 18*7), true),
			5 => (B_ipd(9)'last_event, tpd_B_BCOUT((323 - 3)- 18*8), true),
			6 => (B_ipd(8)'last_event, tpd_B_BCOUT((323 - 3)- 18*9), true),
			7 => (B_ipd(7)'last_event, tpd_B_BCOUT((323 - 3)- 18*10), true),
			8 => (B_ipd(6)'last_event, tpd_B_BCOUT((323 - 3)- 18*11), true),
			9 => (B_ipd(5)'last_event, tpd_B_BCOUT((323 - 3)- 18*12), true),
			10 => (B_ipd(4)'last_event, tpd_B_BCOUT((323 - 3)- 18*13), true),
			11 => (B_ipd(3)'last_event, tpd_B_BCOUT((323 - 3)- 18*14), true),
			12 => (B_ipd(2)'last_event, tpd_B_BCOUT((323 - 3)- 18*15), true),
			13 => (B_ipd(1)'last_event, tpd_B_BCOUT((323 - 3)- 18*16), true),
			14 => (B_ipd(0)'last_event, tpd_B_BCOUT((323 - 3)- 18*17), true),
			15 => (BCIN_ipd(14)'last_event, tpd_BCIN_BCOUT((323 - 3)- 18*3), true),
			16 => (BCIN_ipd(13)'last_event, tpd_BCIN_BCOUT((323 - 3)- 18*4), true),
			17 => (BCIN_ipd(12)'last_event, tpd_BCIN_BCOUT((323 - 3)- 18*5), true),
			18 => (BCIN_ipd(11)'last_event, tpd_BCIN_BCOUT((323 - 3)- 18*6), true),
			19 => (BCIN_ipd(10)'last_event, tpd_BCIN_BCOUT((323 - 3)- 18*7), true),
			20 => (BCIN_ipd(9)'last_event, tpd_BCIN_BCOUT((323 - 3)- 18*8), true),
			21 => (BCIN_ipd(8)'last_event, tpd_BCIN_BCOUT((323 - 3)- 18*9), true),
			22 => (BCIN_ipd(7)'last_event, tpd_BCIN_BCOUT((323 - 3)- 18*10), true),
			23 => (BCIN_ipd(6)'last_event, tpd_BCIN_BCOUT((323 - 3)- 18*11), true),
			24 => (BCIN_ipd(5)'last_event, tpd_BCIN_BCOUT((323 - 3)- 18*12), true),
			25 => (BCIN_ipd(4)'last_event, tpd_BCIN_BCOUT((323 - 3)- 18*13), true),
			26 => (BCIN_ipd(3)'last_event, tpd_BCIN_BCOUT((323 - 3)- 18*14), true),
			27 => (BCIN_ipd(2)'last_event, tpd_BCIN_BCOUT((323 - 3)- 18*15), true),
			28 => (BCIN_ipd(1)'last_event, tpd_BCIN_BCOUT((323 - 3)- 18*16), true),
			29 => (BCIN_ipd(0)'last_event, tpd_BCIN_BCOUT((323 - 3)- 18*17), true),
			30 => (CLK_dly'last_event, tpd_CLK_BCOUT(14), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> BCOUT(13),
         GlitchData	=> BCOUT_GlitchData(13),
         OutSignalName	=> "BCOUT(13)",
         OutTemp	=> BCOUT_zd(13),
         Paths		=> (
			0 => (B_ipd(13)'last_event, tpd_B_BCOUT((323 - 4)- 18*4), true),
			1 => (B_ipd(12)'last_event, tpd_B_BCOUT((323 - 4)- 18*5), true),
			2 => (B_ipd(11)'last_event, tpd_B_BCOUT((323 - 4)- 18*6), true),
			3 => (B_ipd(10)'last_event, tpd_B_BCOUT((323 - 4)- 18*7), true),
			4 => (B_ipd(9)'last_event, tpd_B_BCOUT((323 - 4)- 18*8), true),
			5 => (B_ipd(8)'last_event, tpd_B_BCOUT((323 - 4)- 18*9), true),
			6 => (B_ipd(7)'last_event, tpd_B_BCOUT((323 - 4)- 18*10), true),
			7 => (B_ipd(6)'last_event, tpd_B_BCOUT((323 - 4)- 18*11), true),
			8 => (B_ipd(5)'last_event, tpd_B_BCOUT((323 - 4)- 18*12), true),
			9 => (B_ipd(4)'last_event, tpd_B_BCOUT((323 - 4)- 18*13), true),
			10 => (B_ipd(3)'last_event, tpd_B_BCOUT((323 - 4)- 18*14), true),
			11 => (B_ipd(2)'last_event, tpd_B_BCOUT((323 - 4)- 18*15), true),
			12 => (B_ipd(1)'last_event, tpd_B_BCOUT((323 - 4)- 18*16), true),
			13 => (B_ipd(0)'last_event, tpd_B_BCOUT((323 - 4)- 18*17), true),
			14 => (BCIN_ipd(13)'last_event, tpd_BCIN_BCOUT((323 - 4)- 18*4), true),
			15 => (BCIN_ipd(12)'last_event, tpd_BCIN_BCOUT((323 - 4)- 18*5), true),
			16 => (BCIN_ipd(11)'last_event, tpd_BCIN_BCOUT((323 - 4)- 18*6), true),
			17 => (BCIN_ipd(10)'last_event, tpd_BCIN_BCOUT((323 - 4)- 18*7), true),
			18 => (BCIN_ipd(9)'last_event, tpd_BCIN_BCOUT((323 - 4)- 18*8), true),
			19 => (BCIN_ipd(8)'last_event, tpd_BCIN_BCOUT((323 - 4)- 18*9), true),
			20 => (BCIN_ipd(7)'last_event, tpd_BCIN_BCOUT((323 - 4)- 18*10), true),
			21 => (BCIN_ipd(6)'last_event, tpd_BCIN_BCOUT((323 - 4)- 18*11), true),
			22 => (BCIN_ipd(5)'last_event, tpd_BCIN_BCOUT((323 - 4)- 18*12), true),
			23 => (BCIN_ipd(4)'last_event, tpd_BCIN_BCOUT((323 - 4)- 18*13), true),
			24 => (BCIN_ipd(3)'last_event, tpd_BCIN_BCOUT((323 - 4)- 18*14), true),
			25 => (BCIN_ipd(2)'last_event, tpd_BCIN_BCOUT((323 - 4)- 18*15), true),
			26 => (BCIN_ipd(1)'last_event, tpd_BCIN_BCOUT((323 - 4)- 18*16), true),
			27 => (BCIN_ipd(0)'last_event, tpd_BCIN_BCOUT((323 - 4)- 18*17), true),
			28 => (CLK_dly'last_event, tpd_CLK_BCOUT(13), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> BCOUT(12),
         GlitchData	=> BCOUT_GlitchData(12),
         OutSignalName	=> "BCOUT(12)",
         OutTemp	=> BCOUT_zd(12),
         Paths		=> (
			0 => (B_ipd(12)'last_event, tpd_B_BCOUT((323 - 5)- 18*5), true),
			1 => (B_ipd(11)'last_event, tpd_B_BCOUT((323 - 5)- 18*6), true),
			2 => (B_ipd(10)'last_event, tpd_B_BCOUT((323 - 5)- 18*7), true),
			3 => (B_ipd(9)'last_event, tpd_B_BCOUT((323 - 5)- 18*8), true),
			4 => (B_ipd(8)'last_event, tpd_B_BCOUT((323 - 5)- 18*9), true),
			5 => (B_ipd(7)'last_event, tpd_B_BCOUT((323 - 5)- 18*10), true),
			6 => (B_ipd(6)'last_event, tpd_B_BCOUT((323 - 5)- 18*11), true),
			7 => (B_ipd(5)'last_event, tpd_B_BCOUT((323 - 5)- 18*12), true),
			8 => (B_ipd(4)'last_event, tpd_B_BCOUT((323 - 5)- 18*13), true),
			9 => (B_ipd(3)'last_event, tpd_B_BCOUT((323 - 5)- 18*14), true),
			10 => (B_ipd(2)'last_event, tpd_B_BCOUT((323 - 5)- 18*15), true),
			11 => (B_ipd(1)'last_event, tpd_B_BCOUT((323 - 5)- 18*16), true),
			12 => (B_ipd(0)'last_event, tpd_B_BCOUT((323 - 5)- 18*17), true),
			13 => (BCIN_ipd(12)'last_event, tpd_BCIN_BCOUT((323 - 5)- 18*5), true),
			14 => (BCIN_ipd(11)'last_event, tpd_BCIN_BCOUT((323 - 5)- 18*6), true),
			15 => (BCIN_ipd(10)'last_event, tpd_BCIN_BCOUT((323 - 5)- 18*7), true),
			16 => (BCIN_ipd(9)'last_event, tpd_BCIN_BCOUT((323 - 5)- 18*8), true),
			17 => (BCIN_ipd(8)'last_event, tpd_BCIN_BCOUT((323 - 5)- 18*9), true),
			18 => (BCIN_ipd(7)'last_event, tpd_BCIN_BCOUT((323 - 5)- 18*10), true),
			19 => (BCIN_ipd(6)'last_event, tpd_BCIN_BCOUT((323 - 5)- 18*11), true),
			20 => (BCIN_ipd(5)'last_event, tpd_BCIN_BCOUT((323 - 5)- 18*12), true),
			21 => (BCIN_ipd(4)'last_event, tpd_BCIN_BCOUT((323 - 5)- 18*13), true),
			22 => (BCIN_ipd(3)'last_event, tpd_BCIN_BCOUT((323 - 5)- 18*14), true),
			23 => (BCIN_ipd(2)'last_event, tpd_BCIN_BCOUT((323 - 5)- 18*15), true),
			24 => (BCIN_ipd(1)'last_event, tpd_BCIN_BCOUT((323 - 5)- 18*16), true),
			25 => (BCIN_ipd(0)'last_event, tpd_BCIN_BCOUT((323 - 5)- 18*17), true),
			26 => (CLK_dly'last_event, tpd_CLK_BCOUT(12), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> BCOUT(11),
         GlitchData	=> BCOUT_GlitchData(11),
         OutSignalName	=> "BCOUT(11)",
         OutTemp	=> BCOUT_zd(11),
         Paths		=> (
			0 => (B_ipd(11)'last_event, tpd_B_BCOUT((323 - 6)- 18*6), true),
			1 => (B_ipd(10)'last_event, tpd_B_BCOUT((323 - 6)- 18*7), true),
			2 => (B_ipd(9)'last_event, tpd_B_BCOUT((323 - 6)- 18*8), true),
			3 => (B_ipd(8)'last_event, tpd_B_BCOUT((323 - 6)- 18*9), true),
			4 => (B_ipd(7)'last_event, tpd_B_BCOUT((323 - 6)- 18*10), true),
			5 => (B_ipd(6)'last_event, tpd_B_BCOUT((323 - 6)- 18*11), true),
			6 => (B_ipd(5)'last_event, tpd_B_BCOUT((323 - 6)- 18*12), true),
			7 => (B_ipd(4)'last_event, tpd_B_BCOUT((323 - 6)- 18*13), true),
			8 => (B_ipd(3)'last_event, tpd_B_BCOUT((323 - 6)- 18*14), true),
			9 => (B_ipd(2)'last_event, tpd_B_BCOUT((323 - 6)- 18*15), true),
			10 => (B_ipd(1)'last_event, tpd_B_BCOUT((323 - 6)- 18*16), true),
			11 => (B_ipd(0)'last_event, tpd_B_BCOUT((323 - 6)- 18*17), true),
			12 => (BCIN_ipd(11)'last_event, tpd_BCIN_BCOUT((323 - 6)- 18*6), true),
			13 => (BCIN_ipd(10)'last_event, tpd_BCIN_BCOUT((323 - 6)- 18*7), true),
			14 => (BCIN_ipd(9)'last_event, tpd_BCIN_BCOUT((323 - 6)- 18*8), true),
			15 => (BCIN_ipd(8)'last_event, tpd_BCIN_BCOUT((323 - 6)- 18*9), true),
			16 => (BCIN_ipd(7)'last_event, tpd_BCIN_BCOUT((323 - 6)- 18*10), true),
			17 => (BCIN_ipd(6)'last_event, tpd_BCIN_BCOUT((323 - 6)- 18*11), true),
			18 => (BCIN_ipd(5)'last_event, tpd_BCIN_BCOUT((323 - 6)- 18*12), true),
			19 => (BCIN_ipd(4)'last_event, tpd_BCIN_BCOUT((323 - 6)- 18*13), true),
			20 => (BCIN_ipd(3)'last_event, tpd_BCIN_BCOUT((323 - 6)- 18*14), true),
			21 => (BCIN_ipd(2)'last_event, tpd_BCIN_BCOUT((323 - 6)- 18*15), true),
			22 => (BCIN_ipd(1)'last_event, tpd_BCIN_BCOUT((323 - 6)- 18*16), true),
			23 => (BCIN_ipd(0)'last_event, tpd_BCIN_BCOUT((323 - 6)- 18*17), true),
			24 => (CLK_dly'last_event, tpd_CLK_BCOUT(11), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> BCOUT(10),
         GlitchData	=> BCOUT_GlitchData(10),
         OutSignalName	=> "BCOUT(10)",
         OutTemp	=> BCOUT_zd(10),
         Paths		=> (
			0 => (B_ipd(10)'last_event, tpd_B_BCOUT((323 - 7)- 18*7), true),
			1 => (B_ipd(9)'last_event, tpd_B_BCOUT((323 - 7)- 18*8), true),
			2 => (B_ipd(8)'last_event, tpd_B_BCOUT((323 - 7)- 18*9), true),
			3 => (B_ipd(7)'last_event, tpd_B_BCOUT((323 - 7)- 18*10), true),
			4 => (B_ipd(6)'last_event, tpd_B_BCOUT((323 - 7)- 18*11), true),
			5 => (B_ipd(5)'last_event, tpd_B_BCOUT((323 - 7)- 18*12), true),
			6 => (B_ipd(4)'last_event, tpd_B_BCOUT((323 - 7)- 18*13), true),
			7 => (B_ipd(3)'last_event, tpd_B_BCOUT((323 - 7)- 18*14), true),
			8 => (B_ipd(2)'last_event, tpd_B_BCOUT((323 - 7)- 18*15), true),
			9 => (B_ipd(1)'last_event, tpd_B_BCOUT((323 - 7)- 18*16), true),
			10 => (B_ipd(0)'last_event, tpd_B_BCOUT((323 - 7)- 18*17), true),
			11 => (BCIN_ipd(10)'last_event, tpd_BCIN_BCOUT((323 - 7)- 18*7), true),
			12 => (BCIN_ipd(9)'last_event, tpd_BCIN_BCOUT((323 - 7)- 18*8), true),
			13 => (BCIN_ipd(8)'last_event, tpd_BCIN_BCOUT((323 - 7)- 18*9), true),
			14 => (BCIN_ipd(7)'last_event, tpd_BCIN_BCOUT((323 - 7)- 18*10), true),
			15 => (BCIN_ipd(6)'last_event, tpd_BCIN_BCOUT((323 - 7)- 18*11), true),
			16 => (BCIN_ipd(5)'last_event, tpd_BCIN_BCOUT((323 - 7)- 18*12), true),
			17 => (BCIN_ipd(4)'last_event, tpd_BCIN_BCOUT((323 - 7)- 18*13), true),
			18 => (BCIN_ipd(3)'last_event, tpd_BCIN_BCOUT((323 - 7)- 18*14), true),
			19 => (BCIN_ipd(2)'last_event, tpd_BCIN_BCOUT((323 - 7)- 18*15), true),
			20 => (BCIN_ipd(1)'last_event, tpd_BCIN_BCOUT((323 - 7)- 18*16), true),
			21 => (BCIN_ipd(0)'last_event, tpd_BCIN_BCOUT((323 - 7)- 18*17), true),
			22 => (CLK_dly'last_event, tpd_CLK_BCOUT(10), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> BCOUT(9),
         GlitchData	=> BCOUT_GlitchData(9),
         OutSignalName	=> "BCOUT(9)",
         OutTemp	=> BCOUT_zd(9),
         Paths		=> (
			0 => (B_ipd(9)'last_event, tpd_B_BCOUT((323 - 8)- 18*8), true),
			1 => (B_ipd(8)'last_event, tpd_B_BCOUT((323 - 8)- 18*9), true),
			2 => (B_ipd(7)'last_event, tpd_B_BCOUT((323 - 8)- 18*10), true),
			3 => (B_ipd(6)'last_event, tpd_B_BCOUT((323 - 8)- 18*11), true),
			4 => (B_ipd(5)'last_event, tpd_B_BCOUT((323 - 8)- 18*12), true),
			5 => (B_ipd(4)'last_event, tpd_B_BCOUT((323 - 8)- 18*13), true),
			6 => (B_ipd(3)'last_event, tpd_B_BCOUT((323 - 8)- 18*14), true),
			7 => (B_ipd(2)'last_event, tpd_B_BCOUT((323 - 8)- 18*15), true),
			8 => (B_ipd(1)'last_event, tpd_B_BCOUT((323 - 8)- 18*16), true),
			9 => (B_ipd(0)'last_event, tpd_B_BCOUT((323 - 8)- 18*17), true),
			10 => (BCIN_ipd(9)'last_event, tpd_BCIN_BCOUT((323 - 8)- 18*8), true),
			11 => (BCIN_ipd(8)'last_event, tpd_BCIN_BCOUT((323 - 8)- 18*9), true),
			12 => (BCIN_ipd(7)'last_event, tpd_BCIN_BCOUT((323 - 8)- 18*10), true),
			13 => (BCIN_ipd(6)'last_event, tpd_BCIN_BCOUT((323 - 8)- 18*11), true),
			14 => (BCIN_ipd(5)'last_event, tpd_BCIN_BCOUT((323 - 8)- 18*12), true),
			15 => (BCIN_ipd(4)'last_event, tpd_BCIN_BCOUT((323 - 8)- 18*13), true),
			16 => (BCIN_ipd(3)'last_event, tpd_BCIN_BCOUT((323 - 8)- 18*14), true),
			17 => (BCIN_ipd(2)'last_event, tpd_BCIN_BCOUT((323 - 8)- 18*15), true),
			18 => (BCIN_ipd(1)'last_event, tpd_BCIN_BCOUT((323 - 8)- 18*16), true),
			19 => (BCIN_ipd(0)'last_event, tpd_BCIN_BCOUT((323 - 8)- 18*17), true),
			20 => (CLK_dly'last_event, tpd_CLK_BCOUT(9), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> BCOUT(8),
         GlitchData	=> BCOUT_GlitchData(8),
         OutSignalName	=> "BCOUT(8)",
         OutTemp	=> BCOUT_zd(8),
         Paths		=> (
			0 => (B_ipd(8)'last_event, tpd_B_BCOUT((323 - 9)- 18*9), true),
			1 => (B_ipd(7)'last_event, tpd_B_BCOUT((323 - 9)- 18*10), true),
			2 => (B_ipd(6)'last_event, tpd_B_BCOUT((323 - 9)- 18*11), true),
			3 => (B_ipd(5)'last_event, tpd_B_BCOUT((323 - 9)- 18*12), true),
			4 => (B_ipd(4)'last_event, tpd_B_BCOUT((323 - 9)- 18*13), true),
			5 => (B_ipd(3)'last_event, tpd_B_BCOUT((323 - 9)- 18*14), true),
			6 => (B_ipd(2)'last_event, tpd_B_BCOUT((323 - 9)- 18*15), true),
			7 => (B_ipd(1)'last_event, tpd_B_BCOUT((323 - 9)- 18*16), true),
			8 => (B_ipd(0)'last_event, tpd_B_BCOUT((323 - 9)- 18*17), true),
			9 => (BCIN_ipd(8)'last_event, tpd_BCIN_BCOUT((323 - 9)- 18*9), true),
			10 => (BCIN_ipd(7)'last_event, tpd_BCIN_BCOUT((323 - 9)- 18*10), true),
			11 => (BCIN_ipd(6)'last_event, tpd_BCIN_BCOUT((323 - 9)- 18*11), true),
			12 => (BCIN_ipd(5)'last_event, tpd_BCIN_BCOUT((323 - 9)- 18*12), true),
			13 => (BCIN_ipd(4)'last_event, tpd_BCIN_BCOUT((323 - 9)- 18*13), true),
			14 => (BCIN_ipd(3)'last_event, tpd_BCIN_BCOUT((323 - 9)- 18*14), true),
			15 => (BCIN_ipd(2)'last_event, tpd_BCIN_BCOUT((323 - 9)- 18*15), true),
			16 => (BCIN_ipd(1)'last_event, tpd_BCIN_BCOUT((323 - 9)- 18*16), true),
			17 => (BCIN_ipd(0)'last_event, tpd_BCIN_BCOUT((323 - 9)- 18*17), true),
			18 => (CLK_dly'last_event, tpd_CLK_BCOUT(8), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> BCOUT(7),
         GlitchData	=> BCOUT_GlitchData(7),
         OutSignalName	=> "BCOUT(7)",
         OutTemp	=> BCOUT_zd(7),
         Paths		=> (
			0 => (B_ipd(7)'last_event, tpd_B_BCOUT((323 - 10)- 18*10), true),
			1 => (B_ipd(6)'last_event, tpd_B_BCOUT((323 - 10)- 18*11), true),
			2 => (B_ipd(5)'last_event, tpd_B_BCOUT((323 - 10)- 18*12), true),
			3 => (B_ipd(4)'last_event, tpd_B_BCOUT((323 - 10)- 18*13), true),
			4 => (B_ipd(3)'last_event, tpd_B_BCOUT((323 - 10)- 18*14), true),
			5 => (B_ipd(2)'last_event, tpd_B_BCOUT((323 - 10)- 18*15), true),
			6 => (B_ipd(1)'last_event, tpd_B_BCOUT((323 - 10)- 18*16), true),
			7 => (B_ipd(0)'last_event, tpd_B_BCOUT((323 - 10)- 18*17), true),
			8 => (BCIN_ipd(7)'last_event, tpd_BCIN_BCOUT((323 - 10)- 18*10), true),
			9 => (BCIN_ipd(6)'last_event, tpd_BCIN_BCOUT((323 - 10)- 18*11), true),
			10 => (BCIN_ipd(5)'last_event, tpd_BCIN_BCOUT((323 - 10)- 18*12), true),
			11 => (BCIN_ipd(4)'last_event, tpd_BCIN_BCOUT((323 - 10)- 18*13), true),
			12 => (BCIN_ipd(3)'last_event, tpd_BCIN_BCOUT((323 - 10)- 18*14), true),
			13 => (BCIN_ipd(2)'last_event, tpd_BCIN_BCOUT((323 - 10)- 18*15), true),
			14 => (BCIN_ipd(1)'last_event, tpd_BCIN_BCOUT((323 - 10)- 18*16), true),
			15 => (BCIN_ipd(0)'last_event, tpd_BCIN_BCOUT((323 - 10)- 18*17), true),
			16 => (CLK_dly'last_event, tpd_CLK_BCOUT(7), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> BCOUT(6),
         GlitchData	=> BCOUT_GlitchData(6),
         OutSignalName	=> "BCOUT(6)",
         OutTemp	=> BCOUT_zd(6),
         Paths		=> (
			0 => (B_ipd(6)'last_event, tpd_B_BCOUT((323 - 11)- 18*11), true),
			1 => (B_ipd(5)'last_event, tpd_B_BCOUT((323 - 11)- 18*12), true),
			2 => (B_ipd(4)'last_event, tpd_B_BCOUT((323 - 11)- 18*13), true),
			3 => (B_ipd(3)'last_event, tpd_B_BCOUT((323 - 11)- 18*14), true),
			4 => (B_ipd(2)'last_event, tpd_B_BCOUT((323 - 11)- 18*15), true),
			5 => (B_ipd(1)'last_event, tpd_B_BCOUT((323 - 11)- 18*16), true),
			6 => (B_ipd(0)'last_event, tpd_B_BCOUT((323 - 11)- 18*17), true),
			7 => (BCIN_ipd(6)'last_event, tpd_BCIN_BCOUT((323 - 11)- 18*11), true),
			8 => (BCIN_ipd(5)'last_event, tpd_BCIN_BCOUT((323 - 11)- 18*12), true),
			9 => (BCIN_ipd(4)'last_event, tpd_BCIN_BCOUT((323 - 11)- 18*13), true),
			10 => (BCIN_ipd(3)'last_event, tpd_BCIN_BCOUT((323 - 11)- 18*14), true),
			11 => (BCIN_ipd(2)'last_event, tpd_BCIN_BCOUT((323 - 11)- 18*15), true),
			12 => (BCIN_ipd(1)'last_event, tpd_BCIN_BCOUT((323 - 11)- 18*16), true),
			13 => (BCIN_ipd(0)'last_event, tpd_BCIN_BCOUT((323 - 11)- 18*17), true),
			14 => (CLK_dly'last_event, tpd_CLK_BCOUT(6), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> BCOUT(5),
         GlitchData	=> BCOUT_GlitchData(5),
         OutSignalName	=> "BCOUT(5)",
         OutTemp	=> BCOUT_zd(5),
         Paths		=> (
			0 => (B_ipd(5)'last_event, tpd_B_BCOUT((323 - 12)- 18*12), true),
			1 => (B_ipd(4)'last_event, tpd_B_BCOUT((323 - 12)- 18*13), true),
			2 => (B_ipd(3)'last_event, tpd_B_BCOUT((323 - 12)- 18*14), true),
			3 => (B_ipd(2)'last_event, tpd_B_BCOUT((323 - 12)- 18*15), true),
			4 => (B_ipd(1)'last_event, tpd_B_BCOUT((323 - 12)- 18*16), true),
			5 => (B_ipd(0)'last_event, tpd_B_BCOUT((323 - 12)- 18*17), true),
			6 => (BCIN_ipd(5)'last_event, tpd_BCIN_BCOUT((323 - 12)- 18*12), true),
			7 => (BCIN_ipd(4)'last_event, tpd_BCIN_BCOUT((323 - 12)- 18*13), true),
			8 => (BCIN_ipd(3)'last_event, tpd_BCIN_BCOUT((323 - 12)- 18*14), true),
			9 => (BCIN_ipd(2)'last_event, tpd_BCIN_BCOUT((323 - 12)- 18*15), true),
			10 => (BCIN_ipd(1)'last_event, tpd_BCIN_BCOUT((323 - 12)- 18*16), true),
			11 => (BCIN_ipd(0)'last_event, tpd_BCIN_BCOUT((323 - 12)- 18*17), true),
			12 => (CLK_dly'last_event, tpd_CLK_BCOUT(5), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> BCOUT(4),
         GlitchData	=> BCOUT_GlitchData(4),
         OutSignalName	=> "BCOUT(4)",
         OutTemp	=> BCOUT_zd(4),
         Paths		=> (
			0 => (B_ipd(4)'last_event, tpd_B_BCOUT((323 - 13)- 18*13), true),
			1 => (B_ipd(3)'last_event, tpd_B_BCOUT((323 - 13)- 18*14), true),
			2 => (B_ipd(2)'last_event, tpd_B_BCOUT((323 - 13)- 18*15), true),
			3 => (B_ipd(1)'last_event, tpd_B_BCOUT((323 - 13)- 18*16), true),
			4 => (B_ipd(0)'last_event, tpd_B_BCOUT((323 - 13)- 18*17), true),
			5 => (BCIN_ipd(4)'last_event, tpd_BCIN_BCOUT((323 - 13)- 18*13), true),
			6 => (BCIN_ipd(3)'last_event, tpd_BCIN_BCOUT((323 - 13)- 18*14), true),
			7 => (BCIN_ipd(2)'last_event, tpd_BCIN_BCOUT((323 - 13)- 18*15), true),
			8 => (BCIN_ipd(1)'last_event, tpd_BCIN_BCOUT((323 - 13)- 18*16), true),
			9 => (BCIN_ipd(0)'last_event, tpd_BCIN_BCOUT((323 - 13)- 18*17), true),
			10 => (CLK_dly'last_event, tpd_CLK_BCOUT(4), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> BCOUT(3),
         GlitchData	=> BCOUT_GlitchData(3),
         OutSignalName	=> "BCOUT(3)",
         OutTemp	=> BCOUT_zd(3),
         Paths		=> (
			0 => (B_ipd(3)'last_event, tpd_B_BCOUT((323 - 14)- 18*14), true),
			1 => (B_ipd(2)'last_event, tpd_B_BCOUT((323 - 14)- 18*15), true),
			2 => (B_ipd(1)'last_event, tpd_B_BCOUT((323 - 14)- 18*16), true),
			3 => (B_ipd(0)'last_event, tpd_B_BCOUT((323 - 14)- 18*17), true),
			4 => (BCIN_ipd(3)'last_event, tpd_BCIN_BCOUT((323 - 14)- 18*14), true),
			5 => (BCIN_ipd(2)'last_event, tpd_BCIN_BCOUT((323 - 14)- 18*15), true),
			6 => (BCIN_ipd(1)'last_event, tpd_BCIN_BCOUT((323 - 14)- 18*16), true),
			7 => (BCIN_ipd(0)'last_event, tpd_BCIN_BCOUT((323 - 14)- 18*17), true),
			8 => (CLK_dly'last_event, tpd_CLK_BCOUT(3), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> BCOUT(2),
         GlitchData	=> BCOUT_GlitchData(2),
         OutSignalName	=> "BCOUT(2)",
         OutTemp	=> BCOUT_zd(2),
         Paths		=> (
			0 => (B_ipd(2)'last_event, tpd_B_BCOUT((323 - 15)- 18*15), true),
			1 => (B_ipd(1)'last_event, tpd_B_BCOUT((323 - 15)- 18*16), true),
			2 => (B_ipd(0)'last_event, tpd_B_BCOUT((323 - 15)- 18*17), true),
			3 => (BCIN_ipd(2)'last_event, tpd_BCIN_BCOUT((323 - 15)- 18*15), true),
			4 => (BCIN_ipd(1)'last_event, tpd_BCIN_BCOUT((323 - 15)- 18*16), true),
			5 => (BCIN_ipd(0)'last_event, tpd_BCIN_BCOUT((323 - 15)- 18*17), true),
			6 => (CLK_dly'last_event, tpd_CLK_BCOUT(2), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> BCOUT(1),
         GlitchData	=> BCOUT_GlitchData(1),
         OutSignalName	=> "BCOUT(1)",
         OutTemp	=> BCOUT_zd(1),
         Paths		=> (
			0 => (B_ipd(1)'last_event, tpd_B_BCOUT((323 - 16)- 18*16), true),
			1 => (B_ipd(0)'last_event, tpd_B_BCOUT((323 - 16)- 18*17), true),
			2 => (BCIN_ipd(1)'last_event, tpd_BCIN_BCOUT((323 - 16)- 18*16), true),
			3 => (BCIN_ipd(0)'last_event, tpd_BCIN_BCOUT((323 - 16)- 18*17), true),
			4 => (CLK_dly'last_event, tpd_CLK_BCOUT(1), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> BCOUT(0),
         GlitchData	=> BCOUT_GlitchData(0),
         OutSignalName	=> "BCOUT(0)",
         OutTemp	=> BCOUT_zd(0),
         Paths		=> (
			0 => (B_ipd(0)'last_event, tpd_B_BCOUT((323 - 17)- 18*17), true),
			1 => (BCIN_ipd(0)'last_event, tpd_BCIN_BCOUT((323 - 17)- 18*17), true),
			2 => (CLK_dly'last_event, tpd_CLK_BCOUT(0), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> CARRYCASCOUT,
         GlitchData	=> CARRYCASCOUT_GlitchData,
         OutSignalName	=> "CARRYCASCOUT",
         OutTemp	=> CARRYCASCOUT_zd,
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_CARRYCASCOUT((29 - 0)- 1*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_CARRYCASCOUT((29 - 0)- 1*0), true),
			2 => (A_ipd(2)'last_event, tpd_A_CARRYCASCOUT((29 - 0)- 1*0), true),
			3 => (A_ipd(3)'last_event, tpd_A_CARRYCASCOUT((29 - 0)- 1*0), true),
			4 => (A_ipd(4)'last_event, tpd_A_CARRYCASCOUT((29 - 0)- 1*0), true),
			5 => (A_ipd(5)'last_event, tpd_A_CARRYCASCOUT((29 - 0)- 1*0), true),
			6 => (A_ipd(6)'last_event, tpd_A_CARRYCASCOUT((29 - 0)- 1*0), true),
			7 => (A_ipd(7)'last_event, tpd_A_CARRYCASCOUT((29 - 0)- 1*0), true),
			8 => (A_ipd(8)'last_event, tpd_A_CARRYCASCOUT((29 - 0)- 1*0), true),
			9 => (A_ipd(9)'last_event, tpd_A_CARRYCASCOUT((29 - 0)- 1*0), true),
			10 => (A_ipd(10)'last_event, tpd_A_CARRYCASCOUT((29 - 0)- 1*0), true),
			11 => (A_ipd(11)'last_event, tpd_A_CARRYCASCOUT((29 - 0)- 1*0), true),
			12 => (A_ipd(12)'last_event, tpd_A_CARRYCASCOUT((29 - 0)- 1*0), true),
			13 => (A_ipd(13)'last_event, tpd_A_CARRYCASCOUT((29 - 0)- 1*0), true),
			14 => (A_ipd(14)'last_event, tpd_A_CARRYCASCOUT((29 - 0)- 1*0), true),
			15 => (A_ipd(15)'last_event, tpd_A_CARRYCASCOUT((29 - 0)- 1*0), true),
			16 => (A_ipd(16)'last_event, tpd_A_CARRYCASCOUT((29 - 0)- 1*0), true),
			17 => (A_ipd(17)'last_event, tpd_A_CARRYCASCOUT((29 - 0)- 1*0), true),
			18 => (A_ipd(18)'last_event, tpd_A_CARRYCASCOUT((29 - 0)- 1*0), true),
			19 => (A_ipd(19)'last_event, tpd_A_CARRYCASCOUT((29 - 0)- 1*0), true),
			20 => (A_ipd(20)'last_event, tpd_A_CARRYCASCOUT((29 - 0)- 1*0), true),
			21 => (A_ipd(21)'last_event, tpd_A_CARRYCASCOUT((29 - 0)- 1*0), true),
			22 => (A_ipd(22)'last_event, tpd_A_CARRYCASCOUT((29 - 0)- 1*0), true),
			23 => (A_ipd(23)'last_event, tpd_A_CARRYCASCOUT((29 - 0)- 1*0), true),
			24 => (A_ipd(24)'last_event, tpd_A_CARRYCASCOUT((29 - 0)- 1*0), true),
			25 => (A_ipd(25)'last_event, tpd_A_CARRYCASCOUT((29 - 0)- 1*0), true),
			26 => (A_ipd(26)'last_event, tpd_A_CARRYCASCOUT((29 - 0)- 1*0), true),
			27 => (A_ipd(27)'last_event, tpd_A_CARRYCASCOUT((29 - 0)- 1*0), true),
			28 => (A_ipd(28)'last_event, tpd_A_CARRYCASCOUT((29 - 0)- 1*0), true),
			29 => (A_ipd(29)'last_event, tpd_A_CARRYCASCOUT((29 - 0)- 1*0), true),
			30 => (ACIN_ipd(0)'last_event, tpd_ACIN_CARRYCASCOUT((29 - 0)- 1*0), true),
			31 => (ACIN_ipd(1)'last_event, tpd_ACIN_CARRYCASCOUT((29 - 0)- 1*0), true),
			32 => (ACIN_ipd(2)'last_event, tpd_ACIN_CARRYCASCOUT((29 - 0)- 1*0), true),
			33 => (ACIN_ipd(3)'last_event, tpd_ACIN_CARRYCASCOUT((29 - 0)- 1*0), true),
			34 => (ACIN_ipd(4)'last_event, tpd_ACIN_CARRYCASCOUT((29 - 0)- 1*0), true),
			35 => (ACIN_ipd(5)'last_event, tpd_ACIN_CARRYCASCOUT((29 - 0)- 1*0), true),
			36 => (ACIN_ipd(6)'last_event, tpd_ACIN_CARRYCASCOUT((29 - 0)- 1*0), true),
			37 => (ACIN_ipd(7)'last_event, tpd_ACIN_CARRYCASCOUT((29 - 0)- 1*0), true),
			38 => (ACIN_ipd(8)'last_event, tpd_ACIN_CARRYCASCOUT((29 - 0)- 1*0), true),
			39 => (ACIN_ipd(9)'last_event, tpd_ACIN_CARRYCASCOUT((29 - 0)- 1*0), true),
			40 => (ACIN_ipd(10)'last_event, tpd_ACIN_CARRYCASCOUT((29 - 0)- 1*0), true),
			41 => (ACIN_ipd(11)'last_event, tpd_ACIN_CARRYCASCOUT((29 - 0)- 1*0), true),
			42 => (ACIN_ipd(12)'last_event, tpd_ACIN_CARRYCASCOUT((29 - 0)- 1*0), true),
			43 => (ACIN_ipd(13)'last_event, tpd_ACIN_CARRYCASCOUT((29 - 0)- 1*0), true),
			44 => (ACIN_ipd(14)'last_event, tpd_ACIN_CARRYCASCOUT((29 - 0)- 1*0), true),
			45 => (ACIN_ipd(15)'last_event, tpd_ACIN_CARRYCASCOUT((29 - 0)- 1*0), true),
			46 => (ACIN_ipd(16)'last_event, tpd_ACIN_CARRYCASCOUT((29 - 0)- 1*0), true),
			47 => (ACIN_ipd(17)'last_event, tpd_ACIN_CARRYCASCOUT((29 - 0)- 1*0), true),
			48 => (ACIN_ipd(18)'last_event, tpd_ACIN_CARRYCASCOUT((29 - 0)- 1*0), true),
			49 => (ACIN_ipd(19)'last_event, tpd_ACIN_CARRYCASCOUT((29 - 0)- 1*0), true),
			50 => (ACIN_ipd(20)'last_event, tpd_ACIN_CARRYCASCOUT((29 - 0)- 1*0), true),
			51 => (ACIN_ipd(21)'last_event, tpd_ACIN_CARRYCASCOUT((29 - 0)- 1*0), true),
			52 => (ACIN_ipd(22)'last_event, tpd_ACIN_CARRYCASCOUT((29 - 0)- 1*0), true),
			53 => (ACIN_ipd(23)'last_event, tpd_ACIN_CARRYCASCOUT((29 - 0)- 1*0), true),
			54 => (ACIN_ipd(24)'last_event, tpd_ACIN_CARRYCASCOUT((29 - 0)- 1*0), true),
			55 => (ACIN_ipd(25)'last_event, tpd_ACIN_CARRYCASCOUT((29 - 0)- 1*0), true),
			56 => (ACIN_ipd(26)'last_event, tpd_ACIN_CARRYCASCOUT((29 - 0)- 1*0), true),
			57 => (ACIN_ipd(27)'last_event, tpd_ACIN_CARRYCASCOUT((29 - 0)- 1*0), true),
			58 => (ACIN_ipd(28)'last_event, tpd_ACIN_CARRYCASCOUT((29 - 0)- 1*0), true),
			59 => (ACIN_ipd(29)'last_event, tpd_ACIN_CARRYCASCOUT((29 - 0)- 1*0), true),
			60 => (ALUMODE_ipd(0)'last_event, tpd_ALUMODE_CARRYCASCOUT((3 - 0)- 1*0), true),
			61 => (ALUMODE_ipd(1)'last_event, tpd_ALUMODE_CARRYCASCOUT((3 - 0)- 1*0), true),
			62 => (ALUMODE_ipd(2)'last_event, tpd_ALUMODE_CARRYCASCOUT((3 - 0)- 1*0), true),
			63 => (ALUMODE_ipd(3)'last_event, tpd_ALUMODE_CARRYCASCOUT((3 - 0)- 1*0), true),
			64 => (B_ipd(0)'last_event, tpd_B_CARRYCASCOUT((17 - 0)- 1*0), true),
			65 => (B_ipd(1)'last_event, tpd_B_CARRYCASCOUT((17 - 0)- 1*0), true),
			66 => (B_ipd(2)'last_event, tpd_B_CARRYCASCOUT((17 - 0)- 1*0), true),
			67 => (B_ipd(3)'last_event, tpd_B_CARRYCASCOUT((17 - 0)- 1*0), true),
			68 => (B_ipd(4)'last_event, tpd_B_CARRYCASCOUT((17 - 0)- 1*0), true),
			69 => (B_ipd(5)'last_event, tpd_B_CARRYCASCOUT((17 - 0)- 1*0), true),
			70 => (B_ipd(6)'last_event, tpd_B_CARRYCASCOUT((17 - 0)- 1*0), true),
			71 => (B_ipd(7)'last_event, tpd_B_CARRYCASCOUT((17 - 0)- 1*0), true),
			72 => (B_ipd(8)'last_event, tpd_B_CARRYCASCOUT((17 - 0)- 1*0), true),
			73 => (B_ipd(9)'last_event, tpd_B_CARRYCASCOUT((17 - 0)- 1*0), true),
			74 => (B_ipd(10)'last_event, tpd_B_CARRYCASCOUT((17 - 0)- 1*0), true),
			75 => (B_ipd(11)'last_event, tpd_B_CARRYCASCOUT((17 - 0)- 1*0), true),
			76 => (B_ipd(12)'last_event, tpd_B_CARRYCASCOUT((17 - 0)- 1*0), true),
			77 => (B_ipd(13)'last_event, tpd_B_CARRYCASCOUT((17 - 0)- 1*0), true),
			78 => (B_ipd(14)'last_event, tpd_B_CARRYCASCOUT((17 - 0)- 1*0), true),
			79 => (B_ipd(15)'last_event, tpd_B_CARRYCASCOUT((17 - 0)- 1*0), true),
			80 => (B_ipd(16)'last_event, tpd_B_CARRYCASCOUT((17 - 0)- 1*0), true),
			81 => (B_ipd(17)'last_event, tpd_B_CARRYCASCOUT((17 - 0)- 1*0), true),
			82 => (BCIN_ipd(0)'last_event, tpd_BCIN_CARRYCASCOUT((17 - 0)- 1*0), true),
			83 => (BCIN_ipd(1)'last_event, tpd_BCIN_CARRYCASCOUT((17 - 0)- 1*0), true),
			84 => (BCIN_ipd(2)'last_event, tpd_BCIN_CARRYCASCOUT((17 - 0)- 1*0), true),
			85 => (BCIN_ipd(3)'last_event, tpd_BCIN_CARRYCASCOUT((17 - 0)- 1*0), true),
			86 => (BCIN_ipd(4)'last_event, tpd_BCIN_CARRYCASCOUT((17 - 0)- 1*0), true),
			87 => (BCIN_ipd(5)'last_event, tpd_BCIN_CARRYCASCOUT((17 - 0)- 1*0), true),
			88 => (BCIN_ipd(6)'last_event, tpd_BCIN_CARRYCASCOUT((17 - 0)- 1*0), true),
			89 => (BCIN_ipd(7)'last_event, tpd_BCIN_CARRYCASCOUT((17 - 0)- 1*0), true),
			90 => (BCIN_ipd(8)'last_event, tpd_BCIN_CARRYCASCOUT((17 - 0)- 1*0), true),
			91 => (BCIN_ipd(9)'last_event, tpd_BCIN_CARRYCASCOUT((17 - 0)- 1*0), true),
			92 => (BCIN_ipd(10)'last_event, tpd_BCIN_CARRYCASCOUT((17 - 0)- 1*0), true),
			93 => (BCIN_ipd(11)'last_event, tpd_BCIN_CARRYCASCOUT((17 - 0)- 1*0), true),
			94 => (BCIN_ipd(12)'last_event, tpd_BCIN_CARRYCASCOUT((17 - 0)- 1*0), true),
			95 => (BCIN_ipd(13)'last_event, tpd_BCIN_CARRYCASCOUT((17 - 0)- 1*0), true),
			96 => (BCIN_ipd(14)'last_event, tpd_BCIN_CARRYCASCOUT((17 - 0)- 1*0), true),
			97 => (BCIN_ipd(15)'last_event, tpd_BCIN_CARRYCASCOUT((17 - 0)- 1*0), true),
			98 => (BCIN_ipd(16)'last_event, tpd_BCIN_CARRYCASCOUT((17 - 0)- 1*0), true),
			99 => (BCIN_ipd(17)'last_event, tpd_BCIN_CARRYCASCOUT((17 - 0)- 1*0), true),
			100 => (C_ipd(0)'last_event, tpd_C_CARRYCASCOUT((47 - 0)- 1*0), true),
			101 => (C_ipd(1)'last_event, tpd_C_CARRYCASCOUT((47 - 0)- 1*0), true),
			102 => (C_ipd(2)'last_event, tpd_C_CARRYCASCOUT((47 - 0)- 1*0), true),
			103 => (C_ipd(3)'last_event, tpd_C_CARRYCASCOUT((47 - 0)- 1*0), true),
			104 => (C_ipd(4)'last_event, tpd_C_CARRYCASCOUT((47 - 0)- 1*0), true),
			105 => (C_ipd(5)'last_event, tpd_C_CARRYCASCOUT((47 - 0)- 1*0), true),
			106 => (C_ipd(6)'last_event, tpd_C_CARRYCASCOUT((47 - 0)- 1*0), true),
			107 => (C_ipd(7)'last_event, tpd_C_CARRYCASCOUT((47 - 0)- 1*0), true),
			108 => (C_ipd(8)'last_event, tpd_C_CARRYCASCOUT((47 - 0)- 1*0), true),
			109 => (C_ipd(9)'last_event, tpd_C_CARRYCASCOUT((47 - 0)- 1*0), true),
			110 => (C_ipd(10)'last_event, tpd_C_CARRYCASCOUT((47 - 0)- 1*0), true),
			111 => (C_ipd(11)'last_event, tpd_C_CARRYCASCOUT((47 - 0)- 1*0), true),
			112 => (C_ipd(12)'last_event, tpd_C_CARRYCASCOUT((47 - 0)- 1*0), true),
			113 => (C_ipd(13)'last_event, tpd_C_CARRYCASCOUT((47 - 0)- 1*0), true),
			114 => (C_ipd(14)'last_event, tpd_C_CARRYCASCOUT((47 - 0)- 1*0), true),
			115 => (C_ipd(15)'last_event, tpd_C_CARRYCASCOUT((47 - 0)- 1*0), true),
			116 => (C_ipd(16)'last_event, tpd_C_CARRYCASCOUT((47 - 0)- 1*0), true),
			117 => (C_ipd(17)'last_event, tpd_C_CARRYCASCOUT((47 - 0)- 1*0), true),
			118 => (C_ipd(18)'last_event, tpd_C_CARRYCASCOUT((47 - 0)- 1*0), true),
			119 => (C_ipd(19)'last_event, tpd_C_CARRYCASCOUT((47 - 0)- 1*0), true),
			120 => (C_ipd(20)'last_event, tpd_C_CARRYCASCOUT((47 - 0)- 1*0), true),
			121 => (C_ipd(21)'last_event, tpd_C_CARRYCASCOUT((47 - 0)- 1*0), true),
			122 => (C_ipd(22)'last_event, tpd_C_CARRYCASCOUT((47 - 0)- 1*0), true),
			123 => (C_ipd(23)'last_event, tpd_C_CARRYCASCOUT((47 - 0)- 1*0), true),
			124 => (C_ipd(24)'last_event, tpd_C_CARRYCASCOUT((47 - 0)- 1*0), true),
			125 => (C_ipd(25)'last_event, tpd_C_CARRYCASCOUT((47 - 0)- 1*0), true),
			126 => (C_ipd(26)'last_event, tpd_C_CARRYCASCOUT((47 - 0)- 1*0), true),
			127 => (C_ipd(27)'last_event, tpd_C_CARRYCASCOUT((47 - 0)- 1*0), true),
			128 => (C_ipd(28)'last_event, tpd_C_CARRYCASCOUT((47 - 0)- 1*0), true),
			129 => (C_ipd(29)'last_event, tpd_C_CARRYCASCOUT((47 - 0)- 1*0), true),
			130 => (C_ipd(30)'last_event, tpd_C_CARRYCASCOUT((47 - 0)- 1*0), true),
			131 => (C_ipd(31)'last_event, tpd_C_CARRYCASCOUT((47 - 0)- 1*0), true),
			132 => (C_ipd(32)'last_event, tpd_C_CARRYCASCOUT((47 - 0)- 1*0), true),
			133 => (C_ipd(33)'last_event, tpd_C_CARRYCASCOUT((47 - 0)- 1*0), true),
			134 => (C_ipd(34)'last_event, tpd_C_CARRYCASCOUT((47 - 0)- 1*0), true),
			135 => (C_ipd(35)'last_event, tpd_C_CARRYCASCOUT((47 - 0)- 1*0), true),
			136 => (C_ipd(36)'last_event, tpd_C_CARRYCASCOUT((47 - 0)- 1*0), true),
			137 => (C_ipd(37)'last_event, tpd_C_CARRYCASCOUT((47 - 0)- 1*0), true),
			138 => (C_ipd(38)'last_event, tpd_C_CARRYCASCOUT((47 - 0)- 1*0), true),
			139 => (C_ipd(39)'last_event, tpd_C_CARRYCASCOUT((47 - 0)- 1*0), true),
			140 => (C_ipd(40)'last_event, tpd_C_CARRYCASCOUT((47 - 0)- 1*0), true),
			141 => (C_ipd(41)'last_event, tpd_C_CARRYCASCOUT((47 - 0)- 1*0), true),
			142 => (C_ipd(42)'last_event, tpd_C_CARRYCASCOUT((47 - 0)- 1*0), true),
			143 => (C_ipd(43)'last_event, tpd_C_CARRYCASCOUT((47 - 0)- 1*0), true),
			144 => (C_ipd(44)'last_event, tpd_C_CARRYCASCOUT((47 - 0)- 1*0), true),
			145 => (C_ipd(45)'last_event, tpd_C_CARRYCASCOUT((47 - 0)- 1*0), true),
			146 => (C_ipd(46)'last_event, tpd_C_CARRYCASCOUT((47 - 0)- 1*0), true),
			147 => (C_ipd(47)'last_event, tpd_C_CARRYCASCOUT((47 - 0)- 1*0), true),
			148 => (CARRYCASCIN_ipd'last_event, tpd_CARRYCASCIN_CARRYCASCOUT, true),
			149 => (CARRYIN_ipd'last_event, tpd_CARRYIN_CARRYCASCOUT, true),
			150 => (CARRYINSEL_ipd(0)'last_event, tpd_CARRYINSEL_CARRYCASCOUT((2 - 0)- 1*0), true),
			151 => (CARRYINSEL_ipd(1)'last_event, tpd_CARRYINSEL_CARRYCASCOUT((2 - 0)- 1*0), true),
			152 => (CARRYINSEL_ipd(2)'last_event, tpd_CARRYINSEL_CARRYCASCOUT((2 - 0)- 1*0), true),
			153 => (MULTSIGNIN_ipd'last_event, tpd_MULTSIGNIN_CARRYCASCOUT, true),
			154 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_CARRYCASCOUT((6 - 0)- 1*0), true),
			155 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_CARRYCASCOUT((6 - 0)- 1*0), true),
			156 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_CARRYCASCOUT((6 - 0)- 1*0), true),
			157 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_CARRYCASCOUT((6 - 0)- 1*0), true),
			158 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_CARRYCASCOUT((6 - 0)- 1*0), true),
			159 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_CARRYCASCOUT((6 - 0)- 1*0), true),
			160 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_CARRYCASCOUT((6 - 0)- 1*0), true),
			161 => (PCIN_ipd(0)'last_event, tpd_PCIN_CARRYCASCOUT((47 - 0)- 1*0), true),
			162 => (PCIN_ipd(1)'last_event, tpd_PCIN_CARRYCASCOUT((47 - 0)- 1*0), true),
			163 => (PCIN_ipd(2)'last_event, tpd_PCIN_CARRYCASCOUT((47 - 0)- 1*0), true),
			164 => (PCIN_ipd(3)'last_event, tpd_PCIN_CARRYCASCOUT((47 - 0)- 1*0), true),
			165 => (PCIN_ipd(4)'last_event, tpd_PCIN_CARRYCASCOUT((47 - 0)- 1*0), true),
			166 => (PCIN_ipd(5)'last_event, tpd_PCIN_CARRYCASCOUT((47 - 0)- 1*0), true),
			167 => (PCIN_ipd(6)'last_event, tpd_PCIN_CARRYCASCOUT((47 - 0)- 1*0), true),
			168 => (PCIN_ipd(7)'last_event, tpd_PCIN_CARRYCASCOUT((47 - 0)- 1*0), true),
			169 => (PCIN_ipd(8)'last_event, tpd_PCIN_CARRYCASCOUT((47 - 0)- 1*0), true),
			170 => (PCIN_ipd(9)'last_event, tpd_PCIN_CARRYCASCOUT((47 - 0)- 1*0), true),
			171 => (PCIN_ipd(10)'last_event, tpd_PCIN_CARRYCASCOUT((47 - 0)- 1*0), true),
			172 => (PCIN_ipd(11)'last_event, tpd_PCIN_CARRYCASCOUT((47 - 0)- 1*0), true),
			173 => (PCIN_ipd(12)'last_event, tpd_PCIN_CARRYCASCOUT((47 - 0)- 1*0), true),
			174 => (PCIN_ipd(13)'last_event, tpd_PCIN_CARRYCASCOUT((47 - 0)- 1*0), true),
			175 => (PCIN_ipd(14)'last_event, tpd_PCIN_CARRYCASCOUT((47 - 0)- 1*0), true),
			176 => (PCIN_ipd(15)'last_event, tpd_PCIN_CARRYCASCOUT((47 - 0)- 1*0), true),
			177 => (PCIN_ipd(16)'last_event, tpd_PCIN_CARRYCASCOUT((47 - 0)- 1*0), true),
			178 => (PCIN_ipd(17)'last_event, tpd_PCIN_CARRYCASCOUT((47 - 0)- 1*0), true),
			179 => (PCIN_ipd(18)'last_event, tpd_PCIN_CARRYCASCOUT((47 - 0)- 1*0), true),
			180 => (PCIN_ipd(19)'last_event, tpd_PCIN_CARRYCASCOUT((47 - 0)- 1*0), true),
			181 => (PCIN_ipd(20)'last_event, tpd_PCIN_CARRYCASCOUT((47 - 0)- 1*0), true),
			182 => (PCIN_ipd(21)'last_event, tpd_PCIN_CARRYCASCOUT((47 - 0)- 1*0), true),
			183 => (PCIN_ipd(22)'last_event, tpd_PCIN_CARRYCASCOUT((47 - 0)- 1*0), true),
			184 => (PCIN_ipd(23)'last_event, tpd_PCIN_CARRYCASCOUT((47 - 0)- 1*0), true),
			185 => (PCIN_ipd(24)'last_event, tpd_PCIN_CARRYCASCOUT((47 - 0)- 1*0), true),
			186 => (PCIN_ipd(25)'last_event, tpd_PCIN_CARRYCASCOUT((47 - 0)- 1*0), true),
			187 => (PCIN_ipd(26)'last_event, tpd_PCIN_CARRYCASCOUT((47 - 0)- 1*0), true),
			188 => (PCIN_ipd(27)'last_event, tpd_PCIN_CARRYCASCOUT((47 - 0)- 1*0), true),
			189 => (PCIN_ipd(28)'last_event, tpd_PCIN_CARRYCASCOUT((47 - 0)- 1*0), true),
			190 => (PCIN_ipd(29)'last_event, tpd_PCIN_CARRYCASCOUT((47 - 0)- 1*0), true),
			191 => (PCIN_ipd(30)'last_event, tpd_PCIN_CARRYCASCOUT((47 - 0)- 1*0), true),
			192 => (PCIN_ipd(31)'last_event, tpd_PCIN_CARRYCASCOUT((47 - 0)- 1*0), true),
			193 => (PCIN_ipd(32)'last_event, tpd_PCIN_CARRYCASCOUT((47 - 0)- 1*0), true),
			194 => (PCIN_ipd(33)'last_event, tpd_PCIN_CARRYCASCOUT((47 - 0)- 1*0), true),
			195 => (PCIN_ipd(34)'last_event, tpd_PCIN_CARRYCASCOUT((47 - 0)- 1*0), true),
			196 => (PCIN_ipd(35)'last_event, tpd_PCIN_CARRYCASCOUT((47 - 0)- 1*0), true),
			197 => (PCIN_ipd(36)'last_event, tpd_PCIN_CARRYCASCOUT((47 - 0)- 1*0), true),
			198 => (PCIN_ipd(37)'last_event, tpd_PCIN_CARRYCASCOUT((47 - 0)- 1*0), true),
			199 => (PCIN_ipd(38)'last_event, tpd_PCIN_CARRYCASCOUT((47 - 0)- 1*0), true),
			200 => (PCIN_ipd(39)'last_event, tpd_PCIN_CARRYCASCOUT((47 - 0)- 1*0), true),
			201 => (PCIN_ipd(40)'last_event, tpd_PCIN_CARRYCASCOUT((47 - 0)- 1*0), true),
			202 => (PCIN_ipd(41)'last_event, tpd_PCIN_CARRYCASCOUT((47 - 0)- 1*0), true),
			203 => (PCIN_ipd(42)'last_event, tpd_PCIN_CARRYCASCOUT((47 - 0)- 1*0), true),
			204 => (PCIN_ipd(43)'last_event, tpd_PCIN_CARRYCASCOUT((47 - 0)- 1*0), true),
			205 => (PCIN_ipd(44)'last_event, tpd_PCIN_CARRYCASCOUT((47 - 0)- 1*0), true),
			206 => (PCIN_ipd(45)'last_event, tpd_PCIN_CARRYCASCOUT((47 - 0)- 1*0), true),
			207 => (PCIN_ipd(46)'last_event, tpd_PCIN_CARRYCASCOUT((47 - 0)- 1*0), true),
			208 => (PCIN_ipd(47)'last_event, tpd_PCIN_CARRYCASCOUT((47 - 0)- 1*0), true),
			209 => (CLK_dly'last_event, tpd_CLK_CARRYCASCOUT, true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> CARRYOUT(3),
         GlitchData	=> CARRYOUT_GlitchData(3),
         OutSignalName	=> "CARRYOUT(3)",
         OutTemp	=> CARRYOUT_zd(3),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_CARRYOUT((119 - 0)- 4*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_CARRYOUT((119 - 0)- 4*0), true),
			2 => (A_ipd(2)'last_event, tpd_A_CARRYOUT((119 - 0)- 4*0), true),
			3 => (A_ipd(3)'last_event, tpd_A_CARRYOUT((119 - 0)- 4*0), true),
			4 => (A_ipd(4)'last_event, tpd_A_CARRYOUT((119 - 0)- 4*0), true),
			5 => (A_ipd(5)'last_event, tpd_A_CARRYOUT((119 - 0)- 4*0), true),
			6 => (A_ipd(6)'last_event, tpd_A_CARRYOUT((119 - 0)- 4*0), true),
			7 => (A_ipd(7)'last_event, tpd_A_CARRYOUT((119 - 0)- 4*0), true),
			8 => (A_ipd(8)'last_event, tpd_A_CARRYOUT((119 - 0)- 4*0), true),
			9 => (A_ipd(9)'last_event, tpd_A_CARRYOUT((119 - 0)- 4*0), true),
			10 => (A_ipd(10)'last_event, tpd_A_CARRYOUT((119 - 0)- 4*0), true),
			11 => (A_ipd(11)'last_event, tpd_A_CARRYOUT((119 - 0)- 4*0), true),
			12 => (A_ipd(12)'last_event, tpd_A_CARRYOUT((119 - 0)- 4*0), true),
			13 => (A_ipd(13)'last_event, tpd_A_CARRYOUT((119 - 0)- 4*0), true),
			14 => (A_ipd(14)'last_event, tpd_A_CARRYOUT((119 - 0)- 4*0), true),
			15 => (A_ipd(15)'last_event, tpd_A_CARRYOUT((119 - 0)- 4*0), true),
			16 => (A_ipd(16)'last_event, tpd_A_CARRYOUT((119 - 0)- 4*0), true),
			17 => (A_ipd(17)'last_event, tpd_A_CARRYOUT((119 - 0)- 4*0), true),
			18 => (A_ipd(18)'last_event, tpd_A_CARRYOUT((119 - 0)- 4*0), true),
			19 => (A_ipd(19)'last_event, tpd_A_CARRYOUT((119 - 0)- 4*0), true),
			20 => (A_ipd(20)'last_event, tpd_A_CARRYOUT((119 - 0)- 4*0), true),
			21 => (A_ipd(21)'last_event, tpd_A_CARRYOUT((119 - 0)- 4*0), true),
			22 => (A_ipd(22)'last_event, tpd_A_CARRYOUT((119 - 0)- 4*0), true),
			23 => (A_ipd(23)'last_event, tpd_A_CARRYOUT((119 - 0)- 4*0), true),
			24 => (A_ipd(24)'last_event, tpd_A_CARRYOUT((119 - 0)- 4*0), true),
			25 => (A_ipd(25)'last_event, tpd_A_CARRYOUT((119 - 0)- 4*0), true),
			26 => (A_ipd(26)'last_event, tpd_A_CARRYOUT((119 - 0)- 4*0), true),
			27 => (A_ipd(27)'last_event, tpd_A_CARRYOUT((119 - 0)- 4*0), true),
			28 => (A_ipd(28)'last_event, tpd_A_CARRYOUT((119 - 0)- 4*0), true),
			29 => (A_ipd(29)'last_event, tpd_A_CARRYOUT((119 - 0)- 4*0), true),
			30 => (ACIN_ipd(0)'last_event, tpd_ACIN_CARRYOUT((119 - 0)- 4*0), true),
			31 => (ACIN_ipd(1)'last_event, tpd_ACIN_CARRYOUT((119 - 0)- 4*0), true),
			32 => (ACIN_ipd(2)'last_event, tpd_ACIN_CARRYOUT((119 - 0)- 4*0), true),
			33 => (ACIN_ipd(3)'last_event, tpd_ACIN_CARRYOUT((119 - 0)- 4*0), true),
			34 => (ACIN_ipd(4)'last_event, tpd_ACIN_CARRYOUT((119 - 0)- 4*0), true),
			35 => (ACIN_ipd(5)'last_event, tpd_ACIN_CARRYOUT((119 - 0)- 4*0), true),
			36 => (ACIN_ipd(6)'last_event, tpd_ACIN_CARRYOUT((119 - 0)- 4*0), true),
			37 => (ACIN_ipd(7)'last_event, tpd_ACIN_CARRYOUT((119 - 0)- 4*0), true),
			38 => (ACIN_ipd(8)'last_event, tpd_ACIN_CARRYOUT((119 - 0)- 4*0), true),
			39 => (ACIN_ipd(9)'last_event, tpd_ACIN_CARRYOUT((119 - 0)- 4*0), true),
			40 => (ACIN_ipd(10)'last_event, tpd_ACIN_CARRYOUT((119 - 0)- 4*0), true),
			41 => (ACIN_ipd(11)'last_event, tpd_ACIN_CARRYOUT((119 - 0)- 4*0), true),
			42 => (ACIN_ipd(12)'last_event, tpd_ACIN_CARRYOUT((119 - 0)- 4*0), true),
			43 => (ACIN_ipd(13)'last_event, tpd_ACIN_CARRYOUT((119 - 0)- 4*0), true),
			44 => (ACIN_ipd(14)'last_event, tpd_ACIN_CARRYOUT((119 - 0)- 4*0), true),
			45 => (ACIN_ipd(15)'last_event, tpd_ACIN_CARRYOUT((119 - 0)- 4*0), true),
			46 => (ACIN_ipd(16)'last_event, tpd_ACIN_CARRYOUT((119 - 0)- 4*0), true),
			47 => (ACIN_ipd(17)'last_event, tpd_ACIN_CARRYOUT((119 - 0)- 4*0), true),
			48 => (ACIN_ipd(18)'last_event, tpd_ACIN_CARRYOUT((119 - 0)- 4*0), true),
			49 => (ACIN_ipd(19)'last_event, tpd_ACIN_CARRYOUT((119 - 0)- 4*0), true),
			50 => (ACIN_ipd(20)'last_event, tpd_ACIN_CARRYOUT((119 - 0)- 4*0), true),
			51 => (ACIN_ipd(21)'last_event, tpd_ACIN_CARRYOUT((119 - 0)- 4*0), true),
			52 => (ACIN_ipd(22)'last_event, tpd_ACIN_CARRYOUT((119 - 0)- 4*0), true),
			53 => (ACIN_ipd(23)'last_event, tpd_ACIN_CARRYOUT((119 - 0)- 4*0), true),
			54 => (ACIN_ipd(24)'last_event, tpd_ACIN_CARRYOUT((119 - 0)- 4*0), true),
			55 => (ACIN_ipd(25)'last_event, tpd_ACIN_CARRYOUT((119 - 0)- 4*0), true),
			56 => (ACIN_ipd(26)'last_event, tpd_ACIN_CARRYOUT((119 - 0)- 4*0), true),
			57 => (ACIN_ipd(27)'last_event, tpd_ACIN_CARRYOUT((119 - 0)- 4*0), true),
			58 => (ACIN_ipd(28)'last_event, tpd_ACIN_CARRYOUT((119 - 0)- 4*0), true),
			59 => (ACIN_ipd(29)'last_event, tpd_ACIN_CARRYOUT((119 - 0)- 4*0), true),
			60 => (ALUMODE_ipd(0)'last_event, tpd_ALUMODE_CARRYOUT((15 - 0)- 4*0), true),
			61 => (ALUMODE_ipd(1)'last_event, tpd_ALUMODE_CARRYOUT((15 - 0)- 4*0), true),
			62 => (ALUMODE_ipd(2)'last_event, tpd_ALUMODE_CARRYOUT((15 - 0)- 4*0), true),
			63 => (ALUMODE_ipd(3)'last_event, tpd_ALUMODE_CARRYOUT((15 - 0)- 4*0), true),
			64 => (B_ipd(0)'last_event, tpd_B_CARRYOUT((71 - 0)- 4*0), true),
			65 => (B_ipd(1)'last_event, tpd_B_CARRYOUT((71 - 0)- 4*0), true),
			66 => (B_ipd(2)'last_event, tpd_B_CARRYOUT((71 - 0)- 4*0), true),
			67 => (B_ipd(3)'last_event, tpd_B_CARRYOUT((71 - 0)- 4*0), true),
			68 => (B_ipd(4)'last_event, tpd_B_CARRYOUT((71 - 0)- 4*0), true),
			69 => (B_ipd(5)'last_event, tpd_B_CARRYOUT((71 - 0)- 4*0), true),
			70 => (B_ipd(6)'last_event, tpd_B_CARRYOUT((71 - 0)- 4*0), true),
			71 => (B_ipd(7)'last_event, tpd_B_CARRYOUT((71 - 0)- 4*0), true),
			72 => (B_ipd(8)'last_event, tpd_B_CARRYOUT((71 - 0)- 4*0), true),
			73 => (B_ipd(9)'last_event, tpd_B_CARRYOUT((71 - 0)- 4*0), true),
			74 => (B_ipd(10)'last_event, tpd_B_CARRYOUT((71 - 0)- 4*0), true),
			75 => (B_ipd(11)'last_event, tpd_B_CARRYOUT((71 - 0)- 4*0), true),
			76 => (B_ipd(12)'last_event, tpd_B_CARRYOUT((71 - 0)- 4*0), true),
			77 => (B_ipd(13)'last_event, tpd_B_CARRYOUT((71 - 0)- 4*0), true),
			78 => (B_ipd(14)'last_event, tpd_B_CARRYOUT((71 - 0)- 4*0), true),
			79 => (B_ipd(15)'last_event, tpd_B_CARRYOUT((71 - 0)- 4*0), true),
			80 => (B_ipd(16)'last_event, tpd_B_CARRYOUT((71 - 0)- 4*0), true),
			81 => (B_ipd(17)'last_event, tpd_B_CARRYOUT((71 - 0)- 4*0), true),
			82 => (BCIN_ipd(0)'last_event, tpd_BCIN_CARRYOUT((71 - 0)- 4*0), true),
			83 => (BCIN_ipd(1)'last_event, tpd_BCIN_CARRYOUT((71 - 0)- 4*0), true),
			84 => (BCIN_ipd(2)'last_event, tpd_BCIN_CARRYOUT((71 - 0)- 4*0), true),
			85 => (BCIN_ipd(3)'last_event, tpd_BCIN_CARRYOUT((71 - 0)- 4*0), true),
			86 => (BCIN_ipd(4)'last_event, tpd_BCIN_CARRYOUT((71 - 0)- 4*0), true),
			87 => (BCIN_ipd(5)'last_event, tpd_BCIN_CARRYOUT((71 - 0)- 4*0), true),
			88 => (BCIN_ipd(6)'last_event, tpd_BCIN_CARRYOUT((71 - 0)- 4*0), true),
			89 => (BCIN_ipd(7)'last_event, tpd_BCIN_CARRYOUT((71 - 0)- 4*0), true),
			90 => (BCIN_ipd(8)'last_event, tpd_BCIN_CARRYOUT((71 - 0)- 4*0), true),
			91 => (BCIN_ipd(9)'last_event, tpd_BCIN_CARRYOUT((71 - 0)- 4*0), true),
			92 => (BCIN_ipd(10)'last_event, tpd_BCIN_CARRYOUT((71 - 0)- 4*0), true),
			93 => (BCIN_ipd(11)'last_event, tpd_BCIN_CARRYOUT((71 - 0)- 4*0), true),
			94 => (BCIN_ipd(12)'last_event, tpd_BCIN_CARRYOUT((71 - 0)- 4*0), true),
			95 => (BCIN_ipd(13)'last_event, tpd_BCIN_CARRYOUT((71 - 0)- 4*0), true),
			96 => (BCIN_ipd(14)'last_event, tpd_BCIN_CARRYOUT((71 - 0)- 4*0), true),
			97 => (BCIN_ipd(15)'last_event, tpd_BCIN_CARRYOUT((71 - 0)- 4*0), true),
			98 => (BCIN_ipd(16)'last_event, tpd_BCIN_CARRYOUT((71 - 0)- 4*0), true),
			99 => (BCIN_ipd(17)'last_event, tpd_BCIN_CARRYOUT((71 - 0)- 4*0), true),
			100 => (C_ipd(0)'last_event, tpd_C_CARRYOUT((191 - 0)- 4*0), true),
			101 => (C_ipd(1)'last_event, tpd_C_CARRYOUT((191 - 0)- 4*0), true),
			102 => (C_ipd(2)'last_event, tpd_C_CARRYOUT((191 - 0)- 4*0), true),
			103 => (C_ipd(3)'last_event, tpd_C_CARRYOUT((191 - 0)- 4*0), true),
			104 => (C_ipd(4)'last_event, tpd_C_CARRYOUT((191 - 0)- 4*0), true),
			105 => (C_ipd(5)'last_event, tpd_C_CARRYOUT((191 - 0)- 4*0), true),
			106 => (C_ipd(6)'last_event, tpd_C_CARRYOUT((191 - 0)- 4*0), true),
			107 => (C_ipd(7)'last_event, tpd_C_CARRYOUT((191 - 0)- 4*0), true),
			108 => (C_ipd(8)'last_event, tpd_C_CARRYOUT((191 - 0)- 4*0), true),
			109 => (C_ipd(9)'last_event, tpd_C_CARRYOUT((191 - 0)- 4*0), true),
			110 => (C_ipd(10)'last_event, tpd_C_CARRYOUT((191 - 0)- 4*0), true),
			111 => (C_ipd(11)'last_event, tpd_C_CARRYOUT((191 - 0)- 4*0), true),
			112 => (C_ipd(12)'last_event, tpd_C_CARRYOUT((191 - 0)- 4*0), true),
			113 => (C_ipd(13)'last_event, tpd_C_CARRYOUT((191 - 0)- 4*0), true),
			114 => (C_ipd(14)'last_event, tpd_C_CARRYOUT((191 - 0)- 4*0), true),
			115 => (C_ipd(15)'last_event, tpd_C_CARRYOUT((191 - 0)- 4*0), true),
			116 => (C_ipd(16)'last_event, tpd_C_CARRYOUT((191 - 0)- 4*0), true),
			117 => (C_ipd(17)'last_event, tpd_C_CARRYOUT((191 - 0)- 4*0), true),
			118 => (C_ipd(18)'last_event, tpd_C_CARRYOUT((191 - 0)- 4*0), true),
			119 => (C_ipd(19)'last_event, tpd_C_CARRYOUT((191 - 0)- 4*0), true),
			120 => (C_ipd(20)'last_event, tpd_C_CARRYOUT((191 - 0)- 4*0), true),
			121 => (C_ipd(21)'last_event, tpd_C_CARRYOUT((191 - 0)- 4*0), true),
			122 => (C_ipd(22)'last_event, tpd_C_CARRYOUT((191 - 0)- 4*0), true),
			123 => (C_ipd(23)'last_event, tpd_C_CARRYOUT((191 - 0)- 4*0), true),
			124 => (C_ipd(24)'last_event, tpd_C_CARRYOUT((191 - 0)- 4*0), true),
			125 => (C_ipd(25)'last_event, tpd_C_CARRYOUT((191 - 0)- 4*0), true),
			126 => (C_ipd(26)'last_event, tpd_C_CARRYOUT((191 - 0)- 4*0), true),
			127 => (C_ipd(27)'last_event, tpd_C_CARRYOUT((191 - 0)- 4*0), true),
			128 => (C_ipd(28)'last_event, tpd_C_CARRYOUT((191 - 0)- 4*0), true),
			129 => (C_ipd(29)'last_event, tpd_C_CARRYOUT((191 - 0)- 4*0), true),
			130 => (C_ipd(30)'last_event, tpd_C_CARRYOUT((191 - 0)- 4*0), true),
			131 => (C_ipd(31)'last_event, tpd_C_CARRYOUT((191 - 0)- 4*0), true),
			132 => (C_ipd(32)'last_event, tpd_C_CARRYOUT((191 - 0)- 4*0), true),
			133 => (C_ipd(33)'last_event, tpd_C_CARRYOUT((191 - 0)- 4*0), true),
			134 => (C_ipd(34)'last_event, tpd_C_CARRYOUT((191 - 0)- 4*0), true),
			135 => (C_ipd(35)'last_event, tpd_C_CARRYOUT((191 - 0)- 4*0), true),
			136 => (C_ipd(36)'last_event, tpd_C_CARRYOUT((191 - 0)- 4*0), true),
			137 => (C_ipd(37)'last_event, tpd_C_CARRYOUT((191 - 0)- 4*0), true),
			138 => (C_ipd(38)'last_event, tpd_C_CARRYOUT((191 - 0)- 4*0), true),
			139 => (C_ipd(39)'last_event, tpd_C_CARRYOUT((191 - 0)- 4*0), true),
			140 => (C_ipd(40)'last_event, tpd_C_CARRYOUT((191 - 0)- 4*0), true),
			141 => (C_ipd(41)'last_event, tpd_C_CARRYOUT((191 - 0)- 4*0), true),
			142 => (C_ipd(42)'last_event, tpd_C_CARRYOUT((191 - 0)- 4*0), true),
			143 => (C_ipd(43)'last_event, tpd_C_CARRYOUT((191 - 0)- 4*0), true),
			144 => (C_ipd(44)'last_event, tpd_C_CARRYOUT((191 - 0)- 4*0), true),
			145 => (C_ipd(45)'last_event, tpd_C_CARRYOUT((191 - 0)- 4*0), true),
			146 => (C_ipd(46)'last_event, tpd_C_CARRYOUT((191 - 0)- 4*0), true),
			147 => (C_ipd(47)'last_event, tpd_C_CARRYOUT((191 - 0)- 4*0), true),
			148 => (CARRYCASCIN_ipd'last_event, tpd_CARRYCASCIN_CARRYOUT(3), true),
			149 => (CARRYIN_ipd'last_event, tpd_CARRYIN_CARRYOUT(3), true),
			150 => (CARRYINSEL_ipd(0)'last_event, tpd_CARRYINSEL_CARRYOUT((11 - 0)- 4*0), true),
			151 => (CARRYINSEL_ipd(1)'last_event, tpd_CARRYINSEL_CARRYOUT((11 - 0)- 4*0), true),
			152 => (CARRYINSEL_ipd(2)'last_event, tpd_CARRYINSEL_CARRYOUT((11 - 0)- 4*0), true),
			153 => (MULTSIGNIN_ipd'last_event, tpd_MULTSIGNIN_CARRYOUT(3), true),
			154 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_CARRYOUT((27 - 0)- 4*0), true),
			155 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_CARRYOUT((27 - 0)- 4*0), true),
			156 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_CARRYOUT((27 - 0)- 4*0), true),
			157 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_CARRYOUT((27 - 0)- 4*0), true),
			158 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_CARRYOUT((27 - 0)- 4*0), true),
			159 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_CARRYOUT((27 - 0)- 4*0), true),
			160 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_CARRYOUT((27 - 0)- 4*0), true),
			161 => (PCIN_ipd(0)'last_event, tpd_PCIN_CARRYOUT((191 - 0)- 4*0), true),
			162 => (PCIN_ipd(1)'last_event, tpd_PCIN_CARRYOUT((191 - 0)- 4*0), true),
			163 => (PCIN_ipd(2)'last_event, tpd_PCIN_CARRYOUT((191 - 0)- 4*0), true),
			164 => (PCIN_ipd(3)'last_event, tpd_PCIN_CARRYOUT((191 - 0)- 4*0), true),
			165 => (PCIN_ipd(4)'last_event, tpd_PCIN_CARRYOUT((191 - 0)- 4*0), true),
			166 => (PCIN_ipd(5)'last_event, tpd_PCIN_CARRYOUT((191 - 0)- 4*0), true),
			167 => (PCIN_ipd(6)'last_event, tpd_PCIN_CARRYOUT((191 - 0)- 4*0), true),
			168 => (PCIN_ipd(7)'last_event, tpd_PCIN_CARRYOUT((191 - 0)- 4*0), true),
			169 => (PCIN_ipd(8)'last_event, tpd_PCIN_CARRYOUT((191 - 0)- 4*0), true),
			170 => (PCIN_ipd(9)'last_event, tpd_PCIN_CARRYOUT((191 - 0)- 4*0), true),
			171 => (PCIN_ipd(10)'last_event, tpd_PCIN_CARRYOUT((191 - 0)- 4*0), true),
			172 => (PCIN_ipd(11)'last_event, tpd_PCIN_CARRYOUT((191 - 0)- 4*0), true),
			173 => (PCIN_ipd(12)'last_event, tpd_PCIN_CARRYOUT((191 - 0)- 4*0), true),
			174 => (PCIN_ipd(13)'last_event, tpd_PCIN_CARRYOUT((191 - 0)- 4*0), true),
			175 => (PCIN_ipd(14)'last_event, tpd_PCIN_CARRYOUT((191 - 0)- 4*0), true),
			176 => (PCIN_ipd(15)'last_event, tpd_PCIN_CARRYOUT((191 - 0)- 4*0), true),
			177 => (PCIN_ipd(16)'last_event, tpd_PCIN_CARRYOUT((191 - 0)- 4*0), true),
			178 => (PCIN_ipd(17)'last_event, tpd_PCIN_CARRYOUT((191 - 0)- 4*0), true),
			179 => (PCIN_ipd(18)'last_event, tpd_PCIN_CARRYOUT((191 - 0)- 4*0), true),
			180 => (PCIN_ipd(19)'last_event, tpd_PCIN_CARRYOUT((191 - 0)- 4*0), true),
			181 => (PCIN_ipd(20)'last_event, tpd_PCIN_CARRYOUT((191 - 0)- 4*0), true),
			182 => (PCIN_ipd(21)'last_event, tpd_PCIN_CARRYOUT((191 - 0)- 4*0), true),
			183 => (PCIN_ipd(22)'last_event, tpd_PCIN_CARRYOUT((191 - 0)- 4*0), true),
			184 => (PCIN_ipd(23)'last_event, tpd_PCIN_CARRYOUT((191 - 0)- 4*0), true),
			185 => (PCIN_ipd(24)'last_event, tpd_PCIN_CARRYOUT((191 - 0)- 4*0), true),
			186 => (PCIN_ipd(25)'last_event, tpd_PCIN_CARRYOUT((191 - 0)- 4*0), true),
			187 => (PCIN_ipd(26)'last_event, tpd_PCIN_CARRYOUT((191 - 0)- 4*0), true),
			188 => (PCIN_ipd(27)'last_event, tpd_PCIN_CARRYOUT((191 - 0)- 4*0), true),
			189 => (PCIN_ipd(28)'last_event, tpd_PCIN_CARRYOUT((191 - 0)- 4*0), true),
			190 => (PCIN_ipd(29)'last_event, tpd_PCIN_CARRYOUT((191 - 0)- 4*0), true),
			191 => (PCIN_ipd(30)'last_event, tpd_PCIN_CARRYOUT((191 - 0)- 4*0), true),
			192 => (PCIN_ipd(31)'last_event, tpd_PCIN_CARRYOUT((191 - 0)- 4*0), true),
			193 => (PCIN_ipd(32)'last_event, tpd_PCIN_CARRYOUT((191 - 0)- 4*0), true),
			194 => (PCIN_ipd(33)'last_event, tpd_PCIN_CARRYOUT((191 - 0)- 4*0), true),
			195 => (PCIN_ipd(34)'last_event, tpd_PCIN_CARRYOUT((191 - 0)- 4*0), true),
			196 => (PCIN_ipd(35)'last_event, tpd_PCIN_CARRYOUT((191 - 0)- 4*0), true),
			197 => (PCIN_ipd(36)'last_event, tpd_PCIN_CARRYOUT((191 - 0)- 4*0), true),
			198 => (PCIN_ipd(37)'last_event, tpd_PCIN_CARRYOUT((191 - 0)- 4*0), true),
			199 => (PCIN_ipd(38)'last_event, tpd_PCIN_CARRYOUT((191 - 0)- 4*0), true),
			200 => (PCIN_ipd(39)'last_event, tpd_PCIN_CARRYOUT((191 - 0)- 4*0), true),
			201 => (PCIN_ipd(40)'last_event, tpd_PCIN_CARRYOUT((191 - 0)- 4*0), true),
			202 => (PCIN_ipd(41)'last_event, tpd_PCIN_CARRYOUT((191 - 0)- 4*0), true),
			203 => (PCIN_ipd(42)'last_event, tpd_PCIN_CARRYOUT((191 - 0)- 4*0), true),
			204 => (PCIN_ipd(43)'last_event, tpd_PCIN_CARRYOUT((191 - 0)- 4*0), true),
			205 => (PCIN_ipd(44)'last_event, tpd_PCIN_CARRYOUT((191 - 0)- 4*0), true),
			206 => (PCIN_ipd(45)'last_event, tpd_PCIN_CARRYOUT((191 - 0)- 4*0), true),
			207 => (PCIN_ipd(46)'last_event, tpd_PCIN_CARRYOUT((191 - 0)- 4*0), true),
			208 => (PCIN_ipd(47)'last_event, tpd_PCIN_CARRYOUT((191 - 0)- 4*0), true),
			209 => (CLK_dly'last_event, tpd_CLK_CARRYOUT(3), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> CARRYOUT(2),
         GlitchData	=> CARRYOUT_GlitchData(2),
         OutSignalName	=> "CARRYOUT(2)",
         OutTemp	=> CARRYOUT_zd(2),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_CARRYOUT((119 - 1)- 4*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_CARRYOUT((119 - 1)- 4*0), true),
			2 => (A_ipd(2)'last_event, tpd_A_CARRYOUT((119 - 1)- 4*0), true),
			3 => (A_ipd(3)'last_event, tpd_A_CARRYOUT((119 - 1)- 4*0), true),
			4 => (A_ipd(4)'last_event, tpd_A_CARRYOUT((119 - 1)- 4*0), true),
			5 => (A_ipd(5)'last_event, tpd_A_CARRYOUT((119 - 1)- 4*0), true),
			6 => (A_ipd(6)'last_event, tpd_A_CARRYOUT((119 - 1)- 4*0), true),
			7 => (A_ipd(7)'last_event, tpd_A_CARRYOUT((119 - 1)- 4*0), true),
			8 => (A_ipd(8)'last_event, tpd_A_CARRYOUT((119 - 1)- 4*0), true),
			9 => (A_ipd(9)'last_event, tpd_A_CARRYOUT((119 - 1)- 4*0), true),
			10 => (A_ipd(10)'last_event, tpd_A_CARRYOUT((119 - 1)- 4*0), true),
			11 => (A_ipd(11)'last_event, tpd_A_CARRYOUT((119 - 1)- 4*0), true),
			12 => (A_ipd(12)'last_event, tpd_A_CARRYOUT((119 - 1)- 4*0), true),
			13 => (A_ipd(13)'last_event, tpd_A_CARRYOUT((119 - 1)- 4*0), true),
			14 => (A_ipd(14)'last_event, tpd_A_CARRYOUT((119 - 1)- 4*0), true),
			15 => (A_ipd(15)'last_event, tpd_A_CARRYOUT((119 - 1)- 4*0), true),
			16 => (A_ipd(16)'last_event, tpd_A_CARRYOUT((119 - 1)- 4*0), true),
			17 => (A_ipd(17)'last_event, tpd_A_CARRYOUT((119 - 1)- 4*0), true),
			18 => (A_ipd(18)'last_event, tpd_A_CARRYOUT((119 - 1)- 4*0), true),
			19 => (A_ipd(19)'last_event, tpd_A_CARRYOUT((119 - 1)- 4*0), true),
			20 => (A_ipd(20)'last_event, tpd_A_CARRYOUT((119 - 1)- 4*0), true),
			21 => (A_ipd(21)'last_event, tpd_A_CARRYOUT((119 - 1)- 4*0), true),
			22 => (A_ipd(22)'last_event, tpd_A_CARRYOUT((119 - 1)- 4*0), true),
			23 => (A_ipd(23)'last_event, tpd_A_CARRYOUT((119 - 1)- 4*0), true),
			24 => (A_ipd(24)'last_event, tpd_A_CARRYOUT((119 - 1)- 4*0), true),
			25 => (A_ipd(25)'last_event, tpd_A_CARRYOUT((119 - 1)- 4*0), true),
			26 => (A_ipd(26)'last_event, tpd_A_CARRYOUT((119 - 1)- 4*0), true),
			27 => (A_ipd(27)'last_event, tpd_A_CARRYOUT((119 - 1)- 4*0), true),
			28 => (A_ipd(28)'last_event, tpd_A_CARRYOUT((119 - 1)- 4*0), true),
			29 => (A_ipd(29)'last_event, tpd_A_CARRYOUT((119 - 1)- 4*0), true),
			30 => (ACIN_ipd(0)'last_event, tpd_ACIN_CARRYOUT((119 - 1)- 4*0), true),
			31 => (ACIN_ipd(1)'last_event, tpd_ACIN_CARRYOUT((119 - 1)- 4*0), true),
			32 => (ACIN_ipd(2)'last_event, tpd_ACIN_CARRYOUT((119 - 1)- 4*0), true),
			33 => (ACIN_ipd(3)'last_event, tpd_ACIN_CARRYOUT((119 - 1)- 4*0), true),
			34 => (ACIN_ipd(4)'last_event, tpd_ACIN_CARRYOUT((119 - 1)- 4*0), true),
			35 => (ACIN_ipd(5)'last_event, tpd_ACIN_CARRYOUT((119 - 1)- 4*0), true),
			36 => (ACIN_ipd(6)'last_event, tpd_ACIN_CARRYOUT((119 - 1)- 4*0), true),
			37 => (ACIN_ipd(7)'last_event, tpd_ACIN_CARRYOUT((119 - 1)- 4*0), true),
			38 => (ACIN_ipd(8)'last_event, tpd_ACIN_CARRYOUT((119 - 1)- 4*0), true),
			39 => (ACIN_ipd(9)'last_event, tpd_ACIN_CARRYOUT((119 - 1)- 4*0), true),
			40 => (ACIN_ipd(10)'last_event, tpd_ACIN_CARRYOUT((119 - 1)- 4*0), true),
			41 => (ACIN_ipd(11)'last_event, tpd_ACIN_CARRYOUT((119 - 1)- 4*0), true),
			42 => (ACIN_ipd(12)'last_event, tpd_ACIN_CARRYOUT((119 - 1)- 4*0), true),
			43 => (ACIN_ipd(13)'last_event, tpd_ACIN_CARRYOUT((119 - 1)- 4*0), true),
			44 => (ACIN_ipd(14)'last_event, tpd_ACIN_CARRYOUT((119 - 1)- 4*0), true),
			45 => (ACIN_ipd(15)'last_event, tpd_ACIN_CARRYOUT((119 - 1)- 4*0), true),
			46 => (ACIN_ipd(16)'last_event, tpd_ACIN_CARRYOUT((119 - 1)- 4*0), true),
			47 => (ACIN_ipd(17)'last_event, tpd_ACIN_CARRYOUT((119 - 1)- 4*0), true),
			48 => (ACIN_ipd(18)'last_event, tpd_ACIN_CARRYOUT((119 - 1)- 4*0), true),
			49 => (ACIN_ipd(19)'last_event, tpd_ACIN_CARRYOUT((119 - 1)- 4*0), true),
			50 => (ACIN_ipd(20)'last_event, tpd_ACIN_CARRYOUT((119 - 1)- 4*0), true),
			51 => (ACIN_ipd(21)'last_event, tpd_ACIN_CARRYOUT((119 - 1)- 4*0), true),
			52 => (ACIN_ipd(22)'last_event, tpd_ACIN_CARRYOUT((119 - 1)- 4*0), true),
			53 => (ACIN_ipd(23)'last_event, tpd_ACIN_CARRYOUT((119 - 1)- 4*0), true),
			54 => (ACIN_ipd(24)'last_event, tpd_ACIN_CARRYOUT((119 - 1)- 4*0), true),
			55 => (ACIN_ipd(25)'last_event, tpd_ACIN_CARRYOUT((119 - 1)- 4*0), true),
			56 => (ACIN_ipd(26)'last_event, tpd_ACIN_CARRYOUT((119 - 1)- 4*0), true),
			57 => (ACIN_ipd(27)'last_event, tpd_ACIN_CARRYOUT((119 - 1)- 4*0), true),
			58 => (ACIN_ipd(28)'last_event, tpd_ACIN_CARRYOUT((119 - 1)- 4*0), true),
			59 => (ACIN_ipd(29)'last_event, tpd_ACIN_CARRYOUT((119 - 1)- 4*0), true),
			60 => (ALUMODE_ipd(0)'last_event, tpd_ALUMODE_CARRYOUT((15 - 1)- 4*0), true),
			61 => (ALUMODE_ipd(1)'last_event, tpd_ALUMODE_CARRYOUT((15 - 1)- 4*0), true),
			62 => (ALUMODE_ipd(2)'last_event, tpd_ALUMODE_CARRYOUT((15 - 1)- 4*0), true),
			63 => (ALUMODE_ipd(3)'last_event, tpd_ALUMODE_CARRYOUT((15 - 1)- 4*0), true),
			64 => (B_ipd(0)'last_event, tpd_B_CARRYOUT((71 - 1)- 4*0), true),
			65 => (B_ipd(1)'last_event, tpd_B_CARRYOUT((71 - 1)- 4*0), true),
			66 => (B_ipd(2)'last_event, tpd_B_CARRYOUT((71 - 1)- 4*0), true),
			67 => (B_ipd(3)'last_event, tpd_B_CARRYOUT((71 - 1)- 4*0), true),
			68 => (B_ipd(4)'last_event, tpd_B_CARRYOUT((71 - 1)- 4*0), true),
			69 => (B_ipd(5)'last_event, tpd_B_CARRYOUT((71 - 1)- 4*0), true),
			70 => (B_ipd(6)'last_event, tpd_B_CARRYOUT((71 - 1)- 4*0), true),
			71 => (B_ipd(7)'last_event, tpd_B_CARRYOUT((71 - 1)- 4*0), true),
			72 => (B_ipd(8)'last_event, tpd_B_CARRYOUT((71 - 1)- 4*0), true),
			73 => (B_ipd(9)'last_event, tpd_B_CARRYOUT((71 - 1)- 4*0), true),
			74 => (B_ipd(10)'last_event, tpd_B_CARRYOUT((71 - 1)- 4*0), true),
			75 => (B_ipd(11)'last_event, tpd_B_CARRYOUT((71 - 1)- 4*0), true),
			76 => (B_ipd(12)'last_event, tpd_B_CARRYOUT((71 - 1)- 4*0), true),
			77 => (B_ipd(13)'last_event, tpd_B_CARRYOUT((71 - 1)- 4*0), true),
			78 => (B_ipd(14)'last_event, tpd_B_CARRYOUT((71 - 1)- 4*0), true),
			79 => (B_ipd(15)'last_event, tpd_B_CARRYOUT((71 - 1)- 4*0), true),
			80 => (B_ipd(16)'last_event, tpd_B_CARRYOUT((71 - 1)- 4*0), true),
			81 => (B_ipd(17)'last_event, tpd_B_CARRYOUT((71 - 1)- 4*0), true),
			82 => (BCIN_ipd(0)'last_event, tpd_BCIN_CARRYOUT((71 - 1)- 4*0), true),
			83 => (BCIN_ipd(1)'last_event, tpd_BCIN_CARRYOUT((71 - 1)- 4*0), true),
			84 => (BCIN_ipd(2)'last_event, tpd_BCIN_CARRYOUT((71 - 1)- 4*0), true),
			85 => (BCIN_ipd(3)'last_event, tpd_BCIN_CARRYOUT((71 - 1)- 4*0), true),
			86 => (BCIN_ipd(4)'last_event, tpd_BCIN_CARRYOUT((71 - 1)- 4*0), true),
			87 => (BCIN_ipd(5)'last_event, tpd_BCIN_CARRYOUT((71 - 1)- 4*0), true),
			88 => (BCIN_ipd(6)'last_event, tpd_BCIN_CARRYOUT((71 - 1)- 4*0), true),
			89 => (BCIN_ipd(7)'last_event, tpd_BCIN_CARRYOUT((71 - 1)- 4*0), true),
			90 => (BCIN_ipd(8)'last_event, tpd_BCIN_CARRYOUT((71 - 1)- 4*0), true),
			91 => (BCIN_ipd(9)'last_event, tpd_BCIN_CARRYOUT((71 - 1)- 4*0), true),
			92 => (BCIN_ipd(10)'last_event, tpd_BCIN_CARRYOUT((71 - 1)- 4*0), true),
			93 => (BCIN_ipd(11)'last_event, tpd_BCIN_CARRYOUT((71 - 1)- 4*0), true),
			94 => (BCIN_ipd(12)'last_event, tpd_BCIN_CARRYOUT((71 - 1)- 4*0), true),
			95 => (BCIN_ipd(13)'last_event, tpd_BCIN_CARRYOUT((71 - 1)- 4*0), true),
			96 => (BCIN_ipd(14)'last_event, tpd_BCIN_CARRYOUT((71 - 1)- 4*0), true),
			97 => (BCIN_ipd(15)'last_event, tpd_BCIN_CARRYOUT((71 - 1)- 4*0), true),
			98 => (BCIN_ipd(16)'last_event, tpd_BCIN_CARRYOUT((71 - 1)- 4*0), true),
			99 => (BCIN_ipd(17)'last_event, tpd_BCIN_CARRYOUT((71 - 1)- 4*0), true),
			100 => (C_ipd(0)'last_event, tpd_C_CARRYOUT((191 - 1)- 4*0), true),
			101 => (C_ipd(1)'last_event, tpd_C_CARRYOUT((191 - 1)- 4*0), true),
			102 => (C_ipd(2)'last_event, tpd_C_CARRYOUT((191 - 1)- 4*0), true),
			103 => (C_ipd(3)'last_event, tpd_C_CARRYOUT((191 - 1)- 4*0), true),
			104 => (C_ipd(4)'last_event, tpd_C_CARRYOUT((191 - 1)- 4*0), true),
			105 => (C_ipd(5)'last_event, tpd_C_CARRYOUT((191 - 1)- 4*0), true),
			106 => (C_ipd(6)'last_event, tpd_C_CARRYOUT((191 - 1)- 4*0), true),
			107 => (C_ipd(7)'last_event, tpd_C_CARRYOUT((191 - 1)- 4*0), true),
			108 => (C_ipd(8)'last_event, tpd_C_CARRYOUT((191 - 1)- 4*0), true),
			109 => (C_ipd(9)'last_event, tpd_C_CARRYOUT((191 - 1)- 4*0), true),
			110 => (C_ipd(10)'last_event, tpd_C_CARRYOUT((191 - 1)- 4*0), true),
			111 => (C_ipd(11)'last_event, tpd_C_CARRYOUT((191 - 1)- 4*0), true),
			112 => (C_ipd(12)'last_event, tpd_C_CARRYOUT((191 - 1)- 4*0), true),
			113 => (C_ipd(13)'last_event, tpd_C_CARRYOUT((191 - 1)- 4*0), true),
			114 => (C_ipd(14)'last_event, tpd_C_CARRYOUT((191 - 1)- 4*0), true),
			115 => (C_ipd(15)'last_event, tpd_C_CARRYOUT((191 - 1)- 4*0), true),
			116 => (C_ipd(16)'last_event, tpd_C_CARRYOUT((191 - 1)- 4*0), true),
			117 => (C_ipd(17)'last_event, tpd_C_CARRYOUT((191 - 1)- 4*0), true),
			118 => (C_ipd(18)'last_event, tpd_C_CARRYOUT((191 - 1)- 4*0), true),
			119 => (C_ipd(19)'last_event, tpd_C_CARRYOUT((191 - 1)- 4*0), true),
			120 => (C_ipd(20)'last_event, tpd_C_CARRYOUT((191 - 1)- 4*0), true),
			121 => (C_ipd(21)'last_event, tpd_C_CARRYOUT((191 - 1)- 4*0), true),
			122 => (C_ipd(22)'last_event, tpd_C_CARRYOUT((191 - 1)- 4*0), true),
			123 => (C_ipd(23)'last_event, tpd_C_CARRYOUT((191 - 1)- 4*0), true),
			124 => (C_ipd(24)'last_event, tpd_C_CARRYOUT((191 - 1)- 4*0), true),
			125 => (C_ipd(25)'last_event, tpd_C_CARRYOUT((191 - 1)- 4*0), true),
			126 => (C_ipd(26)'last_event, tpd_C_CARRYOUT((191 - 1)- 4*0), true),
			127 => (C_ipd(27)'last_event, tpd_C_CARRYOUT((191 - 1)- 4*0), true),
			128 => (C_ipd(28)'last_event, tpd_C_CARRYOUT((191 - 1)- 4*0), true),
			129 => (C_ipd(29)'last_event, tpd_C_CARRYOUT((191 - 1)- 4*0), true),
			130 => (C_ipd(30)'last_event, tpd_C_CARRYOUT((191 - 1)- 4*0), true),
			131 => (C_ipd(31)'last_event, tpd_C_CARRYOUT((191 - 1)- 4*0), true),
			132 => (C_ipd(32)'last_event, tpd_C_CARRYOUT((191 - 1)- 4*0), true),
			133 => (C_ipd(33)'last_event, tpd_C_CARRYOUT((191 - 1)- 4*0), true),
			134 => (C_ipd(34)'last_event, tpd_C_CARRYOUT((191 - 1)- 4*0), true),
			135 => (C_ipd(35)'last_event, tpd_C_CARRYOUT((191 - 1)- 4*0), true),
			136 => (C_ipd(36)'last_event, tpd_C_CARRYOUT((191 - 1)- 4*0), true),
			137 => (C_ipd(37)'last_event, tpd_C_CARRYOUT((191 - 1)- 4*0), true),
			138 => (C_ipd(38)'last_event, tpd_C_CARRYOUT((191 - 1)- 4*0), true),
			139 => (C_ipd(39)'last_event, tpd_C_CARRYOUT((191 - 1)- 4*0), true),
			140 => (C_ipd(40)'last_event, tpd_C_CARRYOUT((191 - 1)- 4*0), true),
			141 => (C_ipd(41)'last_event, tpd_C_CARRYOUT((191 - 1)- 4*0), true),
			142 => (C_ipd(42)'last_event, tpd_C_CARRYOUT((191 - 1)- 4*0), true),
			143 => (C_ipd(43)'last_event, tpd_C_CARRYOUT((191 - 1)- 4*0), true),
			144 => (C_ipd(44)'last_event, tpd_C_CARRYOUT((191 - 1)- 4*0), true),
			145 => (C_ipd(45)'last_event, tpd_C_CARRYOUT((191 - 1)- 4*0), true),
			146 => (C_ipd(46)'last_event, tpd_C_CARRYOUT((191 - 1)- 4*0), true),
			147 => (C_ipd(47)'last_event, tpd_C_CARRYOUT((191 - 1)- 4*0), true),
			148 => (CARRYCASCIN_ipd'last_event, tpd_CARRYCASCIN_CARRYOUT(2), true),
			149 => (CARRYIN_ipd'last_event, tpd_CARRYIN_CARRYOUT(2), true),
			150 => (CARRYINSEL_ipd(0)'last_event, tpd_CARRYINSEL_CARRYOUT((11 - 1)- 4*0), true),
			151 => (CARRYINSEL_ipd(1)'last_event, tpd_CARRYINSEL_CARRYOUT((11 - 1)- 4*0), true),
			152 => (CARRYINSEL_ipd(2)'last_event, tpd_CARRYINSEL_CARRYOUT((11 - 1)- 4*0), true),
			153 => (MULTSIGNIN_ipd'last_event, tpd_MULTSIGNIN_CARRYOUT(2), true),
			154 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_CARRYOUT((27 - 1)- 4*0), true),
			155 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_CARRYOUT((27 - 1)- 4*0), true),
			156 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_CARRYOUT((27 - 1)- 4*0), true),
			157 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_CARRYOUT((27 - 1)- 4*0), true),
			158 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_CARRYOUT((27 - 1)- 4*0), true),
			159 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_CARRYOUT((27 - 1)- 4*0), true),
			160 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_CARRYOUT((27 - 1)- 4*0), true),
			161 => (PCIN_ipd(0)'last_event, tpd_PCIN_CARRYOUT((191 - 1)- 4*0), true),
			162 => (PCIN_ipd(1)'last_event, tpd_PCIN_CARRYOUT((191 - 1)- 4*0), true),
			163 => (PCIN_ipd(2)'last_event, tpd_PCIN_CARRYOUT((191 - 1)- 4*0), true),
			164 => (PCIN_ipd(3)'last_event, tpd_PCIN_CARRYOUT((191 - 1)- 4*0), true),
			165 => (PCIN_ipd(4)'last_event, tpd_PCIN_CARRYOUT((191 - 1)- 4*0), true),
			166 => (PCIN_ipd(5)'last_event, tpd_PCIN_CARRYOUT((191 - 1)- 4*0), true),
			167 => (PCIN_ipd(6)'last_event, tpd_PCIN_CARRYOUT((191 - 1)- 4*0), true),
			168 => (PCIN_ipd(7)'last_event, tpd_PCIN_CARRYOUT((191 - 1)- 4*0), true),
			169 => (PCIN_ipd(8)'last_event, tpd_PCIN_CARRYOUT((191 - 1)- 4*0), true),
			170 => (PCIN_ipd(9)'last_event, tpd_PCIN_CARRYOUT((191 - 1)- 4*0), true),
			171 => (PCIN_ipd(10)'last_event, tpd_PCIN_CARRYOUT((191 - 1)- 4*0), true),
			172 => (PCIN_ipd(11)'last_event, tpd_PCIN_CARRYOUT((191 - 1)- 4*0), true),
			173 => (PCIN_ipd(12)'last_event, tpd_PCIN_CARRYOUT((191 - 1)- 4*0), true),
			174 => (PCIN_ipd(13)'last_event, tpd_PCIN_CARRYOUT((191 - 1)- 4*0), true),
			175 => (PCIN_ipd(14)'last_event, tpd_PCIN_CARRYOUT((191 - 1)- 4*0), true),
			176 => (PCIN_ipd(15)'last_event, tpd_PCIN_CARRYOUT((191 - 1)- 4*0), true),
			177 => (PCIN_ipd(16)'last_event, tpd_PCIN_CARRYOUT((191 - 1)- 4*0), true),
			178 => (PCIN_ipd(17)'last_event, tpd_PCIN_CARRYOUT((191 - 1)- 4*0), true),
			179 => (PCIN_ipd(18)'last_event, tpd_PCIN_CARRYOUT((191 - 1)- 4*0), true),
			180 => (PCIN_ipd(19)'last_event, tpd_PCIN_CARRYOUT((191 - 1)- 4*0), true),
			181 => (PCIN_ipd(20)'last_event, tpd_PCIN_CARRYOUT((191 - 1)- 4*0), true),
			182 => (PCIN_ipd(21)'last_event, tpd_PCIN_CARRYOUT((191 - 1)- 4*0), true),
			183 => (PCIN_ipd(22)'last_event, tpd_PCIN_CARRYOUT((191 - 1)- 4*0), true),
			184 => (PCIN_ipd(23)'last_event, tpd_PCIN_CARRYOUT((191 - 1)- 4*0), true),
			185 => (PCIN_ipd(24)'last_event, tpd_PCIN_CARRYOUT((191 - 1)- 4*0), true),
			186 => (PCIN_ipd(25)'last_event, tpd_PCIN_CARRYOUT((191 - 1)- 4*0), true),
			187 => (PCIN_ipd(26)'last_event, tpd_PCIN_CARRYOUT((191 - 1)- 4*0), true),
			188 => (PCIN_ipd(27)'last_event, tpd_PCIN_CARRYOUT((191 - 1)- 4*0), true),
			189 => (PCIN_ipd(28)'last_event, tpd_PCIN_CARRYOUT((191 - 1)- 4*0), true),
			190 => (PCIN_ipd(29)'last_event, tpd_PCIN_CARRYOUT((191 - 1)- 4*0), true),
			191 => (PCIN_ipd(30)'last_event, tpd_PCIN_CARRYOUT((191 - 1)- 4*0), true),
			192 => (PCIN_ipd(31)'last_event, tpd_PCIN_CARRYOUT((191 - 1)- 4*0), true),
			193 => (PCIN_ipd(32)'last_event, tpd_PCIN_CARRYOUT((191 - 1)- 4*0), true),
			194 => (PCIN_ipd(33)'last_event, tpd_PCIN_CARRYOUT((191 - 1)- 4*0), true),
			195 => (PCIN_ipd(34)'last_event, tpd_PCIN_CARRYOUT((191 - 1)- 4*0), true),
			196 => (PCIN_ipd(35)'last_event, tpd_PCIN_CARRYOUT((191 - 1)- 4*0), true),
			197 => (PCIN_ipd(36)'last_event, tpd_PCIN_CARRYOUT((191 - 1)- 4*0), true),
			198 => (PCIN_ipd(37)'last_event, tpd_PCIN_CARRYOUT((191 - 1)- 4*0), true),
			199 => (PCIN_ipd(38)'last_event, tpd_PCIN_CARRYOUT((191 - 1)- 4*0), true),
			200 => (PCIN_ipd(39)'last_event, tpd_PCIN_CARRYOUT((191 - 1)- 4*0), true),
			201 => (PCIN_ipd(40)'last_event, tpd_PCIN_CARRYOUT((191 - 1)- 4*0), true),
			202 => (PCIN_ipd(41)'last_event, tpd_PCIN_CARRYOUT((191 - 1)- 4*0), true),
			203 => (PCIN_ipd(42)'last_event, tpd_PCIN_CARRYOUT((191 - 1)- 4*0), true),
			204 => (PCIN_ipd(43)'last_event, tpd_PCIN_CARRYOUT((191 - 1)- 4*0), true),
			205 => (PCIN_ipd(44)'last_event, tpd_PCIN_CARRYOUT((191 - 1)- 4*0), true),
			206 => (PCIN_ipd(45)'last_event, tpd_PCIN_CARRYOUT((191 - 1)- 4*0), true),
			207 => (PCIN_ipd(46)'last_event, tpd_PCIN_CARRYOUT((191 - 1)- 4*0), true),
			208 => (PCIN_ipd(47)'last_event, tpd_PCIN_CARRYOUT((191 - 1)- 4*0), true),
			209 => (CLK_dly'last_event, tpd_CLK_CARRYOUT(2), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> CARRYOUT(1),
         GlitchData	=> CARRYOUT_GlitchData(1),
         OutSignalName	=> "CARRYOUT(1)",
         OutTemp	=> CARRYOUT_zd(1),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_CARRYOUT((119 - 2)- 4*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_CARRYOUT((119 - 2)- 4*0), true),
			2 => (A_ipd(2)'last_event, tpd_A_CARRYOUT((119 - 2)- 4*0), true),
			3 => (A_ipd(3)'last_event, tpd_A_CARRYOUT((119 - 2)- 4*0), true),
			4 => (A_ipd(4)'last_event, tpd_A_CARRYOUT((119 - 2)- 4*0), true),
			5 => (A_ipd(5)'last_event, tpd_A_CARRYOUT((119 - 2)- 4*0), true),
			6 => (A_ipd(6)'last_event, tpd_A_CARRYOUT((119 - 2)- 4*0), true),
			7 => (A_ipd(7)'last_event, tpd_A_CARRYOUT((119 - 2)- 4*0), true),
			8 => (A_ipd(8)'last_event, tpd_A_CARRYOUT((119 - 2)- 4*0), true),
			9 => (A_ipd(9)'last_event, tpd_A_CARRYOUT((119 - 2)- 4*0), true),
			10 => (A_ipd(10)'last_event, tpd_A_CARRYOUT((119 - 2)- 4*0), true),
			11 => (A_ipd(11)'last_event, tpd_A_CARRYOUT((119 - 2)- 4*0), true),
			12 => (A_ipd(12)'last_event, tpd_A_CARRYOUT((119 - 2)- 4*0), true),
			13 => (A_ipd(13)'last_event, tpd_A_CARRYOUT((119 - 2)- 4*0), true),
			14 => (A_ipd(14)'last_event, tpd_A_CARRYOUT((119 - 2)- 4*0), true),
			15 => (A_ipd(15)'last_event, tpd_A_CARRYOUT((119 - 2)- 4*0), true),
			16 => (A_ipd(16)'last_event, tpd_A_CARRYOUT((119 - 2)- 4*0), true),
			17 => (A_ipd(17)'last_event, tpd_A_CARRYOUT((119 - 2)- 4*0), true),
			18 => (A_ipd(18)'last_event, tpd_A_CARRYOUT((119 - 2)- 4*0), true),
			19 => (A_ipd(19)'last_event, tpd_A_CARRYOUT((119 - 2)- 4*0), true),
			20 => (A_ipd(20)'last_event, tpd_A_CARRYOUT((119 - 2)- 4*0), true),
			21 => (A_ipd(21)'last_event, tpd_A_CARRYOUT((119 - 2)- 4*0), true),
			22 => (A_ipd(22)'last_event, tpd_A_CARRYOUT((119 - 2)- 4*0), true),
			23 => (A_ipd(23)'last_event, tpd_A_CARRYOUT((119 - 2)- 4*0), true),
			24 => (A_ipd(24)'last_event, tpd_A_CARRYOUT((119 - 2)- 4*0), true),
			25 => (A_ipd(25)'last_event, tpd_A_CARRYOUT((119 - 2)- 4*0), true),
			26 => (A_ipd(26)'last_event, tpd_A_CARRYOUT((119 - 2)- 4*0), true),
			27 => (A_ipd(27)'last_event, tpd_A_CARRYOUT((119 - 2)- 4*0), true),
			28 => (A_ipd(28)'last_event, tpd_A_CARRYOUT((119 - 2)- 4*0), true),
			29 => (A_ipd(29)'last_event, tpd_A_CARRYOUT((119 - 2)- 4*0), true),
			30 => (ACIN_ipd(0)'last_event, tpd_ACIN_CARRYOUT((119 - 2)- 4*0), true),
			31 => (ACIN_ipd(1)'last_event, tpd_ACIN_CARRYOUT((119 - 2)- 4*0), true),
			32 => (ACIN_ipd(2)'last_event, tpd_ACIN_CARRYOUT((119 - 2)- 4*0), true),
			33 => (ACIN_ipd(3)'last_event, tpd_ACIN_CARRYOUT((119 - 2)- 4*0), true),
			34 => (ACIN_ipd(4)'last_event, tpd_ACIN_CARRYOUT((119 - 2)- 4*0), true),
			35 => (ACIN_ipd(5)'last_event, tpd_ACIN_CARRYOUT((119 - 2)- 4*0), true),
			36 => (ACIN_ipd(6)'last_event, tpd_ACIN_CARRYOUT((119 - 2)- 4*0), true),
			37 => (ACIN_ipd(7)'last_event, tpd_ACIN_CARRYOUT((119 - 2)- 4*0), true),
			38 => (ACIN_ipd(8)'last_event, tpd_ACIN_CARRYOUT((119 - 2)- 4*0), true),
			39 => (ACIN_ipd(9)'last_event, tpd_ACIN_CARRYOUT((119 - 2)- 4*0), true),
			40 => (ACIN_ipd(10)'last_event, tpd_ACIN_CARRYOUT((119 - 2)- 4*0), true),
			41 => (ACIN_ipd(11)'last_event, tpd_ACIN_CARRYOUT((119 - 2)- 4*0), true),
			42 => (ACIN_ipd(12)'last_event, tpd_ACIN_CARRYOUT((119 - 2)- 4*0), true),
			43 => (ACIN_ipd(13)'last_event, tpd_ACIN_CARRYOUT((119 - 2)- 4*0), true),
			44 => (ACIN_ipd(14)'last_event, tpd_ACIN_CARRYOUT((119 - 2)- 4*0), true),
			45 => (ACIN_ipd(15)'last_event, tpd_ACIN_CARRYOUT((119 - 2)- 4*0), true),
			46 => (ACIN_ipd(16)'last_event, tpd_ACIN_CARRYOUT((119 - 2)- 4*0), true),
			47 => (ACIN_ipd(17)'last_event, tpd_ACIN_CARRYOUT((119 - 2)- 4*0), true),
			48 => (ACIN_ipd(18)'last_event, tpd_ACIN_CARRYOUT((119 - 2)- 4*0), true),
			49 => (ACIN_ipd(19)'last_event, tpd_ACIN_CARRYOUT((119 - 2)- 4*0), true),
			50 => (ACIN_ipd(20)'last_event, tpd_ACIN_CARRYOUT((119 - 2)- 4*0), true),
			51 => (ACIN_ipd(21)'last_event, tpd_ACIN_CARRYOUT((119 - 2)- 4*0), true),
			52 => (ACIN_ipd(22)'last_event, tpd_ACIN_CARRYOUT((119 - 2)- 4*0), true),
			53 => (ACIN_ipd(23)'last_event, tpd_ACIN_CARRYOUT((119 - 2)- 4*0), true),
			54 => (ACIN_ipd(24)'last_event, tpd_ACIN_CARRYOUT((119 - 2)- 4*0), true),
			55 => (ACIN_ipd(25)'last_event, tpd_ACIN_CARRYOUT((119 - 2)- 4*0), true),
			56 => (ACIN_ipd(26)'last_event, tpd_ACIN_CARRYOUT((119 - 2)- 4*0), true),
			57 => (ACIN_ipd(27)'last_event, tpd_ACIN_CARRYOUT((119 - 2)- 4*0), true),
			58 => (ACIN_ipd(28)'last_event, tpd_ACIN_CARRYOUT((119 - 2)- 4*0), true),
			59 => (ACIN_ipd(29)'last_event, tpd_ACIN_CARRYOUT((119 - 2)- 4*0), true),
			60 => (ALUMODE_ipd(0)'last_event, tpd_ALUMODE_CARRYOUT((15 - 2)- 4*0), true),
			61 => (ALUMODE_ipd(1)'last_event, tpd_ALUMODE_CARRYOUT((15 - 2)- 4*0), true),
			62 => (ALUMODE_ipd(2)'last_event, tpd_ALUMODE_CARRYOUT((15 - 2)- 4*0), true),
			63 => (ALUMODE_ipd(3)'last_event, tpd_ALUMODE_CARRYOUT((15 - 2)- 4*0), true),
			64 => (B_ipd(0)'last_event, tpd_B_CARRYOUT((71 - 2)- 4*0), true),
			65 => (B_ipd(1)'last_event, tpd_B_CARRYOUT((71 - 2)- 4*0), true),
			66 => (B_ipd(2)'last_event, tpd_B_CARRYOUT((71 - 2)- 4*0), true),
			67 => (B_ipd(3)'last_event, tpd_B_CARRYOUT((71 - 2)- 4*0), true),
			68 => (B_ipd(4)'last_event, tpd_B_CARRYOUT((71 - 2)- 4*0), true),
			69 => (B_ipd(5)'last_event, tpd_B_CARRYOUT((71 - 2)- 4*0), true),
			70 => (B_ipd(6)'last_event, tpd_B_CARRYOUT((71 - 2)- 4*0), true),
			71 => (B_ipd(7)'last_event, tpd_B_CARRYOUT((71 - 2)- 4*0), true),
			72 => (B_ipd(8)'last_event, tpd_B_CARRYOUT((71 - 2)- 4*0), true),
			73 => (B_ipd(9)'last_event, tpd_B_CARRYOUT((71 - 2)- 4*0), true),
			74 => (B_ipd(10)'last_event, tpd_B_CARRYOUT((71 - 2)- 4*0), true),
			75 => (B_ipd(11)'last_event, tpd_B_CARRYOUT((71 - 2)- 4*0), true),
			76 => (B_ipd(12)'last_event, tpd_B_CARRYOUT((71 - 2)- 4*0), true),
			77 => (B_ipd(13)'last_event, tpd_B_CARRYOUT((71 - 2)- 4*0), true),
			78 => (B_ipd(14)'last_event, tpd_B_CARRYOUT((71 - 2)- 4*0), true),
			79 => (B_ipd(15)'last_event, tpd_B_CARRYOUT((71 - 2)- 4*0), true),
			80 => (B_ipd(16)'last_event, tpd_B_CARRYOUT((71 - 2)- 4*0), true),
			81 => (B_ipd(17)'last_event, tpd_B_CARRYOUT((71 - 2)- 4*0), true),
			82 => (BCIN_ipd(0)'last_event, tpd_BCIN_CARRYOUT((71 - 2)- 4*0), true),
			83 => (BCIN_ipd(1)'last_event, tpd_BCIN_CARRYOUT((71 - 2)- 4*0), true),
			84 => (BCIN_ipd(2)'last_event, tpd_BCIN_CARRYOUT((71 - 2)- 4*0), true),
			85 => (BCIN_ipd(3)'last_event, tpd_BCIN_CARRYOUT((71 - 2)- 4*0), true),
			86 => (BCIN_ipd(4)'last_event, tpd_BCIN_CARRYOUT((71 - 2)- 4*0), true),
			87 => (BCIN_ipd(5)'last_event, tpd_BCIN_CARRYOUT((71 - 2)- 4*0), true),
			88 => (BCIN_ipd(6)'last_event, tpd_BCIN_CARRYOUT((71 - 2)- 4*0), true),
			89 => (BCIN_ipd(7)'last_event, tpd_BCIN_CARRYOUT((71 - 2)- 4*0), true),
			90 => (BCIN_ipd(8)'last_event, tpd_BCIN_CARRYOUT((71 - 2)- 4*0), true),
			91 => (BCIN_ipd(9)'last_event, tpd_BCIN_CARRYOUT((71 - 2)- 4*0), true),
			92 => (BCIN_ipd(10)'last_event, tpd_BCIN_CARRYOUT((71 - 2)- 4*0), true),
			93 => (BCIN_ipd(11)'last_event, tpd_BCIN_CARRYOUT((71 - 2)- 4*0), true),
			94 => (BCIN_ipd(12)'last_event, tpd_BCIN_CARRYOUT((71 - 2)- 4*0), true),
			95 => (BCIN_ipd(13)'last_event, tpd_BCIN_CARRYOUT((71 - 2)- 4*0), true),
			96 => (BCIN_ipd(14)'last_event, tpd_BCIN_CARRYOUT((71 - 2)- 4*0), true),
			97 => (BCIN_ipd(15)'last_event, tpd_BCIN_CARRYOUT((71 - 2)- 4*0), true),
			98 => (BCIN_ipd(16)'last_event, tpd_BCIN_CARRYOUT((71 - 2)- 4*0), true),
			99 => (BCIN_ipd(17)'last_event, tpd_BCIN_CARRYOUT((71 - 2)- 4*0), true),
			100 => (C_ipd(0)'last_event, tpd_C_CARRYOUT((191 - 2)- 4*0), true),
			101 => (C_ipd(1)'last_event, tpd_C_CARRYOUT((191 - 2)- 4*0), true),
			102 => (C_ipd(2)'last_event, tpd_C_CARRYOUT((191 - 2)- 4*0), true),
			103 => (C_ipd(3)'last_event, tpd_C_CARRYOUT((191 - 2)- 4*0), true),
			104 => (C_ipd(4)'last_event, tpd_C_CARRYOUT((191 - 2)- 4*0), true),
			105 => (C_ipd(5)'last_event, tpd_C_CARRYOUT((191 - 2)- 4*0), true),
			106 => (C_ipd(6)'last_event, tpd_C_CARRYOUT((191 - 2)- 4*0), true),
			107 => (C_ipd(7)'last_event, tpd_C_CARRYOUT((191 - 2)- 4*0), true),
			108 => (C_ipd(8)'last_event, tpd_C_CARRYOUT((191 - 2)- 4*0), true),
			109 => (C_ipd(9)'last_event, tpd_C_CARRYOUT((191 - 2)- 4*0), true),
			110 => (C_ipd(10)'last_event, tpd_C_CARRYOUT((191 - 2)- 4*0), true),
			111 => (C_ipd(11)'last_event, tpd_C_CARRYOUT((191 - 2)- 4*0), true),
			112 => (C_ipd(12)'last_event, tpd_C_CARRYOUT((191 - 2)- 4*0), true),
			113 => (C_ipd(13)'last_event, tpd_C_CARRYOUT((191 - 2)- 4*0), true),
			114 => (C_ipd(14)'last_event, tpd_C_CARRYOUT((191 - 2)- 4*0), true),
			115 => (C_ipd(15)'last_event, tpd_C_CARRYOUT((191 - 2)- 4*0), true),
			116 => (C_ipd(16)'last_event, tpd_C_CARRYOUT((191 - 2)- 4*0), true),
			117 => (C_ipd(17)'last_event, tpd_C_CARRYOUT((191 - 2)- 4*0), true),
			118 => (C_ipd(18)'last_event, tpd_C_CARRYOUT((191 - 2)- 4*0), true),
			119 => (C_ipd(19)'last_event, tpd_C_CARRYOUT((191 - 2)- 4*0), true),
			120 => (C_ipd(20)'last_event, tpd_C_CARRYOUT((191 - 2)- 4*0), true),
			121 => (C_ipd(21)'last_event, tpd_C_CARRYOUT((191 - 2)- 4*0), true),
			122 => (C_ipd(22)'last_event, tpd_C_CARRYOUT((191 - 2)- 4*0), true),
			123 => (C_ipd(23)'last_event, tpd_C_CARRYOUT((191 - 2)- 4*0), true),
			124 => (C_ipd(24)'last_event, tpd_C_CARRYOUT((191 - 2)- 4*0), true),
			125 => (C_ipd(25)'last_event, tpd_C_CARRYOUT((191 - 2)- 4*0), true),
			126 => (C_ipd(26)'last_event, tpd_C_CARRYOUT((191 - 2)- 4*0), true),
			127 => (C_ipd(27)'last_event, tpd_C_CARRYOUT((191 - 2)- 4*0), true),
			128 => (C_ipd(28)'last_event, tpd_C_CARRYOUT((191 - 2)- 4*0), true),
			129 => (C_ipd(29)'last_event, tpd_C_CARRYOUT((191 - 2)- 4*0), true),
			130 => (C_ipd(30)'last_event, tpd_C_CARRYOUT((191 - 2)- 4*0), true),
			131 => (C_ipd(31)'last_event, tpd_C_CARRYOUT((191 - 2)- 4*0), true),
			132 => (C_ipd(32)'last_event, tpd_C_CARRYOUT((191 - 2)- 4*0), true),
			133 => (C_ipd(33)'last_event, tpd_C_CARRYOUT((191 - 2)- 4*0), true),
			134 => (C_ipd(34)'last_event, tpd_C_CARRYOUT((191 - 2)- 4*0), true),
			135 => (C_ipd(35)'last_event, tpd_C_CARRYOUT((191 - 2)- 4*0), true),
			136 => (C_ipd(36)'last_event, tpd_C_CARRYOUT((191 - 2)- 4*0), true),
			137 => (C_ipd(37)'last_event, tpd_C_CARRYOUT((191 - 2)- 4*0), true),
			138 => (C_ipd(38)'last_event, tpd_C_CARRYOUT((191 - 2)- 4*0), true),
			139 => (C_ipd(39)'last_event, tpd_C_CARRYOUT((191 - 2)- 4*0), true),
			140 => (C_ipd(40)'last_event, tpd_C_CARRYOUT((191 - 2)- 4*0), true),
			141 => (C_ipd(41)'last_event, tpd_C_CARRYOUT((191 - 2)- 4*0), true),
			142 => (C_ipd(42)'last_event, tpd_C_CARRYOUT((191 - 2)- 4*0), true),
			143 => (C_ipd(43)'last_event, tpd_C_CARRYOUT((191 - 2)- 4*0), true),
			144 => (C_ipd(44)'last_event, tpd_C_CARRYOUT((191 - 2)- 4*0), true),
			145 => (C_ipd(45)'last_event, tpd_C_CARRYOUT((191 - 2)- 4*0), true),
			146 => (C_ipd(46)'last_event, tpd_C_CARRYOUT((191 - 2)- 4*0), true),
			147 => (C_ipd(47)'last_event, tpd_C_CARRYOUT((191 - 2)- 4*0), true),
			148 => (CARRYCASCIN_ipd'last_event, tpd_CARRYCASCIN_CARRYOUT(1), true),
			149 => (CARRYIN_ipd'last_event, tpd_CARRYIN_CARRYOUT(1), true),
			150 => (CARRYINSEL_ipd(0)'last_event, tpd_CARRYINSEL_CARRYOUT((11 - 2)- 4*0), true),
			151 => (CARRYINSEL_ipd(1)'last_event, tpd_CARRYINSEL_CARRYOUT((11 - 2)- 4*0), true),
			152 => (CARRYINSEL_ipd(2)'last_event, tpd_CARRYINSEL_CARRYOUT((11 - 2)- 4*0), true),
			153 => (MULTSIGNIN_ipd'last_event, tpd_MULTSIGNIN_CARRYOUT(1), true),
			154 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_CARRYOUT((27 - 2)- 4*0), true),
			155 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_CARRYOUT((27 - 2)- 4*0), true),
			156 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_CARRYOUT((27 - 2)- 4*0), true),
			157 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_CARRYOUT((27 - 2)- 4*0), true),
			158 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_CARRYOUT((27 - 2)- 4*0), true),
			159 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_CARRYOUT((27 - 2)- 4*0), true),
			160 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_CARRYOUT((27 - 2)- 4*0), true),
			161 => (PCIN_ipd(0)'last_event, tpd_PCIN_CARRYOUT((191 - 2)- 4*0), true),
			162 => (PCIN_ipd(1)'last_event, tpd_PCIN_CARRYOUT((191 - 2)- 4*0), true),
			163 => (PCIN_ipd(2)'last_event, tpd_PCIN_CARRYOUT((191 - 2)- 4*0), true),
			164 => (PCIN_ipd(3)'last_event, tpd_PCIN_CARRYOUT((191 - 2)- 4*0), true),
			165 => (PCIN_ipd(4)'last_event, tpd_PCIN_CARRYOUT((191 - 2)- 4*0), true),
			166 => (PCIN_ipd(5)'last_event, tpd_PCIN_CARRYOUT((191 - 2)- 4*0), true),
			167 => (PCIN_ipd(6)'last_event, tpd_PCIN_CARRYOUT((191 - 2)- 4*0), true),
			168 => (PCIN_ipd(7)'last_event, tpd_PCIN_CARRYOUT((191 - 2)- 4*0), true),
			169 => (PCIN_ipd(8)'last_event, tpd_PCIN_CARRYOUT((191 - 2)- 4*0), true),
			170 => (PCIN_ipd(9)'last_event, tpd_PCIN_CARRYOUT((191 - 2)- 4*0), true),
			171 => (PCIN_ipd(10)'last_event, tpd_PCIN_CARRYOUT((191 - 2)- 4*0), true),
			172 => (PCIN_ipd(11)'last_event, tpd_PCIN_CARRYOUT((191 - 2)- 4*0), true),
			173 => (PCIN_ipd(12)'last_event, tpd_PCIN_CARRYOUT((191 - 2)- 4*0), true),
			174 => (PCIN_ipd(13)'last_event, tpd_PCIN_CARRYOUT((191 - 2)- 4*0), true),
			175 => (PCIN_ipd(14)'last_event, tpd_PCIN_CARRYOUT((191 - 2)- 4*0), true),
			176 => (PCIN_ipd(15)'last_event, tpd_PCIN_CARRYOUT((191 - 2)- 4*0), true),
			177 => (PCIN_ipd(16)'last_event, tpd_PCIN_CARRYOUT((191 - 2)- 4*0), true),
			178 => (PCIN_ipd(17)'last_event, tpd_PCIN_CARRYOUT((191 - 2)- 4*0), true),
			179 => (PCIN_ipd(18)'last_event, tpd_PCIN_CARRYOUT((191 - 2)- 4*0), true),
			180 => (PCIN_ipd(19)'last_event, tpd_PCIN_CARRYOUT((191 - 2)- 4*0), true),
			181 => (PCIN_ipd(20)'last_event, tpd_PCIN_CARRYOUT((191 - 2)- 4*0), true),
			182 => (PCIN_ipd(21)'last_event, tpd_PCIN_CARRYOUT((191 - 2)- 4*0), true),
			183 => (PCIN_ipd(22)'last_event, tpd_PCIN_CARRYOUT((191 - 2)- 4*0), true),
			184 => (PCIN_ipd(23)'last_event, tpd_PCIN_CARRYOUT((191 - 2)- 4*0), true),
			185 => (PCIN_ipd(24)'last_event, tpd_PCIN_CARRYOUT((191 - 2)- 4*0), true),
			186 => (PCIN_ipd(25)'last_event, tpd_PCIN_CARRYOUT((191 - 2)- 4*0), true),
			187 => (PCIN_ipd(26)'last_event, tpd_PCIN_CARRYOUT((191 - 2)- 4*0), true),
			188 => (PCIN_ipd(27)'last_event, tpd_PCIN_CARRYOUT((191 - 2)- 4*0), true),
			189 => (PCIN_ipd(28)'last_event, tpd_PCIN_CARRYOUT((191 - 2)- 4*0), true),
			190 => (PCIN_ipd(29)'last_event, tpd_PCIN_CARRYOUT((191 - 2)- 4*0), true),
			191 => (PCIN_ipd(30)'last_event, tpd_PCIN_CARRYOUT((191 - 2)- 4*0), true),
			192 => (PCIN_ipd(31)'last_event, tpd_PCIN_CARRYOUT((191 - 2)- 4*0), true),
			193 => (PCIN_ipd(32)'last_event, tpd_PCIN_CARRYOUT((191 - 2)- 4*0), true),
			194 => (PCIN_ipd(33)'last_event, tpd_PCIN_CARRYOUT((191 - 2)- 4*0), true),
			195 => (PCIN_ipd(34)'last_event, tpd_PCIN_CARRYOUT((191 - 2)- 4*0), true),
			196 => (PCIN_ipd(35)'last_event, tpd_PCIN_CARRYOUT((191 - 2)- 4*0), true),
			197 => (PCIN_ipd(36)'last_event, tpd_PCIN_CARRYOUT((191 - 2)- 4*0), true),
			198 => (PCIN_ipd(37)'last_event, tpd_PCIN_CARRYOUT((191 - 2)- 4*0), true),
			199 => (PCIN_ipd(38)'last_event, tpd_PCIN_CARRYOUT((191 - 2)- 4*0), true),
			200 => (PCIN_ipd(39)'last_event, tpd_PCIN_CARRYOUT((191 - 2)- 4*0), true),
			201 => (PCIN_ipd(40)'last_event, tpd_PCIN_CARRYOUT((191 - 2)- 4*0), true),
			202 => (PCIN_ipd(41)'last_event, tpd_PCIN_CARRYOUT((191 - 2)- 4*0), true),
			203 => (PCIN_ipd(42)'last_event, tpd_PCIN_CARRYOUT((191 - 2)- 4*0), true),
			204 => (PCIN_ipd(43)'last_event, tpd_PCIN_CARRYOUT((191 - 2)- 4*0), true),
			205 => (PCIN_ipd(44)'last_event, tpd_PCIN_CARRYOUT((191 - 2)- 4*0), true),
			206 => (PCIN_ipd(45)'last_event, tpd_PCIN_CARRYOUT((191 - 2)- 4*0), true),
			207 => (PCIN_ipd(46)'last_event, tpd_PCIN_CARRYOUT((191 - 2)- 4*0), true),
			208 => (PCIN_ipd(47)'last_event, tpd_PCIN_CARRYOUT((191 - 2)- 4*0), true),
			209 => (CLK_dly'last_event, tpd_CLK_CARRYOUT(1), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> CARRYOUT(0),
         GlitchData	=> CARRYOUT_GlitchData(0),
         OutSignalName	=> "CARRYOUT(0)",
         OutTemp	=> CARRYOUT_zd(0),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_CARRYOUT((119 - 3)- 4*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_CARRYOUT((119 - 3)- 4*0), true),
			2 => (A_ipd(2)'last_event, tpd_A_CARRYOUT((119 - 3)- 4*0), true),
			3 => (A_ipd(3)'last_event, tpd_A_CARRYOUT((119 - 3)- 4*0), true),
			4 => (A_ipd(4)'last_event, tpd_A_CARRYOUT((119 - 3)- 4*0), true),
			5 => (A_ipd(5)'last_event, tpd_A_CARRYOUT((119 - 3)- 4*0), true),
			6 => (A_ipd(6)'last_event, tpd_A_CARRYOUT((119 - 3)- 4*0), true),
			7 => (A_ipd(7)'last_event, tpd_A_CARRYOUT((119 - 3)- 4*0), true),
			8 => (A_ipd(8)'last_event, tpd_A_CARRYOUT((119 - 3)- 4*0), true),
			9 => (A_ipd(9)'last_event, tpd_A_CARRYOUT((119 - 3)- 4*0), true),
			10 => (A_ipd(10)'last_event, tpd_A_CARRYOUT((119 - 3)- 4*0), true),
			11 => (A_ipd(11)'last_event, tpd_A_CARRYOUT((119 - 3)- 4*0), true),
			12 => (A_ipd(12)'last_event, tpd_A_CARRYOUT((119 - 3)- 4*0), true),
			13 => (A_ipd(13)'last_event, tpd_A_CARRYOUT((119 - 3)- 4*0), true),
			14 => (A_ipd(14)'last_event, tpd_A_CARRYOUT((119 - 3)- 4*0), true),
			15 => (A_ipd(15)'last_event, tpd_A_CARRYOUT((119 - 3)- 4*0), true),
			16 => (A_ipd(16)'last_event, tpd_A_CARRYOUT((119 - 3)- 4*0), true),
			17 => (A_ipd(17)'last_event, tpd_A_CARRYOUT((119 - 3)- 4*0), true),
			18 => (A_ipd(18)'last_event, tpd_A_CARRYOUT((119 - 3)- 4*0), true),
			19 => (A_ipd(19)'last_event, tpd_A_CARRYOUT((119 - 3)- 4*0), true),
			20 => (A_ipd(20)'last_event, tpd_A_CARRYOUT((119 - 3)- 4*0), true),
			21 => (A_ipd(21)'last_event, tpd_A_CARRYOUT((119 - 3)- 4*0), true),
			22 => (A_ipd(22)'last_event, tpd_A_CARRYOUT((119 - 3)- 4*0), true),
			23 => (A_ipd(23)'last_event, tpd_A_CARRYOUT((119 - 3)- 4*0), true),
			24 => (A_ipd(24)'last_event, tpd_A_CARRYOUT((119 - 3)- 4*0), true),
			25 => (A_ipd(25)'last_event, tpd_A_CARRYOUT((119 - 3)- 4*0), true),
			26 => (A_ipd(26)'last_event, tpd_A_CARRYOUT((119 - 3)- 4*0), true),
			27 => (A_ipd(27)'last_event, tpd_A_CARRYOUT((119 - 3)- 4*0), true),
			28 => (A_ipd(28)'last_event, tpd_A_CARRYOUT((119 - 3)- 4*0), true),
			29 => (A_ipd(29)'last_event, tpd_A_CARRYOUT((119 - 3)- 4*0), true),
			30 => (ACIN_ipd(0)'last_event, tpd_ACIN_CARRYOUT((119 - 3)- 4*0), true),
			31 => (ACIN_ipd(1)'last_event, tpd_ACIN_CARRYOUT((119 - 3)- 4*0), true),
			32 => (ACIN_ipd(2)'last_event, tpd_ACIN_CARRYOUT((119 - 3)- 4*0), true),
			33 => (ACIN_ipd(3)'last_event, tpd_ACIN_CARRYOUT((119 - 3)- 4*0), true),
			34 => (ACIN_ipd(4)'last_event, tpd_ACIN_CARRYOUT((119 - 3)- 4*0), true),
			35 => (ACIN_ipd(5)'last_event, tpd_ACIN_CARRYOUT((119 - 3)- 4*0), true),
			36 => (ACIN_ipd(6)'last_event, tpd_ACIN_CARRYOUT((119 - 3)- 4*0), true),
			37 => (ACIN_ipd(7)'last_event, tpd_ACIN_CARRYOUT((119 - 3)- 4*0), true),
			38 => (ACIN_ipd(8)'last_event, tpd_ACIN_CARRYOUT((119 - 3)- 4*0), true),
			39 => (ACIN_ipd(9)'last_event, tpd_ACIN_CARRYOUT((119 - 3)- 4*0), true),
			40 => (ACIN_ipd(10)'last_event, tpd_ACIN_CARRYOUT((119 - 3)- 4*0), true),
			41 => (ACIN_ipd(11)'last_event, tpd_ACIN_CARRYOUT((119 - 3)- 4*0), true),
			42 => (ACIN_ipd(12)'last_event, tpd_ACIN_CARRYOUT((119 - 3)- 4*0), true),
			43 => (ACIN_ipd(13)'last_event, tpd_ACIN_CARRYOUT((119 - 3)- 4*0), true),
			44 => (ACIN_ipd(14)'last_event, tpd_ACIN_CARRYOUT((119 - 3)- 4*0), true),
			45 => (ACIN_ipd(15)'last_event, tpd_ACIN_CARRYOUT((119 - 3)- 4*0), true),
			46 => (ACIN_ipd(16)'last_event, tpd_ACIN_CARRYOUT((119 - 3)- 4*0), true),
			47 => (ACIN_ipd(17)'last_event, tpd_ACIN_CARRYOUT((119 - 3)- 4*0), true),
			48 => (ACIN_ipd(18)'last_event, tpd_ACIN_CARRYOUT((119 - 3)- 4*0), true),
			49 => (ACIN_ipd(19)'last_event, tpd_ACIN_CARRYOUT((119 - 3)- 4*0), true),
			50 => (ACIN_ipd(20)'last_event, tpd_ACIN_CARRYOUT((119 - 3)- 4*0), true),
			51 => (ACIN_ipd(21)'last_event, tpd_ACIN_CARRYOUT((119 - 3)- 4*0), true),
			52 => (ACIN_ipd(22)'last_event, tpd_ACIN_CARRYOUT((119 - 3)- 4*0), true),
			53 => (ACIN_ipd(23)'last_event, tpd_ACIN_CARRYOUT((119 - 3)- 4*0), true),
			54 => (ACIN_ipd(24)'last_event, tpd_ACIN_CARRYOUT((119 - 3)- 4*0), true),
			55 => (ACIN_ipd(25)'last_event, tpd_ACIN_CARRYOUT((119 - 3)- 4*0), true),
			56 => (ACIN_ipd(26)'last_event, tpd_ACIN_CARRYOUT((119 - 3)- 4*0), true),
			57 => (ACIN_ipd(27)'last_event, tpd_ACIN_CARRYOUT((119 - 3)- 4*0), true),
			58 => (ACIN_ipd(28)'last_event, tpd_ACIN_CARRYOUT((119 - 3)- 4*0), true),
			59 => (ACIN_ipd(29)'last_event, tpd_ACIN_CARRYOUT((119 - 3)- 4*0), true),
			60 => (ALUMODE_ipd(0)'last_event, tpd_ALUMODE_CARRYOUT((15 - 3)- 4*0), true),
			61 => (ALUMODE_ipd(1)'last_event, tpd_ALUMODE_CARRYOUT((15 - 3)- 4*0), true),
			62 => (ALUMODE_ipd(2)'last_event, tpd_ALUMODE_CARRYOUT((15 - 3)- 4*0), true),
			63 => (ALUMODE_ipd(3)'last_event, tpd_ALUMODE_CARRYOUT((15 - 3)- 4*0), true),
			64 => (B_ipd(0)'last_event, tpd_B_CARRYOUT((71 - 3)- 4*0), true),
			65 => (B_ipd(1)'last_event, tpd_B_CARRYOUT((71 - 3)- 4*0), true),
			66 => (B_ipd(2)'last_event, tpd_B_CARRYOUT((71 - 3)- 4*0), true),
			67 => (B_ipd(3)'last_event, tpd_B_CARRYOUT((71 - 3)- 4*0), true),
			68 => (B_ipd(4)'last_event, tpd_B_CARRYOUT((71 - 3)- 4*0), true),
			69 => (B_ipd(5)'last_event, tpd_B_CARRYOUT((71 - 3)- 4*0), true),
			70 => (B_ipd(6)'last_event, tpd_B_CARRYOUT((71 - 3)- 4*0), true),
			71 => (B_ipd(7)'last_event, tpd_B_CARRYOUT((71 - 3)- 4*0), true),
			72 => (B_ipd(8)'last_event, tpd_B_CARRYOUT((71 - 3)- 4*0), true),
			73 => (B_ipd(9)'last_event, tpd_B_CARRYOUT((71 - 3)- 4*0), true),
			74 => (B_ipd(10)'last_event, tpd_B_CARRYOUT((71 - 3)- 4*0), true),
			75 => (B_ipd(11)'last_event, tpd_B_CARRYOUT((71 - 3)- 4*0), true),
			76 => (B_ipd(12)'last_event, tpd_B_CARRYOUT((71 - 3)- 4*0), true),
			77 => (B_ipd(13)'last_event, tpd_B_CARRYOUT((71 - 3)- 4*0), true),
			78 => (B_ipd(14)'last_event, tpd_B_CARRYOUT((71 - 3)- 4*0), true),
			79 => (B_ipd(15)'last_event, tpd_B_CARRYOUT((71 - 3)- 4*0), true),
			80 => (B_ipd(16)'last_event, tpd_B_CARRYOUT((71 - 3)- 4*0), true),
			81 => (B_ipd(17)'last_event, tpd_B_CARRYOUT((71 - 3)- 4*0), true),
			82 => (BCIN_ipd(0)'last_event, tpd_BCIN_CARRYOUT((71 - 3)- 4*0), true),
			83 => (BCIN_ipd(1)'last_event, tpd_BCIN_CARRYOUT((71 - 3)- 4*0), true),
			84 => (BCIN_ipd(2)'last_event, tpd_BCIN_CARRYOUT((71 - 3)- 4*0), true),
			85 => (BCIN_ipd(3)'last_event, tpd_BCIN_CARRYOUT((71 - 3)- 4*0), true),
			86 => (BCIN_ipd(4)'last_event, tpd_BCIN_CARRYOUT((71 - 3)- 4*0), true),
			87 => (BCIN_ipd(5)'last_event, tpd_BCIN_CARRYOUT((71 - 3)- 4*0), true),
			88 => (BCIN_ipd(6)'last_event, tpd_BCIN_CARRYOUT((71 - 3)- 4*0), true),
			89 => (BCIN_ipd(7)'last_event, tpd_BCIN_CARRYOUT((71 - 3)- 4*0), true),
			90 => (BCIN_ipd(8)'last_event, tpd_BCIN_CARRYOUT((71 - 3)- 4*0), true),
			91 => (BCIN_ipd(9)'last_event, tpd_BCIN_CARRYOUT((71 - 3)- 4*0), true),
			92 => (BCIN_ipd(10)'last_event, tpd_BCIN_CARRYOUT((71 - 3)- 4*0), true),
			93 => (BCIN_ipd(11)'last_event, tpd_BCIN_CARRYOUT((71 - 3)- 4*0), true),
			94 => (BCIN_ipd(12)'last_event, tpd_BCIN_CARRYOUT((71 - 3)- 4*0), true),
			95 => (BCIN_ipd(13)'last_event, tpd_BCIN_CARRYOUT((71 - 3)- 4*0), true),
			96 => (BCIN_ipd(14)'last_event, tpd_BCIN_CARRYOUT((71 - 3)- 4*0), true),
			97 => (BCIN_ipd(15)'last_event, tpd_BCIN_CARRYOUT((71 - 3)- 4*0), true),
			98 => (BCIN_ipd(16)'last_event, tpd_BCIN_CARRYOUT((71 - 3)- 4*0), true),
			99 => (BCIN_ipd(17)'last_event, tpd_BCIN_CARRYOUT((71 - 3)- 4*0), true),
			100 => (C_ipd(0)'last_event, tpd_C_CARRYOUT((191 - 3)- 4*0), true),
			101 => (C_ipd(1)'last_event, tpd_C_CARRYOUT((191 - 3)- 4*0), true),
			102 => (C_ipd(2)'last_event, tpd_C_CARRYOUT((191 - 3)- 4*0), true),
			103 => (C_ipd(3)'last_event, tpd_C_CARRYOUT((191 - 3)- 4*0), true),
			104 => (C_ipd(4)'last_event, tpd_C_CARRYOUT((191 - 3)- 4*0), true),
			105 => (C_ipd(5)'last_event, tpd_C_CARRYOUT((191 - 3)- 4*0), true),
			106 => (C_ipd(6)'last_event, tpd_C_CARRYOUT((191 - 3)- 4*0), true),
			107 => (C_ipd(7)'last_event, tpd_C_CARRYOUT((191 - 3)- 4*0), true),
			108 => (C_ipd(8)'last_event, tpd_C_CARRYOUT((191 - 3)- 4*0), true),
			109 => (C_ipd(9)'last_event, tpd_C_CARRYOUT((191 - 3)- 4*0), true),
			110 => (C_ipd(10)'last_event, tpd_C_CARRYOUT((191 - 3)- 4*0), true),
			111 => (C_ipd(11)'last_event, tpd_C_CARRYOUT((191 - 3)- 4*0), true),
			112 => (C_ipd(12)'last_event, tpd_C_CARRYOUT((191 - 3)- 4*0), true),
			113 => (C_ipd(13)'last_event, tpd_C_CARRYOUT((191 - 3)- 4*0), true),
			114 => (C_ipd(14)'last_event, tpd_C_CARRYOUT((191 - 3)- 4*0), true),
			115 => (C_ipd(15)'last_event, tpd_C_CARRYOUT((191 - 3)- 4*0), true),
			116 => (C_ipd(16)'last_event, tpd_C_CARRYOUT((191 - 3)- 4*0), true),
			117 => (C_ipd(17)'last_event, tpd_C_CARRYOUT((191 - 3)- 4*0), true),
			118 => (C_ipd(18)'last_event, tpd_C_CARRYOUT((191 - 3)- 4*0), true),
			119 => (C_ipd(19)'last_event, tpd_C_CARRYOUT((191 - 3)- 4*0), true),
			120 => (C_ipd(20)'last_event, tpd_C_CARRYOUT((191 - 3)- 4*0), true),
			121 => (C_ipd(21)'last_event, tpd_C_CARRYOUT((191 - 3)- 4*0), true),
			122 => (C_ipd(22)'last_event, tpd_C_CARRYOUT((191 - 3)- 4*0), true),
			123 => (C_ipd(23)'last_event, tpd_C_CARRYOUT((191 - 3)- 4*0), true),
			124 => (C_ipd(24)'last_event, tpd_C_CARRYOUT((191 - 3)- 4*0), true),
			125 => (C_ipd(25)'last_event, tpd_C_CARRYOUT((191 - 3)- 4*0), true),
			126 => (C_ipd(26)'last_event, tpd_C_CARRYOUT((191 - 3)- 4*0), true),
			127 => (C_ipd(27)'last_event, tpd_C_CARRYOUT((191 - 3)- 4*0), true),
			128 => (C_ipd(28)'last_event, tpd_C_CARRYOUT((191 - 3)- 4*0), true),
			129 => (C_ipd(29)'last_event, tpd_C_CARRYOUT((191 - 3)- 4*0), true),
			130 => (C_ipd(30)'last_event, tpd_C_CARRYOUT((191 - 3)- 4*0), true),
			131 => (C_ipd(31)'last_event, tpd_C_CARRYOUT((191 - 3)- 4*0), true),
			132 => (C_ipd(32)'last_event, tpd_C_CARRYOUT((191 - 3)- 4*0), true),
			133 => (C_ipd(33)'last_event, tpd_C_CARRYOUT((191 - 3)- 4*0), true),
			134 => (C_ipd(34)'last_event, tpd_C_CARRYOUT((191 - 3)- 4*0), true),
			135 => (C_ipd(35)'last_event, tpd_C_CARRYOUT((191 - 3)- 4*0), true),
			136 => (C_ipd(36)'last_event, tpd_C_CARRYOUT((191 - 3)- 4*0), true),
			137 => (C_ipd(37)'last_event, tpd_C_CARRYOUT((191 - 3)- 4*0), true),
			138 => (C_ipd(38)'last_event, tpd_C_CARRYOUT((191 - 3)- 4*0), true),
			139 => (C_ipd(39)'last_event, tpd_C_CARRYOUT((191 - 3)- 4*0), true),
			140 => (C_ipd(40)'last_event, tpd_C_CARRYOUT((191 - 3)- 4*0), true),
			141 => (C_ipd(41)'last_event, tpd_C_CARRYOUT((191 - 3)- 4*0), true),
			142 => (C_ipd(42)'last_event, tpd_C_CARRYOUT((191 - 3)- 4*0), true),
			143 => (C_ipd(43)'last_event, tpd_C_CARRYOUT((191 - 3)- 4*0), true),
			144 => (C_ipd(44)'last_event, tpd_C_CARRYOUT((191 - 3)- 4*0), true),
			145 => (C_ipd(45)'last_event, tpd_C_CARRYOUT((191 - 3)- 4*0), true),
			146 => (C_ipd(46)'last_event, tpd_C_CARRYOUT((191 - 3)- 4*0), true),
			147 => (C_ipd(47)'last_event, tpd_C_CARRYOUT((191 - 3)- 4*0), true),
			148 => (CARRYCASCIN_ipd'last_event, tpd_CARRYCASCIN_CARRYOUT(0), true),
			149 => (CARRYIN_ipd'last_event, tpd_CARRYIN_CARRYOUT(0), true),
			150 => (CARRYINSEL_ipd(0)'last_event, tpd_CARRYINSEL_CARRYOUT((11 - 3)- 4*0), true),
			151 => (CARRYINSEL_ipd(1)'last_event, tpd_CARRYINSEL_CARRYOUT((11 - 3)- 4*0), true),
			152 => (CARRYINSEL_ipd(2)'last_event, tpd_CARRYINSEL_CARRYOUT((11 - 3)- 4*0), true),
			153 => (MULTSIGNIN_ipd'last_event, tpd_MULTSIGNIN_CARRYOUT(0), true),
			154 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_CARRYOUT((27 - 3)- 4*0), true),
			155 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_CARRYOUT((27 - 3)- 4*0), true),
			156 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_CARRYOUT((27 - 3)- 4*0), true),
			157 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_CARRYOUT((27 - 3)- 4*0), true),
			158 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_CARRYOUT((27 - 3)- 4*0), true),
			159 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_CARRYOUT((27 - 3)- 4*0), true),
			160 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_CARRYOUT((27 - 3)- 4*0), true),
			161 => (PCIN_ipd(0)'last_event, tpd_PCIN_CARRYOUT((191 - 3)- 4*0), true),
			162 => (PCIN_ipd(1)'last_event, tpd_PCIN_CARRYOUT((191 - 3)- 4*0), true),
			163 => (PCIN_ipd(2)'last_event, tpd_PCIN_CARRYOUT((191 - 3)- 4*0), true),
			164 => (PCIN_ipd(3)'last_event, tpd_PCIN_CARRYOUT((191 - 3)- 4*0), true),
			165 => (PCIN_ipd(4)'last_event, tpd_PCIN_CARRYOUT((191 - 3)- 4*0), true),
			166 => (PCIN_ipd(5)'last_event, tpd_PCIN_CARRYOUT((191 - 3)- 4*0), true),
			167 => (PCIN_ipd(6)'last_event, tpd_PCIN_CARRYOUT((191 - 3)- 4*0), true),
			168 => (PCIN_ipd(7)'last_event, tpd_PCIN_CARRYOUT((191 - 3)- 4*0), true),
			169 => (PCIN_ipd(8)'last_event, tpd_PCIN_CARRYOUT((191 - 3)- 4*0), true),
			170 => (PCIN_ipd(9)'last_event, tpd_PCIN_CARRYOUT((191 - 3)- 4*0), true),
			171 => (PCIN_ipd(10)'last_event, tpd_PCIN_CARRYOUT((191 - 3)- 4*0), true),
			172 => (PCIN_ipd(11)'last_event, tpd_PCIN_CARRYOUT((191 - 3)- 4*0), true),
			173 => (PCIN_ipd(12)'last_event, tpd_PCIN_CARRYOUT((191 - 3)- 4*0), true),
			174 => (PCIN_ipd(13)'last_event, tpd_PCIN_CARRYOUT((191 - 3)- 4*0), true),
			175 => (PCIN_ipd(14)'last_event, tpd_PCIN_CARRYOUT((191 - 3)- 4*0), true),
			176 => (PCIN_ipd(15)'last_event, tpd_PCIN_CARRYOUT((191 - 3)- 4*0), true),
			177 => (PCIN_ipd(16)'last_event, tpd_PCIN_CARRYOUT((191 - 3)- 4*0), true),
			178 => (PCIN_ipd(17)'last_event, tpd_PCIN_CARRYOUT((191 - 3)- 4*0), true),
			179 => (PCIN_ipd(18)'last_event, tpd_PCIN_CARRYOUT((191 - 3)- 4*0), true),
			180 => (PCIN_ipd(19)'last_event, tpd_PCIN_CARRYOUT((191 - 3)- 4*0), true),
			181 => (PCIN_ipd(20)'last_event, tpd_PCIN_CARRYOUT((191 - 3)- 4*0), true),
			182 => (PCIN_ipd(21)'last_event, tpd_PCIN_CARRYOUT((191 - 3)- 4*0), true),
			183 => (PCIN_ipd(22)'last_event, tpd_PCIN_CARRYOUT((191 - 3)- 4*0), true),
			184 => (PCIN_ipd(23)'last_event, tpd_PCIN_CARRYOUT((191 - 3)- 4*0), true),
			185 => (PCIN_ipd(24)'last_event, tpd_PCIN_CARRYOUT((191 - 3)- 4*0), true),
			186 => (PCIN_ipd(25)'last_event, tpd_PCIN_CARRYOUT((191 - 3)- 4*0), true),
			187 => (PCIN_ipd(26)'last_event, tpd_PCIN_CARRYOUT((191 - 3)- 4*0), true),
			188 => (PCIN_ipd(27)'last_event, tpd_PCIN_CARRYOUT((191 - 3)- 4*0), true),
			189 => (PCIN_ipd(28)'last_event, tpd_PCIN_CARRYOUT((191 - 3)- 4*0), true),
			190 => (PCIN_ipd(29)'last_event, tpd_PCIN_CARRYOUT((191 - 3)- 4*0), true),
			191 => (PCIN_ipd(30)'last_event, tpd_PCIN_CARRYOUT((191 - 3)- 4*0), true),
			192 => (PCIN_ipd(31)'last_event, tpd_PCIN_CARRYOUT((191 - 3)- 4*0), true),
			193 => (PCIN_ipd(32)'last_event, tpd_PCIN_CARRYOUT((191 - 3)- 4*0), true),
			194 => (PCIN_ipd(33)'last_event, tpd_PCIN_CARRYOUT((191 - 3)- 4*0), true),
			195 => (PCIN_ipd(34)'last_event, tpd_PCIN_CARRYOUT((191 - 3)- 4*0), true),
			196 => (PCIN_ipd(35)'last_event, tpd_PCIN_CARRYOUT((191 - 3)- 4*0), true),
			197 => (PCIN_ipd(36)'last_event, tpd_PCIN_CARRYOUT((191 - 3)- 4*0), true),
			198 => (PCIN_ipd(37)'last_event, tpd_PCIN_CARRYOUT((191 - 3)- 4*0), true),
			199 => (PCIN_ipd(38)'last_event, tpd_PCIN_CARRYOUT((191 - 3)- 4*0), true),
			200 => (PCIN_ipd(39)'last_event, tpd_PCIN_CARRYOUT((191 - 3)- 4*0), true),
			201 => (PCIN_ipd(40)'last_event, tpd_PCIN_CARRYOUT((191 - 3)- 4*0), true),
			202 => (PCIN_ipd(41)'last_event, tpd_PCIN_CARRYOUT((191 - 3)- 4*0), true),
			203 => (PCIN_ipd(42)'last_event, tpd_PCIN_CARRYOUT((191 - 3)- 4*0), true),
			204 => (PCIN_ipd(43)'last_event, tpd_PCIN_CARRYOUT((191 - 3)- 4*0), true),
			205 => (PCIN_ipd(44)'last_event, tpd_PCIN_CARRYOUT((191 - 3)- 4*0), true),
			206 => (PCIN_ipd(45)'last_event, tpd_PCIN_CARRYOUT((191 - 3)- 4*0), true),
			207 => (PCIN_ipd(46)'last_event, tpd_PCIN_CARRYOUT((191 - 3)- 4*0), true),
			208 => (PCIN_ipd(47)'last_event, tpd_PCIN_CARRYOUT((191 - 3)- 4*0), true),
			209 => (CLK_dly'last_event, tpd_CLK_CARRYOUT(0), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> MULTSIGNOUT,
         GlitchData	=> MULTSIGNOUT_GlitchData,
         OutSignalName	=> "MULTSIGNOUT",
         OutTemp	=> MULTSIGNOUT_zd,
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_MULTSIGNOUT((29 - 0)- 1*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_MULTSIGNOUT((29 - 0)- 1*0), true),
			2 => (A_ipd(2)'last_event, tpd_A_MULTSIGNOUT((29 - 0)- 1*0), true),
			3 => (A_ipd(3)'last_event, tpd_A_MULTSIGNOUT((29 - 0)- 1*0), true),
			4 => (A_ipd(4)'last_event, tpd_A_MULTSIGNOUT((29 - 0)- 1*0), true),
			5 => (A_ipd(5)'last_event, tpd_A_MULTSIGNOUT((29 - 0)- 1*0), true),
			6 => (A_ipd(6)'last_event, tpd_A_MULTSIGNOUT((29 - 0)- 1*0), true),
			7 => (A_ipd(7)'last_event, tpd_A_MULTSIGNOUT((29 - 0)- 1*0), true),
			8 => (A_ipd(8)'last_event, tpd_A_MULTSIGNOUT((29 - 0)- 1*0), true),
			9 => (A_ipd(9)'last_event, tpd_A_MULTSIGNOUT((29 - 0)- 1*0), true),
			10 => (A_ipd(10)'last_event, tpd_A_MULTSIGNOUT((29 - 0)- 1*0), true),
			11 => (A_ipd(11)'last_event, tpd_A_MULTSIGNOUT((29 - 0)- 1*0), true),
			12 => (A_ipd(12)'last_event, tpd_A_MULTSIGNOUT((29 - 0)- 1*0), true),
			13 => (A_ipd(13)'last_event, tpd_A_MULTSIGNOUT((29 - 0)- 1*0), true),
			14 => (A_ipd(14)'last_event, tpd_A_MULTSIGNOUT((29 - 0)- 1*0), true),
			15 => (A_ipd(15)'last_event, tpd_A_MULTSIGNOUT((29 - 0)- 1*0), true),
			16 => (A_ipd(16)'last_event, tpd_A_MULTSIGNOUT((29 - 0)- 1*0), true),
			17 => (A_ipd(17)'last_event, tpd_A_MULTSIGNOUT((29 - 0)- 1*0), true),
			18 => (A_ipd(18)'last_event, tpd_A_MULTSIGNOUT((29 - 0)- 1*0), true),
			19 => (A_ipd(19)'last_event, tpd_A_MULTSIGNOUT((29 - 0)- 1*0), true),
			20 => (A_ipd(20)'last_event, tpd_A_MULTSIGNOUT((29 - 0)- 1*0), true),
			21 => (A_ipd(21)'last_event, tpd_A_MULTSIGNOUT((29 - 0)- 1*0), true),
			22 => (A_ipd(22)'last_event, tpd_A_MULTSIGNOUT((29 - 0)- 1*0), true),
			23 => (A_ipd(23)'last_event, tpd_A_MULTSIGNOUT((29 - 0)- 1*0), true),
			24 => (A_ipd(24)'last_event, tpd_A_MULTSIGNOUT((29 - 0)- 1*0), true),
			25 => (A_ipd(25)'last_event, tpd_A_MULTSIGNOUT((29 - 0)- 1*0), true),
			26 => (A_ipd(26)'last_event, tpd_A_MULTSIGNOUT((29 - 0)- 1*0), true),
			27 => (A_ipd(27)'last_event, tpd_A_MULTSIGNOUT((29 - 0)- 1*0), true),
			28 => (A_ipd(28)'last_event, tpd_A_MULTSIGNOUT((29 - 0)- 1*0), true),
			29 => (A_ipd(29)'last_event, tpd_A_MULTSIGNOUT((29 - 0)- 1*0), true),
			30 => (ACIN_ipd(0)'last_event, tpd_ACIN_MULTSIGNOUT((29 - 0)- 1*0), true),
			31 => (ACIN_ipd(1)'last_event, tpd_ACIN_MULTSIGNOUT((29 - 0)- 1*0), true),
			32 => (ACIN_ipd(2)'last_event, tpd_ACIN_MULTSIGNOUT((29 - 0)- 1*0), true),
			33 => (ACIN_ipd(3)'last_event, tpd_ACIN_MULTSIGNOUT((29 - 0)- 1*0), true),
			34 => (ACIN_ipd(4)'last_event, tpd_ACIN_MULTSIGNOUT((29 - 0)- 1*0), true),
			35 => (ACIN_ipd(5)'last_event, tpd_ACIN_MULTSIGNOUT((29 - 0)- 1*0), true),
			36 => (ACIN_ipd(6)'last_event, tpd_ACIN_MULTSIGNOUT((29 - 0)- 1*0), true),
			37 => (ACIN_ipd(7)'last_event, tpd_ACIN_MULTSIGNOUT((29 - 0)- 1*0), true),
			38 => (ACIN_ipd(8)'last_event, tpd_ACIN_MULTSIGNOUT((29 - 0)- 1*0), true),
			39 => (ACIN_ipd(9)'last_event, tpd_ACIN_MULTSIGNOUT((29 - 0)- 1*0), true),
			40 => (ACIN_ipd(10)'last_event, tpd_ACIN_MULTSIGNOUT((29 - 0)- 1*0), true),
			41 => (ACIN_ipd(11)'last_event, tpd_ACIN_MULTSIGNOUT((29 - 0)- 1*0), true),
			42 => (ACIN_ipd(12)'last_event, tpd_ACIN_MULTSIGNOUT((29 - 0)- 1*0), true),
			43 => (ACIN_ipd(13)'last_event, tpd_ACIN_MULTSIGNOUT((29 - 0)- 1*0), true),
			44 => (ACIN_ipd(14)'last_event, tpd_ACIN_MULTSIGNOUT((29 - 0)- 1*0), true),
			45 => (ACIN_ipd(15)'last_event, tpd_ACIN_MULTSIGNOUT((29 - 0)- 1*0), true),
			46 => (ACIN_ipd(16)'last_event, tpd_ACIN_MULTSIGNOUT((29 - 0)- 1*0), true),
			47 => (ACIN_ipd(17)'last_event, tpd_ACIN_MULTSIGNOUT((29 - 0)- 1*0), true),
			48 => (ACIN_ipd(18)'last_event, tpd_ACIN_MULTSIGNOUT((29 - 0)- 1*0), true),
			49 => (ACIN_ipd(19)'last_event, tpd_ACIN_MULTSIGNOUT((29 - 0)- 1*0), true),
			50 => (ACIN_ipd(20)'last_event, tpd_ACIN_MULTSIGNOUT((29 - 0)- 1*0), true),
			51 => (ACIN_ipd(21)'last_event, tpd_ACIN_MULTSIGNOUT((29 - 0)- 1*0), true),
			52 => (ACIN_ipd(22)'last_event, tpd_ACIN_MULTSIGNOUT((29 - 0)- 1*0), true),
			53 => (ACIN_ipd(23)'last_event, tpd_ACIN_MULTSIGNOUT((29 - 0)- 1*0), true),
			54 => (ACIN_ipd(24)'last_event, tpd_ACIN_MULTSIGNOUT((29 - 0)- 1*0), true),
			55 => (ACIN_ipd(25)'last_event, tpd_ACIN_MULTSIGNOUT((29 - 0)- 1*0), true),
			56 => (ACIN_ipd(26)'last_event, tpd_ACIN_MULTSIGNOUT((29 - 0)- 1*0), true),
			57 => (ACIN_ipd(27)'last_event, tpd_ACIN_MULTSIGNOUT((29 - 0)- 1*0), true),
			58 => (ACIN_ipd(28)'last_event, tpd_ACIN_MULTSIGNOUT((29 - 0)- 1*0), true),
			59 => (ACIN_ipd(29)'last_event, tpd_ACIN_MULTSIGNOUT((29 - 0)- 1*0), true),
			60 => (ALUMODE_ipd(0)'last_event, tpd_ALUMODE_MULTSIGNOUT((3 - 0)- 1*0), true),
			61 => (ALUMODE_ipd(1)'last_event, tpd_ALUMODE_MULTSIGNOUT((3 - 0)- 1*0), true),
			62 => (ALUMODE_ipd(2)'last_event, tpd_ALUMODE_MULTSIGNOUT((3 - 0)- 1*0), true),
			63 => (ALUMODE_ipd(3)'last_event, tpd_ALUMODE_MULTSIGNOUT((3 - 0)- 1*0), true),
			64 => (B_ipd(0)'last_event, tpd_B_MULTSIGNOUT((17 - 0)- 1*0), true),
			65 => (B_ipd(1)'last_event, tpd_B_MULTSIGNOUT((17 - 0)- 1*0), true),
			66 => (B_ipd(2)'last_event, tpd_B_MULTSIGNOUT((17 - 0)- 1*0), true),
			67 => (B_ipd(3)'last_event, tpd_B_MULTSIGNOUT((17 - 0)- 1*0), true),
			68 => (B_ipd(4)'last_event, tpd_B_MULTSIGNOUT((17 - 0)- 1*0), true),
			69 => (B_ipd(5)'last_event, tpd_B_MULTSIGNOUT((17 - 0)- 1*0), true),
			70 => (B_ipd(6)'last_event, tpd_B_MULTSIGNOUT((17 - 0)- 1*0), true),
			71 => (B_ipd(7)'last_event, tpd_B_MULTSIGNOUT((17 - 0)- 1*0), true),
			72 => (B_ipd(8)'last_event, tpd_B_MULTSIGNOUT((17 - 0)- 1*0), true),
			73 => (B_ipd(9)'last_event, tpd_B_MULTSIGNOUT((17 - 0)- 1*0), true),
			74 => (B_ipd(10)'last_event, tpd_B_MULTSIGNOUT((17 - 0)- 1*0), true),
			75 => (B_ipd(11)'last_event, tpd_B_MULTSIGNOUT((17 - 0)- 1*0), true),
			76 => (B_ipd(12)'last_event, tpd_B_MULTSIGNOUT((17 - 0)- 1*0), true),
			77 => (B_ipd(13)'last_event, tpd_B_MULTSIGNOUT((17 - 0)- 1*0), true),
			78 => (B_ipd(14)'last_event, tpd_B_MULTSIGNOUT((17 - 0)- 1*0), true),
			79 => (B_ipd(15)'last_event, tpd_B_MULTSIGNOUT((17 - 0)- 1*0), true),
			80 => (B_ipd(16)'last_event, tpd_B_MULTSIGNOUT((17 - 0)- 1*0), true),
			81 => (B_ipd(17)'last_event, tpd_B_MULTSIGNOUT((17 - 0)- 1*0), true),
			82 => (BCIN_ipd(0)'last_event, tpd_BCIN_MULTSIGNOUT((17 - 0)- 1*0), true),
			83 => (BCIN_ipd(1)'last_event, tpd_BCIN_MULTSIGNOUT((17 - 0)- 1*0), true),
			84 => (BCIN_ipd(2)'last_event, tpd_BCIN_MULTSIGNOUT((17 - 0)- 1*0), true),
			85 => (BCIN_ipd(3)'last_event, tpd_BCIN_MULTSIGNOUT((17 - 0)- 1*0), true),
			86 => (BCIN_ipd(4)'last_event, tpd_BCIN_MULTSIGNOUT((17 - 0)- 1*0), true),
			87 => (BCIN_ipd(5)'last_event, tpd_BCIN_MULTSIGNOUT((17 - 0)- 1*0), true),
			88 => (BCIN_ipd(6)'last_event, tpd_BCIN_MULTSIGNOUT((17 - 0)- 1*0), true),
			89 => (BCIN_ipd(7)'last_event, tpd_BCIN_MULTSIGNOUT((17 - 0)- 1*0), true),
			90 => (BCIN_ipd(8)'last_event, tpd_BCIN_MULTSIGNOUT((17 - 0)- 1*0), true),
			91 => (BCIN_ipd(9)'last_event, tpd_BCIN_MULTSIGNOUT((17 - 0)- 1*0), true),
			92 => (BCIN_ipd(10)'last_event, tpd_BCIN_MULTSIGNOUT((17 - 0)- 1*0), true),
			93 => (BCIN_ipd(11)'last_event, tpd_BCIN_MULTSIGNOUT((17 - 0)- 1*0), true),
			94 => (BCIN_ipd(12)'last_event, tpd_BCIN_MULTSIGNOUT((17 - 0)- 1*0), true),
			95 => (BCIN_ipd(13)'last_event, tpd_BCIN_MULTSIGNOUT((17 - 0)- 1*0), true),
			96 => (BCIN_ipd(14)'last_event, tpd_BCIN_MULTSIGNOUT((17 - 0)- 1*0), true),
			97 => (BCIN_ipd(15)'last_event, tpd_BCIN_MULTSIGNOUT((17 - 0)- 1*0), true),
			98 => (BCIN_ipd(16)'last_event, tpd_BCIN_MULTSIGNOUT((17 - 0)- 1*0), true),
			99 => (BCIN_ipd(17)'last_event, tpd_BCIN_MULTSIGNOUT((17 - 0)- 1*0), true),
			100 => (C_ipd(0)'last_event, tpd_C_MULTSIGNOUT((47 - 0)- 1*0), true),
			101 => (C_ipd(1)'last_event, tpd_C_MULTSIGNOUT((47 - 0)- 1*0), true),
			102 => (C_ipd(2)'last_event, tpd_C_MULTSIGNOUT((47 - 0)- 1*0), true),
			103 => (C_ipd(3)'last_event, tpd_C_MULTSIGNOUT((47 - 0)- 1*0), true),
			104 => (C_ipd(4)'last_event, tpd_C_MULTSIGNOUT((47 - 0)- 1*0), true),
			105 => (C_ipd(5)'last_event, tpd_C_MULTSIGNOUT((47 - 0)- 1*0), true),
			106 => (C_ipd(6)'last_event, tpd_C_MULTSIGNOUT((47 - 0)- 1*0), true),
			107 => (C_ipd(7)'last_event, tpd_C_MULTSIGNOUT((47 - 0)- 1*0), true),
			108 => (C_ipd(8)'last_event, tpd_C_MULTSIGNOUT((47 - 0)- 1*0), true),
			109 => (C_ipd(9)'last_event, tpd_C_MULTSIGNOUT((47 - 0)- 1*0), true),
			110 => (C_ipd(10)'last_event, tpd_C_MULTSIGNOUT((47 - 0)- 1*0), true),
			111 => (C_ipd(11)'last_event, tpd_C_MULTSIGNOUT((47 - 0)- 1*0), true),
			112 => (C_ipd(12)'last_event, tpd_C_MULTSIGNOUT((47 - 0)- 1*0), true),
			113 => (C_ipd(13)'last_event, tpd_C_MULTSIGNOUT((47 - 0)- 1*0), true),
			114 => (C_ipd(14)'last_event, tpd_C_MULTSIGNOUT((47 - 0)- 1*0), true),
			115 => (C_ipd(15)'last_event, tpd_C_MULTSIGNOUT((47 - 0)- 1*0), true),
			116 => (C_ipd(16)'last_event, tpd_C_MULTSIGNOUT((47 - 0)- 1*0), true),
			117 => (C_ipd(17)'last_event, tpd_C_MULTSIGNOUT((47 - 0)- 1*0), true),
			118 => (C_ipd(18)'last_event, tpd_C_MULTSIGNOUT((47 - 0)- 1*0), true),
			119 => (C_ipd(19)'last_event, tpd_C_MULTSIGNOUT((47 - 0)- 1*0), true),
			120 => (C_ipd(20)'last_event, tpd_C_MULTSIGNOUT((47 - 0)- 1*0), true),
			121 => (C_ipd(21)'last_event, tpd_C_MULTSIGNOUT((47 - 0)- 1*0), true),
			122 => (C_ipd(22)'last_event, tpd_C_MULTSIGNOUT((47 - 0)- 1*0), true),
			123 => (C_ipd(23)'last_event, tpd_C_MULTSIGNOUT((47 - 0)- 1*0), true),
			124 => (C_ipd(24)'last_event, tpd_C_MULTSIGNOUT((47 - 0)- 1*0), true),
			125 => (C_ipd(25)'last_event, tpd_C_MULTSIGNOUT((47 - 0)- 1*0), true),
			126 => (C_ipd(26)'last_event, tpd_C_MULTSIGNOUT((47 - 0)- 1*0), true),
			127 => (C_ipd(27)'last_event, tpd_C_MULTSIGNOUT((47 - 0)- 1*0), true),
			128 => (C_ipd(28)'last_event, tpd_C_MULTSIGNOUT((47 - 0)- 1*0), true),
			129 => (C_ipd(29)'last_event, tpd_C_MULTSIGNOUT((47 - 0)- 1*0), true),
			130 => (C_ipd(30)'last_event, tpd_C_MULTSIGNOUT((47 - 0)- 1*0), true),
			131 => (C_ipd(31)'last_event, tpd_C_MULTSIGNOUT((47 - 0)- 1*0), true),
			132 => (C_ipd(32)'last_event, tpd_C_MULTSIGNOUT((47 - 0)- 1*0), true),
			133 => (C_ipd(33)'last_event, tpd_C_MULTSIGNOUT((47 - 0)- 1*0), true),
			134 => (C_ipd(34)'last_event, tpd_C_MULTSIGNOUT((47 - 0)- 1*0), true),
			135 => (C_ipd(35)'last_event, tpd_C_MULTSIGNOUT((47 - 0)- 1*0), true),
			136 => (C_ipd(36)'last_event, tpd_C_MULTSIGNOUT((47 - 0)- 1*0), true),
			137 => (C_ipd(37)'last_event, tpd_C_MULTSIGNOUT((47 - 0)- 1*0), true),
			138 => (C_ipd(38)'last_event, tpd_C_MULTSIGNOUT((47 - 0)- 1*0), true),
			139 => (C_ipd(39)'last_event, tpd_C_MULTSIGNOUT((47 - 0)- 1*0), true),
			140 => (C_ipd(40)'last_event, tpd_C_MULTSIGNOUT((47 - 0)- 1*0), true),
			141 => (C_ipd(41)'last_event, tpd_C_MULTSIGNOUT((47 - 0)- 1*0), true),
			142 => (C_ipd(42)'last_event, tpd_C_MULTSIGNOUT((47 - 0)- 1*0), true),
			143 => (C_ipd(43)'last_event, tpd_C_MULTSIGNOUT((47 - 0)- 1*0), true),
			144 => (C_ipd(44)'last_event, tpd_C_MULTSIGNOUT((47 - 0)- 1*0), true),
			145 => (C_ipd(45)'last_event, tpd_C_MULTSIGNOUT((47 - 0)- 1*0), true),
			146 => (C_ipd(46)'last_event, tpd_C_MULTSIGNOUT((47 - 0)- 1*0), true),
			147 => (C_ipd(47)'last_event, tpd_C_MULTSIGNOUT((47 - 0)- 1*0), true),
			148 => (CARRYCASCIN_ipd'last_event, tpd_CARRYCASCIN_MULTSIGNOUT, true),
			149 => (CARRYIN_ipd'last_event, tpd_CARRYIN_MULTSIGNOUT, true),
			150 => (CARRYINSEL_ipd(0)'last_event, tpd_CARRYINSEL_MULTSIGNOUT((2 - 0)- 1*0), true),
			151 => (CARRYINSEL_ipd(1)'last_event, tpd_CARRYINSEL_MULTSIGNOUT((2 - 0)- 1*0), true),
			152 => (CARRYINSEL_ipd(2)'last_event, tpd_CARRYINSEL_MULTSIGNOUT((2 - 0)- 1*0), true),
			153 => (MULTSIGNIN_ipd'last_event, tpd_MULTSIGNIN_MULTSIGNOUT, true),
			154 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_MULTSIGNOUT((6 - 0)- 1*0), true),
			155 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_MULTSIGNOUT((6 - 0)- 1*0), true),
			156 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_MULTSIGNOUT((6 - 0)- 1*0), true),
			157 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_MULTSIGNOUT((6 - 0)- 1*0), true),
			158 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_MULTSIGNOUT((6 - 0)- 1*0), true),
			159 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_MULTSIGNOUT((6 - 0)- 1*0), true),
			160 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_MULTSIGNOUT((6 - 0)- 1*0), true),
			161 => (PCIN_ipd(0)'last_event, tpd_PCIN_MULTSIGNOUT((47 - 0)- 1*0), true),
			162 => (PCIN_ipd(1)'last_event, tpd_PCIN_MULTSIGNOUT((47 - 0)- 1*0), true),
			163 => (PCIN_ipd(2)'last_event, tpd_PCIN_MULTSIGNOUT((47 - 0)- 1*0), true),
			164 => (PCIN_ipd(3)'last_event, tpd_PCIN_MULTSIGNOUT((47 - 0)- 1*0), true),
			165 => (PCIN_ipd(4)'last_event, tpd_PCIN_MULTSIGNOUT((47 - 0)- 1*0), true),
			166 => (PCIN_ipd(5)'last_event, tpd_PCIN_MULTSIGNOUT((47 - 0)- 1*0), true),
			167 => (PCIN_ipd(6)'last_event, tpd_PCIN_MULTSIGNOUT((47 - 0)- 1*0), true),
			168 => (PCIN_ipd(7)'last_event, tpd_PCIN_MULTSIGNOUT((47 - 0)- 1*0), true),
			169 => (PCIN_ipd(8)'last_event, tpd_PCIN_MULTSIGNOUT((47 - 0)- 1*0), true),
			170 => (PCIN_ipd(9)'last_event, tpd_PCIN_MULTSIGNOUT((47 - 0)- 1*0), true),
			171 => (PCIN_ipd(10)'last_event, tpd_PCIN_MULTSIGNOUT((47 - 0)- 1*0), true),
			172 => (PCIN_ipd(11)'last_event, tpd_PCIN_MULTSIGNOUT((47 - 0)- 1*0), true),
			173 => (PCIN_ipd(12)'last_event, tpd_PCIN_MULTSIGNOUT((47 - 0)- 1*0), true),
			174 => (PCIN_ipd(13)'last_event, tpd_PCIN_MULTSIGNOUT((47 - 0)- 1*0), true),
			175 => (PCIN_ipd(14)'last_event, tpd_PCIN_MULTSIGNOUT((47 - 0)- 1*0), true),
			176 => (PCIN_ipd(15)'last_event, tpd_PCIN_MULTSIGNOUT((47 - 0)- 1*0), true),
			177 => (PCIN_ipd(16)'last_event, tpd_PCIN_MULTSIGNOUT((47 - 0)- 1*0), true),
			178 => (PCIN_ipd(17)'last_event, tpd_PCIN_MULTSIGNOUT((47 - 0)- 1*0), true),
			179 => (PCIN_ipd(18)'last_event, tpd_PCIN_MULTSIGNOUT((47 - 0)- 1*0), true),
			180 => (PCIN_ipd(19)'last_event, tpd_PCIN_MULTSIGNOUT((47 - 0)- 1*0), true),
			181 => (PCIN_ipd(20)'last_event, tpd_PCIN_MULTSIGNOUT((47 - 0)- 1*0), true),
			182 => (PCIN_ipd(21)'last_event, tpd_PCIN_MULTSIGNOUT((47 - 0)- 1*0), true),
			183 => (PCIN_ipd(22)'last_event, tpd_PCIN_MULTSIGNOUT((47 - 0)- 1*0), true),
			184 => (PCIN_ipd(23)'last_event, tpd_PCIN_MULTSIGNOUT((47 - 0)- 1*0), true),
			185 => (PCIN_ipd(24)'last_event, tpd_PCIN_MULTSIGNOUT((47 - 0)- 1*0), true),
			186 => (PCIN_ipd(25)'last_event, tpd_PCIN_MULTSIGNOUT((47 - 0)- 1*0), true),
			187 => (PCIN_ipd(26)'last_event, tpd_PCIN_MULTSIGNOUT((47 - 0)- 1*0), true),
			188 => (PCIN_ipd(27)'last_event, tpd_PCIN_MULTSIGNOUT((47 - 0)- 1*0), true),
			189 => (PCIN_ipd(28)'last_event, tpd_PCIN_MULTSIGNOUT((47 - 0)- 1*0), true),
			190 => (PCIN_ipd(29)'last_event, tpd_PCIN_MULTSIGNOUT((47 - 0)- 1*0), true),
			191 => (PCIN_ipd(30)'last_event, tpd_PCIN_MULTSIGNOUT((47 - 0)- 1*0), true),
			192 => (PCIN_ipd(31)'last_event, tpd_PCIN_MULTSIGNOUT((47 - 0)- 1*0), true),
			193 => (PCIN_ipd(32)'last_event, tpd_PCIN_MULTSIGNOUT((47 - 0)- 1*0), true),
			194 => (PCIN_ipd(33)'last_event, tpd_PCIN_MULTSIGNOUT((47 - 0)- 1*0), true),
			195 => (PCIN_ipd(34)'last_event, tpd_PCIN_MULTSIGNOUT((47 - 0)- 1*0), true),
			196 => (PCIN_ipd(35)'last_event, tpd_PCIN_MULTSIGNOUT((47 - 0)- 1*0), true),
			197 => (PCIN_ipd(36)'last_event, tpd_PCIN_MULTSIGNOUT((47 - 0)- 1*0), true),
			198 => (PCIN_ipd(37)'last_event, tpd_PCIN_MULTSIGNOUT((47 - 0)- 1*0), true),
			199 => (PCIN_ipd(38)'last_event, tpd_PCIN_MULTSIGNOUT((47 - 0)- 1*0), true),
			200 => (PCIN_ipd(39)'last_event, tpd_PCIN_MULTSIGNOUT((47 - 0)- 1*0), true),
			201 => (PCIN_ipd(40)'last_event, tpd_PCIN_MULTSIGNOUT((47 - 0)- 1*0), true),
			202 => (PCIN_ipd(41)'last_event, tpd_PCIN_MULTSIGNOUT((47 - 0)- 1*0), true),
			203 => (PCIN_ipd(42)'last_event, tpd_PCIN_MULTSIGNOUT((47 - 0)- 1*0), true),
			204 => (PCIN_ipd(43)'last_event, tpd_PCIN_MULTSIGNOUT((47 - 0)- 1*0), true),
			205 => (PCIN_ipd(44)'last_event, tpd_PCIN_MULTSIGNOUT((47 - 0)- 1*0), true),
			206 => (PCIN_ipd(45)'last_event, tpd_PCIN_MULTSIGNOUT((47 - 0)- 1*0), true),
			207 => (PCIN_ipd(46)'last_event, tpd_PCIN_MULTSIGNOUT((47 - 0)- 1*0), true),
			208 => (PCIN_ipd(47)'last_event, tpd_PCIN_MULTSIGNOUT((47 - 0)- 1*0), true),
			209 => (CLK_dly'last_event, tpd_CLK_MULTSIGNOUT, true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> OVERFLOW,
         GlitchData	=> OVERFLOW_GlitchData,
         OutSignalName	=> "OVERFLOW",
         OutTemp	=> OVERFLOW_zd,
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_OVERFLOW((29 - 0)- 1*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_OVERFLOW((29 - 0)- 1*0), true),
			2 => (A_ipd(2)'last_event, tpd_A_OVERFLOW((29 - 0)- 1*0), true),
			3 => (A_ipd(3)'last_event, tpd_A_OVERFLOW((29 - 0)- 1*0), true),
			4 => (A_ipd(4)'last_event, tpd_A_OVERFLOW((29 - 0)- 1*0), true),
			5 => (A_ipd(5)'last_event, tpd_A_OVERFLOW((29 - 0)- 1*0), true),
			6 => (A_ipd(6)'last_event, tpd_A_OVERFLOW((29 - 0)- 1*0), true),
			7 => (A_ipd(7)'last_event, tpd_A_OVERFLOW((29 - 0)- 1*0), true),
			8 => (A_ipd(8)'last_event, tpd_A_OVERFLOW((29 - 0)- 1*0), true),
			9 => (A_ipd(9)'last_event, tpd_A_OVERFLOW((29 - 0)- 1*0), true),
			10 => (A_ipd(10)'last_event, tpd_A_OVERFLOW((29 - 0)- 1*0), true),
			11 => (A_ipd(11)'last_event, tpd_A_OVERFLOW((29 - 0)- 1*0), true),
			12 => (A_ipd(12)'last_event, tpd_A_OVERFLOW((29 - 0)- 1*0), true),
			13 => (A_ipd(13)'last_event, tpd_A_OVERFLOW((29 - 0)- 1*0), true),
			14 => (A_ipd(14)'last_event, tpd_A_OVERFLOW((29 - 0)- 1*0), true),
			15 => (A_ipd(15)'last_event, tpd_A_OVERFLOW((29 - 0)- 1*0), true),
			16 => (A_ipd(16)'last_event, tpd_A_OVERFLOW((29 - 0)- 1*0), true),
			17 => (A_ipd(17)'last_event, tpd_A_OVERFLOW((29 - 0)- 1*0), true),
			18 => (A_ipd(18)'last_event, tpd_A_OVERFLOW((29 - 0)- 1*0), true),
			19 => (A_ipd(19)'last_event, tpd_A_OVERFLOW((29 - 0)- 1*0), true),
			20 => (A_ipd(20)'last_event, tpd_A_OVERFLOW((29 - 0)- 1*0), true),
			21 => (A_ipd(21)'last_event, tpd_A_OVERFLOW((29 - 0)- 1*0), true),
			22 => (A_ipd(22)'last_event, tpd_A_OVERFLOW((29 - 0)- 1*0), true),
			23 => (A_ipd(23)'last_event, tpd_A_OVERFLOW((29 - 0)- 1*0), true),
			24 => (A_ipd(24)'last_event, tpd_A_OVERFLOW((29 - 0)- 1*0), true),
			25 => (A_ipd(25)'last_event, tpd_A_OVERFLOW((29 - 0)- 1*0), true),
			26 => (A_ipd(26)'last_event, tpd_A_OVERFLOW((29 - 0)- 1*0), true),
			27 => (A_ipd(27)'last_event, tpd_A_OVERFLOW((29 - 0)- 1*0), true),
			28 => (A_ipd(28)'last_event, tpd_A_OVERFLOW((29 - 0)- 1*0), true),
			29 => (A_ipd(29)'last_event, tpd_A_OVERFLOW((29 - 0)- 1*0), true),
			30 => (ACIN_ipd(0)'last_event, tpd_ACIN_OVERFLOW((29 - 0)- 1*0), true),
			31 => (ACIN_ipd(1)'last_event, tpd_ACIN_OVERFLOW((29 - 0)- 1*0), true),
			32 => (ACIN_ipd(2)'last_event, tpd_ACIN_OVERFLOW((29 - 0)- 1*0), true),
			33 => (ACIN_ipd(3)'last_event, tpd_ACIN_OVERFLOW((29 - 0)- 1*0), true),
			34 => (ACIN_ipd(4)'last_event, tpd_ACIN_OVERFLOW((29 - 0)- 1*0), true),
			35 => (ACIN_ipd(5)'last_event, tpd_ACIN_OVERFLOW((29 - 0)- 1*0), true),
			36 => (ACIN_ipd(6)'last_event, tpd_ACIN_OVERFLOW((29 - 0)- 1*0), true),
			37 => (ACIN_ipd(7)'last_event, tpd_ACIN_OVERFLOW((29 - 0)- 1*0), true),
			38 => (ACIN_ipd(8)'last_event, tpd_ACIN_OVERFLOW((29 - 0)- 1*0), true),
			39 => (ACIN_ipd(9)'last_event, tpd_ACIN_OVERFLOW((29 - 0)- 1*0), true),
			40 => (ACIN_ipd(10)'last_event, tpd_ACIN_OVERFLOW((29 - 0)- 1*0), true),
			41 => (ACIN_ipd(11)'last_event, tpd_ACIN_OVERFLOW((29 - 0)- 1*0), true),
			42 => (ACIN_ipd(12)'last_event, tpd_ACIN_OVERFLOW((29 - 0)- 1*0), true),
			43 => (ACIN_ipd(13)'last_event, tpd_ACIN_OVERFLOW((29 - 0)- 1*0), true),
			44 => (ACIN_ipd(14)'last_event, tpd_ACIN_OVERFLOW((29 - 0)- 1*0), true),
			45 => (ACIN_ipd(15)'last_event, tpd_ACIN_OVERFLOW((29 - 0)- 1*0), true),
			46 => (ACIN_ipd(16)'last_event, tpd_ACIN_OVERFLOW((29 - 0)- 1*0), true),
			47 => (ACIN_ipd(17)'last_event, tpd_ACIN_OVERFLOW((29 - 0)- 1*0), true),
			48 => (ACIN_ipd(18)'last_event, tpd_ACIN_OVERFLOW((29 - 0)- 1*0), true),
			49 => (ACIN_ipd(19)'last_event, tpd_ACIN_OVERFLOW((29 - 0)- 1*0), true),
			50 => (ACIN_ipd(20)'last_event, tpd_ACIN_OVERFLOW((29 - 0)- 1*0), true),
			51 => (ACIN_ipd(21)'last_event, tpd_ACIN_OVERFLOW((29 - 0)- 1*0), true),
			52 => (ACIN_ipd(22)'last_event, tpd_ACIN_OVERFLOW((29 - 0)- 1*0), true),
			53 => (ACIN_ipd(23)'last_event, tpd_ACIN_OVERFLOW((29 - 0)- 1*0), true),
			54 => (ACIN_ipd(24)'last_event, tpd_ACIN_OVERFLOW((29 - 0)- 1*0), true),
			55 => (ACIN_ipd(25)'last_event, tpd_ACIN_OVERFLOW((29 - 0)- 1*0), true),
			56 => (ACIN_ipd(26)'last_event, tpd_ACIN_OVERFLOW((29 - 0)- 1*0), true),
			57 => (ACIN_ipd(27)'last_event, tpd_ACIN_OVERFLOW((29 - 0)- 1*0), true),
			58 => (ACIN_ipd(28)'last_event, tpd_ACIN_OVERFLOW((29 - 0)- 1*0), true),
			59 => (ACIN_ipd(29)'last_event, tpd_ACIN_OVERFLOW((29 - 0)- 1*0), true),
			60 => (ALUMODE_ipd(0)'last_event, tpd_ALUMODE_OVERFLOW((3 - 0)- 1*0), true),
			61 => (ALUMODE_ipd(1)'last_event, tpd_ALUMODE_OVERFLOW((3 - 0)- 1*0), true),
			62 => (ALUMODE_ipd(2)'last_event, tpd_ALUMODE_OVERFLOW((3 - 0)- 1*0), true),
			63 => (ALUMODE_ipd(3)'last_event, tpd_ALUMODE_OVERFLOW((3 - 0)- 1*0), true),
			64 => (B_ipd(0)'last_event, tpd_B_OVERFLOW((17 - 0)- 1*0), true),
			65 => (B_ipd(1)'last_event, tpd_B_OVERFLOW((17 - 0)- 1*0), true),
			66 => (B_ipd(2)'last_event, tpd_B_OVERFLOW((17 - 0)- 1*0), true),
			67 => (B_ipd(3)'last_event, tpd_B_OVERFLOW((17 - 0)- 1*0), true),
			68 => (B_ipd(4)'last_event, tpd_B_OVERFLOW((17 - 0)- 1*0), true),
			69 => (B_ipd(5)'last_event, tpd_B_OVERFLOW((17 - 0)- 1*0), true),
			70 => (B_ipd(6)'last_event, tpd_B_OVERFLOW((17 - 0)- 1*0), true),
			71 => (B_ipd(7)'last_event, tpd_B_OVERFLOW((17 - 0)- 1*0), true),
			72 => (B_ipd(8)'last_event, tpd_B_OVERFLOW((17 - 0)- 1*0), true),
			73 => (B_ipd(9)'last_event, tpd_B_OVERFLOW((17 - 0)- 1*0), true),
			74 => (B_ipd(10)'last_event, tpd_B_OVERFLOW((17 - 0)- 1*0), true),
			75 => (B_ipd(11)'last_event, tpd_B_OVERFLOW((17 - 0)- 1*0), true),
			76 => (B_ipd(12)'last_event, tpd_B_OVERFLOW((17 - 0)- 1*0), true),
			77 => (B_ipd(13)'last_event, tpd_B_OVERFLOW((17 - 0)- 1*0), true),
			78 => (B_ipd(14)'last_event, tpd_B_OVERFLOW((17 - 0)- 1*0), true),
			79 => (B_ipd(15)'last_event, tpd_B_OVERFLOW((17 - 0)- 1*0), true),
			80 => (B_ipd(16)'last_event, tpd_B_OVERFLOW((17 - 0)- 1*0), true),
			81 => (B_ipd(17)'last_event, tpd_B_OVERFLOW((17 - 0)- 1*0), true),
			82 => (BCIN_ipd(0)'last_event, tpd_BCIN_OVERFLOW((17 - 0)- 1*0), true),
			83 => (BCIN_ipd(1)'last_event, tpd_BCIN_OVERFLOW((17 - 0)- 1*0), true),
			84 => (BCIN_ipd(2)'last_event, tpd_BCIN_OVERFLOW((17 - 0)- 1*0), true),
			85 => (BCIN_ipd(3)'last_event, tpd_BCIN_OVERFLOW((17 - 0)- 1*0), true),
			86 => (BCIN_ipd(4)'last_event, tpd_BCIN_OVERFLOW((17 - 0)- 1*0), true),
			87 => (BCIN_ipd(5)'last_event, tpd_BCIN_OVERFLOW((17 - 0)- 1*0), true),
			88 => (BCIN_ipd(6)'last_event, tpd_BCIN_OVERFLOW((17 - 0)- 1*0), true),
			89 => (BCIN_ipd(7)'last_event, tpd_BCIN_OVERFLOW((17 - 0)- 1*0), true),
			90 => (BCIN_ipd(8)'last_event, tpd_BCIN_OVERFLOW((17 - 0)- 1*0), true),
			91 => (BCIN_ipd(9)'last_event, tpd_BCIN_OVERFLOW((17 - 0)- 1*0), true),
			92 => (BCIN_ipd(10)'last_event, tpd_BCIN_OVERFLOW((17 - 0)- 1*0), true),
			93 => (BCIN_ipd(11)'last_event, tpd_BCIN_OVERFLOW((17 - 0)- 1*0), true),
			94 => (BCIN_ipd(12)'last_event, tpd_BCIN_OVERFLOW((17 - 0)- 1*0), true),
			95 => (BCIN_ipd(13)'last_event, tpd_BCIN_OVERFLOW((17 - 0)- 1*0), true),
			96 => (BCIN_ipd(14)'last_event, tpd_BCIN_OVERFLOW((17 - 0)- 1*0), true),
			97 => (BCIN_ipd(15)'last_event, tpd_BCIN_OVERFLOW((17 - 0)- 1*0), true),
			98 => (BCIN_ipd(16)'last_event, tpd_BCIN_OVERFLOW((17 - 0)- 1*0), true),
			99 => (BCIN_ipd(17)'last_event, tpd_BCIN_OVERFLOW((17 - 0)- 1*0), true),
			100 => (C_ipd(0)'last_event, tpd_C_OVERFLOW((47 - 0)- 1*0), true),
			101 => (C_ipd(1)'last_event, tpd_C_OVERFLOW((47 - 0)- 1*0), true),
			102 => (C_ipd(2)'last_event, tpd_C_OVERFLOW((47 - 0)- 1*0), true),
			103 => (C_ipd(3)'last_event, tpd_C_OVERFLOW((47 - 0)- 1*0), true),
			104 => (C_ipd(4)'last_event, tpd_C_OVERFLOW((47 - 0)- 1*0), true),
			105 => (C_ipd(5)'last_event, tpd_C_OVERFLOW((47 - 0)- 1*0), true),
			106 => (C_ipd(6)'last_event, tpd_C_OVERFLOW((47 - 0)- 1*0), true),
			107 => (C_ipd(7)'last_event, tpd_C_OVERFLOW((47 - 0)- 1*0), true),
			108 => (C_ipd(8)'last_event, tpd_C_OVERFLOW((47 - 0)- 1*0), true),
			109 => (C_ipd(9)'last_event, tpd_C_OVERFLOW((47 - 0)- 1*0), true),
			110 => (C_ipd(10)'last_event, tpd_C_OVERFLOW((47 - 0)- 1*0), true),
			111 => (C_ipd(11)'last_event, tpd_C_OVERFLOW((47 - 0)- 1*0), true),
			112 => (C_ipd(12)'last_event, tpd_C_OVERFLOW((47 - 0)- 1*0), true),
			113 => (C_ipd(13)'last_event, tpd_C_OVERFLOW((47 - 0)- 1*0), true),
			114 => (C_ipd(14)'last_event, tpd_C_OVERFLOW((47 - 0)- 1*0), true),
			115 => (C_ipd(15)'last_event, tpd_C_OVERFLOW((47 - 0)- 1*0), true),
			116 => (C_ipd(16)'last_event, tpd_C_OVERFLOW((47 - 0)- 1*0), true),
			117 => (C_ipd(17)'last_event, tpd_C_OVERFLOW((47 - 0)- 1*0), true),
			118 => (C_ipd(18)'last_event, tpd_C_OVERFLOW((47 - 0)- 1*0), true),
			119 => (C_ipd(19)'last_event, tpd_C_OVERFLOW((47 - 0)- 1*0), true),
			120 => (C_ipd(20)'last_event, tpd_C_OVERFLOW((47 - 0)- 1*0), true),
			121 => (C_ipd(21)'last_event, tpd_C_OVERFLOW((47 - 0)- 1*0), true),
			122 => (C_ipd(22)'last_event, tpd_C_OVERFLOW((47 - 0)- 1*0), true),
			123 => (C_ipd(23)'last_event, tpd_C_OVERFLOW((47 - 0)- 1*0), true),
			124 => (C_ipd(24)'last_event, tpd_C_OVERFLOW((47 - 0)- 1*0), true),
			125 => (C_ipd(25)'last_event, tpd_C_OVERFLOW((47 - 0)- 1*0), true),
			126 => (C_ipd(26)'last_event, tpd_C_OVERFLOW((47 - 0)- 1*0), true),
			127 => (C_ipd(27)'last_event, tpd_C_OVERFLOW((47 - 0)- 1*0), true),
			128 => (C_ipd(28)'last_event, tpd_C_OVERFLOW((47 - 0)- 1*0), true),
			129 => (C_ipd(29)'last_event, tpd_C_OVERFLOW((47 - 0)- 1*0), true),
			130 => (C_ipd(30)'last_event, tpd_C_OVERFLOW((47 - 0)- 1*0), true),
			131 => (C_ipd(31)'last_event, tpd_C_OVERFLOW((47 - 0)- 1*0), true),
			132 => (C_ipd(32)'last_event, tpd_C_OVERFLOW((47 - 0)- 1*0), true),
			133 => (C_ipd(33)'last_event, tpd_C_OVERFLOW((47 - 0)- 1*0), true),
			134 => (C_ipd(34)'last_event, tpd_C_OVERFLOW((47 - 0)- 1*0), true),
			135 => (C_ipd(35)'last_event, tpd_C_OVERFLOW((47 - 0)- 1*0), true),
			136 => (C_ipd(36)'last_event, tpd_C_OVERFLOW((47 - 0)- 1*0), true),
			137 => (C_ipd(37)'last_event, tpd_C_OVERFLOW((47 - 0)- 1*0), true),
			138 => (C_ipd(38)'last_event, tpd_C_OVERFLOW((47 - 0)- 1*0), true),
			139 => (C_ipd(39)'last_event, tpd_C_OVERFLOW((47 - 0)- 1*0), true),
			140 => (C_ipd(40)'last_event, tpd_C_OVERFLOW((47 - 0)- 1*0), true),
			141 => (C_ipd(41)'last_event, tpd_C_OVERFLOW((47 - 0)- 1*0), true),
			142 => (C_ipd(42)'last_event, tpd_C_OVERFLOW((47 - 0)- 1*0), true),
			143 => (C_ipd(43)'last_event, tpd_C_OVERFLOW((47 - 0)- 1*0), true),
			144 => (C_ipd(44)'last_event, tpd_C_OVERFLOW((47 - 0)- 1*0), true),
			145 => (C_ipd(45)'last_event, tpd_C_OVERFLOW((47 - 0)- 1*0), true),
			146 => (C_ipd(46)'last_event, tpd_C_OVERFLOW((47 - 0)- 1*0), true),
			147 => (C_ipd(47)'last_event, tpd_C_OVERFLOW((47 - 0)- 1*0), true),
			148 => (CARRYCASCIN_ipd'last_event, tpd_CARRYCASCIN_OVERFLOW, true),
			149 => (CARRYIN_ipd'last_event, tpd_CARRYIN_OVERFLOW, true),
			150 => (CARRYINSEL_ipd(0)'last_event, tpd_CARRYINSEL_OVERFLOW((2 - 0)- 1*0), true),
			151 => (CARRYINSEL_ipd(1)'last_event, tpd_CARRYINSEL_OVERFLOW((2 - 0)- 1*0), true),
			152 => (CARRYINSEL_ipd(2)'last_event, tpd_CARRYINSEL_OVERFLOW((2 - 0)- 1*0), true),
			153 => (MULTSIGNIN_ipd'last_event, tpd_MULTSIGNIN_OVERFLOW, true),
			154 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_OVERFLOW((6 - 0)- 1*0), true),
			155 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_OVERFLOW((6 - 0)- 1*0), true),
			156 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_OVERFLOW((6 - 0)- 1*0), true),
			157 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_OVERFLOW((6 - 0)- 1*0), true),
			158 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_OVERFLOW((6 - 0)- 1*0), true),
			159 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_OVERFLOW((6 - 0)- 1*0), true),
			160 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_OVERFLOW((6 - 0)- 1*0), true),
			161 => (PCIN_ipd(0)'last_event, tpd_PCIN_OVERFLOW((47 - 0)- 1*0), true),
			162 => (PCIN_ipd(1)'last_event, tpd_PCIN_OVERFLOW((47 - 0)- 1*0), true),
			163 => (PCIN_ipd(2)'last_event, tpd_PCIN_OVERFLOW((47 - 0)- 1*0), true),
			164 => (PCIN_ipd(3)'last_event, tpd_PCIN_OVERFLOW((47 - 0)- 1*0), true),
			165 => (PCIN_ipd(4)'last_event, tpd_PCIN_OVERFLOW((47 - 0)- 1*0), true),
			166 => (PCIN_ipd(5)'last_event, tpd_PCIN_OVERFLOW((47 - 0)- 1*0), true),
			167 => (PCIN_ipd(6)'last_event, tpd_PCIN_OVERFLOW((47 - 0)- 1*0), true),
			168 => (PCIN_ipd(7)'last_event, tpd_PCIN_OVERFLOW((47 - 0)- 1*0), true),
			169 => (PCIN_ipd(8)'last_event, tpd_PCIN_OVERFLOW((47 - 0)- 1*0), true),
			170 => (PCIN_ipd(9)'last_event, tpd_PCIN_OVERFLOW((47 - 0)- 1*0), true),
			171 => (PCIN_ipd(10)'last_event, tpd_PCIN_OVERFLOW((47 - 0)- 1*0), true),
			172 => (PCIN_ipd(11)'last_event, tpd_PCIN_OVERFLOW((47 - 0)- 1*0), true),
			173 => (PCIN_ipd(12)'last_event, tpd_PCIN_OVERFLOW((47 - 0)- 1*0), true),
			174 => (PCIN_ipd(13)'last_event, tpd_PCIN_OVERFLOW((47 - 0)- 1*0), true),
			175 => (PCIN_ipd(14)'last_event, tpd_PCIN_OVERFLOW((47 - 0)- 1*0), true),
			176 => (PCIN_ipd(15)'last_event, tpd_PCIN_OVERFLOW((47 - 0)- 1*0), true),
			177 => (PCIN_ipd(16)'last_event, tpd_PCIN_OVERFLOW((47 - 0)- 1*0), true),
			178 => (PCIN_ipd(17)'last_event, tpd_PCIN_OVERFLOW((47 - 0)- 1*0), true),
			179 => (PCIN_ipd(18)'last_event, tpd_PCIN_OVERFLOW((47 - 0)- 1*0), true),
			180 => (PCIN_ipd(19)'last_event, tpd_PCIN_OVERFLOW((47 - 0)- 1*0), true),
			181 => (PCIN_ipd(20)'last_event, tpd_PCIN_OVERFLOW((47 - 0)- 1*0), true),
			182 => (PCIN_ipd(21)'last_event, tpd_PCIN_OVERFLOW((47 - 0)- 1*0), true),
			183 => (PCIN_ipd(22)'last_event, tpd_PCIN_OVERFLOW((47 - 0)- 1*0), true),
			184 => (PCIN_ipd(23)'last_event, tpd_PCIN_OVERFLOW((47 - 0)- 1*0), true),
			185 => (PCIN_ipd(24)'last_event, tpd_PCIN_OVERFLOW((47 - 0)- 1*0), true),
			186 => (PCIN_ipd(25)'last_event, tpd_PCIN_OVERFLOW((47 - 0)- 1*0), true),
			187 => (PCIN_ipd(26)'last_event, tpd_PCIN_OVERFLOW((47 - 0)- 1*0), true),
			188 => (PCIN_ipd(27)'last_event, tpd_PCIN_OVERFLOW((47 - 0)- 1*0), true),
			189 => (PCIN_ipd(28)'last_event, tpd_PCIN_OVERFLOW((47 - 0)- 1*0), true),
			190 => (PCIN_ipd(29)'last_event, tpd_PCIN_OVERFLOW((47 - 0)- 1*0), true),
			191 => (PCIN_ipd(30)'last_event, tpd_PCIN_OVERFLOW((47 - 0)- 1*0), true),
			192 => (PCIN_ipd(31)'last_event, tpd_PCIN_OVERFLOW((47 - 0)- 1*0), true),
			193 => (PCIN_ipd(32)'last_event, tpd_PCIN_OVERFLOW((47 - 0)- 1*0), true),
			194 => (PCIN_ipd(33)'last_event, tpd_PCIN_OVERFLOW((47 - 0)- 1*0), true),
			195 => (PCIN_ipd(34)'last_event, tpd_PCIN_OVERFLOW((47 - 0)- 1*0), true),
			196 => (PCIN_ipd(35)'last_event, tpd_PCIN_OVERFLOW((47 - 0)- 1*0), true),
			197 => (PCIN_ipd(36)'last_event, tpd_PCIN_OVERFLOW((47 - 0)- 1*0), true),
			198 => (PCIN_ipd(37)'last_event, tpd_PCIN_OVERFLOW((47 - 0)- 1*0), true),
			199 => (PCIN_ipd(38)'last_event, tpd_PCIN_OVERFLOW((47 - 0)- 1*0), true),
			200 => (PCIN_ipd(39)'last_event, tpd_PCIN_OVERFLOW((47 - 0)- 1*0), true),
			201 => (PCIN_ipd(40)'last_event, tpd_PCIN_OVERFLOW((47 - 0)- 1*0), true),
			202 => (PCIN_ipd(41)'last_event, tpd_PCIN_OVERFLOW((47 - 0)- 1*0), true),
			203 => (PCIN_ipd(42)'last_event, tpd_PCIN_OVERFLOW((47 - 0)- 1*0), true),
			204 => (PCIN_ipd(43)'last_event, tpd_PCIN_OVERFLOW((47 - 0)- 1*0), true),
			205 => (PCIN_ipd(44)'last_event, tpd_PCIN_OVERFLOW((47 - 0)- 1*0), true),
			206 => (PCIN_ipd(45)'last_event, tpd_PCIN_OVERFLOW((47 - 0)- 1*0), true),
			207 => (PCIN_ipd(46)'last_event, tpd_PCIN_OVERFLOW((47 - 0)- 1*0), true),
			208 => (PCIN_ipd(47)'last_event, tpd_PCIN_OVERFLOW((47 - 0)- 1*0), true),
			209 => (CLK_dly'last_event, tpd_CLK_OVERFLOW, true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(47),
         GlitchData	=> P_GlitchData(47),
         OutSignalName	=> "P(47)",
         OutTemp	=> P_zd(47),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((1439 - 0)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((1439 - 0)- 48*0), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((1439 - 0)- 48*0), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((1439 - 0)- 48*0), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((1439 - 0)- 48*0), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((1439 - 0)- 48*0), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((1439 - 0)- 48*0), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((1439 - 0)- 48*0), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((1439 - 0)- 48*0), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((1439 - 0)- 48*0), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((1439 - 0)- 48*0), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((1439 - 0)- 48*0), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((1439 - 0)- 48*0), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((1439 - 0)- 48*0), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((1439 - 0)- 48*0), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((1439 - 0)- 48*0), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((1439 - 0)- 48*0), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((1439 - 0)- 48*0), true),
			18 => (A_ipd(18)'last_event, tpd_A_P((1439 - 0)- 48*0), true),
			19 => (A_ipd(19)'last_event, tpd_A_P((1439 - 0)- 48*0), true),
			20 => (A_ipd(20)'last_event, tpd_A_P((1439 - 0)- 48*0), true),
			21 => (A_ipd(21)'last_event, tpd_A_P((1439 - 0)- 48*0), true),
			22 => (A_ipd(22)'last_event, tpd_A_P((1439 - 0)- 48*0), true),
			23 => (A_ipd(23)'last_event, tpd_A_P((1439 - 0)- 48*0), true),
			24 => (A_ipd(24)'last_event, tpd_A_P((1439 - 0)- 48*0), true),
			25 => (A_ipd(25)'last_event, tpd_A_P((1439 - 0)- 48*0), true),
			26 => (A_ipd(26)'last_event, tpd_A_P((1439 - 0)- 48*0), true),
			27 => (A_ipd(27)'last_event, tpd_A_P((1439 - 0)- 48*0), true),
			28 => (A_ipd(28)'last_event, tpd_A_P((1439 - 0)- 48*0), true),
			29 => (A_ipd(29)'last_event, tpd_A_P((1439 - 0)- 48*0), true),
			30 => (ACIN_ipd(0)'last_event, tpd_ACIN_P((1439 - 0)- 48*0), true),
			31 => (ACIN_ipd(1)'last_event, tpd_ACIN_P((1439 - 0)- 48*0), true),
			32 => (ACIN_ipd(2)'last_event, tpd_ACIN_P((1439 - 0)- 48*0), true),
			33 => (ACIN_ipd(3)'last_event, tpd_ACIN_P((1439 - 0)- 48*0), true),
			34 => (ACIN_ipd(4)'last_event, tpd_ACIN_P((1439 - 0)- 48*0), true),
			35 => (ACIN_ipd(5)'last_event, tpd_ACIN_P((1439 - 0)- 48*0), true),
			36 => (ACIN_ipd(6)'last_event, tpd_ACIN_P((1439 - 0)- 48*0), true),
			37 => (ACIN_ipd(7)'last_event, tpd_ACIN_P((1439 - 0)- 48*0), true),
			38 => (ACIN_ipd(8)'last_event, tpd_ACIN_P((1439 - 0)- 48*0), true),
			39 => (ACIN_ipd(9)'last_event, tpd_ACIN_P((1439 - 0)- 48*0), true),
			40 => (ACIN_ipd(10)'last_event, tpd_ACIN_P((1439 - 0)- 48*0), true),
			41 => (ACIN_ipd(11)'last_event, tpd_ACIN_P((1439 - 0)- 48*0), true),
			42 => (ACIN_ipd(12)'last_event, tpd_ACIN_P((1439 - 0)- 48*0), true),
			43 => (ACIN_ipd(13)'last_event, tpd_ACIN_P((1439 - 0)- 48*0), true),
			44 => (ACIN_ipd(14)'last_event, tpd_ACIN_P((1439 - 0)- 48*0), true),
			45 => (ACIN_ipd(15)'last_event, tpd_ACIN_P((1439 - 0)- 48*0), true),
			46 => (ACIN_ipd(16)'last_event, tpd_ACIN_P((1439 - 0)- 48*0), true),
			47 => (ACIN_ipd(17)'last_event, tpd_ACIN_P((1439 - 0)- 48*0), true),
			48 => (ACIN_ipd(18)'last_event, tpd_ACIN_P((1439 - 0)- 48*0), true),
			49 => (ACIN_ipd(19)'last_event, tpd_ACIN_P((1439 - 0)- 48*0), true),
			50 => (ACIN_ipd(20)'last_event, tpd_ACIN_P((1439 - 0)- 48*0), true),
			51 => (ACIN_ipd(21)'last_event, tpd_ACIN_P((1439 - 0)- 48*0), true),
			52 => (ACIN_ipd(22)'last_event, tpd_ACIN_P((1439 - 0)- 48*0), true),
			53 => (ACIN_ipd(23)'last_event, tpd_ACIN_P((1439 - 0)- 48*0), true),
			54 => (ACIN_ipd(24)'last_event, tpd_ACIN_P((1439 - 0)- 48*0), true),
			55 => (ACIN_ipd(25)'last_event, tpd_ACIN_P((1439 - 0)- 48*0), true),
			56 => (ACIN_ipd(26)'last_event, tpd_ACIN_P((1439 - 0)- 48*0), true),
			57 => (ACIN_ipd(27)'last_event, tpd_ACIN_P((1439 - 0)- 48*0), true),
			58 => (ACIN_ipd(28)'last_event, tpd_ACIN_P((1439 - 0)- 48*0), true),
			59 => (ACIN_ipd(29)'last_event, tpd_ACIN_P((1439 - 0)- 48*0), true),
			60 => (ALUMODE_ipd(0)'last_event, tpd_ALUMODE_P((191 - 0)- 48*0), true),
			61 => (ALUMODE_ipd(1)'last_event, tpd_ALUMODE_P((191 - 0)- 48*0), true),
			62 => (ALUMODE_ipd(2)'last_event, tpd_ALUMODE_P((191 - 0)- 48*0), true),
			63 => (ALUMODE_ipd(3)'last_event, tpd_ALUMODE_P((191 - 0)- 48*0), true),
			64 => (B_ipd(0)'last_event, tpd_B_P((863 - 0)- 48*0), true),
			65 => (B_ipd(1)'last_event, tpd_B_P((863 - 0)- 48*0), true),
			66 => (B_ipd(2)'last_event, tpd_B_P((863 - 0)- 48*0), true),
			67 => (B_ipd(3)'last_event, tpd_B_P((863 - 0)- 48*0), true),
			68 => (B_ipd(4)'last_event, tpd_B_P((863 - 0)- 48*0), true),
			69 => (B_ipd(5)'last_event, tpd_B_P((863 - 0)- 48*0), true),
			70 => (B_ipd(6)'last_event, tpd_B_P((863 - 0)- 48*0), true),
			71 => (B_ipd(7)'last_event, tpd_B_P((863 - 0)- 48*0), true),
			72 => (B_ipd(8)'last_event, tpd_B_P((863 - 0)- 48*0), true),
			73 => (B_ipd(9)'last_event, tpd_B_P((863 - 0)- 48*0), true),
			74 => (B_ipd(10)'last_event, tpd_B_P((863 - 0)- 48*0), true),
			75 => (B_ipd(11)'last_event, tpd_B_P((863 - 0)- 48*0), true),
			76 => (B_ipd(12)'last_event, tpd_B_P((863 - 0)- 48*0), true),
			77 => (B_ipd(13)'last_event, tpd_B_P((863 - 0)- 48*0), true),
			78 => (B_ipd(14)'last_event, tpd_B_P((863 - 0)- 48*0), true),
			79 => (B_ipd(15)'last_event, tpd_B_P((863 - 0)- 48*0), true),
			80 => (B_ipd(16)'last_event, tpd_B_P((863 - 0)- 48*0), true),
			81 => (B_ipd(17)'last_event, tpd_B_P((863 - 0)- 48*0), true),
			82 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 0)- 48*0), true),
			83 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 0)- 48*0), true),
			84 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 0)- 48*0), true),
			85 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 0)- 48*0), true),
			86 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 0)- 48*0), true),
			87 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 0)- 48*0), true),
			88 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 0)- 48*0), true),
			89 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 0)- 48*0), true),
			90 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 0)- 48*0), true),
			91 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 0)- 48*0), true),
			92 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 0)- 48*0), true),
			93 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 0)- 48*0), true),
			94 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 0)- 48*0), true),
			95 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 0)- 48*0), true),
			96 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 0)- 48*0), true),
			97 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 0)- 48*0), true),
			98 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 0)- 48*0), true),
			99 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 0)- 48*0), true),
			100 => (C_ipd(0)'last_event, tpd_C_P((2303 - 0)- 48*0), true),
			101 => (C_ipd(1)'last_event, tpd_C_P((2303 - 0)- 48*0), true),
			102 => (C_ipd(2)'last_event, tpd_C_P((2303 - 0)- 48*0), true),
			103 => (C_ipd(3)'last_event, tpd_C_P((2303 - 0)- 48*0), true),
			104 => (C_ipd(4)'last_event, tpd_C_P((2303 - 0)- 48*0), true),
			105 => (C_ipd(5)'last_event, tpd_C_P((2303 - 0)- 48*0), true),
			106 => (C_ipd(6)'last_event, tpd_C_P((2303 - 0)- 48*0), true),
			107 => (C_ipd(7)'last_event, tpd_C_P((2303 - 0)- 48*0), true),
			108 => (C_ipd(8)'last_event, tpd_C_P((2303 - 0)- 48*0), true),
			109 => (C_ipd(9)'last_event, tpd_C_P((2303 - 0)- 48*0), true),
			110 => (C_ipd(10)'last_event, tpd_C_P((2303 - 0)- 48*0), true),
			111 => (C_ipd(11)'last_event, tpd_C_P((2303 - 0)- 48*0), true),
			112 => (C_ipd(12)'last_event, tpd_C_P((2303 - 0)- 48*0), true),
			113 => (C_ipd(13)'last_event, tpd_C_P((2303 - 0)- 48*0), true),
			114 => (C_ipd(14)'last_event, tpd_C_P((2303 - 0)- 48*0), true),
			115 => (C_ipd(15)'last_event, tpd_C_P((2303 - 0)- 48*0), true),
			116 => (C_ipd(16)'last_event, tpd_C_P((2303 - 0)- 48*0), true),
			117 => (C_ipd(17)'last_event, tpd_C_P((2303 - 0)- 48*0), true),
			118 => (C_ipd(18)'last_event, tpd_C_P((2303 - 0)- 48*0), true),
			119 => (C_ipd(19)'last_event, tpd_C_P((2303 - 0)- 48*0), true),
			120 => (C_ipd(20)'last_event, tpd_C_P((2303 - 0)- 48*0), true),
			121 => (C_ipd(21)'last_event, tpd_C_P((2303 - 0)- 48*0), true),
			122 => (C_ipd(22)'last_event, tpd_C_P((2303 - 0)- 48*0), true),
			123 => (C_ipd(23)'last_event, tpd_C_P((2303 - 0)- 48*0), true),
			124 => (C_ipd(24)'last_event, tpd_C_P((2303 - 0)- 48*0), true),
			125 => (C_ipd(25)'last_event, tpd_C_P((2303 - 0)- 48*0), true),
			126 => (C_ipd(26)'last_event, tpd_C_P((2303 - 0)- 48*0), true),
			127 => (C_ipd(27)'last_event, tpd_C_P((2303 - 0)- 48*0), true),
			128 => (C_ipd(28)'last_event, tpd_C_P((2303 - 0)- 48*0), true),
			129 => (C_ipd(29)'last_event, tpd_C_P((2303 - 0)- 48*0), true),
			130 => (C_ipd(30)'last_event, tpd_C_P((2303 - 0)- 48*0), true),
			131 => (C_ipd(31)'last_event, tpd_C_P((2303 - 0)- 48*0), true),
			132 => (C_ipd(32)'last_event, tpd_C_P((2303 - 0)- 48*0), true),
			133 => (C_ipd(33)'last_event, tpd_C_P((2303 - 0)- 48*0), true),
			134 => (C_ipd(34)'last_event, tpd_C_P((2303 - 0)- 48*0), true),
			135 => (C_ipd(35)'last_event, tpd_C_P((2303 - 0)- 48*0), true),
			136 => (C_ipd(36)'last_event, tpd_C_P((2303 - 0)- 48*0), true),
			137 => (C_ipd(37)'last_event, tpd_C_P((2303 - 0)- 48*0), true),
			138 => (C_ipd(38)'last_event, tpd_C_P((2303 - 0)- 48*0), true),
			139 => (C_ipd(39)'last_event, tpd_C_P((2303 - 0)- 48*0), true),
			140 => (C_ipd(40)'last_event, tpd_C_P((2303 - 0)- 48*0), true),
			141 => (C_ipd(41)'last_event, tpd_C_P((2303 - 0)- 48*0), true),
			142 => (C_ipd(42)'last_event, tpd_C_P((2303 - 0)- 48*0), true),
			143 => (C_ipd(43)'last_event, tpd_C_P((2303 - 0)- 48*0), true),
			144 => (C_ipd(44)'last_event, tpd_C_P((2303 - 0)- 48*0), true),
			145 => (C_ipd(45)'last_event, tpd_C_P((2303 - 0)- 48*0), true),
			146 => (C_ipd(46)'last_event, tpd_C_P((2303 - 0)- 48*0), true),
			147 => (C_ipd(47)'last_event, tpd_C_P((2303 - 0)- 48*0), true),
			148 => (CARRYCASCIN_ipd'last_event, tpd_CARRYCASCIN_P(47), true),
			149 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(47), true),
			150 => (CARRYINSEL_ipd(0)'last_event, tpd_CARRYINSEL_P((143 - 0)- 48*0), true),
			151 => (CARRYINSEL_ipd(1)'last_event, tpd_CARRYINSEL_P((143 - 0)- 48*0), true),
			152 => (CARRYINSEL_ipd(2)'last_event, tpd_CARRYINSEL_P((143 - 0)- 48*0), true),
			153 => (MULTSIGNIN_ipd'last_event, tpd_MULTSIGNIN_P(47), true),
			154 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 0)- 48*0), true),
			155 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 0)- 48*0), true),
			156 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 0)- 48*0), true),
			157 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 0)- 48*0), true),
			158 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 0)- 48*0), true),
			159 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 0)- 48*0), true),
			160 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 0)- 48*0), true),
			161 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 0)- 48*0), true),
			162 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 0)- 48*0), true),
			163 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 0)- 48*0), true),
			164 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 0)- 48*0), true),
			165 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 0)- 48*0), true),
			166 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 0)- 48*0), true),
			167 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 0)- 48*0), true),
			168 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 0)- 48*0), true),
			169 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 0)- 48*0), true),
			170 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 0)- 48*0), true),
			171 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 0)- 48*0), true),
			172 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 0)- 48*0), true),
			173 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 0)- 48*0), true),
			174 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 0)- 48*0), true),
			175 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 0)- 48*0), true),
			176 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 0)- 48*0), true),
			177 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 0)- 48*0), true),
			178 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 0)- 48*0), true),
			179 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 0)- 48*0), true),
			180 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 0)- 48*0), true),
			181 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 0)- 48*0), true),
			182 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 0)- 48*0), true),
			183 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 0)- 48*0), true),
			184 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 0)- 48*0), true),
			185 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 0)- 48*0), true),
			186 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 0)- 48*0), true),
			187 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 0)- 48*0), true),
			188 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 0)- 48*0), true),
			189 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 0)- 48*0), true),
			190 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 0)- 48*0), true),
			191 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 0)- 48*0), true),
			192 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 0)- 48*0), true),
			193 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 0)- 48*0), true),
			194 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 0)- 48*0), true),
			195 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 0)- 48*0), true),
			196 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 0)- 48*0), true),
			197 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 0)- 48*0), true),
			198 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 0)- 48*0), true),
			199 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 0)- 48*0), true),
			200 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 0)- 48*0), true),
			201 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 0)- 48*0), true),
			202 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 0)- 48*0), true),
			203 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 0)- 48*0), true),
			204 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 0)- 48*0), true),
			205 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 0)- 48*0), true),
			206 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 0)- 48*0), true),
			207 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 0)- 48*0), true),
			208 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 0)- 48*0), true),
			209 => (CLK_dly'last_event, tpd_CLK_P(47), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(46),
         GlitchData	=> P_GlitchData(46),
         OutSignalName	=> "P(46)",
         OutTemp	=> P_zd(46),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((1439 - 1)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((1439 - 1)- 48*0), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((1439 - 1)- 48*0), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((1439 - 1)- 48*0), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((1439 - 1)- 48*0), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((1439 - 1)- 48*0), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((1439 - 1)- 48*0), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((1439 - 1)- 48*0), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((1439 - 1)- 48*0), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((1439 - 1)- 48*0), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((1439 - 1)- 48*0), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((1439 - 1)- 48*0), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((1439 - 1)- 48*0), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((1439 - 1)- 48*0), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((1439 - 1)- 48*0), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((1439 - 1)- 48*0), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((1439 - 1)- 48*0), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((1439 - 1)- 48*0), true),
			18 => (A_ipd(18)'last_event, tpd_A_P((1439 - 1)- 48*0), true),
			19 => (A_ipd(19)'last_event, tpd_A_P((1439 - 1)- 48*0), true),
			20 => (A_ipd(20)'last_event, tpd_A_P((1439 - 1)- 48*0), true),
			21 => (A_ipd(21)'last_event, tpd_A_P((1439 - 1)- 48*0), true),
			22 => (A_ipd(22)'last_event, tpd_A_P((1439 - 1)- 48*0), true),
			23 => (A_ipd(23)'last_event, tpd_A_P((1439 - 1)- 48*0), true),
			24 => (A_ipd(24)'last_event, tpd_A_P((1439 - 1)- 48*0), true),
			25 => (A_ipd(25)'last_event, tpd_A_P((1439 - 1)- 48*0), true),
			26 => (A_ipd(26)'last_event, tpd_A_P((1439 - 1)- 48*0), true),
			27 => (A_ipd(27)'last_event, tpd_A_P((1439 - 1)- 48*0), true),
			28 => (A_ipd(28)'last_event, tpd_A_P((1439 - 1)- 48*0), true),
			29 => (A_ipd(29)'last_event, tpd_A_P((1439 - 1)- 48*0), true),
			30 => (ACIN_ipd(0)'last_event, tpd_ACIN_P((1439 - 1)- 48*0), true),
			31 => (ACIN_ipd(1)'last_event, tpd_ACIN_P((1439 - 1)- 48*0), true),
			32 => (ACIN_ipd(2)'last_event, tpd_ACIN_P((1439 - 1)- 48*0), true),
			33 => (ACIN_ipd(3)'last_event, tpd_ACIN_P((1439 - 1)- 48*0), true),
			34 => (ACIN_ipd(4)'last_event, tpd_ACIN_P((1439 - 1)- 48*0), true),
			35 => (ACIN_ipd(5)'last_event, tpd_ACIN_P((1439 - 1)- 48*0), true),
			36 => (ACIN_ipd(6)'last_event, tpd_ACIN_P((1439 - 1)- 48*0), true),
			37 => (ACIN_ipd(7)'last_event, tpd_ACIN_P((1439 - 1)- 48*0), true),
			38 => (ACIN_ipd(8)'last_event, tpd_ACIN_P((1439 - 1)- 48*0), true),
			39 => (ACIN_ipd(9)'last_event, tpd_ACIN_P((1439 - 1)- 48*0), true),
			40 => (ACIN_ipd(10)'last_event, tpd_ACIN_P((1439 - 1)- 48*0), true),
			41 => (ACIN_ipd(11)'last_event, tpd_ACIN_P((1439 - 1)- 48*0), true),
			42 => (ACIN_ipd(12)'last_event, tpd_ACIN_P((1439 - 1)- 48*0), true),
			43 => (ACIN_ipd(13)'last_event, tpd_ACIN_P((1439 - 1)- 48*0), true),
			44 => (ACIN_ipd(14)'last_event, tpd_ACIN_P((1439 - 1)- 48*0), true),
			45 => (ACIN_ipd(15)'last_event, tpd_ACIN_P((1439 - 1)- 48*0), true),
			46 => (ACIN_ipd(16)'last_event, tpd_ACIN_P((1439 - 1)- 48*0), true),
			47 => (ACIN_ipd(17)'last_event, tpd_ACIN_P((1439 - 1)- 48*0), true),
			48 => (ACIN_ipd(18)'last_event, tpd_ACIN_P((1439 - 1)- 48*0), true),
			49 => (ACIN_ipd(19)'last_event, tpd_ACIN_P((1439 - 1)- 48*0), true),
			50 => (ACIN_ipd(20)'last_event, tpd_ACIN_P((1439 - 1)- 48*0), true),
			51 => (ACIN_ipd(21)'last_event, tpd_ACIN_P((1439 - 1)- 48*0), true),
			52 => (ACIN_ipd(22)'last_event, tpd_ACIN_P((1439 - 1)- 48*0), true),
			53 => (ACIN_ipd(23)'last_event, tpd_ACIN_P((1439 - 1)- 48*0), true),
			54 => (ACIN_ipd(24)'last_event, tpd_ACIN_P((1439 - 1)- 48*0), true),
			55 => (ACIN_ipd(25)'last_event, tpd_ACIN_P((1439 - 1)- 48*0), true),
			56 => (ACIN_ipd(26)'last_event, tpd_ACIN_P((1439 - 1)- 48*0), true),
			57 => (ACIN_ipd(27)'last_event, tpd_ACIN_P((1439 - 1)- 48*0), true),
			58 => (ACIN_ipd(28)'last_event, tpd_ACIN_P((1439 - 1)- 48*0), true),
			59 => (ACIN_ipd(29)'last_event, tpd_ACIN_P((1439 - 1)- 48*0), true),
			60 => (ALUMODE_ipd(0)'last_event, tpd_ALUMODE_P((191 - 1)- 48*0), true),
			61 => (ALUMODE_ipd(1)'last_event, tpd_ALUMODE_P((191 - 1)- 48*0), true),
			62 => (ALUMODE_ipd(2)'last_event, tpd_ALUMODE_P((191 - 1)- 48*0), true),
			63 => (ALUMODE_ipd(3)'last_event, tpd_ALUMODE_P((191 - 1)- 48*0), true),
			64 => (B_ipd(0)'last_event, tpd_B_P((863 - 1)- 48*0), true),
			65 => (B_ipd(1)'last_event, tpd_B_P((863 - 1)- 48*0), true),
			66 => (B_ipd(2)'last_event, tpd_B_P((863 - 1)- 48*0), true),
			67 => (B_ipd(3)'last_event, tpd_B_P((863 - 1)- 48*0), true),
			68 => (B_ipd(4)'last_event, tpd_B_P((863 - 1)- 48*0), true),
			69 => (B_ipd(5)'last_event, tpd_B_P((863 - 1)- 48*0), true),
			70 => (B_ipd(6)'last_event, tpd_B_P((863 - 1)- 48*0), true),
			71 => (B_ipd(7)'last_event, tpd_B_P((863 - 1)- 48*0), true),
			72 => (B_ipd(8)'last_event, tpd_B_P((863 - 1)- 48*0), true),
			73 => (B_ipd(9)'last_event, tpd_B_P((863 - 1)- 48*0), true),
			74 => (B_ipd(10)'last_event, tpd_B_P((863 - 1)- 48*0), true),
			75 => (B_ipd(11)'last_event, tpd_B_P((863 - 1)- 48*0), true),
			76 => (B_ipd(12)'last_event, tpd_B_P((863 - 1)- 48*0), true),
			77 => (B_ipd(13)'last_event, tpd_B_P((863 - 1)- 48*0), true),
			78 => (B_ipd(14)'last_event, tpd_B_P((863 - 1)- 48*0), true),
			79 => (B_ipd(15)'last_event, tpd_B_P((863 - 1)- 48*0), true),
			80 => (B_ipd(16)'last_event, tpd_B_P((863 - 1)- 48*0), true),
			81 => (B_ipd(17)'last_event, tpd_B_P((863 - 1)- 48*0), true),
			82 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 1)- 48*0), true),
			83 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 1)- 48*0), true),
			84 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 1)- 48*0), true),
			85 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 1)- 48*0), true),
			86 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 1)- 48*0), true),
			87 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 1)- 48*0), true),
			88 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 1)- 48*0), true),
			89 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 1)- 48*0), true),
			90 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 1)- 48*0), true),
			91 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 1)- 48*0), true),
			92 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 1)- 48*0), true),
			93 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 1)- 48*0), true),
			94 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 1)- 48*0), true),
			95 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 1)- 48*0), true),
			96 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 1)- 48*0), true),
			97 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 1)- 48*0), true),
			98 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 1)- 48*0), true),
			99 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 1)- 48*0), true),
			100 => (C_ipd(0)'last_event, tpd_C_P((2303 - 1)- 48*0), true),
			101 => (C_ipd(1)'last_event, tpd_C_P((2303 - 1)- 48*0), true),
			102 => (C_ipd(2)'last_event, tpd_C_P((2303 - 1)- 48*0), true),
			103 => (C_ipd(3)'last_event, tpd_C_P((2303 - 1)- 48*0), true),
			104 => (C_ipd(4)'last_event, tpd_C_P((2303 - 1)- 48*0), true),
			105 => (C_ipd(5)'last_event, tpd_C_P((2303 - 1)- 48*0), true),
			106 => (C_ipd(6)'last_event, tpd_C_P((2303 - 1)- 48*0), true),
			107 => (C_ipd(7)'last_event, tpd_C_P((2303 - 1)- 48*0), true),
			108 => (C_ipd(8)'last_event, tpd_C_P((2303 - 1)- 48*0), true),
			109 => (C_ipd(9)'last_event, tpd_C_P((2303 - 1)- 48*0), true),
			110 => (C_ipd(10)'last_event, tpd_C_P((2303 - 1)- 48*0), true),
			111 => (C_ipd(11)'last_event, tpd_C_P((2303 - 1)- 48*0), true),
			112 => (C_ipd(12)'last_event, tpd_C_P((2303 - 1)- 48*0), true),
			113 => (C_ipd(13)'last_event, tpd_C_P((2303 - 1)- 48*0), true),
			114 => (C_ipd(14)'last_event, tpd_C_P((2303 - 1)- 48*0), true),
			115 => (C_ipd(15)'last_event, tpd_C_P((2303 - 1)- 48*0), true),
			116 => (C_ipd(16)'last_event, tpd_C_P((2303 - 1)- 48*0), true),
			117 => (C_ipd(17)'last_event, tpd_C_P((2303 - 1)- 48*0), true),
			118 => (C_ipd(18)'last_event, tpd_C_P((2303 - 1)- 48*0), true),
			119 => (C_ipd(19)'last_event, tpd_C_P((2303 - 1)- 48*0), true),
			120 => (C_ipd(20)'last_event, tpd_C_P((2303 - 1)- 48*0), true),
			121 => (C_ipd(21)'last_event, tpd_C_P((2303 - 1)- 48*0), true),
			122 => (C_ipd(22)'last_event, tpd_C_P((2303 - 1)- 48*0), true),
			123 => (C_ipd(23)'last_event, tpd_C_P((2303 - 1)- 48*0), true),
			124 => (C_ipd(24)'last_event, tpd_C_P((2303 - 1)- 48*0), true),
			125 => (C_ipd(25)'last_event, tpd_C_P((2303 - 1)- 48*0), true),
			126 => (C_ipd(26)'last_event, tpd_C_P((2303 - 1)- 48*0), true),
			127 => (C_ipd(27)'last_event, tpd_C_P((2303 - 1)- 48*0), true),
			128 => (C_ipd(28)'last_event, tpd_C_P((2303 - 1)- 48*0), true),
			129 => (C_ipd(29)'last_event, tpd_C_P((2303 - 1)- 48*0), true),
			130 => (C_ipd(30)'last_event, tpd_C_P((2303 - 1)- 48*0), true),
			131 => (C_ipd(31)'last_event, tpd_C_P((2303 - 1)- 48*0), true),
			132 => (C_ipd(32)'last_event, tpd_C_P((2303 - 1)- 48*0), true),
			133 => (C_ipd(33)'last_event, tpd_C_P((2303 - 1)- 48*0), true),
			134 => (C_ipd(34)'last_event, tpd_C_P((2303 - 1)- 48*0), true),
			135 => (C_ipd(35)'last_event, tpd_C_P((2303 - 1)- 48*0), true),
			136 => (C_ipd(36)'last_event, tpd_C_P((2303 - 1)- 48*0), true),
			137 => (C_ipd(37)'last_event, tpd_C_P((2303 - 1)- 48*0), true),
			138 => (C_ipd(38)'last_event, tpd_C_P((2303 - 1)- 48*0), true),
			139 => (C_ipd(39)'last_event, tpd_C_P((2303 - 1)- 48*0), true),
			140 => (C_ipd(40)'last_event, tpd_C_P((2303 - 1)- 48*0), true),
			141 => (C_ipd(41)'last_event, tpd_C_P((2303 - 1)- 48*0), true),
			142 => (C_ipd(42)'last_event, tpd_C_P((2303 - 1)- 48*0), true),
			143 => (C_ipd(43)'last_event, tpd_C_P((2303 - 1)- 48*0), true),
			144 => (C_ipd(44)'last_event, tpd_C_P((2303 - 1)- 48*0), true),
			145 => (C_ipd(45)'last_event, tpd_C_P((2303 - 1)- 48*0), true),
			146 => (C_ipd(46)'last_event, tpd_C_P((2303 - 1)- 48*0), true),
			147 => (C_ipd(47)'last_event, tpd_C_P((2303 - 1)- 48*0), true),
			148 => (CARRYCASCIN_ipd'last_event, tpd_CARRYCASCIN_P(46), true),
			149 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(46), true),
			150 => (CARRYINSEL_ipd(0)'last_event, tpd_CARRYINSEL_P((143 - 1)- 48*0), true),
			151 => (CARRYINSEL_ipd(1)'last_event, tpd_CARRYINSEL_P((143 - 1)- 48*0), true),
			152 => (CARRYINSEL_ipd(2)'last_event, tpd_CARRYINSEL_P((143 - 1)- 48*0), true),
			153 => (MULTSIGNIN_ipd'last_event, tpd_MULTSIGNIN_P(46), true),
			154 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 1)- 48*0), true),
			155 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 1)- 48*0), true),
			156 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 1)- 48*0), true),
			157 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 1)- 48*0), true),
			158 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 1)- 48*0), true),
			159 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 1)- 48*0), true),
			160 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 1)- 48*0), true),
			161 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 1)- 48*0), true),
			162 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 1)- 48*0), true),
			163 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 1)- 48*0), true),
			164 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 1)- 48*0), true),
			165 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 1)- 48*0), true),
			166 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 1)- 48*0), true),
			167 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 1)- 48*0), true),
			168 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 1)- 48*0), true),
			169 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 1)- 48*0), true),
			170 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 1)- 48*0), true),
			171 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 1)- 48*0), true),
			172 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 1)- 48*0), true),
			173 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 1)- 48*0), true),
			174 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 1)- 48*0), true),
			175 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 1)- 48*0), true),
			176 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 1)- 48*0), true),
			177 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 1)- 48*0), true),
			178 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 1)- 48*0), true),
			179 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 1)- 48*0), true),
			180 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 1)- 48*0), true),
			181 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 1)- 48*0), true),
			182 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 1)- 48*0), true),
			183 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 1)- 48*0), true),
			184 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 1)- 48*0), true),
			185 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 1)- 48*0), true),
			186 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 1)- 48*0), true),
			187 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 1)- 48*0), true),
			188 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 1)- 48*0), true),
			189 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 1)- 48*0), true),
			190 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 1)- 48*0), true),
			191 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 1)- 48*0), true),
			192 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 1)- 48*0), true),
			193 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 1)- 48*0), true),
			194 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 1)- 48*0), true),
			195 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 1)- 48*0), true),
			196 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 1)- 48*0), true),
			197 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 1)- 48*0), true),
			198 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 1)- 48*0), true),
			199 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 1)- 48*0), true),
			200 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 1)- 48*0), true),
			201 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 1)- 48*0), true),
			202 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 1)- 48*0), true),
			203 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 1)- 48*0), true),
			204 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 1)- 48*0), true),
			205 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 1)- 48*0), true),
			206 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 1)- 48*0), true),
			207 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 1)- 48*0), true),
			208 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 1)- 48*0), true),
			209 => (CLK_dly'last_event, tpd_CLK_P(46), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(45),
         GlitchData	=> P_GlitchData(45),
         OutSignalName	=> "P(45)",
         OutTemp	=> P_zd(45),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((1439 - 2)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((1439 - 2)- 48*0), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((1439 - 2)- 48*0), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((1439 - 2)- 48*0), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((1439 - 2)- 48*0), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((1439 - 2)- 48*0), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((1439 - 2)- 48*0), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((1439 - 2)- 48*0), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((1439 - 2)- 48*0), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((1439 - 2)- 48*0), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((1439 - 2)- 48*0), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((1439 - 2)- 48*0), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((1439 - 2)- 48*0), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((1439 - 2)- 48*0), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((1439 - 2)- 48*0), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((1439 - 2)- 48*0), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((1439 - 2)- 48*0), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((1439 - 2)- 48*0), true),
			18 => (A_ipd(18)'last_event, tpd_A_P((1439 - 2)- 48*0), true),
			19 => (A_ipd(19)'last_event, tpd_A_P((1439 - 2)- 48*0), true),
			20 => (A_ipd(20)'last_event, tpd_A_P((1439 - 2)- 48*0), true),
			21 => (A_ipd(21)'last_event, tpd_A_P((1439 - 2)- 48*0), true),
			22 => (A_ipd(22)'last_event, tpd_A_P((1439 - 2)- 48*0), true),
			23 => (A_ipd(23)'last_event, tpd_A_P((1439 - 2)- 48*0), true),
			24 => (A_ipd(24)'last_event, tpd_A_P((1439 - 2)- 48*0), true),
			25 => (A_ipd(25)'last_event, tpd_A_P((1439 - 2)- 48*0), true),
			26 => (A_ipd(26)'last_event, tpd_A_P((1439 - 2)- 48*0), true),
			27 => (A_ipd(27)'last_event, tpd_A_P((1439 - 2)- 48*0), true),
			28 => (A_ipd(28)'last_event, tpd_A_P((1439 - 2)- 48*0), true),
			29 => (A_ipd(29)'last_event, tpd_A_P((1439 - 2)- 48*0), true),
			30 => (ACIN_ipd(0)'last_event, tpd_ACIN_P((1439 - 2)- 48*0), true),
			31 => (ACIN_ipd(1)'last_event, tpd_ACIN_P((1439 - 2)- 48*0), true),
			32 => (ACIN_ipd(2)'last_event, tpd_ACIN_P((1439 - 2)- 48*0), true),
			33 => (ACIN_ipd(3)'last_event, tpd_ACIN_P((1439 - 2)- 48*0), true),
			34 => (ACIN_ipd(4)'last_event, tpd_ACIN_P((1439 - 2)- 48*0), true),
			35 => (ACIN_ipd(5)'last_event, tpd_ACIN_P((1439 - 2)- 48*0), true),
			36 => (ACIN_ipd(6)'last_event, tpd_ACIN_P((1439 - 2)- 48*0), true),
			37 => (ACIN_ipd(7)'last_event, tpd_ACIN_P((1439 - 2)- 48*0), true),
			38 => (ACIN_ipd(8)'last_event, tpd_ACIN_P((1439 - 2)- 48*0), true),
			39 => (ACIN_ipd(9)'last_event, tpd_ACIN_P((1439 - 2)- 48*0), true),
			40 => (ACIN_ipd(10)'last_event, tpd_ACIN_P((1439 - 2)- 48*0), true),
			41 => (ACIN_ipd(11)'last_event, tpd_ACIN_P((1439 - 2)- 48*0), true),
			42 => (ACIN_ipd(12)'last_event, tpd_ACIN_P((1439 - 2)- 48*0), true),
			43 => (ACIN_ipd(13)'last_event, tpd_ACIN_P((1439 - 2)- 48*0), true),
			44 => (ACIN_ipd(14)'last_event, tpd_ACIN_P((1439 - 2)- 48*0), true),
			45 => (ACIN_ipd(15)'last_event, tpd_ACIN_P((1439 - 2)- 48*0), true),
			46 => (ACIN_ipd(16)'last_event, tpd_ACIN_P((1439 - 2)- 48*0), true),
			47 => (ACIN_ipd(17)'last_event, tpd_ACIN_P((1439 - 2)- 48*0), true),
			48 => (ACIN_ipd(18)'last_event, tpd_ACIN_P((1439 - 2)- 48*0), true),
			49 => (ACIN_ipd(19)'last_event, tpd_ACIN_P((1439 - 2)- 48*0), true),
			50 => (ACIN_ipd(20)'last_event, tpd_ACIN_P((1439 - 2)- 48*0), true),
			51 => (ACIN_ipd(21)'last_event, tpd_ACIN_P((1439 - 2)- 48*0), true),
			52 => (ACIN_ipd(22)'last_event, tpd_ACIN_P((1439 - 2)- 48*0), true),
			53 => (ACIN_ipd(23)'last_event, tpd_ACIN_P((1439 - 2)- 48*0), true),
			54 => (ACIN_ipd(24)'last_event, tpd_ACIN_P((1439 - 2)- 48*0), true),
			55 => (ACIN_ipd(25)'last_event, tpd_ACIN_P((1439 - 2)- 48*0), true),
			56 => (ACIN_ipd(26)'last_event, tpd_ACIN_P((1439 - 2)- 48*0), true),
			57 => (ACIN_ipd(27)'last_event, tpd_ACIN_P((1439 - 2)- 48*0), true),
			58 => (ACIN_ipd(28)'last_event, tpd_ACIN_P((1439 - 2)- 48*0), true),
			59 => (ACIN_ipd(29)'last_event, tpd_ACIN_P((1439 - 2)- 48*0), true),
			60 => (ALUMODE_ipd(0)'last_event, tpd_ALUMODE_P((191 - 2)- 48*0), true),
			61 => (ALUMODE_ipd(1)'last_event, tpd_ALUMODE_P((191 - 2)- 48*0), true),
			62 => (ALUMODE_ipd(2)'last_event, tpd_ALUMODE_P((191 - 2)- 48*0), true),
			63 => (ALUMODE_ipd(3)'last_event, tpd_ALUMODE_P((191 - 2)- 48*0), true),
			64 => (B_ipd(0)'last_event, tpd_B_P((863 - 2)- 48*0), true),
			65 => (B_ipd(1)'last_event, tpd_B_P((863 - 2)- 48*0), true),
			66 => (B_ipd(2)'last_event, tpd_B_P((863 - 2)- 48*0), true),
			67 => (B_ipd(3)'last_event, tpd_B_P((863 - 2)- 48*0), true),
			68 => (B_ipd(4)'last_event, tpd_B_P((863 - 2)- 48*0), true),
			69 => (B_ipd(5)'last_event, tpd_B_P((863 - 2)- 48*0), true),
			70 => (B_ipd(6)'last_event, tpd_B_P((863 - 2)- 48*0), true),
			71 => (B_ipd(7)'last_event, tpd_B_P((863 - 2)- 48*0), true),
			72 => (B_ipd(8)'last_event, tpd_B_P((863 - 2)- 48*0), true),
			73 => (B_ipd(9)'last_event, tpd_B_P((863 - 2)- 48*0), true),
			74 => (B_ipd(10)'last_event, tpd_B_P((863 - 2)- 48*0), true),
			75 => (B_ipd(11)'last_event, tpd_B_P((863 - 2)- 48*0), true),
			76 => (B_ipd(12)'last_event, tpd_B_P((863 - 2)- 48*0), true),
			77 => (B_ipd(13)'last_event, tpd_B_P((863 - 2)- 48*0), true),
			78 => (B_ipd(14)'last_event, tpd_B_P((863 - 2)- 48*0), true),
			79 => (B_ipd(15)'last_event, tpd_B_P((863 - 2)- 48*0), true),
			80 => (B_ipd(16)'last_event, tpd_B_P((863 - 2)- 48*0), true),
			81 => (B_ipd(17)'last_event, tpd_B_P((863 - 2)- 48*0), true),
			82 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 2)- 48*0), true),
			83 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 2)- 48*0), true),
			84 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 2)- 48*0), true),
			85 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 2)- 48*0), true),
			86 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 2)- 48*0), true),
			87 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 2)- 48*0), true),
			88 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 2)- 48*0), true),
			89 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 2)- 48*0), true),
			90 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 2)- 48*0), true),
			91 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 2)- 48*0), true),
			92 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 2)- 48*0), true),
			93 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 2)- 48*0), true),
			94 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 2)- 48*0), true),
			95 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 2)- 48*0), true),
			96 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 2)- 48*0), true),
			97 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 2)- 48*0), true),
			98 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 2)- 48*0), true),
			99 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 2)- 48*0), true),
			100 => (C_ipd(0)'last_event, tpd_C_P((2303 - 2)- 48*0), true),
			101 => (C_ipd(1)'last_event, tpd_C_P((2303 - 2)- 48*0), true),
			102 => (C_ipd(2)'last_event, tpd_C_P((2303 - 2)- 48*0), true),
			103 => (C_ipd(3)'last_event, tpd_C_P((2303 - 2)- 48*0), true),
			104 => (C_ipd(4)'last_event, tpd_C_P((2303 - 2)- 48*0), true),
			105 => (C_ipd(5)'last_event, tpd_C_P((2303 - 2)- 48*0), true),
			106 => (C_ipd(6)'last_event, tpd_C_P((2303 - 2)- 48*0), true),
			107 => (C_ipd(7)'last_event, tpd_C_P((2303 - 2)- 48*0), true),
			108 => (C_ipd(8)'last_event, tpd_C_P((2303 - 2)- 48*0), true),
			109 => (C_ipd(9)'last_event, tpd_C_P((2303 - 2)- 48*0), true),
			110 => (C_ipd(10)'last_event, tpd_C_P((2303 - 2)- 48*0), true),
			111 => (C_ipd(11)'last_event, tpd_C_P((2303 - 2)- 48*0), true),
			112 => (C_ipd(12)'last_event, tpd_C_P((2303 - 2)- 48*0), true),
			113 => (C_ipd(13)'last_event, tpd_C_P((2303 - 2)- 48*0), true),
			114 => (C_ipd(14)'last_event, tpd_C_P((2303 - 2)- 48*0), true),
			115 => (C_ipd(15)'last_event, tpd_C_P((2303 - 2)- 48*0), true),
			116 => (C_ipd(16)'last_event, tpd_C_P((2303 - 2)- 48*0), true),
			117 => (C_ipd(17)'last_event, tpd_C_P((2303 - 2)- 48*0), true),
			118 => (C_ipd(18)'last_event, tpd_C_P((2303 - 2)- 48*0), true),
			119 => (C_ipd(19)'last_event, tpd_C_P((2303 - 2)- 48*0), true),
			120 => (C_ipd(20)'last_event, tpd_C_P((2303 - 2)- 48*0), true),
			121 => (C_ipd(21)'last_event, tpd_C_P((2303 - 2)- 48*0), true),
			122 => (C_ipd(22)'last_event, tpd_C_P((2303 - 2)- 48*0), true),
			123 => (C_ipd(23)'last_event, tpd_C_P((2303 - 2)- 48*0), true),
			124 => (C_ipd(24)'last_event, tpd_C_P((2303 - 2)- 48*0), true),
			125 => (C_ipd(25)'last_event, tpd_C_P((2303 - 2)- 48*0), true),
			126 => (C_ipd(26)'last_event, tpd_C_P((2303 - 2)- 48*0), true),
			127 => (C_ipd(27)'last_event, tpd_C_P((2303 - 2)- 48*0), true),
			128 => (C_ipd(28)'last_event, tpd_C_P((2303 - 2)- 48*0), true),
			129 => (C_ipd(29)'last_event, tpd_C_P((2303 - 2)- 48*0), true),
			130 => (C_ipd(30)'last_event, tpd_C_P((2303 - 2)- 48*0), true),
			131 => (C_ipd(31)'last_event, tpd_C_P((2303 - 2)- 48*0), true),
			132 => (C_ipd(32)'last_event, tpd_C_P((2303 - 2)- 48*0), true),
			133 => (C_ipd(33)'last_event, tpd_C_P((2303 - 2)- 48*0), true),
			134 => (C_ipd(34)'last_event, tpd_C_P((2303 - 2)- 48*0), true),
			135 => (C_ipd(35)'last_event, tpd_C_P((2303 - 2)- 48*0), true),
			136 => (C_ipd(36)'last_event, tpd_C_P((2303 - 2)- 48*0), true),
			137 => (C_ipd(37)'last_event, tpd_C_P((2303 - 2)- 48*0), true),
			138 => (C_ipd(38)'last_event, tpd_C_P((2303 - 2)- 48*0), true),
			139 => (C_ipd(39)'last_event, tpd_C_P((2303 - 2)- 48*0), true),
			140 => (C_ipd(40)'last_event, tpd_C_P((2303 - 2)- 48*0), true),
			141 => (C_ipd(41)'last_event, tpd_C_P((2303 - 2)- 48*0), true),
			142 => (C_ipd(42)'last_event, tpd_C_P((2303 - 2)- 48*0), true),
			143 => (C_ipd(43)'last_event, tpd_C_P((2303 - 2)- 48*0), true),
			144 => (C_ipd(44)'last_event, tpd_C_P((2303 - 2)- 48*0), true),
			145 => (C_ipd(45)'last_event, tpd_C_P((2303 - 2)- 48*0), true),
			146 => (C_ipd(46)'last_event, tpd_C_P((2303 - 2)- 48*0), true),
			147 => (C_ipd(47)'last_event, tpd_C_P((2303 - 2)- 48*0), true),
			148 => (CARRYCASCIN_ipd'last_event, tpd_CARRYCASCIN_P(45), true),
			149 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(45), true),
			150 => (CARRYINSEL_ipd(0)'last_event, tpd_CARRYINSEL_P((143 - 2)- 48*0), true),
			151 => (CARRYINSEL_ipd(1)'last_event, tpd_CARRYINSEL_P((143 - 2)- 48*0), true),
			152 => (CARRYINSEL_ipd(2)'last_event, tpd_CARRYINSEL_P((143 - 2)- 48*0), true),
			153 => (MULTSIGNIN_ipd'last_event, tpd_MULTSIGNIN_P(45), true),
			154 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 2)- 48*0), true),
			155 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 2)- 48*0), true),
			156 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 2)- 48*0), true),
			157 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 2)- 48*0), true),
			158 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 2)- 48*0), true),
			159 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 2)- 48*0), true),
			160 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 2)- 48*0), true),
			161 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 2)- 48*0), true),
			162 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 2)- 48*0), true),
			163 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 2)- 48*0), true),
			164 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 2)- 48*0), true),
			165 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 2)- 48*0), true),
			166 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 2)- 48*0), true),
			167 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 2)- 48*0), true),
			168 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 2)- 48*0), true),
			169 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 2)- 48*0), true),
			170 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 2)- 48*0), true),
			171 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 2)- 48*0), true),
			172 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 2)- 48*0), true),
			173 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 2)- 48*0), true),
			174 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 2)- 48*0), true),
			175 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 2)- 48*0), true),
			176 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 2)- 48*0), true),
			177 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 2)- 48*0), true),
			178 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 2)- 48*0), true),
			179 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 2)- 48*0), true),
			180 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 2)- 48*0), true),
			181 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 2)- 48*0), true),
			182 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 2)- 48*0), true),
			183 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 2)- 48*0), true),
			184 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 2)- 48*0), true),
			185 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 2)- 48*0), true),
			186 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 2)- 48*0), true),
			187 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 2)- 48*0), true),
			188 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 2)- 48*0), true),
			189 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 2)- 48*0), true),
			190 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 2)- 48*0), true),
			191 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 2)- 48*0), true),
			192 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 2)- 48*0), true),
			193 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 2)- 48*0), true),
			194 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 2)- 48*0), true),
			195 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 2)- 48*0), true),
			196 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 2)- 48*0), true),
			197 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 2)- 48*0), true),
			198 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 2)- 48*0), true),
			199 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 2)- 48*0), true),
			200 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 2)- 48*0), true),
			201 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 2)- 48*0), true),
			202 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 2)- 48*0), true),
			203 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 2)- 48*0), true),
			204 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 2)- 48*0), true),
			205 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 2)- 48*0), true),
			206 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 2)- 48*0), true),
			207 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 2)- 48*0), true),
			208 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 2)- 48*0), true),
			209 => (CLK_dly'last_event, tpd_CLK_P(45), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(44),
         GlitchData	=> P_GlitchData(44),
         OutSignalName	=> "P(44)",
         OutTemp	=> P_zd(44),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((1439 - 3)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((1439 - 3)- 48*0), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((1439 - 3)- 48*0), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((1439 - 3)- 48*0), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((1439 - 3)- 48*0), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((1439 - 3)- 48*0), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((1439 - 3)- 48*0), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((1439 - 3)- 48*0), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((1439 - 3)- 48*0), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((1439 - 3)- 48*0), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((1439 - 3)- 48*0), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((1439 - 3)- 48*0), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((1439 - 3)- 48*0), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((1439 - 3)- 48*0), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((1439 - 3)- 48*0), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((1439 - 3)- 48*0), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((1439 - 3)- 48*0), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((1439 - 3)- 48*0), true),
			18 => (A_ipd(18)'last_event, tpd_A_P((1439 - 3)- 48*0), true),
			19 => (A_ipd(19)'last_event, tpd_A_P((1439 - 3)- 48*0), true),
			20 => (A_ipd(20)'last_event, tpd_A_P((1439 - 3)- 48*0), true),
			21 => (A_ipd(21)'last_event, tpd_A_P((1439 - 3)- 48*0), true),
			22 => (A_ipd(22)'last_event, tpd_A_P((1439 - 3)- 48*0), true),
			23 => (A_ipd(23)'last_event, tpd_A_P((1439 - 3)- 48*0), true),
			24 => (A_ipd(24)'last_event, tpd_A_P((1439 - 3)- 48*0), true),
			25 => (A_ipd(25)'last_event, tpd_A_P((1439 - 3)- 48*0), true),
			26 => (A_ipd(26)'last_event, tpd_A_P((1439 - 3)- 48*0), true),
			27 => (A_ipd(27)'last_event, tpd_A_P((1439 - 3)- 48*0), true),
			28 => (A_ipd(28)'last_event, tpd_A_P((1439 - 3)- 48*0), true),
			29 => (A_ipd(29)'last_event, tpd_A_P((1439 - 3)- 48*0), true),
			30 => (ACIN_ipd(0)'last_event, tpd_ACIN_P((1439 - 3)- 48*0), true),
			31 => (ACIN_ipd(1)'last_event, tpd_ACIN_P((1439 - 3)- 48*0), true),
			32 => (ACIN_ipd(2)'last_event, tpd_ACIN_P((1439 - 3)- 48*0), true),
			33 => (ACIN_ipd(3)'last_event, tpd_ACIN_P((1439 - 3)- 48*0), true),
			34 => (ACIN_ipd(4)'last_event, tpd_ACIN_P((1439 - 3)- 48*0), true),
			35 => (ACIN_ipd(5)'last_event, tpd_ACIN_P((1439 - 3)- 48*0), true),
			36 => (ACIN_ipd(6)'last_event, tpd_ACIN_P((1439 - 3)- 48*0), true),
			37 => (ACIN_ipd(7)'last_event, tpd_ACIN_P((1439 - 3)- 48*0), true),
			38 => (ACIN_ipd(8)'last_event, tpd_ACIN_P((1439 - 3)- 48*0), true),
			39 => (ACIN_ipd(9)'last_event, tpd_ACIN_P((1439 - 3)- 48*0), true),
			40 => (ACIN_ipd(10)'last_event, tpd_ACIN_P((1439 - 3)- 48*0), true),
			41 => (ACIN_ipd(11)'last_event, tpd_ACIN_P((1439 - 3)- 48*0), true),
			42 => (ACIN_ipd(12)'last_event, tpd_ACIN_P((1439 - 3)- 48*0), true),
			43 => (ACIN_ipd(13)'last_event, tpd_ACIN_P((1439 - 3)- 48*0), true),
			44 => (ACIN_ipd(14)'last_event, tpd_ACIN_P((1439 - 3)- 48*0), true),
			45 => (ACIN_ipd(15)'last_event, tpd_ACIN_P((1439 - 3)- 48*0), true),
			46 => (ACIN_ipd(16)'last_event, tpd_ACIN_P((1439 - 3)- 48*0), true),
			47 => (ACIN_ipd(17)'last_event, tpd_ACIN_P((1439 - 3)- 48*0), true),
			48 => (ACIN_ipd(18)'last_event, tpd_ACIN_P((1439 - 3)- 48*0), true),
			49 => (ACIN_ipd(19)'last_event, tpd_ACIN_P((1439 - 3)- 48*0), true),
			50 => (ACIN_ipd(20)'last_event, tpd_ACIN_P((1439 - 3)- 48*0), true),
			51 => (ACIN_ipd(21)'last_event, tpd_ACIN_P((1439 - 3)- 48*0), true),
			52 => (ACIN_ipd(22)'last_event, tpd_ACIN_P((1439 - 3)- 48*0), true),
			53 => (ACIN_ipd(23)'last_event, tpd_ACIN_P((1439 - 3)- 48*0), true),
			54 => (ACIN_ipd(24)'last_event, tpd_ACIN_P((1439 - 3)- 48*0), true),
			55 => (ACIN_ipd(25)'last_event, tpd_ACIN_P((1439 - 3)- 48*0), true),
			56 => (ACIN_ipd(26)'last_event, tpd_ACIN_P((1439 - 3)- 48*0), true),
			57 => (ACIN_ipd(27)'last_event, tpd_ACIN_P((1439 - 3)- 48*0), true),
			58 => (ACIN_ipd(28)'last_event, tpd_ACIN_P((1439 - 3)- 48*0), true),
			59 => (ACIN_ipd(29)'last_event, tpd_ACIN_P((1439 - 3)- 48*0), true),
			60 => (ALUMODE_ipd(0)'last_event, tpd_ALUMODE_P((191 - 3)- 48*0), true),
			61 => (ALUMODE_ipd(1)'last_event, tpd_ALUMODE_P((191 - 3)- 48*0), true),
			62 => (ALUMODE_ipd(2)'last_event, tpd_ALUMODE_P((191 - 3)- 48*0), true),
			63 => (ALUMODE_ipd(3)'last_event, tpd_ALUMODE_P((191 - 3)- 48*0), true),
			64 => (B_ipd(0)'last_event, tpd_B_P((863 - 3)- 48*0), true),
			65 => (B_ipd(1)'last_event, tpd_B_P((863 - 3)- 48*0), true),
			66 => (B_ipd(2)'last_event, tpd_B_P((863 - 3)- 48*0), true),
			67 => (B_ipd(3)'last_event, tpd_B_P((863 - 3)- 48*0), true),
			68 => (B_ipd(4)'last_event, tpd_B_P((863 - 3)- 48*0), true),
			69 => (B_ipd(5)'last_event, tpd_B_P((863 - 3)- 48*0), true),
			70 => (B_ipd(6)'last_event, tpd_B_P((863 - 3)- 48*0), true),
			71 => (B_ipd(7)'last_event, tpd_B_P((863 - 3)- 48*0), true),
			72 => (B_ipd(8)'last_event, tpd_B_P((863 - 3)- 48*0), true),
			73 => (B_ipd(9)'last_event, tpd_B_P((863 - 3)- 48*0), true),
			74 => (B_ipd(10)'last_event, tpd_B_P((863 - 3)- 48*0), true),
			75 => (B_ipd(11)'last_event, tpd_B_P((863 - 3)- 48*0), true),
			76 => (B_ipd(12)'last_event, tpd_B_P((863 - 3)- 48*0), true),
			77 => (B_ipd(13)'last_event, tpd_B_P((863 - 3)- 48*0), true),
			78 => (B_ipd(14)'last_event, tpd_B_P((863 - 3)- 48*0), true),
			79 => (B_ipd(15)'last_event, tpd_B_P((863 - 3)- 48*0), true),
			80 => (B_ipd(16)'last_event, tpd_B_P((863 - 3)- 48*0), true),
			81 => (B_ipd(17)'last_event, tpd_B_P((863 - 3)- 48*0), true),
			82 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 3)- 48*0), true),
			83 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 3)- 48*0), true),
			84 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 3)- 48*0), true),
			85 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 3)- 48*0), true),
			86 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 3)- 48*0), true),
			87 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 3)- 48*0), true),
			88 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 3)- 48*0), true),
			89 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 3)- 48*0), true),
			90 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 3)- 48*0), true),
			91 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 3)- 48*0), true),
			92 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 3)- 48*0), true),
			93 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 3)- 48*0), true),
			94 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 3)- 48*0), true),
			95 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 3)- 48*0), true),
			96 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 3)- 48*0), true),
			97 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 3)- 48*0), true),
			98 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 3)- 48*0), true),
			99 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 3)- 48*0), true),
			100 => (C_ipd(0)'last_event, tpd_C_P((2303 - 3)- 48*0), true),
			101 => (C_ipd(1)'last_event, tpd_C_P((2303 - 3)- 48*0), true),
			102 => (C_ipd(2)'last_event, tpd_C_P((2303 - 3)- 48*0), true),
			103 => (C_ipd(3)'last_event, tpd_C_P((2303 - 3)- 48*0), true),
			104 => (C_ipd(4)'last_event, tpd_C_P((2303 - 3)- 48*0), true),
			105 => (C_ipd(5)'last_event, tpd_C_P((2303 - 3)- 48*0), true),
			106 => (C_ipd(6)'last_event, tpd_C_P((2303 - 3)- 48*0), true),
			107 => (C_ipd(7)'last_event, tpd_C_P((2303 - 3)- 48*0), true),
			108 => (C_ipd(8)'last_event, tpd_C_P((2303 - 3)- 48*0), true),
			109 => (C_ipd(9)'last_event, tpd_C_P((2303 - 3)- 48*0), true),
			110 => (C_ipd(10)'last_event, tpd_C_P((2303 - 3)- 48*0), true),
			111 => (C_ipd(11)'last_event, tpd_C_P((2303 - 3)- 48*0), true),
			112 => (C_ipd(12)'last_event, tpd_C_P((2303 - 3)- 48*0), true),
			113 => (C_ipd(13)'last_event, tpd_C_P((2303 - 3)- 48*0), true),
			114 => (C_ipd(14)'last_event, tpd_C_P((2303 - 3)- 48*0), true),
			115 => (C_ipd(15)'last_event, tpd_C_P((2303 - 3)- 48*0), true),
			116 => (C_ipd(16)'last_event, tpd_C_P((2303 - 3)- 48*0), true),
			117 => (C_ipd(17)'last_event, tpd_C_P((2303 - 3)- 48*0), true),
			118 => (C_ipd(18)'last_event, tpd_C_P((2303 - 3)- 48*0), true),
			119 => (C_ipd(19)'last_event, tpd_C_P((2303 - 3)- 48*0), true),
			120 => (C_ipd(20)'last_event, tpd_C_P((2303 - 3)- 48*0), true),
			121 => (C_ipd(21)'last_event, tpd_C_P((2303 - 3)- 48*0), true),
			122 => (C_ipd(22)'last_event, tpd_C_P((2303 - 3)- 48*0), true),
			123 => (C_ipd(23)'last_event, tpd_C_P((2303 - 3)- 48*0), true),
			124 => (C_ipd(24)'last_event, tpd_C_P((2303 - 3)- 48*0), true),
			125 => (C_ipd(25)'last_event, tpd_C_P((2303 - 3)- 48*0), true),
			126 => (C_ipd(26)'last_event, tpd_C_P((2303 - 3)- 48*0), true),
			127 => (C_ipd(27)'last_event, tpd_C_P((2303 - 3)- 48*0), true),
			128 => (C_ipd(28)'last_event, tpd_C_P((2303 - 3)- 48*0), true),
			129 => (C_ipd(29)'last_event, tpd_C_P((2303 - 3)- 48*0), true),
			130 => (C_ipd(30)'last_event, tpd_C_P((2303 - 3)- 48*0), true),
			131 => (C_ipd(31)'last_event, tpd_C_P((2303 - 3)- 48*0), true),
			132 => (C_ipd(32)'last_event, tpd_C_P((2303 - 3)- 48*0), true),
			133 => (C_ipd(33)'last_event, tpd_C_P((2303 - 3)- 48*0), true),
			134 => (C_ipd(34)'last_event, tpd_C_P((2303 - 3)- 48*0), true),
			135 => (C_ipd(35)'last_event, tpd_C_P((2303 - 3)- 48*0), true),
			136 => (C_ipd(36)'last_event, tpd_C_P((2303 - 3)- 48*0), true),
			137 => (C_ipd(37)'last_event, tpd_C_P((2303 - 3)- 48*0), true),
			138 => (C_ipd(38)'last_event, tpd_C_P((2303 - 3)- 48*0), true),
			139 => (C_ipd(39)'last_event, tpd_C_P((2303 - 3)- 48*0), true),
			140 => (C_ipd(40)'last_event, tpd_C_P((2303 - 3)- 48*0), true),
			141 => (C_ipd(41)'last_event, tpd_C_P((2303 - 3)- 48*0), true),
			142 => (C_ipd(42)'last_event, tpd_C_P((2303 - 3)- 48*0), true),
			143 => (C_ipd(43)'last_event, tpd_C_P((2303 - 3)- 48*0), true),
			144 => (C_ipd(44)'last_event, tpd_C_P((2303 - 3)- 48*0), true),
			145 => (C_ipd(45)'last_event, tpd_C_P((2303 - 3)- 48*0), true),
			146 => (C_ipd(46)'last_event, tpd_C_P((2303 - 3)- 48*0), true),
			147 => (C_ipd(47)'last_event, tpd_C_P((2303 - 3)- 48*0), true),
			148 => (CARRYCASCIN_ipd'last_event, tpd_CARRYCASCIN_P(44), true),
			149 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(44), true),
			150 => (CARRYINSEL_ipd(0)'last_event, tpd_CARRYINSEL_P((143 - 3)- 48*0), true),
			151 => (CARRYINSEL_ipd(1)'last_event, tpd_CARRYINSEL_P((143 - 3)- 48*0), true),
			152 => (CARRYINSEL_ipd(2)'last_event, tpd_CARRYINSEL_P((143 - 3)- 48*0), true),
			153 => (MULTSIGNIN_ipd'last_event, tpd_MULTSIGNIN_P(44), true),
			154 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 3)- 48*0), true),
			155 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 3)- 48*0), true),
			156 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 3)- 48*0), true),
			157 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 3)- 48*0), true),
			158 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 3)- 48*0), true),
			159 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 3)- 48*0), true),
			160 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 3)- 48*0), true),
			161 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 3)- 48*0), true),
			162 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 3)- 48*0), true),
			163 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 3)- 48*0), true),
			164 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 3)- 48*0), true),
			165 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 3)- 48*0), true),
			166 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 3)- 48*0), true),
			167 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 3)- 48*0), true),
			168 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 3)- 48*0), true),
			169 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 3)- 48*0), true),
			170 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 3)- 48*0), true),
			171 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 3)- 48*0), true),
			172 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 3)- 48*0), true),
			173 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 3)- 48*0), true),
			174 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 3)- 48*0), true),
			175 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 3)- 48*0), true),
			176 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 3)- 48*0), true),
			177 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 3)- 48*0), true),
			178 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 3)- 48*0), true),
			179 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 3)- 48*0), true),
			180 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 3)- 48*0), true),
			181 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 3)- 48*0), true),
			182 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 3)- 48*0), true),
			183 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 3)- 48*0), true),
			184 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 3)- 48*0), true),
			185 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 3)- 48*0), true),
			186 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 3)- 48*0), true),
			187 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 3)- 48*0), true),
			188 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 3)- 48*0), true),
			189 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 3)- 48*0), true),
			190 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 3)- 48*0), true),
			191 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 3)- 48*0), true),
			192 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 3)- 48*0), true),
			193 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 3)- 48*0), true),
			194 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 3)- 48*0), true),
			195 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 3)- 48*0), true),
			196 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 3)- 48*0), true),
			197 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 3)- 48*0), true),
			198 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 3)- 48*0), true),
			199 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 3)- 48*0), true),
			200 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 3)- 48*0), true),
			201 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 3)- 48*0), true),
			202 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 3)- 48*0), true),
			203 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 3)- 48*0), true),
			204 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 3)- 48*0), true),
			205 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 3)- 48*0), true),
			206 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 3)- 48*0), true),
			207 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 3)- 48*0), true),
			208 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 3)- 48*0), true),
			209 => (CLK_dly'last_event, tpd_CLK_P(44), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(43),
         GlitchData	=> P_GlitchData(43),
         OutSignalName	=> "P(43)",
         OutTemp	=> P_zd(43),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((1439 - 4)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((1439 - 4)- 48*0), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((1439 - 4)- 48*0), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((1439 - 4)- 48*0), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((1439 - 4)- 48*0), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((1439 - 4)- 48*0), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((1439 - 4)- 48*0), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((1439 - 4)- 48*0), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((1439 - 4)- 48*0), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((1439 - 4)- 48*0), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((1439 - 4)- 48*0), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((1439 - 4)- 48*0), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((1439 - 4)- 48*0), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((1439 - 4)- 48*0), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((1439 - 4)- 48*0), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((1439 - 4)- 48*0), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((1439 - 4)- 48*0), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((1439 - 4)- 48*0), true),
			18 => (A_ipd(18)'last_event, tpd_A_P((1439 - 4)- 48*0), true),
			19 => (A_ipd(19)'last_event, tpd_A_P((1439 - 4)- 48*0), true),
			20 => (A_ipd(20)'last_event, tpd_A_P((1439 - 4)- 48*0), true),
			21 => (A_ipd(21)'last_event, tpd_A_P((1439 - 4)- 48*0), true),
			22 => (A_ipd(22)'last_event, tpd_A_P((1439 - 4)- 48*0), true),
			23 => (A_ipd(23)'last_event, tpd_A_P((1439 - 4)- 48*0), true),
			24 => (A_ipd(24)'last_event, tpd_A_P((1439 - 4)- 48*0), true),
			25 => (A_ipd(25)'last_event, tpd_A_P((1439 - 4)- 48*0), true),
			26 => (A_ipd(26)'last_event, tpd_A_P((1439 - 4)- 48*0), true),
			27 => (A_ipd(27)'last_event, tpd_A_P((1439 - 4)- 48*0), true),
			28 => (A_ipd(28)'last_event, tpd_A_P((1439 - 4)- 48*0), true),
			29 => (A_ipd(29)'last_event, tpd_A_P((1439 - 4)- 48*0), true),
			30 => (ACIN_ipd(0)'last_event, tpd_ACIN_P((1439 - 4)- 48*0), true),
			31 => (ACIN_ipd(1)'last_event, tpd_ACIN_P((1439 - 4)- 48*0), true),
			32 => (ACIN_ipd(2)'last_event, tpd_ACIN_P((1439 - 4)- 48*0), true),
			33 => (ACIN_ipd(3)'last_event, tpd_ACIN_P((1439 - 4)- 48*0), true),
			34 => (ACIN_ipd(4)'last_event, tpd_ACIN_P((1439 - 4)- 48*0), true),
			35 => (ACIN_ipd(5)'last_event, tpd_ACIN_P((1439 - 4)- 48*0), true),
			36 => (ACIN_ipd(6)'last_event, tpd_ACIN_P((1439 - 4)- 48*0), true),
			37 => (ACIN_ipd(7)'last_event, tpd_ACIN_P((1439 - 4)- 48*0), true),
			38 => (ACIN_ipd(8)'last_event, tpd_ACIN_P((1439 - 4)- 48*0), true),
			39 => (ACIN_ipd(9)'last_event, tpd_ACIN_P((1439 - 4)- 48*0), true),
			40 => (ACIN_ipd(10)'last_event, tpd_ACIN_P((1439 - 4)- 48*0), true),
			41 => (ACIN_ipd(11)'last_event, tpd_ACIN_P((1439 - 4)- 48*0), true),
			42 => (ACIN_ipd(12)'last_event, tpd_ACIN_P((1439 - 4)- 48*0), true),
			43 => (ACIN_ipd(13)'last_event, tpd_ACIN_P((1439 - 4)- 48*0), true),
			44 => (ACIN_ipd(14)'last_event, tpd_ACIN_P((1439 - 4)- 48*0), true),
			45 => (ACIN_ipd(15)'last_event, tpd_ACIN_P((1439 - 4)- 48*0), true),
			46 => (ACIN_ipd(16)'last_event, tpd_ACIN_P((1439 - 4)- 48*0), true),
			47 => (ACIN_ipd(17)'last_event, tpd_ACIN_P((1439 - 4)- 48*0), true),
			48 => (ACIN_ipd(18)'last_event, tpd_ACIN_P((1439 - 4)- 48*0), true),
			49 => (ACIN_ipd(19)'last_event, tpd_ACIN_P((1439 - 4)- 48*0), true),
			50 => (ACIN_ipd(20)'last_event, tpd_ACIN_P((1439 - 4)- 48*0), true),
			51 => (ACIN_ipd(21)'last_event, tpd_ACIN_P((1439 - 4)- 48*0), true),
			52 => (ACIN_ipd(22)'last_event, tpd_ACIN_P((1439 - 4)- 48*0), true),
			53 => (ACIN_ipd(23)'last_event, tpd_ACIN_P((1439 - 4)- 48*0), true),
			54 => (ACIN_ipd(24)'last_event, tpd_ACIN_P((1439 - 4)- 48*0), true),
			55 => (ACIN_ipd(25)'last_event, tpd_ACIN_P((1439 - 4)- 48*0), true),
			56 => (ACIN_ipd(26)'last_event, tpd_ACIN_P((1439 - 4)- 48*0), true),
			57 => (ACIN_ipd(27)'last_event, tpd_ACIN_P((1439 - 4)- 48*0), true),
			58 => (ACIN_ipd(28)'last_event, tpd_ACIN_P((1439 - 4)- 48*0), true),
			59 => (ACIN_ipd(29)'last_event, tpd_ACIN_P((1439 - 4)- 48*0), true),
			60 => (ALUMODE_ipd(0)'last_event, tpd_ALUMODE_P((191 - 4)- 48*0), true),
			61 => (ALUMODE_ipd(1)'last_event, tpd_ALUMODE_P((191 - 4)- 48*0), true),
			62 => (ALUMODE_ipd(2)'last_event, tpd_ALUMODE_P((191 - 4)- 48*0), true),
			63 => (ALUMODE_ipd(3)'last_event, tpd_ALUMODE_P((191 - 4)- 48*0), true),
			64 => (B_ipd(0)'last_event, tpd_B_P((863 - 4)- 48*0), true),
			65 => (B_ipd(1)'last_event, tpd_B_P((863 - 4)- 48*0), true),
			66 => (B_ipd(2)'last_event, tpd_B_P((863 - 4)- 48*0), true),
			67 => (B_ipd(3)'last_event, tpd_B_P((863 - 4)- 48*0), true),
			68 => (B_ipd(4)'last_event, tpd_B_P((863 - 4)- 48*0), true),
			69 => (B_ipd(5)'last_event, tpd_B_P((863 - 4)- 48*0), true),
			70 => (B_ipd(6)'last_event, tpd_B_P((863 - 4)- 48*0), true),
			71 => (B_ipd(7)'last_event, tpd_B_P((863 - 4)- 48*0), true),
			72 => (B_ipd(8)'last_event, tpd_B_P((863 - 4)- 48*0), true),
			73 => (B_ipd(9)'last_event, tpd_B_P((863 - 4)- 48*0), true),
			74 => (B_ipd(10)'last_event, tpd_B_P((863 - 4)- 48*0), true),
			75 => (B_ipd(11)'last_event, tpd_B_P((863 - 4)- 48*0), true),
			76 => (B_ipd(12)'last_event, tpd_B_P((863 - 4)- 48*0), true),
			77 => (B_ipd(13)'last_event, tpd_B_P((863 - 4)- 48*0), true),
			78 => (B_ipd(14)'last_event, tpd_B_P((863 - 4)- 48*0), true),
			79 => (B_ipd(15)'last_event, tpd_B_P((863 - 4)- 48*0), true),
			80 => (B_ipd(16)'last_event, tpd_B_P((863 - 4)- 48*0), true),
			81 => (B_ipd(17)'last_event, tpd_B_P((863 - 4)- 48*0), true),
			82 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 4)- 48*0), true),
			83 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 4)- 48*0), true),
			84 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 4)- 48*0), true),
			85 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 4)- 48*0), true),
			86 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 4)- 48*0), true),
			87 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 4)- 48*0), true),
			88 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 4)- 48*0), true),
			89 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 4)- 48*0), true),
			90 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 4)- 48*0), true),
			91 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 4)- 48*0), true),
			92 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 4)- 48*0), true),
			93 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 4)- 48*0), true),
			94 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 4)- 48*0), true),
			95 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 4)- 48*0), true),
			96 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 4)- 48*0), true),
			97 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 4)- 48*0), true),
			98 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 4)- 48*0), true),
			99 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 4)- 48*0), true),
			100 => (C_ipd(0)'last_event, tpd_C_P((2303 - 4)- 48*0), true),
			101 => (C_ipd(1)'last_event, tpd_C_P((2303 - 4)- 48*0), true),
			102 => (C_ipd(2)'last_event, tpd_C_P((2303 - 4)- 48*0), true),
			103 => (C_ipd(3)'last_event, tpd_C_P((2303 - 4)- 48*0), true),
			104 => (C_ipd(4)'last_event, tpd_C_P((2303 - 4)- 48*0), true),
			105 => (C_ipd(5)'last_event, tpd_C_P((2303 - 4)- 48*0), true),
			106 => (C_ipd(6)'last_event, tpd_C_P((2303 - 4)- 48*0), true),
			107 => (C_ipd(7)'last_event, tpd_C_P((2303 - 4)- 48*0), true),
			108 => (C_ipd(8)'last_event, tpd_C_P((2303 - 4)- 48*0), true),
			109 => (C_ipd(9)'last_event, tpd_C_P((2303 - 4)- 48*0), true),
			110 => (C_ipd(10)'last_event, tpd_C_P((2303 - 4)- 48*0), true),
			111 => (C_ipd(11)'last_event, tpd_C_P((2303 - 4)- 48*0), true),
			112 => (C_ipd(12)'last_event, tpd_C_P((2303 - 4)- 48*0), true),
			113 => (C_ipd(13)'last_event, tpd_C_P((2303 - 4)- 48*0), true),
			114 => (C_ipd(14)'last_event, tpd_C_P((2303 - 4)- 48*0), true),
			115 => (C_ipd(15)'last_event, tpd_C_P((2303 - 4)- 48*0), true),
			116 => (C_ipd(16)'last_event, tpd_C_P((2303 - 4)- 48*0), true),
			117 => (C_ipd(17)'last_event, tpd_C_P((2303 - 4)- 48*0), true),
			118 => (C_ipd(18)'last_event, tpd_C_P((2303 - 4)- 48*0), true),
			119 => (C_ipd(19)'last_event, tpd_C_P((2303 - 4)- 48*0), true),
			120 => (C_ipd(20)'last_event, tpd_C_P((2303 - 4)- 48*0), true),
			121 => (C_ipd(21)'last_event, tpd_C_P((2303 - 4)- 48*0), true),
			122 => (C_ipd(22)'last_event, tpd_C_P((2303 - 4)- 48*0), true),
			123 => (C_ipd(23)'last_event, tpd_C_P((2303 - 4)- 48*0), true),
			124 => (C_ipd(24)'last_event, tpd_C_P((2303 - 4)- 48*0), true),
			125 => (C_ipd(25)'last_event, tpd_C_P((2303 - 4)- 48*0), true),
			126 => (C_ipd(26)'last_event, tpd_C_P((2303 - 4)- 48*0), true),
			127 => (C_ipd(27)'last_event, tpd_C_P((2303 - 4)- 48*0), true),
			128 => (C_ipd(28)'last_event, tpd_C_P((2303 - 4)- 48*0), true),
			129 => (C_ipd(29)'last_event, tpd_C_P((2303 - 4)- 48*0), true),
			130 => (C_ipd(30)'last_event, tpd_C_P((2303 - 4)- 48*0), true),
			131 => (C_ipd(31)'last_event, tpd_C_P((2303 - 4)- 48*0), true),
			132 => (C_ipd(32)'last_event, tpd_C_P((2303 - 4)- 48*0), true),
			133 => (C_ipd(33)'last_event, tpd_C_P((2303 - 4)- 48*0), true),
			134 => (C_ipd(34)'last_event, tpd_C_P((2303 - 4)- 48*0), true),
			135 => (C_ipd(35)'last_event, tpd_C_P((2303 - 4)- 48*0), true),
			136 => (C_ipd(36)'last_event, tpd_C_P((2303 - 4)- 48*0), true),
			137 => (C_ipd(37)'last_event, tpd_C_P((2303 - 4)- 48*0), true),
			138 => (C_ipd(38)'last_event, tpd_C_P((2303 - 4)- 48*0), true),
			139 => (C_ipd(39)'last_event, tpd_C_P((2303 - 4)- 48*0), true),
			140 => (C_ipd(40)'last_event, tpd_C_P((2303 - 4)- 48*0), true),
			141 => (C_ipd(41)'last_event, tpd_C_P((2303 - 4)- 48*0), true),
			142 => (C_ipd(42)'last_event, tpd_C_P((2303 - 4)- 48*0), true),
			143 => (C_ipd(43)'last_event, tpd_C_P((2303 - 4)- 48*0), true),
			144 => (C_ipd(44)'last_event, tpd_C_P((2303 - 4)- 48*0), true),
			145 => (C_ipd(45)'last_event, tpd_C_P((2303 - 4)- 48*0), true),
			146 => (C_ipd(46)'last_event, tpd_C_P((2303 - 4)- 48*0), true),
			147 => (C_ipd(47)'last_event, tpd_C_P((2303 - 4)- 48*0), true),
			148 => (CARRYCASCIN_ipd'last_event, tpd_CARRYCASCIN_P(43), true),
			149 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(43), true),
			150 => (CARRYINSEL_ipd(0)'last_event, tpd_CARRYINSEL_P((143 - 4)- 48*0), true),
			151 => (CARRYINSEL_ipd(1)'last_event, tpd_CARRYINSEL_P((143 - 4)- 48*0), true),
			152 => (CARRYINSEL_ipd(2)'last_event, tpd_CARRYINSEL_P((143 - 4)- 48*0), true),
			153 => (MULTSIGNIN_ipd'last_event, tpd_MULTSIGNIN_P(43), true),
			154 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 4)- 48*0), true),
			155 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 4)- 48*0), true),
			156 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 4)- 48*0), true),
			157 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 4)- 48*0), true),
			158 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 4)- 48*0), true),
			159 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 4)- 48*0), true),
			160 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 4)- 48*0), true),
			161 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 4)- 48*0), true),
			162 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 4)- 48*0), true),
			163 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 4)- 48*0), true),
			164 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 4)- 48*0), true),
			165 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 4)- 48*0), true),
			166 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 4)- 48*0), true),
			167 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 4)- 48*0), true),
			168 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 4)- 48*0), true),
			169 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 4)- 48*0), true),
			170 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 4)- 48*0), true),
			171 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 4)- 48*0), true),
			172 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 4)- 48*0), true),
			173 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 4)- 48*0), true),
			174 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 4)- 48*0), true),
			175 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 4)- 48*0), true),
			176 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 4)- 48*0), true),
			177 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 4)- 48*0), true),
			178 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 4)- 48*0), true),
			179 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 4)- 48*0), true),
			180 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 4)- 48*0), true),
			181 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 4)- 48*0), true),
			182 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 4)- 48*0), true),
			183 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 4)- 48*0), true),
			184 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 4)- 48*0), true),
			185 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 4)- 48*0), true),
			186 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 4)- 48*0), true),
			187 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 4)- 48*0), true),
			188 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 4)- 48*0), true),
			189 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 4)- 48*0), true),
			190 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 4)- 48*0), true),
			191 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 4)- 48*0), true),
			192 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 4)- 48*0), true),
			193 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 4)- 48*0), true),
			194 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 4)- 48*0), true),
			195 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 4)- 48*0), true),
			196 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 4)- 48*0), true),
			197 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 4)- 48*0), true),
			198 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 4)- 48*0), true),
			199 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 4)- 48*0), true),
			200 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 4)- 48*0), true),
			201 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 4)- 48*0), true),
			202 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 4)- 48*0), true),
			203 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 4)- 48*0), true),
			204 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 4)- 48*0), true),
			205 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 4)- 48*0), true),
			206 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 4)- 48*0), true),
			207 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 4)- 48*0), true),
			208 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 4)- 48*0), true),
			209 => (CLK_dly'last_event, tpd_CLK_P(43), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(42),
         GlitchData	=> P_GlitchData(42),
         OutSignalName	=> "P(42)",
         OutTemp	=> P_zd(42),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((1439 - 5)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((1439 - 5)- 48*0), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((1439 - 5)- 48*0), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((1439 - 5)- 48*0), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((1439 - 5)- 48*0), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((1439 - 5)- 48*0), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((1439 - 5)- 48*0), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((1439 - 5)- 48*0), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((1439 - 5)- 48*0), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((1439 - 5)- 48*0), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((1439 - 5)- 48*0), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((1439 - 5)- 48*0), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((1439 - 5)- 48*0), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((1439 - 5)- 48*0), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((1439 - 5)- 48*0), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((1439 - 5)- 48*0), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((1439 - 5)- 48*0), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((1439 - 5)- 48*0), true),
			18 => (A_ipd(18)'last_event, tpd_A_P((1439 - 5)- 48*0), true),
			19 => (A_ipd(19)'last_event, tpd_A_P((1439 - 5)- 48*0), true),
			20 => (A_ipd(20)'last_event, tpd_A_P((1439 - 5)- 48*0), true),
			21 => (A_ipd(21)'last_event, tpd_A_P((1439 - 5)- 48*0), true),
			22 => (A_ipd(22)'last_event, tpd_A_P((1439 - 5)- 48*0), true),
			23 => (A_ipd(23)'last_event, tpd_A_P((1439 - 5)- 48*0), true),
			24 => (A_ipd(24)'last_event, tpd_A_P((1439 - 5)- 48*0), true),
			25 => (A_ipd(25)'last_event, tpd_A_P((1439 - 5)- 48*0), true),
			26 => (A_ipd(26)'last_event, tpd_A_P((1439 - 5)- 48*0), true),
			27 => (A_ipd(27)'last_event, tpd_A_P((1439 - 5)- 48*0), true),
			28 => (A_ipd(28)'last_event, tpd_A_P((1439 - 5)- 48*0), true),
			29 => (A_ipd(29)'last_event, tpd_A_P((1439 - 5)- 48*0), true),
			30 => (ACIN_ipd(0)'last_event, tpd_ACIN_P((1439 - 5)- 48*0), true),
			31 => (ACIN_ipd(1)'last_event, tpd_ACIN_P((1439 - 5)- 48*0), true),
			32 => (ACIN_ipd(2)'last_event, tpd_ACIN_P((1439 - 5)- 48*0), true),
			33 => (ACIN_ipd(3)'last_event, tpd_ACIN_P((1439 - 5)- 48*0), true),
			34 => (ACIN_ipd(4)'last_event, tpd_ACIN_P((1439 - 5)- 48*0), true),
			35 => (ACIN_ipd(5)'last_event, tpd_ACIN_P((1439 - 5)- 48*0), true),
			36 => (ACIN_ipd(6)'last_event, tpd_ACIN_P((1439 - 5)- 48*0), true),
			37 => (ACIN_ipd(7)'last_event, tpd_ACIN_P((1439 - 5)- 48*0), true),
			38 => (ACIN_ipd(8)'last_event, tpd_ACIN_P((1439 - 5)- 48*0), true),
			39 => (ACIN_ipd(9)'last_event, tpd_ACIN_P((1439 - 5)- 48*0), true),
			40 => (ACIN_ipd(10)'last_event, tpd_ACIN_P((1439 - 5)- 48*0), true),
			41 => (ACIN_ipd(11)'last_event, tpd_ACIN_P((1439 - 5)- 48*0), true),
			42 => (ACIN_ipd(12)'last_event, tpd_ACIN_P((1439 - 5)- 48*0), true),
			43 => (ACIN_ipd(13)'last_event, tpd_ACIN_P((1439 - 5)- 48*0), true),
			44 => (ACIN_ipd(14)'last_event, tpd_ACIN_P((1439 - 5)- 48*0), true),
			45 => (ACIN_ipd(15)'last_event, tpd_ACIN_P((1439 - 5)- 48*0), true),
			46 => (ACIN_ipd(16)'last_event, tpd_ACIN_P((1439 - 5)- 48*0), true),
			47 => (ACIN_ipd(17)'last_event, tpd_ACIN_P((1439 - 5)- 48*0), true),
			48 => (ACIN_ipd(18)'last_event, tpd_ACIN_P((1439 - 5)- 48*0), true),
			49 => (ACIN_ipd(19)'last_event, tpd_ACIN_P((1439 - 5)- 48*0), true),
			50 => (ACIN_ipd(20)'last_event, tpd_ACIN_P((1439 - 5)- 48*0), true),
			51 => (ACIN_ipd(21)'last_event, tpd_ACIN_P((1439 - 5)- 48*0), true),
			52 => (ACIN_ipd(22)'last_event, tpd_ACIN_P((1439 - 5)- 48*0), true),
			53 => (ACIN_ipd(23)'last_event, tpd_ACIN_P((1439 - 5)- 48*0), true),
			54 => (ACIN_ipd(24)'last_event, tpd_ACIN_P((1439 - 5)- 48*0), true),
			55 => (ACIN_ipd(25)'last_event, tpd_ACIN_P((1439 - 5)- 48*0), true),
			56 => (ACIN_ipd(26)'last_event, tpd_ACIN_P((1439 - 5)- 48*0), true),
			57 => (ACIN_ipd(27)'last_event, tpd_ACIN_P((1439 - 5)- 48*0), true),
			58 => (ACIN_ipd(28)'last_event, tpd_ACIN_P((1439 - 5)- 48*0), true),
			59 => (ACIN_ipd(29)'last_event, tpd_ACIN_P((1439 - 5)- 48*0), true),
			60 => (ALUMODE_ipd(0)'last_event, tpd_ALUMODE_P((191 - 5)- 48*0), true),
			61 => (ALUMODE_ipd(1)'last_event, tpd_ALUMODE_P((191 - 5)- 48*0), true),
			62 => (ALUMODE_ipd(2)'last_event, tpd_ALUMODE_P((191 - 5)- 48*0), true),
			63 => (ALUMODE_ipd(3)'last_event, tpd_ALUMODE_P((191 - 5)- 48*0), true),
			64 => (B_ipd(0)'last_event, tpd_B_P((863 - 5)- 48*0), true),
			65 => (B_ipd(1)'last_event, tpd_B_P((863 - 5)- 48*0), true),
			66 => (B_ipd(2)'last_event, tpd_B_P((863 - 5)- 48*0), true),
			67 => (B_ipd(3)'last_event, tpd_B_P((863 - 5)- 48*0), true),
			68 => (B_ipd(4)'last_event, tpd_B_P((863 - 5)- 48*0), true),
			69 => (B_ipd(5)'last_event, tpd_B_P((863 - 5)- 48*0), true),
			70 => (B_ipd(6)'last_event, tpd_B_P((863 - 5)- 48*0), true),
			71 => (B_ipd(7)'last_event, tpd_B_P((863 - 5)- 48*0), true),
			72 => (B_ipd(8)'last_event, tpd_B_P((863 - 5)- 48*0), true),
			73 => (B_ipd(9)'last_event, tpd_B_P((863 - 5)- 48*0), true),
			74 => (B_ipd(10)'last_event, tpd_B_P((863 - 5)- 48*0), true),
			75 => (B_ipd(11)'last_event, tpd_B_P((863 - 5)- 48*0), true),
			76 => (B_ipd(12)'last_event, tpd_B_P((863 - 5)- 48*0), true),
			77 => (B_ipd(13)'last_event, tpd_B_P((863 - 5)- 48*0), true),
			78 => (B_ipd(14)'last_event, tpd_B_P((863 - 5)- 48*0), true),
			79 => (B_ipd(15)'last_event, tpd_B_P((863 - 5)- 48*0), true),
			80 => (B_ipd(16)'last_event, tpd_B_P((863 - 5)- 48*0), true),
			81 => (B_ipd(17)'last_event, tpd_B_P((863 - 5)- 48*0), true),
			82 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 5)- 48*0), true),
			83 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 5)- 48*0), true),
			84 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 5)- 48*0), true),
			85 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 5)- 48*0), true),
			86 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 5)- 48*0), true),
			87 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 5)- 48*0), true),
			88 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 5)- 48*0), true),
			89 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 5)- 48*0), true),
			90 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 5)- 48*0), true),
			91 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 5)- 48*0), true),
			92 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 5)- 48*0), true),
			93 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 5)- 48*0), true),
			94 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 5)- 48*0), true),
			95 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 5)- 48*0), true),
			96 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 5)- 48*0), true),
			97 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 5)- 48*0), true),
			98 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 5)- 48*0), true),
			99 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 5)- 48*0), true),
			100 => (C_ipd(0)'last_event, tpd_C_P((2303 - 5)- 48*0), true),
			101 => (C_ipd(1)'last_event, tpd_C_P((2303 - 5)- 48*0), true),
			102 => (C_ipd(2)'last_event, tpd_C_P((2303 - 5)- 48*0), true),
			103 => (C_ipd(3)'last_event, tpd_C_P((2303 - 5)- 48*0), true),
			104 => (C_ipd(4)'last_event, tpd_C_P((2303 - 5)- 48*0), true),
			105 => (C_ipd(5)'last_event, tpd_C_P((2303 - 5)- 48*0), true),
			106 => (C_ipd(6)'last_event, tpd_C_P((2303 - 5)- 48*0), true),
			107 => (C_ipd(7)'last_event, tpd_C_P((2303 - 5)- 48*0), true),
			108 => (C_ipd(8)'last_event, tpd_C_P((2303 - 5)- 48*0), true),
			109 => (C_ipd(9)'last_event, tpd_C_P((2303 - 5)- 48*0), true),
			110 => (C_ipd(10)'last_event, tpd_C_P((2303 - 5)- 48*0), true),
			111 => (C_ipd(11)'last_event, tpd_C_P((2303 - 5)- 48*0), true),
			112 => (C_ipd(12)'last_event, tpd_C_P((2303 - 5)- 48*0), true),
			113 => (C_ipd(13)'last_event, tpd_C_P((2303 - 5)- 48*0), true),
			114 => (C_ipd(14)'last_event, tpd_C_P((2303 - 5)- 48*0), true),
			115 => (C_ipd(15)'last_event, tpd_C_P((2303 - 5)- 48*0), true),
			116 => (C_ipd(16)'last_event, tpd_C_P((2303 - 5)- 48*0), true),
			117 => (C_ipd(17)'last_event, tpd_C_P((2303 - 5)- 48*0), true),
			118 => (C_ipd(18)'last_event, tpd_C_P((2303 - 5)- 48*0), true),
			119 => (C_ipd(19)'last_event, tpd_C_P((2303 - 5)- 48*0), true),
			120 => (C_ipd(20)'last_event, tpd_C_P((2303 - 5)- 48*0), true),
			121 => (C_ipd(21)'last_event, tpd_C_P((2303 - 5)- 48*0), true),
			122 => (C_ipd(22)'last_event, tpd_C_P((2303 - 5)- 48*0), true),
			123 => (C_ipd(23)'last_event, tpd_C_P((2303 - 5)- 48*0), true),
			124 => (C_ipd(24)'last_event, tpd_C_P((2303 - 5)- 48*0), true),
			125 => (C_ipd(25)'last_event, tpd_C_P((2303 - 5)- 48*0), true),
			126 => (C_ipd(26)'last_event, tpd_C_P((2303 - 5)- 48*0), true),
			127 => (C_ipd(27)'last_event, tpd_C_P((2303 - 5)- 48*0), true),
			128 => (C_ipd(28)'last_event, tpd_C_P((2303 - 5)- 48*0), true),
			129 => (C_ipd(29)'last_event, tpd_C_P((2303 - 5)- 48*0), true),
			130 => (C_ipd(30)'last_event, tpd_C_P((2303 - 5)- 48*0), true),
			131 => (C_ipd(31)'last_event, tpd_C_P((2303 - 5)- 48*0), true),
			132 => (C_ipd(32)'last_event, tpd_C_P((2303 - 5)- 48*0), true),
			133 => (C_ipd(33)'last_event, tpd_C_P((2303 - 5)- 48*0), true),
			134 => (C_ipd(34)'last_event, tpd_C_P((2303 - 5)- 48*0), true),
			135 => (C_ipd(35)'last_event, tpd_C_P((2303 - 5)- 48*0), true),
			136 => (C_ipd(36)'last_event, tpd_C_P((2303 - 5)- 48*0), true),
			137 => (C_ipd(37)'last_event, tpd_C_P((2303 - 5)- 48*0), true),
			138 => (C_ipd(38)'last_event, tpd_C_P((2303 - 5)- 48*0), true),
			139 => (C_ipd(39)'last_event, tpd_C_P((2303 - 5)- 48*0), true),
			140 => (C_ipd(40)'last_event, tpd_C_P((2303 - 5)- 48*0), true),
			141 => (C_ipd(41)'last_event, tpd_C_P((2303 - 5)- 48*0), true),
			142 => (C_ipd(42)'last_event, tpd_C_P((2303 - 5)- 48*0), true),
			143 => (C_ipd(43)'last_event, tpd_C_P((2303 - 5)- 48*0), true),
			144 => (C_ipd(44)'last_event, tpd_C_P((2303 - 5)- 48*0), true),
			145 => (C_ipd(45)'last_event, tpd_C_P((2303 - 5)- 48*0), true),
			146 => (C_ipd(46)'last_event, tpd_C_P((2303 - 5)- 48*0), true),
			147 => (C_ipd(47)'last_event, tpd_C_P((2303 - 5)- 48*0), true),
			148 => (CARRYCASCIN_ipd'last_event, tpd_CARRYCASCIN_P(42), true),
			149 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(42), true),
			150 => (CARRYINSEL_ipd(0)'last_event, tpd_CARRYINSEL_P((143 - 5)- 48*0), true),
			151 => (CARRYINSEL_ipd(1)'last_event, tpd_CARRYINSEL_P((143 - 5)- 48*0), true),
			152 => (CARRYINSEL_ipd(2)'last_event, tpd_CARRYINSEL_P((143 - 5)- 48*0), true),
			153 => (MULTSIGNIN_ipd'last_event, tpd_MULTSIGNIN_P(42), true),
			154 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 5)- 48*0), true),
			155 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 5)- 48*0), true),
			156 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 5)- 48*0), true),
			157 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 5)- 48*0), true),
			158 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 5)- 48*0), true),
			159 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 5)- 48*0), true),
			160 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 5)- 48*0), true),
			161 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 5)- 48*0), true),
			162 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 5)- 48*0), true),
			163 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 5)- 48*0), true),
			164 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 5)- 48*0), true),
			165 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 5)- 48*0), true),
			166 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 5)- 48*0), true),
			167 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 5)- 48*0), true),
			168 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 5)- 48*0), true),
			169 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 5)- 48*0), true),
			170 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 5)- 48*0), true),
			171 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 5)- 48*0), true),
			172 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 5)- 48*0), true),
			173 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 5)- 48*0), true),
			174 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 5)- 48*0), true),
			175 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 5)- 48*0), true),
			176 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 5)- 48*0), true),
			177 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 5)- 48*0), true),
			178 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 5)- 48*0), true),
			179 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 5)- 48*0), true),
			180 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 5)- 48*0), true),
			181 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 5)- 48*0), true),
			182 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 5)- 48*0), true),
			183 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 5)- 48*0), true),
			184 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 5)- 48*0), true),
			185 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 5)- 48*0), true),
			186 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 5)- 48*0), true),
			187 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 5)- 48*0), true),
			188 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 5)- 48*0), true),
			189 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 5)- 48*0), true),
			190 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 5)- 48*0), true),
			191 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 5)- 48*0), true),
			192 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 5)- 48*0), true),
			193 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 5)- 48*0), true),
			194 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 5)- 48*0), true),
			195 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 5)- 48*0), true),
			196 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 5)- 48*0), true),
			197 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 5)- 48*0), true),
			198 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 5)- 48*0), true),
			199 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 5)- 48*0), true),
			200 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 5)- 48*0), true),
			201 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 5)- 48*0), true),
			202 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 5)- 48*0), true),
			203 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 5)- 48*0), true),
			204 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 5)- 48*0), true),
			205 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 5)- 48*0), true),
			206 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 5)- 48*0), true),
			207 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 5)- 48*0), true),
			208 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 5)- 48*0), true),
			209 => (CLK_dly'last_event, tpd_CLK_P(42), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(41),
         GlitchData	=> P_GlitchData(41),
         OutSignalName	=> "P(41)",
         OutTemp	=> P_zd(41),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((1439 - 6)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((1439 - 6)- 48*0), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((1439 - 6)- 48*0), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((1439 - 6)- 48*0), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((1439 - 6)- 48*0), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((1439 - 6)- 48*0), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((1439 - 6)- 48*0), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((1439 - 6)- 48*0), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((1439 - 6)- 48*0), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((1439 - 6)- 48*0), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((1439 - 6)- 48*0), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((1439 - 6)- 48*0), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((1439 - 6)- 48*0), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((1439 - 6)- 48*0), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((1439 - 6)- 48*0), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((1439 - 6)- 48*0), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((1439 - 6)- 48*0), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((1439 - 6)- 48*0), true),
			18 => (A_ipd(18)'last_event, tpd_A_P((1439 - 6)- 48*0), true),
			19 => (A_ipd(19)'last_event, tpd_A_P((1439 - 6)- 48*0), true),
			20 => (A_ipd(20)'last_event, tpd_A_P((1439 - 6)- 48*0), true),
			21 => (A_ipd(21)'last_event, tpd_A_P((1439 - 6)- 48*0), true),
			22 => (A_ipd(22)'last_event, tpd_A_P((1439 - 6)- 48*0), true),
			23 => (A_ipd(23)'last_event, tpd_A_P((1439 - 6)- 48*0), true),
			24 => (A_ipd(24)'last_event, tpd_A_P((1439 - 6)- 48*0), true),
			25 => (A_ipd(25)'last_event, tpd_A_P((1439 - 6)- 48*0), true),
			26 => (A_ipd(26)'last_event, tpd_A_P((1439 - 6)- 48*0), true),
			27 => (A_ipd(27)'last_event, tpd_A_P((1439 - 6)- 48*0), true),
			28 => (A_ipd(28)'last_event, tpd_A_P((1439 - 6)- 48*0), true),
			29 => (A_ipd(29)'last_event, tpd_A_P((1439 - 6)- 48*0), true),
			30 => (ACIN_ipd(0)'last_event, tpd_ACIN_P((1439 - 6)- 48*0), true),
			31 => (ACIN_ipd(1)'last_event, tpd_ACIN_P((1439 - 6)- 48*0), true),
			32 => (ACIN_ipd(2)'last_event, tpd_ACIN_P((1439 - 6)- 48*0), true),
			33 => (ACIN_ipd(3)'last_event, tpd_ACIN_P((1439 - 6)- 48*0), true),
			34 => (ACIN_ipd(4)'last_event, tpd_ACIN_P((1439 - 6)- 48*0), true),
			35 => (ACIN_ipd(5)'last_event, tpd_ACIN_P((1439 - 6)- 48*0), true),
			36 => (ACIN_ipd(6)'last_event, tpd_ACIN_P((1439 - 6)- 48*0), true),
			37 => (ACIN_ipd(7)'last_event, tpd_ACIN_P((1439 - 6)- 48*0), true),
			38 => (ACIN_ipd(8)'last_event, tpd_ACIN_P((1439 - 6)- 48*0), true),
			39 => (ACIN_ipd(9)'last_event, tpd_ACIN_P((1439 - 6)- 48*0), true),
			40 => (ACIN_ipd(10)'last_event, tpd_ACIN_P((1439 - 6)- 48*0), true),
			41 => (ACIN_ipd(11)'last_event, tpd_ACIN_P((1439 - 6)- 48*0), true),
			42 => (ACIN_ipd(12)'last_event, tpd_ACIN_P((1439 - 6)- 48*0), true),
			43 => (ACIN_ipd(13)'last_event, tpd_ACIN_P((1439 - 6)- 48*0), true),
			44 => (ACIN_ipd(14)'last_event, tpd_ACIN_P((1439 - 6)- 48*0), true),
			45 => (ACIN_ipd(15)'last_event, tpd_ACIN_P((1439 - 6)- 48*0), true),
			46 => (ACIN_ipd(16)'last_event, tpd_ACIN_P((1439 - 6)- 48*0), true),
			47 => (ACIN_ipd(17)'last_event, tpd_ACIN_P((1439 - 6)- 48*0), true),
			48 => (ACIN_ipd(18)'last_event, tpd_ACIN_P((1439 - 6)- 48*0), true),
			49 => (ACIN_ipd(19)'last_event, tpd_ACIN_P((1439 - 6)- 48*0), true),
			50 => (ACIN_ipd(20)'last_event, tpd_ACIN_P((1439 - 6)- 48*0), true),
			51 => (ACIN_ipd(21)'last_event, tpd_ACIN_P((1439 - 6)- 48*0), true),
			52 => (ACIN_ipd(22)'last_event, tpd_ACIN_P((1439 - 6)- 48*0), true),
			53 => (ACIN_ipd(23)'last_event, tpd_ACIN_P((1439 - 6)- 48*0), true),
			54 => (ACIN_ipd(24)'last_event, tpd_ACIN_P((1439 - 6)- 48*0), true),
			55 => (ACIN_ipd(25)'last_event, tpd_ACIN_P((1439 - 6)- 48*0), true),
			56 => (ACIN_ipd(26)'last_event, tpd_ACIN_P((1439 - 6)- 48*0), true),
			57 => (ACIN_ipd(27)'last_event, tpd_ACIN_P((1439 - 6)- 48*0), true),
			58 => (ACIN_ipd(28)'last_event, tpd_ACIN_P((1439 - 6)- 48*0), true),
			59 => (ACIN_ipd(29)'last_event, tpd_ACIN_P((1439 - 6)- 48*0), true),
			60 => (ALUMODE_ipd(0)'last_event, tpd_ALUMODE_P((191 - 6)- 48*0), true),
			61 => (ALUMODE_ipd(1)'last_event, tpd_ALUMODE_P((191 - 6)- 48*0), true),
			62 => (ALUMODE_ipd(2)'last_event, tpd_ALUMODE_P((191 - 6)- 48*0), true),
			63 => (ALUMODE_ipd(3)'last_event, tpd_ALUMODE_P((191 - 6)- 48*0), true),
			64 => (B_ipd(0)'last_event, tpd_B_P((863 - 6)- 48*0), true),
			65 => (B_ipd(1)'last_event, tpd_B_P((863 - 6)- 48*0), true),
			66 => (B_ipd(2)'last_event, tpd_B_P((863 - 6)- 48*0), true),
			67 => (B_ipd(3)'last_event, tpd_B_P((863 - 6)- 48*0), true),
			68 => (B_ipd(4)'last_event, tpd_B_P((863 - 6)- 48*0), true),
			69 => (B_ipd(5)'last_event, tpd_B_P((863 - 6)- 48*0), true),
			70 => (B_ipd(6)'last_event, tpd_B_P((863 - 6)- 48*0), true),
			71 => (B_ipd(7)'last_event, tpd_B_P((863 - 6)- 48*0), true),
			72 => (B_ipd(8)'last_event, tpd_B_P((863 - 6)- 48*0), true),
			73 => (B_ipd(9)'last_event, tpd_B_P((863 - 6)- 48*0), true),
			74 => (B_ipd(10)'last_event, tpd_B_P((863 - 6)- 48*0), true),
			75 => (B_ipd(11)'last_event, tpd_B_P((863 - 6)- 48*0), true),
			76 => (B_ipd(12)'last_event, tpd_B_P((863 - 6)- 48*0), true),
			77 => (B_ipd(13)'last_event, tpd_B_P((863 - 6)- 48*0), true),
			78 => (B_ipd(14)'last_event, tpd_B_P((863 - 6)- 48*0), true),
			79 => (B_ipd(15)'last_event, tpd_B_P((863 - 6)- 48*0), true),
			80 => (B_ipd(16)'last_event, tpd_B_P((863 - 6)- 48*0), true),
			81 => (B_ipd(17)'last_event, tpd_B_P((863 - 6)- 48*0), true),
			82 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 6)- 48*0), true),
			83 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 6)- 48*0), true),
			84 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 6)- 48*0), true),
			85 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 6)- 48*0), true),
			86 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 6)- 48*0), true),
			87 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 6)- 48*0), true),
			88 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 6)- 48*0), true),
			89 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 6)- 48*0), true),
			90 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 6)- 48*0), true),
			91 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 6)- 48*0), true),
			92 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 6)- 48*0), true),
			93 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 6)- 48*0), true),
			94 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 6)- 48*0), true),
			95 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 6)- 48*0), true),
			96 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 6)- 48*0), true),
			97 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 6)- 48*0), true),
			98 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 6)- 48*0), true),
			99 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 6)- 48*0), true),
			100 => (C_ipd(0)'last_event, tpd_C_P((2303 - 6)- 48*0), true),
			101 => (C_ipd(1)'last_event, tpd_C_P((2303 - 6)- 48*0), true),
			102 => (C_ipd(2)'last_event, tpd_C_P((2303 - 6)- 48*0), true),
			103 => (C_ipd(3)'last_event, tpd_C_P((2303 - 6)- 48*0), true),
			104 => (C_ipd(4)'last_event, tpd_C_P((2303 - 6)- 48*0), true),
			105 => (C_ipd(5)'last_event, tpd_C_P((2303 - 6)- 48*0), true),
			106 => (C_ipd(6)'last_event, tpd_C_P((2303 - 6)- 48*0), true),
			107 => (C_ipd(7)'last_event, tpd_C_P((2303 - 6)- 48*0), true),
			108 => (C_ipd(8)'last_event, tpd_C_P((2303 - 6)- 48*0), true),
			109 => (C_ipd(9)'last_event, tpd_C_P((2303 - 6)- 48*0), true),
			110 => (C_ipd(10)'last_event, tpd_C_P((2303 - 6)- 48*0), true),
			111 => (C_ipd(11)'last_event, tpd_C_P((2303 - 6)- 48*0), true),
			112 => (C_ipd(12)'last_event, tpd_C_P((2303 - 6)- 48*0), true),
			113 => (C_ipd(13)'last_event, tpd_C_P((2303 - 6)- 48*0), true),
			114 => (C_ipd(14)'last_event, tpd_C_P((2303 - 6)- 48*0), true),
			115 => (C_ipd(15)'last_event, tpd_C_P((2303 - 6)- 48*0), true),
			116 => (C_ipd(16)'last_event, tpd_C_P((2303 - 6)- 48*0), true),
			117 => (C_ipd(17)'last_event, tpd_C_P((2303 - 6)- 48*0), true),
			118 => (C_ipd(18)'last_event, tpd_C_P((2303 - 6)- 48*0), true),
			119 => (C_ipd(19)'last_event, tpd_C_P((2303 - 6)- 48*0), true),
			120 => (C_ipd(20)'last_event, tpd_C_P((2303 - 6)- 48*0), true),
			121 => (C_ipd(21)'last_event, tpd_C_P((2303 - 6)- 48*0), true),
			122 => (C_ipd(22)'last_event, tpd_C_P((2303 - 6)- 48*0), true),
			123 => (C_ipd(23)'last_event, tpd_C_P((2303 - 6)- 48*0), true),
			124 => (C_ipd(24)'last_event, tpd_C_P((2303 - 6)- 48*0), true),
			125 => (C_ipd(25)'last_event, tpd_C_P((2303 - 6)- 48*0), true),
			126 => (C_ipd(26)'last_event, tpd_C_P((2303 - 6)- 48*0), true),
			127 => (C_ipd(27)'last_event, tpd_C_P((2303 - 6)- 48*0), true),
			128 => (C_ipd(28)'last_event, tpd_C_P((2303 - 6)- 48*0), true),
			129 => (C_ipd(29)'last_event, tpd_C_P((2303 - 6)- 48*0), true),
			130 => (C_ipd(30)'last_event, tpd_C_P((2303 - 6)- 48*0), true),
			131 => (C_ipd(31)'last_event, tpd_C_P((2303 - 6)- 48*0), true),
			132 => (C_ipd(32)'last_event, tpd_C_P((2303 - 6)- 48*0), true),
			133 => (C_ipd(33)'last_event, tpd_C_P((2303 - 6)- 48*0), true),
			134 => (C_ipd(34)'last_event, tpd_C_P((2303 - 6)- 48*0), true),
			135 => (C_ipd(35)'last_event, tpd_C_P((2303 - 6)- 48*0), true),
			136 => (C_ipd(36)'last_event, tpd_C_P((2303 - 6)- 48*0), true),
			137 => (C_ipd(37)'last_event, tpd_C_P((2303 - 6)- 48*0), true),
			138 => (C_ipd(38)'last_event, tpd_C_P((2303 - 6)- 48*0), true),
			139 => (C_ipd(39)'last_event, tpd_C_P((2303 - 6)- 48*0), true),
			140 => (C_ipd(40)'last_event, tpd_C_P((2303 - 6)- 48*0), true),
			141 => (C_ipd(41)'last_event, tpd_C_P((2303 - 6)- 48*0), true),
			142 => (C_ipd(42)'last_event, tpd_C_P((2303 - 6)- 48*0), true),
			143 => (C_ipd(43)'last_event, tpd_C_P((2303 - 6)- 48*0), true),
			144 => (C_ipd(44)'last_event, tpd_C_P((2303 - 6)- 48*0), true),
			145 => (C_ipd(45)'last_event, tpd_C_P((2303 - 6)- 48*0), true),
			146 => (C_ipd(46)'last_event, tpd_C_P((2303 - 6)- 48*0), true),
			147 => (C_ipd(47)'last_event, tpd_C_P((2303 - 6)- 48*0), true),
			148 => (CARRYCASCIN_ipd'last_event, tpd_CARRYCASCIN_P(41), true),
			149 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(41), true),
			150 => (CARRYINSEL_ipd(0)'last_event, tpd_CARRYINSEL_P((143 - 6)- 48*0), true),
			151 => (CARRYINSEL_ipd(1)'last_event, tpd_CARRYINSEL_P((143 - 6)- 48*0), true),
			152 => (CARRYINSEL_ipd(2)'last_event, tpd_CARRYINSEL_P((143 - 6)- 48*0), true),
			153 => (MULTSIGNIN_ipd'last_event, tpd_MULTSIGNIN_P(41), true),
			154 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 6)- 48*0), true),
			155 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 6)- 48*0), true),
			156 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 6)- 48*0), true),
			157 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 6)- 48*0), true),
			158 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 6)- 48*0), true),
			159 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 6)- 48*0), true),
			160 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 6)- 48*0), true),
			161 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 6)- 48*0), true),
			162 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 6)- 48*0), true),
			163 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 6)- 48*0), true),
			164 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 6)- 48*0), true),
			165 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 6)- 48*0), true),
			166 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 6)- 48*0), true),
			167 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 6)- 48*0), true),
			168 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 6)- 48*0), true),
			169 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 6)- 48*0), true),
			170 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 6)- 48*0), true),
			171 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 6)- 48*0), true),
			172 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 6)- 48*0), true),
			173 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 6)- 48*0), true),
			174 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 6)- 48*0), true),
			175 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 6)- 48*0), true),
			176 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 6)- 48*0), true),
			177 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 6)- 48*0), true),
			178 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 6)- 48*0), true),
			179 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 6)- 48*0), true),
			180 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 6)- 48*0), true),
			181 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 6)- 48*0), true),
			182 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 6)- 48*0), true),
			183 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 6)- 48*0), true),
			184 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 6)- 48*0), true),
			185 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 6)- 48*0), true),
			186 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 6)- 48*0), true),
			187 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 6)- 48*0), true),
			188 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 6)- 48*0), true),
			189 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 6)- 48*0), true),
			190 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 6)- 48*0), true),
			191 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 6)- 48*0), true),
			192 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 6)- 48*0), true),
			193 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 6)- 48*0), true),
			194 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 6)- 48*0), true),
			195 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 6)- 48*0), true),
			196 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 6)- 48*0), true),
			197 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 6)- 48*0), true),
			198 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 6)- 48*0), true),
			199 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 6)- 48*0), true),
			200 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 6)- 48*0), true),
			201 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 6)- 48*0), true),
			202 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 6)- 48*0), true),
			203 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 6)- 48*0), true),
			204 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 6)- 48*0), true),
			205 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 6)- 48*0), true),
			206 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 6)- 48*0), true),
			207 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 6)- 48*0), true),
			208 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 6)- 48*0), true),
			209 => (CLK_dly'last_event, tpd_CLK_P(41), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(40),
         GlitchData	=> P_GlitchData(40),
         OutSignalName	=> "P(40)",
         OutTemp	=> P_zd(40),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((1439 - 7)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((1439 - 7)- 48*0), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((1439 - 7)- 48*0), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((1439 - 7)- 48*0), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((1439 - 7)- 48*0), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((1439 - 7)- 48*0), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((1439 - 7)- 48*0), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((1439 - 7)- 48*0), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((1439 - 7)- 48*0), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((1439 - 7)- 48*0), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((1439 - 7)- 48*0), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((1439 - 7)- 48*0), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((1439 - 7)- 48*0), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((1439 - 7)- 48*0), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((1439 - 7)- 48*0), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((1439 - 7)- 48*0), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((1439 - 7)- 48*0), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((1439 - 7)- 48*0), true),
			18 => (A_ipd(18)'last_event, tpd_A_P((1439 - 7)- 48*0), true),
			19 => (A_ipd(19)'last_event, tpd_A_P((1439 - 7)- 48*0), true),
			20 => (A_ipd(20)'last_event, tpd_A_P((1439 - 7)- 48*0), true),
			21 => (A_ipd(21)'last_event, tpd_A_P((1439 - 7)- 48*0), true),
			22 => (A_ipd(22)'last_event, tpd_A_P((1439 - 7)- 48*0), true),
			23 => (A_ipd(23)'last_event, tpd_A_P((1439 - 7)- 48*0), true),
			24 => (A_ipd(24)'last_event, tpd_A_P((1439 - 7)- 48*0), true),
			25 => (A_ipd(25)'last_event, tpd_A_P((1439 - 7)- 48*0), true),
			26 => (A_ipd(26)'last_event, tpd_A_P((1439 - 7)- 48*0), true),
			27 => (A_ipd(27)'last_event, tpd_A_P((1439 - 7)- 48*0), true),
			28 => (A_ipd(28)'last_event, tpd_A_P((1439 - 7)- 48*0), true),
			29 => (A_ipd(29)'last_event, tpd_A_P((1439 - 7)- 48*0), true),
			30 => (ACIN_ipd(0)'last_event, tpd_ACIN_P((1439 - 7)- 48*0), true),
			31 => (ACIN_ipd(1)'last_event, tpd_ACIN_P((1439 - 7)- 48*0), true),
			32 => (ACIN_ipd(2)'last_event, tpd_ACIN_P((1439 - 7)- 48*0), true),
			33 => (ACIN_ipd(3)'last_event, tpd_ACIN_P((1439 - 7)- 48*0), true),
			34 => (ACIN_ipd(4)'last_event, tpd_ACIN_P((1439 - 7)- 48*0), true),
			35 => (ACIN_ipd(5)'last_event, tpd_ACIN_P((1439 - 7)- 48*0), true),
			36 => (ACIN_ipd(6)'last_event, tpd_ACIN_P((1439 - 7)- 48*0), true),
			37 => (ACIN_ipd(7)'last_event, tpd_ACIN_P((1439 - 7)- 48*0), true),
			38 => (ACIN_ipd(8)'last_event, tpd_ACIN_P((1439 - 7)- 48*0), true),
			39 => (ACIN_ipd(9)'last_event, tpd_ACIN_P((1439 - 7)- 48*0), true),
			40 => (ACIN_ipd(10)'last_event, tpd_ACIN_P((1439 - 7)- 48*0), true),
			41 => (ACIN_ipd(11)'last_event, tpd_ACIN_P((1439 - 7)- 48*0), true),
			42 => (ACIN_ipd(12)'last_event, tpd_ACIN_P((1439 - 7)- 48*0), true),
			43 => (ACIN_ipd(13)'last_event, tpd_ACIN_P((1439 - 7)- 48*0), true),
			44 => (ACIN_ipd(14)'last_event, tpd_ACIN_P((1439 - 7)- 48*0), true),
			45 => (ACIN_ipd(15)'last_event, tpd_ACIN_P((1439 - 7)- 48*0), true),
			46 => (ACIN_ipd(16)'last_event, tpd_ACIN_P((1439 - 7)- 48*0), true),
			47 => (ACIN_ipd(17)'last_event, tpd_ACIN_P((1439 - 7)- 48*0), true),
			48 => (ACIN_ipd(18)'last_event, tpd_ACIN_P((1439 - 7)- 48*0), true),
			49 => (ACIN_ipd(19)'last_event, tpd_ACIN_P((1439 - 7)- 48*0), true),
			50 => (ACIN_ipd(20)'last_event, tpd_ACIN_P((1439 - 7)- 48*0), true),
			51 => (ACIN_ipd(21)'last_event, tpd_ACIN_P((1439 - 7)- 48*0), true),
			52 => (ACIN_ipd(22)'last_event, tpd_ACIN_P((1439 - 7)- 48*0), true),
			53 => (ACIN_ipd(23)'last_event, tpd_ACIN_P((1439 - 7)- 48*0), true),
			54 => (ACIN_ipd(24)'last_event, tpd_ACIN_P((1439 - 7)- 48*0), true),
			55 => (ACIN_ipd(25)'last_event, tpd_ACIN_P((1439 - 7)- 48*0), true),
			56 => (ACIN_ipd(26)'last_event, tpd_ACIN_P((1439 - 7)- 48*0), true),
			57 => (ACIN_ipd(27)'last_event, tpd_ACIN_P((1439 - 7)- 48*0), true),
			58 => (ACIN_ipd(28)'last_event, tpd_ACIN_P((1439 - 7)- 48*0), true),
			59 => (ACIN_ipd(29)'last_event, tpd_ACIN_P((1439 - 7)- 48*0), true),
			60 => (ALUMODE_ipd(0)'last_event, tpd_ALUMODE_P((191 - 7)- 48*0), true),
			61 => (ALUMODE_ipd(1)'last_event, tpd_ALUMODE_P((191 - 7)- 48*0), true),
			62 => (ALUMODE_ipd(2)'last_event, tpd_ALUMODE_P((191 - 7)- 48*0), true),
			63 => (ALUMODE_ipd(3)'last_event, tpd_ALUMODE_P((191 - 7)- 48*0), true),
			64 => (B_ipd(0)'last_event, tpd_B_P((863 - 7)- 48*0), true),
			65 => (B_ipd(1)'last_event, tpd_B_P((863 - 7)- 48*0), true),
			66 => (B_ipd(2)'last_event, tpd_B_P((863 - 7)- 48*0), true),
			67 => (B_ipd(3)'last_event, tpd_B_P((863 - 7)- 48*0), true),
			68 => (B_ipd(4)'last_event, tpd_B_P((863 - 7)- 48*0), true),
			69 => (B_ipd(5)'last_event, tpd_B_P((863 - 7)- 48*0), true),
			70 => (B_ipd(6)'last_event, tpd_B_P((863 - 7)- 48*0), true),
			71 => (B_ipd(7)'last_event, tpd_B_P((863 - 7)- 48*0), true),
			72 => (B_ipd(8)'last_event, tpd_B_P((863 - 7)- 48*0), true),
			73 => (B_ipd(9)'last_event, tpd_B_P((863 - 7)- 48*0), true),
			74 => (B_ipd(10)'last_event, tpd_B_P((863 - 7)- 48*0), true),
			75 => (B_ipd(11)'last_event, tpd_B_P((863 - 7)- 48*0), true),
			76 => (B_ipd(12)'last_event, tpd_B_P((863 - 7)- 48*0), true),
			77 => (B_ipd(13)'last_event, tpd_B_P((863 - 7)- 48*0), true),
			78 => (B_ipd(14)'last_event, tpd_B_P((863 - 7)- 48*0), true),
			79 => (B_ipd(15)'last_event, tpd_B_P((863 - 7)- 48*0), true),
			80 => (B_ipd(16)'last_event, tpd_B_P((863 - 7)- 48*0), true),
			81 => (B_ipd(17)'last_event, tpd_B_P((863 - 7)- 48*0), true),
			82 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 7)- 48*0), true),
			83 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 7)- 48*0), true),
			84 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 7)- 48*0), true),
			85 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 7)- 48*0), true),
			86 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 7)- 48*0), true),
			87 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 7)- 48*0), true),
			88 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 7)- 48*0), true),
			89 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 7)- 48*0), true),
			90 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 7)- 48*0), true),
			91 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 7)- 48*0), true),
			92 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 7)- 48*0), true),
			93 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 7)- 48*0), true),
			94 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 7)- 48*0), true),
			95 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 7)- 48*0), true),
			96 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 7)- 48*0), true),
			97 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 7)- 48*0), true),
			98 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 7)- 48*0), true),
			99 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 7)- 48*0), true),
			100 => (C_ipd(0)'last_event, tpd_C_P((2303 - 7)- 48*0), true),
			101 => (C_ipd(1)'last_event, tpd_C_P((2303 - 7)- 48*0), true),
			102 => (C_ipd(2)'last_event, tpd_C_P((2303 - 7)- 48*0), true),
			103 => (C_ipd(3)'last_event, tpd_C_P((2303 - 7)- 48*0), true),
			104 => (C_ipd(4)'last_event, tpd_C_P((2303 - 7)- 48*0), true),
			105 => (C_ipd(5)'last_event, tpd_C_P((2303 - 7)- 48*0), true),
			106 => (C_ipd(6)'last_event, tpd_C_P((2303 - 7)- 48*0), true),
			107 => (C_ipd(7)'last_event, tpd_C_P((2303 - 7)- 48*0), true),
			108 => (C_ipd(8)'last_event, tpd_C_P((2303 - 7)- 48*0), true),
			109 => (C_ipd(9)'last_event, tpd_C_P((2303 - 7)- 48*0), true),
			110 => (C_ipd(10)'last_event, tpd_C_P((2303 - 7)- 48*0), true),
			111 => (C_ipd(11)'last_event, tpd_C_P((2303 - 7)- 48*0), true),
			112 => (C_ipd(12)'last_event, tpd_C_P((2303 - 7)- 48*0), true),
			113 => (C_ipd(13)'last_event, tpd_C_P((2303 - 7)- 48*0), true),
			114 => (C_ipd(14)'last_event, tpd_C_P((2303 - 7)- 48*0), true),
			115 => (C_ipd(15)'last_event, tpd_C_P((2303 - 7)- 48*0), true),
			116 => (C_ipd(16)'last_event, tpd_C_P((2303 - 7)- 48*0), true),
			117 => (C_ipd(17)'last_event, tpd_C_P((2303 - 7)- 48*0), true),
			118 => (C_ipd(18)'last_event, tpd_C_P((2303 - 7)- 48*0), true),
			119 => (C_ipd(19)'last_event, tpd_C_P((2303 - 7)- 48*0), true),
			120 => (C_ipd(20)'last_event, tpd_C_P((2303 - 7)- 48*0), true),
			121 => (C_ipd(21)'last_event, tpd_C_P((2303 - 7)- 48*0), true),
			122 => (C_ipd(22)'last_event, tpd_C_P((2303 - 7)- 48*0), true),
			123 => (C_ipd(23)'last_event, tpd_C_P((2303 - 7)- 48*0), true),
			124 => (C_ipd(24)'last_event, tpd_C_P((2303 - 7)- 48*0), true),
			125 => (C_ipd(25)'last_event, tpd_C_P((2303 - 7)- 48*0), true),
			126 => (C_ipd(26)'last_event, tpd_C_P((2303 - 7)- 48*0), true),
			127 => (C_ipd(27)'last_event, tpd_C_P((2303 - 7)- 48*0), true),
			128 => (C_ipd(28)'last_event, tpd_C_P((2303 - 7)- 48*0), true),
			129 => (C_ipd(29)'last_event, tpd_C_P((2303 - 7)- 48*0), true),
			130 => (C_ipd(30)'last_event, tpd_C_P((2303 - 7)- 48*0), true),
			131 => (C_ipd(31)'last_event, tpd_C_P((2303 - 7)- 48*0), true),
			132 => (C_ipd(32)'last_event, tpd_C_P((2303 - 7)- 48*0), true),
			133 => (C_ipd(33)'last_event, tpd_C_P((2303 - 7)- 48*0), true),
			134 => (C_ipd(34)'last_event, tpd_C_P((2303 - 7)- 48*0), true),
			135 => (C_ipd(35)'last_event, tpd_C_P((2303 - 7)- 48*0), true),
			136 => (C_ipd(36)'last_event, tpd_C_P((2303 - 7)- 48*0), true),
			137 => (C_ipd(37)'last_event, tpd_C_P((2303 - 7)- 48*0), true),
			138 => (C_ipd(38)'last_event, tpd_C_P((2303 - 7)- 48*0), true),
			139 => (C_ipd(39)'last_event, tpd_C_P((2303 - 7)- 48*0), true),
			140 => (C_ipd(40)'last_event, tpd_C_P((2303 - 7)- 48*0), true),
			141 => (C_ipd(41)'last_event, tpd_C_P((2303 - 7)- 48*0), true),
			142 => (C_ipd(42)'last_event, tpd_C_P((2303 - 7)- 48*0), true),
			143 => (C_ipd(43)'last_event, tpd_C_P((2303 - 7)- 48*0), true),
			144 => (C_ipd(44)'last_event, tpd_C_P((2303 - 7)- 48*0), true),
			145 => (C_ipd(45)'last_event, tpd_C_P((2303 - 7)- 48*0), true),
			146 => (C_ipd(46)'last_event, tpd_C_P((2303 - 7)- 48*0), true),
			147 => (C_ipd(47)'last_event, tpd_C_P((2303 - 7)- 48*0), true),
			148 => (CARRYCASCIN_ipd'last_event, tpd_CARRYCASCIN_P(40), true),
			149 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(40), true),
			150 => (CARRYINSEL_ipd(0)'last_event, tpd_CARRYINSEL_P((143 - 7)- 48*0), true),
			151 => (CARRYINSEL_ipd(1)'last_event, tpd_CARRYINSEL_P((143 - 7)- 48*0), true),
			152 => (CARRYINSEL_ipd(2)'last_event, tpd_CARRYINSEL_P((143 - 7)- 48*0), true),
			153 => (MULTSIGNIN_ipd'last_event, tpd_MULTSIGNIN_P(40), true),
			154 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 7)- 48*0), true),
			155 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 7)- 48*0), true),
			156 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 7)- 48*0), true),
			157 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 7)- 48*0), true),
			158 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 7)- 48*0), true),
			159 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 7)- 48*0), true),
			160 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 7)- 48*0), true),
			161 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 7)- 48*0), true),
			162 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 7)- 48*0), true),
			163 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 7)- 48*0), true),
			164 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 7)- 48*0), true),
			165 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 7)- 48*0), true),
			166 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 7)- 48*0), true),
			167 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 7)- 48*0), true),
			168 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 7)- 48*0), true),
			169 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 7)- 48*0), true),
			170 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 7)- 48*0), true),
			171 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 7)- 48*0), true),
			172 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 7)- 48*0), true),
			173 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 7)- 48*0), true),
			174 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 7)- 48*0), true),
			175 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 7)- 48*0), true),
			176 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 7)- 48*0), true),
			177 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 7)- 48*0), true),
			178 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 7)- 48*0), true),
			179 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 7)- 48*0), true),
			180 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 7)- 48*0), true),
			181 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 7)- 48*0), true),
			182 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 7)- 48*0), true),
			183 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 7)- 48*0), true),
			184 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 7)- 48*0), true),
			185 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 7)- 48*0), true),
			186 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 7)- 48*0), true),
			187 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 7)- 48*0), true),
			188 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 7)- 48*0), true),
			189 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 7)- 48*0), true),
			190 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 7)- 48*0), true),
			191 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 7)- 48*0), true),
			192 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 7)- 48*0), true),
			193 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 7)- 48*0), true),
			194 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 7)- 48*0), true),
			195 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 7)- 48*0), true),
			196 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 7)- 48*0), true),
			197 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 7)- 48*0), true),
			198 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 7)- 48*0), true),
			199 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 7)- 48*0), true),
			200 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 7)- 48*0), true),
			201 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 7)- 48*0), true),
			202 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 7)- 48*0), true),
			203 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 7)- 48*0), true),
			204 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 7)- 48*0), true),
			205 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 7)- 48*0), true),
			206 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 7)- 48*0), true),
			207 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 7)- 48*0), true),
			208 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 7)- 48*0), true),
			209 => (CLK_dly'last_event, tpd_CLK_P(40), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(39),
         GlitchData	=> P_GlitchData(39),
         OutSignalName	=> "P(39)",
         OutTemp	=> P_zd(39),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((1439 - 8)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((1439 - 8)- 48*0), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((1439 - 8)- 48*0), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((1439 - 8)- 48*0), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((1439 - 8)- 48*0), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((1439 - 8)- 48*0), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((1439 - 8)- 48*0), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((1439 - 8)- 48*0), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((1439 - 8)- 48*0), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((1439 - 8)- 48*0), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((1439 - 8)- 48*0), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((1439 - 8)- 48*0), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((1439 - 8)- 48*0), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((1439 - 8)- 48*0), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((1439 - 8)- 48*0), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((1439 - 8)- 48*0), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((1439 - 8)- 48*0), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((1439 - 8)- 48*0), true),
			18 => (A_ipd(18)'last_event, tpd_A_P((1439 - 8)- 48*0), true),
			19 => (A_ipd(19)'last_event, tpd_A_P((1439 - 8)- 48*0), true),
			20 => (A_ipd(20)'last_event, tpd_A_P((1439 - 8)- 48*0), true),
			21 => (A_ipd(21)'last_event, tpd_A_P((1439 - 8)- 48*0), true),
			22 => (A_ipd(22)'last_event, tpd_A_P((1439 - 8)- 48*0), true),
			23 => (A_ipd(23)'last_event, tpd_A_P((1439 - 8)- 48*0), true),
			24 => (A_ipd(24)'last_event, tpd_A_P((1439 - 8)- 48*0), true),
			25 => (A_ipd(25)'last_event, tpd_A_P((1439 - 8)- 48*0), true),
			26 => (A_ipd(26)'last_event, tpd_A_P((1439 - 8)- 48*0), true),
			27 => (A_ipd(27)'last_event, tpd_A_P((1439 - 8)- 48*0), true),
			28 => (A_ipd(28)'last_event, tpd_A_P((1439 - 8)- 48*0), true),
			29 => (A_ipd(29)'last_event, tpd_A_P((1439 - 8)- 48*0), true),
			30 => (ACIN_ipd(0)'last_event, tpd_ACIN_P((1439 - 8)- 48*0), true),
			31 => (ACIN_ipd(1)'last_event, tpd_ACIN_P((1439 - 8)- 48*0), true),
			32 => (ACIN_ipd(2)'last_event, tpd_ACIN_P((1439 - 8)- 48*0), true),
			33 => (ACIN_ipd(3)'last_event, tpd_ACIN_P((1439 - 8)- 48*0), true),
			34 => (ACIN_ipd(4)'last_event, tpd_ACIN_P((1439 - 8)- 48*0), true),
			35 => (ACIN_ipd(5)'last_event, tpd_ACIN_P((1439 - 8)- 48*0), true),
			36 => (ACIN_ipd(6)'last_event, tpd_ACIN_P((1439 - 8)- 48*0), true),
			37 => (ACIN_ipd(7)'last_event, tpd_ACIN_P((1439 - 8)- 48*0), true),
			38 => (ACIN_ipd(8)'last_event, tpd_ACIN_P((1439 - 8)- 48*0), true),
			39 => (ACIN_ipd(9)'last_event, tpd_ACIN_P((1439 - 8)- 48*0), true),
			40 => (ACIN_ipd(10)'last_event, tpd_ACIN_P((1439 - 8)- 48*0), true),
			41 => (ACIN_ipd(11)'last_event, tpd_ACIN_P((1439 - 8)- 48*0), true),
			42 => (ACIN_ipd(12)'last_event, tpd_ACIN_P((1439 - 8)- 48*0), true),
			43 => (ACIN_ipd(13)'last_event, tpd_ACIN_P((1439 - 8)- 48*0), true),
			44 => (ACIN_ipd(14)'last_event, tpd_ACIN_P((1439 - 8)- 48*0), true),
			45 => (ACIN_ipd(15)'last_event, tpd_ACIN_P((1439 - 8)- 48*0), true),
			46 => (ACIN_ipd(16)'last_event, tpd_ACIN_P((1439 - 8)- 48*0), true),
			47 => (ACIN_ipd(17)'last_event, tpd_ACIN_P((1439 - 8)- 48*0), true),
			48 => (ACIN_ipd(18)'last_event, tpd_ACIN_P((1439 - 8)- 48*0), true),
			49 => (ACIN_ipd(19)'last_event, tpd_ACIN_P((1439 - 8)- 48*0), true),
			50 => (ACIN_ipd(20)'last_event, tpd_ACIN_P((1439 - 8)- 48*0), true),
			51 => (ACIN_ipd(21)'last_event, tpd_ACIN_P((1439 - 8)- 48*0), true),
			52 => (ACIN_ipd(22)'last_event, tpd_ACIN_P((1439 - 8)- 48*0), true),
			53 => (ACIN_ipd(23)'last_event, tpd_ACIN_P((1439 - 8)- 48*0), true),
			54 => (ACIN_ipd(24)'last_event, tpd_ACIN_P((1439 - 8)- 48*0), true),
			55 => (ACIN_ipd(25)'last_event, tpd_ACIN_P((1439 - 8)- 48*0), true),
			56 => (ACIN_ipd(26)'last_event, tpd_ACIN_P((1439 - 8)- 48*0), true),
			57 => (ACIN_ipd(27)'last_event, tpd_ACIN_P((1439 - 8)- 48*0), true),
			58 => (ACIN_ipd(28)'last_event, tpd_ACIN_P((1439 - 8)- 48*0), true),
			59 => (ACIN_ipd(29)'last_event, tpd_ACIN_P((1439 - 8)- 48*0), true),
			60 => (ALUMODE_ipd(0)'last_event, tpd_ALUMODE_P((191 - 8)- 48*0), true),
			61 => (ALUMODE_ipd(1)'last_event, tpd_ALUMODE_P((191 - 8)- 48*0), true),
			62 => (ALUMODE_ipd(2)'last_event, tpd_ALUMODE_P((191 - 8)- 48*0), true),
			63 => (ALUMODE_ipd(3)'last_event, tpd_ALUMODE_P((191 - 8)- 48*0), true),
			64 => (B_ipd(0)'last_event, tpd_B_P((863 - 8)- 48*0), true),
			65 => (B_ipd(1)'last_event, tpd_B_P((863 - 8)- 48*0), true),
			66 => (B_ipd(2)'last_event, tpd_B_P((863 - 8)- 48*0), true),
			67 => (B_ipd(3)'last_event, tpd_B_P((863 - 8)- 48*0), true),
			68 => (B_ipd(4)'last_event, tpd_B_P((863 - 8)- 48*0), true),
			69 => (B_ipd(5)'last_event, tpd_B_P((863 - 8)- 48*0), true),
			70 => (B_ipd(6)'last_event, tpd_B_P((863 - 8)- 48*0), true),
			71 => (B_ipd(7)'last_event, tpd_B_P((863 - 8)- 48*0), true),
			72 => (B_ipd(8)'last_event, tpd_B_P((863 - 8)- 48*0), true),
			73 => (B_ipd(9)'last_event, tpd_B_P((863 - 8)- 48*0), true),
			74 => (B_ipd(10)'last_event, tpd_B_P((863 - 8)- 48*0), true),
			75 => (B_ipd(11)'last_event, tpd_B_P((863 - 8)- 48*0), true),
			76 => (B_ipd(12)'last_event, tpd_B_P((863 - 8)- 48*0), true),
			77 => (B_ipd(13)'last_event, tpd_B_P((863 - 8)- 48*0), true),
			78 => (B_ipd(14)'last_event, tpd_B_P((863 - 8)- 48*0), true),
			79 => (B_ipd(15)'last_event, tpd_B_P((863 - 8)- 48*0), true),
			80 => (B_ipd(16)'last_event, tpd_B_P((863 - 8)- 48*0), true),
			81 => (B_ipd(17)'last_event, tpd_B_P((863 - 8)- 48*0), true),
			82 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 8)- 48*0), true),
			83 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 8)- 48*0), true),
			84 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 8)- 48*0), true),
			85 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 8)- 48*0), true),
			86 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 8)- 48*0), true),
			87 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 8)- 48*0), true),
			88 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 8)- 48*0), true),
			89 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 8)- 48*0), true),
			90 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 8)- 48*0), true),
			91 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 8)- 48*0), true),
			92 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 8)- 48*0), true),
			93 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 8)- 48*0), true),
			94 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 8)- 48*0), true),
			95 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 8)- 48*0), true),
			96 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 8)- 48*0), true),
			97 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 8)- 48*0), true),
			98 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 8)- 48*0), true),
			99 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 8)- 48*0), true),
			100 => (C_ipd(0)'last_event, tpd_C_P((2303 - 8)- 48*0), true),
			101 => (C_ipd(1)'last_event, tpd_C_P((2303 - 8)- 48*0), true),
			102 => (C_ipd(2)'last_event, tpd_C_P((2303 - 8)- 48*0), true),
			103 => (C_ipd(3)'last_event, tpd_C_P((2303 - 8)- 48*0), true),
			104 => (C_ipd(4)'last_event, tpd_C_P((2303 - 8)- 48*0), true),
			105 => (C_ipd(5)'last_event, tpd_C_P((2303 - 8)- 48*0), true),
			106 => (C_ipd(6)'last_event, tpd_C_P((2303 - 8)- 48*0), true),
			107 => (C_ipd(7)'last_event, tpd_C_P((2303 - 8)- 48*0), true),
			108 => (C_ipd(8)'last_event, tpd_C_P((2303 - 8)- 48*0), true),
			109 => (C_ipd(9)'last_event, tpd_C_P((2303 - 8)- 48*0), true),
			110 => (C_ipd(10)'last_event, tpd_C_P((2303 - 8)- 48*0), true),
			111 => (C_ipd(11)'last_event, tpd_C_P((2303 - 8)- 48*0), true),
			112 => (C_ipd(12)'last_event, tpd_C_P((2303 - 8)- 48*0), true),
			113 => (C_ipd(13)'last_event, tpd_C_P((2303 - 8)- 48*0), true),
			114 => (C_ipd(14)'last_event, tpd_C_P((2303 - 8)- 48*0), true),
			115 => (C_ipd(15)'last_event, tpd_C_P((2303 - 8)- 48*0), true),
			116 => (C_ipd(16)'last_event, tpd_C_P((2303 - 8)- 48*0), true),
			117 => (C_ipd(17)'last_event, tpd_C_P((2303 - 8)- 48*0), true),
			118 => (C_ipd(18)'last_event, tpd_C_P((2303 - 8)- 48*0), true),
			119 => (C_ipd(19)'last_event, tpd_C_P((2303 - 8)- 48*0), true),
			120 => (C_ipd(20)'last_event, tpd_C_P((2303 - 8)- 48*0), true),
			121 => (C_ipd(21)'last_event, tpd_C_P((2303 - 8)- 48*0), true),
			122 => (C_ipd(22)'last_event, tpd_C_P((2303 - 8)- 48*0), true),
			123 => (C_ipd(23)'last_event, tpd_C_P((2303 - 8)- 48*0), true),
			124 => (C_ipd(24)'last_event, tpd_C_P((2303 - 8)- 48*0), true),
			125 => (C_ipd(25)'last_event, tpd_C_P((2303 - 8)- 48*0), true),
			126 => (C_ipd(26)'last_event, tpd_C_P((2303 - 8)- 48*0), true),
			127 => (C_ipd(27)'last_event, tpd_C_P((2303 - 8)- 48*0), true),
			128 => (C_ipd(28)'last_event, tpd_C_P((2303 - 8)- 48*0), true),
			129 => (C_ipd(29)'last_event, tpd_C_P((2303 - 8)- 48*0), true),
			130 => (C_ipd(30)'last_event, tpd_C_P((2303 - 8)- 48*0), true),
			131 => (C_ipd(31)'last_event, tpd_C_P((2303 - 8)- 48*0), true),
			132 => (C_ipd(32)'last_event, tpd_C_P((2303 - 8)- 48*0), true),
			133 => (C_ipd(33)'last_event, tpd_C_P((2303 - 8)- 48*0), true),
			134 => (C_ipd(34)'last_event, tpd_C_P((2303 - 8)- 48*0), true),
			135 => (C_ipd(35)'last_event, tpd_C_P((2303 - 8)- 48*0), true),
			136 => (C_ipd(36)'last_event, tpd_C_P((2303 - 8)- 48*0), true),
			137 => (C_ipd(37)'last_event, tpd_C_P((2303 - 8)- 48*0), true),
			138 => (C_ipd(38)'last_event, tpd_C_P((2303 - 8)- 48*0), true),
			139 => (C_ipd(39)'last_event, tpd_C_P((2303 - 8)- 48*0), true),
			140 => (C_ipd(40)'last_event, tpd_C_P((2303 - 8)- 48*0), true),
			141 => (C_ipd(41)'last_event, tpd_C_P((2303 - 8)- 48*0), true),
			142 => (C_ipd(42)'last_event, tpd_C_P((2303 - 8)- 48*0), true),
			143 => (C_ipd(43)'last_event, tpd_C_P((2303 - 8)- 48*0), true),
			144 => (C_ipd(44)'last_event, tpd_C_P((2303 - 8)- 48*0), true),
			145 => (C_ipd(45)'last_event, tpd_C_P((2303 - 8)- 48*0), true),
			146 => (C_ipd(46)'last_event, tpd_C_P((2303 - 8)- 48*0), true),
			147 => (C_ipd(47)'last_event, tpd_C_P((2303 - 8)- 48*0), true),
			148 => (CARRYCASCIN_ipd'last_event, tpd_CARRYCASCIN_P(39), true),
			149 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(39), true),
			150 => (CARRYINSEL_ipd(0)'last_event, tpd_CARRYINSEL_P((143 - 8)- 48*0), true),
			151 => (CARRYINSEL_ipd(1)'last_event, tpd_CARRYINSEL_P((143 - 8)- 48*0), true),
			152 => (CARRYINSEL_ipd(2)'last_event, tpd_CARRYINSEL_P((143 - 8)- 48*0), true),
			153 => (MULTSIGNIN_ipd'last_event, tpd_MULTSIGNIN_P(39), true),
			154 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 8)- 48*0), true),
			155 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 8)- 48*0), true),
			156 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 8)- 48*0), true),
			157 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 8)- 48*0), true),
			158 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 8)- 48*0), true),
			159 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 8)- 48*0), true),
			160 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 8)- 48*0), true),
			161 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 8)- 48*0), true),
			162 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 8)- 48*0), true),
			163 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 8)- 48*0), true),
			164 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 8)- 48*0), true),
			165 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 8)- 48*0), true),
			166 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 8)- 48*0), true),
			167 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 8)- 48*0), true),
			168 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 8)- 48*0), true),
			169 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 8)- 48*0), true),
			170 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 8)- 48*0), true),
			171 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 8)- 48*0), true),
			172 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 8)- 48*0), true),
			173 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 8)- 48*0), true),
			174 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 8)- 48*0), true),
			175 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 8)- 48*0), true),
			176 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 8)- 48*0), true),
			177 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 8)- 48*0), true),
			178 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 8)- 48*0), true),
			179 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 8)- 48*0), true),
			180 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 8)- 48*0), true),
			181 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 8)- 48*0), true),
			182 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 8)- 48*0), true),
			183 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 8)- 48*0), true),
			184 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 8)- 48*0), true),
			185 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 8)- 48*0), true),
			186 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 8)- 48*0), true),
			187 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 8)- 48*0), true),
			188 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 8)- 48*0), true),
			189 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 8)- 48*0), true),
			190 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 8)- 48*0), true),
			191 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 8)- 48*0), true),
			192 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 8)- 48*0), true),
			193 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 8)- 48*0), true),
			194 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 8)- 48*0), true),
			195 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 8)- 48*0), true),
			196 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 8)- 48*0), true),
			197 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 8)- 48*0), true),
			198 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 8)- 48*0), true),
			199 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 8)- 48*0), true),
			200 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 8)- 48*0), true),
			201 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 8)- 48*0), true),
			202 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 8)- 48*0), true),
			203 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 8)- 48*0), true),
			204 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 8)- 48*0), true),
			205 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 8)- 48*0), true),
			206 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 8)- 48*0), true),
			207 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 8)- 48*0), true),
			208 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 8)- 48*0), true),
			209 => (CLK_dly'last_event, tpd_CLK_P(39), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(38),
         GlitchData	=> P_GlitchData(38),
         OutSignalName	=> "P(38)",
         OutTemp	=> P_zd(38),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((1439 - 9)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((1439 - 9)- 48*0), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((1439 - 9)- 48*0), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((1439 - 9)- 48*0), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((1439 - 9)- 48*0), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((1439 - 9)- 48*0), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((1439 - 9)- 48*0), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((1439 - 9)- 48*0), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((1439 - 9)- 48*0), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((1439 - 9)- 48*0), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((1439 - 9)- 48*0), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((1439 - 9)- 48*0), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((1439 - 9)- 48*0), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((1439 - 9)- 48*0), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((1439 - 9)- 48*0), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((1439 - 9)- 48*0), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((1439 - 9)- 48*0), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((1439 - 9)- 48*0), true),
			18 => (A_ipd(18)'last_event, tpd_A_P((1439 - 9)- 48*0), true),
			19 => (A_ipd(19)'last_event, tpd_A_P((1439 - 9)- 48*0), true),
			20 => (A_ipd(20)'last_event, tpd_A_P((1439 - 9)- 48*0), true),
			21 => (A_ipd(21)'last_event, tpd_A_P((1439 - 9)- 48*0), true),
			22 => (A_ipd(22)'last_event, tpd_A_P((1439 - 9)- 48*0), true),
			23 => (A_ipd(23)'last_event, tpd_A_P((1439 - 9)- 48*0), true),
			24 => (A_ipd(24)'last_event, tpd_A_P((1439 - 9)- 48*0), true),
			25 => (A_ipd(25)'last_event, tpd_A_P((1439 - 9)- 48*0), true),
			26 => (A_ipd(26)'last_event, tpd_A_P((1439 - 9)- 48*0), true),
			27 => (A_ipd(27)'last_event, tpd_A_P((1439 - 9)- 48*0), true),
			28 => (A_ipd(28)'last_event, tpd_A_P((1439 - 9)- 48*0), true),
			29 => (A_ipd(29)'last_event, tpd_A_P((1439 - 9)- 48*0), true),
			30 => (ACIN_ipd(0)'last_event, tpd_ACIN_P((1439 - 9)- 48*0), true),
			31 => (ACIN_ipd(1)'last_event, tpd_ACIN_P((1439 - 9)- 48*0), true),
			32 => (ACIN_ipd(2)'last_event, tpd_ACIN_P((1439 - 9)- 48*0), true),
			33 => (ACIN_ipd(3)'last_event, tpd_ACIN_P((1439 - 9)- 48*0), true),
			34 => (ACIN_ipd(4)'last_event, tpd_ACIN_P((1439 - 9)- 48*0), true),
			35 => (ACIN_ipd(5)'last_event, tpd_ACIN_P((1439 - 9)- 48*0), true),
			36 => (ACIN_ipd(6)'last_event, tpd_ACIN_P((1439 - 9)- 48*0), true),
			37 => (ACIN_ipd(7)'last_event, tpd_ACIN_P((1439 - 9)- 48*0), true),
			38 => (ACIN_ipd(8)'last_event, tpd_ACIN_P((1439 - 9)- 48*0), true),
			39 => (ACIN_ipd(9)'last_event, tpd_ACIN_P((1439 - 9)- 48*0), true),
			40 => (ACIN_ipd(10)'last_event, tpd_ACIN_P((1439 - 9)- 48*0), true),
			41 => (ACIN_ipd(11)'last_event, tpd_ACIN_P((1439 - 9)- 48*0), true),
			42 => (ACIN_ipd(12)'last_event, tpd_ACIN_P((1439 - 9)- 48*0), true),
			43 => (ACIN_ipd(13)'last_event, tpd_ACIN_P((1439 - 9)- 48*0), true),
			44 => (ACIN_ipd(14)'last_event, tpd_ACIN_P((1439 - 9)- 48*0), true),
			45 => (ACIN_ipd(15)'last_event, tpd_ACIN_P((1439 - 9)- 48*0), true),
			46 => (ACIN_ipd(16)'last_event, tpd_ACIN_P((1439 - 9)- 48*0), true),
			47 => (ACIN_ipd(17)'last_event, tpd_ACIN_P((1439 - 9)- 48*0), true),
			48 => (ACIN_ipd(18)'last_event, tpd_ACIN_P((1439 - 9)- 48*0), true),
			49 => (ACIN_ipd(19)'last_event, tpd_ACIN_P((1439 - 9)- 48*0), true),
			50 => (ACIN_ipd(20)'last_event, tpd_ACIN_P((1439 - 9)- 48*0), true),
			51 => (ACIN_ipd(21)'last_event, tpd_ACIN_P((1439 - 9)- 48*0), true),
			52 => (ACIN_ipd(22)'last_event, tpd_ACIN_P((1439 - 9)- 48*0), true),
			53 => (ACIN_ipd(23)'last_event, tpd_ACIN_P((1439 - 9)- 48*0), true),
			54 => (ACIN_ipd(24)'last_event, tpd_ACIN_P((1439 - 9)- 48*0), true),
			55 => (ACIN_ipd(25)'last_event, tpd_ACIN_P((1439 - 9)- 48*0), true),
			56 => (ACIN_ipd(26)'last_event, tpd_ACIN_P((1439 - 9)- 48*0), true),
			57 => (ACIN_ipd(27)'last_event, tpd_ACIN_P((1439 - 9)- 48*0), true),
			58 => (ACIN_ipd(28)'last_event, tpd_ACIN_P((1439 - 9)- 48*0), true),
			59 => (ACIN_ipd(29)'last_event, tpd_ACIN_P((1439 - 9)- 48*0), true),
			60 => (ALUMODE_ipd(0)'last_event, tpd_ALUMODE_P((191 - 9)- 48*0), true),
			61 => (ALUMODE_ipd(1)'last_event, tpd_ALUMODE_P((191 - 9)- 48*0), true),
			62 => (ALUMODE_ipd(2)'last_event, tpd_ALUMODE_P((191 - 9)- 48*0), true),
			63 => (ALUMODE_ipd(3)'last_event, tpd_ALUMODE_P((191 - 9)- 48*0), true),
			64 => (B_ipd(0)'last_event, tpd_B_P((863 - 9)- 48*0), true),
			65 => (B_ipd(1)'last_event, tpd_B_P((863 - 9)- 48*0), true),
			66 => (B_ipd(2)'last_event, tpd_B_P((863 - 9)- 48*0), true),
			67 => (B_ipd(3)'last_event, tpd_B_P((863 - 9)- 48*0), true),
			68 => (B_ipd(4)'last_event, tpd_B_P((863 - 9)- 48*0), true),
			69 => (B_ipd(5)'last_event, tpd_B_P((863 - 9)- 48*0), true),
			70 => (B_ipd(6)'last_event, tpd_B_P((863 - 9)- 48*0), true),
			71 => (B_ipd(7)'last_event, tpd_B_P((863 - 9)- 48*0), true),
			72 => (B_ipd(8)'last_event, tpd_B_P((863 - 9)- 48*0), true),
			73 => (B_ipd(9)'last_event, tpd_B_P((863 - 9)- 48*0), true),
			74 => (B_ipd(10)'last_event, tpd_B_P((863 - 9)- 48*0), true),
			75 => (B_ipd(11)'last_event, tpd_B_P((863 - 9)- 48*0), true),
			76 => (B_ipd(12)'last_event, tpd_B_P((863 - 9)- 48*0), true),
			77 => (B_ipd(13)'last_event, tpd_B_P((863 - 9)- 48*0), true),
			78 => (B_ipd(14)'last_event, tpd_B_P((863 - 9)- 48*0), true),
			79 => (B_ipd(15)'last_event, tpd_B_P((863 - 9)- 48*0), true),
			80 => (B_ipd(16)'last_event, tpd_B_P((863 - 9)- 48*0), true),
			81 => (B_ipd(17)'last_event, tpd_B_P((863 - 9)- 48*0), true),
			82 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 9)- 48*0), true),
			83 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 9)- 48*0), true),
			84 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 9)- 48*0), true),
			85 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 9)- 48*0), true),
			86 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 9)- 48*0), true),
			87 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 9)- 48*0), true),
			88 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 9)- 48*0), true),
			89 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 9)- 48*0), true),
			90 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 9)- 48*0), true),
			91 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 9)- 48*0), true),
			92 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 9)- 48*0), true),
			93 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 9)- 48*0), true),
			94 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 9)- 48*0), true),
			95 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 9)- 48*0), true),
			96 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 9)- 48*0), true),
			97 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 9)- 48*0), true),
			98 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 9)- 48*0), true),
			99 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 9)- 48*0), true),
			100 => (C_ipd(0)'last_event, tpd_C_P((2303 - 9)- 48*0), true),
			101 => (C_ipd(1)'last_event, tpd_C_P((2303 - 9)- 48*0), true),
			102 => (C_ipd(2)'last_event, tpd_C_P((2303 - 9)- 48*0), true),
			103 => (C_ipd(3)'last_event, tpd_C_P((2303 - 9)- 48*0), true),
			104 => (C_ipd(4)'last_event, tpd_C_P((2303 - 9)- 48*0), true),
			105 => (C_ipd(5)'last_event, tpd_C_P((2303 - 9)- 48*0), true),
			106 => (C_ipd(6)'last_event, tpd_C_P((2303 - 9)- 48*0), true),
			107 => (C_ipd(7)'last_event, tpd_C_P((2303 - 9)- 48*0), true),
			108 => (C_ipd(8)'last_event, tpd_C_P((2303 - 9)- 48*0), true),
			109 => (C_ipd(9)'last_event, tpd_C_P((2303 - 9)- 48*0), true),
			110 => (C_ipd(10)'last_event, tpd_C_P((2303 - 9)- 48*0), true),
			111 => (C_ipd(11)'last_event, tpd_C_P((2303 - 9)- 48*0), true),
			112 => (C_ipd(12)'last_event, tpd_C_P((2303 - 9)- 48*0), true),
			113 => (C_ipd(13)'last_event, tpd_C_P((2303 - 9)- 48*0), true),
			114 => (C_ipd(14)'last_event, tpd_C_P((2303 - 9)- 48*0), true),
			115 => (C_ipd(15)'last_event, tpd_C_P((2303 - 9)- 48*0), true),
			116 => (C_ipd(16)'last_event, tpd_C_P((2303 - 9)- 48*0), true),
			117 => (C_ipd(17)'last_event, tpd_C_P((2303 - 9)- 48*0), true),
			118 => (C_ipd(18)'last_event, tpd_C_P((2303 - 9)- 48*0), true),
			119 => (C_ipd(19)'last_event, tpd_C_P((2303 - 9)- 48*0), true),
			120 => (C_ipd(20)'last_event, tpd_C_P((2303 - 9)- 48*0), true),
			121 => (C_ipd(21)'last_event, tpd_C_P((2303 - 9)- 48*0), true),
			122 => (C_ipd(22)'last_event, tpd_C_P((2303 - 9)- 48*0), true),
			123 => (C_ipd(23)'last_event, tpd_C_P((2303 - 9)- 48*0), true),
			124 => (C_ipd(24)'last_event, tpd_C_P((2303 - 9)- 48*0), true),
			125 => (C_ipd(25)'last_event, tpd_C_P((2303 - 9)- 48*0), true),
			126 => (C_ipd(26)'last_event, tpd_C_P((2303 - 9)- 48*0), true),
			127 => (C_ipd(27)'last_event, tpd_C_P((2303 - 9)- 48*0), true),
			128 => (C_ipd(28)'last_event, tpd_C_P((2303 - 9)- 48*0), true),
			129 => (C_ipd(29)'last_event, tpd_C_P((2303 - 9)- 48*0), true),
			130 => (C_ipd(30)'last_event, tpd_C_P((2303 - 9)- 48*0), true),
			131 => (C_ipd(31)'last_event, tpd_C_P((2303 - 9)- 48*0), true),
			132 => (C_ipd(32)'last_event, tpd_C_P((2303 - 9)- 48*0), true),
			133 => (C_ipd(33)'last_event, tpd_C_P((2303 - 9)- 48*0), true),
			134 => (C_ipd(34)'last_event, tpd_C_P((2303 - 9)- 48*0), true),
			135 => (C_ipd(35)'last_event, tpd_C_P((2303 - 9)- 48*0), true),
			136 => (C_ipd(36)'last_event, tpd_C_P((2303 - 9)- 48*0), true),
			137 => (C_ipd(37)'last_event, tpd_C_P((2303 - 9)- 48*0), true),
			138 => (C_ipd(38)'last_event, tpd_C_P((2303 - 9)- 48*0), true),
			139 => (C_ipd(39)'last_event, tpd_C_P((2303 - 9)- 48*0), true),
			140 => (C_ipd(40)'last_event, tpd_C_P((2303 - 9)- 48*0), true),
			141 => (C_ipd(41)'last_event, tpd_C_P((2303 - 9)- 48*0), true),
			142 => (C_ipd(42)'last_event, tpd_C_P((2303 - 9)- 48*0), true),
			143 => (C_ipd(43)'last_event, tpd_C_P((2303 - 9)- 48*0), true),
			144 => (C_ipd(44)'last_event, tpd_C_P((2303 - 9)- 48*0), true),
			145 => (C_ipd(45)'last_event, tpd_C_P((2303 - 9)- 48*0), true),
			146 => (C_ipd(46)'last_event, tpd_C_P((2303 - 9)- 48*0), true),
			147 => (C_ipd(47)'last_event, tpd_C_P((2303 - 9)- 48*0), true),
			148 => (CARRYCASCIN_ipd'last_event, tpd_CARRYCASCIN_P(38), true),
			149 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(38), true),
			150 => (CARRYINSEL_ipd(0)'last_event, tpd_CARRYINSEL_P((143 - 9)- 48*0), true),
			151 => (CARRYINSEL_ipd(1)'last_event, tpd_CARRYINSEL_P((143 - 9)- 48*0), true),
			152 => (CARRYINSEL_ipd(2)'last_event, tpd_CARRYINSEL_P((143 - 9)- 48*0), true),
			153 => (MULTSIGNIN_ipd'last_event, tpd_MULTSIGNIN_P(38), true),
			154 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 9)- 48*0), true),
			155 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 9)- 48*0), true),
			156 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 9)- 48*0), true),
			157 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 9)- 48*0), true),
			158 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 9)- 48*0), true),
			159 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 9)- 48*0), true),
			160 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 9)- 48*0), true),
			161 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 9)- 48*0), true),
			162 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 9)- 48*0), true),
			163 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 9)- 48*0), true),
			164 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 9)- 48*0), true),
			165 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 9)- 48*0), true),
			166 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 9)- 48*0), true),
			167 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 9)- 48*0), true),
			168 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 9)- 48*0), true),
			169 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 9)- 48*0), true),
			170 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 9)- 48*0), true),
			171 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 9)- 48*0), true),
			172 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 9)- 48*0), true),
			173 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 9)- 48*0), true),
			174 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 9)- 48*0), true),
			175 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 9)- 48*0), true),
			176 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 9)- 48*0), true),
			177 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 9)- 48*0), true),
			178 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 9)- 48*0), true),
			179 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 9)- 48*0), true),
			180 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 9)- 48*0), true),
			181 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 9)- 48*0), true),
			182 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 9)- 48*0), true),
			183 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 9)- 48*0), true),
			184 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 9)- 48*0), true),
			185 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 9)- 48*0), true),
			186 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 9)- 48*0), true),
			187 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 9)- 48*0), true),
			188 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 9)- 48*0), true),
			189 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 9)- 48*0), true),
			190 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 9)- 48*0), true),
			191 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 9)- 48*0), true),
			192 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 9)- 48*0), true),
			193 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 9)- 48*0), true),
			194 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 9)- 48*0), true),
			195 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 9)- 48*0), true),
			196 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 9)- 48*0), true),
			197 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 9)- 48*0), true),
			198 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 9)- 48*0), true),
			199 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 9)- 48*0), true),
			200 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 9)- 48*0), true),
			201 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 9)- 48*0), true),
			202 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 9)- 48*0), true),
			203 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 9)- 48*0), true),
			204 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 9)- 48*0), true),
			205 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 9)- 48*0), true),
			206 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 9)- 48*0), true),
			207 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 9)- 48*0), true),
			208 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 9)- 48*0), true),
			209 => (CLK_dly'last_event, tpd_CLK_P(38), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(37),
         GlitchData	=> P_GlitchData(37),
         OutSignalName	=> "P(37)",
         OutTemp	=> P_zd(37),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((1439 - 10)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((1439 - 10)- 48*0), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((1439 - 10)- 48*0), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((1439 - 10)- 48*0), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((1439 - 10)- 48*0), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((1439 - 10)- 48*0), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((1439 - 10)- 48*0), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((1439 - 10)- 48*0), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((1439 - 10)- 48*0), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((1439 - 10)- 48*0), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((1439 - 10)- 48*0), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((1439 - 10)- 48*0), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((1439 - 10)- 48*0), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((1439 - 10)- 48*0), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((1439 - 10)- 48*0), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((1439 - 10)- 48*0), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((1439 - 10)- 48*0), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((1439 - 10)- 48*0), true),
			18 => (A_ipd(18)'last_event, tpd_A_P((1439 - 10)- 48*0), true),
			19 => (A_ipd(19)'last_event, tpd_A_P((1439 - 10)- 48*0), true),
			20 => (A_ipd(20)'last_event, tpd_A_P((1439 - 10)- 48*0), true),
			21 => (A_ipd(21)'last_event, tpd_A_P((1439 - 10)- 48*0), true),
			22 => (A_ipd(22)'last_event, tpd_A_P((1439 - 10)- 48*0), true),
			23 => (A_ipd(23)'last_event, tpd_A_P((1439 - 10)- 48*0), true),
			24 => (A_ipd(24)'last_event, tpd_A_P((1439 - 10)- 48*0), true),
			25 => (A_ipd(25)'last_event, tpd_A_P((1439 - 10)- 48*0), true),
			26 => (A_ipd(26)'last_event, tpd_A_P((1439 - 10)- 48*0), true),
			27 => (A_ipd(27)'last_event, tpd_A_P((1439 - 10)- 48*0), true),
			28 => (A_ipd(28)'last_event, tpd_A_P((1439 - 10)- 48*0), true),
			29 => (A_ipd(29)'last_event, tpd_A_P((1439 - 10)- 48*0), true),
			30 => (ACIN_ipd(0)'last_event, tpd_ACIN_P((1439 - 10)- 48*0), true),
			31 => (ACIN_ipd(1)'last_event, tpd_ACIN_P((1439 - 10)- 48*0), true),
			32 => (ACIN_ipd(2)'last_event, tpd_ACIN_P((1439 - 10)- 48*0), true),
			33 => (ACIN_ipd(3)'last_event, tpd_ACIN_P((1439 - 10)- 48*0), true),
			34 => (ACIN_ipd(4)'last_event, tpd_ACIN_P((1439 - 10)- 48*0), true),
			35 => (ACIN_ipd(5)'last_event, tpd_ACIN_P((1439 - 10)- 48*0), true),
			36 => (ACIN_ipd(6)'last_event, tpd_ACIN_P((1439 - 10)- 48*0), true),
			37 => (ACIN_ipd(7)'last_event, tpd_ACIN_P((1439 - 10)- 48*0), true),
			38 => (ACIN_ipd(8)'last_event, tpd_ACIN_P((1439 - 10)- 48*0), true),
			39 => (ACIN_ipd(9)'last_event, tpd_ACIN_P((1439 - 10)- 48*0), true),
			40 => (ACIN_ipd(10)'last_event, tpd_ACIN_P((1439 - 10)- 48*0), true),
			41 => (ACIN_ipd(11)'last_event, tpd_ACIN_P((1439 - 10)- 48*0), true),
			42 => (ACIN_ipd(12)'last_event, tpd_ACIN_P((1439 - 10)- 48*0), true),
			43 => (ACIN_ipd(13)'last_event, tpd_ACIN_P((1439 - 10)- 48*0), true),
			44 => (ACIN_ipd(14)'last_event, tpd_ACIN_P((1439 - 10)- 48*0), true),
			45 => (ACIN_ipd(15)'last_event, tpd_ACIN_P((1439 - 10)- 48*0), true),
			46 => (ACIN_ipd(16)'last_event, tpd_ACIN_P((1439 - 10)- 48*0), true),
			47 => (ACIN_ipd(17)'last_event, tpd_ACIN_P((1439 - 10)- 48*0), true),
			48 => (ACIN_ipd(18)'last_event, tpd_ACIN_P((1439 - 10)- 48*0), true),
			49 => (ACIN_ipd(19)'last_event, tpd_ACIN_P((1439 - 10)- 48*0), true),
			50 => (ACIN_ipd(20)'last_event, tpd_ACIN_P((1439 - 10)- 48*0), true),
			51 => (ACIN_ipd(21)'last_event, tpd_ACIN_P((1439 - 10)- 48*0), true),
			52 => (ACIN_ipd(22)'last_event, tpd_ACIN_P((1439 - 10)- 48*0), true),
			53 => (ACIN_ipd(23)'last_event, tpd_ACIN_P((1439 - 10)- 48*0), true),
			54 => (ACIN_ipd(24)'last_event, tpd_ACIN_P((1439 - 10)- 48*0), true),
			55 => (ACIN_ipd(25)'last_event, tpd_ACIN_P((1439 - 10)- 48*0), true),
			56 => (ACIN_ipd(26)'last_event, tpd_ACIN_P((1439 - 10)- 48*0), true),
			57 => (ACIN_ipd(27)'last_event, tpd_ACIN_P((1439 - 10)- 48*0), true),
			58 => (ACIN_ipd(28)'last_event, tpd_ACIN_P((1439 - 10)- 48*0), true),
			59 => (ACIN_ipd(29)'last_event, tpd_ACIN_P((1439 - 10)- 48*0), true),
			60 => (ALUMODE_ipd(0)'last_event, tpd_ALUMODE_P((191 - 10)- 48*0), true),
			61 => (ALUMODE_ipd(1)'last_event, tpd_ALUMODE_P((191 - 10)- 48*0), true),
			62 => (ALUMODE_ipd(2)'last_event, tpd_ALUMODE_P((191 - 10)- 48*0), true),
			63 => (ALUMODE_ipd(3)'last_event, tpd_ALUMODE_P((191 - 10)- 48*0), true),
			64 => (B_ipd(0)'last_event, tpd_B_P((863 - 10)- 48*0), true),
			65 => (B_ipd(1)'last_event, tpd_B_P((863 - 10)- 48*0), true),
			66 => (B_ipd(2)'last_event, tpd_B_P((863 - 10)- 48*0), true),
			67 => (B_ipd(3)'last_event, tpd_B_P((863 - 10)- 48*0), true),
			68 => (B_ipd(4)'last_event, tpd_B_P((863 - 10)- 48*0), true),
			69 => (B_ipd(5)'last_event, tpd_B_P((863 - 10)- 48*0), true),
			70 => (B_ipd(6)'last_event, tpd_B_P((863 - 10)- 48*0), true),
			71 => (B_ipd(7)'last_event, tpd_B_P((863 - 10)- 48*0), true),
			72 => (B_ipd(8)'last_event, tpd_B_P((863 - 10)- 48*0), true),
			73 => (B_ipd(9)'last_event, tpd_B_P((863 - 10)- 48*0), true),
			74 => (B_ipd(10)'last_event, tpd_B_P((863 - 10)- 48*0), true),
			75 => (B_ipd(11)'last_event, tpd_B_P((863 - 10)- 48*0), true),
			76 => (B_ipd(12)'last_event, tpd_B_P((863 - 10)- 48*0), true),
			77 => (B_ipd(13)'last_event, tpd_B_P((863 - 10)- 48*0), true),
			78 => (B_ipd(14)'last_event, tpd_B_P((863 - 10)- 48*0), true),
			79 => (B_ipd(15)'last_event, tpd_B_P((863 - 10)- 48*0), true),
			80 => (B_ipd(16)'last_event, tpd_B_P((863 - 10)- 48*0), true),
			81 => (B_ipd(17)'last_event, tpd_B_P((863 - 10)- 48*0), true),
			82 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 10)- 48*0), true),
			83 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 10)- 48*0), true),
			84 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 10)- 48*0), true),
			85 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 10)- 48*0), true),
			86 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 10)- 48*0), true),
			87 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 10)- 48*0), true),
			88 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 10)- 48*0), true),
			89 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 10)- 48*0), true),
			90 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 10)- 48*0), true),
			91 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 10)- 48*0), true),
			92 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 10)- 48*0), true),
			93 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 10)- 48*0), true),
			94 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 10)- 48*0), true),
			95 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 10)- 48*0), true),
			96 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 10)- 48*0), true),
			97 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 10)- 48*0), true),
			98 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 10)- 48*0), true),
			99 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 10)- 48*0), true),
			100 => (C_ipd(0)'last_event, tpd_C_P((2303 - 10)- 48*0), true),
			101 => (C_ipd(1)'last_event, tpd_C_P((2303 - 10)- 48*0), true),
			102 => (C_ipd(2)'last_event, tpd_C_P((2303 - 10)- 48*0), true),
			103 => (C_ipd(3)'last_event, tpd_C_P((2303 - 10)- 48*0), true),
			104 => (C_ipd(4)'last_event, tpd_C_P((2303 - 10)- 48*0), true),
			105 => (C_ipd(5)'last_event, tpd_C_P((2303 - 10)- 48*0), true),
			106 => (C_ipd(6)'last_event, tpd_C_P((2303 - 10)- 48*0), true),
			107 => (C_ipd(7)'last_event, tpd_C_P((2303 - 10)- 48*0), true),
			108 => (C_ipd(8)'last_event, tpd_C_P((2303 - 10)- 48*0), true),
			109 => (C_ipd(9)'last_event, tpd_C_P((2303 - 10)- 48*0), true),
			110 => (C_ipd(10)'last_event, tpd_C_P((2303 - 10)- 48*0), true),
			111 => (C_ipd(11)'last_event, tpd_C_P((2303 - 10)- 48*0), true),
			112 => (C_ipd(12)'last_event, tpd_C_P((2303 - 10)- 48*0), true),
			113 => (C_ipd(13)'last_event, tpd_C_P((2303 - 10)- 48*0), true),
			114 => (C_ipd(14)'last_event, tpd_C_P((2303 - 10)- 48*0), true),
			115 => (C_ipd(15)'last_event, tpd_C_P((2303 - 10)- 48*0), true),
			116 => (C_ipd(16)'last_event, tpd_C_P((2303 - 10)- 48*0), true),
			117 => (C_ipd(17)'last_event, tpd_C_P((2303 - 10)- 48*0), true),
			118 => (C_ipd(18)'last_event, tpd_C_P((2303 - 10)- 48*0), true),
			119 => (C_ipd(19)'last_event, tpd_C_P((2303 - 10)- 48*0), true),
			120 => (C_ipd(20)'last_event, tpd_C_P((2303 - 10)- 48*0), true),
			121 => (C_ipd(21)'last_event, tpd_C_P((2303 - 10)- 48*0), true),
			122 => (C_ipd(22)'last_event, tpd_C_P((2303 - 10)- 48*0), true),
			123 => (C_ipd(23)'last_event, tpd_C_P((2303 - 10)- 48*0), true),
			124 => (C_ipd(24)'last_event, tpd_C_P((2303 - 10)- 48*0), true),
			125 => (C_ipd(25)'last_event, tpd_C_P((2303 - 10)- 48*0), true),
			126 => (C_ipd(26)'last_event, tpd_C_P((2303 - 10)- 48*0), true),
			127 => (C_ipd(27)'last_event, tpd_C_P((2303 - 10)- 48*0), true),
			128 => (C_ipd(28)'last_event, tpd_C_P((2303 - 10)- 48*0), true),
			129 => (C_ipd(29)'last_event, tpd_C_P((2303 - 10)- 48*0), true),
			130 => (C_ipd(30)'last_event, tpd_C_P((2303 - 10)- 48*0), true),
			131 => (C_ipd(31)'last_event, tpd_C_P((2303 - 10)- 48*0), true),
			132 => (C_ipd(32)'last_event, tpd_C_P((2303 - 10)- 48*0), true),
			133 => (C_ipd(33)'last_event, tpd_C_P((2303 - 10)- 48*0), true),
			134 => (C_ipd(34)'last_event, tpd_C_P((2303 - 10)- 48*0), true),
			135 => (C_ipd(35)'last_event, tpd_C_P((2303 - 10)- 48*0), true),
			136 => (C_ipd(36)'last_event, tpd_C_P((2303 - 10)- 48*0), true),
			137 => (C_ipd(37)'last_event, tpd_C_P((2303 - 10)- 48*0), true),
			138 => (C_ipd(38)'last_event, tpd_C_P((2303 - 10)- 48*0), true),
			139 => (C_ipd(39)'last_event, tpd_C_P((2303 - 10)- 48*0), true),
			140 => (C_ipd(40)'last_event, tpd_C_P((2303 - 10)- 48*0), true),
			141 => (C_ipd(41)'last_event, tpd_C_P((2303 - 10)- 48*0), true),
			142 => (C_ipd(42)'last_event, tpd_C_P((2303 - 10)- 48*0), true),
			143 => (C_ipd(43)'last_event, tpd_C_P((2303 - 10)- 48*0), true),
			144 => (C_ipd(44)'last_event, tpd_C_P((2303 - 10)- 48*0), true),
			145 => (C_ipd(45)'last_event, tpd_C_P((2303 - 10)- 48*0), true),
			146 => (C_ipd(46)'last_event, tpd_C_P((2303 - 10)- 48*0), true),
			147 => (C_ipd(47)'last_event, tpd_C_P((2303 - 10)- 48*0), true),
			148 => (CARRYCASCIN_ipd'last_event, tpd_CARRYCASCIN_P(37), true),
			149 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(37), true),
			150 => (CARRYINSEL_ipd(0)'last_event, tpd_CARRYINSEL_P((143 - 10)- 48*0), true),
			151 => (CARRYINSEL_ipd(1)'last_event, tpd_CARRYINSEL_P((143 - 10)- 48*0), true),
			152 => (CARRYINSEL_ipd(2)'last_event, tpd_CARRYINSEL_P((143 - 10)- 48*0), true),
			153 => (MULTSIGNIN_ipd'last_event, tpd_MULTSIGNIN_P(37), true),
			154 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 10)- 48*0), true),
			155 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 10)- 48*0), true),
			156 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 10)- 48*0), true),
			157 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 10)- 48*0), true),
			158 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 10)- 48*0), true),
			159 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 10)- 48*0), true),
			160 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 10)- 48*0), true),
			161 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 10)- 48*0), true),
			162 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 10)- 48*0), true),
			163 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 10)- 48*0), true),
			164 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 10)- 48*0), true),
			165 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 10)- 48*0), true),
			166 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 10)- 48*0), true),
			167 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 10)- 48*0), true),
			168 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 10)- 48*0), true),
			169 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 10)- 48*0), true),
			170 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 10)- 48*0), true),
			171 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 10)- 48*0), true),
			172 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 10)- 48*0), true),
			173 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 10)- 48*0), true),
			174 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 10)- 48*0), true),
			175 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 10)- 48*0), true),
			176 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 10)- 48*0), true),
			177 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 10)- 48*0), true),
			178 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 10)- 48*0), true),
			179 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 10)- 48*0), true),
			180 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 10)- 48*0), true),
			181 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 10)- 48*0), true),
			182 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 10)- 48*0), true),
			183 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 10)- 48*0), true),
			184 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 10)- 48*0), true),
			185 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 10)- 48*0), true),
			186 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 10)- 48*0), true),
			187 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 10)- 48*0), true),
			188 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 10)- 48*0), true),
			189 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 10)- 48*0), true),
			190 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 10)- 48*0), true),
			191 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 10)- 48*0), true),
			192 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 10)- 48*0), true),
			193 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 10)- 48*0), true),
			194 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 10)- 48*0), true),
			195 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 10)- 48*0), true),
			196 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 10)- 48*0), true),
			197 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 10)- 48*0), true),
			198 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 10)- 48*0), true),
			199 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 10)- 48*0), true),
			200 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 10)- 48*0), true),
			201 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 10)- 48*0), true),
			202 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 10)- 48*0), true),
			203 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 10)- 48*0), true),
			204 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 10)- 48*0), true),
			205 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 10)- 48*0), true),
			206 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 10)- 48*0), true),
			207 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 10)- 48*0), true),
			208 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 10)- 48*0), true),
			209 => (CLK_dly'last_event, tpd_CLK_P(37), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(36),
         GlitchData	=> P_GlitchData(36),
         OutSignalName	=> "P(36)",
         OutTemp	=> P_zd(36),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((1439 - 11)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((1439 - 11)- 48*0), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((1439 - 11)- 48*0), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((1439 - 11)- 48*0), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((1439 - 11)- 48*0), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((1439 - 11)- 48*0), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((1439 - 11)- 48*0), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((1439 - 11)- 48*0), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((1439 - 11)- 48*0), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((1439 - 11)- 48*0), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((1439 - 11)- 48*0), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((1439 - 11)- 48*0), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((1439 - 11)- 48*0), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((1439 - 11)- 48*0), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((1439 - 11)- 48*0), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((1439 - 11)- 48*0), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((1439 - 11)- 48*0), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((1439 - 11)- 48*0), true),
			18 => (A_ipd(18)'last_event, tpd_A_P((1439 - 11)- 48*0), true),
			19 => (A_ipd(19)'last_event, tpd_A_P((1439 - 11)- 48*0), true),
			20 => (A_ipd(20)'last_event, tpd_A_P((1439 - 11)- 48*0), true),
			21 => (A_ipd(21)'last_event, tpd_A_P((1439 - 11)- 48*0), true),
			22 => (A_ipd(22)'last_event, tpd_A_P((1439 - 11)- 48*0), true),
			23 => (A_ipd(23)'last_event, tpd_A_P((1439 - 11)- 48*0), true),
			24 => (A_ipd(24)'last_event, tpd_A_P((1439 - 11)- 48*0), true),
			25 => (A_ipd(25)'last_event, tpd_A_P((1439 - 11)- 48*0), true),
			26 => (A_ipd(26)'last_event, tpd_A_P((1439 - 11)- 48*0), true),
			27 => (A_ipd(27)'last_event, tpd_A_P((1439 - 11)- 48*0), true),
			28 => (A_ipd(28)'last_event, tpd_A_P((1439 - 11)- 48*0), true),
			29 => (A_ipd(29)'last_event, tpd_A_P((1439 - 11)- 48*0), true),
			30 => (ACIN_ipd(0)'last_event, tpd_ACIN_P((1439 - 11)- 48*0), true),
			31 => (ACIN_ipd(1)'last_event, tpd_ACIN_P((1439 - 11)- 48*0), true),
			32 => (ACIN_ipd(2)'last_event, tpd_ACIN_P((1439 - 11)- 48*0), true),
			33 => (ACIN_ipd(3)'last_event, tpd_ACIN_P((1439 - 11)- 48*0), true),
			34 => (ACIN_ipd(4)'last_event, tpd_ACIN_P((1439 - 11)- 48*0), true),
			35 => (ACIN_ipd(5)'last_event, tpd_ACIN_P((1439 - 11)- 48*0), true),
			36 => (ACIN_ipd(6)'last_event, tpd_ACIN_P((1439 - 11)- 48*0), true),
			37 => (ACIN_ipd(7)'last_event, tpd_ACIN_P((1439 - 11)- 48*0), true),
			38 => (ACIN_ipd(8)'last_event, tpd_ACIN_P((1439 - 11)- 48*0), true),
			39 => (ACIN_ipd(9)'last_event, tpd_ACIN_P((1439 - 11)- 48*0), true),
			40 => (ACIN_ipd(10)'last_event, tpd_ACIN_P((1439 - 11)- 48*0), true),
			41 => (ACIN_ipd(11)'last_event, tpd_ACIN_P((1439 - 11)- 48*0), true),
			42 => (ACIN_ipd(12)'last_event, tpd_ACIN_P((1439 - 11)- 48*0), true),
			43 => (ACIN_ipd(13)'last_event, tpd_ACIN_P((1439 - 11)- 48*0), true),
			44 => (ACIN_ipd(14)'last_event, tpd_ACIN_P((1439 - 11)- 48*0), true),
			45 => (ACIN_ipd(15)'last_event, tpd_ACIN_P((1439 - 11)- 48*0), true),
			46 => (ACIN_ipd(16)'last_event, tpd_ACIN_P((1439 - 11)- 48*0), true),
			47 => (ACIN_ipd(17)'last_event, tpd_ACIN_P((1439 - 11)- 48*0), true),
			48 => (ACIN_ipd(18)'last_event, tpd_ACIN_P((1439 - 11)- 48*0), true),
			49 => (ACIN_ipd(19)'last_event, tpd_ACIN_P((1439 - 11)- 48*0), true),
			50 => (ACIN_ipd(20)'last_event, tpd_ACIN_P((1439 - 11)- 48*0), true),
			51 => (ACIN_ipd(21)'last_event, tpd_ACIN_P((1439 - 11)- 48*0), true),
			52 => (ACIN_ipd(22)'last_event, tpd_ACIN_P((1439 - 11)- 48*0), true),
			53 => (ACIN_ipd(23)'last_event, tpd_ACIN_P((1439 - 11)- 48*0), true),
			54 => (ACIN_ipd(24)'last_event, tpd_ACIN_P((1439 - 11)- 48*0), true),
			55 => (ACIN_ipd(25)'last_event, tpd_ACIN_P((1439 - 11)- 48*0), true),
			56 => (ACIN_ipd(26)'last_event, tpd_ACIN_P((1439 - 11)- 48*0), true),
			57 => (ACIN_ipd(27)'last_event, tpd_ACIN_P((1439 - 11)- 48*0), true),
			58 => (ACIN_ipd(28)'last_event, tpd_ACIN_P((1439 - 11)- 48*0), true),
			59 => (ACIN_ipd(29)'last_event, tpd_ACIN_P((1439 - 11)- 48*0), true),
			60 => (ALUMODE_ipd(0)'last_event, tpd_ALUMODE_P((191 - 11)- 48*0), true),
			61 => (ALUMODE_ipd(1)'last_event, tpd_ALUMODE_P((191 - 11)- 48*0), true),
			62 => (ALUMODE_ipd(2)'last_event, tpd_ALUMODE_P((191 - 11)- 48*0), true),
			63 => (ALUMODE_ipd(3)'last_event, tpd_ALUMODE_P((191 - 11)- 48*0), true),
			64 => (B_ipd(0)'last_event, tpd_B_P((863 - 11)- 48*0), true),
			65 => (B_ipd(1)'last_event, tpd_B_P((863 - 11)- 48*0), true),
			66 => (B_ipd(2)'last_event, tpd_B_P((863 - 11)- 48*0), true),
			67 => (B_ipd(3)'last_event, tpd_B_P((863 - 11)- 48*0), true),
			68 => (B_ipd(4)'last_event, tpd_B_P((863 - 11)- 48*0), true),
			69 => (B_ipd(5)'last_event, tpd_B_P((863 - 11)- 48*0), true),
			70 => (B_ipd(6)'last_event, tpd_B_P((863 - 11)- 48*0), true),
			71 => (B_ipd(7)'last_event, tpd_B_P((863 - 11)- 48*0), true),
			72 => (B_ipd(8)'last_event, tpd_B_P((863 - 11)- 48*0), true),
			73 => (B_ipd(9)'last_event, tpd_B_P((863 - 11)- 48*0), true),
			74 => (B_ipd(10)'last_event, tpd_B_P((863 - 11)- 48*0), true),
			75 => (B_ipd(11)'last_event, tpd_B_P((863 - 11)- 48*0), true),
			76 => (B_ipd(12)'last_event, tpd_B_P((863 - 11)- 48*0), true),
			77 => (B_ipd(13)'last_event, tpd_B_P((863 - 11)- 48*0), true),
			78 => (B_ipd(14)'last_event, tpd_B_P((863 - 11)- 48*0), true),
			79 => (B_ipd(15)'last_event, tpd_B_P((863 - 11)- 48*0), true),
			80 => (B_ipd(16)'last_event, tpd_B_P((863 - 11)- 48*0), true),
			81 => (B_ipd(17)'last_event, tpd_B_P((863 - 11)- 48*0), true),
			82 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 11)- 48*0), true),
			83 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 11)- 48*0), true),
			84 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 11)- 48*0), true),
			85 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 11)- 48*0), true),
			86 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 11)- 48*0), true),
			87 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 11)- 48*0), true),
			88 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 11)- 48*0), true),
			89 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 11)- 48*0), true),
			90 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 11)- 48*0), true),
			91 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 11)- 48*0), true),
			92 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 11)- 48*0), true),
			93 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 11)- 48*0), true),
			94 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 11)- 48*0), true),
			95 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 11)- 48*0), true),
			96 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 11)- 48*0), true),
			97 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 11)- 48*0), true),
			98 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 11)- 48*0), true),
			99 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 11)- 48*0), true),
			100 => (C_ipd(0)'last_event, tpd_C_P((2303 - 11)- 48*0), true),
			101 => (C_ipd(1)'last_event, tpd_C_P((2303 - 11)- 48*0), true),
			102 => (C_ipd(2)'last_event, tpd_C_P((2303 - 11)- 48*0), true),
			103 => (C_ipd(3)'last_event, tpd_C_P((2303 - 11)- 48*0), true),
			104 => (C_ipd(4)'last_event, tpd_C_P((2303 - 11)- 48*0), true),
			105 => (C_ipd(5)'last_event, tpd_C_P((2303 - 11)- 48*0), true),
			106 => (C_ipd(6)'last_event, tpd_C_P((2303 - 11)- 48*0), true),
			107 => (C_ipd(7)'last_event, tpd_C_P((2303 - 11)- 48*0), true),
			108 => (C_ipd(8)'last_event, tpd_C_P((2303 - 11)- 48*0), true),
			109 => (C_ipd(9)'last_event, tpd_C_P((2303 - 11)- 48*0), true),
			110 => (C_ipd(10)'last_event, tpd_C_P((2303 - 11)- 48*0), true),
			111 => (C_ipd(11)'last_event, tpd_C_P((2303 - 11)- 48*0), true),
			112 => (C_ipd(12)'last_event, tpd_C_P((2303 - 11)- 48*0), true),
			113 => (C_ipd(13)'last_event, tpd_C_P((2303 - 11)- 48*0), true),
			114 => (C_ipd(14)'last_event, tpd_C_P((2303 - 11)- 48*0), true),
			115 => (C_ipd(15)'last_event, tpd_C_P((2303 - 11)- 48*0), true),
			116 => (C_ipd(16)'last_event, tpd_C_P((2303 - 11)- 48*0), true),
			117 => (C_ipd(17)'last_event, tpd_C_P((2303 - 11)- 48*0), true),
			118 => (C_ipd(18)'last_event, tpd_C_P((2303 - 11)- 48*0), true),
			119 => (C_ipd(19)'last_event, tpd_C_P((2303 - 11)- 48*0), true),
			120 => (C_ipd(20)'last_event, tpd_C_P((2303 - 11)- 48*0), true),
			121 => (C_ipd(21)'last_event, tpd_C_P((2303 - 11)- 48*0), true),
			122 => (C_ipd(22)'last_event, tpd_C_P((2303 - 11)- 48*0), true),
			123 => (C_ipd(23)'last_event, tpd_C_P((2303 - 11)- 48*0), true),
			124 => (C_ipd(24)'last_event, tpd_C_P((2303 - 11)- 48*0), true),
			125 => (C_ipd(25)'last_event, tpd_C_P((2303 - 11)- 48*0), true),
			126 => (C_ipd(26)'last_event, tpd_C_P((2303 - 11)- 48*0), true),
			127 => (C_ipd(27)'last_event, tpd_C_P((2303 - 11)- 48*0), true),
			128 => (C_ipd(28)'last_event, tpd_C_P((2303 - 11)- 48*0), true),
			129 => (C_ipd(29)'last_event, tpd_C_P((2303 - 11)- 48*0), true),
			130 => (C_ipd(30)'last_event, tpd_C_P((2303 - 11)- 48*0), true),
			131 => (C_ipd(31)'last_event, tpd_C_P((2303 - 11)- 48*0), true),
			132 => (C_ipd(32)'last_event, tpd_C_P((2303 - 11)- 48*0), true),
			133 => (C_ipd(33)'last_event, tpd_C_P((2303 - 11)- 48*0), true),
			134 => (C_ipd(34)'last_event, tpd_C_P((2303 - 11)- 48*0), true),
			135 => (C_ipd(35)'last_event, tpd_C_P((2303 - 11)- 48*0), true),
			136 => (C_ipd(36)'last_event, tpd_C_P((2303 - 11)- 48*0), true),
			137 => (C_ipd(37)'last_event, tpd_C_P((2303 - 11)- 48*0), true),
			138 => (C_ipd(38)'last_event, tpd_C_P((2303 - 11)- 48*0), true),
			139 => (C_ipd(39)'last_event, tpd_C_P((2303 - 11)- 48*0), true),
			140 => (C_ipd(40)'last_event, tpd_C_P((2303 - 11)- 48*0), true),
			141 => (C_ipd(41)'last_event, tpd_C_P((2303 - 11)- 48*0), true),
			142 => (C_ipd(42)'last_event, tpd_C_P((2303 - 11)- 48*0), true),
			143 => (C_ipd(43)'last_event, tpd_C_P((2303 - 11)- 48*0), true),
			144 => (C_ipd(44)'last_event, tpd_C_P((2303 - 11)- 48*0), true),
			145 => (C_ipd(45)'last_event, tpd_C_P((2303 - 11)- 48*0), true),
			146 => (C_ipd(46)'last_event, tpd_C_P((2303 - 11)- 48*0), true),
			147 => (C_ipd(47)'last_event, tpd_C_P((2303 - 11)- 48*0), true),
			148 => (CARRYCASCIN_ipd'last_event, tpd_CARRYCASCIN_P(36), true),
			149 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(36), true),
			150 => (CARRYINSEL_ipd(0)'last_event, tpd_CARRYINSEL_P((143 - 11)- 48*0), true),
			151 => (CARRYINSEL_ipd(1)'last_event, tpd_CARRYINSEL_P((143 - 11)- 48*0), true),
			152 => (CARRYINSEL_ipd(2)'last_event, tpd_CARRYINSEL_P((143 - 11)- 48*0), true),
			153 => (MULTSIGNIN_ipd'last_event, tpd_MULTSIGNIN_P(36), true),
			154 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 11)- 48*0), true),
			155 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 11)- 48*0), true),
			156 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 11)- 48*0), true),
			157 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 11)- 48*0), true),
			158 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 11)- 48*0), true),
			159 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 11)- 48*0), true),
			160 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 11)- 48*0), true),
			161 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 11)- 48*0), true),
			162 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 11)- 48*0), true),
			163 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 11)- 48*0), true),
			164 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 11)- 48*0), true),
			165 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 11)- 48*0), true),
			166 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 11)- 48*0), true),
			167 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 11)- 48*0), true),
			168 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 11)- 48*0), true),
			169 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 11)- 48*0), true),
			170 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 11)- 48*0), true),
			171 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 11)- 48*0), true),
			172 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 11)- 48*0), true),
			173 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 11)- 48*0), true),
			174 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 11)- 48*0), true),
			175 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 11)- 48*0), true),
			176 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 11)- 48*0), true),
			177 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 11)- 48*0), true),
			178 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 11)- 48*0), true),
			179 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 11)- 48*0), true),
			180 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 11)- 48*0), true),
			181 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 11)- 48*0), true),
			182 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 11)- 48*0), true),
			183 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 11)- 48*0), true),
			184 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 11)- 48*0), true),
			185 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 11)- 48*0), true),
			186 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 11)- 48*0), true),
			187 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 11)- 48*0), true),
			188 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 11)- 48*0), true),
			189 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 11)- 48*0), true),
			190 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 11)- 48*0), true),
			191 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 11)- 48*0), true),
			192 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 11)- 48*0), true),
			193 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 11)- 48*0), true),
			194 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 11)- 48*0), true),
			195 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 11)- 48*0), true),
			196 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 11)- 48*0), true),
			197 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 11)- 48*0), true),
			198 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 11)- 48*0), true),
			199 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 11)- 48*0), true),
			200 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 11)- 48*0), true),
			201 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 11)- 48*0), true),
			202 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 11)- 48*0), true),
			203 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 11)- 48*0), true),
			204 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 11)- 48*0), true),
			205 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 11)- 48*0), true),
			206 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 11)- 48*0), true),
			207 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 11)- 48*0), true),
			208 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 11)- 48*0), true),
			209 => (CLK_dly'last_event, tpd_CLK_P(36), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(35),
         GlitchData	=> P_GlitchData(35),
         OutSignalName	=> "P(35)",
         OutTemp	=> P_zd(35),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((1439 - 12)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((1439 - 12)- 48*0), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((1439 - 12)- 48*0), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((1439 - 12)- 48*0), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((1439 - 12)- 48*0), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((1439 - 12)- 48*0), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((1439 - 12)- 48*0), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((1439 - 12)- 48*0), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((1439 - 12)- 48*0), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((1439 - 12)- 48*0), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((1439 - 12)- 48*0), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((1439 - 12)- 48*0), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((1439 - 12)- 48*0), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((1439 - 12)- 48*0), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((1439 - 12)- 48*0), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((1439 - 12)- 48*0), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((1439 - 12)- 48*0), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((1439 - 12)- 48*0), true),
			18 => (A_ipd(18)'last_event, tpd_A_P((1439 - 12)- 48*0), true),
			19 => (A_ipd(19)'last_event, tpd_A_P((1439 - 12)- 48*0), true),
			20 => (A_ipd(20)'last_event, tpd_A_P((1439 - 12)- 48*0), true),
			21 => (A_ipd(21)'last_event, tpd_A_P((1439 - 12)- 48*0), true),
			22 => (A_ipd(22)'last_event, tpd_A_P((1439 - 12)- 48*0), true),
			23 => (A_ipd(23)'last_event, tpd_A_P((1439 - 12)- 48*0), true),
			24 => (A_ipd(24)'last_event, tpd_A_P((1439 - 12)- 48*0), true),
			25 => (A_ipd(25)'last_event, tpd_A_P((1439 - 12)- 48*0), true),
			26 => (A_ipd(26)'last_event, tpd_A_P((1439 - 12)- 48*0), true),
			27 => (A_ipd(27)'last_event, tpd_A_P((1439 - 12)- 48*0), true),
			28 => (A_ipd(28)'last_event, tpd_A_P((1439 - 12)- 48*0), true),
			29 => (A_ipd(29)'last_event, tpd_A_P((1439 - 12)- 48*0), true),
			30 => (ACIN_ipd(0)'last_event, tpd_ACIN_P((1439 - 12)- 48*0), true),
			31 => (ACIN_ipd(1)'last_event, tpd_ACIN_P((1439 - 12)- 48*0), true),
			32 => (ACIN_ipd(2)'last_event, tpd_ACIN_P((1439 - 12)- 48*0), true),
			33 => (ACIN_ipd(3)'last_event, tpd_ACIN_P((1439 - 12)- 48*0), true),
			34 => (ACIN_ipd(4)'last_event, tpd_ACIN_P((1439 - 12)- 48*0), true),
			35 => (ACIN_ipd(5)'last_event, tpd_ACIN_P((1439 - 12)- 48*0), true),
			36 => (ACIN_ipd(6)'last_event, tpd_ACIN_P((1439 - 12)- 48*0), true),
			37 => (ACIN_ipd(7)'last_event, tpd_ACIN_P((1439 - 12)- 48*0), true),
			38 => (ACIN_ipd(8)'last_event, tpd_ACIN_P((1439 - 12)- 48*0), true),
			39 => (ACIN_ipd(9)'last_event, tpd_ACIN_P((1439 - 12)- 48*0), true),
			40 => (ACIN_ipd(10)'last_event, tpd_ACIN_P((1439 - 12)- 48*0), true),
			41 => (ACIN_ipd(11)'last_event, tpd_ACIN_P((1439 - 12)- 48*0), true),
			42 => (ACIN_ipd(12)'last_event, tpd_ACIN_P((1439 - 12)- 48*0), true),
			43 => (ACIN_ipd(13)'last_event, tpd_ACIN_P((1439 - 12)- 48*0), true),
			44 => (ACIN_ipd(14)'last_event, tpd_ACIN_P((1439 - 12)- 48*0), true),
			45 => (ACIN_ipd(15)'last_event, tpd_ACIN_P((1439 - 12)- 48*0), true),
			46 => (ACIN_ipd(16)'last_event, tpd_ACIN_P((1439 - 12)- 48*0), true),
			47 => (ACIN_ipd(17)'last_event, tpd_ACIN_P((1439 - 12)- 48*0), true),
			48 => (ACIN_ipd(18)'last_event, tpd_ACIN_P((1439 - 12)- 48*0), true),
			49 => (ACIN_ipd(19)'last_event, tpd_ACIN_P((1439 - 12)- 48*0), true),
			50 => (ACIN_ipd(20)'last_event, tpd_ACIN_P((1439 - 12)- 48*0), true),
			51 => (ACIN_ipd(21)'last_event, tpd_ACIN_P((1439 - 12)- 48*0), true),
			52 => (ACIN_ipd(22)'last_event, tpd_ACIN_P((1439 - 12)- 48*0), true),
			53 => (ACIN_ipd(23)'last_event, tpd_ACIN_P((1439 - 12)- 48*0), true),
			54 => (ACIN_ipd(24)'last_event, tpd_ACIN_P((1439 - 12)- 48*0), true),
			55 => (ACIN_ipd(25)'last_event, tpd_ACIN_P((1439 - 12)- 48*0), true),
			56 => (ACIN_ipd(26)'last_event, tpd_ACIN_P((1439 - 12)- 48*0), true),
			57 => (ACIN_ipd(27)'last_event, tpd_ACIN_P((1439 - 12)- 48*0), true),
			58 => (ACIN_ipd(28)'last_event, tpd_ACIN_P((1439 - 12)- 48*0), true),
			59 => (ACIN_ipd(29)'last_event, tpd_ACIN_P((1439 - 12)- 48*0), true),
			60 => (ALUMODE_ipd(0)'last_event, tpd_ALUMODE_P((191 - 12)- 48*0), true),
			61 => (ALUMODE_ipd(1)'last_event, tpd_ALUMODE_P((191 - 12)- 48*0), true),
			62 => (ALUMODE_ipd(2)'last_event, tpd_ALUMODE_P((191 - 12)- 48*0), true),
			63 => (ALUMODE_ipd(3)'last_event, tpd_ALUMODE_P((191 - 12)- 48*0), true),
			64 => (B_ipd(0)'last_event, tpd_B_P((863 - 12)- 48*0), true),
			65 => (B_ipd(1)'last_event, tpd_B_P((863 - 12)- 48*0), true),
			66 => (B_ipd(2)'last_event, tpd_B_P((863 - 12)- 48*0), true),
			67 => (B_ipd(3)'last_event, tpd_B_P((863 - 12)- 48*0), true),
			68 => (B_ipd(4)'last_event, tpd_B_P((863 - 12)- 48*0), true),
			69 => (B_ipd(5)'last_event, tpd_B_P((863 - 12)- 48*0), true),
			70 => (B_ipd(6)'last_event, tpd_B_P((863 - 12)- 48*0), true),
			71 => (B_ipd(7)'last_event, tpd_B_P((863 - 12)- 48*0), true),
			72 => (B_ipd(8)'last_event, tpd_B_P((863 - 12)- 48*0), true),
			73 => (B_ipd(9)'last_event, tpd_B_P((863 - 12)- 48*0), true),
			74 => (B_ipd(10)'last_event, tpd_B_P((863 - 12)- 48*0), true),
			75 => (B_ipd(11)'last_event, tpd_B_P((863 - 12)- 48*0), true),
			76 => (B_ipd(12)'last_event, tpd_B_P((863 - 12)- 48*0), true),
			77 => (B_ipd(13)'last_event, tpd_B_P((863 - 12)- 48*0), true),
			78 => (B_ipd(14)'last_event, tpd_B_P((863 - 12)- 48*0), true),
			79 => (B_ipd(15)'last_event, tpd_B_P((863 - 12)- 48*0), true),
			80 => (B_ipd(16)'last_event, tpd_B_P((863 - 12)- 48*0), true),
			81 => (B_ipd(17)'last_event, tpd_B_P((863 - 12)- 48*0), true),
			82 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 12)- 48*0), true),
			83 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 12)- 48*0), true),
			84 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 12)- 48*0), true),
			85 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 12)- 48*0), true),
			86 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 12)- 48*0), true),
			87 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 12)- 48*0), true),
			88 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 12)- 48*0), true),
			89 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 12)- 48*0), true),
			90 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 12)- 48*0), true),
			91 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 12)- 48*0), true),
			92 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 12)- 48*0), true),
			93 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 12)- 48*0), true),
			94 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 12)- 48*0), true),
			95 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 12)- 48*0), true),
			96 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 12)- 48*0), true),
			97 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 12)- 48*0), true),
			98 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 12)- 48*0), true),
			99 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 12)- 48*0), true),
			100 => (C_ipd(0)'last_event, tpd_C_P((2303 - 12)- 48*0), true),
			101 => (C_ipd(1)'last_event, tpd_C_P((2303 - 12)- 48*0), true),
			102 => (C_ipd(2)'last_event, tpd_C_P((2303 - 12)- 48*0), true),
			103 => (C_ipd(3)'last_event, tpd_C_P((2303 - 12)- 48*0), true),
			104 => (C_ipd(4)'last_event, tpd_C_P((2303 - 12)- 48*0), true),
			105 => (C_ipd(5)'last_event, tpd_C_P((2303 - 12)- 48*0), true),
			106 => (C_ipd(6)'last_event, tpd_C_P((2303 - 12)- 48*0), true),
			107 => (C_ipd(7)'last_event, tpd_C_P((2303 - 12)- 48*0), true),
			108 => (C_ipd(8)'last_event, tpd_C_P((2303 - 12)- 48*0), true),
			109 => (C_ipd(9)'last_event, tpd_C_P((2303 - 12)- 48*0), true),
			110 => (C_ipd(10)'last_event, tpd_C_P((2303 - 12)- 48*0), true),
			111 => (C_ipd(11)'last_event, tpd_C_P((2303 - 12)- 48*0), true),
			112 => (C_ipd(12)'last_event, tpd_C_P((2303 - 12)- 48*0), true),
			113 => (C_ipd(13)'last_event, tpd_C_P((2303 - 12)- 48*0), true),
			114 => (C_ipd(14)'last_event, tpd_C_P((2303 - 12)- 48*0), true),
			115 => (C_ipd(15)'last_event, tpd_C_P((2303 - 12)- 48*0), true),
			116 => (C_ipd(16)'last_event, tpd_C_P((2303 - 12)- 48*0), true),
			117 => (C_ipd(17)'last_event, tpd_C_P((2303 - 12)- 48*0), true),
			118 => (C_ipd(18)'last_event, tpd_C_P((2303 - 12)- 48*0), true),
			119 => (C_ipd(19)'last_event, tpd_C_P((2303 - 12)- 48*0), true),
			120 => (C_ipd(20)'last_event, tpd_C_P((2303 - 12)- 48*0), true),
			121 => (C_ipd(21)'last_event, tpd_C_P((2303 - 12)- 48*0), true),
			122 => (C_ipd(22)'last_event, tpd_C_P((2303 - 12)- 48*0), true),
			123 => (C_ipd(23)'last_event, tpd_C_P((2303 - 12)- 48*0), true),
			124 => (C_ipd(24)'last_event, tpd_C_P((2303 - 12)- 48*0), true),
			125 => (C_ipd(25)'last_event, tpd_C_P((2303 - 12)- 48*0), true),
			126 => (C_ipd(26)'last_event, tpd_C_P((2303 - 12)- 48*0), true),
			127 => (C_ipd(27)'last_event, tpd_C_P((2303 - 12)- 48*0), true),
			128 => (C_ipd(28)'last_event, tpd_C_P((2303 - 12)- 48*0), true),
			129 => (C_ipd(29)'last_event, tpd_C_P((2303 - 12)- 48*0), true),
			130 => (C_ipd(30)'last_event, tpd_C_P((2303 - 12)- 48*0), true),
			131 => (C_ipd(31)'last_event, tpd_C_P((2303 - 12)- 48*0), true),
			132 => (C_ipd(32)'last_event, tpd_C_P((2303 - 12)- 48*0), true),
			133 => (C_ipd(33)'last_event, tpd_C_P((2303 - 12)- 48*0), true),
			134 => (C_ipd(34)'last_event, tpd_C_P((2303 - 12)- 48*0), true),
			135 => (C_ipd(35)'last_event, tpd_C_P((2303 - 12)- 48*0), true),
			136 => (C_ipd(36)'last_event, tpd_C_P((2303 - 12)- 48*0), true),
			137 => (C_ipd(37)'last_event, tpd_C_P((2303 - 12)- 48*0), true),
			138 => (C_ipd(38)'last_event, tpd_C_P((2303 - 12)- 48*0), true),
			139 => (C_ipd(39)'last_event, tpd_C_P((2303 - 12)- 48*0), true),
			140 => (C_ipd(40)'last_event, tpd_C_P((2303 - 12)- 48*0), true),
			141 => (C_ipd(41)'last_event, tpd_C_P((2303 - 12)- 48*0), true),
			142 => (C_ipd(42)'last_event, tpd_C_P((2303 - 12)- 48*0), true),
			143 => (C_ipd(43)'last_event, tpd_C_P((2303 - 12)- 48*0), true),
			144 => (C_ipd(44)'last_event, tpd_C_P((2303 - 12)- 48*0), true),
			145 => (C_ipd(45)'last_event, tpd_C_P((2303 - 12)- 48*0), true),
			146 => (C_ipd(46)'last_event, tpd_C_P((2303 - 12)- 48*0), true),
			147 => (C_ipd(47)'last_event, tpd_C_P((2303 - 12)- 48*0), true),
			148 => (CARRYCASCIN_ipd'last_event, tpd_CARRYCASCIN_P(35), true),
			149 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(35), true),
			150 => (CARRYINSEL_ipd(0)'last_event, tpd_CARRYINSEL_P((143 - 12)- 48*0), true),
			151 => (CARRYINSEL_ipd(1)'last_event, tpd_CARRYINSEL_P((143 - 12)- 48*0), true),
			152 => (CARRYINSEL_ipd(2)'last_event, tpd_CARRYINSEL_P((143 - 12)- 48*0), true),
			153 => (MULTSIGNIN_ipd'last_event, tpd_MULTSIGNIN_P(35), true),
			154 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 12)- 48*0), true),
			155 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 12)- 48*0), true),
			156 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 12)- 48*0), true),
			157 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 12)- 48*0), true),
			158 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 12)- 48*0), true),
			159 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 12)- 48*0), true),
			160 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 12)- 48*0), true),
			161 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 12)- 48*0), true),
			162 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 12)- 48*0), true),
			163 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 12)- 48*0), true),
			164 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 12)- 48*0), true),
			165 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 12)- 48*0), true),
			166 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 12)- 48*0), true),
			167 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 12)- 48*0), true),
			168 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 12)- 48*0), true),
			169 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 12)- 48*0), true),
			170 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 12)- 48*0), true),
			171 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 12)- 48*0), true),
			172 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 12)- 48*0), true),
			173 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 12)- 48*0), true),
			174 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 12)- 48*0), true),
			175 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 12)- 48*0), true),
			176 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 12)- 48*0), true),
			177 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 12)- 48*0), true),
			178 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 12)- 48*0), true),
			179 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 12)- 48*0), true),
			180 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 12)- 48*0), true),
			181 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 12)- 48*0), true),
			182 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 12)- 48*0), true),
			183 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 12)- 48*0), true),
			184 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 12)- 48*0), true),
			185 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 12)- 48*0), true),
			186 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 12)- 48*0), true),
			187 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 12)- 48*0), true),
			188 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 12)- 48*0), true),
			189 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 12)- 48*0), true),
			190 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 12)- 48*0), true),
			191 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 12)- 48*0), true),
			192 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 12)- 48*0), true),
			193 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 12)- 48*0), true),
			194 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 12)- 48*0), true),
			195 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 12)- 48*0), true),
			196 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 12)- 48*0), true),
			197 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 12)- 48*0), true),
			198 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 12)- 48*0), true),
			199 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 12)- 48*0), true),
			200 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 12)- 48*0), true),
			201 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 12)- 48*0), true),
			202 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 12)- 48*0), true),
			203 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 12)- 48*0), true),
			204 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 12)- 48*0), true),
			205 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 12)- 48*0), true),
			206 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 12)- 48*0), true),
			207 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 12)- 48*0), true),
			208 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 12)- 48*0), true),
			209 => (CLK_dly'last_event, tpd_CLK_P(35), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(34),
         GlitchData	=> P_GlitchData(34),
         OutSignalName	=> "P(34)",
         OutTemp	=> P_zd(34),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((1439 - 13)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((1439 - 13)- 48*0), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((1439 - 13)- 48*0), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((1439 - 13)- 48*0), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((1439 - 13)- 48*0), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((1439 - 13)- 48*0), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((1439 - 13)- 48*0), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((1439 - 13)- 48*0), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((1439 - 13)- 48*0), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((1439 - 13)- 48*0), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((1439 - 13)- 48*0), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((1439 - 13)- 48*0), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((1439 - 13)- 48*0), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((1439 - 13)- 48*0), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((1439 - 13)- 48*0), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((1439 - 13)- 48*0), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((1439 - 13)- 48*0), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((1439 - 13)- 48*0), true),
			18 => (A_ipd(18)'last_event, tpd_A_P((1439 - 13)- 48*0), true),
			19 => (A_ipd(19)'last_event, tpd_A_P((1439 - 13)- 48*0), true),
			20 => (A_ipd(20)'last_event, tpd_A_P((1439 - 13)- 48*0), true),
			21 => (A_ipd(21)'last_event, tpd_A_P((1439 - 13)- 48*0), true),
			22 => (A_ipd(22)'last_event, tpd_A_P((1439 - 13)- 48*0), true),
			23 => (A_ipd(23)'last_event, tpd_A_P((1439 - 13)- 48*0), true),
			24 => (A_ipd(24)'last_event, tpd_A_P((1439 - 13)- 48*0), true),
			25 => (A_ipd(25)'last_event, tpd_A_P((1439 - 13)- 48*0), true),
			26 => (A_ipd(26)'last_event, tpd_A_P((1439 - 13)- 48*0), true),
			27 => (A_ipd(27)'last_event, tpd_A_P((1439 - 13)- 48*0), true),
			28 => (A_ipd(28)'last_event, tpd_A_P((1439 - 13)- 48*0), true),
			29 => (A_ipd(29)'last_event, tpd_A_P((1439 - 13)- 48*0), true),
			30 => (ACIN_ipd(0)'last_event, tpd_ACIN_P((1439 - 13)- 48*0), true),
			31 => (ACIN_ipd(1)'last_event, tpd_ACIN_P((1439 - 13)- 48*0), true),
			32 => (ACIN_ipd(2)'last_event, tpd_ACIN_P((1439 - 13)- 48*0), true),
			33 => (ACIN_ipd(3)'last_event, tpd_ACIN_P((1439 - 13)- 48*0), true),
			34 => (ACIN_ipd(4)'last_event, tpd_ACIN_P((1439 - 13)- 48*0), true),
			35 => (ACIN_ipd(5)'last_event, tpd_ACIN_P((1439 - 13)- 48*0), true),
			36 => (ACIN_ipd(6)'last_event, tpd_ACIN_P((1439 - 13)- 48*0), true),
			37 => (ACIN_ipd(7)'last_event, tpd_ACIN_P((1439 - 13)- 48*0), true),
			38 => (ACIN_ipd(8)'last_event, tpd_ACIN_P((1439 - 13)- 48*0), true),
			39 => (ACIN_ipd(9)'last_event, tpd_ACIN_P((1439 - 13)- 48*0), true),
			40 => (ACIN_ipd(10)'last_event, tpd_ACIN_P((1439 - 13)- 48*0), true),
			41 => (ACIN_ipd(11)'last_event, tpd_ACIN_P((1439 - 13)- 48*0), true),
			42 => (ACIN_ipd(12)'last_event, tpd_ACIN_P((1439 - 13)- 48*0), true),
			43 => (ACIN_ipd(13)'last_event, tpd_ACIN_P((1439 - 13)- 48*0), true),
			44 => (ACIN_ipd(14)'last_event, tpd_ACIN_P((1439 - 13)- 48*0), true),
			45 => (ACIN_ipd(15)'last_event, tpd_ACIN_P((1439 - 13)- 48*0), true),
			46 => (ACIN_ipd(16)'last_event, tpd_ACIN_P((1439 - 13)- 48*0), true),
			47 => (ACIN_ipd(17)'last_event, tpd_ACIN_P((1439 - 13)- 48*0), true),
			48 => (ACIN_ipd(18)'last_event, tpd_ACIN_P((1439 - 13)- 48*0), true),
			49 => (ACIN_ipd(19)'last_event, tpd_ACIN_P((1439 - 13)- 48*0), true),
			50 => (ACIN_ipd(20)'last_event, tpd_ACIN_P((1439 - 13)- 48*0), true),
			51 => (ACIN_ipd(21)'last_event, tpd_ACIN_P((1439 - 13)- 48*0), true),
			52 => (ACIN_ipd(22)'last_event, tpd_ACIN_P((1439 - 13)- 48*0), true),
			53 => (ACIN_ipd(23)'last_event, tpd_ACIN_P((1439 - 13)- 48*0), true),
			54 => (ACIN_ipd(24)'last_event, tpd_ACIN_P((1439 - 13)- 48*0), true),
			55 => (ACIN_ipd(25)'last_event, tpd_ACIN_P((1439 - 13)- 48*0), true),
			56 => (ACIN_ipd(26)'last_event, tpd_ACIN_P((1439 - 13)- 48*0), true),
			57 => (ACIN_ipd(27)'last_event, tpd_ACIN_P((1439 - 13)- 48*0), true),
			58 => (ACIN_ipd(28)'last_event, tpd_ACIN_P((1439 - 13)- 48*0), true),
			59 => (ACIN_ipd(29)'last_event, tpd_ACIN_P((1439 - 13)- 48*0), true),
			60 => (ALUMODE_ipd(0)'last_event, tpd_ALUMODE_P((191 - 13)- 48*0), true),
			61 => (ALUMODE_ipd(1)'last_event, tpd_ALUMODE_P((191 - 13)- 48*0), true),
			62 => (ALUMODE_ipd(2)'last_event, tpd_ALUMODE_P((191 - 13)- 48*0), true),
			63 => (ALUMODE_ipd(3)'last_event, tpd_ALUMODE_P((191 - 13)- 48*0), true),
			64 => (B_ipd(0)'last_event, tpd_B_P((863 - 13)- 48*0), true),
			65 => (B_ipd(1)'last_event, tpd_B_P((863 - 13)- 48*0), true),
			66 => (B_ipd(2)'last_event, tpd_B_P((863 - 13)- 48*0), true),
			67 => (B_ipd(3)'last_event, tpd_B_P((863 - 13)- 48*0), true),
			68 => (B_ipd(4)'last_event, tpd_B_P((863 - 13)- 48*0), true),
			69 => (B_ipd(5)'last_event, tpd_B_P((863 - 13)- 48*0), true),
			70 => (B_ipd(6)'last_event, tpd_B_P((863 - 13)- 48*0), true),
			71 => (B_ipd(7)'last_event, tpd_B_P((863 - 13)- 48*0), true),
			72 => (B_ipd(8)'last_event, tpd_B_P((863 - 13)- 48*0), true),
			73 => (B_ipd(9)'last_event, tpd_B_P((863 - 13)- 48*0), true),
			74 => (B_ipd(10)'last_event, tpd_B_P((863 - 13)- 48*0), true),
			75 => (B_ipd(11)'last_event, tpd_B_P((863 - 13)- 48*0), true),
			76 => (B_ipd(12)'last_event, tpd_B_P((863 - 13)- 48*0), true),
			77 => (B_ipd(13)'last_event, tpd_B_P((863 - 13)- 48*0), true),
			78 => (B_ipd(14)'last_event, tpd_B_P((863 - 13)- 48*0), true),
			79 => (B_ipd(15)'last_event, tpd_B_P((863 - 13)- 48*0), true),
			80 => (B_ipd(16)'last_event, tpd_B_P((863 - 13)- 48*0), true),
			81 => (B_ipd(17)'last_event, tpd_B_P((863 - 13)- 48*0), true),
			82 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 13)- 48*0), true),
			83 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 13)- 48*0), true),
			84 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 13)- 48*0), true),
			85 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 13)- 48*0), true),
			86 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 13)- 48*0), true),
			87 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 13)- 48*0), true),
			88 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 13)- 48*0), true),
			89 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 13)- 48*0), true),
			90 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 13)- 48*0), true),
			91 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 13)- 48*0), true),
			92 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 13)- 48*0), true),
			93 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 13)- 48*0), true),
			94 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 13)- 48*0), true),
			95 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 13)- 48*0), true),
			96 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 13)- 48*0), true),
			97 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 13)- 48*0), true),
			98 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 13)- 48*0), true),
			99 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 13)- 48*0), true),
			100 => (C_ipd(0)'last_event, tpd_C_P((2303 - 13)- 48*0), true),
			101 => (C_ipd(1)'last_event, tpd_C_P((2303 - 13)- 48*0), true),
			102 => (C_ipd(2)'last_event, tpd_C_P((2303 - 13)- 48*0), true),
			103 => (C_ipd(3)'last_event, tpd_C_P((2303 - 13)- 48*0), true),
			104 => (C_ipd(4)'last_event, tpd_C_P((2303 - 13)- 48*0), true),
			105 => (C_ipd(5)'last_event, tpd_C_P((2303 - 13)- 48*0), true),
			106 => (C_ipd(6)'last_event, tpd_C_P((2303 - 13)- 48*0), true),
			107 => (C_ipd(7)'last_event, tpd_C_P((2303 - 13)- 48*0), true),
			108 => (C_ipd(8)'last_event, tpd_C_P((2303 - 13)- 48*0), true),
			109 => (C_ipd(9)'last_event, tpd_C_P((2303 - 13)- 48*0), true),
			110 => (C_ipd(10)'last_event, tpd_C_P((2303 - 13)- 48*0), true),
			111 => (C_ipd(11)'last_event, tpd_C_P((2303 - 13)- 48*0), true),
			112 => (C_ipd(12)'last_event, tpd_C_P((2303 - 13)- 48*0), true),
			113 => (C_ipd(13)'last_event, tpd_C_P((2303 - 13)- 48*0), true),
			114 => (C_ipd(14)'last_event, tpd_C_P((2303 - 13)- 48*0), true),
			115 => (C_ipd(15)'last_event, tpd_C_P((2303 - 13)- 48*0), true),
			116 => (C_ipd(16)'last_event, tpd_C_P((2303 - 13)- 48*0), true),
			117 => (C_ipd(17)'last_event, tpd_C_P((2303 - 13)- 48*0), true),
			118 => (C_ipd(18)'last_event, tpd_C_P((2303 - 13)- 48*0), true),
			119 => (C_ipd(19)'last_event, tpd_C_P((2303 - 13)- 48*0), true),
			120 => (C_ipd(20)'last_event, tpd_C_P((2303 - 13)- 48*0), true),
			121 => (C_ipd(21)'last_event, tpd_C_P((2303 - 13)- 48*0), true),
			122 => (C_ipd(22)'last_event, tpd_C_P((2303 - 13)- 48*0), true),
			123 => (C_ipd(23)'last_event, tpd_C_P((2303 - 13)- 48*0), true),
			124 => (C_ipd(24)'last_event, tpd_C_P((2303 - 13)- 48*0), true),
			125 => (C_ipd(25)'last_event, tpd_C_P((2303 - 13)- 48*0), true),
			126 => (C_ipd(26)'last_event, tpd_C_P((2303 - 13)- 48*0), true),
			127 => (C_ipd(27)'last_event, tpd_C_P((2303 - 13)- 48*0), true),
			128 => (C_ipd(28)'last_event, tpd_C_P((2303 - 13)- 48*0), true),
			129 => (C_ipd(29)'last_event, tpd_C_P((2303 - 13)- 48*0), true),
			130 => (C_ipd(30)'last_event, tpd_C_P((2303 - 13)- 48*0), true),
			131 => (C_ipd(31)'last_event, tpd_C_P((2303 - 13)- 48*0), true),
			132 => (C_ipd(32)'last_event, tpd_C_P((2303 - 13)- 48*0), true),
			133 => (C_ipd(33)'last_event, tpd_C_P((2303 - 13)- 48*0), true),
			134 => (C_ipd(34)'last_event, tpd_C_P((2303 - 13)- 48*0), true),
			135 => (C_ipd(35)'last_event, tpd_C_P((2303 - 13)- 48*0), true),
			136 => (C_ipd(36)'last_event, tpd_C_P((2303 - 13)- 48*0), true),
			137 => (C_ipd(37)'last_event, tpd_C_P((2303 - 13)- 48*0), true),
			138 => (C_ipd(38)'last_event, tpd_C_P((2303 - 13)- 48*0), true),
			139 => (C_ipd(39)'last_event, tpd_C_P((2303 - 13)- 48*0), true),
			140 => (C_ipd(40)'last_event, tpd_C_P((2303 - 13)- 48*0), true),
			141 => (C_ipd(41)'last_event, tpd_C_P((2303 - 13)- 48*0), true),
			142 => (C_ipd(42)'last_event, tpd_C_P((2303 - 13)- 48*0), true),
			143 => (C_ipd(43)'last_event, tpd_C_P((2303 - 13)- 48*0), true),
			144 => (C_ipd(44)'last_event, tpd_C_P((2303 - 13)- 48*0), true),
			145 => (C_ipd(45)'last_event, tpd_C_P((2303 - 13)- 48*0), true),
			146 => (C_ipd(46)'last_event, tpd_C_P((2303 - 13)- 48*0), true),
			147 => (C_ipd(47)'last_event, tpd_C_P((2303 - 13)- 48*0), true),
			148 => (CARRYCASCIN_ipd'last_event, tpd_CARRYCASCIN_P(34), true),
			149 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(34), true),
			150 => (CARRYINSEL_ipd(0)'last_event, tpd_CARRYINSEL_P((143 - 13)- 48*0), true),
			151 => (CARRYINSEL_ipd(1)'last_event, tpd_CARRYINSEL_P((143 - 13)- 48*0), true),
			152 => (CARRYINSEL_ipd(2)'last_event, tpd_CARRYINSEL_P((143 - 13)- 48*0), true),
			153 => (MULTSIGNIN_ipd'last_event, tpd_MULTSIGNIN_P(34), true),
			154 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 13)- 48*0), true),
			155 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 13)- 48*0), true),
			156 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 13)- 48*0), true),
			157 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 13)- 48*0), true),
			158 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 13)- 48*0), true),
			159 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 13)- 48*0), true),
			160 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 13)- 48*0), true),
			161 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 13)- 48*0), true),
			162 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 13)- 48*0), true),
			163 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 13)- 48*0), true),
			164 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 13)- 48*0), true),
			165 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 13)- 48*0), true),
			166 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 13)- 48*0), true),
			167 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 13)- 48*0), true),
			168 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 13)- 48*0), true),
			169 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 13)- 48*0), true),
			170 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 13)- 48*0), true),
			171 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 13)- 48*0), true),
			172 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 13)- 48*0), true),
			173 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 13)- 48*0), true),
			174 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 13)- 48*0), true),
			175 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 13)- 48*0), true),
			176 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 13)- 48*0), true),
			177 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 13)- 48*0), true),
			178 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 13)- 48*0), true),
			179 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 13)- 48*0), true),
			180 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 13)- 48*0), true),
			181 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 13)- 48*0), true),
			182 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 13)- 48*0), true),
			183 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 13)- 48*0), true),
			184 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 13)- 48*0), true),
			185 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 13)- 48*0), true),
			186 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 13)- 48*0), true),
			187 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 13)- 48*0), true),
			188 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 13)- 48*0), true),
			189 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 13)- 48*0), true),
			190 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 13)- 48*0), true),
			191 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 13)- 48*0), true),
			192 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 13)- 48*0), true),
			193 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 13)- 48*0), true),
			194 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 13)- 48*0), true),
			195 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 13)- 48*0), true),
			196 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 13)- 48*0), true),
			197 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 13)- 48*0), true),
			198 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 13)- 48*0), true),
			199 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 13)- 48*0), true),
			200 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 13)- 48*0), true),
			201 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 13)- 48*0), true),
			202 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 13)- 48*0), true),
			203 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 13)- 48*0), true),
			204 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 13)- 48*0), true),
			205 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 13)- 48*0), true),
			206 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 13)- 48*0), true),
			207 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 13)- 48*0), true),
			208 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 13)- 48*0), true),
			209 => (CLK_dly'last_event, tpd_CLK_P(34), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(33),
         GlitchData	=> P_GlitchData(33),
         OutSignalName	=> "P(33)",
         OutTemp	=> P_zd(33),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((1439 - 14)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((1439 - 14)- 48*0), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((1439 - 14)- 48*0), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((1439 - 14)- 48*0), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((1439 - 14)- 48*0), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((1439 - 14)- 48*0), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((1439 - 14)- 48*0), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((1439 - 14)- 48*0), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((1439 - 14)- 48*0), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((1439 - 14)- 48*0), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((1439 - 14)- 48*0), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((1439 - 14)- 48*0), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((1439 - 14)- 48*0), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((1439 - 14)- 48*0), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((1439 - 14)- 48*0), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((1439 - 14)- 48*0), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((1439 - 14)- 48*0), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((1439 - 14)- 48*0), true),
			18 => (A_ipd(18)'last_event, tpd_A_P((1439 - 14)- 48*0), true),
			19 => (A_ipd(19)'last_event, tpd_A_P((1439 - 14)- 48*0), true),
			20 => (A_ipd(20)'last_event, tpd_A_P((1439 - 14)- 48*0), true),
			21 => (A_ipd(21)'last_event, tpd_A_P((1439 - 14)- 48*0), true),
			22 => (A_ipd(22)'last_event, tpd_A_P((1439 - 14)- 48*0), true),
			23 => (A_ipd(23)'last_event, tpd_A_P((1439 - 14)- 48*0), true),
			24 => (A_ipd(24)'last_event, tpd_A_P((1439 - 14)- 48*0), true),
			25 => (A_ipd(25)'last_event, tpd_A_P((1439 - 14)- 48*0), true),
			26 => (A_ipd(26)'last_event, tpd_A_P((1439 - 14)- 48*0), true),
			27 => (A_ipd(27)'last_event, tpd_A_P((1439 - 14)- 48*0), true),
			28 => (A_ipd(28)'last_event, tpd_A_P((1439 - 14)- 48*0), true),
			29 => (A_ipd(29)'last_event, tpd_A_P((1439 - 14)- 48*0), true),
			30 => (ACIN_ipd(0)'last_event, tpd_ACIN_P((1439 - 14)- 48*0), true),
			31 => (ACIN_ipd(1)'last_event, tpd_ACIN_P((1439 - 14)- 48*0), true),
			32 => (ACIN_ipd(2)'last_event, tpd_ACIN_P((1439 - 14)- 48*0), true),
			33 => (ACIN_ipd(3)'last_event, tpd_ACIN_P((1439 - 14)- 48*0), true),
			34 => (ACIN_ipd(4)'last_event, tpd_ACIN_P((1439 - 14)- 48*0), true),
			35 => (ACIN_ipd(5)'last_event, tpd_ACIN_P((1439 - 14)- 48*0), true),
			36 => (ACIN_ipd(6)'last_event, tpd_ACIN_P((1439 - 14)- 48*0), true),
			37 => (ACIN_ipd(7)'last_event, tpd_ACIN_P((1439 - 14)- 48*0), true),
			38 => (ACIN_ipd(8)'last_event, tpd_ACIN_P((1439 - 14)- 48*0), true),
			39 => (ACIN_ipd(9)'last_event, tpd_ACIN_P((1439 - 14)- 48*0), true),
			40 => (ACIN_ipd(10)'last_event, tpd_ACIN_P((1439 - 14)- 48*0), true),
			41 => (ACIN_ipd(11)'last_event, tpd_ACIN_P((1439 - 14)- 48*0), true),
			42 => (ACIN_ipd(12)'last_event, tpd_ACIN_P((1439 - 14)- 48*0), true),
			43 => (ACIN_ipd(13)'last_event, tpd_ACIN_P((1439 - 14)- 48*0), true),
			44 => (ACIN_ipd(14)'last_event, tpd_ACIN_P((1439 - 14)- 48*0), true),
			45 => (ACIN_ipd(15)'last_event, tpd_ACIN_P((1439 - 14)- 48*0), true),
			46 => (ACIN_ipd(16)'last_event, tpd_ACIN_P((1439 - 14)- 48*0), true),
			47 => (ACIN_ipd(17)'last_event, tpd_ACIN_P((1439 - 14)- 48*0), true),
			48 => (ACIN_ipd(18)'last_event, tpd_ACIN_P((1439 - 14)- 48*0), true),
			49 => (ACIN_ipd(19)'last_event, tpd_ACIN_P((1439 - 14)- 48*0), true),
			50 => (ACIN_ipd(20)'last_event, tpd_ACIN_P((1439 - 14)- 48*0), true),
			51 => (ACIN_ipd(21)'last_event, tpd_ACIN_P((1439 - 14)- 48*0), true),
			52 => (ACIN_ipd(22)'last_event, tpd_ACIN_P((1439 - 14)- 48*0), true),
			53 => (ACIN_ipd(23)'last_event, tpd_ACIN_P((1439 - 14)- 48*0), true),
			54 => (ACIN_ipd(24)'last_event, tpd_ACIN_P((1439 - 14)- 48*0), true),
			55 => (ACIN_ipd(25)'last_event, tpd_ACIN_P((1439 - 14)- 48*0), true),
			56 => (ACIN_ipd(26)'last_event, tpd_ACIN_P((1439 - 14)- 48*0), true),
			57 => (ACIN_ipd(27)'last_event, tpd_ACIN_P((1439 - 14)- 48*0), true),
			58 => (ACIN_ipd(28)'last_event, tpd_ACIN_P((1439 - 14)- 48*0), true),
			59 => (ACIN_ipd(29)'last_event, tpd_ACIN_P((1439 - 14)- 48*0), true),
			60 => (ALUMODE_ipd(0)'last_event, tpd_ALUMODE_P((191 - 14)- 48*0), true),
			61 => (ALUMODE_ipd(1)'last_event, tpd_ALUMODE_P((191 - 14)- 48*0), true),
			62 => (ALUMODE_ipd(2)'last_event, tpd_ALUMODE_P((191 - 14)- 48*0), true),
			63 => (ALUMODE_ipd(3)'last_event, tpd_ALUMODE_P((191 - 14)- 48*0), true),
			64 => (B_ipd(0)'last_event, tpd_B_P((863 - 14)- 48*0), true),
			65 => (B_ipd(1)'last_event, tpd_B_P((863 - 14)- 48*0), true),
			66 => (B_ipd(2)'last_event, tpd_B_P((863 - 14)- 48*0), true),
			67 => (B_ipd(3)'last_event, tpd_B_P((863 - 14)- 48*0), true),
			68 => (B_ipd(4)'last_event, tpd_B_P((863 - 14)- 48*0), true),
			69 => (B_ipd(5)'last_event, tpd_B_P((863 - 14)- 48*0), true),
			70 => (B_ipd(6)'last_event, tpd_B_P((863 - 14)- 48*0), true),
			71 => (B_ipd(7)'last_event, tpd_B_P((863 - 14)- 48*0), true),
			72 => (B_ipd(8)'last_event, tpd_B_P((863 - 14)- 48*0), true),
			73 => (B_ipd(9)'last_event, tpd_B_P((863 - 14)- 48*0), true),
			74 => (B_ipd(10)'last_event, tpd_B_P((863 - 14)- 48*0), true),
			75 => (B_ipd(11)'last_event, tpd_B_P((863 - 14)- 48*0), true),
			76 => (B_ipd(12)'last_event, tpd_B_P((863 - 14)- 48*0), true),
			77 => (B_ipd(13)'last_event, tpd_B_P((863 - 14)- 48*0), true),
			78 => (B_ipd(14)'last_event, tpd_B_P((863 - 14)- 48*0), true),
			79 => (B_ipd(15)'last_event, tpd_B_P((863 - 14)- 48*0), true),
			80 => (B_ipd(16)'last_event, tpd_B_P((863 - 14)- 48*0), true),
			81 => (B_ipd(17)'last_event, tpd_B_P((863 - 14)- 48*0), true),
			82 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 14)- 48*0), true),
			83 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 14)- 48*0), true),
			84 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 14)- 48*0), true),
			85 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 14)- 48*0), true),
			86 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 14)- 48*0), true),
			87 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 14)- 48*0), true),
			88 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 14)- 48*0), true),
			89 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 14)- 48*0), true),
			90 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 14)- 48*0), true),
			91 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 14)- 48*0), true),
			92 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 14)- 48*0), true),
			93 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 14)- 48*0), true),
			94 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 14)- 48*0), true),
			95 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 14)- 48*0), true),
			96 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 14)- 48*0), true),
			97 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 14)- 48*0), true),
			98 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 14)- 48*0), true),
			99 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 14)- 48*0), true),
			100 => (C_ipd(0)'last_event, tpd_C_P((2303 - 14)- 48*0), true),
			101 => (C_ipd(1)'last_event, tpd_C_P((2303 - 14)- 48*0), true),
			102 => (C_ipd(2)'last_event, tpd_C_P((2303 - 14)- 48*0), true),
			103 => (C_ipd(3)'last_event, tpd_C_P((2303 - 14)- 48*0), true),
			104 => (C_ipd(4)'last_event, tpd_C_P((2303 - 14)- 48*0), true),
			105 => (C_ipd(5)'last_event, tpd_C_P((2303 - 14)- 48*0), true),
			106 => (C_ipd(6)'last_event, tpd_C_P((2303 - 14)- 48*0), true),
			107 => (C_ipd(7)'last_event, tpd_C_P((2303 - 14)- 48*0), true),
			108 => (C_ipd(8)'last_event, tpd_C_P((2303 - 14)- 48*0), true),
			109 => (C_ipd(9)'last_event, tpd_C_P((2303 - 14)- 48*0), true),
			110 => (C_ipd(10)'last_event, tpd_C_P((2303 - 14)- 48*0), true),
			111 => (C_ipd(11)'last_event, tpd_C_P((2303 - 14)- 48*0), true),
			112 => (C_ipd(12)'last_event, tpd_C_P((2303 - 14)- 48*0), true),
			113 => (C_ipd(13)'last_event, tpd_C_P((2303 - 14)- 48*0), true),
			114 => (C_ipd(14)'last_event, tpd_C_P((2303 - 14)- 48*0), true),
			115 => (C_ipd(15)'last_event, tpd_C_P((2303 - 14)- 48*0), true),
			116 => (C_ipd(16)'last_event, tpd_C_P((2303 - 14)- 48*0), true),
			117 => (C_ipd(17)'last_event, tpd_C_P((2303 - 14)- 48*0), true),
			118 => (C_ipd(18)'last_event, tpd_C_P((2303 - 14)- 48*0), true),
			119 => (C_ipd(19)'last_event, tpd_C_P((2303 - 14)- 48*0), true),
			120 => (C_ipd(20)'last_event, tpd_C_P((2303 - 14)- 48*0), true),
			121 => (C_ipd(21)'last_event, tpd_C_P((2303 - 14)- 48*0), true),
			122 => (C_ipd(22)'last_event, tpd_C_P((2303 - 14)- 48*0), true),
			123 => (C_ipd(23)'last_event, tpd_C_P((2303 - 14)- 48*0), true),
			124 => (C_ipd(24)'last_event, tpd_C_P((2303 - 14)- 48*0), true),
			125 => (C_ipd(25)'last_event, tpd_C_P((2303 - 14)- 48*0), true),
			126 => (C_ipd(26)'last_event, tpd_C_P((2303 - 14)- 48*0), true),
			127 => (C_ipd(27)'last_event, tpd_C_P((2303 - 14)- 48*0), true),
			128 => (C_ipd(28)'last_event, tpd_C_P((2303 - 14)- 48*0), true),
			129 => (C_ipd(29)'last_event, tpd_C_P((2303 - 14)- 48*0), true),
			130 => (C_ipd(30)'last_event, tpd_C_P((2303 - 14)- 48*0), true),
			131 => (C_ipd(31)'last_event, tpd_C_P((2303 - 14)- 48*0), true),
			132 => (C_ipd(32)'last_event, tpd_C_P((2303 - 14)- 48*0), true),
			133 => (C_ipd(33)'last_event, tpd_C_P((2303 - 14)- 48*0), true),
			134 => (C_ipd(34)'last_event, tpd_C_P((2303 - 14)- 48*0), true),
			135 => (C_ipd(35)'last_event, tpd_C_P((2303 - 14)- 48*0), true),
			136 => (C_ipd(36)'last_event, tpd_C_P((2303 - 14)- 48*0), true),
			137 => (C_ipd(37)'last_event, tpd_C_P((2303 - 14)- 48*0), true),
			138 => (C_ipd(38)'last_event, tpd_C_P((2303 - 14)- 48*0), true),
			139 => (C_ipd(39)'last_event, tpd_C_P((2303 - 14)- 48*0), true),
			140 => (C_ipd(40)'last_event, tpd_C_P((2303 - 14)- 48*0), true),
			141 => (C_ipd(41)'last_event, tpd_C_P((2303 - 14)- 48*0), true),
			142 => (C_ipd(42)'last_event, tpd_C_P((2303 - 14)- 48*0), true),
			143 => (C_ipd(43)'last_event, tpd_C_P((2303 - 14)- 48*0), true),
			144 => (C_ipd(44)'last_event, tpd_C_P((2303 - 14)- 48*0), true),
			145 => (C_ipd(45)'last_event, tpd_C_P((2303 - 14)- 48*0), true),
			146 => (C_ipd(46)'last_event, tpd_C_P((2303 - 14)- 48*0), true),
			147 => (C_ipd(47)'last_event, tpd_C_P((2303 - 14)- 48*0), true),
			148 => (CARRYCASCIN_ipd'last_event, tpd_CARRYCASCIN_P(33), true),
			149 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(33), true),
			150 => (CARRYINSEL_ipd(0)'last_event, tpd_CARRYINSEL_P((143 - 14)- 48*0), true),
			151 => (CARRYINSEL_ipd(1)'last_event, tpd_CARRYINSEL_P((143 - 14)- 48*0), true),
			152 => (CARRYINSEL_ipd(2)'last_event, tpd_CARRYINSEL_P((143 - 14)- 48*0), true),
			153 => (MULTSIGNIN_ipd'last_event, tpd_MULTSIGNIN_P(33), true),
			154 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 14)- 48*0), true),
			155 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 14)- 48*0), true),
			156 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 14)- 48*0), true),
			157 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 14)- 48*0), true),
			158 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 14)- 48*0), true),
			159 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 14)- 48*0), true),
			160 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 14)- 48*0), true),
			161 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 14)- 48*0), true),
			162 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 14)- 48*0), true),
			163 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 14)- 48*0), true),
			164 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 14)- 48*0), true),
			165 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 14)- 48*0), true),
			166 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 14)- 48*0), true),
			167 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 14)- 48*0), true),
			168 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 14)- 48*0), true),
			169 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 14)- 48*0), true),
			170 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 14)- 48*0), true),
			171 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 14)- 48*0), true),
			172 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 14)- 48*0), true),
			173 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 14)- 48*0), true),
			174 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 14)- 48*0), true),
			175 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 14)- 48*0), true),
			176 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 14)- 48*0), true),
			177 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 14)- 48*0), true),
			178 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 14)- 48*0), true),
			179 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 14)- 48*0), true),
			180 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 14)- 48*0), true),
			181 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 14)- 48*0), true),
			182 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 14)- 48*0), true),
			183 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 14)- 48*0), true),
			184 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 14)- 48*0), true),
			185 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 14)- 48*0), true),
			186 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 14)- 48*0), true),
			187 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 14)- 48*0), true),
			188 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 14)- 48*0), true),
			189 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 14)- 48*0), true),
			190 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 14)- 48*0), true),
			191 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 14)- 48*0), true),
			192 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 14)- 48*0), true),
			193 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 14)- 48*0), true),
			194 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 14)- 48*0), true),
			195 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 14)- 48*0), true),
			196 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 14)- 48*0), true),
			197 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 14)- 48*0), true),
			198 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 14)- 48*0), true),
			199 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 14)- 48*0), true),
			200 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 14)- 48*0), true),
			201 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 14)- 48*0), true),
			202 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 14)- 48*0), true),
			203 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 14)- 48*0), true),
			204 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 14)- 48*0), true),
			205 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 14)- 48*0), true),
			206 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 14)- 48*0), true),
			207 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 14)- 48*0), true),
			208 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 14)- 48*0), true),
			209 => (CLK_dly'last_event, tpd_CLK_P(33), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(32),
         GlitchData	=> P_GlitchData(32),
         OutSignalName	=> "P(32)",
         OutTemp	=> P_zd(32),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((1439 - 15)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((1439 - 15)- 48*0), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((1439 - 15)- 48*0), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((1439 - 15)- 48*0), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((1439 - 15)- 48*0), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((1439 - 15)- 48*0), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((1439 - 15)- 48*0), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((1439 - 15)- 48*0), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((1439 - 15)- 48*0), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((1439 - 15)- 48*0), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((1439 - 15)- 48*0), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((1439 - 15)- 48*0), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((1439 - 15)- 48*0), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((1439 - 15)- 48*0), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((1439 - 15)- 48*0), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((1439 - 15)- 48*0), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((1439 - 15)- 48*0), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((1439 - 15)- 48*0), true),
			18 => (A_ipd(18)'last_event, tpd_A_P((1439 - 15)- 48*0), true),
			19 => (A_ipd(19)'last_event, tpd_A_P((1439 - 15)- 48*0), true),
			20 => (A_ipd(20)'last_event, tpd_A_P((1439 - 15)- 48*0), true),
			21 => (A_ipd(21)'last_event, tpd_A_P((1439 - 15)- 48*0), true),
			22 => (A_ipd(22)'last_event, tpd_A_P((1439 - 15)- 48*0), true),
			23 => (A_ipd(23)'last_event, tpd_A_P((1439 - 15)- 48*0), true),
			24 => (A_ipd(24)'last_event, tpd_A_P((1439 - 15)- 48*0), true),
			25 => (A_ipd(25)'last_event, tpd_A_P((1439 - 15)- 48*0), true),
			26 => (A_ipd(26)'last_event, tpd_A_P((1439 - 15)- 48*0), true),
			27 => (A_ipd(27)'last_event, tpd_A_P((1439 - 15)- 48*0), true),
			28 => (A_ipd(28)'last_event, tpd_A_P((1439 - 15)- 48*0), true),
			29 => (A_ipd(29)'last_event, tpd_A_P((1439 - 15)- 48*0), true),
			30 => (ACIN_ipd(0)'last_event, tpd_ACIN_P((1439 - 15)- 48*0), true),
			31 => (ACIN_ipd(1)'last_event, tpd_ACIN_P((1439 - 15)- 48*0), true),
			32 => (ACIN_ipd(2)'last_event, tpd_ACIN_P((1439 - 15)- 48*0), true),
			33 => (ACIN_ipd(3)'last_event, tpd_ACIN_P((1439 - 15)- 48*0), true),
			34 => (ACIN_ipd(4)'last_event, tpd_ACIN_P((1439 - 15)- 48*0), true),
			35 => (ACIN_ipd(5)'last_event, tpd_ACIN_P((1439 - 15)- 48*0), true),
			36 => (ACIN_ipd(6)'last_event, tpd_ACIN_P((1439 - 15)- 48*0), true),
			37 => (ACIN_ipd(7)'last_event, tpd_ACIN_P((1439 - 15)- 48*0), true),
			38 => (ACIN_ipd(8)'last_event, tpd_ACIN_P((1439 - 15)- 48*0), true),
			39 => (ACIN_ipd(9)'last_event, tpd_ACIN_P((1439 - 15)- 48*0), true),
			40 => (ACIN_ipd(10)'last_event, tpd_ACIN_P((1439 - 15)- 48*0), true),
			41 => (ACIN_ipd(11)'last_event, tpd_ACIN_P((1439 - 15)- 48*0), true),
			42 => (ACIN_ipd(12)'last_event, tpd_ACIN_P((1439 - 15)- 48*0), true),
			43 => (ACIN_ipd(13)'last_event, tpd_ACIN_P((1439 - 15)- 48*0), true),
			44 => (ACIN_ipd(14)'last_event, tpd_ACIN_P((1439 - 15)- 48*0), true),
			45 => (ACIN_ipd(15)'last_event, tpd_ACIN_P((1439 - 15)- 48*0), true),
			46 => (ACIN_ipd(16)'last_event, tpd_ACIN_P((1439 - 15)- 48*0), true),
			47 => (ACIN_ipd(17)'last_event, tpd_ACIN_P((1439 - 15)- 48*0), true),
			48 => (ACIN_ipd(18)'last_event, tpd_ACIN_P((1439 - 15)- 48*0), true),
			49 => (ACIN_ipd(19)'last_event, tpd_ACIN_P((1439 - 15)- 48*0), true),
			50 => (ACIN_ipd(20)'last_event, tpd_ACIN_P((1439 - 15)- 48*0), true),
			51 => (ACIN_ipd(21)'last_event, tpd_ACIN_P((1439 - 15)- 48*0), true),
			52 => (ACIN_ipd(22)'last_event, tpd_ACIN_P((1439 - 15)- 48*0), true),
			53 => (ACIN_ipd(23)'last_event, tpd_ACIN_P((1439 - 15)- 48*0), true),
			54 => (ACIN_ipd(24)'last_event, tpd_ACIN_P((1439 - 15)- 48*0), true),
			55 => (ACIN_ipd(25)'last_event, tpd_ACIN_P((1439 - 15)- 48*0), true),
			56 => (ACIN_ipd(26)'last_event, tpd_ACIN_P((1439 - 15)- 48*0), true),
			57 => (ACIN_ipd(27)'last_event, tpd_ACIN_P((1439 - 15)- 48*0), true),
			58 => (ACIN_ipd(28)'last_event, tpd_ACIN_P((1439 - 15)- 48*0), true),
			59 => (ACIN_ipd(29)'last_event, tpd_ACIN_P((1439 - 15)- 48*0), true),
			60 => (ALUMODE_ipd(0)'last_event, tpd_ALUMODE_P((191 - 15)- 48*0), true),
			61 => (ALUMODE_ipd(1)'last_event, tpd_ALUMODE_P((191 - 15)- 48*0), true),
			62 => (ALUMODE_ipd(2)'last_event, tpd_ALUMODE_P((191 - 15)- 48*0), true),
			63 => (ALUMODE_ipd(3)'last_event, tpd_ALUMODE_P((191 - 15)- 48*0), true),
			64 => (B_ipd(0)'last_event, tpd_B_P((863 - 15)- 48*0), true),
			65 => (B_ipd(1)'last_event, tpd_B_P((863 - 15)- 48*0), true),
			66 => (B_ipd(2)'last_event, tpd_B_P((863 - 15)- 48*0), true),
			67 => (B_ipd(3)'last_event, tpd_B_P((863 - 15)- 48*0), true),
			68 => (B_ipd(4)'last_event, tpd_B_P((863 - 15)- 48*0), true),
			69 => (B_ipd(5)'last_event, tpd_B_P((863 - 15)- 48*0), true),
			70 => (B_ipd(6)'last_event, tpd_B_P((863 - 15)- 48*0), true),
			71 => (B_ipd(7)'last_event, tpd_B_P((863 - 15)- 48*0), true),
			72 => (B_ipd(8)'last_event, tpd_B_P((863 - 15)- 48*0), true),
			73 => (B_ipd(9)'last_event, tpd_B_P((863 - 15)- 48*0), true),
			74 => (B_ipd(10)'last_event, tpd_B_P((863 - 15)- 48*0), true),
			75 => (B_ipd(11)'last_event, tpd_B_P((863 - 15)- 48*0), true),
			76 => (B_ipd(12)'last_event, tpd_B_P((863 - 15)- 48*0), true),
			77 => (B_ipd(13)'last_event, tpd_B_P((863 - 15)- 48*0), true),
			78 => (B_ipd(14)'last_event, tpd_B_P((863 - 15)- 48*0), true),
			79 => (B_ipd(15)'last_event, tpd_B_P((863 - 15)- 48*0), true),
			80 => (B_ipd(16)'last_event, tpd_B_P((863 - 15)- 48*0), true),
			81 => (B_ipd(17)'last_event, tpd_B_P((863 - 15)- 48*0), true),
			82 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 15)- 48*0), true),
			83 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 15)- 48*0), true),
			84 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 15)- 48*0), true),
			85 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 15)- 48*0), true),
			86 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 15)- 48*0), true),
			87 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 15)- 48*0), true),
			88 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 15)- 48*0), true),
			89 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 15)- 48*0), true),
			90 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 15)- 48*0), true),
			91 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 15)- 48*0), true),
			92 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 15)- 48*0), true),
			93 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 15)- 48*0), true),
			94 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 15)- 48*0), true),
			95 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 15)- 48*0), true),
			96 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 15)- 48*0), true),
			97 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 15)- 48*0), true),
			98 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 15)- 48*0), true),
			99 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 15)- 48*0), true),
			100 => (C_ipd(0)'last_event, tpd_C_P((2303 - 15)- 48*0), true),
			101 => (C_ipd(1)'last_event, tpd_C_P((2303 - 15)- 48*0), true),
			102 => (C_ipd(2)'last_event, tpd_C_P((2303 - 15)- 48*0), true),
			103 => (C_ipd(3)'last_event, tpd_C_P((2303 - 15)- 48*0), true),
			104 => (C_ipd(4)'last_event, tpd_C_P((2303 - 15)- 48*0), true),
			105 => (C_ipd(5)'last_event, tpd_C_P((2303 - 15)- 48*0), true),
			106 => (C_ipd(6)'last_event, tpd_C_P((2303 - 15)- 48*0), true),
			107 => (C_ipd(7)'last_event, tpd_C_P((2303 - 15)- 48*0), true),
			108 => (C_ipd(8)'last_event, tpd_C_P((2303 - 15)- 48*0), true),
			109 => (C_ipd(9)'last_event, tpd_C_P((2303 - 15)- 48*0), true),
			110 => (C_ipd(10)'last_event, tpd_C_P((2303 - 15)- 48*0), true),
			111 => (C_ipd(11)'last_event, tpd_C_P((2303 - 15)- 48*0), true),
			112 => (C_ipd(12)'last_event, tpd_C_P((2303 - 15)- 48*0), true),
			113 => (C_ipd(13)'last_event, tpd_C_P((2303 - 15)- 48*0), true),
			114 => (C_ipd(14)'last_event, tpd_C_P((2303 - 15)- 48*0), true),
			115 => (C_ipd(15)'last_event, tpd_C_P((2303 - 15)- 48*0), true),
			116 => (C_ipd(16)'last_event, tpd_C_P((2303 - 15)- 48*0), true),
			117 => (C_ipd(17)'last_event, tpd_C_P((2303 - 15)- 48*0), true),
			118 => (C_ipd(18)'last_event, tpd_C_P((2303 - 15)- 48*0), true),
			119 => (C_ipd(19)'last_event, tpd_C_P((2303 - 15)- 48*0), true),
			120 => (C_ipd(20)'last_event, tpd_C_P((2303 - 15)- 48*0), true),
			121 => (C_ipd(21)'last_event, tpd_C_P((2303 - 15)- 48*0), true),
			122 => (C_ipd(22)'last_event, tpd_C_P((2303 - 15)- 48*0), true),
			123 => (C_ipd(23)'last_event, tpd_C_P((2303 - 15)- 48*0), true),
			124 => (C_ipd(24)'last_event, tpd_C_P((2303 - 15)- 48*0), true),
			125 => (C_ipd(25)'last_event, tpd_C_P((2303 - 15)- 48*0), true),
			126 => (C_ipd(26)'last_event, tpd_C_P((2303 - 15)- 48*0), true),
			127 => (C_ipd(27)'last_event, tpd_C_P((2303 - 15)- 48*0), true),
			128 => (C_ipd(28)'last_event, tpd_C_P((2303 - 15)- 48*0), true),
			129 => (C_ipd(29)'last_event, tpd_C_P((2303 - 15)- 48*0), true),
			130 => (C_ipd(30)'last_event, tpd_C_P((2303 - 15)- 48*0), true),
			131 => (C_ipd(31)'last_event, tpd_C_P((2303 - 15)- 48*0), true),
			132 => (C_ipd(32)'last_event, tpd_C_P((2303 - 15)- 48*0), true),
			133 => (C_ipd(33)'last_event, tpd_C_P((2303 - 15)- 48*0), true),
			134 => (C_ipd(34)'last_event, tpd_C_P((2303 - 15)- 48*0), true),
			135 => (C_ipd(35)'last_event, tpd_C_P((2303 - 15)- 48*0), true),
			136 => (C_ipd(36)'last_event, tpd_C_P((2303 - 15)- 48*0), true),
			137 => (C_ipd(37)'last_event, tpd_C_P((2303 - 15)- 48*0), true),
			138 => (C_ipd(38)'last_event, tpd_C_P((2303 - 15)- 48*0), true),
			139 => (C_ipd(39)'last_event, tpd_C_P((2303 - 15)- 48*0), true),
			140 => (C_ipd(40)'last_event, tpd_C_P((2303 - 15)- 48*0), true),
			141 => (C_ipd(41)'last_event, tpd_C_P((2303 - 15)- 48*0), true),
			142 => (C_ipd(42)'last_event, tpd_C_P((2303 - 15)- 48*0), true),
			143 => (C_ipd(43)'last_event, tpd_C_P((2303 - 15)- 48*0), true),
			144 => (C_ipd(44)'last_event, tpd_C_P((2303 - 15)- 48*0), true),
			145 => (C_ipd(45)'last_event, tpd_C_P((2303 - 15)- 48*0), true),
			146 => (C_ipd(46)'last_event, tpd_C_P((2303 - 15)- 48*0), true),
			147 => (C_ipd(47)'last_event, tpd_C_P((2303 - 15)- 48*0), true),
			148 => (CARRYCASCIN_ipd'last_event, tpd_CARRYCASCIN_P(32), true),
			149 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(32), true),
			150 => (CARRYINSEL_ipd(0)'last_event, tpd_CARRYINSEL_P((143 - 15)- 48*0), true),
			151 => (CARRYINSEL_ipd(1)'last_event, tpd_CARRYINSEL_P((143 - 15)- 48*0), true),
			152 => (CARRYINSEL_ipd(2)'last_event, tpd_CARRYINSEL_P((143 - 15)- 48*0), true),
			153 => (MULTSIGNIN_ipd'last_event, tpd_MULTSIGNIN_P(32), true),
			154 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 15)- 48*0), true),
			155 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 15)- 48*0), true),
			156 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 15)- 48*0), true),
			157 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 15)- 48*0), true),
			158 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 15)- 48*0), true),
			159 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 15)- 48*0), true),
			160 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 15)- 48*0), true),
			161 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 15)- 48*0), true),
			162 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 15)- 48*0), true),
			163 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 15)- 48*0), true),
			164 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 15)- 48*0), true),
			165 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 15)- 48*0), true),
			166 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 15)- 48*0), true),
			167 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 15)- 48*0), true),
			168 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 15)- 48*0), true),
			169 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 15)- 48*0), true),
			170 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 15)- 48*0), true),
			171 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 15)- 48*0), true),
			172 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 15)- 48*0), true),
			173 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 15)- 48*0), true),
			174 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 15)- 48*0), true),
			175 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 15)- 48*0), true),
			176 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 15)- 48*0), true),
			177 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 15)- 48*0), true),
			178 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 15)- 48*0), true),
			179 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 15)- 48*0), true),
			180 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 15)- 48*0), true),
			181 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 15)- 48*0), true),
			182 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 15)- 48*0), true),
			183 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 15)- 48*0), true),
			184 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 15)- 48*0), true),
			185 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 15)- 48*0), true),
			186 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 15)- 48*0), true),
			187 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 15)- 48*0), true),
			188 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 15)- 48*0), true),
			189 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 15)- 48*0), true),
			190 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 15)- 48*0), true),
			191 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 15)- 48*0), true),
			192 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 15)- 48*0), true),
			193 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 15)- 48*0), true),
			194 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 15)- 48*0), true),
			195 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 15)- 48*0), true),
			196 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 15)- 48*0), true),
			197 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 15)- 48*0), true),
			198 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 15)- 48*0), true),
			199 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 15)- 48*0), true),
			200 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 15)- 48*0), true),
			201 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 15)- 48*0), true),
			202 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 15)- 48*0), true),
			203 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 15)- 48*0), true),
			204 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 15)- 48*0), true),
			205 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 15)- 48*0), true),
			206 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 15)- 48*0), true),
			207 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 15)- 48*0), true),
			208 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 15)- 48*0), true),
			209 => (CLK_dly'last_event, tpd_CLK_P(32), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(31),
         GlitchData	=> P_GlitchData(31),
         OutSignalName	=> "P(31)",
         OutTemp	=> P_zd(31),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((1439 - 16)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((1439 - 16)- 48*0), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((1439 - 16)- 48*0), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((1439 - 16)- 48*0), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((1439 - 16)- 48*0), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((1439 - 16)- 48*0), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((1439 - 16)- 48*0), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((1439 - 16)- 48*0), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((1439 - 16)- 48*0), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((1439 - 16)- 48*0), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((1439 - 16)- 48*0), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((1439 - 16)- 48*0), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((1439 - 16)- 48*0), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((1439 - 16)- 48*0), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((1439 - 16)- 48*0), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((1439 - 16)- 48*0), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((1439 - 16)- 48*0), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((1439 - 16)- 48*0), true),
			18 => (A_ipd(18)'last_event, tpd_A_P((1439 - 16)- 48*0), true),
			19 => (A_ipd(19)'last_event, tpd_A_P((1439 - 16)- 48*0), true),
			20 => (A_ipd(20)'last_event, tpd_A_P((1439 - 16)- 48*0), true),
			21 => (A_ipd(21)'last_event, tpd_A_P((1439 - 16)- 48*0), true),
			22 => (A_ipd(22)'last_event, tpd_A_P((1439 - 16)- 48*0), true),
			23 => (A_ipd(23)'last_event, tpd_A_P((1439 - 16)- 48*0), true),
			24 => (A_ipd(24)'last_event, tpd_A_P((1439 - 16)- 48*0), true),
			25 => (A_ipd(25)'last_event, tpd_A_P((1439 - 16)- 48*0), true),
			26 => (A_ipd(26)'last_event, tpd_A_P((1439 - 16)- 48*0), true),
			27 => (A_ipd(27)'last_event, tpd_A_P((1439 - 16)- 48*0), true),
			28 => (A_ipd(28)'last_event, tpd_A_P((1439 - 16)- 48*0), true),
			29 => (A_ipd(29)'last_event, tpd_A_P((1439 - 16)- 48*0), true),
			30 => (ACIN_ipd(0)'last_event, tpd_ACIN_P((1439 - 16)- 48*0), true),
			31 => (ACIN_ipd(1)'last_event, tpd_ACIN_P((1439 - 16)- 48*0), true),
			32 => (ACIN_ipd(2)'last_event, tpd_ACIN_P((1439 - 16)- 48*0), true),
			33 => (ACIN_ipd(3)'last_event, tpd_ACIN_P((1439 - 16)- 48*0), true),
			34 => (ACIN_ipd(4)'last_event, tpd_ACIN_P((1439 - 16)- 48*0), true),
			35 => (ACIN_ipd(5)'last_event, tpd_ACIN_P((1439 - 16)- 48*0), true),
			36 => (ACIN_ipd(6)'last_event, tpd_ACIN_P((1439 - 16)- 48*0), true),
			37 => (ACIN_ipd(7)'last_event, tpd_ACIN_P((1439 - 16)- 48*0), true),
			38 => (ACIN_ipd(8)'last_event, tpd_ACIN_P((1439 - 16)- 48*0), true),
			39 => (ACIN_ipd(9)'last_event, tpd_ACIN_P((1439 - 16)- 48*0), true),
			40 => (ACIN_ipd(10)'last_event, tpd_ACIN_P((1439 - 16)- 48*0), true),
			41 => (ACIN_ipd(11)'last_event, tpd_ACIN_P((1439 - 16)- 48*0), true),
			42 => (ACIN_ipd(12)'last_event, tpd_ACIN_P((1439 - 16)- 48*0), true),
			43 => (ACIN_ipd(13)'last_event, tpd_ACIN_P((1439 - 16)- 48*0), true),
			44 => (ACIN_ipd(14)'last_event, tpd_ACIN_P((1439 - 16)- 48*0), true),
			45 => (ACIN_ipd(15)'last_event, tpd_ACIN_P((1439 - 16)- 48*0), true),
			46 => (ACIN_ipd(16)'last_event, tpd_ACIN_P((1439 - 16)- 48*0), true),
			47 => (ACIN_ipd(17)'last_event, tpd_ACIN_P((1439 - 16)- 48*0), true),
			48 => (ACIN_ipd(18)'last_event, tpd_ACIN_P((1439 - 16)- 48*0), true),
			49 => (ACIN_ipd(19)'last_event, tpd_ACIN_P((1439 - 16)- 48*0), true),
			50 => (ACIN_ipd(20)'last_event, tpd_ACIN_P((1439 - 16)- 48*0), true),
			51 => (ACIN_ipd(21)'last_event, tpd_ACIN_P((1439 - 16)- 48*0), true),
			52 => (ACIN_ipd(22)'last_event, tpd_ACIN_P((1439 - 16)- 48*0), true),
			53 => (ACIN_ipd(23)'last_event, tpd_ACIN_P((1439 - 16)- 48*0), true),
			54 => (ACIN_ipd(24)'last_event, tpd_ACIN_P((1439 - 16)- 48*0), true),
			55 => (ACIN_ipd(25)'last_event, tpd_ACIN_P((1439 - 16)- 48*0), true),
			56 => (ACIN_ipd(26)'last_event, tpd_ACIN_P((1439 - 16)- 48*0), true),
			57 => (ACIN_ipd(27)'last_event, tpd_ACIN_P((1439 - 16)- 48*0), true),
			58 => (ACIN_ipd(28)'last_event, tpd_ACIN_P((1439 - 16)- 48*0), true),
			59 => (ACIN_ipd(29)'last_event, tpd_ACIN_P((1439 - 16)- 48*0), true),
			60 => (ALUMODE_ipd(0)'last_event, tpd_ALUMODE_P((191 - 16)- 48*0), true),
			61 => (ALUMODE_ipd(1)'last_event, tpd_ALUMODE_P((191 - 16)- 48*0), true),
			62 => (ALUMODE_ipd(2)'last_event, tpd_ALUMODE_P((191 - 16)- 48*0), true),
			63 => (ALUMODE_ipd(3)'last_event, tpd_ALUMODE_P((191 - 16)- 48*0), true),
			64 => (B_ipd(0)'last_event, tpd_B_P((863 - 16)- 48*0), true),
			65 => (B_ipd(1)'last_event, tpd_B_P((863 - 16)- 48*0), true),
			66 => (B_ipd(2)'last_event, tpd_B_P((863 - 16)- 48*0), true),
			67 => (B_ipd(3)'last_event, tpd_B_P((863 - 16)- 48*0), true),
			68 => (B_ipd(4)'last_event, tpd_B_P((863 - 16)- 48*0), true),
			69 => (B_ipd(5)'last_event, tpd_B_P((863 - 16)- 48*0), true),
			70 => (B_ipd(6)'last_event, tpd_B_P((863 - 16)- 48*0), true),
			71 => (B_ipd(7)'last_event, tpd_B_P((863 - 16)- 48*0), true),
			72 => (B_ipd(8)'last_event, tpd_B_P((863 - 16)- 48*0), true),
			73 => (B_ipd(9)'last_event, tpd_B_P((863 - 16)- 48*0), true),
			74 => (B_ipd(10)'last_event, tpd_B_P((863 - 16)- 48*0), true),
			75 => (B_ipd(11)'last_event, tpd_B_P((863 - 16)- 48*0), true),
			76 => (B_ipd(12)'last_event, tpd_B_P((863 - 16)- 48*0), true),
			77 => (B_ipd(13)'last_event, tpd_B_P((863 - 16)- 48*0), true),
			78 => (B_ipd(14)'last_event, tpd_B_P((863 - 16)- 48*0), true),
			79 => (B_ipd(15)'last_event, tpd_B_P((863 - 16)- 48*0), true),
			80 => (B_ipd(16)'last_event, tpd_B_P((863 - 16)- 48*0), true),
			81 => (B_ipd(17)'last_event, tpd_B_P((863 - 16)- 48*0), true),
			82 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 16)- 48*0), true),
			83 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 16)- 48*0), true),
			84 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 16)- 48*0), true),
			85 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 16)- 48*0), true),
			86 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 16)- 48*0), true),
			87 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 16)- 48*0), true),
			88 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 16)- 48*0), true),
			89 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 16)- 48*0), true),
			90 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 16)- 48*0), true),
			91 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 16)- 48*0), true),
			92 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 16)- 48*0), true),
			93 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 16)- 48*0), true),
			94 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 16)- 48*0), true),
			95 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 16)- 48*0), true),
			96 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 16)- 48*0), true),
			97 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 16)- 48*0), true),
			98 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 16)- 48*0), true),
			99 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 16)- 48*0), true),
			100 => (C_ipd(0)'last_event, tpd_C_P((2303 - 16)- 48*0), true),
			101 => (C_ipd(1)'last_event, tpd_C_P((2303 - 16)- 48*0), true),
			102 => (C_ipd(2)'last_event, tpd_C_P((2303 - 16)- 48*0), true),
			103 => (C_ipd(3)'last_event, tpd_C_P((2303 - 16)- 48*0), true),
			104 => (C_ipd(4)'last_event, tpd_C_P((2303 - 16)- 48*0), true),
			105 => (C_ipd(5)'last_event, tpd_C_P((2303 - 16)- 48*0), true),
			106 => (C_ipd(6)'last_event, tpd_C_P((2303 - 16)- 48*0), true),
			107 => (C_ipd(7)'last_event, tpd_C_P((2303 - 16)- 48*0), true),
			108 => (C_ipd(8)'last_event, tpd_C_P((2303 - 16)- 48*0), true),
			109 => (C_ipd(9)'last_event, tpd_C_P((2303 - 16)- 48*0), true),
			110 => (C_ipd(10)'last_event, tpd_C_P((2303 - 16)- 48*0), true),
			111 => (C_ipd(11)'last_event, tpd_C_P((2303 - 16)- 48*0), true),
			112 => (C_ipd(12)'last_event, tpd_C_P((2303 - 16)- 48*0), true),
			113 => (C_ipd(13)'last_event, tpd_C_P((2303 - 16)- 48*0), true),
			114 => (C_ipd(14)'last_event, tpd_C_P((2303 - 16)- 48*0), true),
			115 => (C_ipd(15)'last_event, tpd_C_P((2303 - 16)- 48*0), true),
			116 => (C_ipd(16)'last_event, tpd_C_P((2303 - 16)- 48*0), true),
			117 => (C_ipd(17)'last_event, tpd_C_P((2303 - 16)- 48*0), true),
			118 => (C_ipd(18)'last_event, tpd_C_P((2303 - 16)- 48*0), true),
			119 => (C_ipd(19)'last_event, tpd_C_P((2303 - 16)- 48*0), true),
			120 => (C_ipd(20)'last_event, tpd_C_P((2303 - 16)- 48*0), true),
			121 => (C_ipd(21)'last_event, tpd_C_P((2303 - 16)- 48*0), true),
			122 => (C_ipd(22)'last_event, tpd_C_P((2303 - 16)- 48*0), true),
			123 => (C_ipd(23)'last_event, tpd_C_P((2303 - 16)- 48*0), true),
			124 => (C_ipd(24)'last_event, tpd_C_P((2303 - 16)- 48*0), true),
			125 => (C_ipd(25)'last_event, tpd_C_P((2303 - 16)- 48*0), true),
			126 => (C_ipd(26)'last_event, tpd_C_P((2303 - 16)- 48*0), true),
			127 => (C_ipd(27)'last_event, tpd_C_P((2303 - 16)- 48*0), true),
			128 => (C_ipd(28)'last_event, tpd_C_P((2303 - 16)- 48*0), true),
			129 => (C_ipd(29)'last_event, tpd_C_P((2303 - 16)- 48*0), true),
			130 => (C_ipd(30)'last_event, tpd_C_P((2303 - 16)- 48*0), true),
			131 => (C_ipd(31)'last_event, tpd_C_P((2303 - 16)- 48*0), true),
			132 => (C_ipd(32)'last_event, tpd_C_P((2303 - 16)- 48*0), true),
			133 => (C_ipd(33)'last_event, tpd_C_P((2303 - 16)- 48*0), true),
			134 => (C_ipd(34)'last_event, tpd_C_P((2303 - 16)- 48*0), true),
			135 => (C_ipd(35)'last_event, tpd_C_P((2303 - 16)- 48*0), true),
			136 => (C_ipd(36)'last_event, tpd_C_P((2303 - 16)- 48*0), true),
			137 => (C_ipd(37)'last_event, tpd_C_P((2303 - 16)- 48*0), true),
			138 => (C_ipd(38)'last_event, tpd_C_P((2303 - 16)- 48*0), true),
			139 => (C_ipd(39)'last_event, tpd_C_P((2303 - 16)- 48*0), true),
			140 => (C_ipd(40)'last_event, tpd_C_P((2303 - 16)- 48*0), true),
			141 => (C_ipd(41)'last_event, tpd_C_P((2303 - 16)- 48*0), true),
			142 => (C_ipd(42)'last_event, tpd_C_P((2303 - 16)- 48*0), true),
			143 => (C_ipd(43)'last_event, tpd_C_P((2303 - 16)- 48*0), true),
			144 => (C_ipd(44)'last_event, tpd_C_P((2303 - 16)- 48*0), true),
			145 => (C_ipd(45)'last_event, tpd_C_P((2303 - 16)- 48*0), true),
			146 => (C_ipd(46)'last_event, tpd_C_P((2303 - 16)- 48*0), true),
			147 => (C_ipd(47)'last_event, tpd_C_P((2303 - 16)- 48*0), true),
			148 => (CARRYCASCIN_ipd'last_event, tpd_CARRYCASCIN_P(31), true),
			149 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(31), true),
			150 => (CARRYINSEL_ipd(0)'last_event, tpd_CARRYINSEL_P((143 - 16)- 48*0), true),
			151 => (CARRYINSEL_ipd(1)'last_event, tpd_CARRYINSEL_P((143 - 16)- 48*0), true),
			152 => (CARRYINSEL_ipd(2)'last_event, tpd_CARRYINSEL_P((143 - 16)- 48*0), true),
			153 => (MULTSIGNIN_ipd'last_event, tpd_MULTSIGNIN_P(31), true),
			154 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 16)- 48*0), true),
			155 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 16)- 48*0), true),
			156 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 16)- 48*0), true),
			157 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 16)- 48*0), true),
			158 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 16)- 48*0), true),
			159 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 16)- 48*0), true),
			160 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 16)- 48*0), true),
			161 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 16)- 48*0), true),
			162 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 16)- 48*0), true),
			163 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 16)- 48*0), true),
			164 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 16)- 48*0), true),
			165 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 16)- 48*0), true),
			166 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 16)- 48*0), true),
			167 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 16)- 48*0), true),
			168 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 16)- 48*0), true),
			169 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 16)- 48*0), true),
			170 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 16)- 48*0), true),
			171 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 16)- 48*0), true),
			172 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 16)- 48*0), true),
			173 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 16)- 48*0), true),
			174 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 16)- 48*0), true),
			175 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 16)- 48*0), true),
			176 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 16)- 48*0), true),
			177 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 16)- 48*0), true),
			178 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 16)- 48*0), true),
			179 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 16)- 48*0), true),
			180 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 16)- 48*0), true),
			181 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 16)- 48*0), true),
			182 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 16)- 48*0), true),
			183 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 16)- 48*0), true),
			184 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 16)- 48*0), true),
			185 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 16)- 48*0), true),
			186 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 16)- 48*0), true),
			187 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 16)- 48*0), true),
			188 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 16)- 48*0), true),
			189 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 16)- 48*0), true),
			190 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 16)- 48*0), true),
			191 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 16)- 48*0), true),
			192 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 16)- 48*0), true),
			193 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 16)- 48*0), true),
			194 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 16)- 48*0), true),
			195 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 16)- 48*0), true),
			196 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 16)- 48*0), true),
			197 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 16)- 48*0), true),
			198 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 16)- 48*0), true),
			199 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 16)- 48*0), true),
			200 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 16)- 48*0), true),
			201 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 16)- 48*0), true),
			202 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 16)- 48*0), true),
			203 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 16)- 48*0), true),
			204 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 16)- 48*0), true),
			205 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 16)- 48*0), true),
			206 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 16)- 48*0), true),
			207 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 16)- 48*0), true),
			208 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 16)- 48*0), true),
			209 => (CLK_dly'last_event, tpd_CLK_P(31), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(30),
         GlitchData	=> P_GlitchData(30),
         OutSignalName	=> "P(30)",
         OutTemp	=> P_zd(30),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((1439 - 17)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((1439 - 17)- 48*0), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((1439 - 17)- 48*0), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((1439 - 17)- 48*0), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((1439 - 17)- 48*0), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((1439 - 17)- 48*0), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((1439 - 17)- 48*0), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((1439 - 17)- 48*0), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((1439 - 17)- 48*0), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((1439 - 17)- 48*0), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((1439 - 17)- 48*0), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((1439 - 17)- 48*0), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((1439 - 17)- 48*0), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((1439 - 17)- 48*0), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((1439 - 17)- 48*0), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((1439 - 17)- 48*0), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((1439 - 17)- 48*0), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((1439 - 17)- 48*0), true),
			18 => (A_ipd(18)'last_event, tpd_A_P((1439 - 17)- 48*0), true),
			19 => (A_ipd(19)'last_event, tpd_A_P((1439 - 17)- 48*0), true),
			20 => (A_ipd(20)'last_event, tpd_A_P((1439 - 17)- 48*0), true),
			21 => (A_ipd(21)'last_event, tpd_A_P((1439 - 17)- 48*0), true),
			22 => (A_ipd(22)'last_event, tpd_A_P((1439 - 17)- 48*0), true),
			23 => (A_ipd(23)'last_event, tpd_A_P((1439 - 17)- 48*0), true),
			24 => (A_ipd(24)'last_event, tpd_A_P((1439 - 17)- 48*0), true),
			25 => (A_ipd(25)'last_event, tpd_A_P((1439 - 17)- 48*0), true),
			26 => (A_ipd(26)'last_event, tpd_A_P((1439 - 17)- 48*0), true),
			27 => (A_ipd(27)'last_event, tpd_A_P((1439 - 17)- 48*0), true),
			28 => (A_ipd(28)'last_event, tpd_A_P((1439 - 17)- 48*0), true),
			29 => (A_ipd(29)'last_event, tpd_A_P((1439 - 17)- 48*0), true),
			30 => (ACIN_ipd(0)'last_event, tpd_ACIN_P((1439 - 17)- 48*0), true),
			31 => (ACIN_ipd(1)'last_event, tpd_ACIN_P((1439 - 17)- 48*0), true),
			32 => (ACIN_ipd(2)'last_event, tpd_ACIN_P((1439 - 17)- 48*0), true),
			33 => (ACIN_ipd(3)'last_event, tpd_ACIN_P((1439 - 17)- 48*0), true),
			34 => (ACIN_ipd(4)'last_event, tpd_ACIN_P((1439 - 17)- 48*0), true),
			35 => (ACIN_ipd(5)'last_event, tpd_ACIN_P((1439 - 17)- 48*0), true),
			36 => (ACIN_ipd(6)'last_event, tpd_ACIN_P((1439 - 17)- 48*0), true),
			37 => (ACIN_ipd(7)'last_event, tpd_ACIN_P((1439 - 17)- 48*0), true),
			38 => (ACIN_ipd(8)'last_event, tpd_ACIN_P((1439 - 17)- 48*0), true),
			39 => (ACIN_ipd(9)'last_event, tpd_ACIN_P((1439 - 17)- 48*0), true),
			40 => (ACIN_ipd(10)'last_event, tpd_ACIN_P((1439 - 17)- 48*0), true),
			41 => (ACIN_ipd(11)'last_event, tpd_ACIN_P((1439 - 17)- 48*0), true),
			42 => (ACIN_ipd(12)'last_event, tpd_ACIN_P((1439 - 17)- 48*0), true),
			43 => (ACIN_ipd(13)'last_event, tpd_ACIN_P((1439 - 17)- 48*0), true),
			44 => (ACIN_ipd(14)'last_event, tpd_ACIN_P((1439 - 17)- 48*0), true),
			45 => (ACIN_ipd(15)'last_event, tpd_ACIN_P((1439 - 17)- 48*0), true),
			46 => (ACIN_ipd(16)'last_event, tpd_ACIN_P((1439 - 17)- 48*0), true),
			47 => (ACIN_ipd(17)'last_event, tpd_ACIN_P((1439 - 17)- 48*0), true),
			48 => (ACIN_ipd(18)'last_event, tpd_ACIN_P((1439 - 17)- 48*0), true),
			49 => (ACIN_ipd(19)'last_event, tpd_ACIN_P((1439 - 17)- 48*0), true),
			50 => (ACIN_ipd(20)'last_event, tpd_ACIN_P((1439 - 17)- 48*0), true),
			51 => (ACIN_ipd(21)'last_event, tpd_ACIN_P((1439 - 17)- 48*0), true),
			52 => (ACIN_ipd(22)'last_event, tpd_ACIN_P((1439 - 17)- 48*0), true),
			53 => (ACIN_ipd(23)'last_event, tpd_ACIN_P((1439 - 17)- 48*0), true),
			54 => (ACIN_ipd(24)'last_event, tpd_ACIN_P((1439 - 17)- 48*0), true),
			55 => (ACIN_ipd(25)'last_event, tpd_ACIN_P((1439 - 17)- 48*0), true),
			56 => (ACIN_ipd(26)'last_event, tpd_ACIN_P((1439 - 17)- 48*0), true),
			57 => (ACIN_ipd(27)'last_event, tpd_ACIN_P((1439 - 17)- 48*0), true),
			58 => (ACIN_ipd(28)'last_event, tpd_ACIN_P((1439 - 17)- 48*0), true),
			59 => (ACIN_ipd(29)'last_event, tpd_ACIN_P((1439 - 17)- 48*0), true),
			60 => (ALUMODE_ipd(0)'last_event, tpd_ALUMODE_P((191 - 17)- 48*0), true),
			61 => (ALUMODE_ipd(1)'last_event, tpd_ALUMODE_P((191 - 17)- 48*0), true),
			62 => (ALUMODE_ipd(2)'last_event, tpd_ALUMODE_P((191 - 17)- 48*0), true),
			63 => (ALUMODE_ipd(3)'last_event, tpd_ALUMODE_P((191 - 17)- 48*0), true),
			64 => (B_ipd(0)'last_event, tpd_B_P((863 - 17)- 48*0), true),
			65 => (B_ipd(1)'last_event, tpd_B_P((863 - 17)- 48*0), true),
			66 => (B_ipd(2)'last_event, tpd_B_P((863 - 17)- 48*0), true),
			67 => (B_ipd(3)'last_event, tpd_B_P((863 - 17)- 48*0), true),
			68 => (B_ipd(4)'last_event, tpd_B_P((863 - 17)- 48*0), true),
			69 => (B_ipd(5)'last_event, tpd_B_P((863 - 17)- 48*0), true),
			70 => (B_ipd(6)'last_event, tpd_B_P((863 - 17)- 48*0), true),
			71 => (B_ipd(7)'last_event, tpd_B_P((863 - 17)- 48*0), true),
			72 => (B_ipd(8)'last_event, tpd_B_P((863 - 17)- 48*0), true),
			73 => (B_ipd(9)'last_event, tpd_B_P((863 - 17)- 48*0), true),
			74 => (B_ipd(10)'last_event, tpd_B_P((863 - 17)- 48*0), true),
			75 => (B_ipd(11)'last_event, tpd_B_P((863 - 17)- 48*0), true),
			76 => (B_ipd(12)'last_event, tpd_B_P((863 - 17)- 48*0), true),
			77 => (B_ipd(13)'last_event, tpd_B_P((863 - 17)- 48*0), true),
			78 => (B_ipd(14)'last_event, tpd_B_P((863 - 17)- 48*0), true),
			79 => (B_ipd(15)'last_event, tpd_B_P((863 - 17)- 48*0), true),
			80 => (B_ipd(16)'last_event, tpd_B_P((863 - 17)- 48*0), true),
			81 => (B_ipd(17)'last_event, tpd_B_P((863 - 17)- 48*0), true),
			82 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 17)- 48*0), true),
			83 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 17)- 48*0), true),
			84 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 17)- 48*0), true),
			85 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 17)- 48*0), true),
			86 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 17)- 48*0), true),
			87 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 17)- 48*0), true),
			88 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 17)- 48*0), true),
			89 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 17)- 48*0), true),
			90 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 17)- 48*0), true),
			91 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 17)- 48*0), true),
			92 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 17)- 48*0), true),
			93 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 17)- 48*0), true),
			94 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 17)- 48*0), true),
			95 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 17)- 48*0), true),
			96 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 17)- 48*0), true),
			97 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 17)- 48*0), true),
			98 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 17)- 48*0), true),
			99 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 17)- 48*0), true),
			100 => (C_ipd(0)'last_event, tpd_C_P((2303 - 17)- 48*0), true),
			101 => (C_ipd(1)'last_event, tpd_C_P((2303 - 17)- 48*0), true),
			102 => (C_ipd(2)'last_event, tpd_C_P((2303 - 17)- 48*0), true),
			103 => (C_ipd(3)'last_event, tpd_C_P((2303 - 17)- 48*0), true),
			104 => (C_ipd(4)'last_event, tpd_C_P((2303 - 17)- 48*0), true),
			105 => (C_ipd(5)'last_event, tpd_C_P((2303 - 17)- 48*0), true),
			106 => (C_ipd(6)'last_event, tpd_C_P((2303 - 17)- 48*0), true),
			107 => (C_ipd(7)'last_event, tpd_C_P((2303 - 17)- 48*0), true),
			108 => (C_ipd(8)'last_event, tpd_C_P((2303 - 17)- 48*0), true),
			109 => (C_ipd(9)'last_event, tpd_C_P((2303 - 17)- 48*0), true),
			110 => (C_ipd(10)'last_event, tpd_C_P((2303 - 17)- 48*0), true),
			111 => (C_ipd(11)'last_event, tpd_C_P((2303 - 17)- 48*0), true),
			112 => (C_ipd(12)'last_event, tpd_C_P((2303 - 17)- 48*0), true),
			113 => (C_ipd(13)'last_event, tpd_C_P((2303 - 17)- 48*0), true),
			114 => (C_ipd(14)'last_event, tpd_C_P((2303 - 17)- 48*0), true),
			115 => (C_ipd(15)'last_event, tpd_C_P((2303 - 17)- 48*0), true),
			116 => (C_ipd(16)'last_event, tpd_C_P((2303 - 17)- 48*0), true),
			117 => (C_ipd(17)'last_event, tpd_C_P((2303 - 17)- 48*0), true),
			118 => (C_ipd(18)'last_event, tpd_C_P((2303 - 17)- 48*0), true),
			119 => (C_ipd(19)'last_event, tpd_C_P((2303 - 17)- 48*0), true),
			120 => (C_ipd(20)'last_event, tpd_C_P((2303 - 17)- 48*0), true),
			121 => (C_ipd(21)'last_event, tpd_C_P((2303 - 17)- 48*0), true),
			122 => (C_ipd(22)'last_event, tpd_C_P((2303 - 17)- 48*0), true),
			123 => (C_ipd(23)'last_event, tpd_C_P((2303 - 17)- 48*0), true),
			124 => (C_ipd(24)'last_event, tpd_C_P((2303 - 17)- 48*0), true),
			125 => (C_ipd(25)'last_event, tpd_C_P((2303 - 17)- 48*0), true),
			126 => (C_ipd(26)'last_event, tpd_C_P((2303 - 17)- 48*0), true),
			127 => (C_ipd(27)'last_event, tpd_C_P((2303 - 17)- 48*0), true),
			128 => (C_ipd(28)'last_event, tpd_C_P((2303 - 17)- 48*0), true),
			129 => (C_ipd(29)'last_event, tpd_C_P((2303 - 17)- 48*0), true),
			130 => (C_ipd(30)'last_event, tpd_C_P((2303 - 17)- 48*0), true),
			131 => (C_ipd(31)'last_event, tpd_C_P((2303 - 17)- 48*0), true),
			132 => (C_ipd(32)'last_event, tpd_C_P((2303 - 17)- 48*0), true),
			133 => (C_ipd(33)'last_event, tpd_C_P((2303 - 17)- 48*0), true),
			134 => (C_ipd(34)'last_event, tpd_C_P((2303 - 17)- 48*0), true),
			135 => (C_ipd(35)'last_event, tpd_C_P((2303 - 17)- 48*0), true),
			136 => (C_ipd(36)'last_event, tpd_C_P((2303 - 17)- 48*0), true),
			137 => (C_ipd(37)'last_event, tpd_C_P((2303 - 17)- 48*0), true),
			138 => (C_ipd(38)'last_event, tpd_C_P((2303 - 17)- 48*0), true),
			139 => (C_ipd(39)'last_event, tpd_C_P((2303 - 17)- 48*0), true),
			140 => (C_ipd(40)'last_event, tpd_C_P((2303 - 17)- 48*0), true),
			141 => (C_ipd(41)'last_event, tpd_C_P((2303 - 17)- 48*0), true),
			142 => (C_ipd(42)'last_event, tpd_C_P((2303 - 17)- 48*0), true),
			143 => (C_ipd(43)'last_event, tpd_C_P((2303 - 17)- 48*0), true),
			144 => (C_ipd(44)'last_event, tpd_C_P((2303 - 17)- 48*0), true),
			145 => (C_ipd(45)'last_event, tpd_C_P((2303 - 17)- 48*0), true),
			146 => (C_ipd(46)'last_event, tpd_C_P((2303 - 17)- 48*0), true),
			147 => (C_ipd(47)'last_event, tpd_C_P((2303 - 17)- 48*0), true),
			148 => (CARRYCASCIN_ipd'last_event, tpd_CARRYCASCIN_P(30), true),
			149 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(30), true),
			150 => (CARRYINSEL_ipd(0)'last_event, tpd_CARRYINSEL_P((143 - 17)- 48*0), true),
			151 => (CARRYINSEL_ipd(1)'last_event, tpd_CARRYINSEL_P((143 - 17)- 48*0), true),
			152 => (CARRYINSEL_ipd(2)'last_event, tpd_CARRYINSEL_P((143 - 17)- 48*0), true),
			153 => (MULTSIGNIN_ipd'last_event, tpd_MULTSIGNIN_P(30), true),
			154 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 17)- 48*0), true),
			155 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 17)- 48*0), true),
			156 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 17)- 48*0), true),
			157 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 17)- 48*0), true),
			158 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 17)- 48*0), true),
			159 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 17)- 48*0), true),
			160 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 17)- 48*0), true),
			161 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 17)- 48*0), true),
			162 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 17)- 48*0), true),
			163 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 17)- 48*0), true),
			164 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 17)- 48*0), true),
			165 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 17)- 48*0), true),
			166 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 17)- 48*0), true),
			167 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 17)- 48*0), true),
			168 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 17)- 48*0), true),
			169 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 17)- 48*0), true),
			170 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 17)- 48*0), true),
			171 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 17)- 48*0), true),
			172 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 17)- 48*0), true),
			173 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 17)- 48*0), true),
			174 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 17)- 48*0), true),
			175 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 17)- 48*0), true),
			176 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 17)- 48*0), true),
			177 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 17)- 48*0), true),
			178 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 17)- 48*0), true),
			179 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 17)- 48*0), true),
			180 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 17)- 48*0), true),
			181 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 17)- 48*0), true),
			182 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 17)- 48*0), true),
			183 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 17)- 48*0), true),
			184 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 17)- 48*0), true),
			185 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 17)- 48*0), true),
			186 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 17)- 48*0), true),
			187 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 17)- 48*0), true),
			188 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 17)- 48*0), true),
			189 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 17)- 48*0), true),
			190 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 17)- 48*0), true),
			191 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 17)- 48*0), true),
			192 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 17)- 48*0), true),
			193 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 17)- 48*0), true),
			194 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 17)- 48*0), true),
			195 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 17)- 48*0), true),
			196 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 17)- 48*0), true),
			197 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 17)- 48*0), true),
			198 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 17)- 48*0), true),
			199 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 17)- 48*0), true),
			200 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 17)- 48*0), true),
			201 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 17)- 48*0), true),
			202 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 17)- 48*0), true),
			203 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 17)- 48*0), true),
			204 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 17)- 48*0), true),
			205 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 17)- 48*0), true),
			206 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 17)- 48*0), true),
			207 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 17)- 48*0), true),
			208 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 17)- 48*0), true),
			209 => (CLK_dly'last_event, tpd_CLK_P(30), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(29),
         GlitchData	=> P_GlitchData(29),
         OutSignalName	=> "P(29)",
         OutTemp	=> P_zd(29),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((1439 - 18)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((1439 - 18)- 48*0), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((1439 - 18)- 48*0), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((1439 - 18)- 48*0), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((1439 - 18)- 48*0), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((1439 - 18)- 48*0), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((1439 - 18)- 48*0), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((1439 - 18)- 48*0), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((1439 - 18)- 48*0), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((1439 - 18)- 48*0), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((1439 - 18)- 48*0), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((1439 - 18)- 48*0), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((1439 - 18)- 48*0), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((1439 - 18)- 48*0), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((1439 - 18)- 48*0), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((1439 - 18)- 48*0), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((1439 - 18)- 48*0), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((1439 - 18)- 48*0), true),
			18 => (A_ipd(18)'last_event, tpd_A_P((1439 - 18)- 48*0), true),
			19 => (A_ipd(19)'last_event, tpd_A_P((1439 - 18)- 48*0), true),
			20 => (A_ipd(20)'last_event, tpd_A_P((1439 - 18)- 48*0), true),
			21 => (A_ipd(21)'last_event, tpd_A_P((1439 - 18)- 48*0), true),
			22 => (A_ipd(22)'last_event, tpd_A_P((1439 - 18)- 48*0), true),
			23 => (A_ipd(23)'last_event, tpd_A_P((1439 - 18)- 48*0), true),
			24 => (A_ipd(24)'last_event, tpd_A_P((1439 - 18)- 48*0), true),
			25 => (A_ipd(25)'last_event, tpd_A_P((1439 - 18)- 48*0), true),
			26 => (A_ipd(26)'last_event, tpd_A_P((1439 - 18)- 48*0), true),
			27 => (A_ipd(27)'last_event, tpd_A_P((1439 - 18)- 48*0), true),
			28 => (A_ipd(28)'last_event, tpd_A_P((1439 - 18)- 48*0), true),
			29 => (A_ipd(29)'last_event, tpd_A_P((1439 - 18)- 48*0), true),
			30 => (ACIN_ipd(0)'last_event, tpd_ACIN_P((1439 - 18)- 48*0), true),
			31 => (ACIN_ipd(1)'last_event, tpd_ACIN_P((1439 - 18)- 48*0), true),
			32 => (ACIN_ipd(2)'last_event, tpd_ACIN_P((1439 - 18)- 48*0), true),
			33 => (ACIN_ipd(3)'last_event, tpd_ACIN_P((1439 - 18)- 48*0), true),
			34 => (ACIN_ipd(4)'last_event, tpd_ACIN_P((1439 - 18)- 48*0), true),
			35 => (ACIN_ipd(5)'last_event, tpd_ACIN_P((1439 - 18)- 48*0), true),
			36 => (ACIN_ipd(6)'last_event, tpd_ACIN_P((1439 - 18)- 48*0), true),
			37 => (ACIN_ipd(7)'last_event, tpd_ACIN_P((1439 - 18)- 48*0), true),
			38 => (ACIN_ipd(8)'last_event, tpd_ACIN_P((1439 - 18)- 48*0), true),
			39 => (ACIN_ipd(9)'last_event, tpd_ACIN_P((1439 - 18)- 48*0), true),
			40 => (ACIN_ipd(10)'last_event, tpd_ACIN_P((1439 - 18)- 48*0), true),
			41 => (ACIN_ipd(11)'last_event, tpd_ACIN_P((1439 - 18)- 48*0), true),
			42 => (ACIN_ipd(12)'last_event, tpd_ACIN_P((1439 - 18)- 48*0), true),
			43 => (ACIN_ipd(13)'last_event, tpd_ACIN_P((1439 - 18)- 48*0), true),
			44 => (ACIN_ipd(14)'last_event, tpd_ACIN_P((1439 - 18)- 48*0), true),
			45 => (ACIN_ipd(15)'last_event, tpd_ACIN_P((1439 - 18)- 48*0), true),
			46 => (ACIN_ipd(16)'last_event, tpd_ACIN_P((1439 - 18)- 48*0), true),
			47 => (ACIN_ipd(17)'last_event, tpd_ACIN_P((1439 - 18)- 48*0), true),
			48 => (ACIN_ipd(18)'last_event, tpd_ACIN_P((1439 - 18)- 48*0), true),
			49 => (ACIN_ipd(19)'last_event, tpd_ACIN_P((1439 - 18)- 48*0), true),
			50 => (ACIN_ipd(20)'last_event, tpd_ACIN_P((1439 - 18)- 48*0), true),
			51 => (ACIN_ipd(21)'last_event, tpd_ACIN_P((1439 - 18)- 48*0), true),
			52 => (ACIN_ipd(22)'last_event, tpd_ACIN_P((1439 - 18)- 48*0), true),
			53 => (ACIN_ipd(23)'last_event, tpd_ACIN_P((1439 - 18)- 48*0), true),
			54 => (ACIN_ipd(24)'last_event, tpd_ACIN_P((1439 - 18)- 48*0), true),
			55 => (ACIN_ipd(25)'last_event, tpd_ACIN_P((1439 - 18)- 48*0), true),
			56 => (ACIN_ipd(26)'last_event, tpd_ACIN_P((1439 - 18)- 48*0), true),
			57 => (ACIN_ipd(27)'last_event, tpd_ACIN_P((1439 - 18)- 48*0), true),
			58 => (ACIN_ipd(28)'last_event, tpd_ACIN_P((1439 - 18)- 48*0), true),
			59 => (ACIN_ipd(29)'last_event, tpd_ACIN_P((1439 - 18)- 48*0), true),
			60 => (ALUMODE_ipd(0)'last_event, tpd_ALUMODE_P((191 - 18)- 48*0), true),
			61 => (ALUMODE_ipd(1)'last_event, tpd_ALUMODE_P((191 - 18)- 48*0), true),
			62 => (ALUMODE_ipd(2)'last_event, tpd_ALUMODE_P((191 - 18)- 48*0), true),
			63 => (ALUMODE_ipd(3)'last_event, tpd_ALUMODE_P((191 - 18)- 48*0), true),
			64 => (B_ipd(0)'last_event, tpd_B_P((863 - 18)- 48*0), true),
			65 => (B_ipd(1)'last_event, tpd_B_P((863 - 18)- 48*0), true),
			66 => (B_ipd(2)'last_event, tpd_B_P((863 - 18)- 48*0), true),
			67 => (B_ipd(3)'last_event, tpd_B_P((863 - 18)- 48*0), true),
			68 => (B_ipd(4)'last_event, tpd_B_P((863 - 18)- 48*0), true),
			69 => (B_ipd(5)'last_event, tpd_B_P((863 - 18)- 48*0), true),
			70 => (B_ipd(6)'last_event, tpd_B_P((863 - 18)- 48*0), true),
			71 => (B_ipd(7)'last_event, tpd_B_P((863 - 18)- 48*0), true),
			72 => (B_ipd(8)'last_event, tpd_B_P((863 - 18)- 48*0), true),
			73 => (B_ipd(9)'last_event, tpd_B_P((863 - 18)- 48*0), true),
			74 => (B_ipd(10)'last_event, tpd_B_P((863 - 18)- 48*0), true),
			75 => (B_ipd(11)'last_event, tpd_B_P((863 - 18)- 48*0), true),
			76 => (B_ipd(12)'last_event, tpd_B_P((863 - 18)- 48*0), true),
			77 => (B_ipd(13)'last_event, tpd_B_P((863 - 18)- 48*0), true),
			78 => (B_ipd(14)'last_event, tpd_B_P((863 - 18)- 48*0), true),
			79 => (B_ipd(15)'last_event, tpd_B_P((863 - 18)- 48*0), true),
			80 => (B_ipd(16)'last_event, tpd_B_P((863 - 18)- 48*0), true),
			81 => (B_ipd(17)'last_event, tpd_B_P((863 - 18)- 48*0), true),
			82 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 18)- 48*0), true),
			83 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 18)- 48*0), true),
			84 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 18)- 48*0), true),
			85 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 18)- 48*0), true),
			86 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 18)- 48*0), true),
			87 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 18)- 48*0), true),
			88 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 18)- 48*0), true),
			89 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 18)- 48*0), true),
			90 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 18)- 48*0), true),
			91 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 18)- 48*0), true),
			92 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 18)- 48*0), true),
			93 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 18)- 48*0), true),
			94 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 18)- 48*0), true),
			95 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 18)- 48*0), true),
			96 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 18)- 48*0), true),
			97 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 18)- 48*0), true),
			98 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 18)- 48*0), true),
			99 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 18)- 48*0), true),
			100 => (C_ipd(0)'last_event, tpd_C_P((2303 - 18)- 48*0), true),
			101 => (C_ipd(1)'last_event, tpd_C_P((2303 - 18)- 48*0), true),
			102 => (C_ipd(2)'last_event, tpd_C_P((2303 - 18)- 48*0), true),
			103 => (C_ipd(3)'last_event, tpd_C_P((2303 - 18)- 48*0), true),
			104 => (C_ipd(4)'last_event, tpd_C_P((2303 - 18)- 48*0), true),
			105 => (C_ipd(5)'last_event, tpd_C_P((2303 - 18)- 48*0), true),
			106 => (C_ipd(6)'last_event, tpd_C_P((2303 - 18)- 48*0), true),
			107 => (C_ipd(7)'last_event, tpd_C_P((2303 - 18)- 48*0), true),
			108 => (C_ipd(8)'last_event, tpd_C_P((2303 - 18)- 48*0), true),
			109 => (C_ipd(9)'last_event, tpd_C_P((2303 - 18)- 48*0), true),
			110 => (C_ipd(10)'last_event, tpd_C_P((2303 - 18)- 48*0), true),
			111 => (C_ipd(11)'last_event, tpd_C_P((2303 - 18)- 48*0), true),
			112 => (C_ipd(12)'last_event, tpd_C_P((2303 - 18)- 48*0), true),
			113 => (C_ipd(13)'last_event, tpd_C_P((2303 - 18)- 48*0), true),
			114 => (C_ipd(14)'last_event, tpd_C_P((2303 - 18)- 48*0), true),
			115 => (C_ipd(15)'last_event, tpd_C_P((2303 - 18)- 48*0), true),
			116 => (C_ipd(16)'last_event, tpd_C_P((2303 - 18)- 48*0), true),
			117 => (C_ipd(17)'last_event, tpd_C_P((2303 - 18)- 48*0), true),
			118 => (C_ipd(18)'last_event, tpd_C_P((2303 - 18)- 48*0), true),
			119 => (C_ipd(19)'last_event, tpd_C_P((2303 - 18)- 48*0), true),
			120 => (C_ipd(20)'last_event, tpd_C_P((2303 - 18)- 48*0), true),
			121 => (C_ipd(21)'last_event, tpd_C_P((2303 - 18)- 48*0), true),
			122 => (C_ipd(22)'last_event, tpd_C_P((2303 - 18)- 48*0), true),
			123 => (C_ipd(23)'last_event, tpd_C_P((2303 - 18)- 48*0), true),
			124 => (C_ipd(24)'last_event, tpd_C_P((2303 - 18)- 48*0), true),
			125 => (C_ipd(25)'last_event, tpd_C_P((2303 - 18)- 48*0), true),
			126 => (C_ipd(26)'last_event, tpd_C_P((2303 - 18)- 48*0), true),
			127 => (C_ipd(27)'last_event, tpd_C_P((2303 - 18)- 48*0), true),
			128 => (C_ipd(28)'last_event, tpd_C_P((2303 - 18)- 48*0), true),
			129 => (C_ipd(29)'last_event, tpd_C_P((2303 - 18)- 48*0), true),
			130 => (C_ipd(30)'last_event, tpd_C_P((2303 - 18)- 48*0), true),
			131 => (C_ipd(31)'last_event, tpd_C_P((2303 - 18)- 48*0), true),
			132 => (C_ipd(32)'last_event, tpd_C_P((2303 - 18)- 48*0), true),
			133 => (C_ipd(33)'last_event, tpd_C_P((2303 - 18)- 48*0), true),
			134 => (C_ipd(34)'last_event, tpd_C_P((2303 - 18)- 48*0), true),
			135 => (C_ipd(35)'last_event, tpd_C_P((2303 - 18)- 48*0), true),
			136 => (C_ipd(36)'last_event, tpd_C_P((2303 - 18)- 48*0), true),
			137 => (C_ipd(37)'last_event, tpd_C_P((2303 - 18)- 48*0), true),
			138 => (C_ipd(38)'last_event, tpd_C_P((2303 - 18)- 48*0), true),
			139 => (C_ipd(39)'last_event, tpd_C_P((2303 - 18)- 48*0), true),
			140 => (C_ipd(40)'last_event, tpd_C_P((2303 - 18)- 48*0), true),
			141 => (C_ipd(41)'last_event, tpd_C_P((2303 - 18)- 48*0), true),
			142 => (C_ipd(42)'last_event, tpd_C_P((2303 - 18)- 48*0), true),
			143 => (C_ipd(43)'last_event, tpd_C_P((2303 - 18)- 48*0), true),
			144 => (C_ipd(44)'last_event, tpd_C_P((2303 - 18)- 48*0), true),
			145 => (C_ipd(45)'last_event, tpd_C_P((2303 - 18)- 48*0), true),
			146 => (C_ipd(46)'last_event, tpd_C_P((2303 - 18)- 48*0), true),
			147 => (C_ipd(47)'last_event, tpd_C_P((2303 - 18)- 48*0), true),
			148 => (CARRYCASCIN_ipd'last_event, tpd_CARRYCASCIN_P(29), true),
			149 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(29), true),
			150 => (CARRYINSEL_ipd(0)'last_event, tpd_CARRYINSEL_P((143 - 18)- 48*0), true),
			151 => (CARRYINSEL_ipd(1)'last_event, tpd_CARRYINSEL_P((143 - 18)- 48*0), true),
			152 => (CARRYINSEL_ipd(2)'last_event, tpd_CARRYINSEL_P((143 - 18)- 48*0), true),
			153 => (MULTSIGNIN_ipd'last_event, tpd_MULTSIGNIN_P(29), true),
			154 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 18)- 48*0), true),
			155 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 18)- 48*0), true),
			156 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 18)- 48*0), true),
			157 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 18)- 48*0), true),
			158 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 18)- 48*0), true),
			159 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 18)- 48*0), true),
			160 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 18)- 48*0), true),
			161 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 18)- 48*0), true),
			162 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 18)- 48*0), true),
			163 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 18)- 48*0), true),
			164 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 18)- 48*0), true),
			165 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 18)- 48*0), true),
			166 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 18)- 48*0), true),
			167 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 18)- 48*0), true),
			168 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 18)- 48*0), true),
			169 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 18)- 48*0), true),
			170 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 18)- 48*0), true),
			171 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 18)- 48*0), true),
			172 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 18)- 48*0), true),
			173 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 18)- 48*0), true),
			174 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 18)- 48*0), true),
			175 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 18)- 48*0), true),
			176 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 18)- 48*0), true),
			177 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 18)- 48*0), true),
			178 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 18)- 48*0), true),
			179 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 18)- 48*0), true),
			180 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 18)- 48*0), true),
			181 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 18)- 48*0), true),
			182 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 18)- 48*0), true),
			183 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 18)- 48*0), true),
			184 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 18)- 48*0), true),
			185 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 18)- 48*0), true),
			186 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 18)- 48*0), true),
			187 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 18)- 48*0), true),
			188 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 18)- 48*0), true),
			189 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 18)- 48*0), true),
			190 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 18)- 48*0), true),
			191 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 18)- 48*0), true),
			192 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 18)- 48*0), true),
			193 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 18)- 48*0), true),
			194 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 18)- 48*0), true),
			195 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 18)- 48*0), true),
			196 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 18)- 48*0), true),
			197 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 18)- 48*0), true),
			198 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 18)- 48*0), true),
			199 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 18)- 48*0), true),
			200 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 18)- 48*0), true),
			201 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 18)- 48*0), true),
			202 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 18)- 48*0), true),
			203 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 18)- 48*0), true),
			204 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 18)- 48*0), true),
			205 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 18)- 48*0), true),
			206 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 18)- 48*0), true),
			207 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 18)- 48*0), true),
			208 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 18)- 48*0), true),
			209 => (CLK_dly'last_event, tpd_CLK_P(29), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(28),
         GlitchData	=> P_GlitchData(28),
         OutSignalName	=> "P(28)",
         OutTemp	=> P_zd(28),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((1439 - 19)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((1439 - 19)- 48*0), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((1439 - 19)- 48*0), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((1439 - 19)- 48*0), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((1439 - 19)- 48*0), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((1439 - 19)- 48*0), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((1439 - 19)- 48*0), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((1439 - 19)- 48*0), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((1439 - 19)- 48*0), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((1439 - 19)- 48*0), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((1439 - 19)- 48*0), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((1439 - 19)- 48*0), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((1439 - 19)- 48*0), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((1439 - 19)- 48*0), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((1439 - 19)- 48*0), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((1439 - 19)- 48*0), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((1439 - 19)- 48*0), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((1439 - 19)- 48*0), true),
			18 => (A_ipd(18)'last_event, tpd_A_P((1439 - 19)- 48*0), true),
			19 => (A_ipd(19)'last_event, tpd_A_P((1439 - 19)- 48*0), true),
			20 => (A_ipd(20)'last_event, tpd_A_P((1439 - 19)- 48*0), true),
			21 => (A_ipd(21)'last_event, tpd_A_P((1439 - 19)- 48*0), true),
			22 => (A_ipd(22)'last_event, tpd_A_P((1439 - 19)- 48*0), true),
			23 => (A_ipd(23)'last_event, tpd_A_P((1439 - 19)- 48*0), true),
			24 => (A_ipd(24)'last_event, tpd_A_P((1439 - 19)- 48*0), true),
			25 => (A_ipd(25)'last_event, tpd_A_P((1439 - 19)- 48*0), true),
			26 => (A_ipd(26)'last_event, tpd_A_P((1439 - 19)- 48*0), true),
			27 => (A_ipd(27)'last_event, tpd_A_P((1439 - 19)- 48*0), true),
			28 => (A_ipd(28)'last_event, tpd_A_P((1439 - 19)- 48*0), true),
			29 => (A_ipd(29)'last_event, tpd_A_P((1439 - 19)- 48*0), true),
			30 => (ACIN_ipd(0)'last_event, tpd_ACIN_P((1439 - 19)- 48*0), true),
			31 => (ACIN_ipd(1)'last_event, tpd_ACIN_P((1439 - 19)- 48*0), true),
			32 => (ACIN_ipd(2)'last_event, tpd_ACIN_P((1439 - 19)- 48*0), true),
			33 => (ACIN_ipd(3)'last_event, tpd_ACIN_P((1439 - 19)- 48*0), true),
			34 => (ACIN_ipd(4)'last_event, tpd_ACIN_P((1439 - 19)- 48*0), true),
			35 => (ACIN_ipd(5)'last_event, tpd_ACIN_P((1439 - 19)- 48*0), true),
			36 => (ACIN_ipd(6)'last_event, tpd_ACIN_P((1439 - 19)- 48*0), true),
			37 => (ACIN_ipd(7)'last_event, tpd_ACIN_P((1439 - 19)- 48*0), true),
			38 => (ACIN_ipd(8)'last_event, tpd_ACIN_P((1439 - 19)- 48*0), true),
			39 => (ACIN_ipd(9)'last_event, tpd_ACIN_P((1439 - 19)- 48*0), true),
			40 => (ACIN_ipd(10)'last_event, tpd_ACIN_P((1439 - 19)- 48*0), true),
			41 => (ACIN_ipd(11)'last_event, tpd_ACIN_P((1439 - 19)- 48*0), true),
			42 => (ACIN_ipd(12)'last_event, tpd_ACIN_P((1439 - 19)- 48*0), true),
			43 => (ACIN_ipd(13)'last_event, tpd_ACIN_P((1439 - 19)- 48*0), true),
			44 => (ACIN_ipd(14)'last_event, tpd_ACIN_P((1439 - 19)- 48*0), true),
			45 => (ACIN_ipd(15)'last_event, tpd_ACIN_P((1439 - 19)- 48*0), true),
			46 => (ACIN_ipd(16)'last_event, tpd_ACIN_P((1439 - 19)- 48*0), true),
			47 => (ACIN_ipd(17)'last_event, tpd_ACIN_P((1439 - 19)- 48*0), true),
			48 => (ACIN_ipd(18)'last_event, tpd_ACIN_P((1439 - 19)- 48*0), true),
			49 => (ACIN_ipd(19)'last_event, tpd_ACIN_P((1439 - 19)- 48*0), true),
			50 => (ACIN_ipd(20)'last_event, tpd_ACIN_P((1439 - 19)- 48*0), true),
			51 => (ACIN_ipd(21)'last_event, tpd_ACIN_P((1439 - 19)- 48*0), true),
			52 => (ACIN_ipd(22)'last_event, tpd_ACIN_P((1439 - 19)- 48*0), true),
			53 => (ACIN_ipd(23)'last_event, tpd_ACIN_P((1439 - 19)- 48*0), true),
			54 => (ACIN_ipd(24)'last_event, tpd_ACIN_P((1439 - 19)- 48*0), true),
			55 => (ACIN_ipd(25)'last_event, tpd_ACIN_P((1439 - 19)- 48*0), true),
			56 => (ACIN_ipd(26)'last_event, tpd_ACIN_P((1439 - 19)- 48*0), true),
			57 => (ACIN_ipd(27)'last_event, tpd_ACIN_P((1439 - 19)- 48*0), true),
			58 => (ACIN_ipd(28)'last_event, tpd_ACIN_P((1439 - 19)- 48*0), true),
			59 => (ACIN_ipd(29)'last_event, tpd_ACIN_P((1439 - 19)- 48*0), true),
			60 => (ALUMODE_ipd(0)'last_event, tpd_ALUMODE_P((191 - 19)- 48*0), true),
			61 => (ALUMODE_ipd(1)'last_event, tpd_ALUMODE_P((191 - 19)- 48*0), true),
			62 => (ALUMODE_ipd(2)'last_event, tpd_ALUMODE_P((191 - 19)- 48*0), true),
			63 => (ALUMODE_ipd(3)'last_event, tpd_ALUMODE_P((191 - 19)- 48*0), true),
			64 => (B_ipd(0)'last_event, tpd_B_P((863 - 19)- 48*0), true),
			65 => (B_ipd(1)'last_event, tpd_B_P((863 - 19)- 48*0), true),
			66 => (B_ipd(2)'last_event, tpd_B_P((863 - 19)- 48*0), true),
			67 => (B_ipd(3)'last_event, tpd_B_P((863 - 19)- 48*0), true),
			68 => (B_ipd(4)'last_event, tpd_B_P((863 - 19)- 48*0), true),
			69 => (B_ipd(5)'last_event, tpd_B_P((863 - 19)- 48*0), true),
			70 => (B_ipd(6)'last_event, tpd_B_P((863 - 19)- 48*0), true),
			71 => (B_ipd(7)'last_event, tpd_B_P((863 - 19)- 48*0), true),
			72 => (B_ipd(8)'last_event, tpd_B_P((863 - 19)- 48*0), true),
			73 => (B_ipd(9)'last_event, tpd_B_P((863 - 19)- 48*0), true),
			74 => (B_ipd(10)'last_event, tpd_B_P((863 - 19)- 48*0), true),
			75 => (B_ipd(11)'last_event, tpd_B_P((863 - 19)- 48*0), true),
			76 => (B_ipd(12)'last_event, tpd_B_P((863 - 19)- 48*0), true),
			77 => (B_ipd(13)'last_event, tpd_B_P((863 - 19)- 48*0), true),
			78 => (B_ipd(14)'last_event, tpd_B_P((863 - 19)- 48*0), true),
			79 => (B_ipd(15)'last_event, tpd_B_P((863 - 19)- 48*0), true),
			80 => (B_ipd(16)'last_event, tpd_B_P((863 - 19)- 48*0), true),
			81 => (B_ipd(17)'last_event, tpd_B_P((863 - 19)- 48*0), true),
			82 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 19)- 48*0), true),
			83 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 19)- 48*0), true),
			84 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 19)- 48*0), true),
			85 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 19)- 48*0), true),
			86 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 19)- 48*0), true),
			87 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 19)- 48*0), true),
			88 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 19)- 48*0), true),
			89 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 19)- 48*0), true),
			90 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 19)- 48*0), true),
			91 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 19)- 48*0), true),
			92 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 19)- 48*0), true),
			93 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 19)- 48*0), true),
			94 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 19)- 48*0), true),
			95 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 19)- 48*0), true),
			96 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 19)- 48*0), true),
			97 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 19)- 48*0), true),
			98 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 19)- 48*0), true),
			99 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 19)- 48*0), true),
			100 => (C_ipd(0)'last_event, tpd_C_P((2303 - 19)- 48*0), true),
			101 => (C_ipd(1)'last_event, tpd_C_P((2303 - 19)- 48*0), true),
			102 => (C_ipd(2)'last_event, tpd_C_P((2303 - 19)- 48*0), true),
			103 => (C_ipd(3)'last_event, tpd_C_P((2303 - 19)- 48*0), true),
			104 => (C_ipd(4)'last_event, tpd_C_P((2303 - 19)- 48*0), true),
			105 => (C_ipd(5)'last_event, tpd_C_P((2303 - 19)- 48*0), true),
			106 => (C_ipd(6)'last_event, tpd_C_P((2303 - 19)- 48*0), true),
			107 => (C_ipd(7)'last_event, tpd_C_P((2303 - 19)- 48*0), true),
			108 => (C_ipd(8)'last_event, tpd_C_P((2303 - 19)- 48*0), true),
			109 => (C_ipd(9)'last_event, tpd_C_P((2303 - 19)- 48*0), true),
			110 => (C_ipd(10)'last_event, tpd_C_P((2303 - 19)- 48*0), true),
			111 => (C_ipd(11)'last_event, tpd_C_P((2303 - 19)- 48*0), true),
			112 => (C_ipd(12)'last_event, tpd_C_P((2303 - 19)- 48*0), true),
			113 => (C_ipd(13)'last_event, tpd_C_P((2303 - 19)- 48*0), true),
			114 => (C_ipd(14)'last_event, tpd_C_P((2303 - 19)- 48*0), true),
			115 => (C_ipd(15)'last_event, tpd_C_P((2303 - 19)- 48*0), true),
			116 => (C_ipd(16)'last_event, tpd_C_P((2303 - 19)- 48*0), true),
			117 => (C_ipd(17)'last_event, tpd_C_P((2303 - 19)- 48*0), true),
			118 => (C_ipd(18)'last_event, tpd_C_P((2303 - 19)- 48*0), true),
			119 => (C_ipd(19)'last_event, tpd_C_P((2303 - 19)- 48*0), true),
			120 => (C_ipd(20)'last_event, tpd_C_P((2303 - 19)- 48*0), true),
			121 => (C_ipd(21)'last_event, tpd_C_P((2303 - 19)- 48*0), true),
			122 => (C_ipd(22)'last_event, tpd_C_P((2303 - 19)- 48*0), true),
			123 => (C_ipd(23)'last_event, tpd_C_P((2303 - 19)- 48*0), true),
			124 => (C_ipd(24)'last_event, tpd_C_P((2303 - 19)- 48*0), true),
			125 => (C_ipd(25)'last_event, tpd_C_P((2303 - 19)- 48*0), true),
			126 => (C_ipd(26)'last_event, tpd_C_P((2303 - 19)- 48*0), true),
			127 => (C_ipd(27)'last_event, tpd_C_P((2303 - 19)- 48*0), true),
			128 => (C_ipd(28)'last_event, tpd_C_P((2303 - 19)- 48*0), true),
			129 => (C_ipd(29)'last_event, tpd_C_P((2303 - 19)- 48*0), true),
			130 => (C_ipd(30)'last_event, tpd_C_P((2303 - 19)- 48*0), true),
			131 => (C_ipd(31)'last_event, tpd_C_P((2303 - 19)- 48*0), true),
			132 => (C_ipd(32)'last_event, tpd_C_P((2303 - 19)- 48*0), true),
			133 => (C_ipd(33)'last_event, tpd_C_P((2303 - 19)- 48*0), true),
			134 => (C_ipd(34)'last_event, tpd_C_P((2303 - 19)- 48*0), true),
			135 => (C_ipd(35)'last_event, tpd_C_P((2303 - 19)- 48*0), true),
			136 => (C_ipd(36)'last_event, tpd_C_P((2303 - 19)- 48*0), true),
			137 => (C_ipd(37)'last_event, tpd_C_P((2303 - 19)- 48*0), true),
			138 => (C_ipd(38)'last_event, tpd_C_P((2303 - 19)- 48*0), true),
			139 => (C_ipd(39)'last_event, tpd_C_P((2303 - 19)- 48*0), true),
			140 => (C_ipd(40)'last_event, tpd_C_P((2303 - 19)- 48*0), true),
			141 => (C_ipd(41)'last_event, tpd_C_P((2303 - 19)- 48*0), true),
			142 => (C_ipd(42)'last_event, tpd_C_P((2303 - 19)- 48*0), true),
			143 => (C_ipd(43)'last_event, tpd_C_P((2303 - 19)- 48*0), true),
			144 => (C_ipd(44)'last_event, tpd_C_P((2303 - 19)- 48*0), true),
			145 => (C_ipd(45)'last_event, tpd_C_P((2303 - 19)- 48*0), true),
			146 => (C_ipd(46)'last_event, tpd_C_P((2303 - 19)- 48*0), true),
			147 => (C_ipd(47)'last_event, tpd_C_P((2303 - 19)- 48*0), true),
			148 => (CARRYCASCIN_ipd'last_event, tpd_CARRYCASCIN_P(28), true),
			149 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(28), true),
			150 => (CARRYINSEL_ipd(0)'last_event, tpd_CARRYINSEL_P((143 - 19)- 48*0), true),
			151 => (CARRYINSEL_ipd(1)'last_event, tpd_CARRYINSEL_P((143 - 19)- 48*0), true),
			152 => (CARRYINSEL_ipd(2)'last_event, tpd_CARRYINSEL_P((143 - 19)- 48*0), true),
			153 => (MULTSIGNIN_ipd'last_event, tpd_MULTSIGNIN_P(28), true),
			154 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 19)- 48*0), true),
			155 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 19)- 48*0), true),
			156 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 19)- 48*0), true),
			157 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 19)- 48*0), true),
			158 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 19)- 48*0), true),
			159 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 19)- 48*0), true),
			160 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 19)- 48*0), true),
			161 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 19)- 48*0), true),
			162 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 19)- 48*0), true),
			163 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 19)- 48*0), true),
			164 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 19)- 48*0), true),
			165 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 19)- 48*0), true),
			166 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 19)- 48*0), true),
			167 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 19)- 48*0), true),
			168 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 19)- 48*0), true),
			169 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 19)- 48*0), true),
			170 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 19)- 48*0), true),
			171 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 19)- 48*0), true),
			172 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 19)- 48*0), true),
			173 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 19)- 48*0), true),
			174 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 19)- 48*0), true),
			175 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 19)- 48*0), true),
			176 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 19)- 48*0), true),
			177 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 19)- 48*0), true),
			178 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 19)- 48*0), true),
			179 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 19)- 48*0), true),
			180 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 19)- 48*0), true),
			181 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 19)- 48*0), true),
			182 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 19)- 48*0), true),
			183 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 19)- 48*0), true),
			184 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 19)- 48*0), true),
			185 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 19)- 48*0), true),
			186 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 19)- 48*0), true),
			187 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 19)- 48*0), true),
			188 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 19)- 48*0), true),
			189 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 19)- 48*0), true),
			190 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 19)- 48*0), true),
			191 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 19)- 48*0), true),
			192 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 19)- 48*0), true),
			193 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 19)- 48*0), true),
			194 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 19)- 48*0), true),
			195 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 19)- 48*0), true),
			196 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 19)- 48*0), true),
			197 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 19)- 48*0), true),
			198 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 19)- 48*0), true),
			199 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 19)- 48*0), true),
			200 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 19)- 48*0), true),
			201 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 19)- 48*0), true),
			202 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 19)- 48*0), true),
			203 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 19)- 48*0), true),
			204 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 19)- 48*0), true),
			205 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 19)- 48*0), true),
			206 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 19)- 48*0), true),
			207 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 19)- 48*0), true),
			208 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 19)- 48*0), true),
			209 => (CLK_dly'last_event, tpd_CLK_P(28), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(27),
         GlitchData	=> P_GlitchData(27),
         OutSignalName	=> "P(27)",
         OutTemp	=> P_zd(27),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((1439 - 20)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((1439 - 20)- 48*0), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((1439 - 20)- 48*0), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((1439 - 20)- 48*0), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((1439 - 20)- 48*0), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((1439 - 20)- 48*0), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((1439 - 20)- 48*0), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((1439 - 20)- 48*0), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((1439 - 20)- 48*0), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((1439 - 20)- 48*0), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((1439 - 20)- 48*0), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((1439 - 20)- 48*0), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((1439 - 20)- 48*0), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((1439 - 20)- 48*0), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((1439 - 20)- 48*0), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((1439 - 20)- 48*0), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((1439 - 20)- 48*0), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((1439 - 20)- 48*0), true),
			18 => (A_ipd(18)'last_event, tpd_A_P((1439 - 20)- 48*0), true),
			19 => (A_ipd(19)'last_event, tpd_A_P((1439 - 20)- 48*0), true),
			20 => (A_ipd(20)'last_event, tpd_A_P((1439 - 20)- 48*0), true),
			21 => (A_ipd(21)'last_event, tpd_A_P((1439 - 20)- 48*0), true),
			22 => (A_ipd(22)'last_event, tpd_A_P((1439 - 20)- 48*0), true),
			23 => (A_ipd(23)'last_event, tpd_A_P((1439 - 20)- 48*0), true),
			24 => (A_ipd(24)'last_event, tpd_A_P((1439 - 20)- 48*0), true),
			25 => (A_ipd(25)'last_event, tpd_A_P((1439 - 20)- 48*0), true),
			26 => (A_ipd(26)'last_event, tpd_A_P((1439 - 20)- 48*0), true),
			27 => (A_ipd(27)'last_event, tpd_A_P((1439 - 20)- 48*0), true),
			28 => (A_ipd(28)'last_event, tpd_A_P((1439 - 20)- 48*0), true),
			29 => (A_ipd(29)'last_event, tpd_A_P((1439 - 20)- 48*0), true),
			30 => (ACIN_ipd(0)'last_event, tpd_ACIN_P((1439 - 20)- 48*0), true),
			31 => (ACIN_ipd(1)'last_event, tpd_ACIN_P((1439 - 20)- 48*0), true),
			32 => (ACIN_ipd(2)'last_event, tpd_ACIN_P((1439 - 20)- 48*0), true),
			33 => (ACIN_ipd(3)'last_event, tpd_ACIN_P((1439 - 20)- 48*0), true),
			34 => (ACIN_ipd(4)'last_event, tpd_ACIN_P((1439 - 20)- 48*0), true),
			35 => (ACIN_ipd(5)'last_event, tpd_ACIN_P((1439 - 20)- 48*0), true),
			36 => (ACIN_ipd(6)'last_event, tpd_ACIN_P((1439 - 20)- 48*0), true),
			37 => (ACIN_ipd(7)'last_event, tpd_ACIN_P((1439 - 20)- 48*0), true),
			38 => (ACIN_ipd(8)'last_event, tpd_ACIN_P((1439 - 20)- 48*0), true),
			39 => (ACIN_ipd(9)'last_event, tpd_ACIN_P((1439 - 20)- 48*0), true),
			40 => (ACIN_ipd(10)'last_event, tpd_ACIN_P((1439 - 20)- 48*0), true),
			41 => (ACIN_ipd(11)'last_event, tpd_ACIN_P((1439 - 20)- 48*0), true),
			42 => (ACIN_ipd(12)'last_event, tpd_ACIN_P((1439 - 20)- 48*0), true),
			43 => (ACIN_ipd(13)'last_event, tpd_ACIN_P((1439 - 20)- 48*0), true),
			44 => (ACIN_ipd(14)'last_event, tpd_ACIN_P((1439 - 20)- 48*0), true),
			45 => (ACIN_ipd(15)'last_event, tpd_ACIN_P((1439 - 20)- 48*0), true),
			46 => (ACIN_ipd(16)'last_event, tpd_ACIN_P((1439 - 20)- 48*0), true),
			47 => (ACIN_ipd(17)'last_event, tpd_ACIN_P((1439 - 20)- 48*0), true),
			48 => (ACIN_ipd(18)'last_event, tpd_ACIN_P((1439 - 20)- 48*0), true),
			49 => (ACIN_ipd(19)'last_event, tpd_ACIN_P((1439 - 20)- 48*0), true),
			50 => (ACIN_ipd(20)'last_event, tpd_ACIN_P((1439 - 20)- 48*0), true),
			51 => (ACIN_ipd(21)'last_event, tpd_ACIN_P((1439 - 20)- 48*0), true),
			52 => (ACIN_ipd(22)'last_event, tpd_ACIN_P((1439 - 20)- 48*0), true),
			53 => (ACIN_ipd(23)'last_event, tpd_ACIN_P((1439 - 20)- 48*0), true),
			54 => (ACIN_ipd(24)'last_event, tpd_ACIN_P((1439 - 20)- 48*0), true),
			55 => (ACIN_ipd(25)'last_event, tpd_ACIN_P((1439 - 20)- 48*0), true),
			56 => (ACIN_ipd(26)'last_event, tpd_ACIN_P((1439 - 20)- 48*0), true),
			57 => (ACIN_ipd(27)'last_event, tpd_ACIN_P((1439 - 20)- 48*0), true),
			58 => (ACIN_ipd(28)'last_event, tpd_ACIN_P((1439 - 20)- 48*0), true),
			59 => (ACIN_ipd(29)'last_event, tpd_ACIN_P((1439 - 20)- 48*0), true),
			60 => (ALUMODE_ipd(0)'last_event, tpd_ALUMODE_P((191 - 20)- 48*0), true),
			61 => (ALUMODE_ipd(1)'last_event, tpd_ALUMODE_P((191 - 20)- 48*0), true),
			62 => (ALUMODE_ipd(2)'last_event, tpd_ALUMODE_P((191 - 20)- 48*0), true),
			63 => (ALUMODE_ipd(3)'last_event, tpd_ALUMODE_P((191 - 20)- 48*0), true),
			64 => (B_ipd(0)'last_event, tpd_B_P((863 - 20)- 48*0), true),
			65 => (B_ipd(1)'last_event, tpd_B_P((863 - 20)- 48*0), true),
			66 => (B_ipd(2)'last_event, tpd_B_P((863 - 20)- 48*0), true),
			67 => (B_ipd(3)'last_event, tpd_B_P((863 - 20)- 48*0), true),
			68 => (B_ipd(4)'last_event, tpd_B_P((863 - 20)- 48*0), true),
			69 => (B_ipd(5)'last_event, tpd_B_P((863 - 20)- 48*0), true),
			70 => (B_ipd(6)'last_event, tpd_B_P((863 - 20)- 48*0), true),
			71 => (B_ipd(7)'last_event, tpd_B_P((863 - 20)- 48*0), true),
			72 => (B_ipd(8)'last_event, tpd_B_P((863 - 20)- 48*0), true),
			73 => (B_ipd(9)'last_event, tpd_B_P((863 - 20)- 48*0), true),
			74 => (B_ipd(10)'last_event, tpd_B_P((863 - 20)- 48*0), true),
			75 => (B_ipd(11)'last_event, tpd_B_P((863 - 20)- 48*0), true),
			76 => (B_ipd(12)'last_event, tpd_B_P((863 - 20)- 48*0), true),
			77 => (B_ipd(13)'last_event, tpd_B_P((863 - 20)- 48*0), true),
			78 => (B_ipd(14)'last_event, tpd_B_P((863 - 20)- 48*0), true),
			79 => (B_ipd(15)'last_event, tpd_B_P((863 - 20)- 48*0), true),
			80 => (B_ipd(16)'last_event, tpd_B_P((863 - 20)- 48*0), true),
			81 => (B_ipd(17)'last_event, tpd_B_P((863 - 20)- 48*0), true),
			82 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 20)- 48*0), true),
			83 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 20)- 48*0), true),
			84 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 20)- 48*0), true),
			85 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 20)- 48*0), true),
			86 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 20)- 48*0), true),
			87 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 20)- 48*0), true),
			88 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 20)- 48*0), true),
			89 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 20)- 48*0), true),
			90 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 20)- 48*0), true),
			91 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 20)- 48*0), true),
			92 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 20)- 48*0), true),
			93 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 20)- 48*0), true),
			94 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 20)- 48*0), true),
			95 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 20)- 48*0), true),
			96 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 20)- 48*0), true),
			97 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 20)- 48*0), true),
			98 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 20)- 48*0), true),
			99 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 20)- 48*0), true),
			100 => (C_ipd(0)'last_event, tpd_C_P((2303 - 20)- 48*0), true),
			101 => (C_ipd(1)'last_event, tpd_C_P((2303 - 20)- 48*0), true),
			102 => (C_ipd(2)'last_event, tpd_C_P((2303 - 20)- 48*0), true),
			103 => (C_ipd(3)'last_event, tpd_C_P((2303 - 20)- 48*0), true),
			104 => (C_ipd(4)'last_event, tpd_C_P((2303 - 20)- 48*0), true),
			105 => (C_ipd(5)'last_event, tpd_C_P((2303 - 20)- 48*0), true),
			106 => (C_ipd(6)'last_event, tpd_C_P((2303 - 20)- 48*0), true),
			107 => (C_ipd(7)'last_event, tpd_C_P((2303 - 20)- 48*0), true),
			108 => (C_ipd(8)'last_event, tpd_C_P((2303 - 20)- 48*0), true),
			109 => (C_ipd(9)'last_event, tpd_C_P((2303 - 20)- 48*0), true),
			110 => (C_ipd(10)'last_event, tpd_C_P((2303 - 20)- 48*0), true),
			111 => (C_ipd(11)'last_event, tpd_C_P((2303 - 20)- 48*0), true),
			112 => (C_ipd(12)'last_event, tpd_C_P((2303 - 20)- 48*0), true),
			113 => (C_ipd(13)'last_event, tpd_C_P((2303 - 20)- 48*0), true),
			114 => (C_ipd(14)'last_event, tpd_C_P((2303 - 20)- 48*0), true),
			115 => (C_ipd(15)'last_event, tpd_C_P((2303 - 20)- 48*0), true),
			116 => (C_ipd(16)'last_event, tpd_C_P((2303 - 20)- 48*0), true),
			117 => (C_ipd(17)'last_event, tpd_C_P((2303 - 20)- 48*0), true),
			118 => (C_ipd(18)'last_event, tpd_C_P((2303 - 20)- 48*0), true),
			119 => (C_ipd(19)'last_event, tpd_C_P((2303 - 20)- 48*0), true),
			120 => (C_ipd(20)'last_event, tpd_C_P((2303 - 20)- 48*0), true),
			121 => (C_ipd(21)'last_event, tpd_C_P((2303 - 20)- 48*0), true),
			122 => (C_ipd(22)'last_event, tpd_C_P((2303 - 20)- 48*0), true),
			123 => (C_ipd(23)'last_event, tpd_C_P((2303 - 20)- 48*0), true),
			124 => (C_ipd(24)'last_event, tpd_C_P((2303 - 20)- 48*0), true),
			125 => (C_ipd(25)'last_event, tpd_C_P((2303 - 20)- 48*0), true),
			126 => (C_ipd(26)'last_event, tpd_C_P((2303 - 20)- 48*0), true),
			127 => (C_ipd(27)'last_event, tpd_C_P((2303 - 20)- 48*0), true),
			128 => (C_ipd(28)'last_event, tpd_C_P((2303 - 20)- 48*0), true),
			129 => (C_ipd(29)'last_event, tpd_C_P((2303 - 20)- 48*0), true),
			130 => (C_ipd(30)'last_event, tpd_C_P((2303 - 20)- 48*0), true),
			131 => (C_ipd(31)'last_event, tpd_C_P((2303 - 20)- 48*0), true),
			132 => (C_ipd(32)'last_event, tpd_C_P((2303 - 20)- 48*0), true),
			133 => (C_ipd(33)'last_event, tpd_C_P((2303 - 20)- 48*0), true),
			134 => (C_ipd(34)'last_event, tpd_C_P((2303 - 20)- 48*0), true),
			135 => (C_ipd(35)'last_event, tpd_C_P((2303 - 20)- 48*0), true),
			136 => (C_ipd(36)'last_event, tpd_C_P((2303 - 20)- 48*0), true),
			137 => (C_ipd(37)'last_event, tpd_C_P((2303 - 20)- 48*0), true),
			138 => (C_ipd(38)'last_event, tpd_C_P((2303 - 20)- 48*0), true),
			139 => (C_ipd(39)'last_event, tpd_C_P((2303 - 20)- 48*0), true),
			140 => (C_ipd(40)'last_event, tpd_C_P((2303 - 20)- 48*0), true),
			141 => (C_ipd(41)'last_event, tpd_C_P((2303 - 20)- 48*0), true),
			142 => (C_ipd(42)'last_event, tpd_C_P((2303 - 20)- 48*0), true),
			143 => (C_ipd(43)'last_event, tpd_C_P((2303 - 20)- 48*0), true),
			144 => (C_ipd(44)'last_event, tpd_C_P((2303 - 20)- 48*0), true),
			145 => (C_ipd(45)'last_event, tpd_C_P((2303 - 20)- 48*0), true),
			146 => (C_ipd(46)'last_event, tpd_C_P((2303 - 20)- 48*0), true),
			147 => (C_ipd(47)'last_event, tpd_C_P((2303 - 20)- 48*0), true),
			148 => (CARRYCASCIN_ipd'last_event, tpd_CARRYCASCIN_P(27), true),
			149 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(27), true),
			150 => (CARRYINSEL_ipd(0)'last_event, tpd_CARRYINSEL_P((143 - 20)- 48*0), true),
			151 => (CARRYINSEL_ipd(1)'last_event, tpd_CARRYINSEL_P((143 - 20)- 48*0), true),
			152 => (CARRYINSEL_ipd(2)'last_event, tpd_CARRYINSEL_P((143 - 20)- 48*0), true),
			153 => (MULTSIGNIN_ipd'last_event, tpd_MULTSIGNIN_P(27), true),
			154 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 20)- 48*0), true),
			155 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 20)- 48*0), true),
			156 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 20)- 48*0), true),
			157 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 20)- 48*0), true),
			158 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 20)- 48*0), true),
			159 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 20)- 48*0), true),
			160 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 20)- 48*0), true),
			161 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 20)- 48*0), true),
			162 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 20)- 48*0), true),
			163 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 20)- 48*0), true),
			164 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 20)- 48*0), true),
			165 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 20)- 48*0), true),
			166 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 20)- 48*0), true),
			167 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 20)- 48*0), true),
			168 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 20)- 48*0), true),
			169 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 20)- 48*0), true),
			170 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 20)- 48*0), true),
			171 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 20)- 48*0), true),
			172 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 20)- 48*0), true),
			173 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 20)- 48*0), true),
			174 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 20)- 48*0), true),
			175 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 20)- 48*0), true),
			176 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 20)- 48*0), true),
			177 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 20)- 48*0), true),
			178 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 20)- 48*0), true),
			179 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 20)- 48*0), true),
			180 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 20)- 48*0), true),
			181 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 20)- 48*0), true),
			182 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 20)- 48*0), true),
			183 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 20)- 48*0), true),
			184 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 20)- 48*0), true),
			185 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 20)- 48*0), true),
			186 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 20)- 48*0), true),
			187 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 20)- 48*0), true),
			188 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 20)- 48*0), true),
			189 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 20)- 48*0), true),
			190 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 20)- 48*0), true),
			191 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 20)- 48*0), true),
			192 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 20)- 48*0), true),
			193 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 20)- 48*0), true),
			194 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 20)- 48*0), true),
			195 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 20)- 48*0), true),
			196 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 20)- 48*0), true),
			197 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 20)- 48*0), true),
			198 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 20)- 48*0), true),
			199 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 20)- 48*0), true),
			200 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 20)- 48*0), true),
			201 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 20)- 48*0), true),
			202 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 20)- 48*0), true),
			203 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 20)- 48*0), true),
			204 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 20)- 48*0), true),
			205 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 20)- 48*0), true),
			206 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 20)- 48*0), true),
			207 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 20)- 48*0), true),
			208 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 20)- 48*0), true),
			209 => (CLK_dly'last_event, tpd_CLK_P(27), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(26),
         GlitchData	=> P_GlitchData(26),
         OutSignalName	=> "P(26)",
         OutTemp	=> P_zd(26),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((1439 - 21)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((1439 - 21)- 48*0), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((1439 - 21)- 48*0), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((1439 - 21)- 48*0), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((1439 - 21)- 48*0), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((1439 - 21)- 48*0), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((1439 - 21)- 48*0), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((1439 - 21)- 48*0), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((1439 - 21)- 48*0), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((1439 - 21)- 48*0), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((1439 - 21)- 48*0), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((1439 - 21)- 48*0), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((1439 - 21)- 48*0), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((1439 - 21)- 48*0), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((1439 - 21)- 48*0), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((1439 - 21)- 48*0), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((1439 - 21)- 48*0), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((1439 - 21)- 48*0), true),
			18 => (A_ipd(18)'last_event, tpd_A_P((1439 - 21)- 48*0), true),
			19 => (A_ipd(19)'last_event, tpd_A_P((1439 - 21)- 48*0), true),
			20 => (A_ipd(20)'last_event, tpd_A_P((1439 - 21)- 48*0), true),
			21 => (A_ipd(21)'last_event, tpd_A_P((1439 - 21)- 48*0), true),
			22 => (A_ipd(22)'last_event, tpd_A_P((1439 - 21)- 48*0), true),
			23 => (A_ipd(23)'last_event, tpd_A_P((1439 - 21)- 48*0), true),
			24 => (A_ipd(24)'last_event, tpd_A_P((1439 - 21)- 48*0), true),
			25 => (A_ipd(25)'last_event, tpd_A_P((1439 - 21)- 48*0), true),
			26 => (A_ipd(26)'last_event, tpd_A_P((1439 - 21)- 48*0), true),
			27 => (A_ipd(27)'last_event, tpd_A_P((1439 - 21)- 48*0), true),
			28 => (A_ipd(28)'last_event, tpd_A_P((1439 - 21)- 48*0), true),
			29 => (A_ipd(29)'last_event, tpd_A_P((1439 - 21)- 48*0), true),
			30 => (ACIN_ipd(0)'last_event, tpd_ACIN_P((1439 - 21)- 48*0), true),
			31 => (ACIN_ipd(1)'last_event, tpd_ACIN_P((1439 - 21)- 48*0), true),
			32 => (ACIN_ipd(2)'last_event, tpd_ACIN_P((1439 - 21)- 48*0), true),
			33 => (ACIN_ipd(3)'last_event, tpd_ACIN_P((1439 - 21)- 48*0), true),
			34 => (ACIN_ipd(4)'last_event, tpd_ACIN_P((1439 - 21)- 48*0), true),
			35 => (ACIN_ipd(5)'last_event, tpd_ACIN_P((1439 - 21)- 48*0), true),
			36 => (ACIN_ipd(6)'last_event, tpd_ACIN_P((1439 - 21)- 48*0), true),
			37 => (ACIN_ipd(7)'last_event, tpd_ACIN_P((1439 - 21)- 48*0), true),
			38 => (ACIN_ipd(8)'last_event, tpd_ACIN_P((1439 - 21)- 48*0), true),
			39 => (ACIN_ipd(9)'last_event, tpd_ACIN_P((1439 - 21)- 48*0), true),
			40 => (ACIN_ipd(10)'last_event, tpd_ACIN_P((1439 - 21)- 48*0), true),
			41 => (ACIN_ipd(11)'last_event, tpd_ACIN_P((1439 - 21)- 48*0), true),
			42 => (ACIN_ipd(12)'last_event, tpd_ACIN_P((1439 - 21)- 48*0), true),
			43 => (ACIN_ipd(13)'last_event, tpd_ACIN_P((1439 - 21)- 48*0), true),
			44 => (ACIN_ipd(14)'last_event, tpd_ACIN_P((1439 - 21)- 48*0), true),
			45 => (ACIN_ipd(15)'last_event, tpd_ACIN_P((1439 - 21)- 48*0), true),
			46 => (ACIN_ipd(16)'last_event, tpd_ACIN_P((1439 - 21)- 48*0), true),
			47 => (ACIN_ipd(17)'last_event, tpd_ACIN_P((1439 - 21)- 48*0), true),
			48 => (ACIN_ipd(18)'last_event, tpd_ACIN_P((1439 - 21)- 48*0), true),
			49 => (ACIN_ipd(19)'last_event, tpd_ACIN_P((1439 - 21)- 48*0), true),
			50 => (ACIN_ipd(20)'last_event, tpd_ACIN_P((1439 - 21)- 48*0), true),
			51 => (ACIN_ipd(21)'last_event, tpd_ACIN_P((1439 - 21)- 48*0), true),
			52 => (ACIN_ipd(22)'last_event, tpd_ACIN_P((1439 - 21)- 48*0), true),
			53 => (ACIN_ipd(23)'last_event, tpd_ACIN_P((1439 - 21)- 48*0), true),
			54 => (ACIN_ipd(24)'last_event, tpd_ACIN_P((1439 - 21)- 48*0), true),
			55 => (ACIN_ipd(25)'last_event, tpd_ACIN_P((1439 - 21)- 48*0), true),
			56 => (ACIN_ipd(26)'last_event, tpd_ACIN_P((1439 - 21)- 48*0), true),
			57 => (ACIN_ipd(27)'last_event, tpd_